/*
 * Decompiled with CFR 0.152.
 */
package cn.sendsms.test;

import cn.sendsms.AGateway;
import cn.sendsms.GatewayException;
import cn.sendsms.InboundMessage;
import cn.sendsms.Message;
import cn.sendsms.OutboundMessage;
import cn.sendsms.Service;
import cn.sendsms.TimeoutException;
import cn.sendsms.helper.Logger;
import cn.sendsms.notify.InboundMessageNotification;
import java.io.IOException;
import java.util.Collection;
import java.util.Date;

public class TestGateway
extends AGateway {
    private int b = 0;
    private int c = 0;
    protected int failCycle;
    protected int receiveCycle;
    Thread a;

    public TestGateway(String id) {
        super(id);
        this.setAttributes(1);
        this.setInbound(true);
        this.setOutbound(true);
        this.setFailCycle(3000);
        this.receiveCycle = 60000;
    }

    @Override
    public boolean deleteMessage(InboundMessage msg) throws TimeoutException, GatewayException, IOException, InterruptedException {
        return true;
    }

    InboundMessage a() {
        this.incInboundMessageCount();
        InboundMessage msg = new InboundMessage(new Date(), "+1234567890", "Hello World! #" + this.getInboundMessageCount(), 0, null);
        msg.setGatewayId(this.getGatewayId());
        return msg;
    }

    @Override
    public void startGateway() throws TimeoutException, GatewayException, IOException, InterruptedException {
        super.startGateway();
        this.a = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (!TestGateway.this.a.isInterrupted()) {
                    Thread thread = TestGateway.this.a;
                    synchronized (thread) {
                        try {
                            TestGateway.this.a.wait(TestGateway.this.receiveCycle);
                        }
                        catch (InterruptedException e2) {
                            break;
                        }
                    }
                    if (TestGateway.this.a.isInterrupted()) continue;
                    Logger.getInstance().logInfo("Detecting incoming message", null, TestGateway.this.getGatewayId());
                    Service.getInstance().getNotifyQueueManager().getNotifyQueue().add(new InboundMessageNotification(TestGateway.this.getMyself(), Message.MessageTypes.INBOUND, TestGateway.this.a()));
                }
            }
        }, "IncomingMessagesThread");
        this.a.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopGateway() throws TimeoutException, GatewayException, IOException, InterruptedException {
        super.stopGateway();
        if (this.a != null) {
            Thread thread = this.a;
            synchronized (thread) {
                this.a.interrupt();
            }
        }
    }

    @Override
    public InboundMessage readMessage(String memLoc, int memIndex) throws TimeoutException, GatewayException, IOException, InterruptedException {
        ++this.c;
        if (this.failCycle > 0 && this.c >= this.failCycle) {
            this.c = 0;
            throw new GatewayException("*** READ ERROR ***");
        }
        return this.a();
    }

    @Override
    public void readMessages(Collection<InboundMessage> msgList, InboundMessage.MessageClasses msgClass) throws TimeoutException, GatewayException, IOException, InterruptedException {
        msgList.add(this.a());
    }

    @Override
    public boolean sendMessage(OutboundMessage msg) throws TimeoutException, GatewayException, IOException, InterruptedException {
        Logger.getInstance().logInfo("Sending to: " + msg.getRecipient() + " via: " + msg.getGatewayId(), null, this.getGatewayId());
        ++this.c;
        if (this.failCycle > 0 && this.c >= this.failCycle) {
            this.c = 0;
            if (!this.getGatewayId().equalsIgnoreCase("Test3")) {
                throw new IOException("Dummy Exception!!!");
            }
        }
        msg.setDispatchDate(new Date());
        msg.setMessageStatus(OutboundMessage.MessageStatuses.SENT);
        msg.setRefNo(Integer.toString(++this.b));
        msg.setGatewayId(this.getGatewayId());
        Logger.getInstance().logInfo("Sent to: " + msg.getRecipient() + " via: " + msg.getGatewayId(), null, this.getGatewayId());
        this.incOutboundMessageCount();
        return true;
    }

    public int getFailCycle() {
        return this.failCycle;
    }

    public void setFailCycle(int myFailCycle) {
        this.failCycle = myFailCycle;
    }

    @Override
    public int getQueueSchedulingInterval() {
        return 200;
    }
}

