/*
 * Decompiled with CFR 0.152.
 */
package cn.sendsms;

import cn.sendsms.GatewayDisableException;
import cn.sendsms.GatewayException;
import cn.sendsms.InboundMessage;
import cn.sendsms.OutboundMessage;
import cn.sendsms.Phonebook;
import cn.sendsms.Service;
import cn.sendsms.StatusReportMessage;
import cn.sendsms.TimeoutException;
import cn.sendsms.USSDRequest;
import cn.sendsms.helper.AGatewayHelper;
import cn.sendsms.helper.Logger;
import cn.sendsms.notify.GatewayStatusNotification;
import cn.sendsms.notify.OutboundMessageNotification;
import cn.sendsms.threading.AServiceThread;
import cn.sendsms.tools.IntStater;
import cn.sendsms.tools.JDApp;
import cn.sendsms.tools.TimeChecker;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;

public abstract class AGateway {
    private String a;
    private int b;
    private boolean c;
    private boolean d;
    private AGatewayHelper.Protocols e;
    private b f;
    private String g;
    private int h;
    protected AGatewayHelper.GatewayStatuses status;
    protected int restartCount;
    private a i;
    private IntStater j;

    public AGateway(String id) {
        this.a = id;
        this.c = false;
        this.d = false;
        this.b = 0;
        this.e = AGatewayHelper.Protocols.PDU;
        this.g = "";
        this.f = new b();
        this.g = "";
        this.h = -1;
        this.status = AGatewayHelper.GatewayStatuses.STOPPED;
        this.restartCount = 0;
        this.j = new IntStater(0);
    }

    public IntStater stater() {
        return this.j;
    }

    public void setAttributes(int myAttributes) {
        this.b = myAttributes;
    }

    public int getAttributes() {
        return this.b;
    }

    public AGateway getMyself() {
        return this;
    }

    public boolean isInbound() {
        return this.c;
    }

    public void setInbound(boolean value) {
        if ((this.b & 2) != 0) {
            this.c = value;
        }
    }

    public boolean isOutbound() {
        return this.d;
    }

    public void setOutbound(boolean value) {
        if ((this.b & 1) != 0) {
            this.d = value;
        }
    }

    public void setProtocol(AGatewayHelper.Protocols myProtocoll) {
        this.e = myProtocoll;
    }

    public AGatewayHelper.Protocols getProtocol() {
        return this.e;
    }

    public String getGatewayId() {
        return this.a;
    }

    public AGatewayHelper.GatewayStatuses getStatus() {
        return this.status;
    }

    public void setStatus(AGatewayHelper.GatewayStatuses myStatus) {
        AGatewayHelper.GatewayStatuses curStatus;
        if (myStatus == AGatewayHelper.GatewayStatuses.RESTART && ((curStatus = this.getStatus()) == AGatewayHelper.GatewayStatuses.FAILURE || curStatus == AGatewayHelper.GatewayStatuses.OCCUPY || curStatus == AGatewayHelper.GatewayStatuses.NOPORT || curStatus == AGatewayHelper.GatewayStatuses.STOPPED || curStatus == AGatewayHelper.GatewayStatuses.STOPPING)) {
            return;
        }
        Service.getInstance().getNotifyQueueManager().getNotifyQueue().add(new GatewayStatusNotification(this.getMyself(), this.getStatus(), myStatus));
        if (myStatus == AGatewayHelper.GatewayStatuses.FAILURE || myStatus == AGatewayHelper.GatewayStatuses.OCCUPY || myStatus == AGatewayHelper.GatewayStatuses.NOPORT || myStatus == AGatewayHelper.GatewayStatuses.STOPPED || myStatus == AGatewayHelper.GatewayStatuses.STOPPING) {
            this.stater().setVal(99902);
        } else {
            this.stater().setVal(0);
        }
        this.status = myStatus;
    }

    public int getInboundMessageCount() {
        return this.f.a;
    }

    public void incInboundMessageCount() {
        ++this.f.a;
    }

    public int getOutboundMessageCount() {
        return this.f.b;
    }

    public void incOutboundMessageCount() {
        ++this.f.b;
    }

    public String getFrom() {
        return this.g;
    }

    public void setFrom(String myFrom) {
        this.g = myFrom;
    }

    public void startGateway() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.setStatus(AGatewayHelper.GatewayStatuses.STARTING);
        this.i = new a("QueueManager [" + this.a + "]", this.getQueueSchedulingInterval());
        ++this.restartCount;
        this.setStatus(AGatewayHelper.GatewayStatuses.STARTED);
    }

    public void stopGateway() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.setStatus(AGatewayHelper.GatewayStatuses.STOPPING);
        if (this.i != null) {
            this.i.cancel();
            this.i = null;
        }
        this.setStatus(AGatewayHelper.GatewayStatuses.STOPPED);
    }

    public void readMessages(Collection<InboundMessage> msgList, InboundMessage.MessageClasses msgClass) throws TimeoutException, GatewayException, IOException, InterruptedException {
        throw new GatewayException("Feature not supported.");
    }

    public InboundMessage readMessage(String memLoc, int memIndex) throws TimeoutException, GatewayException, IOException, InterruptedException {
        throw new GatewayException("Feature not supported.");
    }

    public boolean sendMessage(OutboundMessage msg) throws TimeoutException, GatewayException, IOException, InterruptedException, ClassNotFoundException, NoSuchMethodException, SecurityException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, SQLException {
        throw new GatewayException("Feature not supported.");
    }

    public int sendMessages(Collection<OutboundMessage> msgList) throws Exception {
        int cnt = 0;
        Iterator<OutboundMessage> iterator = msgList.iterator();
        while (iterator.hasNext()) {
            if (!this.sendMessage(iterator.next())) continue;
            ++cnt;
        }
        iterator = null;
        return cnt;
    }

    public boolean deleteMessage(InboundMessage msg) throws TimeoutException, GatewayException, IOException, InterruptedException {
        throw new GatewayException("Feature not supported.");
    }

    public float queryBalance() throws TimeoutException, GatewayException, IOException, InterruptedException {
        throw new GatewayException("Feature not supported.");
    }

    public boolean queryCoverage(OutboundMessage msg) throws TimeoutException, GatewayException, IOException, InterruptedException {
        throw new GatewayException("Feature not supported.");
    }

    public StatusReportMessage.DeliveryStatuses queryMessage(OutboundMessage msg) throws TimeoutException, GatewayException, IOException, InterruptedException {
        return this.queryMessage(msg.getRefNo());
    }

    public StatusReportMessage.DeliveryStatuses queryMessage(String refNo) throws TimeoutException, GatewayException, IOException, InterruptedException {
        throw new GatewayException("Feature not supported.");
    }

    public int readPhonebook(Phonebook phonebook) throws TimeoutException, GatewayException, IOException, InterruptedException {
        throw new GatewayException("Feature not supported.");
    }

    public int getDeliveryErrorCode() {
        return this.h;
    }

    public void setDeliveryErrorCode(int error) {
        this.h = error;
    }

    boolean a(int att) {
        return (att & this.b) == att;
    }

    boolean a(int attrib, boolean required) {
        return !required || this.a(attrib);
    }

    public int getRestartCount() {
        return this.restartCount;
    }

    public abstract int getQueueSchedulingInterval();

    public String sendUSSDCommand(String ussdCommand) throws GatewayException, TimeoutException, IOException, InterruptedException {
        throw new GatewayException("Feature not supported");
    }

    public String sendUSSDCommand(String ussdCommand, boolean interactive) throws GatewayException, TimeoutException, IOException, InterruptedException {
        throw new GatewayException("Feature not supported");
    }

    public boolean sendUSSDRequest(USSDRequest request) throws GatewayException, TimeoutException, IOException, InterruptedException {
        throw new GatewayException("Feature not supported");
    }

    public void setGatewayId(String gatewayId) {
        this.a = gatewayId;
    }

    public boolean threadWait(long nTimeOut) {
        return TimeChecker.ThreadWait2(nTimeOut, this.stater(), JDApp.app().stater());
    }

    private class a
    extends AServiceThread {
        public a(String name, int delay) {
            super(name, 1000, 0, true);
        }

        @Override
        public void process() throws Exception {
            block13: {
                Logger.getInstance().logDebug("in class QueueManager process() 000", null, AGateway.this.getGatewayId());
                OutboundMessage msg = null;
                try {
                    if (AGateway.this.getStatus() != AGatewayHelper.GatewayStatuses.STARTED) break block13;
                    Logger.getInstance().logDebug("in class QueueManager process() 001", null, AGateway.this.getGatewayId());
                    if (Service.getInstance().getQueueManager() == null) {
                        Logger.getInstance().logError("queueManager is null", null, AGateway.this.getGatewayId());
                        return;
                    }
                    msg = Service.getInstance().getQueueManager().pollPendingMessage(AGateway.this.getGatewayId());
                    if (msg == null) break block13;
                    Logger.getInstance().logDebug("in class QueueManager process() 002", null, AGateway.this.getGatewayId());
                    if (Service.getInstance().getQueueSendingNotification() != null) {
                        Service.getInstance().getQueueSendingNotification().process(AGateway.this.getMyself(), msg);
                    }
                    try {
                        Logger.getInstance().logDebug("in class QueueManager process() 003", null, AGateway.this.getGatewayId());
                        if (!AGateway.this.sendMessage(msg)) {
                            if (msg.getRetryCount() < Service.getInstance().getSettings().QUEUE_RETRIES) {
                                Logger.getInstance().logInfo("Reinserting message to queue.", null, AGateway.this.getGatewayId());
                                msg.a();
                                Service.getInstance().getQueueManager().queueMessage(msg);
                            } else {
                                Logger.getInstance().logWarn("Maximum number of queue retries exceeded, message lost.", null, AGateway.this.getGatewayId());
                                msg.setFailureCause(OutboundMessage.FailureCauses.UNKNOWN);
                                Service.getInstance().getNotifyQueueManager().getNotifyQueue().add(new OutboundMessageNotification(AGateway.this.getMyself(), msg));
                            }
                        } else {
                            Service.getInstance().getNotifyQueueManager().getNotifyQueue().add(new OutboundMessageNotification(AGateway.this.getMyself(), msg));
                        }
                    }
                    catch (TimeoutException e2) {
                        Service.getInstance().getQueueManager().queueMessage(msg);
                        throw e2;
                    }
                }
                catch (InterruptedException e3) {
                    if (msg != null && msg.getMessageStatus() != OutboundMessage.MessageStatuses.SENT) {
                        Service.getInstance().getQueueManager().queueMessage(msg);
                    }
                    Logger.getInstance().logInfo("QueueManager interrupted.", e3, AGateway.this.getGatewayId());
                }
                catch (GatewayDisableException e4) {
                    Logger.getInstance().logError("\u7aef\u53e3\u975e\u6b63\u5e38\u72b6\u6001\u7981\u6b62\u8fdb\u884cat\u64cd\u4f5c", e4, AGateway.this.a);
                }
                catch (Exception e5) {
                    Logger.getInstance().logWarn("Queue exception, marking gateway for reset.", e5, AGateway.this.getGatewayId());
                    AGateway.this.setStatus(AGatewayHelper.GatewayStatuses.RESTART);
                    Service.getInstance().getNotifyQueueManager().getNotifyQueue().add(new OutboundMessageNotification(AGateway.this.getMyself(), msg));
                }
            }
        }
    }

    static class b {
        public int a = 0;
        public int b = 0;
    }

    public static class GatewayAttributes {
        public static final int SEND = 1;
        public static final int RECEIVE = 2;
        public static final int CUSTOMFROM = 4;
        public static final int BIGMESSAGES = 8;
        public static final int WAPSI = 16;
        public static final int PORTADDRESSING = 32;
        public static final int FLASHSMS = 64;
        public static final int DELIVERYREPORTS = 128;
    }

    public static enum AsyncEvents {
        DELETE,
        NOTHING,
        INBOUNDMESSAGE,
        INBOUNDSTATUSREPORTMESSAGE,
        INBOUNDCALL,
        USSDRESPONSE;

    }
}

