/*
 * Decompiled with CFR 0.152.
 */
package cn.sendsms.addressbook;

import cn.sendsms.addressbook.AddrPageCacheItem;
import cn.sendsms.addressbook.Address;
import cn.sendsms.addressbook.AddressFolder;
import cn.sendsms.addressbook.AddressFolderComparator;
import cn.sendsms.addressbook.AddressNameComparator;
import cn.sendsms.addressbook.FormatPair;
import cn.sendsms.cache.CachePool;
import cn.sendsms.io.ReadLineInput;
import cn.sendsms.jdsmsserver.JDSMSServer;
import cn.sendsms.util.ByteBuffer;
import cn.sendsms.util.ConfParam;
import cn.sendsms.util.LongObj;
import cn.sendsms.util.Param;
import cn.sendsms.util.StringUtil;
import cn.sendsms.util.SysConts;
import cn.sendsms.util.Util;
import java.io.File;
import java.io.FileInputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class AddressList
extends AddressFolder {
    public String m_File = "";
    public String m_FilePath = "";
    public String m_ShortFileName = "";
    public String m_domain = null;
    public String m_username = null;
    private Hashtable a;
    private boolean b = false;
    public ArrayList addrlist = new ArrayList();
    public ArrayList folderlist = new ArrayList();
    public ArrayList rallist = new ArrayList();

    public void putCachePage(String key, AddrPageCacheItem item) {
        this.a.put(key, item);
    }

    public AddrPageCacheItem getCachePage(String key) {
        AddrPageCacheItem strContent = (AddrPageCacheItem)this.a.get(key);
        return strContent;
    }

    public void cleanCachePage() {
        this.a.clear();
    }

    public AddressList() {
        this.a = new Hashtable();
    }

    public static void main(String[] argc) {
        try {
            AddressList addrlist = new AddressList();
            addrlist.init(null, null, "public");
            for (int i2 = 0; i2 < 1000; ++i2) {
                Address addr = new Address();
                addr.m_id = AddressList.createId();
                addr.Name = "a1";
                addr.username = "a1";
                addr.EmailAddress = "a1@a.com";
                addr.Organization = "";
                addr.Department = "";
                addr.Address = "";
                addr.Postalcode = "";
                addr.Telephone = "";
                addr.Employment = "";
                addr.Orderrule = "";
                addrlist.addAddress_id(addr, "/");
            }
            addrlist.save();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private static void inputFromFile(String domain) {
        try {
            String[] tokenstrTemp;
            FileInputStream in = new FileInputStream("e:\\temp\\henan.txt");
            AddressList addrlist = new AddressList();
            addrlist.init(null, null, "public");
            addrlist.m_File = "e:\\temp\\address.xml";
            byte[] bs = null;
            String strLine = null;
            while ((bs = Util.readLine(in)) != null && (tokenstrTemp = (strLine = new String(bs, "GBK")).split("\\s\\s\\s\\s\\s\\s(\\s)+")) != null) {
                if (tokenstrTemp.length < 2) continue;
                if (tokenstrTemp.length < 3) {
                    Address addr = new Address();
                    addr.m_id = AddressList.createId();
                    addr.Name = tokenstrTemp[0];
                    addr.username = tokenstrTemp[1];
                    addr.EmailAddress = tokenstrTemp[1] + "@" + domain;
                    addr.Organization = "";
                    addr.Department = "";
                    addr.Address = "";
                    addr.Postalcode = "";
                    addr.Telephone = "";
                    addr.Employment = "";
                    addr.Orderrule = "";
                    addrlist.addAddress_id(addr, "/");
                    continue;
                }
                String pathName = "/" + tokenstrTemp[2];
                AddressFolder tempFolder = addrlist.findAddressFolder(pathName);
                if (tempFolder == null) {
                    addrlist.addAddressFolder("/", tokenstrTemp[2]);
                    tempFolder = addrlist.findAddressFolder(pathName);
                }
                String folderid = tempFolder.getFullId();
                Address addr = new Address();
                addr.m_id = AddressList.createId();
                addr.Name = tokenstrTemp[0];
                addr.username = tokenstrTemp[1];
                addr.EmailAddress = tokenstrTemp[1] + "@" + domain;
                addr.Organization = "";
                addr.Department = "";
                addr.Address = "";
                addr.Postalcode = "";
                addr.Telephone = "";
                addr.Employment = "";
                addr.Orderrule = "";
                addrlist.addAddress_id(addr, folderid);
            }
            addrlist.save();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public void init(String domain, String username, String foldertype) {
        String strListFile = "";
        strListFile = JDSMSServer.getInstance().getAddressBookPath() + SysConts.FILE_SEPARATOR;
        this.m_foldertype = foldertype;
        if (username != null) {
            strListFile = strListFile + username;
            strListFile = strListFile + SysConts.FILE_SEPARATOR;
        }
        this.m_FilePath = strListFile.substring(0, strListFile.length() - 1);
        this.m_ShortFileName = "address.xml";
        strListFile = strListFile + "address.xml";
        this.initfromfile(domain, username, strListFile, foldertype);
    }

    private String a(ArrayList alMap, String outputname) {
        FormatPair fp = null;
        for (int i2 = 0; i2 < alMap.size(); ++i2) {
            fp = (FormatPair)alMap.get(i2);
            if (!fp.m_OutputName.equals(outputname)) continue;
            return fp.m_FieldName;
        }
        return null;
    }

    public void initfromNormalfile(String domain, String username, String strListFile, ArrayList alField, int iIgnoreLines, String incharset) {
        if (alField == null) {
            return;
        }
        try {
            RandomAccessFile raf = new RandomAccessFile(strListFile, "r");
            LongObj lo = new LongObj();
            byte[] bs = null;
            int iNum = 1;
            ArrayList alTitle = new ArrayList();
            ArrayList<String> alRecord = new ArrayList<String>();
            String str1 = null;
            String strFieldname = null;
            ByteBuffer bb = new ByteBuffer();
            byte[] temp_bs = new byte[1024];
            while ((bs = ReadLineInput.ReadLine(raf, false, lo, bb, temp_bs)) != null) {
                if (iNum <= iIgnoreLines) {
                    ++iNum;
                    continue;
                }
                String strTemp = new String(bs, incharset);
                String[] titles = strTemp.split("[,;]");
                alRecord.clear();
                for (int i2 = 0; i2 < titles.length; ++i2) {
                    str1 = titles[i2];
                    str1 = StringUtil.supertrim(str1, "\"");
                    alRecord.add(str1);
                }
                Address addr = new Address();
                for (int i3 = 0; i3 < alField.size() && i3 < alRecord.size(); ++i3) {
                    strFieldname = (String)alField.get(i3);
                    if (strFieldname == null) continue;
                    if (strFieldname.equals("name")) {
                        addr.Name = (String)alRecord.get(i3);
                        continue;
                    }
                    if (strFieldname.equals("email")) {
                        addr.EmailAddress = (String)alRecord.get(i3);
                        continue;
                    }
                    if (strFieldname.equals("telephone")) {
                        addr.Telephone = (String)alRecord.get(i3);
                        continue;
                    }
                    if (strFieldname.equals("postalcode")) {
                        addr.Postalcode = (String)alRecord.get(i3);
                        continue;
                    }
                    if (strFieldname.equals("address")) {
                        addr.Address = (String)alRecord.get(i3);
                        continue;
                    }
                    if (strFieldname.equals("employment")) {
                        addr.Employment = (String)alRecord.get(i3);
                        continue;
                    }
                    if (strFieldname.equals("organization")) {
                        addr.Organization = (String)alRecord.get(i3);
                        continue;
                    }
                    if (strFieldname.equals("department")) {
                        addr.Department = (String)alRecord.get(i3);
                        continue;
                    }
                    if (!strFieldname.equals("orderrule")) continue;
                    addr.Orderrule = (String)alRecord.get(i3);
                }
                this.alAddress.add(addr);
            }
            raf.close();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public void initfromOutlookfile(String domain, String username, String strListFile, String strMap, String incharset) {
        ArrayList alMap = AddressList.parseMap(strMap);
        if (alMap == null) {
            return;
        }
        try {
            RandomAccessFile raf = new RandomAccessFile(strListFile, "r");
            LongObj lo = new LongObj();
            byte[] bs = null;
            int iNum = 1;
            ArrayList<String> alTitle = new ArrayList<String>();
            ArrayList<String> alRecord = new ArrayList<String>();
            String str1 = null;
            String strFieldname = null;
            ByteBuffer bb = new ByteBuffer();
            byte[] temp_bs = new byte[1024];
            while ((bs = ReadLineInput.ReadLine(raf, false, lo, bb, temp_bs)) != null) {
                int i2;
                String strTemp = new String(bs, incharset);
                String[] titles = strTemp.split("[,;]");
                if (iNum == 1) {
                    for (i2 = 0; i2 < titles.length; ++i2) {
                        str1 = titles[i2];
                        str1 = StringUtil.supertrim(str1, "\"");
                        alTitle.add(str1);
                    }
                    ++iNum;
                    continue;
                }
                alRecord.clear();
                for (i2 = 0; i2 < titles.length; ++i2) {
                    str1 = titles[i2];
                    str1 = StringUtil.supertrim(str1, "\"");
                    alRecord.add(str1);
                }
                Address addr = new Address();
                for (int i3 = 0; i3 < alTitle.size() && i3 < alRecord.size(); ++i3) {
                    str1 = (String)alTitle.get(i3);
                    strFieldname = this.a(alMap, str1);
                    if (strFieldname == null) continue;
                    if (strFieldname.equals("name")) {
                        addr.Name = (String)alRecord.get(i3);
                        continue;
                    }
                    if (strFieldname.equals("email")) {
                        addr.EmailAddress = (String)alRecord.get(i3);
                        continue;
                    }
                    if (strFieldname.equals("telephone")) {
                        addr.Telephone = (String)alRecord.get(i3);
                        continue;
                    }
                    if (strFieldname.equals("postalcode")) {
                        addr.Postalcode = (String)alRecord.get(i3);
                        continue;
                    }
                    if (strFieldname.equals("address")) {
                        addr.Address = (String)alRecord.get(i3);
                        continue;
                    }
                    if (strFieldname.equals("employment")) {
                        addr.Employment = (String)alRecord.get(i3);
                        continue;
                    }
                    if (strFieldname.equals("organization")) {
                        addr.Organization = (String)alRecord.get(i3);
                        continue;
                    }
                    if (strFieldname.equals("department")) {
                        addr.Department = (String)alRecord.get(i3);
                        continue;
                    }
                    if (!strFieldname.equals("orderrule")) continue;
                    addr.Orderrule = (String)alRecord.get(i3);
                }
                addr.m_foldertype = this.m_foldertype;
                this.alAddress.add(addr);
            }
            raf.close();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public void initfromRTXFile(String domain, String username, String strListFile, String incharset) throws Exception {
        SAXReader reader = new SAXReader();
        File file = new File(strListFile);
        Document doc = reader.read(file);
        Element root = doc.getRootElement();
        this.a(root, "");
        for (int i2 = 0; i2 < this.folderlist.size(); ++i2) {
            AddressFolder af = (AddressFolder)this.folderlist.get(i2);
            for (int j2 = 0; j2 < this.folderlist.size(); ++j2) {
                if (j2 == i2) continue;
                AddressFolder childaf = (AddressFolder)this.folderlist.get(j2);
                if (!childaf.m_parentFolder.m_id.equals(af.m_id)) continue;
                af.alAddressFolder.add(childaf);
            }
            ArrayList<Address> addrt = new ArrayList<Address>();
            block2: for (int j3 = 0; j3 < this.addrlist.size(); ++j3) {
                Address addr = (Address)this.addrlist.get(j3);
                for (int k2 = 0; k2 < this.rallist.size(); ++k2) {
                    Map tmp = (Map)this.rallist.get(k2);
                    if (!af.m_id.equals(tmp.get(addr.m_id))) continue;
                    addrt.add(addr);
                    continue block2;
                }
            }
            af.alAddress = addrt;
        }
        String strContent = this.a().toString();
        Util.lockWrite(this.m_File, strContent.getBytes(SysConts.New_FileCharSet));
        this.addrlist.clear();
        this.folderlist.clear();
        this.rallist.clear();
    }

    private void a(Element root, String prefix) {
        if (root == null) {
            return;
        }
        List attrs = root.attributes();
        Element pe = root.getParent();
        boolean isDisplay = false;
        if (pe != null && ("Sys_User".equalsIgnoreCase(pe.getName()) || "RTX_Dept".equalsIgnoreCase(pe.getName()) || "RTX_DeptUser".equalsIgnoreCase(pe.getName()))) {
            isDisplay = true;
        }
        if (attrs != null && attrs.size() > 0 && isDisplay) {
            Attribute attr;
            if ("Sys_User".equalsIgnoreCase(pe.getName())) {
                Address addr = new Address();
                for (int i2 = 0; i2 < attrs.size(); ++i2) {
                    attr = (Attribute)attrs.get(i2);
                    if ("ID".equalsIgnoreCase(attr.getName())) {
                        addr.m_id = attr.getValue();
                        continue;
                    }
                    if ("Name".equalsIgnoreCase(attr.getName())) {
                        addr.Name = attr.getValue();
                        continue;
                    }
                    if ("Mobile".equalsIgnoreCase(attr.getName())) {
                        addr.Telephone = attr.getValue();
                        continue;
                    }
                    if (!"Email".equalsIgnoreCase(attr.getName())) continue;
                    addr.EmailAddress = attr.getValue();
                }
                this.addrlist.add(addr);
            } else if ("RTX_Dept".equalsIgnoreCase(pe.getName())) {
                AddressFolder af = new AddressFolder();
                for (int i3 = 0; i3 < attrs.size(); ++i3) {
                    attr = (Attribute)attrs.get(i3);
                    if ("DeptID".equalsIgnoreCase(attr.getName())) {
                        af.m_id = attr.getValue();
                        continue;
                    }
                    if ("DeptName".equalsIgnoreCase(attr.getName())) {
                        af.m_FolderName = attr.getValue();
                        continue;
                    }
                    if (!"PDeptID".equalsIgnoreCase(attr.getName())) continue;
                    AddressFolder tfolder = new AddressFolder();
                    tfolder.m_id = attr.getValue();
                    af.m_parentFolder = tfolder;
                }
                this.folderlist.add(af);
            } else if ("RTX_DeptUser".equalsIgnoreCase(pe.getName())) {
                HashMap<String, String> map = new HashMap<String, String>();
                String key = "";
                String value = "";
                for (int i4 = 0; i4 < attrs.size(); ++i4) {
                    Attribute attr2 = (Attribute)attrs.get(i4);
                    if ("DeptID".equalsIgnoreCase(attr2.getName())) {
                        value = attr2.getValue();
                        continue;
                    }
                    if (!"UserID".equalsIgnoreCase(attr2.getName())) continue;
                    key = attr2.getValue();
                }
                map.put(key, value);
                this.rallist.add(map);
            }
        }
        List childNodes = root.elements();
        prefix = prefix + "\t";
        for (int i5 = 0; i5 < childNodes.size(); ++i5) {
            this.a((Element)childNodes.get(i5), prefix);
        }
    }

    private StringBuffer a() {
        StringBuffer sbContent = new StringBuffer();
        sbContent.append("<?xml encoding=\"" + SysConts.New_FileCharSet + "\"?>\r\n");
        sbContent.append("<addresslist>\r\n");
        int size = this.folderlist.size();
        AddressFolder addrfolder = null;
        for (int k2 = 0; k2 < size; ++k2) {
            addrfolder = (AddressFolder)this.folderlist.get(k2);
            if (!"0".equals(addrfolder.m_parentFolder.m_id)) continue;
            sbContent.append(addrfolder.getFolderXML());
            this.alAddressFolder.add(addrfolder);
        }
        sbContent.append("</addresslist>");
        return sbContent;
    }

    public void initfromfile(String domain, String username, String strListFile, String foldertype) {
        this.m_File = strListFile;
        ConfParam tempCF = new ConfParam();
        if (tempCF.Open(strListFile) > 0) {
            return;
        }
        Vector v = tempCF.GetParamVt("addresslist.address");
        Param tempParam = null;
        Enumeration xenum = v.elements();
        String strTemp = "";
        this.alAddress.clear();
        while (xenum.hasMoreElements()) {
            tempParam = (Param)xenum.nextElement();
            this.a(tempParam, this.alAddress, domain, username, this);
        }
        v = tempCF.GetParamVt("addresslist.folder");
        xenum = v.elements();
        strTemp = "";
        AddressFolder addrfolder = null;
        Object subParam = null;
        this.alAddressFolder.clear();
        boolean iSize = false;
        while (xenum.hasMoreElements()) {
            tempParam = (Param)xenum.nextElement();
            addrfolder = this.a(tempParam, domain, username, this, foldertype);
            if (addrfolder.m_FolderName.equals("")) continue;
            this.alAddressFolder.add(addrfolder);
        }
        AddressFolderComparator anc = new AddressFolderComparator();
        Collections.sort(this.alAddressFolder, anc);
        if (this.b) {
            this.save();
        }
    }

    public void initfromString(String domain, String username, String strXml, String foldertype) {
        ConfParam tempCF = new ConfParam();
        if (tempCF.OpenString(strXml) > 0) {
            return;
        }
        Vector v = tempCF.GetParamVt("addresslist.address");
        Param tempParam = null;
        Enumeration xenum = v.elements();
        String strTemp = "";
        this.alAddress.clear();
        while (xenum.hasMoreElements()) {
            tempParam = (Param)xenum.nextElement();
            this.a(tempParam, this.alAddress, domain, username, this);
        }
        AddressNameComparator aec = new AddressNameComparator();
        Collections.sort(this.alAddress, aec);
        v = tempCF.GetParamVt("addresslist.folder");
        xenum = v.elements();
        strTemp = "";
        AddressFolder addrfolder = null;
        Object subParam = null;
        this.alAddressFolder.clear();
        boolean iSize = false;
        while (xenum.hasMoreElements()) {
            tempParam = (Param)xenum.nextElement();
            addrfolder = this.a(tempParam, domain, username, this, foldertype);
            if (addrfolder.m_FolderName.equals("")) continue;
            this.alAddressFolder.add(addrfolder);
        }
        AddressFolderComparator anc = new AddressFolderComparator();
        Collections.sort(this.alAddressFolder, anc);
    }

    private AddressFolder a(Param curParam, String domain, String username, AddressFolder parentaf, String foldertype) {
        int iSize = curParam.alSubParam.size();
        AddressFolder addrfolder = new AddressFolder();
        addrfolder.m_parentFolder = parentaf;
        addrfolder.m_FolderName = (String)curParam.Attributes.get("name");
        addrfolder.m_id = (String)curParam.Attributes.get("id");
        addrfolder.m_foldertype = foldertype;
        if (addrfolder.m_id == null) {
            this.b = true;
            addrfolder.m_id = "";
        }
        if (addrfolder.m_id.equals("")) {
            this.b = true;
            addrfolder.m_id = AddressList.createId();
        }
        Param subParam = null;
        for (int k2 = 0; k2 < iSize; ++k2) {
            subParam = (Param)curParam.alSubParam.get(k2);
            if (subParam.ElementName.equals("folder")) {
                AddressFolder subFolder = this.a(subParam, domain, username, addrfolder, foldertype);
                subFolder.m_foldertype = this.m_foldertype;
                if (subFolder == null) continue;
                addrfolder.alAddressFolder.add(subFolder);
                continue;
            }
            if (!subParam.ElementName.equals("address")) continue;
            this.a(subParam, addrfolder.alAddress, domain, username, addrfolder);
        }
        return addrfolder;
    }

    private void a(Param tempParam, ArrayList al, String domain, String username, AddressFolder parentaf) {
        String strTemp = "";
        Address addr = null;
        Param subParam = null;
        int iSize = 0;
        addr = new Address();
        addr.m_parentFolder = parentaf;
        iSize = tempParam.alSubParam.size();
        for (int k2 = 0; k2 < iSize; ++k2) {
            subParam = (Param)tempParam.alSubParam.get(k2);
            if (subParam.ElementName.equals("name")) {
                addr.Name = subParam.ParamValue;
                continue;
            }
            if (subParam.ElementName.equals("email")) {
                addr.EmailAddress = subParam.ParamValue;
                continue;
            }
            if (subParam.ElementName.equals("organization")) {
                addr.Organization = subParam.ParamValue;
                continue;
            }
            if (subParam.ElementName.equals("department")) {
                addr.Department = subParam.ParamValue;
                continue;
            }
            if (subParam.ElementName.equals("address")) {
                addr.Address = subParam.ParamValue;
                continue;
            }
            if (subParam.ElementName.equals("postalcode")) {
                addr.Postalcode = subParam.ParamValue;
                continue;
            }
            if (subParam.ElementName.equals("telephone")) {
                addr.Telephone = subParam.ParamValue;
                continue;
            }
            if (subParam.ElementName.equals("employment")) {
                addr.Employment = subParam.ParamValue;
                continue;
            }
            if (subParam.ElementName.equals("id")) {
                addr.m_id = subParam.ParamValue;
                continue;
            }
            if (!subParam.ElementName.equals("orderrule")) continue;
            addr.Orderrule = subParam.ParamValue;
        }
        if (addr.m_id == null) {
            addr.m_id = "";
        }
        if (addr.m_id.equals("")) {
            addr.m_id = AddressList.createId();
            this.b = true;
        }
        addr.username = username;
        addr.m_foldertype = this.m_foldertype;
        if (!addr.Name.equals("")) {
            al.add(addr);
        }
        if (username == null) {
            String absAccount = "public";
            if (domain != null) {
                absAccount = domain;
            }
        } else {
            String string = username + "@" + domain;
        }
    }

    public void save() {
        boolean bBK = false;
        while (true) {
            try {
                File f2 = new File(this.m_File);
                if (!bBK) {
                    String backupfile;
                    File fbk;
                    long lOldSize = 0L;
                    long lNewSize = 0L;
                    if (f2.exists()) {
                        lNewSize = f2.length();
                    }
                    if ((fbk = new File(backupfile = this.m_File + ".bk")).exists()) {
                        lOldSize = fbk.length();
                    }
                    if (lNewSize > lOldSize) {
                        if (fbk.exists()) {
                            fbk.delete();
                        }
                        if (f2.exists()) {
                            f2.renameTo(fbk);
                        }
                    }
                    bBK = true;
                }
                f2 = new File(this.m_File);
                if (this.m_domain == null && this.m_username == null) {
                    CachePool.m_cmPublicAddrBook.setLastTime(this.m_File, System.currentTimeMillis() + 3600000L);
                }
                String strContent = this.b().toString();
                Util.lockWrite(this.m_File, strContent.getBytes(SysConts.New_FileCharSet));
                if (this.m_domain == null && this.m_username == null) {
                    File file = new File(this.m_File);
                    CachePool.m_cmPublicAddrBook.setLastTime(this.m_File, file.lastModified());
                }
                return;
            }
            catch (Exception e2) {
                e2.printStackTrace();
                continue;
            }
            break;
        }
    }

    private StringBuffer b() {
        StringBuffer sbContent = new StringBuffer();
        sbContent.append("<?xml encoding=\"" + SysConts.New_FileCharSet + "\"?>\r\n");
        sbContent.append("<addresslist>\r\n");
        sbContent.append(this.getAddressXML());
        AddressFolder addrfolder = null;
        int iSize = this.alAddressFolder.size();
        for (int k2 = 0; k2 < iSize; ++k2) {
            addrfolder = (AddressFolder)this.alAddressFolder.get(k2);
            sbContent.append(addrfolder.getFolderXML());
        }
        sbContent.append("</addresslist>");
        return sbContent;
    }

    public StringBuffer getXML_notXmlHeader() {
        StringBuffer sbContent = new StringBuffer();
        sbContent.append("<addresslist>\r\n");
        sbContent.append(this.getAddressXML());
        AddressFolder addrfolder = null;
        int iSize = this.alAddressFolder.size();
        for (int k2 = 0; k2 < iSize; ++k2) {
            addrfolder = (AddressFolder)this.alAddressFolder.get(k2);
            sbContent.append(addrfolder.getFolderXML());
        }
        sbContent.append("</addresslist>");
        return sbContent;
    }

    public void delete(String[] strAddrs, String foldername) {
        AddressFolder af;
        if (strAddrs == null) {
            return;
        }
        String strTemp = "";
        Object stk = null;
        String addrtype = "";
        String addrvalue = "";
        Address addr = null;
        ArrayList al = null;
        al = foldername == null ? this.alAddress : ((af = this.findAddressFolder(foldername)) == null ? this.alAddress : af.alAddress);
        for (int i2 = 0; i2 < strAddrs.length; ++i2) {
            strTemp = strAddrs[i2];
            addr = this.b(al, strTemp);
            if (strTemp == null) continue;
            al.remove(addr);
        }
    }

    private Address b(ArrayList al, String name) {
        int iSize = al.size();
        Address addr = null;
        for (int k2 = 0; k2 < iSize; ++k2) {
            addr = (Address)al.get(k2);
            if (!addr.Name.equals(name)) continue;
            return addr;
        }
        return null;
    }

    public Address findAddress(String addrname, String foldername) {
        AddressFolder af = this.findAddressFolder(foldername);
        if (af == null) {
            return null;
        }
        Address addr = null;
        int iSize = af.alAddress.size();
        for (int k2 = 0; k2 < iSize; ++k2) {
            addr = (Address)af.alAddress.get(k2);
            if (!addr.Name.equals(addrname)) continue;
            return addr;
        }
        return null;
    }

    public Address findAddress(String addrname) {
        Address addr = null;
        if (addrname == null) {
            return null;
        }
        if (addrname.equals("")) {
            return null;
        }
        int i2 = addrname.lastIndexOf("/");
        String path = null;
        String realname = null;
        try {
            path = addrname.substring(0, i2);
            realname = addrname.substring(i2 + 1);
        }
        catch (Exception e2) {
            return null;
        }
        AddressFolder af = this.findAddressFolder(path);
        if (af == null) {
            return null;
        }
        int iSize = af.alAddress.size();
        for (int k2 = 0; k2 < iSize; ++k2) {
            addr = (Address)af.alAddress.get(k2);
            if (!addr.Name.equals(realname)) continue;
            return addr;
        }
        return null;
    }

    public void delAddressFolderFromABS(AddressFolder af) {
        if (af != null) {
            Address addr = null;
            for (int i2 = 0; i2 < af.alAddress.size(); ++i2) {
                addr = (Address)af.alAddress.get(i2);
            }
            AddressFolder tempFolder = null;
            for (int i3 = 0; i3 < af.alAddressFolder.size(); ++i3) {
                tempFolder = (AddressFolder)af.alAddressFolder.get(i3);
                this.delAddressFolderFromABS(tempFolder);
            }
        }
    }

    public void delAddressFolder(String foldername) {
        AddressFolder af = this.findAddressFolder(foldername);
        if (af != null) {
            this.alAddressFolder.remove(af);
            this.a.clear();
        }
    }

    private Address c(ArrayList al, String name) {
        int iSize = al.size();
        Address addr = null;
        for (int k2 = 0; k2 < iSize; ++k2) {
            addr = (Address)al.get(k2);
            if (!addr.m_id.equals(name)) continue;
            return addr;
        }
        return null;
    }

    public Address findAddress_id(String addrname, String foldername) {
        AddressFolder af = this.findAddressFolder(foldername);
        if (af == null) {
            return null;
        }
        Address addr = null;
        int iSize = af.alAddress.size();
        for (int k2 = 0; k2 < iSize; ++k2) {
            addr = (Address)af.alAddress.get(k2);
            if (!addr.m_id.equals(addrname)) continue;
            return addr;
        }
        return null;
    }

    public Address findAddress_idname(String addrname, String foldername) {
        AddressFolder af = this.findAddressFolder_id(foldername);
        if (af == null) {
            return null;
        }
        Address addr = null;
        int iSize = af.alAddress.size();
        for (int k2 = 0; k2 < iSize; ++k2) {
            addr = (Address)af.alAddress.get(k2);
            if (!addr.Name.equals(addrname)) continue;
            return addr;
        }
        return null;
    }

    public Address findAddress_idid(String addrid, String foldername) {
        if (addrid == null) {
            return null;
        }
        if (addrid.equals("")) {
            return null;
        }
        AddressFolder af = this.findAddressFolder_id(foldername);
        if (af == null) {
            return null;
        }
        Address addr = null;
        int iSize = af.alAddress.size();
        for (int k2 = 0; k2 < iSize; ++k2) {
            addr = (Address)af.alAddress.get(k2);
            if (!addr.m_id.equals(addrid)) continue;
            return addr;
        }
        return null;
    }

    public Address findAddress_id(String addrname) {
        Address addr = null;
        if (addrname == null) {
            return null;
        }
        if (addrname.equals("")) {
            return null;
        }
        int i2 = addrname.lastIndexOf("/");
        String path = null;
        String realname = null;
        try {
            path = addrname.substring(0, i2);
            realname = addrname.substring(i2 + 1);
        }
        catch (Exception e2) {
            return null;
        }
        AddressFolder af = this.findAddressFolder_id(path);
        if (af == null) {
            return null;
        }
        int iSize = af.alAddress.size();
        for (int k2 = 0; k2 < iSize; ++k2) {
            addr = (Address)af.alAddress.get(k2);
            if (!addr.m_id.equals(realname)) continue;
            return addr;
        }
        return null;
    }

    public int delAddressFolder_id(String foldername) {
        AddressFolder af = this.findAddressFolder_id(foldername);
        if (af != null) {
            if (af.m_parentFolder == null) {
                af.alAddress.clear();
                af.alAddressFolder.clear();
            } else {
                af.m_parentFolder.alAddressFolder.remove(af);
            }
            this.a.clear();
        }
        this.save();
        return 0;
    }

    public Address delAddress_id(String addressid) {
        Address addr = this.findAddress_id(addressid);
        if (addr.m_parentFolder != null) {
            addr.m_parentFolder.alAddress.remove(addr);
        }
        return addr;
    }

    public int addAddressFolder(String folderPath, String name) {
        if (name == null || name.equals("")) {
            return 2;
        }
        AddressFolder fparent = this.findAddressFolder_id(folderPath);
        if (fparent == null) {
            return 1;
        }
        AddressFolder af = fparent.findCurAddressFolder(name);
        if (af != null) {
            return 1;
        }
        Address addr = fparent.findCurAddress(name);
        if (addr != null) {
            return 4;
        }
        this.a.clear();
        af = new AddressFolder();
        af.m_id = AddressList.createId();
        af.m_FolderName = name;
        af.m_parentFolder = fparent;
        fparent.alAddressFolder.add(af);
        this.save();
        return 0;
    }

    public void addAddress_id(Address addr, String foldername) {
        AddressFolder af = this.findAddressFolder_id(foldername);
        if (af == null) {
            addr.m_parentFolder = this;
            this.alAddress.add(addr);
        } else {
            addr.m_parentFolder = af;
            af.alAddress.add(addr);
        }
    }

    public static ArrayList parseMap(String strMap) {
        FormatPair fp = null;
        ArrayList<FormatPair> alFormat = new ArrayList<FormatPair>();
        String[] fps = strMap.split("\\|");
        if (fps == null) {
            return null;
        }
        if (fps.length == 0) {
            return null;
        }
        for (int i2 = 0; i2 < fps.length; ++i2) {
            fp = new FormatPair();
            fp.m_FieldName = fps[i2];
            fp.m_OutputName = fps[++i2];
            alFormat.add(fp);
        }
        return alFormat;
    }

    public void outputOutlook(String outputfile, String charset, String strMap, String folderid, String showsuball) {
        if (strMap == null) {
            return;
        }
        if (outputfile == null) {
            return;
        }
        FormatPair fp = null;
        ArrayList alFormat = AddressList.parseMap(strMap);
        StringBuffer sbContent = new StringBuffer();
        for (int i2 = 0; i2 < alFormat.size(); ++i2) {
            fp = (FormatPair)alFormat.get(i2);
            if (fp.m_FieldName.equals("name")) {
                sbContent.append(",\"" + fp.m_OutputName + "\"");
                continue;
            }
            if (fp.m_FieldName.equals("telephone")) {
                sbContent.append(",\"" + fp.m_OutputName + "\"");
                continue;
            }
            if (fp.m_FieldName.equals("email")) {
                sbContent.append(",\"" + fp.m_OutputName + "\"");
                continue;
            }
            if (fp.m_FieldName.equals("postalcode")) {
                sbContent.append(",\"" + fp.m_OutputName + "\"");
                continue;
            }
            if (fp.m_FieldName.equals("address")) {
                sbContent.append(",\"" + fp.m_OutputName + "\"");
                continue;
            }
            if (fp.m_FieldName.equals("employment")) {
                sbContent.append(",\"" + fp.m_OutputName + "\"");
                continue;
            }
            if (fp.m_FieldName.equals("organization")) {
                sbContent.append(",\"" + fp.m_OutputName + "\"");
                continue;
            }
            if (fp.m_FieldName.equals("department")) {
                sbContent.append(",\"" + fp.m_OutputName + "\"");
                continue;
            }
            if (!fp.m_FieldName.equals("orderrule")) continue;
            sbContent.append(",\"" + fp.m_OutputName + "\"");
        }
        String strRet = sbContent.toString();
        strRet = StringUtil.supertrim(strRet, ",");
        sbContent.setLength(0);
        sbContent.append(strRet);
        ArrayList alaladdr = new ArrayList();
        AddressFolder af = this.findAddressFolder_id(folderid);
        if (af != null) {
            if (showsuball.equals("true")) {
                af.getAddress(true, alaladdr);
            } else {
                af.getAddress(false, alaladdr);
            }
        }
        sbContent.append(this.outputOutlookFolder(alFormat, alaladdr));
        try {
            File f2 = new File(outputfile);
            if (f2.exists()) {
                f2.delete();
            }
            f2.createNewFile();
            RandomAccessFile raf = new RandomAccessFile(f2, "rw");
            String strContent = sbContent.toString();
            raf.write(strContent.getBytes(charset));
            raf.close();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public void outputOutlook(String outputfile, String charset, String folderid, String showsuball) {
        if (outputfile == null) {
            return;
        }
        ArrayList alaladdr = new ArrayList();
        AddressFolder af = this.findAddressFolder_id(folderid);
        AddressList addrlist = new AddressList();
        if (showsuball.equals("true")) {
            if (folderid.trim().equals("/")) {
                addrlist = this;
            } else {
                addrlist.alAddressFolder.add(af);
            }
        } else {
            ArrayList al = af.alAddress;
            Address addr = null;
            int iSize = al.size();
            for (int k2 = 0; k2 < iSize; ++k2) {
                addr = (Address)al.get(k2);
                addrlist.addAddress_id(addr, folderid);
            }
        }
        try {
            addrlist.saveTempFile(outputfile, charset);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public void saveTempFile(String outputfile, String charset) {
        while (true) {
            try {
                String strContent = this.b().toString();
                Util.lockWrite(outputfile, strContent.getBytes(charset));
                return;
            }
            catch (Exception e2) {
                e2.printStackTrace();
                continue;
            }
            break;
        }
    }
}

