/*
 * Decompiled with CFR 0.152.
 */
package cn.sendsms.jdsmsserver.gateways;

import cn.sendsms.jdsmsserver.JDSMSServer;
import cn.sendsms.jdsmsserver.gateways.BaseGatewayInfo;
import cn.sendsms.jdsmsserver.web.SerialModemBean;
import cn.sendsms.smpp.AbstractSMPPGateway;
import cn.sendsms.smpp.Address;
import cn.sendsms.smpp.BindAttributes;
import java.lang.reflect.Constructor;
import org.apache.commons.configuration.PropertiesConfiguration;

public class SMPPGateway
extends BaseGatewayInfo {
    public SMPPGateway(String myGatewayId, PropertiesConfiguration myProps, JDSMSServer myServer) {
        super(myGatewayId, myProps, myServer);
        this.setDescription(myGatewayId + " SMPP Gateway.");
    }

    @Override
    public boolean create() throws Exception {
        String ton;
        String implClass = this.a("impl");
        Class<?> clazz = Class.forName(implClass);
        Class[] classArgs = new Class[]{String.class, String.class, Integer.TYPE, BindAttributes.class};
        Constructor<?> con = clazz.getConstructor(classArgs);
        String host = this.a("host");
        Integer port = Integer.parseInt(this.a("port"));
        Object[] args = new Object[]{this.getGatewayId(), host, port, this.a()};
        AbstractSMPPGateway gateway = (AbstractSMPPGateway)con.newInstance(args);
        String enquireLink = this.a("enquirelink");
        if (enquireLink != null && !enquireLink.isEmpty()) {
            gateway.setEnquireLink(Integer.parseInt(enquireLink));
        }
        Address.TypeOfNumber typeOfNumber = (ton = this.a("sourceton")) == null ? Address.TypeOfNumber.UNKNOWN : Address.TypeOfNumber.valueOf(Byte.parseByte(ton));
        String npi = this.a("sourcenpi");
        Address.NumberingPlanIndicator numberingPlanIndicator = npi == null ? Address.NumberingPlanIndicator.UNKNOWN : Address.NumberingPlanIndicator.valueOf(Byte.parseByte(ton));
        gateway.setSourceAddress(new Address(typeOfNumber, numberingPlanIndicator));
        ton = this.a("destton");
        typeOfNumber = ton == null ? Address.TypeOfNumber.UNKNOWN : Address.TypeOfNumber.valueOf(Byte.parseByte(ton));
        npi = this.a("destnpi");
        numberingPlanIndicator = npi == null ? Address.NumberingPlanIndicator.UNKNOWN : Address.NumberingPlanIndicator.valueOf(Byte.parseByte(ton));
        gateway.setDestinationAddress(new Address(typeOfNumber, numberingPlanIndicator));
        this.setGateway(gateway);
        return true;
    }

    private BindAttributes a() {
        String systemId = this.a("systemid");
        String password = this.a("password");
        String systemType = this.a("systemtype");
        BindAttributes.BindType bindType = BindAttributes.BindType.getByShortName(this.a("bindtype"));
        String ton = this.a("bindton");
        Address.TypeOfNumber typeOfNumber = ton == null ? Address.TypeOfNumber.UNKNOWN : Address.TypeOfNumber.valueOf(Byte.parseByte(ton));
        String npi = this.a("bindnpi");
        Address.NumberingPlanIndicator numberingPlanIndicator = npi == null ? Address.NumberingPlanIndicator.UNKNOWN : Address.NumberingPlanIndicator.valueOf(Byte.parseByte(ton));
        return new BindAttributes(systemId, password, systemType, bindType, new Address(typeOfNumber, numberingPlanIndicator));
    }

    private String a(String name) {
        String propertyValue = this.getProperties().getString(this.getGatewayId() + "." + name);
        if (propertyValue != null) {
            return propertyValue.trim();
        }
        return propertyValue;
    }

    @Override
    public SerialModemBean getDeviceConfigInfo() {
        return null;
    }
}

