/*
 * Decompiled with CFR 0.152.
 */
package cn.sendsms.jdsmsserver.interfaces;

import cn.sendsms.AGateway;
import cn.sendsms.InboundBinaryMessage;
import cn.sendsms.InboundMessage;
import cn.sendsms.Message;
import cn.sendsms.OutboundBinaryMessage;
import cn.sendsms.OutboundMessage;
import cn.sendsms.OutboundWapSIMessage;
import cn.sendsms.Service;
import cn.sendsms.StatusReportMessage;
import cn.sendsms.helper.AGatewayHelper;
import cn.sendsms.helper.Logger;
import cn.sendsms.jdsmsserver.JDSMSServer;
import cn.sendsms.jdsmsserver.SysLock;
import cn.sendsms.jdsmsserver.interfaces.ConnectionPool;
import cn.sendsms.jdsmsserver.interfaces.Interface;
import cn.sendsms.jdsmsserver.web.NewAuth;
import cn.sendsms.jdsmsserver.web.PhoneInfoCache;
import cn.sendsms.otherModem.common.Utils;
import java.net.URL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang3.StringUtils;

public class Database
extends Interface<Integer> {
    static final int SQL_DELAY = 1000;
    int a = 1;
    private Connection b = null;

    public Database(String myInterfaceId, PropertiesConfiguration myProps, JDSMSServer myServer, Interface.InterfaceTypes myType) {
        super(myInterfaceId, myProps, myServer, myType);
        this.setDescription("Default database interface.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws Exception {
        Connection con = null;
        try {
            con = this.a();
            Statement cmd = con.createStatement(1003, 1007);
            cmd.executeUpdate("update " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " set status = 'U' where status = 'Q'");
            cmd.close();
        }
        catch (SQLException e2) {
            Throwable sqlException = e2.getCause();
            String sqlError = sqlException == null ? "" : sqlException.toString();
            try {
                if (con != null) {
                    con.close();
                }
                this.a(con);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!this.getServer().getShutdown()) {
                Logger.getInstance().logError(String.format("SQL failure " + sqlError + " , will retry in %d seconds...", this.a * 1), e2, null);
                Thread.sleep(this.a * 1000);
                this.a *= 2;
                if (this.a == 64) {
                    this.a = 1;
                }
            }
        }
        finally {
            this.a(con);
        }
        super.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() throws Exception {
        Connection con = null;
        try {
            con = this.a();
            Statement cmd = con.createStatement(1003, 1007);
            cmd.executeUpdate("update " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " set status = 'U' where status = 'Q'");
            cmd.close();
        }
        catch (SQLException e2) {
            try {
                if (con != null) {
                    con.close();
                }
                this.a(con);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!this.getServer().getShutdown()) {
                Logger.getInstance().logError(String.format("SQL failure, will retry in %d seconds...", this.a * 1), e2, null);
                Thread.sleep(this.a * 1000);
                this.a *= 2;
                if (this.a == 64) {
                    this.a = 1;
                }
            }
        }
        finally {
            this.a(con);
            this.b();
        }
        super.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void callReceived(String gtwId, String callerId) throws Exception {
        Connection con = null;
        try {
            con = this.a();
            PreparedStatement cmd = con.prepareStatement("insert into " + this.getProperty("tables.calls", "jdsmsserver_calls") + " (call_date, gateway_id, caller_id) values (?,?,?) ");
            cmd.setTimestamp(1, new Timestamp(new Date().getTime()));
            cmd.setString(2, gtwId);
            cmd.setString(3, callerId);
            cmd.executeUpdate();
            cmd.close();
        }
        catch (SQLException e2) {
            try {
                if (con != null) {
                    con.close();
                }
                this.a(con);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Logger.getInstance().logError(String.format("SQL failure, will retry in %d seconds...", this.a * 1), e2, null);
            Thread.sleep(this.a * 1000);
            this.a *= 2;
            if (this.a == 64) {
                this.a = 1;
            }
        }
        finally {
            this.a(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void messagesReceived(Collection<InboundMessage> msgList) throws Exception {
        int count = 0;
        while (!SysLock.getInstance().canUse()) {
            try {
                Thread.sleep(50L);
                if (count++ <= 50) continue;
                Logger.getInstance().logError("\u81ea\u65cb\u7b49\u5f85\u8d85\u8fc72\u79d2", null, null);
            }
            catch (InterruptedException e2) {
                Logger.getInstance().logError("\u53d6\u5f85\u53d1\u77ed\u4fe1\u65f6\u4ea7\u751f\u4e2d\u65ad\u5f02\u5e38", e2, null);
            }
        }
        System.out.println("Database messagesReceived...");
        Connection con = null;
        try {
            con = this.a();
            PreparedStatement pst = con.prepareStatement(" insert into " + this.getProperty("tables.sms_in", "jdsmsserver_in") + " (process, originator, type, encoding, message_date, receive_date, text, original_ref_no, original_receive_date, gateway_id)  values(?,?,?,?,?,?,?,?,?,?)");
            block26: for (InboundMessage msg : msgList) {
                if (msg.isError()) {
                    Logger.getInstance().logInfo("\u4fe1\u606f\u3010" + msg.getText() + "\u3011\u4e0d\u5b8c\u6574\uff0c\u4e0d\u5165\u5e93\u3002", null, null);
                    continue;
                }
                if (this.a(con, msg)) {
                    Logger.getInstance().logInfo("\u4fe1\u606f\u3010" + msg.getText() + "\u3011\u91cd\u590d\u4e86\uff01key: " + msg.getMessageID() + "-" + msg.getOriginator(), null, null);
                    continue;
                }
                if (msg.getType() != Message.MessageTypes.INBOUND && msg.getType() != Message.MessageTypes.STATUSREPORT) continue;
                if (Utils.isEmptyStr(msg.getMessageID())) {
                    pst.setInt(1, 0);
                } else {
                    pst.setInt(1, Integer.valueOf(msg.getMessageID(), 16));
                }
                switch (msg.getEncoding()) {
                    case ENC7BIT: {
                        pst.setString(4, "7");
                        break;
                    }
                    case ENC8BIT: {
                        pst.setString(4, "8");
                        break;
                    }
                    case ENCUCS2: {
                        pst.setString(4, "U");
                        break;
                    }
                    case SC: {
                        pst.setString(4, "S");
                        break;
                    }
                    case ENCCUSTOM: {
                        pst.setString(4, "C");
                    }
                }
                switch (msg.getType()) {
                    case INBOUND: {
                        pst.setString(3, "I");
                        String org = msg.getOriginator();
                        if (null == org) continue block26;
                        if (org.startsWith("86")) {
                            org = org.substring(2, org.length());
                        }
                        pst.setString(2, org);
                        if (msg.getDate() != null) {
                            pst.setTimestamp(5, new Timestamp(msg.getDate().getTime()));
                        }
                        pst.setString(8, null);
                        pst.setTimestamp(9, null);
                        break;
                    }
                    case STATUSREPORT: {
                        pst.setString(3, "S");
                        pst.setString(2, ((StatusReportMessage)msg).getRecipient());
                        if (((StatusReportMessage)msg).getSent() != null) {
                            pst.setTimestamp(5, new Timestamp(((StatusReportMessage)msg).getSent().getTime()));
                        }
                        pst.setString(8, ((StatusReportMessage)msg).getRefNo());
                        if (((StatusReportMessage)msg).getReceived() != null) {
                            pst.setTimestamp(9, new Timestamp(((StatusReportMessage)msg).getReceived().getTime()));
                        }
                        if (!this.getProperty("update_outbound_on_statusreport", "no").equalsIgnoreCase("yes")) break;
                        PreparedStatement cmd2 = con.prepareStatement(" update " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " set status = ?  where (recipient = ? or recipient = ?) and ref_no = ? and gateway_id = ?");
                        switch (((StatusReportMessage)msg).getStatus()) {
                            case DELIVERED: {
                                cmd2.setString(1, "D");
                                break;
                            }
                            case KEEPTRYING: {
                                cmd2.setString(1, "P");
                                break;
                            }
                            case ABORTED: {
                                cmd2.setString(1, "A");
                                break;
                            }
                        }
                        cmd2.setString(2, ((StatusReportMessage)msg).getRecipient());
                        if (((StatusReportMessage)msg).getRecipient().startsWith("+")) {
                            cmd2.setString(3, ((StatusReportMessage)msg).getRecipient().substring(1));
                        } else {
                            cmd2.setString(3, "+" + ((StatusReportMessage)msg).getRecipient());
                        }
                        cmd2.setString(4, ((StatusReportMessage)msg).getRefNo());
                        cmd2.setString(5, ((StatusReportMessage)msg).getGatewayId());
                        cmd2.executeUpdate();
                        cmd2.close();
                        break;
                    }
                }
                pst.setTimestamp(6, new Timestamp(new Date().getTime()));
                if (msg instanceof InboundBinaryMessage) {
                    pst.setString(7, msg.getPduUserData().length() == 0 ? "" : msg.getPduUserData());
                } else {
                    pst.setString(7, msg.getText().length() == 0 ? "" : msg.getText());
                }
                pst.setString(10, msg.getGatewayId());
                pst.addBatch();
            }
            Iterator<InboundMessage> iterMessage = null;
            pst.executeBatch();
            pst.close();
        }
        catch (Exception e3) {
            try {
                if (con != null) {
                    con.close();
                }
                this.a(con);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Logger.getInstance().logError(String.format("SQL failure, will retry in %d seconds...", this.a * 1), e3, null);
            Thread.sleep(this.a * 1000);
            this.a *= 2;
            if (this.a == 64) {
                this.a = 1;
            }
        }
        finally {
            SysLock.getInstance().setbusy(false);
            this.a(con);
        }
        SysLock.getInstance().setbusy(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<OutboundMessage> getMessagesToSend() throws Exception {
        int count = 0;
        while (!SysLock.getInstance().canUse()) {
            try {
                Thread.sleep(50L);
                if (count++ <= 50) continue;
                Logger.getInstance().logError("\u81ea\u65cb\u7b49\u5f85\u8d85\u8fc72\u79d2", null, null);
            }
            catch (InterruptedException e2) {
                Logger.getInstance().logError("\u53d6\u5f85\u53d1\u77ed\u4fe1\u65f6\u4ea7\u751f\u4e2d\u65ad\u5f02\u5e38", e2, null);
            }
        }
        Connection con = null;
        ArrayList<OutboundMessage> msgList = new ArrayList<OutboundMessage>();
        boolean isOracle = false;
        if (JDSMSServer.getInstance().getProperties().getString("db1.type", "mysql").equals("oracle") || JDSMSServer.getInstance().getProperties().getString("db1.type", "mysql").equals("oracle-rac")) {
            isOracle = true;
        }
        boolean isMssql = false;
        if (JDSMSServer.getInstance().getProperties().getString("db1.type", "mysql").equals("mssql")) {
            isMssql = true;
        }
        boolean isPG = false;
        if (JDSMSServer.getInstance().getProperties().getString("db1.type", "mysql").equals("postgresql")) {
            isPG = true;
        }
        String device_using = JDSMSServer.getInstance().getProperties().getString("settings.device_using", "yes");
        String phone_using = JDSMSServer.getInstance().getProperties().getString("settings.phone_using", "yes");
        String gateway_using = JDSMSServer.getInstance().getProperties().getString("settings.gateway_using", "yes");
        String flag = this.c();
        int retryMaxNum = 0;
        if (phone_using.equals("yes")) {
            ++retryMaxNum;
        }
        if (device_using.equals("yes")) {
            ++retryMaxNum;
        }
        if (gateway_using.equals("yes")) {
            ++retryMaxNum;
        }
        retryMaxNum *= 3;
        try {
            PreparedStatement pst;
            ResultSet rs = null;
            int msgCount = 1;
            con = this.a();
            Statement cmd = con.createStatement(1005, 1008);
            if ("no".equals(device_using)) {
                ArrayList<OutboundMessage> arrayList = msgList;
                return arrayList;
            }
            if (!"*".equals(flag)) {
                pst = con.prepareStatement("update " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " set status = 'Q',gateway_id=? where id = ? ");
                JDSMSServer.getInstance().userConsolePrint("x", "send update1: update " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " set status = 'Q',gateway_id=? where id = ? ");
            } else {
                pst = con.prepareStatement("update " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " set status = 'Q' where id = ? ");
                JDSMSServer.getInstance().userConsolePrint("x", "send update2: update " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " set status = 'Q' where id = ? ");
            }
            String sqlSelect = "";
            if ("*".equals(flag)) {
                if (isOracle) {
                    sqlSelect = "select * from " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " where status = 'U' and (gateway_id = '*' or gateway_id like 'modem%') and rownum <= %size% order by priority desc, id";
                    sqlSelect = sqlSelect.replaceAll("%size%", "" + Integer.parseInt(this.getProperty("batch_size", "50")));
                } else if (isMssql) {
                    sqlSelect = "select top %size% * from " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " where status = 'U' and (gateway_id = '*' or gateway_id like 'modem%') order by priority desc, id";
                    sqlSelect = sqlSelect.replaceAll("%size%", "" + Integer.parseInt(this.getProperty("batch_size", "50")));
                } else if (isPG) {
                    sqlSelect = "select * from " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " where status = 'U' and (gateway_id = '*' or gateway_id like 'modem%') order by priority desc, id limit %size% offset %begin%";
                    sqlSelect = sqlSelect.replaceAll("%begin%", "0");
                    sqlSelect = sqlSelect.replaceAll("%size%", "" + Integer.parseInt(this.getProperty("batch_size", "50")));
                } else {
                    sqlSelect = "select * from " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " where status = 'U' and (gateway_id = '*' or gateway_id like 'modem%') order by priority desc, id limit %begin% , %size%";
                    sqlSelect = sqlSelect.replaceAll("%begin%", "0");
                    sqlSelect = sqlSelect.replaceAll("%size%", "" + Integer.parseInt(this.getProperty("batch_size", "50")));
                }
                JDSMSServer.getInstance().userConsolePrint("x", "get send1:" + sqlSelect);
                rs = cmd.executeQuery(sqlSelect);
            }
            int retryNum = Integer.parseInt(this.getProperty("retries", "2"));
            if (!"*".equals(flag)) {
                if (isOracle) {
                    sqlSelect = "select * from " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " where (status = 'F' and (gateway_id='#' or gateway_id = '$') and errors>'" + retryNum + "' and errors<'" + retryMaxNum + "') or (status = 'U' and (gateway_id = '*' or gateway_id like 'modem%')) and rownum <= %size% order by priority desc, id";
                    sqlSelect = sqlSelect.replaceAll("%size%", "" + Integer.parseInt(this.getProperty("batch_size", "50")));
                } else if (isMssql) {
                    sqlSelect = "select top %size% * from " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " where (status = 'F' and (gateway_id='#' or gateway_id = '$') and errors>'" + retryNum + "' and errors<'" + retryMaxNum + "') or (status = 'U' and (gateway_id = '*' or gateway_id like 'modem%')) order by priority desc, id";
                    sqlSelect = sqlSelect.replaceAll("%size%", "" + Integer.parseInt(this.getProperty("batch_size", "50")));
                } else if (isPG) {
                    sqlSelect = "select * from " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " where (status = 'F' and (gateway_id='#' or gateway_id = '$') and errors>'" + retryNum + "' and errors<'" + retryMaxNum + "') or (status = 'U' and (gateway_id = '*' or gateway_id like 'modem%')) order by priority desc, id limit %size% offset %begin%";
                    sqlSelect = sqlSelect.replaceAll("%begin%", "0");
                    sqlSelect = sqlSelect.replaceAll("%size%", "" + Integer.parseInt(this.getProperty("batch_size", "50")));
                } else {
                    sqlSelect = "select * from " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " where (status = 'F' and (gateway_id='#' or gateway_id = '$') and errors>'" + retryNum + "' and errors<'" + retryMaxNum + "') or (status = 'U' and (gateway_id = '*' or gateway_id like 'modem%')) order by priority desc, id limit %begin% , %size%";
                    sqlSelect = sqlSelect.replaceAll("%begin%", "0");
                    sqlSelect = sqlSelect.replaceAll("%size%", "" + Integer.parseInt(this.getProperty("batch_size", "50")));
                }
                JDSMSServer.getInstance().userConsolePrint("x", "get send2:" + sqlSelect);
                rs = cmd.executeQuery(sqlSelect);
            }
            if (rs == null) {
                Logger.getInstance().logError("\u914d\u7f6e\u6587\u4ef6\u8bbe\u5907\u6a21\u5f0f\u4e22\u5931,\u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6", null, null);
                ArrayList<OutboundMessage> arrayList = msgList;
                return arrayList;
            }
            Logger.getInstance().logDebug("sql\u67e5\u8be2=" + sqlSelect, null, null);
            PreparedStatement updateStatement = con.prepareStatement("update " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " set status = 'F',sent_date=? where id = ? ");
            block28: while (rs.next() && msgCount <= Integer.parseInt(this.getProperty("batch_size", "50"))) {
                OutboundMessage msg;
                if (!this.getServer().checkPriorityTimeFrame(rs.getInt("priority"))) continue;
                String recipient = rs.getString("recipient");
                if (StringUtils.isEmpty((CharSequence)recipient) || !recipient.matches("\\+?\\d{1,25}")) {
                    updateStatement.setTimestamp(1, new Timestamp(System.currentTimeMillis()));
                    updateStatement.setLong(2, rs.getLong("id"));
                    updateStatement.addBatch();
                    continue;
                }
                if (rs.getTimestamp("sent_date") != null && System.currentTimeMillis() < rs.getTimestamp("sent_date").getTime()) continue;
                switch (rs.getString("type").charAt(0)) {
                    case 'O': {
                        switch (rs.getString("encoding").charAt(0)) {
                            case '7': {
                                msg = new OutboundMessage(rs.getString("recipient").trim(), rs.getString("text").trim());
                                msg.setEncoding(Message.MessageEncodings.ENC7BIT);
                                break;
                            }
                            case '8': {
                                String text = rs.getString("text").trim();
                                if (text.matches("[0-9A-F]+")) {
                                    msg = new OutboundBinaryMessage(rs.getString("recipient").trim(), text.getBytes());
                                    break;
                                }
                                Logger.getInstance().logError("8bit\u7f16\u7801\u4e0d\u80fd\u5305\u542b[A-F0-9]\u4ee5\u5916\u7684\u5b57\u7b26\u3002", null, null);
                                continue block28;
                            }
                            case 'U': {
                                msg = new OutboundMessage(rs.getString("recipient").trim(), rs.getString("text").trim());
                                msg.setEncoding(Message.MessageEncodings.ENCUCS2);
                                break;
                            }
                            default: {
                                msg = new OutboundMessage(rs.getString("recipient").trim(), rs.getString("text").trim());
                                msg.setEncoding(Message.MessageEncodings.ENC7BIT);
                            }
                        }
                        if (rs.getInt("flash_sms") == 1) {
                            msg.setFlashSms(true);
                        }
                        if (rs.getInt("src_port") == -1) break;
                        msg.setSrcPort(rs.getInt("src_port"));
                        msg.setDstPort(rs.getInt("dst_port"));
                        break;
                    }
                    case 'W': {
                        OutboundWapSIMessage.WapSISignals wapSignal;
                        Date wapExpiryDate;
                        if (rs.getTime("wap_expiry_date") == null) {
                            Calendar cal = Calendar.getInstance();
                            cal.setTime(new Date());
                            cal.add(6, 7);
                            wapExpiryDate = cal.getTime();
                        } else {
                            wapExpiryDate = rs.getTimestamp("wap_expiry_date");
                        }
                        if (rs.getString("wap_signal") == null) {
                            wapSignal = OutboundWapSIMessage.WapSISignals.NONE;
                        } else {
                            switch (rs.getString("wap_signal").charAt(0)) {
                                case 'N': {
                                    wapSignal = OutboundWapSIMessage.WapSISignals.NONE;
                                    break;
                                }
                                case 'L': {
                                    wapSignal = OutboundWapSIMessage.WapSISignals.LOW;
                                    break;
                                }
                                case 'M': {
                                    wapSignal = OutboundWapSIMessage.WapSISignals.MEDIUM;
                                    break;
                                }
                                case 'H': {
                                    wapSignal = OutboundWapSIMessage.WapSISignals.HIGH;
                                    break;
                                }
                                case 'D': {
                                    wapSignal = OutboundWapSIMessage.WapSISignals.DELETE;
                                    break;
                                }
                                default: {
                                    wapSignal = OutboundWapSIMessage.WapSISignals.NONE;
                                }
                            }
                        }
                        msg = new OutboundWapSIMessage(rs.getString("recipient").trim(), new URL(rs.getString("wap_url").trim()), rs.getString("text").trim(), wapExpiryDate, wapSignal);
                        break;
                    }
                    default: {
                        throw new Exception("Message type '" + rs.getString("type") + "' is unknown!");
                    }
                }
                msg.setPriority(rs.getInt("priority"));
                if (rs.getInt("status_report") == 1) {
                    msg.setStatusReport(true);
                }
                if (rs.getString("originator") != null && rs.getString("originator").length() > 0) {
                    msg.setFrom(rs.getString("originator").trim());
                }
                String gateway_id = rs.getString("gateway_id").trim();
                if (!"*".equals(flag)) {
                    if ("#".equals(gateway_id) || "$".equals(gateway_id)) {
                        msg.setGatewayId("*");
                        pst.setString(1, "*");
                        JDSMSServer.getInstance().userConsolePrint("x", "update gateway from " + gateway_id + " to *");
                    } else {
                        msg.setGatewayId(gateway_id);
                        pst.setString(1, gateway_id);
                    }
                } else {
                    msg.setGatewayId(gateway_id);
                }
                JDSMSServer.getInstance().userConsolePrint("m", "*check message: gateid=" + msg.getGatewayId() + " msgid=" + rs.getInt("id"));
                msgList.add(msg);
                this.getMessageCache().put(msg.getMessageId(), rs.getInt("id"));
                if (!"*".equals(flag)) {
                    pst.setInt(2, rs.getInt("id"));
                } else {
                    pst.setInt(1, rs.getInt("id"));
                }
                pst.addBatch();
                ++msgCount;
            }
            updateStatement.executeBatch();
            pst.executeBatch();
            rs.close();
            cmd.close();
            pst.close();
            updateStatement.close();
        }
        catch (Exception e3) {
            try {
                if (con != null) {
                    con.close();
                }
                this.a(con);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Logger.getInstance().logError(String.format("SQL failure, will retry in %d seconds...", this.a * 1), e3, null);
            Thread.sleep(this.a * 1000);
            this.a *= 2;
            if (this.a == 64) {
                this.a = 1;
            }
        }
        finally {
            SysLock.getInstance().setbusy(false);
            this.a(con);
        }
        SysLock.getInstance().setbusy(false);
        return msgList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<OutboundMessage> getMessagesToSend4Gateway() throws Exception {
        while (!SysLock.getInstance().canUse()) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e2) {
                e2.printStackTrace();
            }
        }
        Connection con = null;
        ArrayList<OutboundMessage> msgList = new ArrayList<OutboundMessage>();
        boolean isOracle = false;
        if (JDSMSServer.getInstance().getProperties().getString("db1.type", "mysql").equals("oracle")) {
            isOracle = true;
        }
        boolean isMssql = false;
        if (JDSMSServer.getInstance().getProperties().getString("db1.type", "mysql").equals("mssql")) {
            isMssql = true;
        }
        boolean isPG = false;
        if (JDSMSServer.getInstance().getProperties().getString("db1.type", "mysql").equals("postgresql")) {
            isPG = true;
        }
        String device_using = JDSMSServer.getInstance().getProperties().getString("settings.device_using", "yes");
        String phone_using = JDSMSServer.getInstance().getProperties().getString("settings.phone_using", "yes");
        String gateway_using = JDSMSServer.getInstance().getProperties().getString("settings.gateway_using", "yes");
        String flag = this.c();
        int retryMaxNum = 0;
        if (phone_using.equals("yes")) {
            ++retryMaxNum;
        }
        if (device_using.equals("yes")) {
            ++retryMaxNum;
        }
        if (gateway_using.equals("yes")) {
            ++retryMaxNum;
        }
        retryMaxNum *= 3;
        try {
            PreparedStatement pst;
            ResultSet rs = null;
            int msgCount = 1;
            con = this.a();
            Statement cmd = con.createStatement(1005, 1008);
            if (!"#".equals(flag)) {
                pst = con.prepareStatement("update " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " set status = 'Q',errors=?,gateway_id=? where id = ? ");
                JDSMSServer.getInstance().userConsolePrint("x", "send4gate update1: update " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " set status = 'Q',errors=?,gateway_id=? where id = ? ");
            } else {
                pst = con.prepareStatement("update " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " set status = 'Q' where id = ? ");
                JDSMSServer.getInstance().userConsolePrint("x", "send4gate update2: update " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " set status = 'Q' where id = ? ");
            }
            int retryNum = Integer.parseInt(this.getProperty("retries", "2"));
            String sqlSelect = "";
            if ("#".equals(flag)) {
                if (isOracle) {
                    sqlSelect = "select * from " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " where status = 'U' and (gateway_id='md' or gateway_id='#') and rownum <= %size% order by priority desc, id";
                    sqlSelect = sqlSelect.replaceAll("%size%", "" + Integer.parseInt(this.getProperty("batch_size", "50")));
                } else if (isMssql) {
                    sqlSelect = "select top %size% * from " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " where status = 'U' and (gateway_id='md' or gateway_id='#') order by priority desc, id";
                    sqlSelect = sqlSelect.replaceAll("%size%", "" + Integer.parseInt(this.getProperty("batch_size", "50")));
                } else if (isPG) {
                    sqlSelect = "select * from " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " where status = 'U' and (gateway_id='md' or gateway_id='#') order by priority desc, id limit %size% offset %begin%";
                    sqlSelect = sqlSelect.replaceAll("%begin%", "0");
                    sqlSelect = sqlSelect.replaceAll("%size%", "" + Integer.parseInt(this.getProperty("batch_size", "50")));
                } else {
                    sqlSelect = "select * from " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " where status = 'U' and (gateway_id='md' or gateway_id='#') order by priority desc, id limit %begin% , %size%";
                    sqlSelect = sqlSelect.replaceAll("%begin%", "0");
                    sqlSelect = sqlSelect.replaceAll("%size%", "" + Integer.parseInt(this.getProperty("batch_size", "50")));
                }
                JDSMSServer.getInstance().userConsolePrint("x", "get send4gate1:" + sqlSelect);
                rs = cmd.executeQuery(sqlSelect);
            }
            if (!"#".equals(flag)) {
                if (isOracle) {
                    sqlSelect = "select * from " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " where (status = 'F' and (gateway_id='*' or gateway_id = '$') and errors>'" + retryNum + "' and errors<'" + retryMaxNum + "') or (status = 'U' and (gateway_id='md' or gateway_id='#')) and rownum <= %size% order by priority desc, id";
                    sqlSelect = sqlSelect.replaceAll("%size%", "" + Integer.parseInt(this.getProperty("batch_size", "50")));
                } else if (isMssql) {
                    sqlSelect = "select top %size% * from " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " where (status = 'F' and (gateway_id='*' or gateway_id = '$') and errors>'" + retryNum + "' and errors<'" + retryMaxNum + "') or (status = 'U' and (gateway_id='md' or gateway_id='#')) order by priority desc, id";
                    sqlSelect = sqlSelect.replaceAll("%size%", "" + Integer.parseInt(this.getProperty("batch_size", "50")));
                } else if (isPG) {
                    sqlSelect = "select * from " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " where (status = 'F' and (gateway_id='*' or gateway_id = '$') and errors>'" + retryNum + "' and errors<'" + retryMaxNum + "') or (status = 'U' and (gateway_id='md' or gateway_id='#')) order by priority desc, id limit %size% offset %begin%";
                    sqlSelect = sqlSelect.replaceAll("%begin%", "0");
                    sqlSelect = sqlSelect.replaceAll("%size%", "" + Integer.parseInt(this.getProperty("batch_size", "50")));
                } else {
                    sqlSelect = "select * from " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " where (status = 'F' and (gateway_id='*' or gateway_id = '$') and errors>'" + retryNum + "' and errors<'" + retryMaxNum + "') or (status = 'U' and (gateway_id='md' or gateway_id='#')) order by priority desc, id limit %begin% , %size%";
                    sqlSelect = sqlSelect.replaceAll("%begin%", "0");
                    sqlSelect = sqlSelect.replaceAll("%size%", "" + Integer.parseInt(this.getProperty("batch_size", "50")));
                }
                JDSMSServer.getInstance().userConsolePrint("x", "get send4gate2:" + sqlSelect);
                rs = cmd.executeQuery(sqlSelect);
            }
            PreparedStatement updateStatement = con.prepareStatement("update " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " set status = 'F',sent_date=? where id = ? ");
            while (rs.next() && msgCount <= Integer.parseInt(this.getProperty("batch_size", "50"))) {
                OutboundMessage msg;
                if (!this.getServer().checkPriorityTimeFrame(rs.getInt("priority"))) continue;
                String recipient = rs.getString("recipient");
                if (StringUtils.isEmpty((CharSequence)recipient) || !recipient.matches("\\+?\\d{1,25}")) {
                    updateStatement.setTimestamp(1, new Timestamp(System.currentTimeMillis()));
                    updateStatement.setLong(2, rs.getLong("id"));
                    updateStatement.addBatch();
                    continue;
                }
                if (rs.getTimestamp("sent_date") != null && System.currentTimeMillis() < rs.getTimestamp("sent_date").getTime()) continue;
                switch (rs.getString("type").charAt(0)) {
                    case 'O': {
                        switch (rs.getString("encoding").charAt(0)) {
                            case '7': {
                                msg = new OutboundMessage(rs.getString("recipient").trim(), rs.getString("text").trim());
                                msg.setEncoding(Message.MessageEncodings.ENC7BIT);
                                break;
                            }
                            case '8': {
                                String text = rs.getString("text").trim();
                                byte[] bytes = new byte[text.length() / 2];
                                for (int i2 = 0; i2 < text.length(); i2 += 2) {
                                    int value = Integer.parseInt("" + text.charAt(i2), 16) * 16 + Integer.parseInt("" + text.charAt(i2 + 1), 16);
                                    bytes[i2 / 2] = (byte)value;
                                }
                                msg = new OutboundBinaryMessage(rs.getString("recipient").trim(), bytes);
                                break;
                            }
                            case 'U': {
                                msg = new OutboundMessage(rs.getString("recipient").trim(), rs.getString("text").trim());
                                msg.setEncoding(Message.MessageEncodings.ENCUCS2);
                                break;
                            }
                            default: {
                                msg = new OutboundMessage(rs.getString("recipient").trim(), rs.getString("text").trim());
                                msg.setEncoding(Message.MessageEncodings.ENC7BIT);
                            }
                        }
                        if (rs.getInt("flash_sms") == 1) {
                            msg.setFlashSms(true);
                        }
                        if (rs.getInt("src_port") == -1) break;
                        msg.setSrcPort(rs.getInt("src_port"));
                        msg.setDstPort(rs.getInt("dst_port"));
                        break;
                    }
                    case 'W': {
                        OutboundWapSIMessage.WapSISignals wapSignal;
                        Date wapExpiryDate;
                        if (rs.getTime("wap_expiry_date") == null) {
                            Calendar cal = Calendar.getInstance();
                            cal.setTime(new Date());
                            cal.add(6, 7);
                            wapExpiryDate = cal.getTime();
                        } else {
                            wapExpiryDate = rs.getTimestamp("wap_expiry_date");
                        }
                        if (rs.getString("wap_signal") == null) {
                            wapSignal = OutboundWapSIMessage.WapSISignals.NONE;
                        } else {
                            switch (rs.getString("wap_signal").charAt(0)) {
                                case 'N': {
                                    wapSignal = OutboundWapSIMessage.WapSISignals.NONE;
                                    break;
                                }
                                case 'L': {
                                    wapSignal = OutboundWapSIMessage.WapSISignals.LOW;
                                    break;
                                }
                                case 'M': {
                                    wapSignal = OutboundWapSIMessage.WapSISignals.MEDIUM;
                                    break;
                                }
                                case 'H': {
                                    wapSignal = OutboundWapSIMessage.WapSISignals.HIGH;
                                    break;
                                }
                                case 'D': {
                                    wapSignal = OutboundWapSIMessage.WapSISignals.DELETE;
                                    break;
                                }
                                default: {
                                    wapSignal = OutboundWapSIMessage.WapSISignals.NONE;
                                }
                            }
                        }
                        msg = new OutboundWapSIMessage(rs.getString("recipient").trim(), new URL(rs.getString("wap_url").trim()), rs.getString("text").trim(), wapExpiryDate, wapSignal);
                        break;
                    }
                    default: {
                        throw new Exception("Message type '" + rs.getString("type") + "' is unknown!");
                    }
                }
                msg.setPriority(rs.getInt("priority"));
                if (rs.getInt("status_report") == 1) {
                    msg.setStatusReport(true);
                }
                if (rs.getString("originator") != null && rs.getString("originator").length() > 0) {
                    msg.setFrom(rs.getString("originator").trim());
                }
                String gateway_id = rs.getString("gateway_id").trim();
                if (!"#".equals(flag)) {
                    if ("*".equals(gateway_id) || "$".equals(gateway_id)) {
                        pst.setInt(1, rs.getInt("errors"));
                        pst.setString(2, "#");
                        msg.setGatewayId("#");
                        JDSMSServer.getInstance().userConsolePrint("x", "update gateway from " + gateway_id + " to #");
                    } else {
                        pst.setInt(1, rs.getInt("errors"));
                        pst.setString(2, gateway_id);
                        msg.setGatewayId(gateway_id);
                    }
                    pst.setInt(3, rs.getInt("id"));
                } else {
                    msg.setGatewayId(gateway_id);
                    pst.setInt(1, rs.getInt("id"));
                }
                JDSMSServer.getInstance().userConsolePrint("m", "#check message: gateid=" + msg.getGatewayId() + " msgid=" + rs.getInt("id"));
                msgList.add(msg);
                this.getMessageCache().put(msg.getMessageId(), rs.getInt("id"));
                pst.addBatch();
                ++msgCount;
            }
            updateStatement.executeBatch();
            pst.executeBatch();
            rs.close();
            cmd.close();
            pst.close();
            updateStatement.close();
        }
        catch (Exception e3) {
            try {
                if (con != null) {
                    con.close();
                }
                this.a(con);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Logger.getInstance().logError(String.format("SQL failure, will retry in %d seconds...", this.a * 1), e3, null);
            Thread.sleep(this.a * 1000);
            this.a *= 2;
            if (this.a == 64) {
                this.a = 1;
            }
        }
        finally {
            SysLock.getInstance().setbusy(false);
            this.a(con);
        }
        SysLock.getInstance().setbusy(false);
        return msgList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<OutboundMessage> getMessagesToSend4Phone() throws Exception {
        int phoneCount;
        while (!SysLock.getInstance().canUse()) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e2) {
                e2.printStackTrace();
            }
        }
        Connection con = null;
        ArrayList<OutboundMessage> msgList = new ArrayList<OutboundMessage>();
        boolean isOracle = false;
        if (JDSMSServer.getInstance().getProperties().getString("db1.type", "mysql").equals("oracle")) {
            isOracle = true;
        }
        boolean isMssql = false;
        if (JDSMSServer.getInstance().getProperties().getString("db1.type", "mysql").equals("mssql")) {
            isMssql = true;
        }
        boolean isPG = false;
        if (JDSMSServer.getInstance().getProperties().getString("db1.type", "mysql").equals("postgresql")) {
            isPG = true;
        }
        List<String> phoneNoList = PhoneInfoCache.getInstance().getUsingPhoneNos();
        int tmpCount = phoneCount = phoneNoList.size();
        if (0 == phoneCount) {
            tmpCount = 1;
        }
        if (PhoneInfoCache.getInstance().getMessagesCounts() >= tmpCount * Integer.parseInt(this.getProperty("phone_message_size", "50"))) {
            phoneNoList.clear();
            SysLock.getInstance().setbusy(false);
            return msgList;
        }
        boolean noPhones = false;
        if (0 == PhoneInfoCache.getInstance().getRealUsingPhones().size()) {
            noPhones = true;
        }
        String device_using = JDSMSServer.getInstance().getProperties().getString("settings.device_using", "yes");
        String phone_using = JDSMSServer.getInstance().getProperties().getString("settings.phone_using", "yes");
        String gateway_using = JDSMSServer.getInstance().getProperties().getString("settings.gateway_using", "yes");
        String flag = this.c();
        int retryMaxNum = 0;
        if (device_using.equals("yes")) {
            ++retryMaxNum;
        }
        if (gateway_using.equals("yes")) {
            ++retryMaxNum;
        }
        if (phone_using.equals("yes")) {
            ++retryMaxNum;
        }
        retryMaxNum *= 3;
        try {
            PreparedStatement pst;
            ResultSet rs = null;
            int msgCount = 1;
            con = this.a();
            Statement cmd = con.createStatement(1005, 1008);
            if (!"$".equals(flag)) {
                pst = con.prepareStatement("update " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " set status = 'Q',errors=?,gateway_id=? where id = ? ");
                JDSMSServer.getInstance().userConsolePrint("x", "send4phone update1: update " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " set status = 'Q',errors=?,gateway_id=? where id = ? ");
            } else {
                pst = con.prepareStatement("update " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " set status = 'Q' where id = ? ");
                JDSMSServer.getInstance().userConsolePrint("x", "send4phone update2: update " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " set status = 'Q' where id = ? ");
            }
            String sqlSelect = "";
            int retryNum = Integer.parseInt(this.getProperty("retries", "2"));
            if ("$".equals(flag)) {
                if (isOracle) {
                    sqlSelect = "select * from " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " where status = 'U' and (gateway_id= '$' or (gateway_id <> '*' and gateway_id <> '#' and gateway_id <> 'md' and gateway_id not like 'modem%' and gateway_id <> '@' and gateway_id not like 'lora%' and gateway_id <> '~' and gateway_id not like 'nbiot%' and gateway_id <> '-' and gateway_id not like 'BD%')) and rownum <= %size% order by priority desc, id";
                    sqlSelect = sqlSelect.replaceAll("%size%", "" + phoneCount * Integer.parseInt(this.getProperty("phone_message_size", "50")));
                } else if (isMssql) {
                    sqlSelect = "select top %size% * from " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " where status = 'U' and (gateway_id= '$' or (gateway_id <> '*' and gateway_id <> '#' and gateway_id <> 'md' and gateway_id not like 'modem%' and gateway_id <> '@' and gateway_id not like 'lora%' and gateway_id <> '~' and gateway_id not like 'nbiot%' and gateway_id <> '-' and gateway_id not like 'BD%')) order by priority desc, id";
                    sqlSelect = sqlSelect.replaceAll("%size%", "" + phoneCount * Integer.parseInt(this.getProperty("phone_message_size", "50")));
                } else if (isPG) {
                    sqlSelect = "select * from " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " where status = 'U' and (gateway_id= '$' or (gateway_id <> '*' and gateway_id <> '#' and gateway_id <> 'md' and gateway_id not like 'modem%' and gateway_id <> '@' and gateway_id not like 'lora%' and gateway_id <> '~' and gateway_id not like 'nbiot%' and gateway_id <> '-' and gateway_id not like 'BD%')) order by priority desc, id limit %size% offset %begin%";
                    sqlSelect = sqlSelect.replaceAll("%begin%", "0");
                    sqlSelect = sqlSelect.replaceAll("%size%", "" + Integer.parseInt(this.getProperty("batch_size", "50")));
                } else {
                    sqlSelect = "select * from " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " where status = 'U' and (gateway_id= '$' or (gateway_id <> '*' and gateway_id <> '#' and gateway_id <> 'md' and gateway_id not like 'modem%' and gateway_id <> '@' and gateway_id not like 'lora%' and gateway_id <> '~' and gateway_id not like 'nbiot%' and gateway_id <> '-' and gateway_id not like 'BD%')) order by priority desc, id limit %begin% , %size%";
                    sqlSelect = sqlSelect.replaceAll("%begin%", "0");
                    sqlSelect = sqlSelect.replaceAll("%size%", "" + phoneCount * Integer.parseInt(this.getProperty("phone_message_size", "50")));
                }
                JDSMSServer.getInstance().userConsolePrint("x", "get send4phone1:" + sqlSelect);
                rs = cmd.executeQuery(sqlSelect);
            }
            if (!"$".equals(flag)) {
                if (isOracle) {
                    sqlSelect = "select * from " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " where (status = 'F' and (gateway_id = '*' or gateway_id = '#') and errors>'" + retryNum + "'and errors<'" + retryMaxNum + "') or (status = 'U' and (gateway_id= '$' or (gateway_id <> '*' and gateway_id <> '#' and gateway_id <> 'md' and gateway_id not like 'modem%' and gateway_id <> '@' and gateway_id not like 'lora%' and gateway_id <> '~' and gateway_id not like 'nbiot%' and gateway_id <> '-' and gateway_id not like 'BD%'))) and rownum <= %size% order by priority desc, id";
                    sqlSelect = sqlSelect.replaceAll("%size%", "" + phoneCount * Integer.parseInt(this.getProperty("phone_message_size", "50")));
                } else if (isMssql) {
                    sqlSelect = "select top %size% * from " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " where (status = 'F' and (gateway_id = '*' or gateway_id = '#') and errors>'" + retryNum + "'and errors<'" + retryMaxNum + "') or (status = 'U' and (gateway_id= '$' or (gateway_id <> '*' and gateway_id <> '#' and gateway_id <> 'md' and gateway_id not like 'modem%' and gateway_id <> '@' and gateway_id not like 'lora%' and gateway_id <> '~' and gateway_id not like 'nbiot%' and gateway_id <> '-' and gateway_id not like 'BD%'))) order by priority desc, id";
                    sqlSelect = sqlSelect.replaceAll("%size%", "" + phoneCount * Integer.parseInt(this.getProperty("phone_message_size", "50")));
                } else if (isPG) {
                    sqlSelect = "select * from " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " where (status = 'F' and (gateway_id = '*' or gateway_id = '#') and errors>'" + retryNum + "'and errors<'" + retryMaxNum + "') or (status = 'U' and (gateway_id= '$' or (gateway_id <> '*' and gateway_id <> '#' and gateway_id <> 'md' and gateway_id not like 'modem%' and gateway_id <> '@' and gateway_id not like 'lora%' and gateway_id <> '~' and gateway_id not like 'nbiot%' and gateway_id <> '-' and gateway_id not like 'BD%'))) order by priority desc, id limit %size% offset %begin%";
                    sqlSelect = sqlSelect.replaceAll("%begin%", "0");
                    sqlSelect = sqlSelect.replaceAll("%size%", "" + Integer.parseInt(this.getProperty("batch_size", "50")));
                } else {
                    sqlSelect = "select * from " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " where (status = 'F' and (gateway_id = '*' or gateway_id = '#') and errors>'" + retryNum + "'and errors<'" + retryMaxNum + "') or (status = 'U' and (gateway_id= '$' or (gateway_id <> '*' and gateway_id <> '#' and gateway_id <> 'md' and gateway_id not like 'modem%' and gateway_id <> '@' and gateway_id not like 'lora%' and gateway_id <> '~' and gateway_id not like 'nbiot%' and gateway_id <> '-' and gateway_id not like 'BD%'))) order by priority desc, id limit %begin% , %size%";
                    sqlSelect = sqlSelect.replaceAll("%begin%", "0");
                    sqlSelect = sqlSelect.replaceAll("%size%", "" + phoneCount * Integer.parseInt(this.getProperty("phone_message_size", "50")));
                }
                JDSMSServer.getInstance().userConsolePrint("x", "get send4phone2:" + sqlSelect);
                rs = cmd.executeQuery(sqlSelect);
            }
            PreparedStatement updateStatement = con.prepareStatement("update " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " set status = 'F',sent_date=? where id = ? ");
            while (rs.next() && msgCount <= tmpCount * Integer.parseInt(this.getProperty("phone_message_size"))) {
                OutboundMessage msg;
                if (!this.getServer().checkPriorityTimeFrame(rs.getInt("priority"))) continue;
                String recipient = rs.getString("recipient");
                if (StringUtils.isEmpty((CharSequence)recipient) || !recipient.matches("\\+?\\d{1,25}")) {
                    updateStatement.setTimestamp(1, new Timestamp(System.currentTimeMillis()));
                    updateStatement.setLong(2, rs.getLong("id"));
                    updateStatement.addBatch();
                    continue;
                }
                if (rs.getTimestamp("sent_date") != null && System.currentTimeMillis() < rs.getTimestamp("sent_date").getTime()) continue;
                switch (rs.getString("type").charAt(0)) {
                    case 'O': {
                        switch (rs.getString("encoding").charAt(0)) {
                            case '7': {
                                msg = new OutboundMessage(rs.getString("recipient").trim(), rs.getString("text").trim());
                                msg.setEncoding(Message.MessageEncodings.ENC7BIT);
                                break;
                            }
                            case '8': {
                                String text = rs.getString("text").trim();
                                byte[] bytes = new byte[text.length() / 2];
                                for (int i2 = 0; i2 < text.length(); i2 += 2) {
                                    int value = Integer.parseInt("" + text.charAt(i2), 16) * 16 + Integer.parseInt("" + text.charAt(i2 + 1), 16);
                                    bytes[i2 / 2] = (byte)value;
                                }
                                msg = new OutboundBinaryMessage(rs.getString("recipient").trim(), bytes);
                                break;
                            }
                            case 'U': {
                                msg = new OutboundMessage(rs.getString("recipient").trim(), rs.getString("text").trim());
                                msg.setEncoding(Message.MessageEncodings.ENCUCS2);
                                break;
                            }
                            default: {
                                msg = new OutboundMessage(rs.getString("recipient").trim(), rs.getString("text").trim());
                                msg.setEncoding(Message.MessageEncodings.ENC7BIT);
                            }
                        }
                        if (rs.getInt("flash_sms") == 1) {
                            msg.setFlashSms(true);
                        }
                        if (rs.getInt("src_port") == -1) break;
                        msg.setSrcPort(rs.getInt("src_port"));
                        msg.setDstPort(rs.getInt("dst_port"));
                        break;
                    }
                    case 'W': {
                        OutboundWapSIMessage.WapSISignals wapSignal;
                        Date wapExpiryDate;
                        if (rs.getTime("wap_expiry_date") == null) {
                            Calendar cal = Calendar.getInstance();
                            cal.setTime(new Date());
                            cal.add(6, 7);
                            wapExpiryDate = cal.getTime();
                        } else {
                            wapExpiryDate = rs.getTimestamp("wap_expiry_date");
                        }
                        if (rs.getString("wap_signal") == null) {
                            wapSignal = OutboundWapSIMessage.WapSISignals.NONE;
                        } else {
                            switch (rs.getString("wap_signal").charAt(0)) {
                                case 'N': {
                                    wapSignal = OutboundWapSIMessage.WapSISignals.NONE;
                                    break;
                                }
                                case 'L': {
                                    wapSignal = OutboundWapSIMessage.WapSISignals.LOW;
                                    break;
                                }
                                case 'M': {
                                    wapSignal = OutboundWapSIMessage.WapSISignals.MEDIUM;
                                    break;
                                }
                                case 'H': {
                                    wapSignal = OutboundWapSIMessage.WapSISignals.HIGH;
                                    break;
                                }
                                case 'D': {
                                    wapSignal = OutboundWapSIMessage.WapSISignals.DELETE;
                                    break;
                                }
                                default: {
                                    wapSignal = OutboundWapSIMessage.WapSISignals.NONE;
                                }
                            }
                        }
                        msg = new OutboundWapSIMessage(rs.getString("recipient").trim(), new URL(rs.getString("wap_url").trim()), rs.getString("text").trim(), wapExpiryDate, wapSignal);
                        break;
                    }
                    default: {
                        throw new Exception("Message type '" + rs.getString("type") + "' is unknown!");
                    }
                }
                msg.setPriority(rs.getInt("priority"));
                if (rs.getInt("status_report") == 1) {
                    msg.setStatusReport(true);
                }
                if (rs.getString("originator") != null && rs.getString("originator").length() > 0) {
                    msg.setFrom(rs.getString("originator").trim());
                }
                String gateway_id = rs.getString("gateway_id").trim();
                if (!"$".equals(flag)) {
                    if ("*".equals(gateway_id) || "#".equals(gateway_id)) {
                        pst.setInt(1, rs.getInt("errors"));
                        pst.setString(2, "$");
                        msg.setGatewayId("$");
                        JDSMSServer.getInstance().userConsolePrint("x", "update gateway from " + gateway_id + " to $");
                    } else {
                        pst.setInt(1, rs.getInt("errors"));
                        pst.setString(2, gateway_id);
                        msg.setGatewayId(gateway_id);
                    }
                    pst.setInt(3, rs.getInt("id"));
                } else {
                    msg.setGatewayId(gateway_id);
                    pst.setInt(1, rs.getInt("id"));
                }
                if (!noPhones) {
                    String phoneNo = phoneNoList.get((msgCount - 1) % phoneCount);
                    String serialnum = PhoneInfoCache.getInstance().getUsingPhoneIMEI(phoneNo);
                    boolean flagR = NewAuth.checkDeviceAuth(serialnum);
                    if (!flagR) {
                        msg.setText("<\u8bf7\u586b\u5199\u8bbe\u5907\u6ce8\u518c\u7801>" + msg.getText());
                        int num = NewAuth.getAvaliableNum(serialnum);
                        if (num < 1) {
                            Logger.getInstance().logWarn("\u624b\u673a\u672a\u6388\u6743\uff0c\u6536\u53d1\u77ed\u4fe1\u6761\u6570\u5df2\u8fbe\u5230\u6700\u5927\u9650\u5236\u657088\u6761,\u5df2\u505c\u6b62\u6536\u53d1\u77ed\u4fe1", null, phoneNo);
                            PhoneInfoCache.getInstance().setRealUsingPhoneFlag(phoneNo, "0");
                            rs.close();
                            cmd.close();
                            pst.close();
                            break;
                        }
                    }
                }
                if (noPhones) {
                    ArrayList<OutboundMessage> arrayList = msgList;
                    return arrayList;
                }
                JDSMSServer.getInstance().userConsolePrint("m", "$check message: gateid=" + msg.getGatewayId() + " msgid=" + rs.getInt("id"));
                msgList.add(msg);
                this.getMessageCache().put(msg.getMessageId(), rs.getInt("id"));
                pst.addBatch();
                ++msgCount;
            }
            updateStatement.executeBatch();
            pst.executeBatch();
            rs.close();
            cmd.close();
            pst.close();
            updateStatement.close();
        }
        catch (Exception e3) {
            Logger.getInstance().logError(String.format("SQL failure, will retry in %d seconds...", this.a * 1), e3, null);
            Thread.sleep(this.a * 1000);
            this.a *= 2;
            if (this.a == 64) {
                this.a = 1;
            }
        }
        finally {
            SysLock.getInstance().setbusy(false);
            this.a(con);
        }
        phoneNoList.clear();
        SysLock.getInstance().setbusy(false);
        return msgList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getPendingMessagesToSend() throws Exception {
        int count = -1;
        Connection con = null;
        Statement cmd = null;
        ResultSet rs = null;
        try {
            con = this.a();
            cmd = con.createStatement(1005, 1007);
            rs = cmd.executeQuery("select count(*) as cnt from " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " where status in ('U', 'Q')");
            if (rs.next()) {
                count = rs.getInt("cnt");
            }
        }
        catch (Exception e2) {
            Logger.getInstance().logError(String.format("SQL failure, will retry in %d seconds...", this.a * 1), e2, null);
            Thread.sleep(this.a * 1000);
            this.a *= 2;
            if (this.a == 64) {
                this.a = 1;
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (cmd != null) {
                cmd.close();
            }
            this.a(con);
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void markMessage(OutboundMessage msg) throws Exception {
        Connection con = null;
        if (this.getMessageCache().get(msg.getMessageId()) == null) {
            return;
        }
        try {
            int errors = 0;
            con = this.a();
            PreparedStatement selectStatement = con.prepareStatement("select errors,sent_date from " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " where id = ?");
            selectStatement.setInt(1, (Integer)this.getMessageCache().get(msg.getMessageId()));
            ResultSet rs = selectStatement.executeQuery();
            Timestamp sentTime = null;
            while (rs.next()) {
                errors = rs.getInt("errors");
                sentTime = rs.getTimestamp("sent_date");
            }
            rs.close();
            selectStatement.close();
            if (msg.getMessageStatus() == OutboundMessage.MessageStatuses.SENT) {
                PreparedStatement updateStatement = con.prepareStatement("update " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " set status = ?, sent_date = ?, gateway_id = ?, ref_no = ? where id = ?");
                updateStatement.setString(1, "S");
                updateStatement.setTimestamp(2, new Timestamp(msg.getDispatchDate().getTime()));
                updateStatement.setString(3, msg.getGatewayId());
                updateStatement.setString(4, msg.getRefNo());
                updateStatement.setInt(5, (Integer)this.getMessageCache().get(msg.getMessageId()));
                updateStatement.executeUpdate();
                updateStatement.close();
            } else if (msg.getMessageStatus() == OutboundMessage.MessageStatuses.UNSENT || msg.getMessageStatus() == OutboundMessage.MessageStatuses.FAILED && msg.getFailureCause() == OutboundMessage.FailureCauses.NO_ROUTE) {
                PreparedStatement updateStatement = con.prepareStatement("update " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " set status = ? where id = ?");
                updateStatement.setString(1, "U");
                updateStatement.setInt(2, (Integer)this.getMessageCache().get(msg.getMessageId()));
                updateStatement.executeUpdate();
                updateStatement.close();
            } else if (msg.getMessageStatus() == OutboundMessage.MessageStatuses.FAILED && msg.getSendFlag()) {
                PreparedStatement updateStatement = con.prepareStatement("update " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " set status = ?, errors = ?,sent_date=?, wap_url=? where id = ?");
                ++errors;
                int retryCounts = Integer.parseInt(this.getProperty("retries", "2"));
                while (0 != errors % (retryCounts + 1)) {
                    ++errors;
                }
                if (errors % (retryCounts + 1) == 0) {
                    updateStatement.setString(1, "F");
                    updateStatement.setTimestamp(3, new Timestamp(System.currentTimeMillis()));
                    updateStatement.setString(4, msg.getErrorMessage());
                } else {
                    updateStatement.setString(1, "U");
                    updateStatement.setTimestamp(3, sentTime);
                    updateStatement.setString(4, "");
                }
                updateStatement.setInt(2, errors);
                updateStatement.setInt(5, (Integer)this.getMessageCache().get(msg.getMessageId()));
                updateStatement.executeUpdate();
                updateStatement.close();
            } else {
                PreparedStatement updateStatement = con.prepareStatement("update " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " set status = ?, errors = ?,sent_date=?, wap_url=? where id = ?");
                if (++errors % (Integer.parseInt(this.getProperty("retries", "2")) + 1) == 0) {
                    updateStatement.setString(1, "F");
                    updateStatement.setTimestamp(3, new Timestamp(System.currentTimeMillis()));
                    updateStatement.setString(4, msg.getErrorMessage());
                } else {
                    updateStatement.setString(1, "U");
                    updateStatement.setTimestamp(3, sentTime);
                    updateStatement.setString(4, "");
                }
                updateStatement.setInt(2, errors);
                updateStatement.setInt(5, (Integer)this.getMessageCache().get(msg.getMessageId()));
                updateStatement.executeUpdate();
                updateStatement.close();
            }
        }
        catch (Exception e2) {
            try {
                if (con != null) {
                    con.close();
                }
                this.a(con);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Logger.getInstance().logError(String.format("SQL failure, will retry in %d seconds...", this.a * 1), e2, null);
            Thread.sleep(this.a * 1000);
            this.a *= 2;
            if (this.a == 64) {
                this.a = 1;
            }
        }
        finally {
            this.a(con);
        }
        this.getMessageCache().remove(msg.getMessageId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markMessages4GatewayFail(List<OutboundMessage> msgList) throws Exception {
        Connection con = null;
        PreparedStatement updateStatement = null;
        try {
            con = this.a();
            con.setAutoCommit(false);
            updateStatement = con.prepareStatement("update " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " set status = ?,gateway_id = ? where id = ?");
            for (int i2 = 0; i2 < msgList.size(); ++i2) {
                OutboundMessage msg = msgList.get(i2);
                if (this.getMessageCache().get(msg.getMessageId()) == null) continue;
                String device_using = JDSMSServer.getInstance().getProperties().getString("settings.device_using", "yes");
                String phone_using = JDSMSServer.getInstance().getProperties().getString("settings.phone_using", "yes");
                int isorted = Integer.parseInt(JDSMSServer.getInstance().getProperties().getString("settings.using_sorted", "0"));
                boolean foundOutboundGateway = false;
                for (AGateway gtw : Service.getInstance().getGateways()) {
                    if (!gtw.isOutbound() || gtw.getStatus() != AGatewayHelper.GatewayStatuses.STARTED) continue;
                    foundOutboundGateway = true;
                    break;
                }
                Iterator<AGateway> iter = null;
                switch (isorted) {
                    case 0: 
                    case 3: 
                    case 4: {
                        if (phone_using.equals("yes") && PhoneInfoCache.getInstance().getUsingPhones().size() > 0) {
                            updateStatement.setString(1, "U");
                            updateStatement.setString(2, "$");
                            break;
                        }
                        if (device_using.equals("yes") && foundOutboundGateway) {
                            updateStatement.setString(1, "U");
                            updateStatement.setString(2, "*");
                            break;
                        }
                        updateStatement.setString(1, "U");
                        updateStatement.setString(2, "#");
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 5: {
                        if (device_using.equals("yes") && foundOutboundGateway) {
                            updateStatement.setString(1, "U");
                            updateStatement.setString(2, "*");
                            break;
                        }
                        if (phone_using.equals("yes") && PhoneInfoCache.getInstance().getUsingPhones().size() > 0) {
                            updateStatement.setString(1, "U");
                            updateStatement.setString(2, "$");
                            break;
                        }
                        updateStatement.setString(1, "U");
                        updateStatement.setString(2, "#");
                        break;
                    }
                }
                updateStatement.setInt(3, (Integer)this.getMessageCache().get(msg.getMessageId()));
                updateStatement.addBatch();
                this.getMessageCache().remove(msg.getMessageId());
            }
            updateStatement.executeBatch();
            updateStatement.close();
        }
        catch (Exception e2) {
            try {
                con.rollback();
                if (con != null) {
                    con.close();
                }
                this.a(con);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Logger.getInstance().logError(String.format("SQL failure, will retry in %d seconds...", this.a * 1), e2, null);
            Thread.sleep(this.a * 1000);
            this.a *= 2;
            if (this.a == 64) {
                this.a = 1;
            }
        }
        finally {
            this.a(con);
        }
    }

    private Connection a() throws Exception {
        Connection conn = null;
        ConnectionPool connPool = ConnectionPool.getInstance();
        if (!connPool.isPoolCreate()) {
            connPool.createPool();
        }
        conn = connPool.getConnection();
        return conn;
    }

    private void a(Connection conn) {
        ConnectionPool connPool = ConnectionPool.getInstance();
        try {
            connPool.returnConnection(conn);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void b() {
        ConnectionPool connPool = ConnectionPool.getInstance();
        try {
            connPool.closeConnectionPool();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<OutboundMessage> getMessagesToSendLora() throws Exception {
        int count = 0;
        while (!SysLock.getInstance().canUse()) {
            try {
                Thread.sleep(50L);
                if (count++ <= 50) continue;
                Logger.getInstance().logError("\u81ea\u65cb\u7b49\u5f85\u8d85\u8fc72\u79d2", null, null);
            }
            catch (InterruptedException e2) {
                Logger.getInstance().logError("\u53d6\u5f85\u53d1\u77ed\u4fe1\u65f6\u4ea7\u751f\u4e2d\u65ad\u5f02\u5e38", e2, null);
            }
        }
        Connection con = null;
        ArrayList<OutboundMessage> msgList = new ArrayList<OutboundMessage>();
        boolean isOracle = false;
        if (JDSMSServer.getInstance().getProperties().getString("db1.type", "mysql").equals("oracle") || JDSMSServer.getInstance().getProperties().getString("db1.type", "mysql").equals("oracle-rac")) {
            isOracle = true;
        }
        boolean isMssql = false;
        if (JDSMSServer.getInstance().getProperties().getString("db1.type", "mysql").equals("mssql")) {
            isMssql = true;
        }
        boolean isPG = false;
        if (JDSMSServer.getInstance().getProperties().getString("db1.type", "mysql").equals("postgresql")) {
            isPG = true;
        }
        String lora_using = JDSMSServer.getInstance().getProperties().getString("settings.lora_using", "no");
        int retryNum = Integer.parseInt(this.getProperty("retries", "2"));
        try {
            ResultSet rs = null;
            int msgCount = 1;
            con = this.a();
            Statement cmd = con.createStatement(1005, 1008);
            if ("no".equals(lora_using)) {
                ArrayList<OutboundMessage> arrayList = msgList;
                return arrayList;
            }
            PreparedStatement pst = con.prepareStatement("update " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " set status = 'Q' where id = ? ");
            String sqlSelect = "";
            if (isOracle) {
                sqlSelect = "select * from " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " where (status = 'U' or (status = 'F' and errors < " + retryNum + ")) and (gateway_id = '@' or gateway_id like 'lora%') and rownum <= %size% order by priority desc, id";
                sqlSelect = sqlSelect.replaceAll("%size%", "" + Integer.parseInt(this.getProperty("batch_size", "50")));
            } else if (isMssql) {
                sqlSelect = "select top %size% * from " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " where (status = 'U' or (status = 'F' and errors < " + retryNum + ")) and (gateway_id = '@' or gateway_id like 'lora%') order by priority desc, id";
                sqlSelect = sqlSelect.replaceAll("%size%", "" + Integer.parseInt(this.getProperty("batch_size", "50")));
            } else if (isPG) {
                sqlSelect = "select * from " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " where (status = 'U' or (status = 'F' and errors < " + retryNum + ")) and (gateway_id = '@' or gateway_id like 'lora%') order by priority desc, id limit %size% offset %begin%";
                sqlSelect = sqlSelect.replaceAll("%begin%", "0");
                sqlSelect = sqlSelect.replaceAll("%size%", "" + Integer.parseInt(this.getProperty("batch_size", "50")));
            } else {
                sqlSelect = "select * from " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " where (status = 'U' or (status = 'F' and errors < " + retryNum + ")) and (gateway_id = '@' or gateway_id like 'lora%') order by priority desc, id limit %begin% , %size%";
                sqlSelect = sqlSelect.replaceAll("%begin%", "0");
                sqlSelect = sqlSelect.replaceAll("%size%", "" + Integer.parseInt(this.getProperty("batch_size", "50")));
            }
            JDSMSServer.getInstance().userConsolePrint("x", "get send lora:" + sqlSelect);
            rs = cmd.executeQuery(sqlSelect);
            if (rs == null) {
                Logger.getInstance().logError("\u914d\u7f6e\u6587\u4ef6\u8bbe\u5907\u6a21\u5f0f\u4e22\u5931,\u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6", null, null);
                ArrayList<OutboundMessage> arrayList = msgList;
                return arrayList;
            }
            Logger.getInstance().logDebug("sql\u67e5\u8be2=" + sqlSelect, null, null);
            PreparedStatement updateStatement = con.prepareStatement("update " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " set status = 'F',sent_date=? where id = ? ");
            while (rs.next() && msgCount <= Integer.parseInt(this.getProperty("batch_size", "50"))) {
                OutboundMessage msg;
                if (!this.getServer().checkPriorityTimeFrame(rs.getInt("priority"))) continue;
                String recipient = rs.getString("recipient");
                if (StringUtils.isEmpty((CharSequence)recipient) || recipient.length() != 4 || !recipient.matches("[A-F,a-f,0-9]+")) {
                    Logger.getInstance().logDebug("\u6536\u4fe1\u5730\u5740" + recipient + "\u4e0d\u5408\u6cd5!", null, null);
                    updateStatement.setTimestamp(1, new Timestamp(System.currentTimeMillis()));
                    updateStatement.setLong(2, rs.getLong("id"));
                    updateStatement.addBatch();
                    continue;
                }
                if (rs.getTimestamp("sent_date") != null && System.currentTimeMillis() < rs.getTimestamp("sent_date").getTime()) continue;
                switch (rs.getString("type").charAt(0)) {
                    case 'O': {
                        switch (rs.getString("encoding").charAt(0)) {
                            case '7': {
                                msg = new OutboundMessage(rs.getString("recipient").trim(), rs.getString("text").trim());
                                msg.setEncoding(Message.MessageEncodings.ENC7BIT);
                                break;
                            }
                            case '8': {
                                msg = new OutboundMessage(rs.getString("recipient").trim(), rs.getString("text").trim());
                                msg.setEncodingForOthers(Message.MessageEncodings.ENC8BIT);
                                break;
                            }
                            case 'U': {
                                msg = new OutboundMessage(rs.getString("recipient").trim(), rs.getString("text").trim());
                                msg.setEncoding(Message.MessageEncodings.ENCUCS2);
                                break;
                            }
                            default: {
                                msg = new OutboundMessage(rs.getString("recipient").trim(), rs.getString("text").trim());
                                msg.setEncoding(Message.MessageEncodings.ENCUCS2);
                            }
                        }
                        if (rs.getInt("flash_sms") == 1) {
                            msg.setFlashSms(true);
                        }
                        if (rs.getInt("src_port") == -1) break;
                        msg.setSrcPort(rs.getInt("src_port"));
                        msg.setDstPort(rs.getInt("dst_port"));
                        break;
                    }
                    case 'W': {
                        OutboundWapSIMessage.WapSISignals wapSignal;
                        Date wapExpiryDate;
                        if (rs.getTime("wap_expiry_date") == null) {
                            Calendar cal = Calendar.getInstance();
                            cal.setTime(new Date());
                            cal.add(6, 7);
                            wapExpiryDate = cal.getTime();
                        } else {
                            wapExpiryDate = rs.getTimestamp("wap_expiry_date");
                        }
                        if (rs.getString("wap_signal") == null) {
                            wapSignal = OutboundWapSIMessage.WapSISignals.NONE;
                        } else {
                            switch (rs.getString("wap_signal").charAt(0)) {
                                case 'N': {
                                    wapSignal = OutboundWapSIMessage.WapSISignals.NONE;
                                    break;
                                }
                                case 'L': {
                                    wapSignal = OutboundWapSIMessage.WapSISignals.LOW;
                                    break;
                                }
                                case 'M': {
                                    wapSignal = OutboundWapSIMessage.WapSISignals.MEDIUM;
                                    break;
                                }
                                case 'H': {
                                    wapSignal = OutboundWapSIMessage.WapSISignals.HIGH;
                                    break;
                                }
                                case 'D': {
                                    wapSignal = OutboundWapSIMessage.WapSISignals.DELETE;
                                    break;
                                }
                                default: {
                                    wapSignal = OutboundWapSIMessage.WapSISignals.NONE;
                                }
                            }
                        }
                        msg = new OutboundWapSIMessage(rs.getString("recipient").trim(), new URL(rs.getString("wap_url").trim()), rs.getString("text").trim(), wapExpiryDate, wapSignal);
                        break;
                    }
                    default: {
                        throw new Exception("Message type '" + rs.getString("type") + "' is unknown!");
                    }
                }
                msg.setPriority(rs.getInt("priority"));
                if (rs.getInt("status_report") == 1) {
                    msg.setStatusReport(true);
                }
                if (rs.getString("originator") != null && rs.getString("originator").length() > 0) {
                    msg.setFrom(rs.getString("originator").trim());
                }
                String gateway_id = rs.getString("gateway_id").trim();
                int messageID = rs.getInt("id");
                pst.setInt(1, messageID);
                msg.setGatewayId(gateway_id);
                int messageIDModefied = rs.getInt("id") + 100;
                if (messageIDModefied > Integer.MAX_VALUE) {
                    Logger.getInstance().logError("\u5df2\u7ecf\u5230\u8fc7\u6570\u636e\u5e93\u6700\u5927\u5bb9\u91cf\uff0c\u8bf7\u66f4\u6362\u6570\u636e\u5e93\uff01", null, null);
                    continue;
                }
                msg.setMessageID(messageIDModefied);
                JDSMSServer.getInstance().userConsolePrint("x", "@check message: gateid=" + msg.getGatewayId() + " msgid=" + rs.getInt("id"));
                msgList.add(msg);
                this.getMessageCache().put(msg.getMessageId(), rs.getInt("id"));
                pst.addBatch();
                ++msgCount;
            }
            updateStatement.executeBatch();
            pst.executeBatch();
            rs.close();
            cmd.close();
            pst.close();
            updateStatement.close();
        }
        catch (Exception e3) {
            try {
                if (con != null) {
                    con.close();
                }
                this.a(con);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Logger.getInstance().logError(String.format("SQL failure, will retry in %d seconds...", this.a * 1), e3, null);
            Thread.sleep(this.a * 1000);
            this.a *= 2;
            if (this.a == 64) {
                this.a = 1;
            }
        }
        finally {
            SysLock.getInstance().setbusy(false);
            this.a(con);
        }
        SysLock.getInstance().setbusy(false);
        return msgList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void LoRaMessagesReceived(Collection<InboundMessage> msgList) throws Exception {
        int count = 0;
        while (!SysLock.getInstance().canUse()) {
            try {
                Thread.sleep(50L);
                if (count++ <= 50) continue;
                Logger.getInstance().logError("\u81ea\u65cb\u7b49\u5f85\u8d85\u8fc72\u79d2", null, null);
            }
            catch (InterruptedException e2) {
                Logger.getInstance().logError("\u53d6\u5f85\u53d1\u77ed\u4fe1\u65f6\u4ea7\u751f\u4e2d\u65ad\u5f02\u5e38", e2, null);
            }
        }
        JDSMSServer.getInstance().userConsolePrint("x", "Database LoraMessagesReceiving...");
        Connection con = null;
        try {
            con = this.a();
            PreparedStatement pst = con.prepareStatement(" insert into " + this.getProperty("tables.sms_in", "jdsmsserver_in") + " (process, originator, type, encoding, message_date, receive_date, text, original_ref_no, original_receive_date, gateway_id)  values(?,?,?,?,?,?,?,?,?,?)");
            for (InboundMessage msg : msgList) {
                if (msg.isError()) {
                    Logger.getInstance().logInfo("\u4fe1\u606f\u3010" + msg.getText() + "\u3011\u4e0d\u5b8c\u6574\uff0c\u4e0d\u5165\u5e93\u3002", null, null);
                    continue;
                }
                if (msg.getType() != Message.MessageTypes.INBOUND) continue;
                pst.setInt(1, 0);
                switch (msg.getEncoding()) {
                    case ENC7BIT: {
                        pst.setString(4, "7");
                        break;
                    }
                    case ENC8BIT: {
                        pst.setString(4, "8");
                        break;
                    }
                    case ENCUCS2: {
                        pst.setString(4, "U");
                        break;
                    }
                    case ENCCUSTOM: {
                        pst.setString(4, "C");
                        break;
                    }
                    default: {
                        pst.setString(4, "U");
                    }
                }
                switch (msg.getType()) {
                    case INBOUND: {
                        pst.setString(3, "I");
                        pst.setString(2, msg.getOriginator());
                        pst.setTimestamp(5, new Timestamp(msg.getDate().getTime()));
                        pst.setString(8, null);
                        pst.setTimestamp(9, null);
                        break;
                    }
                }
                pst.setTimestamp(6, new Timestamp(new Date().getTime()));
                pst.setString(7, msg.getText().length() == 0 ? "" : msg.getText());
                String gatewayID = msg.getGatewayId();
                if (gatewayID == null || gatewayID.equals("")) {
                    gatewayID = "@";
                }
                pst.setString(10, gatewayID);
                pst.addBatch();
            }
            Iterator<InboundMessage> iterMessage = null;
            pst.executeBatch();
            pst.close();
        }
        catch (Exception e3) {
            try {
                if (con != null) {
                    con.close();
                }
                this.a(con);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Logger.getInstance().logError(String.format("SQL failure, will retry in %d seconds...", this.a * 1), e3, null);
            Thread.sleep(this.a * 1000);
            this.a *= 2;
            if (this.a == 64) {
                this.a = 1;
            }
        }
        finally {
            SysLock.getInstance().setbusy(false);
            this.a(con);
        }
        SysLock.getInstance().setbusy(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean a(Connection con, InboundMessage msg) {
        ResultSet rs = null;
        Statement pst = null;
        int count = 0;
        try {
            if (msg.getMessageID() == null || "".equals(msg.getMessageID())) {
                boolean bl = false;
                return bl;
            }
            pst = con.prepareStatement("select count(*) from " + this.getProperty("tables.sms_in", "jdsmsserver_in") + " where process = ?  and originator = ?");
            pst.setInt(1, Integer.valueOf(msg.getMessageID(), 16));
            pst.setString(2, msg.getOriginator());
            rs = pst.executeQuery();
            if (rs.next()) {
                count = rs.getInt(1);
            }
            rs.close();
            pst.close();
        }
        catch (Exception e2) {
            Logger.getInstance().logError("\u6570\u636e\u5e93\u8bbf\u95ee\u5f02\u5e38\uff01", e2, null);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e3) {
                Logger.getInstance().logError("\u8d44\u6e90\u91ca\u653e\u5931\u8d25(1)\uff01", e3, null);
                rs = null;
            }
            try {
                if (pst != null) {
                    pst.close();
                }
            }
            catch (SQLException e4) {
                Logger.getInstance().logError("\u8d44\u6e90\u91ca\u653e\u5931\u8d25\uff01(2)", e4, null);
                pst = null;
            }
        }
        return count > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<? extends OutboundMessage> getMessagesToSendNbIoT() throws Exception {
        int count = 0;
        while (!SysLock.getInstance().canUse()) {
            try {
                Thread.sleep(50L);
                if (count++ <= 50) continue;
                Logger.getInstance().logError("\u81ea\u65cb\u7b49\u5f85\u8d85\u8fc72\u79d2", null, null);
            }
            catch (InterruptedException e2) {
                Logger.getInstance().logError("\u53d6\u5f85\u53d1\u77ed\u4fe1\u65f6\u4ea7\u751f\u4e2d\u65ad\u5f02\u5e38", e2, null);
            }
        }
        Connection con = null;
        ArrayList<OutboundMessage> msgList = new ArrayList<OutboundMessage>();
        boolean isOracle = false;
        if (JDSMSServer.getInstance().getProperties().getString("db1.type", "mysql").equals("oracle") || JDSMSServer.getInstance().getProperties().getString("db1.type", "mysql").equals("oracle-rac")) {
            isOracle = true;
        }
        boolean isMssql = false;
        if (JDSMSServer.getInstance().getProperties().getString("db1.type", "mysql").equals("mssql")) {
            isMssql = true;
        }
        boolean isPG = false;
        if (JDSMSServer.getInstance().getProperties().getString("db1.type", "mysql").equals("postgresql")) {
            isPG = true;
        }
        String nbiot_using = JDSMSServer.getInstance().getProperties().getString("settings.nbiot_using", "no");
        int retryNum = Integer.parseInt(this.getProperty("retries", "2"));
        try {
            ResultSet rs = null;
            int msgCount = 1;
            con = this.a();
            Statement cmd = con.createStatement(1005, 1008);
            if ("no".equals(nbiot_using)) {
                ArrayList<OutboundMessage> arrayList = msgList;
                return arrayList;
            }
            PreparedStatement pst = con.prepareStatement("update " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " set status = 'Q' where id = ? ");
            String sqlSelect = "";
            if (isOracle) {
                sqlSelect = "select * from " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " where (status = 'U' or (status = 'F' and errors < " + retryNum + ")) and (gateway_id = '~' or gateway_id like 'nbiot%') and rownum <= %size% order by priority desc, id";
                sqlSelect = sqlSelect.replaceAll("%size%", "" + Integer.parseInt(this.getProperty("batch_size", "50")));
            } else if (isMssql) {
                sqlSelect = "select top %size% * from " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " where (status = 'U' or (status = 'F' and errors < " + retryNum + ")) and (gateway_id = '~' or gateway_id like 'nbiot%') order by priority desc, id";
                sqlSelect = sqlSelect.replaceAll("%size%", "" + Integer.parseInt(this.getProperty("batch_size", "50")));
            } else if (isPG) {
                sqlSelect = "select * from " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " where (status = 'U' or (status = 'F' and errors < " + retryNum + ")) and (gateway_id = '~' or gateway_id like 'nbiot%') order by priority desc, id limit %size% offset %begin%";
                sqlSelect = sqlSelect.replaceAll("%begin%", "0");
                sqlSelect = sqlSelect.replaceAll("%size%", "" + Integer.parseInt(this.getProperty("batch_size", "50")));
            } else {
                sqlSelect = "select * from " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " where (status = 'U' or (status = 'F' and errors < " + retryNum + ")) and (gateway_id = '~' or gateway_id like 'nbiot%') order by priority desc, id limit %begin% , %size%";
                sqlSelect = sqlSelect.replaceAll("%begin%", "0");
                sqlSelect = sqlSelect.replaceAll("%size%", "" + Integer.parseInt(this.getProperty("batch_size", "50")));
            }
            JDSMSServer.getInstance().userConsolePrint("x", "get send nbiot:" + sqlSelect);
            rs = cmd.executeQuery(sqlSelect);
            if (rs == null) {
                Logger.getInstance().logError("\u914d\u7f6e\u6587\u4ef6\u8bbe\u5907\u6a21\u5f0f\u4e22\u5931,\u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6", null, null);
                ArrayList<OutboundMessage> arrayList = msgList;
                return arrayList;
            }
            Logger.getInstance().logDebug("sql\u67e5\u8be2=" + sqlSelect, null, null);
            PreparedStatement updateStatement = con.prepareStatement("update " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " set status = 'F',sent_date=? where id = ? ");
            while (rs.next() && msgCount <= Integer.parseInt(this.getProperty("batch_size", "50"))) {
                OutboundMessage msg;
                if (!this.getServer().checkPriorityTimeFrame(rs.getInt("priority"))) continue;
                String recipient = rs.getString("recipient");
                if (StringUtils.isEmpty((CharSequence)recipient) || !recipient.matches("\\+?[a-zA-Z0-9]+")) {
                    Logger.getInstance().logDebug("\u6536\u4fe1\u5730\u5740" + recipient + "\u4e0d\u5408\u6cd5!", null, null);
                    updateStatement.setTimestamp(1, new Timestamp(System.currentTimeMillis()));
                    updateStatement.setLong(2, rs.getLong("id"));
                    updateStatement.addBatch();
                    continue;
                }
                if (rs.getTimestamp("sent_date") != null && System.currentTimeMillis() < rs.getTimestamp("sent_date").getTime()) continue;
                switch (rs.getString("type").charAt(0)) {
                    case 'O': {
                        switch (rs.getString("encoding").charAt(0)) {
                            case '8': {
                                msg = new OutboundMessage(rs.getString("recipient").trim(), rs.getString("text").trim());
                                msg.setEncodingForOthers(Message.MessageEncodings.ENC8BIT);
                                break;
                            }
                            case 'U': {
                                msg = new OutboundMessage(rs.getString("recipient").trim(), rs.getString("text").trim());
                                msg.setEncoding(Message.MessageEncodings.ENCUCS2);
                                break;
                            }
                            case 'S': {
                                msg = new OutboundMessage(rs.getString("recipient").trim(), rs.getString("text").trim());
                                msg.setEncoding(Message.MessageEncodings.SC);
                                break;
                            }
                            default: {
                                msg = new OutboundMessage(rs.getString("recipient").trim(), rs.getString("text").trim());
                                msg.setEncoding(Message.MessageEncodings.ENCUCS2);
                            }
                        }
                        if (rs.getInt("flash_sms") == 1) {
                            msg.setFlashSms(true);
                        }
                        if (rs.getInt("src_port") == -1) break;
                        msg.setSrcPort(rs.getInt("src_port"));
                        msg.setDstPort(rs.getInt("dst_port"));
                        break;
                    }
                    case 'W': {
                        OutboundWapSIMessage.WapSISignals wapSignal;
                        Date wapExpiryDate;
                        if (rs.getTime("wap_expiry_date") == null) {
                            Calendar cal = Calendar.getInstance();
                            cal.setTime(new Date());
                            cal.add(6, 7);
                            wapExpiryDate = cal.getTime();
                        } else {
                            wapExpiryDate = rs.getTimestamp("wap_expiry_date");
                        }
                        if (rs.getString("wap_signal") == null) {
                            wapSignal = OutboundWapSIMessage.WapSISignals.NONE;
                        } else {
                            switch (rs.getString("wap_signal").charAt(0)) {
                                case 'N': {
                                    wapSignal = OutboundWapSIMessage.WapSISignals.NONE;
                                    break;
                                }
                                case 'L': {
                                    wapSignal = OutboundWapSIMessage.WapSISignals.LOW;
                                    break;
                                }
                                case 'M': {
                                    wapSignal = OutboundWapSIMessage.WapSISignals.MEDIUM;
                                    break;
                                }
                                case 'H': {
                                    wapSignal = OutboundWapSIMessage.WapSISignals.HIGH;
                                    break;
                                }
                                case 'D': {
                                    wapSignal = OutboundWapSIMessage.WapSISignals.DELETE;
                                    break;
                                }
                                default: {
                                    wapSignal = OutboundWapSIMessage.WapSISignals.NONE;
                                }
                            }
                        }
                        msg = new OutboundWapSIMessage(rs.getString("recipient").trim(), new URL(rs.getString("wap_url").trim()), rs.getString("text").trim(), wapExpiryDate, wapSignal);
                        break;
                    }
                    default: {
                        throw new Exception("Message type '" + rs.getString("type") + "' is unknown!");
                    }
                }
                msg.setPriority(rs.getInt("priority"));
                if (rs.getInt("status_report") == 1) {
                    msg.setStatusReport(true);
                }
                if (rs.getString("originator") != null && rs.getString("originator").length() > 0) {
                    msg.setFrom(rs.getString("originator").trim());
                }
                String gateway_id = rs.getString("gateway_id").trim();
                int id = rs.getInt("id");
                pst.setInt(1, id);
                msg.setGatewayId(gateway_id);
                int messageID = rs.getInt("id") + 100;
                if (messageID > Integer.MAX_VALUE) {
                    Logger.getInstance().logError("\u5df2\u7ecf\u5230\u8fc7\u6570\u636e\u5e93\u6700\u5927\u5bb9\u91cf\uff0c\u8bf7\u66f4\u6362\u6570\u636e\u5e93\uff01", null, null);
                    continue;
                }
                msg.setMessageID(messageID);
                JDSMSServer.getInstance().userConsolePrint("x", "~check message: gateid=" + msg.getGatewayId() + " msgid=" + rs.getInt("id"));
                msgList.add(msg);
                this.getMessageCache().put(msg.getMessageId(), rs.getInt("id"));
                pst.addBatch();
                ++msgCount;
            }
            updateStatement.executeBatch();
            pst.executeBatch();
            rs.close();
            cmd.close();
            pst.close();
            updateStatement.close();
        }
        catch (Exception e3) {
            try {
                if (con != null) {
                    con.close();
                }
                this.a(con);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Logger.getInstance().logError(String.format("SQL failure, will retry in %d seconds...", this.a * 1), e3, null);
            Thread.sleep(this.a * 1000);
            this.a *= 2;
            if (this.a == 64) {
                this.a = 1;
            }
        }
        finally {
            SysLock.getInstance().setbusy(false);
            this.a(con);
        }
        SysLock.getInstance().setbusy(false);
        return msgList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<? extends OutboundMessage> getMessagesToSendBigDipper() throws Exception {
        int count = 0;
        while (!SysLock.getInstance().canUse()) {
            try {
                Thread.sleep(50L);
                if (count++ <= 50) continue;
                Logger.getInstance().logError("\u81ea\u65cb\u7b49\u5f85\u8d85\u8fc72\u79d2", null, null);
            }
            catch (InterruptedException e2) {
                Logger.getInstance().logError("\u53d6\u5f85\u53d1\u77ed\u4fe1\u65f6\u4ea7\u751f\u4e2d\u65ad\u5f02\u5e38", e2, null);
            }
        }
        Connection con = null;
        ArrayList<OutboundMessage> msgList = new ArrayList<OutboundMessage>();
        boolean isOracle = false;
        if (JDSMSServer.getInstance().getProperties().getString("db1.type", "mysql").equals("oracle") || JDSMSServer.getInstance().getProperties().getString("db1.type", "mysql").equals("oracle-rac")) {
            isOracle = true;
        }
        boolean isMssql = false;
        if (JDSMSServer.getInstance().getProperties().getString("db1.type", "mysql").equals("mssql")) {
            isMssql = true;
        }
        boolean isPG = false;
        if (JDSMSServer.getInstance().getProperties().getString("db1.type", "mysql").equals("postgresql")) {
            isPG = true;
        }
        String bd_using = JDSMSServer.getInstance().getProperties().getString("settings.bd_using", "no");
        int retryNum = Integer.parseInt(this.getProperty("retries", "2"));
        try {
            ResultSet rs = null;
            int msgCount = 1;
            con = this.a();
            Statement cmd = con.createStatement(1005, 1008);
            if ("no".equals(bd_using)) {
                ArrayList<OutboundMessage> arrayList = msgList;
                return arrayList;
            }
            PreparedStatement pst = con.prepareStatement("update " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " set status = 'Q' where id = ? ");
            String sqlSelect = "";
            if (isOracle) {
                sqlSelect = "select * from " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " where (status = 'U' or (status = 'F' and errors < " + retryNum + ")) and (gateway_id = '-' or gateway_id like 'BD%') and rownum <= %size% order by priority desc, id";
                sqlSelect = sqlSelect.replaceAll("%size%", "" + Integer.parseInt(this.getProperty("batch_size", "50")));
            } else if (isMssql) {
                sqlSelect = "select top %size% * from " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " where (status = 'U' or (status = 'F' and errors < " + retryNum + ")) and (gateway_id = '-' or gateway_id like 'BD%') order by priority desc, id";
                sqlSelect = sqlSelect.replaceAll("%size%", "" + Integer.parseInt(this.getProperty("batch_size", "50")));
            } else if (isPG) {
                sqlSelect = "select * from " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " where (status = 'U' or (status = 'F' and errors < " + retryNum + ")) and (gateway_id = '-' or gateway_id like 'BD%') order by priority desc, id limit %size% offset %begin%";
                sqlSelect = sqlSelect.replaceAll("%begin%", "0");
                sqlSelect = sqlSelect.replaceAll("%size%", "" + Integer.parseInt(this.getProperty("batch_size", "50")));
            } else {
                sqlSelect = "select * from " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " where (status = 'U' or (status = 'F' and errors < " + retryNum + ")) and (gateway_id = '-' or gateway_id like 'BD%') order by priority desc, id limit %begin% , %size%";
                sqlSelect = sqlSelect.replaceAll("%begin%", "0");
                sqlSelect = sqlSelect.replaceAll("%size%", "" + Integer.parseInt(this.getProperty("batch_size", "50")));
            }
            JDSMSServer.getInstance().userConsolePrint("x", "get send BD:" + sqlSelect);
            rs = cmd.executeQuery(sqlSelect);
            if (rs == null) {
                Logger.getInstance().logError("\u914d\u7f6e\u6587\u4ef6\u8bbe\u5907\u6a21\u5f0f\u4e22\u5931,\u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6", null, null);
                ArrayList<OutboundMessage> arrayList = msgList;
                return arrayList;
            }
            Logger.getInstance().logDebug("sql\u67e5\u8be2=" + sqlSelect, null, null);
            PreparedStatement updateStatement = con.prepareStatement("update " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " set status = 'F',sent_date=? where id = ? ");
            while (rs.next() && msgCount <= Integer.parseInt(this.getProperty("batch_size", "50"))) {
                OutboundMessage msg;
                if (!this.getServer().checkPriorityTimeFrame(rs.getInt("priority"))) continue;
                String recipient = rs.getString("recipient");
                if (StringUtils.isEmpty((CharSequence)recipient) || !recipient.matches("[A-F,a-f,0-9]+")) {
                    Logger.getInstance().logDebug("\u6536\u4fe1\u5730\u5740" + recipient + "\u4e0d\u5408\u6cd5!", null, null);
                    updateStatement.setTimestamp(1, new Timestamp(System.currentTimeMillis()));
                    updateStatement.setLong(2, rs.getLong("id"));
                    updateStatement.addBatch();
                    continue;
                }
                if (rs.getTimestamp("sent_date") != null && System.currentTimeMillis() < rs.getTimestamp("sent_date").getTime()) continue;
                switch (rs.getString("type").charAt(0)) {
                    case 'O': {
                        switch (rs.getString("encoding").charAt(0)) {
                            case '7': {
                                msg = new OutboundMessage(rs.getString("recipient").trim(), rs.getString("text").trim());
                                msg.setEncoding(Message.MessageEncodings.ENC7BIT);
                                break;
                            }
                            case '8': {
                                msg = new OutboundMessage(rs.getString("recipient").trim(), rs.getString("text").trim());
                                msg.setEncodingForOthers(Message.MessageEncodings.ENC8BIT);
                                break;
                            }
                            case 'U': {
                                msg = new OutboundMessage(rs.getString("recipient").trim(), rs.getString("text").trim());
                                msg.setEncoding(Message.MessageEncodings.ENCUCS2);
                                break;
                            }
                            case 'S': {
                                msg = new OutboundMessage(rs.getString("recipient").trim(), rs.getString("text").trim());
                                msg.setEncoding(Message.MessageEncodings.SC);
                                break;
                            }
                            default: {
                                msg = new OutboundMessage(rs.getString("recipient").trim(), rs.getString("text").trim());
                                msg.setEncoding(Message.MessageEncodings.ENCUCS2);
                            }
                        }
                        if (rs.getInt("flash_sms") == 1) {
                            msg.setFlashSms(true);
                        }
                        if (rs.getInt("src_port") == -1) break;
                        msg.setSrcPort(rs.getInt("src_port"));
                        msg.setDstPort(rs.getInt("dst_port"));
                        break;
                    }
                    case 'W': {
                        OutboundWapSIMessage.WapSISignals wapSignal;
                        Date wapExpiryDate;
                        if (rs.getTime("wap_expiry_date") == null) {
                            Calendar cal = Calendar.getInstance();
                            cal.setTime(new Date());
                            cal.add(6, 7);
                            wapExpiryDate = cal.getTime();
                        } else {
                            wapExpiryDate = rs.getTimestamp("wap_expiry_date");
                        }
                        if (rs.getString("wap_signal") == null) {
                            wapSignal = OutboundWapSIMessage.WapSISignals.NONE;
                        } else {
                            switch (rs.getString("wap_signal").charAt(0)) {
                                case 'N': {
                                    wapSignal = OutboundWapSIMessage.WapSISignals.NONE;
                                    break;
                                }
                                case 'L': {
                                    wapSignal = OutboundWapSIMessage.WapSISignals.LOW;
                                    break;
                                }
                                case 'M': {
                                    wapSignal = OutboundWapSIMessage.WapSISignals.MEDIUM;
                                    break;
                                }
                                case 'H': {
                                    wapSignal = OutboundWapSIMessage.WapSISignals.HIGH;
                                    break;
                                }
                                case 'D': {
                                    wapSignal = OutboundWapSIMessage.WapSISignals.DELETE;
                                    break;
                                }
                                default: {
                                    wapSignal = OutboundWapSIMessage.WapSISignals.NONE;
                                }
                            }
                        }
                        msg = new OutboundWapSIMessage(rs.getString("recipient").trim(), new URL(rs.getString("wap_url").trim()), rs.getString("text").trim(), wapExpiryDate, wapSignal);
                        break;
                    }
                    default: {
                        throw new Exception("Message type '" + rs.getString("type") + "' is unknown!");
                    }
                }
                msg.setPriority(rs.getInt("priority"));
                if (rs.getInt("status_report") == 1) {
                    msg.setStatusReport(true);
                }
                if (rs.getString("originator") != null && rs.getString("originator").length() > 0) {
                    msg.setFrom(rs.getString("originator").trim());
                }
                String gateway_id = rs.getString("gateway_id").trim();
                int messageID = rs.getInt("id");
                pst.setInt(1, messageID);
                msg.setGatewayId(gateway_id);
                int messageIDModefied = rs.getInt("id") + 100;
                if (messageIDModefied > Integer.MAX_VALUE) {
                    Logger.getInstance().logError("\u5df2\u7ecf\u5230\u8fc7\u6570\u636e\u5e93\u6700\u5927\u5bb9\u91cf\uff0c\u8bf7\u66f4\u6362\u6570\u636e\u5e93\uff01", null, null);
                    continue;
                }
                msg.setMessageID(messageIDModefied);
                JDSMSServer.getInstance().userConsolePrint("x", "-check message: gateid=" + msg.getGatewayId() + " msgid=" + rs.getInt("id"));
                msgList.add(msg);
                this.getMessageCache().put(msg.getMessageId(), rs.getInt("id"));
                pst.addBatch();
                ++msgCount;
            }
            updateStatement.executeBatch();
            pst.executeBatch();
            rs.close();
            cmd.close();
            pst.close();
            updateStatement.close();
        }
        catch (Exception e3) {
            try {
                if (con != null) {
                    con.close();
                }
                this.a(con);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Logger.getInstance().logError(String.format("SQL failure, will retry in %d seconds...", this.a * 1), e3, null);
            Thread.sleep(this.a * 1000);
            this.a *= 2;
            if (this.a == 64) {
                this.a = 1;
            }
        }
        finally {
            SysLock.getInstance().setbusy(false);
            this.a(con);
        }
        SysLock.getInstance().setbusy(false);
        return msgList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void BDMessagesReceived(Collection<InboundMessage> msgList) throws Exception {
        int count = 0;
        PropertiesConfiguration props = JDSMSServer.getInstance().getProperties();
        while (!SysLock.getInstance().canUse()) {
            try {
                Thread.sleep(50L);
                if (count++ <= 50) continue;
                Logger.getInstance().logError("\u81ea\u65cb\u7b49\u5f85\u8d85\u8fc72\u79d2", null, null);
            }
            catch (InterruptedException e2) {
                Logger.getInstance().logError("\u53d6\u5f85\u53d1\u77ed\u4fe1\u65f6\u4ea7\u751f\u4e2d\u65ad\u5f02\u5e38", e2, null);
            }
        }
        System.out.println("Database BigDipperMessagesReceiving...");
        Connection con = null;
        int resendTimes = props.getInt("settings.resend_times", 0);
        try {
            con = this.a();
            PreparedStatement pst = con.prepareStatement(" insert into " + this.getProperty("tables.sms_in", "jdsmsserver_in") + " (process, originator, type, encoding, message_date, receive_date, text, original_ref_no, original_receive_date, gateway_id)  values(?,?,?,?,?,?,?,?,?,?)");
            for (InboundMessage msg : msgList) {
                if (msg.getEncoding() != Message.MessageEncodings.SC && resendTimes > 0) {
                    if (msg.isError()) {
                        Logger.getInstance().logInfo("\u4fe1\u606f\u3010" + msg.getText() + "\u3011\u4e0d\u5b8c\u6574\uff0c\u4e0d\u5165\u5e93\u3002", null, null);
                        continue;
                    }
                    if (this.a(con, msg)) {
                        Logger.getInstance().logInfo("\u4fe1\u606f\u3010" + msg.getText() + "\u3011\u91cd\u590d\u4e86\uff01 key: " + msg.getMessageID() + "-" + msg.getOriginator(), null, null);
                        continue;
                    }
                }
                if (msg.getType() != Message.MessageTypes.INBOUND) continue;
                if (Utils.isEmptyStr(msg.getMessageID())) {
                    pst.setInt(1, 0);
                } else {
                    pst.setInt(1, Integer.valueOf(msg.getMessageID(), 16));
                }
                switch (msg.getEncoding()) {
                    case ENC7BIT: {
                        pst.setString(4, "7");
                        break;
                    }
                    case ENC8BIT: {
                        pst.setString(4, "8");
                        break;
                    }
                    case ENCUCS2: {
                        pst.setString(4, "U");
                        break;
                    }
                    case SC: {
                        pst.setString(4, "S");
                        break;
                    }
                    case ENCCUSTOM: {
                        pst.setString(4, "C");
                    }
                }
                switch (msg.getType()) {
                    case INBOUND: {
                        pst.setString(3, "I");
                        pst.setString(2, msg.getOriginator());
                        pst.setTimestamp(5, new Timestamp(msg.getDate().getTime()));
                        pst.setString(8, null);
                        pst.setTimestamp(9, null);
                        break;
                    }
                }
                pst.setTimestamp(6, new Timestamp(new Date().getTime()));
                pst.setString(7, msg.getText().length() == 0 ? "" : msg.getText());
                String gatewayID = msg.getGatewayId();
                if (gatewayID == null || gatewayID.equals("")) {
                    gatewayID = "-";
                }
                pst.setString(10, gatewayID);
                pst.addBatch();
            }
            Iterator<InboundMessage> iterMessage = null;
            pst.executeBatch();
            pst.close();
        }
        catch (Exception e3) {
            try {
                if (con != null) {
                    con.close();
                }
                this.a(con);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Logger.getInstance().logError(String.format("SQL failure, will retry in %d seconds...", this.a * 1), e3, null);
            Thread.sleep(this.a * 1000);
            this.a *= 2;
            if (this.a == 64) {
                this.a = 1;
            }
        }
        finally {
            SysLock.getInstance().setbusy(false);
            this.a(con);
        }
        SysLock.getInstance().setbusy(false);
    }

    private String c() {
        String flag = "*";
        int isorted = Integer.parseInt(JDSMSServer.getInstance().getProperties().getString("settings.using_sorted", "0"));
        String device_using = JDSMSServer.getInstance().getProperties().getString("settings.device_using", "yes");
        String phone_using = JDSMSServer.getInstance().getProperties().getString("settings.phone_using", "yes");
        String gateway_using = JDSMSServer.getInstance().getProperties().getString("settings.gateway_using", "yes");
        switch (isorted) {
            case 0: {
                if (device_using.equals("yes")) {
                    flag = "*";
                    break;
                }
                if (gateway_using.equals("yes")) {
                    flag = "#";
                    break;
                }
                if (!phone_using.equals("yes")) break;
                flag = "$";
                break;
            }
            case 1: {
                if (device_using.equals("yes")) {
                    flag = "*";
                    break;
                }
                if (phone_using.equals("yes")) {
                    flag = "$";
                    break;
                }
                if (!gateway_using.equals("yes")) break;
                flag = "#";
                break;
            }
            case 2: {
                if (gateway_using.equals("yes")) {
                    flag = "#";
                    break;
                }
                if (device_using.equals("yes")) {
                    flag = "*";
                    break;
                }
                if (!phone_using.equals("yes")) break;
                flag = "$";
                break;
            }
            case 3: {
                if (gateway_using.equals("yes")) {
                    flag = "#";
                    break;
                }
                if (phone_using.equals("yes")) {
                    flag = "$";
                    break;
                }
                if (!device_using.equals("yes")) break;
                flag = "*";
                break;
            }
            case 4: {
                if (phone_using.equals("yes")) {
                    flag = "$";
                    break;
                }
                if (device_using.equals("yes")) {
                    flag = "*";
                    break;
                }
                if (!gateway_using.equals("yes")) break;
                flag = "#";
                break;
            }
            case 5: {
                if (phone_using.equals("yes")) {
                    flag = "$";
                    break;
                }
                if (gateway_using.equals("yes")) {
                    flag = "#";
                    break;
                }
                if (!device_using.equals("yes")) break;
                flag = "*";
                break;
            }
        }
        return flag;
    }
}

