/*
 * Decompiled with CFR 0.152.
 */
package cn.sendsms.jdsmsserver.interfaces;

import cn.sendsms.InboundMessage;
import cn.sendsms.Message;
import cn.sendsms.OutboundMessage;
import cn.sendsms.helper.ExtStringBuilder;
import cn.sendsms.jdsmsserver.JDSMSServer;
import cn.sendsms.jdsmsserver.interfaces.Interface;
import cn.sendsms.jdsmsserver.web.DbHelper;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.configuration.PropertiesConfiguration;

public class HttpPush
extends Interface<Integer> {
    private static final TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }};
    private static final HostnameVerifier DO_NOT_VERIFY = new HostnameVerifier(){

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    };

    public HttpPush(String myInterfaceId, PropertiesConfiguration myProps, JDSMSServer myServer, Interface.InterfaceTypes myType) {
        super(myInterfaceId, myProps, myServer, myType);
        this.setDescription("Default HTTP interface.");
    }

    @Override
    public void messagesReceived(Collection<InboundMessage> msgList1) throws Exception {
        String template = this.getProperty("get_url");
        this.getService().getLogger().logInfo("SMSServer: Interface HTTP: " + template, null, null);
        DbHelper database = DbHelper.getDbHelper(JDSMSServer.getInstance().getProperties(), "db1");
        List<InboundMessage> msgList = database.getProcess(0);
        for (int index = 0; index < msgList.size(); ++index) {
            InboundMessage im = msgList.get(index);
            try {
                int i2;
                if (template == null || im.getType() != Message.MessageTypes.INBOUND && im.getType() != Message.MessageTypes.STATUSREPORT) continue;
                String getURL = this.a(template, im);
                this.getService().getLogger().logInfo("SMSServer: Interface HTTP: " + getURL, null, null);
                URL url = new URL(getURL);
                boolean suss = this.a(url);
                for (i2 = 0; !suss && i2 < 3; ++i2) {
                    Thread.sleep(10L);
                    suss = this.a(url);
                }
                if (i2 >= 3) {
                    database.updateProcess(im.getPushMsgId(), 2);
                    this.getService().getLogger().logError("\u8c03\u7528url:" + url + "\u5931\u8d25,\u7b49\u5f85\u518d\u6b21\u56de\u8c03.", null, null);
                }
                if (!suss) continue;
                database.updateProcess(im.getPushMsgId(), 1);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void pushMessages(Collection<InboundMessage> msgList) throws Exception {
        String template = this.getProperty("get_url");
        this.getService().getLogger().logInfo("SMSServer: Interface HTTP: " + template, null, null);
        for (InboundMessage im : msgList) {
            try {
                int i2;
                if (template == null || im.getType() != Message.MessageTypes.INBOUND && im.getType() != Message.MessageTypes.STATUSREPORT) continue;
                String getURL = this.a(template, im);
                this.getService().getLogger().logInfo("SMSServer: Interface HTTP: " + getURL, null, null);
                URL url = new URL(getURL);
                boolean suss = this.a(url);
                for (i2 = 0; !suss && i2 < 3; ++i2) {
                    Thread.sleep(10L);
                    suss = this.a(url);
                }
                if (i2 >= 3) {
                    this.getService().getLogger().logError("\u8c03\u7528url:" + url + "\u5931\u8d25,\u7b49\u5f85\u518d\u6b21\u56de\u8c03.", null, null);
                }
                if (!suss) continue;
                DbHelper database = DbHelper.getDbHelper(JDSMSServer.getInstance().getProperties(), "db1");
                database.updateProcess(im.getPushMsgId(), 1);
            }
            catch (Exception exception) {}
        }
        Iterator<InboundMessage> imiterator = null;
    }

    @Override
    public void markMessage(OutboundMessage om) throws Exception {
        String template = this.getProperty("dlr_url");
        if (template != null) {
            String dlrURL = this.a(template, om);
            URL url = new URL(dlrURL);
            this.a(url);
        }
        this.getMessageCache().remove(om.getId());
    }

    boolean a(URL url) throws IOException {
        if ("POST".equalsIgnoreCase(this.getProperty("method"))) {
            return this.b(url);
        }
        return this.c(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean b(URL url) throws IOException {
        try (OutputStreamWriter out = null;){
            URL cleanUrl;
            if (url.getProtocol().equalsIgnoreCase("https")) {
                cleanUrl = new URL(url.getProtocol(), url.getHost(), url.getPort(), url.getPath());
                this.getService().getLogger().logInfo("HTTP POST: " + cleanUrl, null, null);
                HttpsURLConnection con = (HttpsURLConnection)cleanUrl.openConnection();
                HostnameVerifier hostNameVerify = new HostnameVerifier(){

                    @Override
                    public boolean verify(String arg0, SSLSession arg1) {
                        return true;
                    }
                };
                con.setHostnameVerifier(hostNameVerify);
                HttpPush.trustAllHosts(con);
                con.setDoOutput(true);
                out = new OutputStreamWriter(con.getOutputStream());
                if (url.getQuery() != null) {
                    out.write(url.getQuery());
                }
                out.flush();
                if (200 == con.getResponseCode()) {
                    this.getService().getLogger().logInfo("HTTPS POST RET HTTP_OK", null, null);
                    boolean bl = true;
                    return bl;
                }
                this.getService().getLogger().logInfo("HTTPS POST RET " + con.getResponseCode(), null, null);
            } else {
                cleanUrl = new URL(url.getProtocol(), url.getHost(), url.getPort(), url.getPath());
                this.getService().getLogger().logInfo("HTTP POST: " + cleanUrl, null, null);
                HttpURLConnection con = (HttpURLConnection)cleanUrl.openConnection();
                con.setDoOutput(true);
                out = new OutputStreamWriter(con.getOutputStream());
                if (url.getQuery() != null) {
                    out.write(url.getQuery());
                }
                out.flush();
                if (200 == con.getResponseCode()) {
                    this.getService().getLogger().logInfo("HTTP POST RET HTTP_OK", null, null);
                    boolean bl = true;
                    return bl;
                }
                this.getService().getLogger().logInfo("HTTP POST RET " + con.getResponseCode(), null, null);
            }
        }
        return false;
    }

    private static SSLSocketFactory trustAllHosts(HttpsURLConnection connection) {
        SSLSocketFactory oldFactory = connection.getSSLSocketFactory();
        try {
            SSLContext sc = SSLContext.getInstance("TLS");
            sc.init(null, trustAllCerts, new SecureRandom());
            SSLSocketFactory newFactory = sc.getSocketFactory();
            connection.setSSLSocketFactory(newFactory);
        }
        catch (NoSuchAlgorithmException e2) {
            e2.printStackTrace();
        }
        catch (KeyManagementException e3) {
            e3.printStackTrace();
        }
        return oldFactory;
    }

    boolean c(URL url) throws IOException {
        try {
            if (url.getProtocol().equalsIgnoreCase("https")) {
                this.getService().getLogger().logInfo("HTTPS GET: " + url, null, null);
                HttpsURLConnection con = (HttpsURLConnection)url.openConnection();
                HostnameVerifier hostNameVerify = new HostnameVerifier(){

                    @Override
                    public boolean verify(String arg0, SSLSession arg1) {
                        return true;
                    }
                };
                con.setHostnameVerifier(hostNameVerify);
                HttpPush.trustAllHosts(con);
                con.setHostnameVerifier(DO_NOT_VERIFY);
                if (200 == con.getResponseCode()) {
                    this.getService().getLogger().logInfo("HTTPS GET RET HTTP_OK", null, null);
                    return true;
                }
                this.getService().getLogger().logInfo("HTTPS GET RET " + con.getResponseCode(), null, null);
            } else {
                this.getService().getLogger().logInfo("HTTP GET: " + url, null, null);
                HttpURLConnection con = (HttpURLConnection)url.openConnection();
                con.setAllowUserInteraction(false);
                if (200 == con.getResponseCode()) {
                    this.getService().getLogger().logInfo("HTTP GET RET HTTP_OK", null, null);
                    return true;
                }
                this.getService().getLogger().logInfo("HTTP GET RET " + con.getResponseCode(), null, null);
            }
        }
        catch (Exception e2) {
            this.getService().getLogger().logInfo("GET ERROR:" + e2.toString(), null, null);
        }
        return false;
    }

    private String a(String template, InboundMessage msg) throws UnsupportedEncodingException {
        ExtStringBuilder sb = new ExtStringBuilder(template);
        sb.replaceAll("%gatewayId%", URLEncoder.encode(msg.getGatewayId(), this.getProperty("encoding", "UTF-8")));
        sb.replaceAll("%encoding%", msg.getEncoding() == Message.MessageEncodings.ENC7BIT ? "7-bit" : (msg.getEncoding() == Message.MessageEncodings.ENC8BIT ? "8-bit" : "UCS2 (Unicode)"));
        if (msg.getDate() != null) {
            sb.replaceAll("%date%", URLEncoder.encode(msg.getDate().toString(), this.getProperty("encoding", "UTF-8")));
        }
        sb.replaceAll("%text%", URLEncoder.encode(msg.getText(), this.getProperty("encoding", "UTF-8")));
        sb.replaceAll("%originator%", msg.getOriginator());
        sb.replaceAll("%memIndex%", msg.getMemIndex());
        sb.replaceAll("%mpMemIndex%", msg.getMpMemIndex());
        return sb.toString();
    }

    private String a(String template, OutboundMessage msg) throws UnsupportedEncodingException {
        ExtStringBuilder sb = new ExtStringBuilder(template);
        sb.replaceAll("%gatewayId%", URLEncoder.encode(msg.getGatewayId(), this.getProperty("encoding", "UTF-8")));
        sb.replaceAll("%encoding%", msg.getEncoding() == Message.MessageEncodings.ENC7BIT ? "7-bit" : (msg.getEncoding() == Message.MessageEncodings.ENC8BIT ? "8-bit" : "UCS2 (Unicode)"));
        if (msg.getDate() != null) {
            sb.replaceAll("%date%", URLEncoder.encode(msg.getDate().toString(), this.getProperty("encoding", "UTF-8")));
        }
        sb.replaceAll("%text%", URLEncoder.encode(msg.getText(), this.getProperty("encoding", "UTF-8")));
        sb.replaceAll("%refNo%", URLEncoder.encode(msg.getRefNo(), this.getProperty("encoding", "UTF-8")));
        sb.replaceAll("%recipient%", msg.getRecipient());
        sb.replaceAll("%from%", msg.getFrom());
        sb.replaceAll("%failureCause%", URLEncoder.encode(msg.getFailureCause().toString(), this.getProperty("encoding", "UTF-8")));
        sb.replaceAll("%messageStatus%", msg.getMessageStatus().toString());
        return sb.toString();
    }

    public void doTest() throws IOException {
    }
}

