/*
 * Decompiled with CFR 0.152.
 */
package cn.sendsms.jdsmsserver.web;

import cn.sendsms.crypto.PwdConf;
import cn.sendsms.helper.Logger;
import cn.sendsms.jdsmsserver.JDSMSServer;
import cn.sendsms.jdsmsserver.ResourceManager;
import cn.sendsms.jdsmsserver.interfaces.ConnectionPool;
import cn.sendsms.jdsmsserver.interfaces.Database;
import cn.sendsms.jdsmsserver.interfaces.Interface;
import cn.sendsms.jdsmsserver.web.DataSourceBean;
import cn.sendsms.jdsmsserver.web.DatabaseCreator;
import cn.sendsms.jdsmsserver.web.JDWebAction;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.Statement;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang.ArrayUtils;

public class DataSourceAction
extends JDWebAction {
    private static final long serialVersionUID = -7235907240359901762L;
    private DataSourceBean datasource;
    private String racurl;

    public void Init(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.datasource = this.a("db1");
        if (req.getParameter("datasource.type") != null && !req.getParameter("datasource.type").equals("mssql2000") && !req.getParameter("datasource.type").equals("mssql2005-2017")) {
            this.datasource.setType(req.getParameter("datasource.type"));
        }
        if (req.getParameter("datasource.port") != null) {
            this.datasource.setPort(Integer.parseInt(req.getParameter("datasource.port")));
        }
        if (req.getParameter("datasource.mstype") != null) {
            this.datasource.setMssqltype(req.getParameter("datasource.mstype"));
        }
        this.findForward("database-config.jsp", true, req, resp);
    }

    public void save(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String global_info = "";
        Database inf1 = null;
        for (int i2 = 0; i2 < JDSMSServer.getInstance().getInfList().size(); ++i2) {
            Database inf = JDSMSServer.getInstance().getInfList().get(i2);
            if (!inf.getId().equals(this.datasource.getInfid())) continue;
            inf1 = inf;
            break;
        }
        this.a();
        PropertiesConfiguration props = JDSMSServer.getInstance().getProperties();
        props.setProperty(this.datasource.getInterfaceid(), (Object)(this.datasource.getInfid() + " ,Database"));
        props.setProperty(this.datasource.getInfid() + ".type", (Object)this.datasource.getType());
        props.setProperty(this.datasource.getInfid() + ".mssqltype", (Object)this.datasource.getMssqltype());
        String url = "";
        String driver = "";
        if (this.datasource.getType().equalsIgnoreCase("mysql")) {
            url = "jdbc:mysql://" + this.datasource.getIp() + ":" + this.datasource.getPort() + "/" + this.datasource.getDatabaseName() + "?useUnicode=true&characterEncoding=utf8";
            driver = "com.mysql.jdbc.Driver";
        } else if (this.datasource.getType().equalsIgnoreCase("mysql8")) {
            url = "jdbc:mysql://" + this.datasource.getIp() + ":" + this.datasource.getPort() + "/" + this.datasource.getDatabaseName() + "?useUnicode=true&characterEncoding=utf8&useSSL=false&serverTimezone=Asia/Shanghai";
            driver = "com.mysql.cj.jdbc.Driver";
        } else if (this.datasource.getType().equalsIgnoreCase("DM7")) {
            url = "jdbc:dm://" + this.datasource.getIp() + ":" + this.datasource.getPort() + "/" + this.datasource.getDatabaseName();
            driver = "dm.jdbc.driver.DmDriver";
        } else if (this.datasource.getType().equalsIgnoreCase("OSCAR7")) {
            url = "jdbc:oscar://" + this.datasource.getIp() + ":" + this.datasource.getPort() + "/" + this.datasource.getDatabaseName();
            driver = "com.oscar.Driver";
        } else if (this.datasource.getType().equalsIgnoreCase("KINGBASE8")) {
            url = "jdbc:kingbase8://" + this.datasource.getIp() + ":" + this.datasource.getPort() + "/" + this.datasource.getDatabaseName();
            driver = "com.kingbase8.Driver";
        } else if (this.datasource.getType().equalsIgnoreCase("GBASE8A")) {
            url = "jdbc:gbase://" + this.datasource.getIp() + ":" + this.datasource.getPort() + "/" + this.datasource.getDatabaseName() + "?useUnicode=true&characterEncoding=utf8";
            driver = "com.gbase.jdbc.Driver";
        } else if (this.datasource.getType().equalsIgnoreCase("mssql")) {
            url = "jdbc:sqlserver://" + this.datasource.getIp() + ":" + this.datasource.getPort() + ";SelectMethod=cursor;DatabaseName=" + this.datasource.getDatabaseName();
            if (this.datasource.getMssqltype().equalsIgnoreCase("mssql2000")) {
                driver = "com.microsoft.jdbc.sqlserver.SQLServerDriver";
            } else if (this.datasource.getMssqltype().equalsIgnoreCase("mssql2005-2017")) {
                driver = "com.microsoft.sqlserver.jdbc.SQLServerDriver";
            }
        } else if (this.datasource.getType().equalsIgnoreCase("oracle")) {
            url = "jdbc:oracle:thin:@" + this.datasource.getIp() + ":" + this.datasource.getPort() + ":" + this.datasource.getDatabaseName();
            driver = "oracle.jdbc.OracleDriver";
        } else if (this.datasource.getType().equalsIgnoreCase("oracle-rac")) {
            url = this.racurl;
            driver = "oracle.jdbc.OracleDriver";
        } else if (this.datasource.getType().equalsIgnoreCase("postgresql")) {
            url = "jdbc:postgresql://" + this.datasource.getIp() + ":" + this.datasource.getPort() + "/" + this.datasource.getDatabaseName();
            driver = "org.postgresql.Driver";
        } else {
            global_info = ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.db_info1") + "[" + this.datasource.getType() + "]" + ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.db_info2");
            req.setAttribute("global_info", (Object)global_info);
            this.findForward("/database-config.jsp", true, req, resp);
            return;
        }
        props.setProperty(this.datasource.getInfid() + ".url", (Object)url);
        props.setProperty(this.datasource.getInfid() + ".driver", (Object)driver);
        props.setProperty(this.datasource.getInfid() + ".username", (Object)this.datasource.getUsername());
        props.setProperty(this.datasource.getInfid() + ".enc", (Object)"1");
        props.setProperty(this.datasource.getInfid() + ".password", (Object)PwdConf.encPwd(this.datasource.getPassword()));
        props.setProperty(this.datasource.getInfid() + ".tables.sms_in", (Object)this.datasource.getTablesIn());
        props.setProperty(this.datasource.getInfid() + ".tables.sms_out", (Object)this.datasource.getTablesOut());
        props.setProperty(this.datasource.getInfid() + ".tables.calls", (Object)this.datasource.getTablesCall());
        props.setProperty(this.datasource.getInfid() + ".retries", (Object)("" + this.datasource.getRetries()));
        props.setProperty(this.datasource.getInfid() + ".update_outbound_on_statusreport", (Object)this.datasource.getUpdate_outbound_on_statusreport());
        props.setProperty(this.datasource.getInfid() + ".batch_size", (Object)("" + this.datasource.getBatch_size()));
        if (this.datasource.getType().equalsIgnoreCase("oracle-rac")) {
            props.setProperty(this.datasource.getInfid() + ".url.rac", (Object)this.racurl);
        }
        try {
            props.save();
            ConnectionPool.getInstance().initConnectionPool();
            ConnectionPool.getInstance().closeConnectionPool();
        }
        catch (Exception e2) {
            Logger.getInstance().logError("\u4fdd\u5b58\u64cd\u4f5c\u65f6\u51fa\u73b0\u5f02\u5e38", e2, null);
            global_info = ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.db_save_failure_info");
            this.findForward("/database-config.jsp", true, req, resp);
            FileInputStream in = null;
            in = System.getProperty("jdsmsserver.configdir") != null ? new FileInputStream(System.getProperty("jdsmsserver.configdir") + "JDSMSServer.conf") : (System.getProperty("jdsmsserver.configfile") != null ? new FileInputStream(System.getProperty("jdsmsserver.configfile")) : new FileInputStream("JDSMSServer.conf"));
            try {
                JDSMSServer.getInstance().getProperties().load((InputStream)in);
            }
            catch (ConfigurationException e1) {
                Logger.getInstance().logError("\u52a0\u8f7d\u914d\u7f6e\u6587\u4ef6\u65f6\u51fa\u73b0\u5f02\u5e38", e2, null);
            }
            req.setAttribute("global_info", (Object)global_info);
            this.findForward("/database-config.jsp", true, req, resp);
            return;
        }
        global_info = ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.db_save_success_info");
        if (inf1 == null) {
            inf1 = new Database(this.datasource.getInfid(), props, JDSMSServer.getInstance(), Interface.InterfaceTypes.INOUTBOUND);
            JDSMSServer.getInstance().getInfList().add(inf1);
        } else {
            try {
                ((Interface)inf1).stop();
            }
            catch (Exception e3) {
                Logger.getInstance().logError("\u4fdd\u5b58\u6570\u636e\u6e90\u65f6\u505c\u6b62\u6570\u636e\u5e93\u670d\u52a1\u5931\u8d25", e3, null);
            }
            try {
                ((Interface)inf1).start();
            }
            catch (Exception e4) {
                Logger.getInstance().logError("\u4fdd\u5b58\u6570\u636e\u6e90\u65f6\u542f\u52a8\u6570\u636e\u5e93\u670d\u52a1\u5931\u8d25", e4, null);
            }
        }
        req.setAttribute("global_info", (Object)global_info);
        this.Init(req, resp);
    }

    public void test(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String url = "";
        String driver = "";
        String sql = "";
        this.a();
        if (this.datasource.getType().equalsIgnoreCase("mysql")) {
            url = "jdbc:mysql://" + this.datasource.getIp() + ":" + this.datasource.getPort() + "/?useUnicode=true&characterEncoding=gb2312";
            driver = "com.mysql.jdbc.Driver";
            sql = "select 1 from dual";
        }
        if (this.datasource.getType().equalsIgnoreCase("mysql8")) {
            url = "jdbc:mysql://" + this.datasource.getIp() + ":" + this.datasource.getPort() + "/?useUnicode=true&characterEncoding=gb2312&useSSL=false&serverTimezone=Asia/Shanghai";
            driver = "com.mysql.cj.jdbc.Driver";
            sql = "select 1 from dual";
        }
        if (this.datasource.getType().equalsIgnoreCase("mssql") && this.datasource.getMssqltype().equalsIgnoreCase("mssql2000")) {
            url = "jdbc:sqlserver://" + this.datasource.getIp() + ":" + this.datasource.getPort() + ";SelectMethod=cursor;";
            driver = "com.microsoft.jdbc.sqlserver.SQLServerDriver";
            sql = "select abs(-1) value";
        }
        if (this.datasource.getType().equalsIgnoreCase("mssql") && this.datasource.getMssqltype().equalsIgnoreCase("mssql2005-2017")) {
            url = "jdbc:sqlserver://" + this.datasource.getIp() + ":" + this.datasource.getPort() + ";SelectMethod=cursor;";
            driver = "com.microsoft.sqlserver.jdbc.SQLServerDriver";
            sql = "select abs(-1) value";
        }
        if (this.datasource.getType().equalsIgnoreCase("DM7")) {
            url = "jdbc:dm://" + this.datasource.getIp() + ":" + this.datasource.getPort() + "/" + this.datasource.getDatabaseName();
            driver = "dm.jdbc.driver.DmDriver";
            sql = "select 1 from dual";
        }
        if (this.datasource.getType().equalsIgnoreCase("OSCAR7")) {
            url = "jdbc:oscar://" + this.datasource.getIp() + ":" + this.datasource.getPort() + "/" + this.datasource.getDatabaseName();
            driver = "com.oscar.Driver";
            sql = "select 1 from dual";
        }
        if (this.datasource.getType().equalsIgnoreCase("KINGBASE8")) {
            url = "jdbc:kingbase8://" + this.datasource.getIp() + ":" + this.datasource.getPort() + "/" + this.datasource.getDatabaseName();
            driver = "com.kingbase8.Driver";
            sql = "select 1 from dual";
        }
        if (this.datasource.getType().equalsIgnoreCase("GBASE8A")) {
            url = "jdbc:gbase://" + this.datasource.getIp() + ":" + this.datasource.getPort() + "/?useUnicode=true&characterEncoding=gb2312";
            driver = "com.gbase.jdbc.Driver";
            sql = "select 1 from dual";
        }
        if (this.datasource.getType().equalsIgnoreCase("oracle")) {
            url = "jdbc:oracle:thin:@" + this.datasource.getIp() + ":" + this.datasource.getPort() + ":" + this.datasource.getDatabaseName();
            driver = "oracle.jdbc.OracleDriver";
            sql = "select 1 from dual";
        }
        if (this.datasource.getType().equalsIgnoreCase("oracle-rac")) {
            String urlTmp;
            url = urlTmp = req.getParameter("datasource.racurl");
            driver = "oracle.jdbc.OracleDriver";
            sql = "select 1 from dual";
        }
        if (this.datasource.getType().equalsIgnoreCase("postgresql")) {
            url = "jdbc:postgresql://" + this.datasource.getIp() + ":" + this.datasource.getPort() + "/" + this.datasource.getDatabaseName();
            driver = "org.postgresql.Driver";
            sql = "select 1 from user";
        }
        Connection conn = null;
        try {
            Class.forName(driver);
            conn = DriverManager.getConnection(url, this.datasource.getUsername(), this.datasource.getPassword());
            Statement cmd = conn.createStatement();
            cmd.executeQuery(sql);
            cmd.close();
            conn.close();
            if (this.datasource.getType().equalsIgnoreCase("oracle-rac")) {
                this.datasource.setUrlRac(url);
            }
        }
        catch (Exception e2) {
            if (this.datasource.getType().equalsIgnoreCase("oracle-rac")) {
                this.datasource.setUrlRac(url);
            }
            Logger.getInstance().logInfo("\u6570\u636e\u5e93\u9519\u8bef: driver=" + driver, null, null);
            Logger.getInstance().logInfo("\u6570\u636e\u5e93\u9519\u8bef: url=" + url, null, null);
            this.log.error((Object)"\u6d4b\u8bd5\u6570\u636e\u5e93\u8fde\u63a5\u5931\u8d25", (Throwable)e2);
            req.setAttribute("global_info", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.db_test_failure_info1"));
            this.findForward("/database-config.jsp", true, req, resp);
            return;
        }
        req.setAttribute("global_info", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.db_test_failure_info2"));
        this.findForward("/database-config.jsp", true, req, resp);
    }

    public void initDatabase(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            this.a();
            String className = "cn.sendsms.jdsmsserver.web.CreatorFor" + this.datasource.getType().toUpperCase();
            if (this.datasource.getType().equals("oracle-rac")) {
                className = "cn.sendsms.jdsmsserver.web.CreatorForORACLE";
                this.datasource.setUrlRac(req.getParameter("datasource.racurl"));
            }
            Class<?> c2 = Class.forName(className);
            Constructor<?> constructor = c2.getConstructor(DataSourceBean.class);
            DatabaseCreator creater = (DatabaseCreator)constructor.newInstance(this.datasource);
            creater.initDataBase();
        }
        catch (Exception e2) {
            Logger.getInstance().logError("\u8fde\u63a5\u6570\u636e\u5e93\u65f6\u5931\u8d25", e2, null);
            req.setAttribute("global_info", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.db_init_failure_info1"));
            this.findForward("/database-config.jsp", true, req, resp);
            return;
        }
        req.setAttribute("global_info", (Object)ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.db_init_failure_info2"));
        this.findForward("/database-config.jsp", true, req, resp);
    }

    private DataSourceBean a(String infid) {
        String szTmpPwd;
        Object[] results;
        int i2;
        DataSourceBean bean = new DataSourceBean();
        PropertiesConfiguration props = JDSMSServer.getInstance().getProperties();
        for (i2 = 0; i2 < Integer.MAX_VALUE && !ArrayUtils.isEmpty((Object[])(results = props.getStringArray("interface." + i2))) && !((String)results[1]).trim().equals("Database"); ++i2) {
        }
        bean.setInterfaceid("interface." + i2);
        bean.setInfid(infid);
        if (props.getString("interface." + i2, "").length() == 0) {
            return bean;
        }
        String url = props.getString(bean.getInfid() + ".url");
        bean.setType(props.getString(bean.getInfid() + ".type"));
        bean.setMssqltype(props.getString(bean.getInfid() + ".mssqltype"));
        String[] tmp = this.a(url, bean.getType());
        bean.setBatch_size(Integer.parseInt(props.getString(bean.getInfid() + ".batch_size")));
        bean.setDatabaseName(tmp[2]);
        bean.setIp(tmp[0]);
        String szTmpEnc = props.getString(bean.getInfid() + ".enc");
        String szDbPwd = szTmpPwd = props.getString(bean.getInfid() + ".password");
        if (szTmpEnc != null && szTmpEnc.equals("1")) {
            szDbPwd = PwdConf.decPwd(szTmpPwd);
        }
        bean.setPassword(szDbPwd);
        if (bean.getType().equals("oracle-rac")) {
            bean.setPort(1521);
        } else {
            bean.setPort(Integer.parseInt(tmp[1]));
        }
        bean.setRetries(Integer.parseInt(props.getString(bean.getInfid() + ".retries")));
        bean.setTablesCall(props.getString(bean.getInfid() + ".tables.calls"));
        bean.setTablesIn(props.getString(bean.getInfid() + ".tables.sms_in"));
        bean.setTablesOut(props.getString(bean.getInfid() + ".tables.sms_out"));
        bean.setType(props.getString(bean.getInfid() + ".type"));
        bean.setUpdate_outbound_on_statusreport(props.getString(bean.getInfid() + ".update_outbound_on_statusreport"));
        bean.setUsername(props.getString(bean.getInfid() + ".username"));
        bean.setUrlRac(props.getString(bean.getInfid() + ".url.rac", "jdbc:oracle:thin:@(DESCRIPTION=(LOAD_BALANCE=on)(ADDRESS_LIST=(ADDRESS=(PROTOCOL=TCP)(HOST=192.168.0.186)(PORT=1521))(ADDRESS=(PROTOCOL=TCP)(HOST=192.168.0.187)(PORT=1521)))(CONNECT_DATA=(SERVICE_NAME=jdsms)))"));
        return bean;
    }

    String[] a(String url, String type) {
        if (type.equalsIgnoreCase("mysql") || type.equalsIgnoreCase("mysql8")) {
            if (type.equalsIgnoreCase("mysql8")) {
                url = url.substring(0, url.lastIndexOf(47));
            }
            String tmp = url.substring(url.indexOf(47) + 2, url.lastIndexOf(47));
            String[] tmp1 = tmp.split(":");
            String dbname = url.substring(url.lastIndexOf(47) + 1, url.indexOf(63));
            String[] result = new String[]{tmp1[0], tmp1[1], dbname};
            return result;
        }
        if (type.equalsIgnoreCase("oracle")) {
            String tmp = url.substring(url.indexOf(64) + 1);
            String[] tmp1 = tmp.split(":");
            return tmp1;
        }
        if (type.equalsIgnoreCase("mssql")) {
            String tmp = url.substring(url.indexOf(47) + 2, url.indexOf(59));
            String[] tmp1 = tmp.split(":");
            String dbname = url.substring(url.indexOf(59) + 1);
            String[] tmp2 = dbname.split(";");
            for (int i2 = 0; i2 < tmp2.length; ++i2) {
                if (!tmp2[i2].startsWith("Database")) continue;
                String[] tmp3 = tmp2[i2].split("=");
                dbname = tmp3[1];
            }
            String[] result = new String[]{tmp1[0], tmp1[1], dbname};
            return result;
        }
        if (type.equalsIgnoreCase("postgresql") || type.equalsIgnoreCase("DM7")) {
            String tmp = url.substring(url.indexOf(47) + 2, url.lastIndexOf(47));
            String[] tmp1 = tmp.split(":");
            String dbname = url.substring(url.lastIndexOf(47) + 1).trim();
            String[] result = new String[]{tmp1[0], tmp1[1], dbname};
            return result;
        }
        if (type.equalsIgnoreCase("OSCAR7")) {
            String tmp = url.substring(url.indexOf(47) + 2, url.lastIndexOf(47));
            String[] tmp1 = tmp.split(":");
            String dbname = url.substring(url.lastIndexOf(47) + 1).trim();
            String[] result = new String[]{tmp1[0], tmp1[1], dbname};
            return result;
        }
        if (type.equalsIgnoreCase("KINGBASE8")) {
            String tmp = url.substring(url.indexOf(47) + 2, url.lastIndexOf(47));
            String[] tmp1 = tmp.split(":");
            String dbname = url.substring(url.lastIndexOf(47) + 1).trim();
            String[] result = new String[]{tmp1[0], tmp1[1], dbname};
            return result;
        }
        if (type.equalsIgnoreCase("GBASE8A")) {
            String tmp = url.substring(url.indexOf(47) + 2, url.lastIndexOf(47));
            String[] tmp1 = tmp.split(":");
            String dbname = url.substring(url.lastIndexOf(47) + 1, url.indexOf(63));
            String[] result = new String[]{tmp1[0], tmp1[1], dbname};
            return result;
        }
        String[] result = new String[]{"", "", ""};
        return result;
    }

    private void a() {
        if (this.datasource.getType().startsWith("mssql")) {
            if (this.datasource.getType().equalsIgnoreCase("mssql2000")) {
                this.datasource.setType("mssql");
                this.datasource.setMssqltype("mssql2000");
            }
            if (this.datasource.getType().equalsIgnoreCase("mssql2005-2017")) {
                this.datasource.setType("mssql");
                this.datasource.setMssqltype("mssql2005-2017");
            }
        }
    }
}

