/*
 * Decompiled with CFR 0.152.
 */
package cn.sendsms.modem;

import cn.sendsms.GatewayException;
import cn.sendsms.TimeoutException;
import cn.sendsms.helper.AGatewayHelper;
import cn.sendsms.helper.Logger;
import cn.sendsms.jdsmsserver.web.DeviceInfoCache;
import cn.sendsms.jdsmsserver.web.SerialModemBean;
import cn.sendsms.modem.ModemGateway;
import java.io.IOException;

public class SerialModemGateway
extends ModemGateway {
    public SerialModemGateway(String id, String comPort, int baudRate, String manufacturer, String model) {
        super(ModemGateway.ModemTypes.SERIAL, id, comPort, baudRate, manufacturer, model);
    }

    @Override
    public void setStatus(AGatewayHelper.GatewayStatuses myStatus) {
        super.setStatus(myStatus);
        SerialModemBean bean = DeviceInfoCache.getInstance().get(this.getModemDevice());
        if (bean != null) {
            bean.setStatus(this.getStatus());
        } else {
            Logger.getInstance().logError("\u8bbe\u5907\u72b6\u6001\u66f4\u65b0\u5931\u8d25\u3002 ", null, null);
        }
    }

    public SerialModemGateway(SerialModemBean bean) {
        super(ModemGateway.ModemTypes.SERIAL, bean.getGatewayID(), bean.getPort(), bean.getBaudrate(), bean.getManufacturer(), bean.getModel());
        this.setProtocol(bean.getProtocol());
        if (bean.getInbound().equalsIgnoreCase("yes")) {
            this.setInbound(true);
        } else {
            this.setInbound(false);
        }
        if (bean.getOutbound().equalsIgnoreCase("yes")) {
            this.setOutbound(true);
        } else {
            this.setOutbound(false);
        }
        this.setSimPin(bean.getPin());
        this.setCustomInitString(bean.getInit_string());
        this.setSmscNumber(bean.getSmsc_number());
    }

    @Override
    public void startGateway() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.setStatus(AGatewayHelper.GatewayStatuses.STARTING);
        try {
            super.startGateway();
        }
        catch (GatewayException e2) {
            e2.printStackTrace();
            if (e2 instanceof GatewayException) {
                if (e2.getMessage().indexOf("NoSuchPort") != -1) {
                    this.setStatus(AGatewayHelper.GatewayStatuses.NOPORT);
                } else if (e2.getMessage().indexOf("PortInUse") != -1) {
                    this.setStatus(AGatewayHelper.GatewayStatuses.OCCUPY);
                } else {
                    this.setStatus(AGatewayHelper.GatewayStatuses.STOPPED);
                }
                return;
            }
            throw e2;
        }
        this.judgeAuthorize();
    }

    @Override
    public void stopGateway() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.setStatus(AGatewayHelper.GatewayStatuses.STOPPING);
        super.stopGateway();
    }
}

