/*
 * Decompiled with CFR 0.152.
 */
package cn.sendsms.modem.athandler;

import cn.sendsms.GatewayException;
import cn.sendsms.InboundMessage;
import cn.sendsms.TimeoutException;
import cn.sendsms.modem.ModemGateway;
import cn.sendsms.modem.athandler.ATHandler_Wavecom;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ATHandler_Wavecom_Q2438F
extends ATHandler_Wavecom {
    public ATHandler_Wavecom_Q2438F(ModemGateway myGateway) {
        super(myGateway);
        this.setStorageLocations("MT");
    }

    @Override
    public String listMessages(InboundMessage.MessageClasses messageClass) throws TimeoutException, GatewayException, IOException, InterruptedException {
        String line = null;
        StringBuffer msgList = new StringBuffer();
        if (messageClass == InboundMessage.MessageClasses.ALL) {
            this.getModemDriver().write("AT+CMGL=\"ALL\"\r");
        } else if (messageClass == InboundMessage.MessageClasses.UNREAD) {
            this.getModemDriver().write("AT+CMGL=\"REC UNREAD\"\r");
        } else if (messageClass == InboundMessage.MessageClasses.READ) {
            this.getModemDriver().write("AT+CMGL=\"REC READ\"\r");
        }
        String listMsgRespons = this.getModemDriver().getResponse4CDMA();
        BufferedReader reader = new BufferedReader(new StringReader(listMsgRespons));
        while ((line = reader.readLine()) != null) {
            if (!line.matches("^\\+CMGL:\\s*\\d+,.*")) continue;
            int memIndex = 0;
            int i2 = line.indexOf(58);
            int j2 = line.indexOf(44);
            memIndex = Integer.parseInt(line.substring(i2 + 1, j2).trim());
            String oneMessage = this.getGateway().getMessageByIndex(memIndex);
            BufferedReader oneMessageReader = new BufferedReader(new StringReader(oneMessage));
            String header = oneMessageReader.readLine().trim();
            String headerRegex = "(^\\+CMGR:)(\\\"[^\\\"]+\\\",)(\\\"[^\\\"]+\\\",)(\\\"[^,]+,)(\\d+)\\s+(:\\d+)\\s+(:\\d+\\\")(,\\d,)(\\d)";
            Pattern headerPattern = Pattern.compile(headerRegex);
            Matcher headerMatcher = headerPattern.matcher(header);
            header = headerMatcher.replaceAll("$1 " + memIndex + ",$2$3,$4$5$6$7$8$9");
            char encoding = headerMatcher.replaceAll("$9").charAt(0);
            StringBuffer msgContent = new StringBuffer();
            String bodyLine = "";
            while ((bodyLine = oneMessageReader.readLine()) != null) {
                if ((bodyLine = bodyLine.trim()).length() <= 0 || bodyLine.equalsIgnoreCase("OK")) continue;
                msgContent.append(bodyLine);
            }
            String msgContentStr = msgContent.toString();
            if (encoding == '4') {
                char[] unicodeText = msgContentStr.toCharArray();
                msgContentStr = new String(unicodeText);
            }
            String msgText = header + "\r" + msgContentStr + "\r";
            msgList.append(msgText);
        }
        reader.close();
        return msgList.toString();
    }

    @Override
    public String getManufacturer() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getModemDriver().write("AT+WGMI\r");
        return this.getModemDriver().getResponse().replaceAll("\\+WGMI: ", "");
    }

    @Override
    public String getModel() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getModemDriver().write("AT+WGMM\r");
        return this.getModemDriver().getResponse().replaceAll("\\+WGMM: ", "");
    }

    @Override
    public String getSimStatus() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getModemDriver().write("AT+WPIN?\r");
        return this.getModemDriver().getResponse();
    }

    @Override
    public boolean enterPin(String pin) throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getModemDriver().write("AT+WPIN=3,_1_\r".replaceAll("_1_", pin));
        this.getModemDriver().getResponse();
        return this.getModemDriver().isOk();
    }

    @Override
    public String getBatteryLevel() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getModemDriver().write("AT+CBC?\r");
        return this.getModemDriver().getResponse();
    }

    @Override
    public String getSerialNo() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getModemDriver().write("AT+CGSN\r");
        return this.getModemDriver().getResponse().replaceAll("\\+CGSN: ", "");
    }

    @Override
    public boolean setTextProtocol() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getModemDriver().write("AT+CSCS=\"CDMA\"\r");
        this.getModemDriver().getResponse();
        return this.getModemDriver().isOk();
    }
}

