/*
 * Decompiled with CFR 0.152.
 */
package cn.sendsms.otherModem.common;

import cn.sendsms.tools.IntStater;
import cn.sendsms.tools.TimeChecker;
import cn.sendsms.util.ComRecvBuffer;
import java.io.UnsupportedEncodingException;
import java.util.List;
import jssc.SerialPort;
import jssc.SerialPortException;
import org.apache.log4j.Logger;

public class ComReadWriter {
    private String a;
    private ComRecvBuffer b = new ComRecvBuffer();

    public String getIdInfo() {
        return this.a;
    }

    public void setIdInfo(String idInfo) {
        this.a = idInfo;
    }

    public String getRecvLine() {
        return this.b.popLineString();
    }

    public void clearRecv() {
        this.b.reset();
    }

    public boolean send(SerialPort port, String szValue) {
        if (!ComReadWriter.xIsPortOk(port)) {
            return false;
        }
        this.recvNoWait(port);
        Logger.getRootLogger().info((Object)(port.getPortName() + "-SENDING(1):" + szValue));
        boolean bOk = false;
        try {
            bOk = port.writeBytes(szValue.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e2) {
            e2.printStackTrace();
        }
        catch (SerialPortException e3) {
            e3.printStackTrace();
        }
        return bOk;
    }

    public String recvNoWait(SerialPort port) {
        String szRet;
        if (!ComReadWriter.xIsPortOk(port)) {
            return "";
        }
        byte[] szBytes = null;
        try {
            szBytes = port.readBytes();
        }
        catch (SerialPortException e2) {
            e2.printStackTrace();
        }
        if (szBytes == null || szBytes.length < 1) {
            return "";
        }
        this.b.append(szBytes);
        try {
            szRet = new String(szBytes, "UTF-8");
        }
        catch (UnsupportedEncodingException e3) {
            e3.printStackTrace();
            szRet = "";
        }
        return szRet;
    }

    public ComReadResult recv(SerialPort port, long nWaitMilliSeconds) {
        return this.recv(port, "OK", "ERROR", nWaitMilliSeconds);
    }

    public ComReadResult recv(SerialPort port, String szOkTag, String szErrorTag, long nWaitMilliSeconds) {
        ComReadResult result = new ComReadResult();
        long nTimeOut = nWaitMilliSeconds;
        if (nTimeOut < 0L || nTimeOut > 60000L) {
            nTimeOut = 60000L;
        }
        String szOk = szOkTag;
        String szError = szErrorTag;
        if (szOk == null || szOk.length() < 1) {
            szOk = "OK";
        }
        if (szError == null || szError.length() < 1) {
            szError = "ERROR";
        }
        long lastTime = TimeChecker.currentMilliSeconds();
        while (result.code == 0) {
            result.szValue = result.szValue + this.recvNoWait(port);
            if (result.szValue.indexOf(szOk) >= 0) {
                result.code = 1;
                break;
            }
            if (result.szValue.indexOf(szError) >= 0) {
                result.code = 2;
                break;
            }
            if (TimeChecker.checkTimeoutMillSeconds(lastTime, nTimeOut)) {
                result.code = 3;
                break;
            }
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e2) {
                e2.printStackTrace();
            }
        }
        return result;
    }

    public ComReadResult recv(SerialPort port, List<String> szOkTagList, List<String> szErrorTagList, long nWaitMilliSeconds) {
        if (szOkTagList.size() < 1 || szErrorTagList.size() < 1) {
            return this.recv(port, nWaitMilliSeconds);
        }
        ComReadResult result = new ComReadResult();
        long nTimeOut = nWaitMilliSeconds;
        if (nTimeOut < 0L || nTimeOut > 60000L) {
            nTimeOut = 60000L;
        }
        long lastTime = TimeChecker.currentMilliSeconds();
        while (result.code == 0) {
            result.szValue = result.szValue + this.recvNoWait(port);
            boolean bFind = false;
            for (String szOk : szOkTagList) {
                if (result.szValue.indexOf(szOk) < 0) continue;
                bFind = true;
                result.code = 1;
                break;
            }
            if (bFind) break;
            for (String szError : szErrorTagList) {
                if (result.szValue.indexOf(szError) < 0) continue;
                bFind = true;
                result.code = 2;
                break;
            }
            if (bFind) break;
            if (TimeChecker.checkTimeoutMillSeconds(lastTime, nTimeOut)) {
                result.code = 3;
                break;
            }
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e2) {
                e2.printStackTrace();
            }
        }
        return result;
    }

    public ComReadResult recvWithStater(SerialPort port, long nWaitMilliSeconds, IntStater stater) {
        return this.recvWithStater(port, "OK", "ERROR", nWaitMilliSeconds, stater);
    }

    public ComReadResult recvWithStater(SerialPort port, String szOkTag, String szErrorTag, long nWaitMilliSeconds, IntStater stater) {
        ComReadResult result = new ComReadResult();
        long nTimeOut = nWaitMilliSeconds;
        if (nTimeOut < 0L || nTimeOut > 60000L) {
            nTimeOut = 60000L;
        }
        String szOk = szOkTag;
        String szError = szErrorTag;
        if (szOk == null || szOk.length() < 1) {
            szOk = "OK";
        }
        if (szError == null || szError.length() < 1) {
            szError = "ERROR";
        }
        long lastTime = TimeChecker.currentMilliSeconds();
        while (result.code == 0) {
            result.szValue = result.szValue + this.recvNoWait(port);
            if (result.szValue.indexOf(szOk) >= 0) {
                result.code = 1;
                break;
            }
            if (result.szValue.indexOf(szError) >= 0) {
                result.code = 2;
                break;
            }
            if (TimeChecker.checkTimeoutMillSeconds(lastTime, nTimeOut)) {
                result.code = 3;
                break;
            }
            if (stater != null && stater.getVal() >= 99900) break;
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e2) {
                e2.printStackTrace();
            }
        }
        return result;
    }

    public static boolean xIsPortOk(SerialPort port) {
        if (port == null) {
            return false;
        }
        return port.isOpened();
    }

    public static void xClosePort(SerialPort port) {
        if (!ComReadWriter.xIsPortOk(port)) {
            return;
        }
        try {
            port.closePort();
        }
        catch (SerialPortException e2) {
            e2.printStackTrace();
        }
    }

    public static boolean xSend(SerialPort port, String szValue) {
        if (!ComReadWriter.xIsPortOk(port)) {
            return false;
        }
        ComReadWriter.xRecvNoWait(port);
        Logger.getRootLogger().info((Object)(port.getPortName() + "-SENDING(0):" + szValue));
        boolean bOk = false;
        try {
            bOk = port.writeBytes(szValue.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e2) {
            e2.printStackTrace();
        }
        catch (SerialPortException e3) {
            e3.printStackTrace();
        }
        return bOk;
    }

    public static String xRecvNoWait(SerialPort port) {
        String szRet;
        if (!ComReadWriter.xIsPortOk(port)) {
            return "";
        }
        byte[] szBytes = null;
        try {
            szBytes = port.readBytes();
        }
        catch (SerialPortException e2) {
            e2.printStackTrace();
        }
        if (szBytes == null || szBytes.length < 1) {
            return "";
        }
        try {
            szRet = new String(szBytes, "UTF-8");
        }
        catch (UnsupportedEncodingException e3) {
            e3.printStackTrace();
            szRet = "";
        }
        return szRet;
    }

    public static ComReadResult xRecv(SerialPort port, long nWaitMilliSeconds) {
        return ComReadWriter.xRecv(port, "OK", "ERROR", nWaitMilliSeconds);
    }

    public static ComReadResult xRecv(SerialPort port, String szOkTag, String szErrorTag, long nWaitMilliSeconds) {
        ComReadResult result = new ComReadResult();
        if (port == null) {
            return result;
        }
        if (!ComReadWriter.xIsPortOk(port)) {
            return result;
        }
        long nTimeOut = nWaitMilliSeconds;
        if (nTimeOut < 0L || nTimeOut > 60000L) {
            nTimeOut = 60000L;
        }
        String szOk = szOkTag;
        String szError = szErrorTag;
        if (szOk == null || szOk.length() < 1) {
            szOk = "OK";
        }
        if (szError == null || szError.length() < 1) {
            szError = "ERROR";
        }
        long lastTime = TimeChecker.currentMilliSeconds();
        while (result.code == 0) {
            result.szValue = result.szValue + ComReadWriter.xRecvNoWait(port);
            if (result.szValue.indexOf(szOk) >= 0) {
                result.code = 1;
                break;
            }
            if (result.szValue.indexOf(szError) >= 0) {
                result.code = 2;
                break;
            }
            if (TimeChecker.checkTimeoutMillSeconds(lastTime, nTimeOut)) {
                result.code = 3;
                break;
            }
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e2) {
                e2.printStackTrace();
            }
        }
        return result;
    }

    public static ComReadResult xRecvWithStater(SerialPort port, long nWaitMilliSeconds, IntStater stater) {
        return ComReadWriter.xRecvWithStater(port, "OK", "ERROR", nWaitMilliSeconds, stater);
    }

    public static ComReadResult xRecvWithStater(SerialPort port, String szOkTag, String szErrorTag, long nWaitMilliSeconds, IntStater stater) {
        ComReadResult result = new ComReadResult();
        long nTimeOut = nWaitMilliSeconds;
        if (nTimeOut < 0L || nTimeOut > 60000L) {
            nTimeOut = 60000L;
        }
        String szOk = szOkTag;
        String szError = szErrorTag;
        if (szOk == null || szOk.length() < 1) {
            szOk = "OK";
        }
        if (szError == null || szError.length() < 1) {
            szError = "ERROR";
        }
        long lastTime = TimeChecker.currentMilliSeconds();
        while (result.code == 0) {
            result.szValue = result.szValue + ComReadWriter.xRecvNoWait(port);
            if (result.szValue.indexOf(szOk) >= 0) {
                result.code = 1;
                break;
            }
            if (result.szValue.indexOf(szError) >= 0) {
                result.code = 2;
                break;
            }
            if (TimeChecker.checkTimeoutMillSeconds(lastTime, nTimeOut)) {
                result.code = 3;
                break;
            }
            if (stater != null && stater.getVal() >= 99900) break;
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e2) {
                e2.printStackTrace();
            }
        }
        return result;
    }

    public static class ComReadResult {
        public int code = 0;
        public String szValue = "";
    }
}

