/*
 * Decompiled with CFR 0.152.
 */
package cn.sendsms.otherModem.nbiot;

import cn.sendsms.OutboundMessage;
import cn.sendsms.jdsmsserver.JDSMSServer;
import cn.sendsms.jdsmsserver.web.NewAuth;
import cn.sendsms.otherModem.bean.BC26NbIoTBean;
import cn.sendsms.otherModem.bean.NbIoTBean;
import cn.sendsms.otherModem.bean.VitualNbIoTBean;
import cn.sendsms.otherModem.common.Const;
import cn.sendsms.otherModem.common.Utils;
import cn.sendsms.otherModem.driver.nbiotDriver.NbIoTDriver;
import cn.sendsms.otherModem.driver.nbiotDriver.VirtualNbIoTDriver;
import cn.sendsms.otherModem.modem.Modem;
import cn.sendsms.otherModem.nbiot.DeviceMqttCallback;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import jssc.SerialPort;
import jssc.SerialPortList;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.log4j.Logger;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;

public class NbIoTDeviceInfoGetter {
    Map<String, Integer> a = new HashMap<String, Integer>();
    private static int loop = -1;
    public static final Logger log = Logger.getRootLogger();
    public static final List<String> NBIOT_DEVICE_TYPE_LIST = new ArrayList<String>(){
        {
            this.add("M5310-A");
            this.add("Quectel_BC26");
            this.add("SIM7020C");
            this.add("XYM110");
            this.add("Quectel_BC32-B8");
        }
    };
    private static Vector<SerialPort> serialPorts = new Vector();
    private static Vector<NbIoTBean> devices = new Vector();

    private NbIoTDeviceInfoGetter() {
    }

    public static NbIoTDeviceInfoGetter getInstance() {
        return cn.sendsms.otherModem.nbiot.NbIoTDeviceInfoGetter$a.a;
    }

    public synchronized void deleteAll() {
        int index;
        while ((index = this.getindexByDeviceType(devices)) >= 0) {
            devices.removeElementAt(index);
        }
        while ((index = this.getindexByComName(serialPorts)) >= 0) {
            serialPorts.removeElementAt(index);
        }
    }

    public void addNbIoT(NbIoTBean obj) {
        devices.add(obj);
    }

    public List<NbIoTBean> getAll() {
        ArrayList<NbIoTBean> list = new ArrayList<NbIoTBean>();
        for (int i2 = 0; i2 < devices.size(); ++i2) {
            list.add(devices.get(i2));
        }
        return list;
    }

    public synchronized void getNbIoTDeviceInfo() throws Exception {
        int i2;
        long startTime = System.currentTimeMillis();
        this.deleteAll();
        String[] portList = SerialPortList.getPortNames();
        int deviceID = 1;
        block0: for (i2 = 0; i2 < portList.length; ++i2) {
            for (int j2 = 0; j2 < Const.BAUDRATES.length; ++j2) {
                SerialPort serialPort = new SerialPort(portList[i2]);
                log.info((Object)("\u6b63\u5728\u5c1d\u8bd5\u6253\u5f00\u7aef\u53e3:" + portList[i2]));
                if (!Utils.openPort(Const.BAUDRATES[j2], serialPort)) {
                    log.error((Object)("\u7aef\u53e3" + portList[i2] + "\u6253\u5f00\u5931\u8d25\u3002\u3002\u3002"));
                    continue;
                }
                if (NbIoTDriver.checkAT(serialPort)) {
                    String deviceType = NbIoTDriver.checkDeviceType(serialPort);
                    NbIoTBean nbiotInfo = null;
                    nbiotInfo = "Quectel_BC26".equals(deviceType) ? new BC26NbIoTBean() : new NbIoTBean();
                    if (!this.a(deviceType)) {
                        Utils.closePort(serialPort);
                        continue;
                    }
                    nbiotInfo.setDeviceType(deviceType);
                    nbiotInfo.setAT(true);
                    nbiotInfo.setBaudrate(Const.BAUDRATES[j2]);
                    nbiotInfo.setGatewayID("nbiot" + deviceID);
                    ++deviceID;
                    nbiotInfo.setPortID(portList[i2]);
                    String signal = Modem.getDriver(nbiotInfo.getDeviceType()).getSignal(serialPort);
                    String serialNumber = Modem.getDriver(nbiotInfo.getDeviceType()).getSerialNumber(serialPort);
                    String communicationID = NbIoTDriver.getNbIoTDriver(nbiotInfo.getDeviceType()).getCommunicationID(serialNumber);
                    nbiotInfo.setSerialNumber(serialNumber);
                    nbiotInfo.setCommunicationID(communicationID);
                    nbiotInfo.setSignal(signal.replace(" ", ""));
                    nbiotInfo.setUsingStatus("0");
                    this.addNbIoT(nbiotInfo);
                    serialPorts.add(serialPort);
                    Utils.closePort(serialPort);
                    continue block0;
                }
                Utils.closePort(serialPort);
            }
        }
        for (i2 = 0; i2 < devices.size(); ++i2) {
            NbIoTBean nbiotInfo = devices.get(i2);
            String seiralNumber = this.getSerialNumber(nbiotInfo.getPortID());
            nbiotInfo.setSerialNumber(seiralNumber);
            nbiotInfo.updateValidate(seiralNumber);
        }
        long endTime = System.currentTimeMillis();
        log.info((Object)("\u68c0\u6d4b\u8bbe\u5907\u82b1\u8d39\uff1a" + (endTime - startTime) + "ms"));
    }

    private boolean a(String deviceType) {
        return NBIOT_DEVICE_TYPE_LIST.contains(deviceType);
    }

    public List<String> getUsingNbIoTList() {
        ArrayList<String> list = new ArrayList<String>();
        for (int i2 = 0; i2 < devices.size(); ++i2) {
            NbIoTBean device = devices.get(i2);
            if (!device.getUsingStatus().equals("1")) continue;
            list.add(device.getGatewayID());
        }
        return list;
    }

    public boolean addVitualDevice() {
        String vitualPortID = this.a();
        if (Utils.isEmptyStr(vitualPortID)) {
            log.error((Object)"\u5df2\u7ecf\u5230\u8fbe\u53ef\u6dfb\u52a0\u7684\u865a\u62df\u8bbe\u5907\u7684\u6700\u5927\u6570\u76ee\uff01");
            return false;
        }
        VitualNbIoTBean vitualDevice = new VitualNbIoTBean();
        vitualDevice.setDeviceType("JD-VITUAL-NBIOT-DEVICE");
        vitualDevice.setNetworkNormal(true);
        vitualDevice.setPortID(vitualPortID);
        String gateway_id = "nbiot" + vitualPortID.split("-")[1] + "(V)";
        vitualDevice.setGatewayID(gateway_id);
        vitualDevice.setAT(true);
        vitualDevice.setSignal(VirtualNbIoTDriver.getInstance().getSignal(null));
        String communicationID = VirtualNbIoTDriver.getInstance().getCommunicationID("");
        vitualDevice.setCommunicationID(communicationID);
        MqttClient client = this.generateMqttClient(communicationID);
        if (client == null) {
            return false;
        }
        vitualDevice.setClient(client);
        vitualDevice.setSerialNumber(communicationID);
        vitualDevice.updateValidate(communicationID);
        this.addNbIoT(vitualDevice);
        SerialPort serialPort = new SerialPort(vitualPortID);
        serialPorts.add(serialPort);
        return true;
    }

    private String a() {
        String portID;
        int i2;
        String vitualPortaID = "";
        PropertiesConfiguration props = JDSMSServer.getInstance().getProperties();
        int maxNUmberOfVitualDevice = props.getInt("max_number_of_vitual_device", 100);
        ArrayList<NbIoTBean> vitualDeviceList = this.getVitualDevice();
        HashSet<String> vitualPortIDSet = new HashSet<String>();
        for (i2 = 0; i2 < vitualDeviceList.size(); ++i2) {
            portID = vitualDeviceList.get(i2).getPortID();
            if (Utils.isEmptyStr(portID)) continue;
            vitualPortIDSet.add(portID);
        }
        for (i2 = 1; i2 <= maxNUmberOfVitualDevice; ++i2) {
            portID = "Vitual-" + i2 + "-COM";
            if (vitualPortIDSet.contains(portID)) continue;
            vitualPortaID = portID;
            break;
        }
        return vitualPortaID;
    }

    public ArrayList<NbIoTBean> getVitualDevice() {
        ArrayList<NbIoTBean> list = new ArrayList<NbIoTBean>();
        for (int i2 = 0; i2 < devices.size(); ++i2) {
            if (!"JD-VITUAL-NBIOT-DEVICE".equals(devices.get(i2).getDeviceType())) continue;
            list.add(devices.get(i2));
        }
        return list;
    }

    public String getSerialNumber(String portID) {
        String serialNumber = "";
        for (int i2 = 0; i2 < devices.size(); ++i2) {
            NbIoTBean device = devices.get(i2);
            if (!portID.equals(device.getPortID())) continue;
            serialNumber = device.getSerialNumber();
        }
        return serialNumber;
    }

    public List<NbIoTBean> getUsingNbIoTs() {
        ArrayList<NbIoTBean> list = new ArrayList<NbIoTBean>();
        for (int i2 = 0; i2 < devices.size(); ++i2) {
            NbIoTBean device = devices.get(i2);
            if (!device.getUsingStatus().equals("1")) continue;
            list.add(device);
        }
        return list;
    }

    public boolean isNbIoTUsing(String portID) {
        for (int i2 = 0; i2 < devices.size(); ++i2) {
            NbIoTBean device = devices.get(i2);
            if (!portID.equals(device.getPortID()) || !device.getUsingStatus().equals("1")) continue;
            return true;
        }
        return false;
    }

    public void deleteNbIoT(String portID) throws ConfigurationException {
        NbIoTBean nbiotDevice = this.findDeviceByPortID(portID);
        if (nbiotDevice instanceof VitualNbIoTBean) {
            try {
                String communicationID = nbiotDevice.getCommunicationID();
                MqttClient mqttClient = ((VitualNbIoTBean)nbiotDevice).getClient();
                mqttClient.unsubscribe(communicationID);
                mqttClient.close(true);
            }
            catch (Exception e2) {
                log.error((Object)("\u865a\u62df\u8bbe\u5907" + nbiotDevice.getGatewayID() + "\u5220\u9664\u5f02\u5e38!"));
            }
        }
        block2: for (int i2 = 0; i2 < devices.size(); ++i2) {
            NbIoTBean device = devices.get(i2);
            if (!device.getPortID().equals(portID)) continue;
            this.a(device);
            devices.removeElementAt(i2);
            for (int j2 = 0; j2 < serialPorts.size(); ++j2) {
                SerialPort serialPort = serialPorts.get(j2);
                if (!serialPort.getPortName().equals(portID)) continue;
                serialPorts.removeElementAt(j2);
                break block2;
            }
            break;
        }
    }

    private void a(NbIoTBean bean) throws ConfigurationException {
        PropertiesConfiguration props = JDSMSServer.getInstance().getProperties();
        boolean flag = false;
        int i2 = 0;
        for (i2 = 0; i2 < 64; ++i2) {
            if (props.getString("nbiotDevice." + i2, "").trim().length() == 0 || props.getString("nbiotDevice." + i2, "").indexOf(bean.getGatewayID()) == -1) continue;
            flag = true;
            props.clearProperty("nbiotDevice." + i2);
            break;
        }
        if (flag) {
            props.clearProperty(bean.getGatewayID() + ".port");
            props.clearProperty(bean.getGatewayID() + ".device_type");
            props.clearProperty(bean.getGatewayID() + ".baudrate");
            props.clearProperty(bean.getGatewayID() + ".using_status");
            props.clearProperty(bean.getGatewayID() + ".serial_number");
            props.clearProperty(bean.getGatewayID() + ".communication_id");
        }
        props.save();
    }

    public void saveConfigInfo(NbIoTBean bean) throws ConfigurationException {
        PropertiesConfiguration props = JDSMSServer.getInstance().getProperties();
        Configuration config = JDSMSServer.getInstance().getProperties().subset("nbiotDevice");
        int count = 0;
        boolean flag = false;
        Iterator it = config.getKeys();
        while (it.hasNext()) {
            String v = config.getString((String)it.next());
            if (!v.equals(bean.getGatewayID())) continue;
            flag = true;
            break;
        }
        if (!flag) {
            while (count < 64) {
                if (JDSMSServer.getInstance().getProperties().getString("nbiotDevice." + count, "").length() == 0) {
                    props.setProperty("nbiotDevice." + count, (Object)(bean.getGatewayID() + ",NbIoT"));
                    break;
                }
                ++count;
            }
        }
        props.setProperty(bean.getGatewayID() + ".port", (Object)bean.getPortID());
        props.setProperty(bean.getGatewayID() + ".device_type", (Object)bean.getDeviceType());
        props.setProperty(bean.getGatewayID() + ".baudrate", (Object)bean.getBaudrate());
        props.setProperty(bean.getGatewayID() + ".serial_number", (Object)bean.getSerialNumber());
        props.setProperty(bean.getGatewayID() + ".using_status", (Object)bean.getUsingStatus());
        props.setProperty(bean.getGatewayID() + ".communication_id", (Object)bean.getCommunicationID());
        props.save();
    }

    public boolean checkStartNbIoT(String portID) {
        for (int i2 = 0; i2 < devices.size(); ++i2) {
            NbIoTBean device = devices.get(i2);
            if (!device.getPortID().equals(portID) || !device.getUsingStatus().equals("1")) continue;
            return true;
        }
        return false;
    }

    public boolean checkStopNbIoT(String portID) {
        for (int i2 = 0; i2 < devices.size(); ++i2) {
            NbIoTBean device = devices.get(i2);
            if (!device.getPortID().equals(portID) || !device.getUsingStatus().equals("0")) continue;
            return true;
        }
        return false;
    }

    public int getbaudrate(String portID) {
        NbIoTBean serialNbIoTBean = this.findDeviceByPortID(portID);
        if (serialNbIoTBean != null) {
            return serialNbIoTBean.getBaudrate();
        }
        log.error((Object)"\u83b7\u53d6\u6ce2\u7279\u7387\u5931\u8d25\uff0c\u91c7\u7528\u9ed8\u8ba4\u6ce2\u7279\u73879600");
        return 9600;
    }

    public NbIoTBean findDeviceByPortID(String portID) {
        List<NbIoTBean> list = this.getAll();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            if (!list.get(i2).getPortID().equals(portID)) continue;
            return list.get(i2);
        }
        return null;
    }

    public NbIoTBean findDeviceByGatewayID(String gatewayID) {
        List<NbIoTBean> list = this.getAll();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            if (!list.get(i2).getGatewayID().equals(gatewayID)) continue;
            return list.get(i2);
        }
        return null;
    }

    public VitualNbIoTBean findVitualNbIoTBeanByPortID(String portID) {
        NbIoTBean device = this.findDeviceByPortID(portID);
        if (device instanceof VitualNbIoTBean) {
            return (VitualNbIoTBean)device;
        }
        return null;
    }

    public NbIoTBean findVitualNbIoTBeanByCommunicationID(String communicationID) {
        List<NbIoTBean> list = this.getAll();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            if (!list.get(i2).getCommunicationID().equals(communicationID)) continue;
            return list.get(i2);
        }
        return null;
    }

    public BC26NbIoTBean findBC26NbIoTBeanByPortID(String portID) {
        NbIoTBean device = this.findDeviceByPortID(portID);
        if (device instanceof BC26NbIoTBean) {
            return (BC26NbIoTBean)device;
        }
        return null;
    }

    public MqttClient findClientByPortID(String portID) {
        VitualNbIoTBean vitualDevice = this.findVitualNbIoTBeanByPortID(portID);
        return vitualDevice.getClient();
    }

    public String getPortIDByLoop(OutboundMessage msg) {
        if (this.getUsingNbIoTList().isEmpty()) {
            return "";
        }
        String gatewayID = msg.getGatewayId();
        String recipient = msg.getRecipient();
        if (gatewayID == null || gatewayID.equals("")) {
            return "";
        }
        if (recipient == null || recipient.equals("")) {
            return "";
        }
        int loopTimes = 0;
        if ("~".equals(gatewayID)) {
            do {
                ++loop;
                if (++loopTimes <= devices.size()) continue;
                log.error((Object)"\u6ca1\u6709\u627e\u5230\u53ef\u7528\u7684\u7aef\u53e3");
                return "";
            } while (!(loop < devices.size() ? devices.get(loop).getUsingStatus().equals("1") : devices.get(loop = 0).getUsingStatus().equals("1")));
            return devices.get(loop).getPortID();
        }
        NbIoTBean device = this.findDeviceByGatewayID(gatewayID);
        if (device == null) {
            log.error((Object)("\u8bbe\u5907" + msg.getGatewayId() + "\u672a\u542f\u7528\u6216\u8005\u4e0d\u5b58\u5728\u3002\u3002\u3002"));
            return "";
        }
        return device.getPortID();
    }

    public void updateAvaliableNum(String portID) {
        String serialnum = this.findDeviceByPortID(portID).getSerialNumber();
        int num = NewAuth.getAvaliableNum(serialnum);
        --num;
        try {
            NewAuth.updateAvaliableNum(serialnum, num);
        }
        catch (SQLException e2) {
            return;
        }
    }

    public boolean hasIdleDevice(OutboundMessage msg) {
        String gatewayID = msg.getGatewayId();
        if ("~".equals(gatewayID)) {
            for (int i2 = 0; i2 < devices.size(); ++i2) {
                if (!devices.get(i2).isSendIdle()) continue;
                msg.setUsingPortID(devices.get(i2).getPortID());
                devices.get(i2).setSendIdle(false);
                return true;
            }
        } else {
            NbIoTBean device = this.findDeviceByGatewayID(gatewayID);
            if (device == null) {
                return false;
            }
            if (device.isSendIdle()) {
                msg.setUsingPortID(device.getPortID());
                device.setSendIdle(false);
                return true;
            }
        }
        return false;
    }

    public synchronized SerialPort getSerialPort(String portID) {
        for (int i2 = 0; i2 < serialPorts.size(); ++i2) {
            if (!serialPorts.get(i2).getPortName().equals(portID)) continue;
            return serialPorts.get(i2);
        }
        SerialPort serialPort = new SerialPort(portID);
        Utils.openPort(this.getbaudrate(portID), serialPort);
        serialPorts.add(serialPort);
        Utils.closePort(serialPort);
        return serialPort;
    }

    public boolean isNbIoTRegistered(String serialnum) throws Exception {
        String regcode = NewAuth.getAuthorizeInfo(serialnum, "regcode");
        if (regcode == null || regcode.indexOf("null") != -1) {
            regcode = "";
        }
        if (regcode.equals("")) {
            return false;
        }
        return NewAuth.checkDeviceAuth(serialnum);
    }

    public String getOriginator(String usingPortID) {
        if (usingPortID == null) {
            return "";
        }
        for (int i2 = 0; i2 < devices.size(); ++i2) {
            if (!devices.get(i2).getPortID().equals(usingPortID)) continue;
            return devices.get(i2).getCommunicationID();
        }
        return "";
    }

    public boolean checkAuthorizeInfo(String usingPort, OutboundMessage msg) {
        String gatewayID = this.findDeviceByPortID(usingPort).getGatewayID();
        String serialNum = this.findDeviceByPortID(usingPort).getSerialNumber();
        try {
            boolean flag = this.findDeviceByPortID(usingPort).isValidate();
            if (!flag) {
                if (msg != null) {
                    msg.setText("<\u8bf7\u586b\u5199\u8bbe\u5907\u6ce8\u518c\u7801>" + msg.getText());
                }
                int num = NewAuth.getAvaliableNum(serialNum);
                if (this.a.get(serialNum) == null || this.a.get(serialNum) != num) {
                    this.a.put(serialNum, num);
                    log.info((Object)("\u8bbe\u5907\u672a\u6388\u6743\uff0c\u8fd8\u53ef\u6536\u53d1" + num + "\u6761\u77ed\u4fe1" + gatewayID));
                }
                if (num < 1) {
                    log.warn((Object)("\u8bbe\u5907\u672a\u6388\u6743\uff0c\u6536\u53d1\u4fe1\u606f\u6761\u6570\u5df2\u8fbe\u5230\u6700\u5927\u9650\u5236\u657088\u6761,\u5df2\u505c\u6b62\u6536\u53d1\u4fe1\u606f" + gatewayID));
                    return false;
                }
            }
        }
        catch (Exception e2) {
            log.info((Object)("\u83b7\u53d6\u8bbe\u5907\u6388\u6743\u4fe1\u606f\u5931\u8d25\uff1a" + gatewayID), (Throwable)e2);
            return false;
        }
        return true;
    }

    public void initForNbIoT() {
        PropertiesConfiguration props = JDSMSServer.getInstance().getProperties();
        serialPorts.removeAllElements();
        Configuration config = props.subset("nbiotDevice");
        Iterator it = config.getKeys();
        while (it.hasNext()) {
            String deviceIDKey = (String)it.next();
            String deviceID = config.getString(deviceIDKey);
            String port = props.getString(deviceID + ".port", "");
            String deviceType = props.getString(deviceID + ".device_type", "");
            int baudrate = props.getInt(deviceID + ".baudrate", 9600);
            String serial_number = props.getString(deviceID + ".serial_number", "");
            String using_status = props.getString(deviceID + ".using_status", "0");
            String communicationID = props.getString(deviceID + ".communication_id", "");
            NbIoTBean nbiotInfo = null;
            nbiotInfo = "Quectel_BC26".equals(deviceType) ? new BC26NbIoTBean() : ("JD-VITUAL-NBIOT-DEVICE".equals(deviceType) ? new VitualNbIoTBean() : new NbIoTBean());
            nbiotInfo.setGatewayID(deviceID);
            nbiotInfo.setPortID(port);
            nbiotInfo.setDeviceType(deviceType);
            nbiotInfo.setBaudrate(baudrate);
            nbiotInfo.setSerialNumber(serial_number);
            nbiotInfo.setUsingStatus(using_status);
            nbiotInfo.setCommunicationID(communicationID);
            if (nbiotInfo instanceof VitualNbIoTBean) {
                MqttClient client = this.generateMqttClient(communicationID);
                if (client == null) {
                    log.error((Object)("\u7531\u4e8e\u672a\u6210\u529f\u521d\u59cb\u5316MQTT\u5ba2\u6237\u7aef\uff0c" + deviceID + "\u521d\u59cb\u5316\u5931\u8d25\u3002\u3002\u3002"));
                    continue;
                }
                ((VitualNbIoTBean)nbiotInfo).setClient(client);
            }
            this.addNbIoT(nbiotInfo);
        }
        List<NbIoTBean> nbiotInfoList = this.getAll();
        for (NbIoTBean nbiotInfo : nbiotInfoList) {
            String serial_number = nbiotInfo.getSerialNumber();
            nbiotInfo.updateValidate(serial_number);
            SerialPort serialPort = new SerialPort(nbiotInfo.getPortID());
            if (!Utils.openPort(nbiotInfo.getBaudrate(), serialPort)) {
                log.error((Object)"\u4ece\u914d\u7f6e\u6587\u4ef6\u4e2d\u8bfb\u53d6\u7684\u8bbe\u5907\u521d\u59cb\u5316\u5931\u8d25\u3002\u3002\u3002", null);
                continue;
            }
            serialPorts.add(serialPort);
            boolean isAt = NbIoTDriver.checkAT(serialPort);
            if (!isAt) {
                nbiotInfo.setUsingStatus("0");
            }
            nbiotInfo.setAT(isAt);
            nbiotInfo.setSignal(Modem.getDriver(nbiotInfo.getDeviceType()).getSignal(serialPort));
            if (nbiotInfo.getUsingStatus().equals("0")) {
                Utils.closePort(serialPort);
                continue;
            }
            if (Modem.getDriver(nbiotInfo.getDeviceType()).startDevice(serialPort.getPortName())) continue;
            Modem.getDriver(nbiotInfo.getDeviceType()).stopDevice(serialPort.getPortName());
        }
    }

    public MqttClient generateMqttClient(String communicationID) {
        MqttClient client = null;
        PropertiesConfiguration props = JDSMSServer.getInstance().getProperties();
        String mqttServer = props.getString("settings.mqtt_server", "gateway.sendsms.cn");
        String mqttPort = props.getString("settings.mqtt_port", "1883");
        String host = "tcp://" + mqttServer + ":" + mqttPort;
        MemoryPersistence persistence = new MemoryPersistence();
        try {
            client = new MqttClient(host, communicationID + "JD2021-1124", (MqttClientPersistence)persistence);
        }
        catch (MqttException e2) {
            log.error((Object)"MQTT\u5ba2\u6237\u7aef\u521d\u59cb\u5316\u5931\u8d25\u3002\u3002\u3002", (Throwable)e2);
        }
        client.setCallback((MqttCallback)new DeviceMqttCallback(communicationID));
        return client;
    }

    public int getindexByDeviceType(Vector<NbIoTBean> vector) {
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            if ("JD-VITUAL-NBIOT-DEVICE".equals(vector.get(i2).getDeviceType())) continue;
            return i2;
        }
        return -1;
    }

    public int getindexByComName(Vector<SerialPort> vector) {
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            if (vector.get(i2).getPortName().matches("Vitual-[0-9]+-COM")) continue;
            return i2;
        }
        return -1;
    }

    private static class a {
        private static NbIoTDeviceInfoGetter a = new NbIoTDeviceInfoGetter();

        private a() {
        }
    }
}

