/*
 * Decompiled with CFR 0.152.
 */
package cn.sendsms.queues;

import cn.sendsms.OutboundMessage;
import cn.sendsms.Service;
import cn.sendsms.helper.Logger;
import cn.sendsms.queues.AbstractQueueManager;
import cn.sendsms.queues.ScheduledOutboundMessage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.PriorityBlockingQueue;

public class DefaultQueueManager
extends AbstractQueueManager {
    public static final String MESSAGE_FILE_EXT = ".msg";
    private Map<String, PriorityBlockingQueue<OutboundMessage>> a;
    private DelayQueue<ScheduledOutboundMessage> b;
    private String c;
    private File d;
    private File e;

    public DefaultQueueManager() {
    }

    public DefaultQueueManager(String queueDirectory) {
        this.c = queueDirectory;
    }

    public DefaultQueueManager(int delay) {
        super(delay);
    }

    public DefaultQueueManager(int delay, String queueDirectory) {
        super(delay);
        this.c = queueDirectory;
    }

    @Override
    protected void init() {
        super.init();
        this.a = new HashMap<String, PriorityBlockingQueue<OutboundMessage>>();
        this.b = new DelayQueue();
        if (this.c == null) {
            this.c = Service.getInstance().getSettings().QUEUE_DIRECTORY;
            if (this.c == null) {
                Logger.getInstance().logInfo("Queue directory not defined. Queued messages will not be saved to filesystem.", null, null);
                return;
            }
        }
        File baseDir = new File(this.c, "queue");
        this.d = new File(baseDir, "pending");
        if (!this.d.exists()) {
            if (!this.d.mkdirs()) {
                Logger.getInstance().logError("Could not create directory for pending messages queue at " + this.d.getPath(), null, null);
            }
        } else {
            Logger.getInstance().logDebug("loading pending messages..", null, null);
            this.a();
        }
        this.e = new File(baseDir, "delayed");
        if (!this.e.exists()) {
            if (!this.e.mkdirs()) {
                Logger.getInstance().logError("Could not create directory for delayed messages queue at " + this.e.getPath(), null, null);
            }
        } else {
            Logger.getInstance().logDebug("loading delayed messages..", null, null);
            this.b();
        }
    }

    @Override
    public boolean queueMessage(OutboundMessage message) {
        if (message.getDeliveryDelay() > 0L) {
            return this.b(message, true);
        }
        return this.a(message, true);
    }

    @Override
    public boolean removePendingMessage(OutboundMessage message) {
        Iterator<PriorityBlockingQueue<OutboundMessage>> iter = this.a.values().iterator();
        while (iter.hasNext()) {
            PriorityBlockingQueue<OutboundMessage> q2 = iter.next();
            if (!q2.remove(message)) continue;
            this.a(message.getGatewayId(), message.getUuid());
            iter = null;
            return true;
        }
        iter = null;
        return false;
    }

    @Override
    public boolean removePendingMessage(String messageUUID) {
        Iterator<PriorityBlockingQueue<OutboundMessage>> iter = this.a.values().iterator();
        while (iter.hasNext()) {
            PriorityBlockingQueue<OutboundMessage> q2 = iter.next();
            Iterator<OutboundMessage> iterator = q2.iterator();
            while (iterator.hasNext()) {
                OutboundMessage m2 = iterator.next();
                if (!m2.getId().equalsIgnoreCase(messageUUID) || !q2.remove(m2)) continue;
                this.a(m2.getGatewayId(), messageUUID);
                iterator = null;
                iter = null;
                return true;
            }
            iterator = null;
        }
        iter = null;
        return false;
    }

    private boolean a(OutboundMessage message, boolean store) {
        PriorityBlockingQueue<OutboundMessage> queue = this.a.get(message.getGatewayId());
        if (queue == null) {
            queue = new PriorityBlockingQueue<OutboundMessage>(50, new a());
            this.a.put(message.getGatewayId(), queue);
        }
        boolean queued = queue.add(message);
        if (store && queued) {
            this.a(message);
        }
        return queued;
    }

    private boolean b(OutboundMessage message, boolean store) {
        boolean queued = this.b.add(new ScheduledOutboundMessage(message));
        if (store && queued) {
            this.b(message);
        }
        return queued;
    }

    private boolean a(OutboundMessage message) {
        if (this.c == null) {
            return true;
        }
        File gatewayDir = new File(this.d, message.getGatewayId());
        if (!gatewayDir.exists() && !gatewayDir.mkdir()) {
            Logger.getInstance().logError("Queue directory could be created for gateway " + message.getGatewayId() + ". Could not create directory .." + gatewayDir.getPath(), null, null);
            return false;
        }
        return this.a(message, new File(gatewayDir, message.getUuid() + MESSAGE_FILE_EXT));
    }

    private boolean a(String gatewayId, String messageUUID) {
        if (this.c == null) {
            return true;
        }
        return new File(new File(this.d, gatewayId), messageUUID + MESSAGE_FILE_EXT).delete();
    }

    private boolean a(String gatewayId) {
        if (this.c == null) {
            return true;
        }
        if (gatewayId == null) {
            return this.a(this.d, false);
        }
        return this.a(new File(this.d, gatewayId), true);
    }

    private boolean b(OutboundMessage message) {
        if (this.c == null) {
            return true;
        }
        return this.a(message, new File(this.e, message.getUuid() + MESSAGE_FILE_EXT));
    }

    private boolean b(String messageUUID) {
        if (this.c == null) {
            return true;
        }
        return new File(this.e, messageUUID + MESSAGE_FILE_EXT).delete();
    }

    @Override
    public OutboundMessage pollDelayedMessage() {
        try {
            OutboundMessage message = ((ScheduledOutboundMessage)this.b.take()).getMessage();
            this.b(message.getUuid());
            return message;
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
    }

    @Override
    public OutboundMessage pollPendingMessage(String gatewayId) {
        PriorityBlockingQueue<OutboundMessage> queue = this.a.get(gatewayId);
        if (queue == null) {
            return null;
        }
        OutboundMessage message = queue.poll();
        if (message != null) {
            this.a(gatewayId, message.getUuid());
        }
        return message;
    }

    private boolean a(OutboundMessage message, File toFile) {
        if (this.c == null) {
            return true;
        }
        if (toFile.exists()) {
            Logger.getInstance().logError("Cannot save Message " + message.getUuid() + " File already exist.", null, null);
            return false;
        }
        ObjectOutputStream out = null;
        try {
            out = new ObjectOutputStream(new FileOutputStream(toFile));
            out.writeObject(message);
            out.close();
        }
        catch (IOException e2) {
            Logger.getInstance().logError("Cannot save Message " + message.getUuid(), e2, null);
            return false;
        }
        return true;
    }

    private OutboundMessage a(File fromFile) {
        if (!fromFile.exists()) {
            Logger.getInstance().logError("File of queued message doesn't exist " + fromFile.getPath(), null, null);
            return null;
        }
        ObjectInputStream in = null;
        OutboundMessage message = null;
        try {
            in = new ObjectInputStream(new FileInputStream(fromFile));
            message = (OutboundMessage)in.readObject();
            in.close();
        }
        catch (IOException e2) {
            Logger.getInstance().logError("Could not read queued message from file " + fromFile.getPath(), e2, null);
            return null;
        }
        catch (ClassNotFoundException e3) {
            Logger.getInstance().logError("Could not read queued message from file " + fromFile.getPath(), e3, null);
            return null;
        }
        return message;
    }

    private void a() {
        File[] pendingDirs = this.d.listFiles();
        for (int i2 = 0; i2 < pendingDirs.length; ++i2) {
            File pendingDir = pendingDirs[i2];
            if (!pendingDir.isDirectory()) continue;
            File[] pendingFiles = pendingDir.listFiles();
            for (int j2 = 0; j2 < pendingFiles.length; ++j2) {
                File pendingFile = pendingFiles[j2];
                if (!pendingFile.getName().endsWith(MESSAGE_FILE_EXT)) continue;
                this.a(this.a(pendingFile), false);
            }
        }
    }

    private void b() {
        File[] delayedFiles = this.e.listFiles();
        for (int i2 = 0; i2 < delayedFiles.length; ++i2) {
            File delayedFile = delayedFiles[i2];
            if (!delayedFile.getName().endsWith(MESSAGE_FILE_EXT)) continue;
            OutboundMessage message = this.a(delayedFile);
            if (message.getDeliveryDelay() > 0L) {
                this.b(message, false);
                continue;
            }
            this.a(message, true);
            this.b(message.getUuid());
        }
    }

    @Override
    public int delayedQueueSize(String gatewayId) {
        return this.b.size();
    }

    @Override
    public Collection<OutboundMessage> getDelayedMessages() {
        ArrayList<OutboundMessage> messages = new ArrayList<OutboundMessage>();
        Iterator<ScheduledOutboundMessage> iter = this.b.iterator();
        while (iter.hasNext()) {
            messages.add(iter.next().getMessage());
        }
        iter = null;
        return messages;
    }

    @Override
    public Collection<OutboundMessage> getPendingMessages(String gatewayId) {
        PriorityBlockingQueue<OutboundMessage> queue = this.a.get(gatewayId);
        if (queue == null) {
            return new ArrayList<OutboundMessage>();
        }
        return new ArrayList<OutboundMessage>(queue);
    }

    @Override
    public int pendingQueueSize(String gatewayId) {
        PriorityBlockingQueue<OutboundMessage> queue = this.a.get(gatewayId);
        if (queue == null) {
            return 0;
        }
        return queue.size();
    }

    @Override
    public boolean removeDelayedMessage(OutboundMessage message) {
        Iterator<ScheduledOutboundMessage> iter = this.b.iterator();
        while (iter.hasNext()) {
            ScheduledOutboundMessage scheduledOutboundMessage = iter.next();
            if (!message.equals(scheduledOutboundMessage.getMessage()) || !this.b.remove(scheduledOutboundMessage)) continue;
            this.b(message.getUuid());
            iter = null;
            return true;
        }
        iter = null;
        return false;
    }

    @Override
    public boolean removeDelayedMessage(String messageUUID) {
        Iterator<ScheduledOutboundMessage> iter = this.b.iterator();
        while (iter.hasNext()) {
            ScheduledOutboundMessage scheduledOutboundMessage = iter.next();
            if (!messageUUID.equals(scheduledOutboundMessage.getMessage().getUuid()) || !this.b.remove(scheduledOutboundMessage)) continue;
            this.b(messageUUID);
            iter = null;
            return true;
        }
        iter = null;
        return false;
    }

    @Override
    public boolean removeAllDelayedMessages() {
        this.b.clear();
        if (this.c == null) {
            return true;
        }
        return this.a(this.e, false);
    }

    @Override
    public boolean removeAllPendingMessages(String gatewayId) {
        PriorityBlockingQueue<OutboundMessage> queue = this.a.get(gatewayId);
        if (queue != null) {
            queue.clear();
            this.a.remove(queue);
            this.a(gatewayId);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAllPendingMessages() {
        this.a.clear();
        this.a((String)null);
        return false;
    }

    private boolean a(File dir, boolean removeDir) {
        File[] pendingDirs = dir.listFiles();
        for (int i2 = 0; i2 < pendingDirs.length; ++i2) {
            File file = pendingDirs[i2];
            if (file.isDirectory()) {
                this.a(file, true);
                continue;
            }
            if (file.delete()) continue;
            return false;
        }
        if (removeDir) {
            return dir.delete();
        }
        return true;
    }

    class a
    implements Comparator<OutboundMessage> {
        a() {
        }

        public int a(OutboundMessage x, OutboundMessage y) {
            int comp = y.getPriority() - x.getPriority();
            if (comp == 0) {
                comp = x.getDate().compareTo(y.getDate());
            }
            return comp;
        }

        @Override
        public /* synthetic */ int compare(Object object, Object object2) {
            return this.a((OutboundMessage)object, (OutboundMessage)object2);
        }
    }
}

