/*
 * Decompiled with CFR 0.152.
 */
package cn.sendsms.threading;

import cn.sendsms.helper.Logger;

public abstract class AServiceThread
extends Thread {
    private int a;
    private int b;
    private boolean c;
    private boolean d;

    public AServiceThread(String name, int delay, int initialDelay, boolean enabled) {
        this.setName(name);
        this.setDelay(delay);
        if (enabled) {
            this.enable();
        } else {
            this.disable();
        }
        this.d = false;
        Logger.getInstance().logDebug("Initialized.", null, null);
        this.start();
    }

    public int getDelay() {
        return this.a;
    }

    public void setDelay(int delay) {
        this.a = delay;
    }

    public int getInitialDelay() {
        return this.b;
    }

    public void setInitialDelay(int initialDelay) {
        this.b = initialDelay;
    }

    public boolean isEnabled() {
        return this.c;
    }

    public void enable() {
        this.c = true;
    }

    public void disable() {
        this.c = false;
    }

    public boolean isCanceled() {
        return this.d;
    }

    public void cancel() {
        this.d = true;
        this.interrupt();
        try {
            this.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void run() {
        while (!this.isCanceled()) {
            try {
                Logger.getInstance().logDebug(this.isEnabled() ? "Running..." : "** disabled **", null, null);
                if (this.isEnabled()) {
                    this.process();
                }
                AServiceThread.sleep(this.getDelay());
            }
            catch (InterruptedException e2) {
                if (this.isCanceled()) {
                    Logger.getInstance().logDebug("Stopped.", null, null);
                    break;
                }
                Logger.getInstance().logDebug("Interrupted!", null, null);
            }
            catch (Exception e3) {
                Logger.getInstance().logError("Error!", e3, null);
            }
        }
    }

    public abstract void process() throws Exception;
}

