/*
 * Decompiled with CFR 0.152.
 */
package cn.sendsms.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class ByteBuffer {
    private static final int MIN_Capacity = 512;
    public byte[] buffer;
    int a;
    int b;
    public int pos;
    public int endPos;

    public ByteBuffer() {
        this.buffer = new byte[512];
        this.a = this.buffer.length;
        this.b = 0;
    }

    public ByteBuffer(int minimumCapacity) {
        this.a = 512;
        if (minimumCapacity > 4096) {
            this.a = minimumCapacity + 4095 & 0xFFFFF000;
        } else {
            while (this.a < minimumCapacity) {
                this.a += this.a;
            }
        }
        this.buffer = new byte[minimumCapacity];
        this.b = 0;
    }

    public int capacity() {
        return this.a;
    }

    public int hashCode() {
        int hash = 17;
        for (int i2 = this.b - 1; i2 >= 0; --i2) {
            hash = 65537 * hash + this.buffer[i2];
        }
        return hash;
    }

    public void ensureCapacity(int minimumCapacity) {
        if (minimumCapacity <= this.a) {
            return;
        }
        if (minimumCapacity > 4096) {
            this.a = minimumCapacity + 4095 & 0xFFFFF000;
        } else {
            while (this.a < minimumCapacity) {
                this.a += this.a;
            }
        }
        byte[] bytes = new byte[this.a];
        System.arraycopy(this.buffer, 0, bytes, 0, this.b);
        this.buffer = bytes;
    }

    public int length() {
        return this.b;
    }

    public int size() {
        return this.b;
    }

    public int getLength() {
        return this.b;
    }

    public void setLength(int len) {
        if (len < 0) {
            throw new RuntimeException("illegal argument");
        }
        if (len > this.a) {
            this.ensureCapacity(len);
        }
        this.b = len;
    }

    public void clear() {
        this.a = this.buffer.length;
        this.b = 0;
    }

    public byte[] getBuffer() {
        byte[] buf = null;
        if (this.b == 0) {
            buf = new byte[]{};
            return buf;
        }
        buf = new byte[this.b];
        System.arraycopy(this.buffer, 0, buf, 0, this.b);
        return buf;
    }

    public void append(int b2) {
        if (this.b + 1 > this.a) {
            this.ensureCapacity(this.b + 1);
        }
        this.buffer[this.b++] = (byte)b2;
    }

    public void append(long b2) {
        if (this.b + 1 > this.a) {
            this.ensureCapacity(this.b + 1);
        }
        this.buffer[this.b++] = (byte)b2;
    }

    public void add(int i2, byte[] buffer, int offset, int length) {
        if (this.b + length > this.a) {
            this.ensureCapacity(this.b + length);
        }
        System.arraycopy(this.buffer, i2, this.buffer, i2 + length, this.b - i2);
        System.arraycopy(buffer, offset, this.buffer, i2, length);
        this.b += length;
    }

    public void add(byte[] buffer, int offset, int length) {
        if (this.b + length > this.a) {
            this.ensureCapacity(this.b + length);
        }
        System.arraycopy(buffer, offset, this.buffer, this.b, length);
        this.b += length;
    }

    public void add(int i2, int data) {
        if (this.b + 1 > this.a) {
            this.ensureCapacity(this.b + 1);
        }
        System.arraycopy(this.buffer, i2, this.buffer, i2 + 1, this.b - i2);
        this.buffer[i2] = (byte)data;
        ++this.b;
    }

    public void add(int data) {
        if (this.b + 1 > this.a) {
            this.ensureCapacity(this.b + 1);
        }
        this.buffer[this.b++] = (byte)data;
    }

    public void set(int i2, byte[] buffer, int offset, int length) {
        System.arraycopy(buffer, offset, this.buffer, i2, length);
    }

    public void set(int i2, int data) {
        this.buffer[i2] = (byte)data;
    }

    public void insert(int i2, byte[] buffer, int offset, int length) {
        if (this.b + length > this.a) {
            this.ensureCapacity(this.b + length);
        }
        System.arraycopy(this.buffer, i2, this.buffer, i2 + length, this.b - i2);
        System.arraycopy(buffer, offset, this.buffer, i2, length);
        this.b += length;
    }

    public void replace(int i2, byte[] buffer, int offset, int length) {
        System.arraycopy(buffer, offset, this.buffer, i2, length);
    }

    public void append(byte[] buffer) {
        if (this.b + buffer.length >= this.a) {
            this.ensureCapacity(this.b + buffer.length);
        }
        System.arraycopy(buffer, 0, this.buffer, this.b, buffer.length);
        this.b += buffer.length;
    }

    public void append(byte[] buffer, int offset, int length) {
        if (this.b + length >= this.a) {
            this.ensureCapacity(this.b + length);
        }
        System.arraycopy(buffer, offset, this.buffer, this.b, length);
        this.b += length;
    }

    public void replaceShort(int i2, int s) {
        this.buffer[i2] = (byte)(s >> 8);
        this.buffer[i2 + 1] = (byte)s;
    }

    public void appendShort(int s) {
        if (this.b + 2 > this.a) {
            this.ensureCapacity(this.b + 2);
        }
        this.replaceShort(this.b, s);
        this.b += 2;
    }

    public void addShort(int s) {
        if (this.b + 2 > this.a) {
            this.ensureCapacity(this.b + 2);
        }
        this.buffer[this.b++] = (byte)(s >> 8);
        this.buffer[this.b++] = (byte)s;
    }

    public void addShort(int i2, int s) {
        this.add(i2, (byte)(s >> 8));
        this.add(i2 + 1, (byte)s);
    }

    public void setShort(int i2, int s) {
        this.buffer[i2] = (byte)(s >> 8);
        this.buffer[i2 + 1] = (byte)s;
    }

    public void replaceInt(int i2, int v) {
        this.buffer[i2] = (byte)(v >> 24);
        this.buffer[i2 + 1] = (byte)(v >> 16);
        this.buffer[i2 + 2] = (byte)(v >> 8);
        this.buffer[i2 + 3] = (byte)v;
    }

    public void appendInt(int v) {
        if (this.b + 4 > this.a) {
            this.ensureCapacity(this.b + 4);
        }
        this.replaceInt(this.b, v);
        this.b += 4;
    }

    public void addInt(int s) {
        if (this.b + 4 > this.a) {
            this.ensureCapacity(this.b + 4);
        }
        this.buffer[this.b++] = (byte)(s >> 24);
        this.buffer[this.b++] = (byte)(s >> 16);
        this.buffer[this.b++] = (byte)(s >> 8);
        this.buffer[this.b++] = (byte)s;
    }

    public void addInt(int i2, int s) {
        this.add(i2 + 0, (byte)(s >> 24));
        this.add(i2 + 1, (byte)(s >> 16));
        this.add(i2 + 2, (byte)(s >> 8));
        this.add(i2 + 3, (byte)s);
    }

    public void setInt(int i2, int v) {
        this.buffer[i2] = (byte)(v >> 24);
        this.buffer[i2 + 1] = (byte)(v >> 16);
        this.buffer[i2 + 2] = (byte)(v >> 8);
        this.buffer[i2 + 3] = (byte)v;
    }

    public void addDouble(double v) {
        if (this.b + 8 > this.a) {
            this.ensureCapacity(this.b + 8);
        }
        long bits = Double.doubleToLongBits(v);
        this.buffer[this.b++] = (byte)(bits >> 56);
        this.buffer[this.b++] = (byte)(bits >> 48);
        this.buffer[this.b++] = (byte)(bits >> 40);
        this.buffer[this.b++] = (byte)(bits >> 32);
        this.buffer[this.b++] = (byte)(bits >> 24);
        this.buffer[this.b++] = (byte)(bits >> 16);
        this.buffer[this.b++] = (byte)(bits >> 8);
        this.buffer[this.b++] = (byte)bits;
    }

    public void addString(String s) {
        int len = s.length();
        if (len + this.b > this.a) {
            this.ensureCapacity(this.b + len);
        }
        for (int i2 = 0; i2 < len; ++i2) {
            this.buffer[this.b++] = (byte)s.charAt(i2);
        }
    }

    public void add(char[] s, int offset, int len) {
        if (len + this.b > this.a) {
            this.ensureCapacity(this.b + len);
        }
        for (int i2 = 0; i2 < len; ++i2) {
            this.buffer[this.b++] = (byte)s[offset + i2];
        }
    }

    public void remove(int begin, int length) {
        System.arraycopy(this.buffer, begin + length, this.buffer, begin, this.a - length - begin);
        this.b -= length;
    }

    public void append(String string) {
        for (int i2 = 0; i2 < string.length(); ++i2) {
            this.append(string.charAt(i2));
        }
    }

    public byte byteAt(int i2) {
        if (i2 < 0 || i2 > this.b) {
            throw new RuntimeException();
        }
        return this.buffer[i2];
    }

    public void setByteAt(int i2, int b2) {
        this.buffer[i2] = (byte)b2;
    }

    public byte get(int i2) {
        if (i2 < 0 || i2 >= this.b) {
            throw new RuntimeException("out of bounds: " + i2 + " len: " + this.b);
        }
        return this.buffer[i2];
    }

    public short getShort(int i2) {
        if (i2 < 0 || i2 + 1 >= this.b) {
            throw new RuntimeException("out of bounds: " + i2 + " len: " + this.b);
        }
        return (short)(((this.buffer[i2] & 0xFF) << 8) + (this.buffer[i2 + 1] & 0xFF));
    }

    public int getInt(int i2) {
        if (i2 < 0 || i2 + 3 >= this.b) {
            throw new RuntimeException("out of bounds: " + i2 + " len: " + this.b);
        }
        return ((this.buffer[i2 + 0] & 0xFF) << 24) + ((this.buffer[i2 + 1] & 0xFF) << 16) + ((this.buffer[i2 + 2] & 0xFF) << 8) + (this.buffer[i2 + 3] & 0xFF);
    }

    public Object clone() {
        ByteBuffer newBuffer = new ByteBuffer(this.b);
        System.arraycopy(this.buffer, 0, newBuffer.buffer, 0, this.b);
        return newBuffer;
    }

    public boolean equals(Object b2) {
        if (!(b2 instanceof ByteBuffer)) {
            return false;
        }
        ByteBuffer bb = (ByteBuffer)b2;
        if (bb.b != this.b) {
            return false;
        }
        for (int i2 = this.b - 1; i2 >= 0; --i2) {
            if (bb.buffer[i2] == this.buffer[i2]) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return new String(this.buffer, 0, this.b);
    }

    public String toString(String encoding) {
        try {
            return new String(this.buffer, 0, this.b, encoding);
        }
        catch (Exception e2) {
            return new String(this.buffer, 0, this.b);
        }
    }

    static class b
    extends OutputStream {
        ByteBuffer a;

        @Override
        public void write(int ch) throws IOException {
            this.a.append(ch);
        }

        b(ByteBuffer buf) {
            this.a = buf;
        }
    }

    static class a
    extends InputStream {
        ByteBuffer a;
        int b;

        @Override
        public int available() {
            return this.a.b - this.b;
        }

        @Override
        public int read() throws IOException {
            if (this.b >= this.a.b) {
                return -1;
            }
            return this.a.buffer[this.b++] & 0xFF;
        }

        a(ByteBuffer buf) {
            this.a = buf;
        }
    }
}

