/*
 * Decompiled with CFR 0.152.
 */
package cn.sendsms.addressbook;

import cn.sendsms.addressbook.AddressFolder;
import cn.sendsms.addressbook.FormatPair;
import cn.sendsms.helper.Logger;
import cn.sendsms.util.ConfParam;
import cn.sendsms.util.StringUtil;
import cn.sendsms.util.Util;
import java.util.ArrayList;

public class Address
implements Comparable<Address> {
    public String m_id = "";
    public String Name = "";
    public String Telephone = "";
    public String EmailAddress = "";
    public String Organization = "";
    public String Department = "";
    public String Employment = "";
    public String Address = "";
    public String Postalcode = "";
    public String username = null;
    public String m_foldertype = "";
    public String Orderrule = "";
    public AddressFolder m_parentFolder = null;

    public String getFullId() {
        String tempId = "";
        String tempRootId = "";
        tempRootId = this.m_parentFolder == null ? "/" : this.m_parentFolder.getFullId();
        tempId = tempRootId.equals("/") ? tempRootId + this.m_id : tempRootId + "/" + this.m_id;
        return tempId;
    }

    public String outputFormatAddress(ArrayList alFormat) {
        FormatPair fp = null;
        StringBuffer sbContent = new StringBuffer();
        for (int i2 = 0; i2 < alFormat.size(); ++i2) {
            fp = (FormatPair)alFormat.get(i2);
            if (fp.m_FieldName.equals("name")) {
                sbContent.append(",\"" + this.Name + "\"");
                continue;
            }
            if (fp.m_FieldName.equals("email")) {
                sbContent.append(",\"" + this.EmailAddress + "\"");
                continue;
            }
            if (fp.m_FieldName.equals("telephone")) {
                sbContent.append(",\"" + this.Telephone + "\"");
                continue;
            }
            if (fp.m_FieldName.equals("postalcode")) {
                sbContent.append(",\"" + this.Postalcode + "\"");
                continue;
            }
            if (fp.m_FieldName.equals("address")) {
                sbContent.append(",\"" + this.Address + "\"");
                continue;
            }
            if (fp.m_FieldName.equals("employment")) {
                sbContent.append(",\"" + this.Employment + "\"");
                continue;
            }
            if (fp.m_FieldName.equals("organization")) {
                sbContent.append(",\"" + this.Organization + "\"");
                continue;
            }
            if (fp.m_FieldName.equals("department")) {
                sbContent.append(",\"" + this.Department + "\"");
                continue;
            }
            if (!fp.m_FieldName.equals("orderrule")) continue;
            sbContent.append(",\"" + this.Orderrule + "\"");
        }
        String strRet = sbContent.toString();
        strRet = StringUtil.supertrim(strRet, ",");
        return strRet;
    }

    public static Address parseXml(String strXml) {
        ConfParam tempCF = new ConfParam();
        if (tempCF.OpenString(strXml) == 1) {
            return null;
        }
        Address addr = new Address();
        addr.Name = tempCF.GetParamString("address.name");
        addr.EmailAddress = tempCF.GetParamString("address.email");
        addr.Organization = tempCF.GetParamString("address.organization");
        addr.Department = tempCF.GetParamString("address.department");
        addr.Address = tempCF.GetParamString("address.address");
        addr.Postalcode = tempCF.GetParamString("address.postalcode");
        addr.Telephone = tempCF.GetParamString("address.telephone");
        addr.Employment = tempCF.GetParamString("address.employment");
        addr.Orderrule = tempCF.GetParamString("address.orderrule");
        addr.m_id = tempCF.GetParamString("address.id");
        return addr;
    }

    public String getXml() {
        Address addr = this;
        StringBuffer sb = new StringBuffer();
        sb.append("   <address>\r\n");
        sb.append("        <id>" + addr.m_id + "</id>\r\n");
        sb.append("        <name>" + Util.htmlspecialchars(addr.Name, false, false) + "</name>\r\n");
        sb.append("        <telephone>" + Util.htmlspecialchars(addr.Telephone, false, false) + "</telephone>\r\n");
        sb.append("        <email>" + Util.htmlspecialchars(addr.EmailAddress, false, false) + "</email>\r\n");
        sb.append("        <organization>" + Util.htmlspecialchars(addr.Organization, false, false) + "</organization>\r\n");
        sb.append("        <department>" + Util.htmlspecialchars(addr.Department, false, false) + "</department>\r\n");
        sb.append("        <employment>" + Util.htmlspecialchars(addr.Employment, false, false) + "</employment>\r\n");
        sb.append("        <orderrule>" + Util.htmlspecialchars(addr.Orderrule, false, false) + "</orderrule>\r\n");
        sb.append("        <address>" + Util.htmlspecialchars(addr.Address, false, false) + "</address>\r\n");
        sb.append("        <postalcode>" + Util.htmlspecialchars(addr.Postalcode, false, false) + "</postalcode>\r\n");
        sb.append("   </address>\r\n");
        return sb.toString();
    }

    public String toString() {
        return "ID: " + this.m_id + " \u59d3\u540d: " + this.Name + " \u7535\u8bdd\u53f7\u7801: " + this.Telephone + " \u90ae\u4ef6\u5730\u5740: " + this.EmailAddress + " \u516c\u53f8\u540d\u79f0 : " + this.Organization + "\n \u90e8\u95e8\u540d\u79f0: " + this.Department + " \u804c\u4f4d\u540d\u79f0: " + this.Employment + "  \u5730\u5740: " + this.Address + " \u90ae\u7f16: " + this.Postalcode + " \u6392\u5e8f\u89c4\u5219\uff1a " + this.Orderrule;
    }

    @Override
    public int compareTo(Address o2) {
        double rule1 = 0.0;
        double rule2 = 0.0;
        try {
            Address addr1 = this;
            Address addr2 = o2;
            if (!addr1.Orderrule.trim().isEmpty()) {
                rule1 = Double.parseDouble(addr1.Orderrule.trim());
            }
            if (!addr2.Orderrule.trim().isEmpty()) {
                rule2 = Double.parseDouble(addr2.Orderrule.trim());
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
            Logger.getInstance().logError(" Number format error.", e2, null);
        }
        if (rule1 > rule2) {
            return 1;
        }
        if (rule1 == rule2) {
            return 0;
        }
        return -1;
    }
}

