/*
 * Decompiled with CFR 0.152.
 */
package cn.sendsms.jdsmsserver.interfaces;

import cn.sendsms.AGateway;
import cn.sendsms.Library;
import cn.sendsms.Message;
import cn.sendsms.OutboundMessage;
import cn.sendsms.OutboundWapSIMessage;
import cn.sendsms.Service;
import cn.sendsms.crypto.PwdConf;
import cn.sendsms.jdsmsserver.JDSMSServer;
import cn.sendsms.jdsmsserver.interfaces.ConnectionPool;
import cn.sendsms.jdsmsserver.interfaces.Interface;
import cn.sendsms.jdsmsserver.web.DbHelper;
import cn.sendsms.otherModem.common.DesUtils;
import cn.sendsms.otherModem.nbiot.authorize.AuthorizeInfo;
import cn.sendsms.otherModem.nbiot.authorize.NbIoTAuthorize;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.net.URLEncoder;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.dbutils.DbUtils;
import org.apache.log4j.Logger;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class HttpServer
extends Interface<Integer> {
    public static final int ERR_INVALID_PARMS = -9000;
    public static final int ERR_DATABASE = -1;
    public static final int ERR_MISSING_PARMS = -9001;
    public static final int ERR_SEND_ERROR = -9002;
    public static final int ERR_WRONG_PASSWORD = -9003;
    public static final int ERR_INTERNAL_ERROR = -9999;
    private static final String HTTP_TRANSFER_SECRET_KEY = "l1gEgX#jnMau@Csi";
    private static final String HTTP_PASSWORD = "jd.110110";
    private static DesUtils HTTPDesUtils;
    d a;
    private static Logger log;

    public HttpServer(String myInterfaceId, PropertiesConfiguration myProps, JDSMSServer myServer, Interface.InterfaceTypes myType) {
        super(myInterfaceId, myProps, myServer, myType);
        this.setDescription("Default HTTP Server interface.");
    }

    @Override
    public void start() throws Exception {
        this.a(new d(this.getServer(), Integer.parseInt(this.getProperty("port", "8080")), this.getProperty("use_ssl", "no").equals("yes")));
        this.a().start();
        super.start();
    }

    @Override
    public void stop() throws Exception {
        this.a().e.stop();
        this.a().interrupt();
        super.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void markMessage(OutboundMessage msg) {
        PropertiesConfiguration props = JDSMSServer.getInstance().getProperties();
        if (!DbUtils.loadDriver((String)props.getString("db1.driver"))) {
            return;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        if (this.getMessageCache().get(msg.getMessageId()) == null) {
            return;
        }
        try {
            String url = "";
            url = JDSMSServer.getInstance().getProperties().getString("db1.url", "");
            conn = DriverManager.getConnection(url, props.getString("db1.username"), props.getString("db1.password"));
            pstmt = conn.prepareStatement("update " + props.getProperty("db1.tables.sms_out") + " set status = ?, sent_date = ?, gateway_id = ?, ref_no = ? where id = ?");
            if (msg.getMessageStatus() == OutboundMessage.MessageStatuses.SENT) {
                pstmt.setString(1, "S");
                pstmt.setTimestamp(2, new Timestamp(msg.getDispatchDate().getTime()));
                pstmt.setString(3, msg.getGatewayId());
                pstmt.setString(4, msg.getRefNo());
                pstmt.setLong(5, ((Integer)this.getMessageCache().get(msg.getMessageId())).intValue());
            } else if (msg.getMessageStatus() == OutboundMessage.MessageStatuses.FAILED) {
                pstmt.setString(1, "F");
                pstmt.setTimestamp(2, new Timestamp(System.currentTimeMillis()));
                pstmt.setString(3, msg.getGatewayId());
                pstmt.setString(4, msg.getRefNo());
                pstmt.setLong(5, ((Integer)this.getMessageCache().get(msg.getMessageId())).intValue());
            } else if (msg.getMessageStatus() == OutboundMessage.MessageStatuses.UNSENT) {
                pstmt.setString(1, "U");
                pstmt.setTimestamp(2, new Timestamp(System.currentTimeMillis()));
                pstmt.setString(3, msg.getGatewayId());
                pstmt.setString(4, msg.getRefNo());
                pstmt.setLong(5, ((Integer)this.getMessageCache().get(msg.getMessageId())).intValue());
            }
            pstmt.executeUpdate();
            DbUtils.closeQuietly((Connection)conn, (Statement)pstmt, null);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        finally {
            DbUtils.closeQuietly(conn, pstmt, null);
        }
    }

    d a() {
        return this.a;
    }

    void a(d myWebServer) {
        this.a = myWebServer;
    }

    protected String getDateAsISO8601(Date date) {
        Date myDate = date == null ? new Date() : date;
        String result = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ").format(myDate);
        StringBuilder sb = new StringBuilder(result.length() + 1);
        sb.append(result.substring(0, result.length() - 2));
        sb.append(":");
        sb.append(result.substring(result.length() - 2));
        return sb.toString();
    }

    private Connection b() throws Exception {
        Connection conn = null;
        ConnectionPool connPool = ConnectionPool.getInstance();
        if (!connPool.isPoolCreate()) {
            connPool.createPool();
        }
        conn = connPool.getConnection();
        return conn;
    }

    private void a(Connection conn) {
        ConnectionPool connPool = ConnectionPool.getInstance();
        try {
            connPool.returnConnection(conn);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void main(String[] args) {
        if ("55a".matches("^\\d+")) {
            System.out.println("\u5339\u914d");
        }
    }

    private static void initHttPDesUtils() {
        try {
            if (HTTPDesUtils == null) {
                HTTPDesUtils = new DesUtils(HTTP_TRANSFER_SECRET_KEY);
            }
        }
        catch (Exception e2) {
            log.error((Object)"\u6388\u6743\u5f02\u5e38\uff01");
        }
    }

    private String c() {
        String flag = "*";
        int isorted = Integer.parseInt(JDSMSServer.getInstance().getProperties().getString("settings.using_sorted", "0"));
        String device_using = JDSMSServer.getInstance().getProperties().getString("settings.device_using", "yes");
        String phone_using = JDSMSServer.getInstance().getProperties().getString("settings.phone_using", "yes");
        String gateway_using = JDSMSServer.getInstance().getProperties().getString("settings.gateway_using", "yes");
        switch (isorted) {
            case 0: {
                if (device_using.equals("yes")) {
                    flag = "*";
                    break;
                }
                if (gateway_using.equals("yes")) {
                    flag = "#";
                    break;
                }
                if (!phone_using.equals("yes")) break;
                flag = "$";
                break;
            }
            case 1: {
                if (device_using.equals("yes")) {
                    flag = "*";
                    break;
                }
                if (phone_using.equals("yes")) {
                    flag = "$";
                    break;
                }
                if (!gateway_using.equals("yes")) break;
                flag = "#";
                break;
            }
            case 2: {
                if (gateway_using.equals("yes")) {
                    flag = "#";
                    break;
                }
                if (device_using.equals("yes")) {
                    flag = "*";
                    break;
                }
                if (!phone_using.equals("yes")) break;
                flag = "$";
                break;
            }
            case 3: {
                if (gateway_using.equals("yes")) {
                    flag = "#";
                    break;
                }
                if (phone_using.equals("yes")) {
                    flag = "$";
                    break;
                }
                if (!device_using.equals("yes")) break;
                flag = "*";
                break;
            }
            case 4: {
                if (phone_using.equals("yes")) {
                    flag = "$";
                    break;
                }
                if (device_using.equals("yes")) {
                    flag = "*";
                    break;
                }
                if (!gateway_using.equals("yes")) break;
                flag = "#";
                break;
            }
            case 5: {
                if (phone_using.equals("yes")) {
                    flag = "$";
                    break;
                }
                if (gateway_using.equals("yes")) {
                    flag = "#";
                    break;
                }
                if (!device_using.equals("yes")) break;
                flag = "*";
                break;
            }
        }
        return flag;
    }

    static {
        log = Logger.getRootLogger();
    }

    public class Send
    extends a {
        public Send(JDSMSServer myServer, String myTarget, HttpServletRequest myRequest, HttpServletResponse myResponse) {
            super(myServer, myTarget, myRequest, myResponse);
        }

        @Override
        public void process() throws IOException {
            boolean foundErrors = false;
            String isSync = "0";
            PrintWriter body = this.getResponse().getWriter();
            body.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            body.println("<result>");
            Enumeration headers = this.getRequest().getHeaderNames();
            while (headers.hasMoreElements()) {
                System.out.println((String)headers.nextElement());
            }
            String password = this.getRequest().getParameter("password");
            if (password != null && password.equalsIgnoreCase(HttpServer.this.getProperty("password.send", ""))) {
                String[] recipients;
                String gatewayId;
                String method;
                this.getResponse().setContentType("text/xml");
                this.getResponse().setStatus(200);
                String recipient = this.getRequest().getParameter("recipient");
                String signature = JDSMSServer.getInstance().getProperties().getString("settings.device_signature", "");
                String text = this.getRequest().getParameter("text");
                isSync = this.getRequest().getParameter("sync");
                if (!"1".equals(isSync)) {
                    isSync = "0";
                }
                if ("POST".equalsIgnoreCase(method = this.getRequest().getMethod())) {
                    text = new String(text.getBytes("ISO-8859-1"), "UTF8");
                }
                if (!signature.trim().isEmpty()) {
                    text = text + signature;
                }
                if (null == (gatewayId = this.getRequest().getParameter("gateway")) || "".equals(gatewayId)) {
                    String gatewayIdFlag = HttpServer.this.c();
                    if ("*".equals(gatewayIdFlag)) {
                        gatewayId = "*";
                    } else if ("$".equals(gatewayIdFlag)) {
                        gatewayId = "$";
                    } else if ("#".equals(gatewayIdFlag)) {
                        gatewayId = "#";
                    }
                }
                if (recipient == null || recipient.length() == 0 || text == null || text.length() == 0) {
                    foundErrors = true;
                    this.a(body, -9001, "Missing Parameters.");
                } else if ("1".equals(isSync)) {
                    if ("1".equals(isSync)) {
                        this.a(gatewayId, recipient, text, body);
                    }
                } else if ("md".equals(gatewayId) || "#".equals(gatewayId)) {
                    recipients = recipient.split(",");
                    ArrayList<OutboundMessage> list = new ArrayList<OutboundMessage>();
                    for (int i2 = 0; i2 < recipients.length; ++i2) {
                        OutboundMessage msg = new OutboundMessage(recipients[i2], text);
                        String parm = this.getRequest().getParameter("encoding");
                        if (parm != null && parm.length() != 0) {
                            if (parm.equalsIgnoreCase("7")) {
                                msg.setEncoding(Message.MessageEncodings.ENC7BIT);
                            } else {
                                if (!parm.equalsIgnoreCase("U")) {
                                    foundErrors = true;
                                    this.a(body, -9000, "Invalid encoding requested.");
                                    break;
                                }
                                msg.setEncoding(Message.MessageEncodings.ENCUCS2);
                            }
                        }
                        if ((parm = this.getRequest().getParameter("priority")) != null && parm.length() != 0) {
                            try {
                                msg.setPriority(Integer.parseInt(parm));
                            }
                            catch (Exception e2) {
                                foundErrors = true;
                                this.a(body, -9000, "Invalid priority requested.");
                                break;
                            }
                        }
                        if ((parm = this.getRequest().getParameter("from")) != null && parm.length() != 0) {
                            msg.setFrom(parm);
                        }
                        msg.setGatewayId(gatewayId);
                        if (foundErrors) continue;
                        try {
                            long id = this.a(msg, null);
                            this.a(body, msg, id);
                            if (msg.getRecipient().matches("\\+?\\d{1,16}")) {
                                list.add(msg);
                                continue;
                            }
                            msg.setMessageStatus(OutboundMessage.MessageStatuses.FAILED);
                            this.a(body, msg);
                            HttpServer.this.markMessage(msg);
                            continue;
                        }
                        catch (Exception e3) {
                            msg.setMessageStatus(OutboundMessage.MessageStatuses.FAILED);
                            this.a(body, msg, e3.getMessage());
                            HttpServer.this.markMessage(msg);
                        }
                    }
                } else {
                    recipients = recipient.split(",");
                    ArrayList<OutboundMessage> list = new ArrayList<OutboundMessage>();
                    for (int i3 = 0; i3 < recipients.length; ++i3) {
                        OutboundMessage msg = new OutboundMessage(recipients[i3], text);
                        String parm = this.getRequest().getParameter("encoding");
                        if (parm != null && parm.length() != 0) {
                            if (parm.equalsIgnoreCase("7")) {
                                msg.setEncoding(Message.MessageEncodings.ENC7BIT);
                            } else {
                                if (!parm.equalsIgnoreCase("U")) {
                                    foundErrors = true;
                                    this.a(body, -9000, "Invalid encoding requested.");
                                    break;
                                }
                                msg.setEncoding(Message.MessageEncodings.ENCUCS2);
                            }
                        }
                        if ((parm = this.getRequest().getParameter("priority")) != null && parm.length() != 0) {
                            try {
                                msg.setPriority(Integer.parseInt(parm));
                            }
                            catch (Exception e4) {
                                foundErrors = true;
                                this.a(body, -9000, "Invalid priority requested.");
                                break;
                            }
                        }
                        if ((parm = this.getRequest().getParameter("from")) != null && parm.length() != 0) {
                            msg.setFrom(parm);
                        }
                        msg.setGatewayId(gatewayId);
                        if (foundErrors) continue;
                        try {
                            long id = this.a(msg, null);
                            this.a(body, msg, id);
                            if (msg.getRecipient().matches("\\+?\\d{1,16}")) {
                                list.add(msg);
                                continue;
                            }
                            msg.setMessageStatus(OutboundMessage.MessageStatuses.FAILED);
                            this.a(body, msg);
                            HttpServer.this.markMessage(msg);
                            continue;
                        }
                        catch (Exception e5) {
                            msg.setMessageStatus(OutboundMessage.MessageStatuses.FAILED);
                            this.a(body, msg, e5.getMessage());
                            HttpServer.this.markMessage(msg);
                        }
                    }
                }
            } else {
                this.a(body, -9003, "Invalid password.");
            }
            body.println("</result>");
            ((Request)this.getRequest()).setHandled(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void a(String gatewayId, String recipient, String text, PrintWriter body) {
            boolean foundErrors = false;
            String parm = "";
            if (!"*".equals(gatewayId) && !gatewayId.startsWith("modem")) {
                foundErrors = true;
                this.a(body, -9001, "Missing Parameters.");
            } else {
                OutboundMessage msg;
                int i2;
                String[] recipients = recipient.split(",");
                ArrayList<OutboundMessage> list = new ArrayList<OutboundMessage>();
                for (i2 = 0; i2 < recipients.length; ++i2) {
                    msg = new OutboundMessage(recipients[i2], text);
                    parm = this.getRequest().getParameter("encoding");
                    if (parm != null && parm.length() != 0) {
                        if (parm.equalsIgnoreCase("7")) {
                            msg.setEncoding(Message.MessageEncodings.ENC7BIT);
                        } else if (parm.equalsIgnoreCase("U")) {
                            msg.setEncoding(Message.MessageEncodings.ENCUCS2);
                        } else {
                            foundErrors = true;
                            this.a(body, -9000, "Invalid encoding requested.");
                            break;
                        }
                    }
                    if ((parm = this.getRequest().getParameter("priority")) != null && parm.length() != 0) {
                        try {
                            msg.setPriority(Integer.parseInt(parm));
                        }
                        catch (Exception e2) {
                            foundErrors = true;
                            this.a(body, -9000, "Invalid priority requested.");
                            break;
                        }
                    }
                    if ((parm = this.getRequest().getParameter("from")) != null && parm.length() != 0) {
                        msg.setFrom(parm);
                    }
                    msg.setGatewayId(gatewayId);
                    list.add(msg);
                }
                if (!foundErrors) {
                    for (i2 = 0; i2 < list.size(); ++i2) {
                        msg = (OutboundMessage)list.get(i2);
                        try {
                            Service.getInstance().sendMessage(msg);
                            this.a(body, msg);
                            continue;
                        }
                        catch (Exception e3) {
                            this.a(body, msg, e3.getMessage());
                            continue;
                        }
                        finally {
                            HttpServer.this.markMessage(msg);
                        }
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private long a(OutboundMessage msg, String attach) {
            PropertiesConfiguration props = JDSMSServer.getInstance().getProperties();
            Connection conn = null;
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                conn = HttpServer.this.b();
                String sql = "insert into %s (type,recipient,text,wap_url,wap_expiry_date,wap_signal,create_date,originator,encoding,status_report,flash_sms,dst_port,src_port,sent_date,ref_no,priority,status,errors,gateway_id) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
                sql = String.format(sql, props.getProperty("db1.tables.sms_out"));
                pstmt = conn.prepareStatement(sql);
                if (msg instanceof OutboundWapSIMessage) {
                    pstmt.setString(1, "W");
                } else {
                    pstmt.setString(1, "O");
                }
                pstmt.setString(2, msg.getRecipient());
                if (attach != null) {
                    pstmt.setString(3, attach);
                } else {
                    pstmt.setString(3, msg.getText());
                }
                pstmt.setString(4, "");
                if (msg instanceof OutboundWapSIMessage) {
                    pstmt.setString(5, ((OutboundWapSIMessage)msg).getUrl().toString());
                    pstmt.setString(6, ((OutboundWapSIMessage)msg).getExpireDate().toString());
                } else {
                    pstmt.setTimestamp(5, null);
                    pstmt.setString(6, null);
                }
                pstmt.setTimestamp(7, new Timestamp(msg.getDate().getTime()));
                pstmt.setString(8, "");
                if (msg.getEncoding().equals((Object)Message.MessageEncodings.ENC7BIT)) {
                    pstmt.setString(9, "7");
                } else if (msg.getEncoding().equals((Object)Message.MessageEncodings.ENC8BIT)) {
                    pstmt.setString(9, "8");
                } else if (msg.getEncoding().equals((Object)Message.MessageEncodings.ENCUCS2)) {
                    pstmt.setString(9, "U");
                }
                if (msg.getStatusReport()) {
                    pstmt.setInt(10, 1);
                } else {
                    pstmt.setInt(10, 0);
                }
                if (msg.getFlashSms()) {
                    pstmt.setInt(11, 1);
                } else {
                    pstmt.setInt(11, 0);
                }
                pstmt.setInt(12, -1);
                pstmt.setInt(13, -1);
                pstmt.setTimestamp(14, null);
                pstmt.setString(15, msg.getRefNo());
                pstmt.setInt(16, msg.getPriority());
                pstmt.setString(17, "U");
                pstmt.setInt(18, 0);
                pstmt.setString(19, msg.getGatewayId());
                pstmt.executeUpdate();
                DbUtils.close((Statement)pstmt);
                String tmp = null;
                tmp = props.getString("db1.type").equalsIgnoreCase("Oracle") || props.getString("db1.type").equalsIgnoreCase("Dm7") || props.getString("db1.type").equalsIgnoreCase("OSCAR7") || props.getString("db1.type").equalsIgnoreCase("KINGBASE8") ? "select smsserver_out_seq.currval from dual" : "select @@identity";
                pstmt = conn.prepareStatement(tmp);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    long l2 = rs.getLong(1);
                    return l2;
                }
                long l3 = -1L;
                return l3;
            }
            catch (Exception e2) {
                log.error((Object)"\u8c03\u7528http\u63a5\u53e3\u63d2\u5165\u6570\u636e\u5e93\u51fa\u9519", (Throwable)e2);
                long l4 = -1L;
                return l4;
            }
            finally {
                HttpServer.this.a(conn);
            }
        }

        private void a(PrintWriter body, OutboundMessage msg) {
            body.println("<send>");
            if (msg.getMessageStatus() == OutboundMessage.MessageStatuses.SENT || msg.getMessageStatus() == OutboundMessage.MessageStatuses.UNSENT) {
                body.printf("<error>%d</error>", 0);
                body.printf("<message_status>%s</message_status>", new Object[]{OutboundMessage.MessageStatuses.SENT});
            } else {
                body.printf("<error>%d</error>", -9002);
                body.printf("<error_description>%s</error_description>", "Message not sent.");
                body.printf("<message_status>%s</message_status>", new Object[]{OutboundMessage.MessageStatuses.FAILED});
            }
            body.printf("<recipient>%s</recipient>", msg.getRecipient());
            body.printf("<sent_date>%s</sent_date>", HttpServer.this.getDateAsISO8601(msg.getDispatchDate()));
            body.printf("<submit_date>%s</submit_date>", HttpServer.this.getDateAsISO8601(msg.getDate()));
            if (msg.getMessageStatus() == OutboundMessage.MessageStatuses.FAILED) {
                body.printf("<failure_cause>%s</failure_cause>", new Object[]{msg.getFailureCause()});
            }
            body.printf("<ref_no>%s</ref_no>", msg.getRefNo());
            body.printf("<gateway>%s</gateway>", msg.getGatewayId());
            body.println("</send>");
        }

        private void a(PrintWriter body, OutboundMessage msg, long id) {
            body.println("<send>");
            if (msg.getMessageStatus() == OutboundMessage.MessageStatuses.SENT || msg.getMessageStatus() == OutboundMessage.MessageStatuses.UNSENT) {
                body.printf("<error>%d</error>", 0);
                body.printf("<message_status>%s</message_status>", new Object[]{msg.getMessageStatus()});
            } else {
                body.printf("<error>%d</error>", -9002);
                body.printf("<error_description>%s</error_description>", "Message not sent.");
                body.printf("<message_status>%s</message_status>", new Object[]{OutboundMessage.MessageStatuses.FAILED});
            }
            body.printf("<recipient>%s</recipient>", msg.getRecipient());
            body.printf("<sent_date>%s</sent_date>", HttpServer.this.getDateAsISO8601(msg.getDispatchDate()));
            body.printf("<submit_date>%s</submit_date>", HttpServer.this.getDateAsISO8601(msg.getDate()));
            if (msg.getMessageStatus() == OutboundMessage.MessageStatuses.FAILED) {
                body.printf("<failure_cause>%s</failure_cause>", new Object[]{msg.getFailureCause()});
            }
            body.printf("<ref_no>%s</ref_no>", msg.getRefNo());
            body.printf("<msg_id>%s</msg_id>", id);
            body.printf("<gateway>%s</gateway>", msg.getGatewayId());
            body.println("</send>");
        }

        private void a(PrintWriter body, OutboundMessage msg, String errMessage) {
            body.println("<send>");
            if (msg.getMessageStatus() == OutboundMessage.MessageStatuses.SENT) {
                body.printf("<error>%d</error>", 0);
            } else {
                body.printf("<error>%d</error>", -9002);
                body.printf("<error_description>%s</error_description>", errMessage);
            }
            body.printf("<message_status>%s</message_status>", new Object[]{msg.getMessageStatus()});
            body.printf("<recipient>%s</recipient>", msg.getRecipient());
            body.printf("<sent_date>%s</sent_date>", HttpServer.this.getDateAsISO8601(msg.getDispatchDate()));
            body.printf("<submit_date>%s</submit_date>", HttpServer.this.getDateAsISO8601(msg.getDate()));
            if (msg.getMessageStatus() == OutboundMessage.MessageStatuses.FAILED) {
                body.printf("<failure_cause>%s</failure_cause>", new Object[]{msg.getFailureCause()});
            }
            body.printf("<ref_no>%s</ref_no>", msg.getRefNo());
            body.printf("<gateway>%s</gateway>", msg.getGatewayId());
            body.println("</send>");
        }

        private void a(PrintWriter body, int errNo, String errMessage) {
            body.printf("<error>%d</error>", errNo);
            body.printf("<error_description>%s</error_description>", errMessage);
        }
    }

    public class Read
    extends a {
        public Read(JDSMSServer myServer, String myTarget, HttpServletRequest myRequest, HttpServletResponse myResponse) {
            super(myServer, myTarget, myRequest, myResponse);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void process() throws IOException {
            PrintWriter body = this.getResponse().getWriter();
            String password = this.getRequest().getParameter("password");
            Statement cmd = null;
            ResultSet rs = null;
            Connection con = null;
            if (password != null && password.equalsIgnoreCase(HttpServer.this.getProperty("password.read", ""))) {
                int countUpper;
                int getCount;
                String count;
                body.println("<?xml version='1.0' encoding=\"UTF-8\"?>");
                this.getResponse().setStatus(200);
                String gateway = this.getRequest().getParameter("gateway");
                if (gateway == null) {
                    gateway = "";
                }
                if ((count = this.getRequest().getParameter("count")) == null || !count.matches("^\\d+$")) {
                    count = "100";
                }
                if ((getCount = Integer.valueOf(count).intValue()) > (countUpper = Integer.valueOf(JDSMSServer.getInstance().getProperties().getString("settings.recvlimit", "5000")).intValue())) {
                    getCount = countUpper;
                }
                String minidStr = this.getRequest().getParameter("minid");
                int minid = -1;
                if (minidStr != null && minidStr.matches("^\\d+$")) {
                    minid = Integer.valueOf(minidStr);
                }
                try {
                    con = HttpServer.this.b();
                    cmd = con.createStatement(1005, 1007);
                    rs = minid < 0 ? cmd.executeQuery(DbHelper.getDbHelper(JDSMSServer.getInstance().getProperties(), "db1").getHttpReceiveApiSQL(gateway, getCount)) : cmd.executeQuery(DbHelper.getDbHelper(JDSMSServer.getInstance().getProperties(), "db1").getHttpReceiveApiSQL(gateway, getCount, minid));
                    body.println("<messages>");
                    body.printf("<error>0</error>", 0);
                    while (rs.next()) {
                        String originator = rs.getString("originator");
                        Date date = new Date(rs.getTimestamp("message_date").getTime());
                        Date dater = new Date(rs.getTimestamp("receive_date").getTime());
                        String encoding = rs.getString("encoding");
                        String gateway_id = rs.getString("gateway_id");
                        String type = rs.getString("type");
                        String text = rs.getString("text");
                        long id = rs.getLong("id");
                        body.println("<message>");
                        if ("I".equalsIgnoreCase(type)) {
                            body.printf("<message_type>%s</message_type>", "Inbound");
                            body.printf("<message_id>%s</message_id>", id);
                            body.printf("<message_date>%s</message_date>\n", HttpServer.this.getDateAsISO8601(date));
                            body.printf("<receive_date>%s</receive_date>\n", HttpServer.this.getDateAsISO8601(dater));
                            body.printf("<originator>%s</originator>\n", originator);
                            body.printf("<text>\n<![CDATA[\n%s\n]]>\n</text>\n", URLEncoder.encode(text, "UTF-8"));
                            body.printf("<encoding>%s</encoding>\n", encoding);
                            body.printf("<gateway>%s</gateway>\n", gateway_id);
                        }
                        body.println("</message>");
                    }
                    body.println("</messages>");
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                    body.println("<messages>");
                    body.printf("<error>%d</error>", -9999);
                    body.println("</messages>");
                }
                finally {
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                        if (cmd != null) {
                            cmd.close();
                        }
                    }
                    catch (SQLException e3) {
                        log.error((Object)("\u5173\u95ed\u6e38\u6807\u51fa\u73b0\u5f02\u5e38" + e3));
                    }
                    HttpServer.this.a(con);
                }
            } else {
                this.getResponse().setContentType("text/xml");
                this.getResponse().setStatus(200);
                body.println("<?xml version='1.0' encoding='UTF-8'?>");
                body.println("<messages>");
                body.printf("<error>%d</error>", -9003);
                body.printf("<error_description>%s</error_description>", "Invalid password.");
                body.println("</messages>");
            }
            ((Request)this.getRequest()).setHandled(true);
        }
    }

    public class Authorize
    extends a {
        public Authorize(JDSMSServer myServer, String myTarget, HttpServletRequest myRequest, HttpServletResponse myResponse) {
            super(myServer, myTarget, myRequest, myResponse);
        }

        @Override
        public void process() throws IOException {
            PrintWriter body = this.getResponse().getWriter();
            body.println("<?xml version='1.0' encoding=\"UTF-8\"?>");
            try {
                HttpServer.initHttPDesUtils();
                String action = HTTPDesUtils.decrypt(this.getRequest().getParameter("action"));
                String para = HTTPDesUtils.decrypt(this.getRequest().getParameter("para"));
                String password = HTTPDesUtils.decrypt(this.getRequest().getParameter("password"));
                if (!HttpServer.HTTP_PASSWORD.equals(password)) {
                    body.printf("<result>%s</result>", HTTPDesUtils.encrypt("password error"));
                } else if (!NbIoTAuthorize.isActionAndParaLegal(action, para)) {
                    body.printf("<result>%s</result>", HTTPDesUtils.encrypt("action or para illegal"));
                } else {
                    Class<?> NbIoTAuthorizeClass = Class.forName("cn.sendsms.otherModem.nbiot.authorize.NbIoTAuthorize");
                    NbIoTAuthorize nbiotAuthorize = (NbIoTAuthorize)NbIoTAuthorizeClass.newInstance();
                    Method method = NbIoTAuthorizeClass.getMethod(action, AuthorizeInfo.class);
                    AuthorizeInfo authorizeInfo = new AuthorizeInfo();
                    String[] paraArray = para.substring(1, para.length() - 1).split(",");
                    authorizeInfo.setSerialNum(paraArray[0]);
                    if (paraArray.length > 1) {
                        authorizeInfo.setRegCode(paraArray[1]);
                    }
                    if (paraArray.length > 2) {
                        authorizeInfo.setCompany(paraArray[2]);
                    }
                    if (paraArray.length > 3) {
                        authorizeInfo.setTelephone(paraArray[3]);
                    }
                    if (paraArray.length > 4) {
                        authorizeInfo.setTelephone(paraArray[4]);
                    }
                    Object result = method.invoke((Object)nbiotAuthorize, authorizeInfo);
                    body.printf("<result>%s</result>", HTTPDesUtils.encrypt((String)result));
                }
            }
            catch (Exception e2) {
                body.printf("<result>%s</result>", "");
            }
            ((Request)this.getRequest()).setHandled(true);
        }
    }

    public class SendStatus
    extends a {
        public SendStatus(JDSMSServer myServer, String myTarget, HttpServletRequest myRequest, HttpServletResponse myResponse) {
            super(myServer, myTarget, myRequest, myResponse);
        }

        @Override
        public void process() throws IOException {
            PrintWriter body = this.getResponse().getWriter();
            String msgid = this.getRequest().getParameter("msgid");
            String status = this.a(Long.valueOf(msgid));
            this.getResponse().setStatus(200);
            body.println("<?xml version='1.0' encoding=\"UTF-8\"?>");
            body.printf("<status>%s</status>", status);
            ((Request)this.getRequest()).setHandled(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String a(long msgid) {
            String string;
            PropertiesConfiguration props = JDSMSServer.getInstance().getProperties();
            if (!DbUtils.loadDriver((String)props.getString("db1.driver"))) {
                return "load driver error";
            }
            Connection conn = null;
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                String szTmpPwd;
                String url = "";
                url = JDSMSServer.getInstance().getProperties().getString("db1.url", "");
                String szDbPwd = "";
                String szTmpEnc = JDSMSServer.getInstance().getProperties().getString("db1.enc", "");
                szDbPwd = szTmpPwd = JDSMSServer.getInstance().getProperties().getString("db1.password", "");
                if (szTmpEnc != null && szTmpEnc.equals("1")) {
                    szDbPwd = PwdConf.decPwd(szTmpPwd);
                }
                conn = DriverManager.getConnection(url, props.getString("db1.username"), szDbPwd);
                String sql = "select status from  %s where id ='" + msgid + "'";
                pstmt = conn.prepareStatement(sql = String.format(sql, props.getProperty("db1.tables.sms_out")));
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    string = rs.getString(1);
                    DbUtils.closeQuietly((Connection)conn, (Statement)pstmt, (ResultSet)rs);
                    return string;
                }
                string = "no data";
                DbUtils.closeQuietly((Connection)conn, (Statement)pstmt, (ResultSet)rs);
            }
            catch (SQLException e2) {
                String string2 = e2.toString();
                return string2;
            }
            finally {
                DbUtils.closeQuietly(conn, pstmt, rs);
            }
            return string;
        }
    }

    class c
    extends a {
        public c(JDSMSServer myServer, String myTarget, HttpServletRequest myRequest, HttpServletResponse myResponse) {
            super(myServer, myTarget, myRequest, myResponse);
        }

        @Override
        public void process() throws IOException {
            String line;
            PrintWriter body = this.getResponse().getWriter();
            this.getResponse().setContentType("text/html");
            this.getResponse().setStatus(200);
            body.println("<html>");
            body.println("<head>");
            body.println("<title>JDSMSServer - Status</title>");
            body.println("<style type='text/css'> ");
            body.println("<!--");
            body.println("#box-table-a");
            body.println("{");
            body.println("font-family: 'Lucida Sans Unicode', 'Lucida Grande', Sans-Serif;");
            body.println("font-size: 12px;");
            body.println("width: 100px;");
            body.println("text-align: left;");
            body.println("border-collapse: collapse;");
            body.println("}");
            body.println("#box-table-a th");
            body.println("{");
            body.println("font-size: 13px;");
            body.println("font-weight: normal;");
            body.println("padding: 8px;");
            body.println("background: #b9c9fe;");
            body.println("border-top: 4px solid #aabcfe;");
            body.println("border-bottom: 1px solid #fff;");
            body.println("color: #039;");
            body.println("}");
            body.println("#box-table-a td");
            body.println("{");
            body.println("padding: 8px;");
            body.println("background: #e8edff; ");
            body.println("border-bottom: 1px solid #fff;");
            body.println("color: #669;");
            body.println("border-top: 1px solid transparent;");
            body.println("}");
            body.println("#box-table-a tr:hover td");
            body.println("{");
            body.println("background: #d0dafd;");
            body.println("color: #339;");
            body.println("}");
            body.println("-->");
            body.println("</style>");
            body.println("</head>");
            body.println("<body style='font-family:Arial, Helvetica, sans-serif; font-size: 0.8em;'>");
            body.println("<p style='font-size: 2em; font-weight: bold; text-align: center;'>JDSMSServer - Status Page</p>");
            String tpl = "<p style='text-align: center;'>Version: _VERSION<br />Uptime: since _START, _D days, _H hours, _M minutes</p>";
            String line2 = tpl.replaceAll("_VERSION", Library.getLibraryVersion());
            line2 = line2.replaceAll("_START", new Date(Service.getInstance().getStartMillis()).toString());
            long msMillisDiff = System.currentTimeMillis() - Service.getInstance().getStartMillis();
            int days = (int)(msMillisDiff / 86400000L);
            int hours = (int)((msMillisDiff -= (long)(days * 86400000)) / 3600000L);
            int minutes = (int)((msMillisDiff -= (long)(hours * 3600000)) / 60000L);
            line2 = line2.replaceAll("_D", "" + days);
            line2 = line2.replaceAll("_H", "" + hours);
            line2 = line2.replaceAll("_M", "" + minutes);
            body.println(line2);
            body.println("<p style='font-size: 1.3em; font-weight: bold; text-align: center;'>Gateway Status</p>");
            body.println("<center>");
            body.println("<table id='box-table-a' style='width: 750px;'>");
            body.println("<tr><th></th><th></th><th></th><th></th><th scope='col' colspan='2' style='text-align: center;'>Total Traffic</th><th></th><th></th><th></th></tr>");
            body.println("<tr><th>Name</th><th>Type</th><th style='text-align: center;'>IN?</th><th style='text-align: center;'>OUT?</th><th style='text-align: right;'>Inbound</th><th style='text-align: right;'>Outbound</th><th style='text-align: right;'>Queued</th><th style='text-align: right;'>Restarts</th><th style='text-align: center;'>Status</th></tr>");
            for (AGateway gateway : Service.getInstance().getGateways()) {
                line = "<tr><td>_NAME</td><td>_CLASS</td><td style='text-align: center;'>_ISIN</td><td style='text-align: center;'>_ISOUT</td><td style='text-align: right;'>_INBOUND</td><td style='text-align: right;'>_OUTBOUND</td><td style='text-align: right;'>_QUEUED</td><td style='text-align: right;'>_RESTART</td><td style='text-align: center;'>_STATUS</td></tr>";
                line = line.replaceAll("_NAME", gateway.getGatewayId());
                line = line.replaceAll("_CLASS", gateway.getClass().getName());
                line = line.replaceAll("_ISIN", gateway.isInbound() ? "Yes" : "No");
                line = line.replaceAll("_ISOUT", gateway.isOutbound() ? "Yes" : "No");
                line = line.replaceAll("_INBOUND", "" + gateway.getInboundMessageCount());
                line = line.replaceAll("_OUTBOUND", "" + gateway.getOutboundMessageCount());
                line = line.replaceAll("_QUEUED", "0");
                line = line.replaceAll("_RESTART", "" + gateway.getRestartCount());
                switch (gateway.getStatus()) {
                    case STOPPING: {
                        line = line.replaceAll("_STATUS", "Stopping...");
                        break;
                    }
                    case STOPPED: {
                        line = line.replaceAll("_STATUS", "Stopped");
                        break;
                    }
                    case FAILURE: {
                        line = line.replaceAll("_STATUS", "Failure");
                        break;
                    }
                    case RESTART: {
                        line = line.replaceAll("_STATUS", "Restarting");
                        break;
                    }
                    case STARTING: {
                        line = line.replaceAll("_STATUS", "Starting...");
                        break;
                    }
                    case STARTED: {
                        line = line.replaceAll("_STATUS", "Started");
                        break;
                    }
                    default: {
                        line = line.replaceAll("_STATUS", "defaut...");
                    }
                }
                body.println(line);
            }
            Iterator<AGateway> iter = null;
            body.println("</table>");
            body.println("</center>");
            body.println("<br />");
            body.println("<p style='font-size: 1.3em; font-weight: bold; text-align: center;'>Interface Status</p>");
            body.println("<center>");
            body.println("<table id='box-table-a' style='width: 500px;'>");
            body.println("<tr><th>Name</th><th>Type</th><th style='text-align: center;'>IN?</th><th style='text-align: center;'>OUT?</th><th style='text-align: center;'>Queue</th></tr>");
            for (int i2 = 0; i2 < this.getJDSMSServer().getInfList().size(); ++i2) {
                Interface<? extends Object> inf = this.getJDSMSServer().getInfList().get(i2);
                line = "<tr><td>_NAME</td><td>_CLASS</td><td style='text-align: center;'>_ISIN</td><td style='text-align: center;'>_ISOUT</td><td style='text-align: center;'>_QUEUE</td></tr>";
                line = line.replaceAll("_NAME", inf.getId());
                line = line.replaceAll("_CLASS", inf.getClass().getName());
                line = line.replaceAll("_ISIN", inf.isInbound() ? "Yes" : "No");
                line = line.replaceAll("_ISOUT", inf.isOutbound() ? "Yes" : "No");
                try {
                    line = line.replaceAll("_QUEUE", inf.getPendingMessagesToSend() == -1 ? "N/A" : "" + inf.getPendingMessagesToSend());
                }
                catch (Exception e2) {
                    line = line.replaceAll("_QUEUE", "N/A");
                }
                body.println(line);
            }
            body.println("</table>");
            body.println("</center>");
            body.println("</body>");
            body.println("</html>");
            ((Request)this.getRequest()).setHandled(true);
        }
    }

    abstract class a {
        private JDSMSServer a;
        private String b;
        private HttpServletRequest c;
        private HttpServletResponse d;

        public a(JDSMSServer myServer, String myTarget, HttpServletRequest myRequest, HttpServletResponse myResponse) {
            this.setJDSMSServer(myServer);
            this.setTarget(myTarget);
            this.setRequest(myRequest);
            this.setResponse(myResponse);
        }

        protected JDSMSServer getJDSMSServer() {
            return this.a;
        }

        protected void setJDSMSServer(JDSMSServer mySmsServer) {
            this.a = mySmsServer;
        }

        protected String getTarget() {
            return this.b;
        }

        protected void setTarget(String myTarget) {
            this.b = myTarget;
        }

        protected HttpServletRequest getRequest() {
            return this.c;
        }

        protected void setRequest(HttpServletRequest myRequest) {
            this.c = myRequest;
        }

        protected HttpServletResponse getResponse() {
            return this.d;
        }

        protected void setResponse(HttpServletResponse myResponse) {
            this.d = myResponse;
        }

        public abstract void process() throws IOException, ServletException;
    }

    class b
    extends AbstractHandler {
        protected JDSMSServer a;

        public b(JDSMSServer myServer) {
            this.a = myServer;
        }

        protected JDSMSServer a() {
            return this.a;
        }

        public void handle(String arg0, Request arg1, HttpServletRequest arg2, HttpServletResponse arg3) throws IOException, ServletException {
            if (arg2.getPathInfo().toString().equals("/")) {
                new c(this.a(), arg0, arg2, arg3).process();
            } else if (arg2.getPathInfo().toString().equals("/status")) {
                new c(this.a(), arg0, arg2, arg3).process();
            } else if (arg2.getPathInfo().toString().equals("/send")) {
                new Send(this.a(), arg0, arg2, arg3).process();
            } else if (arg2.getPathInfo().toString().equals("/read")) {
                new Read(this.a(), arg0, arg2, arg3).process();
            } else if (arg2.getPathInfo().toString().equals("/sendstatus")) {
                new SendStatus(this.a(), arg0, arg2, arg3).process();
            } else if (arg2.getPathInfo().toString().equals("/authorize")) {
                new Authorize(this.a(), arg0, arg2, arg3).process();
            }
        }
    }

    class d
    extends Thread {
        JDSMSServer a;
        int b;
        boolean c;
        private Server e;

        public d(JDSMSServer myServer, int myPort, boolean use_ssl) {
            this.a = myServer;
            this.b = myPort;
            this.c = use_ssl;
        }

        @Override
        public void run() {
            this.e = new Server();
            if (this.c) {
                SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
                sslContextFactory.setExcludeCipherSuites(new String[]{"^.*_(MD5|SHA|SHA1)$"});
                sslContextFactory.setKeyStorePath(System.getProperty("user.dir") + File.separator + "cert" + File.separator + "config.keystore");
                sslContextFactory.setKeyStorePassword("123456");
                sslContextFactory.setKeyManagerPassword("123456");
                HttpConfiguration httpsConfig = new HttpConfiguration();
                httpsConfig.setSecureScheme("https");
                httpsConfig.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
                HttpConnectionFactory http11 = new HttpConnectionFactory(httpsConfig);
                ServerConnector https = new ServerConnector(this.e, new ConnectionFactory[]{new SslConnectionFactory((SslContextFactory)sslContextFactory, http11.getProtocol()), http11});
                https.setPort(this.b);
                https.setIdleTimeout(500000L);
                this.e.addConnector((Connector)https);
            } else {
                HttpConfiguration httpConfig = new HttpConfiguration();
                httpConfig.setSecureScheme("https");
                httpConfig.setSecurePort(8443);
                httpConfig.setOutputBufferSize(32768);
                httpConfig.setRequestHeaderSize(8192);
                httpConfig.setResponseHeaderSize(8192);
                httpConfig.setSendServerVersion(true);
                httpConfig.setSendDateHeader(false);
                ServerConnector http = new ServerConnector(this.e, new ConnectionFactory[]{new HttpConnectionFactory(httpConfig)});
                http.setPort(this.b);
                http.setIdleTimeout(30000L);
                this.e.addConnector((Connector)http);
            }
            this.e.setHandler((Handler)new b(this.a));
            try {
                this.e.start();
            }
            catch (Exception e2) {
                log.error((Object)e2);
            }
        }
    }
}

