/*
 * Decompiled with CFR 0.152.
 */
package cn.sendsms.jdsmsserver.web;

import cn.sendsms.jdsmsserver.JDSMSServer;
import cn.sendsms.jdsmsserver.web.RegCodeGen;
import com.sun.crypto.provider.SunJCE;
import java.io.File;
import java.security.Security;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.dbutils.DbUtils;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;

public class NewAuth {
    private static final String url = "jdbc:derby:" + System.getProperty("user.dir") + "/conf/authorize";
    private static final byte[] deskey = "=1%c,qd]".getBytes();
    private static Logger log = Logger.getRootLogger();

    private static Connection connectDB() {
        Connection conn = null;
        try {
            Class.forName("org.apache.derby.jdbc.EmbeddedDriver");
            File dbpath = FileUtils.getFile((String[])new String[]{System.getProperty("user.dir"), "conf", "authorize"});
            if (!dbpath.exists()) {
                System.out.println("db path not exist url: " + url);
                conn = DriverManager.getConnection(url + ";create=true", "jindi", "chundi");
            } else {
                conn = DriverManager.getConnection(url + ";create=false", "jindi", "chundi");
            }
            if (conn != null) {
                Statement stmt;
                String sql;
                ResultSet tabRes = conn.getMetaData().getTables(null, "JINDI", "AUTHORIZE_INFO", null);
                if (!tabRes.next()) {
                    System.out.println("not found table - authorize_info");
                    sql = "create table authorize_info (port varchar(40),serialnum varchar(40),regcode varchar(1000),authorize_num int,isauthorize int,authorize_time TimeStamp)";
                    stmt = conn.createStatement();
                    stmt.execute(sql);
                    stmt.close();
                }
                if (!(tabRes = conn.getMetaData().getTables(null, "JINDI", "JD_CODES", null)).next()) {
                    sql = "create table jd_codes (regcode varchar(1000) PRIMARY KEY, total_num INT NOT NULL, past_num INT NOT NULL, first_day INT NOT NULL, last_day INT NOT NULL)";
                    stmt = conn.createStatement();
                    stmt.execute(sql);
                    stmt.close();
                }
            }
        }
        catch (Exception e2) {
            log.error((Object)"connect authorize failed", (Throwable)e2);
        }
        if (conn == null) {
            System.out.println("\u8fde\u63a5\u6570\u636e\u5e93\u5931\u8d25");
        }
        return conn;
    }

    private static int getCurHour() {
        int nHour = (int)(new Date().getTime() / 3600000L - 455824L);
        return nHour;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getDayFromRegCode(String szRegCode) {
        int nCodeLen = szRegCode.length();
        if (nCodeLen == 23) {
            return 0;
        }
        if (nCodeLen != 28) {
            return -1;
        }
        String szMid = szRegCode.substring(23, 24);
        if (!szMid.equals("-")) {
            return -1;
        }
        String szDays = szRegCode.substring(24);
        int nDays = -1;
        try {
            nDays = Integer.parseInt(szDays);
        }
        catch (NumberFormatException numberFormatException) {}
        if (nDays <= 0 || nDays > 9200) {
            return -1;
        }
        return nDays;
    }

    private static boolean isValidRegCode(String szRegCode, String szDevNo) {
        int nCodeLen = szRegCode.length();
        if (nCodeLen != 23 && nCodeLen != 28) {
            return false;
        }
        if (nCodeLen == 23) {
            return RegCodeGen.getRegCode(szDevNo).equals(szRegCode);
        }
        String szDays = szRegCode.substring(24);
        int nDays = NewAuth.getDayFromRegCode(szRegCode);
        if (nDays <= 0) {
            return false;
        }
        return RegCodeGen.getRegCode(szDevNo + "-" + szDays).equals(szRegCode.substring(0, 23));
    }

    private static boolean saveRegCode(String szRegCode) {
        RegCodeInfo retInfo = NewAuth.readRegCodeInfo(szRegCode);
        if (retInfo != null) {
            return true;
        }
        int nTotalNum = NewAuth.getDayFromRegCode(szRegCode);
        if (nTotalNum < 0) {
            return false;
        }
        int nFirstDay = NewAuth.getCurHour();
        if (nFirstDay < 0) {
            return false;
        }
        int nLastDay = nFirstDay;
        boolean bOk = false;
        String sql = "insert into jd_codes (regcode,total_num,past_num,first_day,last_day) VALUES ('" + szRegCode + "'," + nTotalNum + ",0," + nFirstDay + "," + nLastDay + ")";
        Connection conn = NewAuth.connectDB();
        if (conn != null) {
            Statement stmt = null;
            ResultSet rs = null;
            try {
                stmt = conn.createStatement();
                stmt.executeUpdate(sql);
                bOk = true;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            DbUtils.closeQuietly((Connection)conn, (Statement)stmt, rs);
        }
        return bOk;
    }

    private static RegCodeInfo readRegCodeInfo(String szRegCode) {
        String sql = "select total_num, past_num, first_day, last_day from jd_codes where regcode='" + szRegCode + "'";
        RegCodeInfo retInfo = null;
        Connection conn = NewAuth.connectDB();
        if (conn != null) {
            Statement stmt = null;
            ResultSet rs = null;
            try {
                stmt = conn.createStatement();
                rs = stmt.executeQuery(sql);
                if (rs.next()) {
                    retInfo = new RegCodeInfo();
                    retInfo.totalNum = rs.getInt(1);
                    retInfo.pastNum = rs.getInt(2);
                    retInfo.firstDay = rs.getInt(3);
                    retInfo.lastDay = rs.getInt(4);
                    retInfo.regCode = szRegCode;
                }
            }
            catch (SQLException e2) {
                retInfo = null;
            }
            DbUtils.closeQuietly((Connection)conn, (Statement)stmt, (ResultSet)rs);
        }
        return retInfo;
    }

    private static boolean updateRegCodeInfo(String szRegCode) {
        RegCodeInfo info = NewAuth.readRegCodeInfo(szRegCode);
        if (info == null) {
            return false;
        }
        if (info.totalNum < 1) {
            return false;
        }
        if (info.totalNum <= info.pastNum) {
            return false;
        }
        int nCurHour = NewAuth.getCurHour();
        if (nCurHour < 0) {
            return false;
        }
        if (nCurHour < info.lastDay) {
            boolean bOk = false;
            String sql = "update jd_codes set past_num=" + (info.pastNum + 1) + ", last_day=" + nCurHour + " where regcode='" + szRegCode + "'";
            Connection conn = NewAuth.connectDB();
            if (conn != null) {
                Statement stmt = null;
                ResultSet rs = null;
                try {
                    stmt = conn.createStatement();
                    stmt.executeUpdate(sql);
                    bOk = true;
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                DbUtils.closeQuietly((Connection)conn, (Statement)stmt, rs);
            }
            return bOk;
        }
        int nSpace = (nCurHour - info.lastDay) % 24;
        int nDayPass = (nCurHour - info.lastDay - nSpace) / 24;
        if (nDayPass > 0) {
            boolean bOk = false;
            String sql = "update jd_codes set past_num=" + (info.pastNum + nDayPass) + ", last_day=" + (info.lastDay + nDayPass * 24) + " where regcode='" + szRegCode + "'";
            Connection conn = NewAuth.connectDB();
            if (conn != null) {
                Statement stmt = null;
                ResultSet rs = null;
                try {
                    stmt = conn.createStatement();
                    stmt.executeUpdate(sql);
                    bOk = true;
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                DbUtils.closeQuietly((Connection)conn, (Statement)stmt, rs);
            }
            return bOk;
        }
        return false;
    }

    public static int checkExistCode(String szCode) {
        NewAuth.updateRegCodeInfo(szCode);
        RegCodeInfo retInfo = NewAuth.readRegCodeInfo(szCode);
        if (retInfo == null) {
            return 0;
        }
        System.out.println("total=" + retInfo.totalNum + ",pass=" + retInfo.pastNum + ",first=" + retInfo.firstDay + ",last=" + retInfo.lastDay);
        if (retInfo.totalNum < 1) {
            return 1;
        }
        if (retInfo.totalNum <= retInfo.pastNum) {
            return 2;
        }
        if (NewAuth.getCurHour() < 0) {
            return 3;
        }
        return 1;
    }

    public static int checkDevRegCode(String serialnum, String szCode) {
        if (!NewAuth.isValidRegCode(szCode, serialnum)) {
            return 0;
        }
        int nStat = NewAuth.checkExistCode(szCode);
        if (nStat > 0) {
            return nStat;
        }
        if (NewAuth.getCurHour() < 0) {
            return 3;
        }
        if (NewAuth.saveRegCode(szCode)) {
            return 1;
        }
        return 0;
    }

    public static void saveAuthorize(String port, String serialnum, String regcode) throws Exception {
        if (regcode == null) {
            regcode = "";
        }
        String sql = "select count(1) from authorize_info where serialnum='" + serialnum + "'";
        Connection conn = NewAuth.connectDB();
        if (conn == null) {
            return;
        }
        Statement stmt = conn.createStatement();
        ResultSet rs = stmt.executeQuery(sql);
        rs.next();
        int count = rs.getInt(1);
        sql = count == 0 ? "insert into authorize_info values('" + port + "','" + serialnum + "','" + regcode + "',88,0,CURRENT_TIMESTAMP)" : "update authorize_info set regcode ='" + regcode + "',isauthorize=0, port='" + port + "',authorize_time=CURRENT_TIMESTAMP  where serialnum='" + serialnum + "'";
        stmt.executeUpdate(sql);
        DbUtils.closeQuietly((Connection)conn, (Statement)stmt, (ResultSet)rs);
    }

    public static void updateAuthorizeTemp() throws Exception {
        JDSMSServer.getInstance().userConsolePrint("f1", "updateAuthorizeTemp no param");
    }

    public static void updateAuthorizeTemp(String port, String serialnum) throws Exception {
        JDSMSServer.getInstance().userConsolePrint("f1", "updateAuthorizeTemp: " + port + "," + serialnum);
        String sql = "select count(1) from authorize_info where serialnum='" + serialnum + "'";
        Connection conn = NewAuth.connectDB();
        if (conn == null) {
            return;
        }
        Statement stmt = conn.createStatement();
        ResultSet rs = stmt.executeQuery(sql);
        rs.next();
        int count = rs.getInt(1);
        if (count == 0) {
            sql = "insert into authorize_info values('" + port + "','" + serialnum + "','0',88,0,CURRENT_TIMESTAMP)";
            stmt.executeUpdate(sql);
        }
        DbUtils.closeQuietly((Connection)conn, (Statement)stmt, (ResultSet)rs);
    }

    public static int getAvaliableNum(String serialnum) {
        int num = 0;
        try {
            String szRet = NewAuth.getAuthorizeInfo(serialnum, "authorize_num");
            JDSMSServer.getInstance().userConsolePrint("f1", "authorize_num ret: " + szRet);
            if (szRet == null || szRet.isEmpty()) {
                szRet = "0";
            }
            num = Integer.valueOf(szRet);
        }
        catch (Exception e2) {
            JDSMSServer.getInstance().userConsolePrint("f1", "getAvaliableNum error: " + e2.toString());
            return -9999;
        }
        return num;
    }

    public static void updateAvaliableNum(String serialnum, int num) throws SQLException {
        String sql = "update authorize_info set authorize_num=" + num + " where serialnum='" + serialnum + "'";
        Connection conn = NewAuth.connectDB();
        if (conn == null) {
            return;
        }
        Statement stmt = conn.createStatement();
        stmt.executeUpdate(sql);
        DbUtils.closeQuietly((Connection)conn, (Statement)stmt, null);
    }

    public static String getAuthorizeInfo(String serialnum, String key) throws Exception {
        String sql = "select " + key + " from authorize_info where serialnum='" + serialnum + "' order by authorize_time desc";
        Connection conn = NewAuth.connectDB();
        if (conn == null) {
            return "";
        }
        Statement stmt = conn.createStatement();
        ResultSet rs = stmt.executeQuery(sql);
        if (rs.next()) {
            if (key == "authorize_time") {
                Timestamp date = rs.getTimestamp(key);
                SimpleDateFormat format = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5 HH\u65f6mm\u5206ss\u79d2");
                DbUtils.closeQuietly((Connection)conn, (Statement)stmt, (ResultSet)rs);
                return format.format(date);
            }
            if (key == "regcode") {
                String tmp = rs.getString(key);
                DbUtils.closeQuietly((Connection)conn, (Statement)stmt, (ResultSet)rs);
                return tmp;
            }
            String result = rs.getString(key).trim();
            DbUtils.closeQuietly((Connection)conn, (Statement)stmt, (ResultSet)rs);
            return result;
        }
        DbUtils.closeQuietly((Connection)conn, (Statement)stmt, (ResultSet)rs);
        return null;
    }

    public static void initAuthorize(String port, String serialnum, String regcode) throws Exception {
        if (regcode == null) {
            regcode = "";
        }
        String sql = "select count(1) from authorize_info where serialnum='" + serialnum + "'";
        Connection conn = NewAuth.connectDB();
        if (conn == null) {
            return;
        }
        Statement stmt = conn.createStatement();
        ResultSet rs = stmt.executeQuery(sql);
        rs.next();
        int count = rs.getInt(1);
        if (count == 0) {
            sql = "insert into authorize_info values('" + port + "','" + serialnum + "','" + regcode + "',88," + 0 + ",CURRENT_TIMESTAMP)";
            stmt.executeUpdate(sql);
        }
        DbUtils.closeQuietly((Connection)conn, (Statement)stmt, (ResultSet)rs);
    }

    public static void createAuthorize() {
        Connection conn = NewAuth.connectDB();
        if (conn == null) {
            return;
        }
        DbUtils.closeQuietly((Connection)conn);
    }

    public static boolean checkDeviceAuth(String serialnum) {
        String regcode = null;
        try {
            regcode = NewAuth.getAuthorizeInfo(serialnum, "regcode");
        }
        catch (Exception e2) {
            log.error((Object)"\u83b7\u53d6\u6388\u6743\u4fe1\u606f\u5f02\u5e38\u3002", (Throwable)e2);
        }
        if (regcode == null) {
            return false;
        }
        if (regcode.isEmpty()) {
            return false;
        }
        if (regcode.equals("-")) {
            return false;
        }
        if (regcode.equals("0")) {
            return false;
        }
        int nStat = NewAuth.checkDevRegCode(serialnum, regcode);
        return nStat == 1;
    }

    static {
        Security.addProvider(new SunJCE());
    }

    public static class RegCodeInfo {
        public String regCode;
        public int totalNum;
        public int pastNum;
        public int firstDay;
        public int lastDay;
    }
}

