/*
 * Decompiled with CFR 0.152.
 */
package cn.sendsms.modem;

import cn.sendsms.GatewayException;
import cn.sendsms.Service;
import cn.sendsms.helper.CommPortIdentifier;
import cn.sendsms.helper.Logger;
import cn.sendsms.modem.AModemDriver;
import cn.sendsms.modem.ModemGateway;
import cn.sendsms.modem.athandler.ATHandler_Yuga;
import cn.sendsms.threading.AServiceThread;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.StringTokenizer;
import jssc.SerialPort;
import jssc.SerialPortEvent;
import jssc.SerialPortEventListener;
import jssc.SerialPortException;

public class SerialModemDriver
extends AModemDriver
implements SerialPortEventListener {
    private String a;
    private int b;
    private CommPortIdentifier c;
    private SerialPort d;
    private InputStream e;
    private OutputStream f;
    private a g;
    private static Object synclock = new Object();

    protected SerialModemDriver(ModemGateway myGateway, String deviceParms) {
        super(myGateway, deviceParms);
        StringTokenizer tokens = new StringTokenizer(deviceParms, ":");
        this.a(tokens.nextToken());
        this.b(Integer.parseInt(tokens.nextToken()));
        this.a((SerialPort)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void connectPort() throws GatewayException, IOException, InterruptedException {
        if (Service.getInstance().getSettings().SERIAL_NOFLUSH) {
            Logger.getInstance().logInfo("Comm port flushing is disabled.", null, this.getGateway().getGatewayId());
        }
        if (Service.getInstance().getSettings().SERIAL_POLLING) {
            Logger.getInstance().logInfo("Using polled serial port mode.", null, this.getGateway().getGatewayId());
        }
        try {
            Logger.getInstance().logInfo("Opening: " + this.b() + " @" + this.c(), null, this.getGateway().getGatewayId());
            boolean flag = false;
            Object object = synclock;
            synchronized (object) {
                SerialPort ser_ = new SerialPort(this.b());
                this.a(ser_);
                flag = ser_.openPort();
            }
            Logger.getInstance().logInfo("Opened: " + this.b() + " @" + this.c(), null, this.getGateway().getGatewayId() + " \u6253\u5f00\u8fd4\u56de" + flag);
            if (this.getGateway().getATHandler() instanceof ATHandler_Yuga) {
                this.getSerialPort().setFlowControlMode(3);
            } else if (Service.getInstance().getSettings().SERIAL_RTSCTS_OUT) {
                this.getSerialPort().setFlowControlMode(3);
            } else {
                this.getSerialPort().setFlowControlMode(1);
            }
            if (!Service.getInstance().getSettings().SERIAL_POLLING) {
                this.getSerialPort().addEventListener((SerialPortEventListener)this);
            }
            this.getSerialPort().setParams(this.c(), 8, 1, 0);
            if (Service.getInstance().getSettings().SERIAL_POLLING) {
                this.a(new a("PortReader() [" + this.b() + "]", Service.getInstance().getSettings().SERIAL_POLLING_INTERVAL));
            }
        }
        catch (Exception e2) {
            throw new GatewayException("Comm library exception: " + e2.getMessage());
        }
        this.setConnected(true);
        this.setOccurTimeoutError(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void disconnectPort() throws IOException, InterruptedException {
        Object object = this.getSYNCReader();
        synchronized (object) {
            if (Service.getInstance().getSettings().SERIAL_POLLING && this.a() != null) {
                this.a().cancel();
                this.a((a)null);
            }
            boolean flag = false;
            if (this.getSerialPort() != null && this.getSerialPort().isOpened()) {
                try {
                    flag = this.getSerialPort().closePort();
                }
                catch (SerialPortException e2) {
                    Logger.getInstance().logError("\u5173\u95ed\u4e32\u53e3\u65f6\u51fa\u73b0\u5f02\u5e38", (Exception)((Object)e2), this.getGateway().getGatewayId());
                }
            }
            Logger.getInstance().logInfo("Closing: " + this.b() + " @" + this.c() + " \u5173\u95ed\u8fd4\u56de:" + flag, null, this.getGateway().getGatewayId());
            this.setConnected(false);
        }
    }

    @Override
    protected void clear() throws IOException {
        while (this.portHasData()) {
            this.read();
        }
    }

    @Override
    protected boolean portHasData() throws IOException {
        boolean flag = false;
        try {
            flag = this.d.getInputBufferBytesCount() > 0;
        }
        catch (SerialPortException e2) {
            e2.printStackTrace();
        }
        return flag;
    }

    @Override
    public void write(char c2) throws IOException {
        try {
            this.d.writeInt((int)c2);
        }
        catch (SerialPortException e2) {
            e2.printStackTrace();
        }
    }

    @Override
    public void write(byte[] s) throws IOException {
        if (Service.getInstance().getSettings().SERIAL_BUFFER_CHUNK == 0) {
            try {
                boolean flag = this.d.writeBytes(s);
                Logger.getInstance().logInfo("\u5199\u5165\u8fd4\u56de" + flag + "\u5199\u5165\u4e32\u53e3\u6570\u636e :" + s, null, this.getGateway().getGatewayId());
            }
            catch (SerialPortException e1) {
                Logger.getInstance().logError("\u5199\u5165\u4e32\u53e3\u6570\u636e\u51fa\u9519 \uff01", (Exception)((Object)e1), e1.getPortName());
                e1.printStackTrace();
            }
        } else {
            int i2;
            int offset = 0;
            for (int left = s.length; left > 0; left -= i2) {
                i2 = left > Service.getInstance().getSettings().SERIAL_BUFFER_CHUNK ? Service.getInstance().getSettings().SERIAL_BUFFER_CHUNK : left;
                this.f().write(s, offset, i2);
                offset += i2;
                if (this.threadWait(Service.getInstance().getSettings().SERIAL_BUFFER_CHUNK_DELAY)) continue;
                break;
            }
        }
    }

    @Override
    protected byte[] read() throws IOException {
        byte[] bytes = null;
        try {
            bytes = this.getSerialPort().readBytes();
        }
        catch (SerialPortException e2) {
            Logger.getInstance().logError("\u8bfb\u53d6\u4e32\u53e3\u6570\u636e\u51fa\u9519\uff01", (Exception)((Object)e2), e2.getPortName());
            e2.printStackTrace();
        }
        return bytes;
    }

    a a() {
        return this.g;
    }

    void a(a myPortReader) {
        this.g = myPortReader;
    }

    String b() {
        return this.a;
    }

    void a(String myComPort) {
        this.a = myComPort;
    }

    int c() {
        return this.b;
    }

    void b(int myBaudRate) {
        this.b = myBaudRate;
    }

    CommPortIdentifier d() {
        return this.c;
    }

    void a(CommPortIdentifier myPortId) {
        this.c = myPortId;
    }

    public SerialPort getSerialPort() {
        return this.d;
    }

    void a(SerialPort mySerialPort) {
        this.d = mySerialPort;
    }

    InputStream e() {
        return this.e;
    }

    void a(InputStream myIn) {
        this.e = myIn;
    }

    OutputStream f() {
        return this.f;
    }

    void a(OutputStream myOut) {
        this.f = myOut;
    }

    @Override
    public void writeSring(String s) throws IOException {
        try {
            boolean flag = this.getSerialPort().writeBytes(s.getBytes());
            Logger.getInstance().logInfo("\u5199\u5165\u8fd4\u56de" + flag + "\u5199\u5165\u4e32\u53e3\u6570\u636e:" + s, null, this.getGateway().getGatewayId());
        }
        catch (SerialPortException e2) {
            Logger.getInstance().logError("\u5199\u5165\u4e32\u53e3\u6570\u636e\u51fa\u9519\uff01", (Exception)((Object)e2), e2.getPortName());
            e2.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serialEvent(SerialPortEvent se) {
        int eventType = se.getEventType();
        if (eventType == 2) {
            Logger.getInstance().logError("The event character was received and placed in the input buffer!", null, this.getGateway().getGatewayId());
        } else if (eventType == 256) {
            Logger.getInstance().logError("A ring indicator was detected!", null, this.getGateway().getGatewayId());
        } else if (eventType == 64) {
            Logger.getInstance().logError("A break was detected on input!", null, this.getGateway().getGatewayId());
        } else if (eventType == 128) {
            Logger.getInstance().logError("A line-status error occurred!", null, this.getGateway().getGatewayId());
        } else if (eventType == 1 && !Service.getInstance().getSettings().SERIAL_POLLING) {
            Object object = this.getSYNCReader();
            synchronized (object) {
                this.setDataReceived(true);
                this.getSYNCReader().notifyAll();
            }
        }
    }

    private class a
    extends AServiceThread {
        public a(String name, int delay) {
            super(name, delay, 0, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void process() throws Exception {
            block5: {
                try {
                    if (!SerialModemDriver.this.portHasData()) break block5;
                    Object object = SerialModemDriver.this.getSYNCReader();
                    synchronized (object) {
                        SerialModemDriver.this.setDataReceived(true);
                        SerialModemDriver.this.getSYNCReader().notifyAll();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

