/*
 * Decompiled with CFR 0.152.
 */
package cn.sendsms.modem.athandler;

import cn.sendsms.GatewayException;
import cn.sendsms.InboundMessage;
import cn.sendsms.Service;
import cn.sendsms.TimeoutException;
import cn.sendsms.helper.Logger;
import cn.sendsms.modem.ModemGateway;
import cn.sendsms.modem.athandler.ATHandler_Huawei;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ATHandler_Huawei_MC323
extends ATHandler_Huawei {
    private Object a = new Object();

    public ATHandler_Huawei_MC323(ModemGateway myGateway) {
        super(myGateway);
        this.setStorageLocations("ME");
    }

    public String getNetworkOperator() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getModemDriver().write("AT+CREG?\r");
        return this.getModemDriver().getResponse();
    }

    @Override
    public String getSerialNo() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getModemDriver().write("AT+CPBS=\"ME\"\r");
        this.getModemDriver().getResponse();
        this.getModemDriver().write("AT^CPBR=1\r");
        String result = this.getModemDriver().getResponse();
        result = result.replaceAll("AT^CPBR=1\r", "").replaceAll("\\s+OK\\s+", "").replaceAll("\\s+", "");
        result = result.substring(result.indexOf(58) + 1);
        String key = result.substring(result.lastIndexOf(44, result.length() - 3) + 1, result.lastIndexOf(","));
        if (result.indexOf("ERROR") != -1) {
            return "N/A";
        }
        if (result.trim().equals("")) {
            return "N/A";
        }
        if (!key.equals("\"WMSN\"")) {
            return "N/A";
        }
        String str = result.split(",")[1];
        return str.substring(1, str.length() - 1);
    }

    @Override
    public String getSerialNumber() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getModemDriver().write("AT+CPBS=\"ME\"\r");
        this.getModemDriver().getResponse();
        this.getModemDriver().write("AT^CPBR=1\r");
        String result = this.getModemDriver().getResponse();
        result = result.replaceAll("AT^CPBR=1\r", "").replaceAll("\\s+OK\\s+", "").replaceAll("\\s+", "");
        result = result.substring(result.indexOf(58) + 1);
        String key = result.substring(result.lastIndexOf(44, result.length() - 3) + 1, result.lastIndexOf(","));
        if (result.indexOf("ERROR") != -1) {
            return "N/A";
        }
        if (result.trim().equals("")) {
            return "N/A";
        }
        if (!key.equals("\"WMSN\"")) {
            return "N/A";
        }
        String str = result.split(",")[1];
        return str.substring(1, str.length() - 1);
    }

    @Override
    public void reset() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getModemDriver().clearBuffer();
        this.getModemDriver().write("AT^CURC=0\r");
        this.getModemDriver().getResponse();
    }

    @Override
    public String listMessages(InboundMessage.MessageClasses messageClass) throws TimeoutException, GatewayException, IOException, InterruptedException {
        StringBuffer msgList = new StringBuffer();
        this.getModemDriver().clearBuffer();
        if (messageClass == InboundMessage.MessageClasses.ALL) {
            this.getModemDriver().write("AT^HCMGL=4\r");
        } else if (messageClass == InboundMessage.MessageClasses.UNREAD) {
            this.getModemDriver().write("AT^HCMGL=0\r");
        } else if (messageClass == InboundMessage.MessageClasses.READ) {
            this.getModemDriver().write("AT^HCMGL=1\r");
        }
        String listMsgRespons = this.getModemDriver().getResponse();
        ArrayList<Integer> memIndexs = this.a(listMsgRespons);
        for (int x = 0; x < memIndexs.size(); ++x) {
            int memIndex = memIndexs.get(x);
            String header = "";
            String msgText = "";
            this.getModemDriver().write("AT^HCMGR=" + memIndex + "\r");
            byte[] text = this.getModemDriver().getResponseByteArray();
            int i2 = 0;
            for (i2 = 0; i2 < text.length && text[i2] != 13; ++i2) {
                header = header + (char)text[i2];
            }
            ++i2;
            String regx = "(\\d{4},)(\\d{2},)(\\d{2},)(\\d{2},)(\\d{2},)(\\d{2},)(\\d,)(\\d)";
            Pattern pat = Pattern.compile(regx);
            Matcher matcher = pat.matcher(header);
            if (!matcher.find()) continue;
            String format = matcher.group();
            char encoding = matcher.group().substring(format.lastIndexOf(",") + 1, format.length()).trim().charAt(0);
            String msgContentStr = "";
            if (encoding == '6') {
                byte[] tmp = new byte[text.length - i2 - 4];
                for (int j2 = 0; j2 < tmp.length; ++j2) {
                    tmp[j2] = text[i2 + j2];
                }
                msgContentStr = ATHandler_Huawei_MC323.unicode2Ascii(tmp);
            } else {
                while (i2 < text.length) {
                    if (text[i2] == 26) {
                        ++i2;
                        continue;
                    }
                    msgContentStr = msgContentStr + (char)text[i2++];
                }
            }
            if (msgContentStr.charAt(0) == '\u0500') {
                msgContentStr = msgContentStr.substring(3);
            }
            msgText = header + "#" + memIndex + "#\r" + msgContentStr + "\r";
            msgList.append(msgText);
        }
        msgList.append("OK\r");
        return msgList.toString();
    }

    private ArrayList<Integer> a(String respons) throws IOException {
        String line;
        ArrayList<Integer> msgIndexs = new ArrayList<Integer>();
        String listMsgRespons = respons;
        BufferedReader reader = new BufferedReader(new StringReader(listMsgRespons));
        while ((line = reader.readLine().trim()) != null && (line = line.trim()).length() <= 0) {
        }
        while (line != null && (line = line.trim()).length() > 0 && !line.equalsIgnoreCase("OK")) {
            if (line.matches("^\\^HCMGL:\\s*\\d+,.*")) {
                int i2 = line.indexOf(58);
                int j2 = line.indexOf(44);
                int memIndex = Integer.parseInt(line.substring(i2 + 1, j2).trim());
                msgIndexs.add(memIndex);
            }
            line = reader.readLine().trim();
            while (line.length() == 0) {
                line = reader.readLine().trim();
            }
        }
        reader.close();
        return msgIndexs;
    }

    @Override
    public boolean setTextProtocol() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getModemDriver().write("AT+CMGF=1\r");
        this.getModemDriver().getResponse();
        if (this.getModemDriver().isOk()) {
            this.getModemDriver().write("AT^HSMSSS=0,0,6,0\r");
            this.getModemDriver().getResponse();
            return this.getModemDriver().isOk();
        }
        return false;
    }

    @Override
    public int getTextSplitNum(String text) {
        byte[] unicodeBytes = ATHandler_Huawei_MC323.ascii2UnicodeBytes(text, false);
        int nSplitNum = (unicodeBytes.length - 1) / 130 + 1;
        return nSplitNum;
    }

    private ArrayList<String> b(String text) {
        ArrayList<String> array;
        block3: {
            int nKey;
            int nLen;
            block4: {
                block2: {
                    array = new ArrayList<String>();
                    nLen = text.length();
                    if (nLen > (nKey = 70)) break block2;
                    array.add(text);
                    break block3;
                }
                if (nLen <= nKey) break block3;
                if (nLen > 585) break block4;
                nKey = 65;
                int nNum = nLen / nKey;
                for (int i2 = 0; i2 <= nNum; ++i2) {
                    int nBegin;
                    int nEnd = nBegin + ((nBegin = i2 * nKey) + nKey > nLen ? nLen % nKey : nKey);
                    String str = text.substring(nBegin, nEnd);
                    String strTemp = "(" + String.valueOf(i2) + "/" + String.valueOf(nNum) + ")";
                    strTemp = strTemp + str;
                    array.add(strTemp);
                }
                break block3;
            }
            if (nLen <= 585 || nLen > 6237) break block3;
            nKey = 63;
            int nNum = nLen / nKey;
            for (int i3 = 0; i3 <= nNum; ++i3) {
                int nBegin;
                int nEnd = nBegin + ((nBegin = i3 * nKey) + nKey > nLen ? nLen % nKey : nKey);
                String str = text.substring(nBegin, nEnd);
                String strTemp = "";
                strTemp = i3 < 10 ? "(0" + String.valueOf(i3) + "/" + String.valueOf(nNum) + ")" : "(" + String.valueOf(i3) + "/" + String.valueOf(nNum) + ")";
                strTemp = strTemp + str;
                array.add(strTemp);
            }
        }
        return array;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int sendMessage(int size, String pdu, String phone, String text) throws GatewayException, IOException, InterruptedException {
        this.threadWait(Service.getInstance().getSettings().AT_WAIT_CGMS);
        String response = "";
        int refNo = -1;
        boolean isContinue = true;
        Logger.getInstance().logDebug("wait...", null, this.getGateway().getGatewayId());
        byte[] unicodeBytes = ATHandler_Huawei_MC323.ascii2UnicodeBytes(text, false);
        for (int i2 = 0; i2 <= (unicodeBytes.length - 1) / 120; ++i2) {
            int length;
            int n2 = length = unicodeBytes.length < 130 * (i2 + 1) ? unicodeBytes.length - 130 * i2 : 130;
            if (length <= 0) continue;
            byte[] sendingBytes = new byte[length];
            try {
                System.arraycopy(unicodeBytes, i2 * 130, sendingBytes, 0, length);
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
            Logger.getInstance().logDebug(text + " : \u7684unicode bytes are: " + new String(unicodeBytes), null, this.getGateway().getGatewayId());
            Object object = this.a;
            synchronized (object) {
                this.getModemDriver().clearBuffer();
                if (unicodeBytes.length <= 140) {
                    this.getModemDriver().write("AT^HCMGS=\"_1_\",_2_\r".replaceAll("_1_", phone).replaceAll("_2_", "0"));
                    this.threadWait(200L);
                    Logger.getInstance().logDebug("\u5f00\u59cb\u53d1\u77ed\u4fe1:" + "AT^HCMGS=\"_1_\"\r".replaceAll("_1_", phone), null, this.getGateway().getGatewayId());
                    this.getModemDriver().write(unicodeBytes);
                    isContinue = false;
                } else {
                    int k2 = (unicodeBytes.length - 1) / 130 + 1;
                    String prefix = "(" + (i2 + 1) + "/" + k2 + ")";
                    byte[] prefixUnicodeBytes = ATHandler_Huawei_MC323.ascii2UnicodeBytes(prefix, false);
                    byte[] fullUnicodeBytes = new byte[prefixUnicodeBytes.length + sendingBytes.length];
                    System.arraycopy(prefixUnicodeBytes, 0, fullUnicodeBytes, 0, prefixUnicodeBytes.length);
                    System.arraycopy(sendingBytes, 0, fullUnicodeBytes, prefixUnicodeBytes.length, sendingBytes.length);
                    this.getModemDriver().write("AT^HCMGS=\"_1_\"\r".replaceAll("_1_", phone));
                    this.threadWait(200L);
                    Logger.getInstance().logDebug("\u5f00\u59cb\u53d1\u77ed\u4fe1:" + "AT^HCMGS=\"_1_\"\r".replaceAll("_1_", phone), null, this.getGateway().getGatewayId());
                    this.getModemDriver().write(fullUnicodeBytes);
                }
                Logger.getInstance().logDebug("\u77ed\u4fe1\u5185\u5bb9: " + text, null, this.getGateway().getGatewayId());
                byte[] b2 = new byte[]{0, 26};
                this.getModemDriver().write(b2);
                boolean flag = true;
                boolean second = false;
                this.threadWait(1000L);
                long startTime = System.currentTimeMillis();
                while (flag) {
                    if ((System.currentTimeMillis() - startTime) / 1000L >= 60L) {
                        refNo = -1;
                        break;
                    }
                    Logger.getInstance().logDebug("response \u5f00\u59cb\u54cd\u5e94...", null, this.getGateway().getGatewayId());
                    try {
                        if (second) {
                            response = this.getModemDriver().getResponseString();
                            System.out.println("\u53d1\u77ed\u4fe1\u54cd\u5e942: " + response);
                        } else {
                            this.threadWait(100L);
                            response = this.getModemDriver().getResponse();
                            System.out.println("\u53d1\u77ed\u4fe1\u54cd\u5e941: " + response);
                        }
                    }
                    catch (TimeoutException e3) {
                        e3.printStackTrace();
                    }
                    Logger.getInstance().logDebug("response \u5df2\u7ecf\u54cd\u5e94,\u8fd4\u56de\u7684\u54cd\u5e94: " + response, null, this.getGateway().getGatewayId());
                    if (response.indexOf("^HCMGSS:") == -1 && response.indexOf("^HCMGSF:") == -1) {
                        second = true;
                        continue;
                    }
                    String checkString = response.substring(0, response.length());
                    if (checkString.indexOf("^HCMGSS") != -1) {
                        StringBuilder tmp = new StringBuilder();
                        int n3 = response.indexOf(":");
                        while (!Character.isDigit(response.charAt(n3))) {
                            ++n3;
                        }
                        while (Character.isDigit(response.charAt(n3))) {
                            tmp.append(response.charAt(n3));
                            ++n3;
                        }
                        refNo = Integer.parseInt(tmp.toString());
                    } else {
                        refNo = -1;
                    }
                    Logger.getInstance().logDebug("\u8fd4\u56de\u54cd\u5e94: " + response, null, this.getGateway().getGatewayId());
                    break;
                }
            }
            if (!isContinue) break;
        }
        return refNo;
    }

    public static byte[] ascii2UnicodeBytes(String theString, boolean escapeSpace) {
        int len = theString.length();
        int buflen = len * 2;
        if (buflen < 0) {
            buflen = Integer.MAX_VALUE;
        }
        byte[] outBuffer = new byte[buflen];
        for (int i2 = 0; i2 < len; ++i2) {
            char aChar = theString.charAt(i2);
            outBuffer[2 * i2] = (byte)(aChar >> 8);
            outBuffer[2 * i2 + 1] = (byte)(aChar << 8 >> 8);
        }
        return outBuffer;
    }

    public static String unicode2Ascii(byte[] in) {
        char[] out = new char[in.length / 2];
        for (int i2 = 0; i2 < out.length; ++i2) {
            out[i2] = (char)(in[2 * i2] << 8 | in[2 * i2 + 1] & 0xFF);
        }
        return new String(out);
    }
}

