/*
 * Decompiled with CFR 0.152.
 */
package cn.sendsms.modem.athandler;

import cn.ajwcc.pduUtils.gsm3040.Pdu;
import cn.ajwcc.pduUtils.gsm3040.PduParser;
import cn.ajwcc.pduUtils.gsm3040.SmsDeliveryPdu;
import cn.sendsms.GatewayException;
import cn.sendsms.InboundMessage;
import cn.sendsms.Service;
import cn.sendsms.TimeoutException;
import cn.sendsms.modem.ModemGateway;
import cn.sendsms.modem.athandler.ATHandler;
import cn.sendsms.util.Logger;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.regex.Matcher;

public class ATHandler_Huawei_ME909
extends ATHandler {
    public ATHandler_Huawei_ME909(ModemGateway myGateway) {
        super(myGateway);
        this.setStorageLocations("SM");
    }

    @Override
    public void init() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getModemDriver().write("AT^CURC=0\r");
        this.getModemDriver().getResponse();
        this.getModemDriver().write("AT+CLIP=1\r");
        this.getModemDriver().getResponse();
    }

    @Override
    public void reset() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getModemDriver().clearBuffer();
        this.getModemDriver().write("AT^CURC=0\r");
        this.getModemDriver().getResponse();
    }

    @Override
    public int findMatchingTerminator(String response) {
        if (response.indexOf("OK") != -1) {
            return 0;
        }
        for (int i2 = 0; i2 < this.terminators.length; ++i2) {
            if (!response.matches(this.terminators[i2])) continue;
            return i2;
        }
        return -1;
    }

    @Override
    public String getCCID() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getModemDriver().write("AT^ICCID?\r");
        String response = this.getModemDriver().getResponse();
        return response;
    }

    @Override
    public String readTextMode() throws GatewayException, TimeoutException, IOException, InterruptedException {
        this.threadWait(2000L);
        this.getModemDriver().write("AT+CREG?\r");
        this.threadWait(Service.getInstance().getSettings().AT_WAIT);
        return this.getModemDriver().getResponse();
    }

    @Override
    public String listMessages(InboundMessage.MessageClasses messageClass) throws TimeoutException, GatewayException, IOException, InterruptedException {
        StringBuilder listMessage = new StringBuilder();
        this.getModemDriver().write("AT+CMGD=?\r");
        this.threadWait(Service.getInstance().getSettings().AT_WAIT);
        String indexstr = this.getModemDriver().getResponse();
        int start = indexstr.indexOf("(");
        int end = indexstr.indexOf(")");
        String parseStr = "";
        if (start + 1 < end) {
            String[] indexs = indexstr.substring(start + 1, end).split(",");
            PduParser parser = new PduParser();
            long tmp1 = System.currentTimeMillis();
            for (int iindex = 0; indexs != null && iindex < indexs.length; ++iindex) {
                String index = indexs[iindex];
                try {
                    int endIndex;
                    this.getModemDriver().write("AT+CMGR=" + index + "\r");
                    this.threadWait(Service.getInstance().getSettings().AT_WAIT);
                    indexstr = this.getModemDriver().getResponse();
                    indexstr = indexstr.substring(indexstr.indexOf("+CMGR"));
                    Matcher matcher = this.delLineSeparatorAfterCMGR.matcher(indexstr);
                    if (matcher.find()) {
                        indexstr = indexstr.replace(matcher.group(), matcher.group(1) + "\r");
                    }
                    String pduString = indexstr.trim();
                    Logger.getInstance().logInfo("\u6536\u5230\u77ed\u4fe1:" + pduString, null, null);
                    int startIndex = pduString.indexOf("\n");
                    if (startIndex == -1) {
                        startIndex = pduString.indexOf("\r");
                    }
                    if ((endIndex = pduString.lastIndexOf("\nOK")) == -1) {
                        endIndex = pduString.lastIndexOf("\rOK");
                    }
                    parseStr = pduString = pduString.substring(startIndex + 1, endIndex);
                    Pdu pdu = this.checkNullPduParse(pduString);
                    if (null != pdu) {
                        String sendDate = "";
                        if (pdu instanceof SmsDeliveryPdu) {
                            sendDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(((SmsDeliveryPdu)pdu).getTimestamp());
                        }
                        listMessage.append(indexstr.replace("CMGR:", "CMGL: " + index + ",").replaceFirst("\n*OK.*", ""));
                    }
                    this.getModemDriver().write("AT+CMGD=" + index + "\r");
                    this.threadWait(Service.getInstance().getSettings().AT_WAIT);
                    this.getModemDriver().getResponse();
                    if (this.getModemDriver().isOk()) continue;
                    throw new RuntimeException("\u5220\u9664\u77ed\u4fe1 " + indexstr + " : \u4f4d\u7f6e" + index + "\u51fa\u9519");
                }
                catch (Exception e2) {
                    Logger.getInstance().logError("\u8bfb\u53d6" + index + "\u4f4d\u7f6e\u7684\u77ed\u4fe1" + parseStr + "\u65f6\u51fa\u9519", e2, this.getGateway().getGatewayId());
                }
            }
            long tmp2 = System.currentTimeMillis();
            System.out.println("\u65f6\u95f4\u5386\u65f6" + (tmp2 - tmp1));
        }
        listMessage.append("\nOK");
        return listMessage.toString();
    }

    @Override
    public boolean deleteMessage(int memIndex, String memLocation) throws TimeoutException, GatewayException, IOException, InterruptedException {
        return true;
    }
}

