/*
 * Decompiled with CFR 0.152.
 */
package cn.sendsms.otherModem.modem;

import cn.sendsms.Message;
import cn.sendsms.OutboundMessage;
import cn.sendsms.jdsmsserver.JDSMSServer;
import cn.sendsms.otherModem.bean.BigDipperBean;
import cn.sendsms.otherModem.bigdipper.BDDeviceInfoGetter;
import cn.sendsms.otherModem.bigdipper.BDMessageHolder;
import cn.sendsms.otherModem.common.Utils;
import cn.sendsms.otherModem.driver.ModemDriver;
import cn.sendsms.otherModem.driver.bigdipperDriver.BDDriver;
import cn.sendsms.otherModem.modem.Modem;
import cn.sendsms.otherModem.thread.WatchDog;
import jssc.SerialPort;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.log4j.Logger;

public class BDModem
extends Modem {
    public static final Logger log = Logger.getRootLogger();
    private static int MESSAGE_TEXT_LENGTH = 34;
    public static BDDeviceInfoGetter bdDeviceInfoGetter = BDDeviceInfoGetter.getInstance();
    public static BDMessageHolder bdMessageHolder = BDMessageHolder.getInstance();

    private BDModem() {
    }

    public static BDModem getInstance() {
        return a.a;
    }

    @Override
    public void sendMessage(OutboundMessage msg) {
        PropertiesConfiguration props = JDSMSServer.getInstance().getProperties();
        String usingPort = "";
        usingPort = props.getString("settings.send_mode", "sync").equalsIgnoreCase("sync") ? BDDeviceInfoGetter.getInstance().getPortIDByLoop(msg) : msg.getUsingPortID();
        BigDipperBean device = bdDeviceInfoGetter.findDeviceByPortID(usingPort);
        if (device == null) {
            return;
        }
        SerialPort serialport = bdDeviceInfoGetter.getSerialPort(usingPort);
        if (bdDeviceInfoGetter.checkStopBD(usingPort)) {
            return;
        }
        if ("2".equals(device.getUsingStatus())) {
            return;
        }
        if (!bdDeviceInfoGetter.checkAuthorizeInfo(usingPort, msg)) {
            return;
        }
        try {
            if ("1".equals(device.getUsingStatus()) && ModemDriver.readPortInputBufferUsedSize(serialport) == -1) {
                log.error((Object)("\u8bbe\u5907" + device.getGatewayID() + "\u6389\u7ebf\u4e86\uff01"));
                device.setUsingStatus("2");
                WatchDog.getInstance().interrupt();
                return;
            }
        }
        catch (Exception e2) {
            log.error((Object)("\u8bbe\u5907" + device.getGatewayID() + "\u901a\u4fe1\u5f02\u5e38\uff01"));
            return;
        }
        msg.setGatewayId(device.getGatewayID());
        int msgID = msg.getMessageID();
        boolean sendSucess = this.a(usingPort, msg, msgID);
        if (sendSucess) {
            log.info((Object)("\u4fe1\u606f\u3010" + msg.getText() + "\u3011\u53d1\u9001\u6210\u529f\u3002"));
            msg.setMessageStatus(OutboundMessage.MessageStatuses.SENT);
            bdDeviceInfoGetter.updateAvaliableNum(usingPort);
            return;
        }
        log.info((Object)("\u4fe1\u606f\u3010" + msg.getText() + "\u3011\u53d1\u9001\u5931\u8d25\u3002"));
        msg.setMessageStatus(OutboundMessage.MessageStatuses.FAILED);
    }

    private boolean a(String usingPort, OutboundMessage msg, int msgID) {
        PropertiesConfiguration props = JDSMSServer.getInstance().getProperties();
        int resendTimes = props.getInt("settings.resend_times", 0);
        boolean sendSucess = false;
        if (resendTimes > 0) {
            for (int i2 = 0; i2 <= resendTimes; ++i2) {
                if (!this.b(usingPort, msg, msgID)) continue;
                sendSucess = true;
            }
        } else if (this.b(usingPort, msg, msgID)) {
            sendSucess = true;
        }
        return sendSucess;
    }

    private boolean b(String usingPort, OutboundMessage msg, int msgID) {
        String text = msg.getText();
        String recipient = msg.getRecipient().toUpperCase();
        int textLength = text.length();
        this.a(msg.getEncoding());
        String encodingType = bdMessageHolder.getCodingType(msg.getEncoding());
        int splitNumber = textLength / MESSAGE_TEXT_LENGTH;
        if (textLength % MESSAGE_TEXT_LENGTH != 0) {
            ++splitNumber;
        }
        boolean sendSucess = false;
        if (textLength <= MESSAGE_TEXT_LENGTH) {
            String messageIdentificationStr = this.getMessageIdentificationStr(msgID, 1, 1, text);
            sendSucess = BDDriver.getInstance().sendMessage(usingPort, recipient, messageIdentificationStr + text, msg.getEncoding());
        } else {
            int serialNumber = 0;
            for (int startIndex = 0; startIndex < text.length(); startIndex += MESSAGE_TEXT_LENGTH) {
                String messageIdentificationStr;
                ++serialNumber;
                String tempText = "";
                if (startIndex + MESSAGE_TEXT_LENGTH < textLength) {
                    tempText = text.substring(startIndex, startIndex + MESSAGE_TEXT_LENGTH);
                    messageIdentificationStr = this.getMessageIdentificationStr(msgID, splitNumber, serialNumber, tempText);
                    sendSucess = BDDriver.getInstance().sendMessage(usingPort, recipient, messageIdentificationStr + tempText, msg.getEncoding());
                    if (!sendSucess) {
                        break;
                    }
                } else {
                    tempText = text.substring(startIndex, text.length());
                    messageIdentificationStr = this.getMessageIdentificationStr(msgID, splitNumber, serialNumber, tempText);
                    sendSucess = BDDriver.getInstance().sendMessage(usingPort, recipient, messageIdentificationStr + tempText, msg.getEncoding());
                    if (!sendSucess) break;
                }
                if (!"0".equals(encodingType)) continue;
                log.info((Object)("\u6c49\u5b57\u7f16\u7801\u4fe1\u606f\u957f\u5ea6\u8fc7\u957f\uff0c\u53ea\u53d1\u9001\u524d" + MESSAGE_TEXT_LENGTH + "\u4e2a\u5b57\u7b26"));
                break;
            }
        }
        return sendSucess;
    }

    public String getMessageIdentificationStr(int messageID, int splitNumber, int serialNumber, String text) {
        String messageIDStr = Integer.toHexString(messageID);
        messageIDStr = Utils.complementStrWithZero(messageIDStr, 8);
        String splitNumberStr = Integer.toHexString(splitNumber);
        splitNumberStr = Utils.complementStrWithZero(splitNumberStr, 2);
        String serialNumberStr = Integer.toHexString(serialNumber);
        serialNumberStr = Utils.complementStrWithZero(serialNumberStr, 2);
        String textLengthStr = Integer.toHexString(Utils.getByteArray(text, "GBK").length);
        textLengthStr = Utils.complementStrWithZero(textLengthStr, 3);
        return (messageIDStr + splitNumberStr + serialNumberStr + textLengthStr).toUpperCase();
    }

    private void a(Message.MessageEncodings encoding) {
        switch (encoding) {
            case ENC7BIT: {
                MESSAGE_TEXT_LENGTH = 128;
                break;
            }
            case ENC8BIT: {
                MESSAGE_TEXT_LENGTH = 128;
                break;
            }
            case ENCUCS2: {
                MESSAGE_TEXT_LENGTH = 26;
                break;
            }
            case SC: {
                MESSAGE_TEXT_LENGTH = 31;
                break;
            }
            default: {
                MESSAGE_TEXT_LENGTH = 26;
            }
        }
    }

    private static class a {
        private static BDModem a = new BDModem();

        private a() {
        }
    }
}

