/*
 * Decompiled with CFR 0.152.
 */
package cn.sendsms.util;

import cn.sendsms.util.SysConts;
import cn.sendsms.util.UploadMoreException;
import cn.sendsms.util.Util;
import cn.sendsms.util.a;
import cn.sendsms.util.b;
import cn.sendsms.util.c;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;

public class MultipartRequest {
    private static final int DEFAULT_MAX_POST_SIZE = 0x100000;
    private static final String NO_FILE = "unknown";
    private HttpServletRequest a;
    private File b;
    private int c;
    private Hashtable d = new Hashtable();
    private Hashtable e = new Hashtable();

    public MultipartRequest(HttpServletRequest request, String saveDirectory) throws Exception {
        this(request, saveDirectory, 0x100000);
    }

    public MultipartRequest(HttpServletRequest request, String saveDirectory, int maxPostSize) throws Exception {
        if (request == null) {
            throw new IllegalArgumentException("request cannot be null");
        }
        if (saveDirectory == null) {
            throw new IllegalArgumentException("saveDirectory cannot be null");
        }
        this.a = request;
        this.b = new File(saveDirectory);
        this.c = maxPostSize;
        if (!this.b.isDirectory()) {
            throw new IllegalArgumentException("Not a directory: " + saveDirectory);
        }
        if (!this.b.canWrite()) {
            throw new IllegalArgumentException("Not writable: " + saveDirectory);
        }
        this.readRequest();
    }

    public MultipartRequest(ServletRequest request, String saveDirectory) throws Exception {
        this((HttpServletRequest)request, saveDirectory);
    }

    public MultipartRequest(ServletRequest request, String saveDirectory, int maxPostSize) throws Exception {
        this((HttpServletRequest)request, saveDirectory, maxPostSize);
    }

    public Enumeration getParameterNames() {
        return this.d.keys();
    }

    public Enumeration getFileNames() {
        return this.e.keys();
    }

    public int getFileNum() {
        return this.e.size();
    }

    public String getParameter(String name) {
        try {
            Vector values = (Vector)this.d.get(name);
            if (values == null || values.size() == 0) {
                return null;
            }
            String value = (String)values.elementAt(values.size() - 1);
            if (value == null) {
                value = (String)values.elementAt(0);
            }
            return value;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String[] getParameterValues(String name) {
        try {
            Vector values = (Vector)this.d.get(name);
            if (values == null || values.size() == 0) {
                return null;
            }
            Object[] valuesArray = new String[values.size()];
            values.copyInto(valuesArray);
            return valuesArray;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getFilesystemName(String name) {
        try {
            c file = (c)this.e.get(name);
            return file.b();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getOrgFileFullPathName(String name) {
        try {
            c file = (c)this.e.get(name);
            return file.d();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getContentType(String name) {
        try {
            c file = (c)this.e.get(name);
            return file.a();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public File getFile(String name) {
        try {
            c file = (c)this.e.get(name);
            return file.e();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getFilename(String name) {
        try {
            c file = (c)this.e.get(name);
            return file.b();
        }
        catch (Exception exception) {
            return "";
        }
    }

    protected void readRequest() throws Exception {
        int length = this.a.getContentLength();
        if (length > this.c && this.c != -1) {
            throw new UploadMoreException("Posted content length of " + length + " exceeds limit of " + this.c);
        }
        String type = null;
        String type1 = this.a.getHeader("Content-Type");
        String type2 = this.a.getContentType();
        if (type1 == null && type2 != null) {
            type = type2;
        } else if (type2 == null && type1 != null) {
            type = type1;
        } else if (type1 != null && type2 != null) {
            String string = type = type1.length() > type2.length() ? type1 : type2;
        }
        if (type == null || !type.toLowerCase().startsWith("multipart/form-data")) {
            throw new IOException("Posted content type isn't multipart/form-data");
        }
        String boundary = this.a(type);
        if (boundary == null) {
            throw new IOException("Separation boundary was not specified");
        }
        b in = new b(this.a.getInputStream(), length);
        String line = in.a();
        if (line == null) {
            throw new IOException("Corrupt form data: premature ending");
        }
        if (!line.startsWith(boundary)) {
            throw new IOException("Corrupt form data: no leading boundary");
        }
        boolean done = false;
        while (!done) {
            done = this.readNextPart(in, boundary);
        }
    }

    protected boolean readNextPart(b in, String boundary) throws IOException {
        String line = in.a();
        if (line == null) {
            return true;
        }
        if (line.length() == 0) {
            return true;
        }
        String[] dispInfo = this.b(line);
        String disposition = dispInfo[0];
        String name = dispInfo[1];
        String filename = dispInfo[2];
        String orgfilename = dispInfo[3];
        line = in.a();
        if (line == null) {
            return true;
        }
        String contentType = this.c(line);
        if (contentType != null) {
            line = in.a();
            if (line == null || line.length() > 0) {
                throw new IOException("Malformed line after content type: " + line);
            }
        } else {
            contentType = "application/octet-stream";
        }
        if (filename == null) {
            Vector<String> existingValues;
            String value = this.readParameter(in, boundary);
            if (value.equals("")) {
                value = null;
            }
            if ((existingValues = (Vector<String>)this.d.get(name)) == null) {
                existingValues = new Vector<String>();
                this.d.put(name, existingValues);
            }
            existingValues.addElement(value);
        } else {
            String snofilename = Util.getSNO();
            this.readAndSaveFile(in, boundary, filename, contentType, snofilename);
            if (filename.equals(NO_FILE)) {
                this.e.put(name, new c(null, null, null, null, null));
            } else {
                this.e.put(name, new c(this.b.toString(), filename, contentType, orgfilename, snofilename));
            }
        }
        return false;
    }

    protected String readParameter(b in, String boundary) throws IOException {
        String line;
        StringBuffer sbuf = new StringBuffer();
        while ((line = in.a()) != null && !line.startsWith(boundary)) {
            sbuf.append(line + "\r\n");
        }
        if (sbuf.length() == 0) {
            return null;
        }
        sbuf.setLength(sbuf.length() - 2);
        return sbuf.toString();
    }

    protected void readAndSaveFile(b in, String boundary, String filename, String contentType, String snofilename) throws IOException {
        String line;
        int result;
        OutputStream out = null;
        FileOutputStream fos = null;
        File f2 = null;
        if (filename.equals(NO_FILE)) {
            out = new ByteArrayOutputStream();
        } else if (contentType.equals("application/x-macbinary")) {
            f2 = new File(this.b + File.separator + snofilename);
            fos = new FileOutputStream(f2);
            out = new a(new BufferedOutputStream(fos, 8192));
        } else {
            f2 = new File(this.b + File.separator + snofilename);
            fos = new FileOutputStream(f2);
            out = new BufferedOutputStream(fos, 8192);
        }
        byte[] bbuf = new byte[102400];
        boolean rnflag = false;
        int iLen = 0;
        while (!((result = in.a(bbuf, 0, bbuf.length)) == -1 || result > 2 && bbuf[0] == 45 && bbuf[1] == 45 && (line = new String(bbuf, 0, result, SysConts.New_InCharSet)).startsWith(boundary))) {
            if (rnflag) {
                out.write(13);
                out.write(10);
                rnflag = false;
            }
            iLen += result;
            if (result >= 2 && bbuf[result - 2] == 13 && bbuf[result - 1] == 10) {
                out.write(bbuf, 0, result - 2);
                rnflag = true;
                continue;
            }
            out.write(bbuf, 0, result);
        }
        out.flush();
        out.close();
        try {
            if (fos == null) {
                return;
            }
            fos.close();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private String a(String line) {
        int index = line.lastIndexOf("boundary=");
        if (index == -1) {
            return null;
        }
        String boundary = line.substring(index + 9);
        boundary = "--" + boundary;
        return boundary;
    }

    private String[] b(String line) throws IOException {
        String[] retval = new String[4];
        String origline = line;
        line = origline.toLowerCase();
        int start = line.indexOf("content-disposition: ");
        int end = line.indexOf(";");
        if (start == -1 || end == -1) {
            throw new IOException("Content disposition corrupt: " + origline);
        }
        String disposition = line.substring(start + 21, end);
        if (!disposition.equals("form-data")) {
            throw new IOException("Invalid content disposition: " + disposition);
        }
        start = line.indexOf("name=\"", end);
        end = line.indexOf("\"", start + 7);
        if (start == -1 || end == -1) {
            throw new IOException("Content disposition corrupt: " + origline);
        }
        String name = origline.substring(start + 6, end);
        String filename = null;
        String orgfilename = null;
        start = line.indexOf("filename=\"", end + 2);
        end = line.indexOf("\"", start + 10);
        if (start != -1 && end != -1) {
            orgfilename = filename = origline.substring(start + 10, end);
            int slash = Math.max(filename.lastIndexOf(47), filename.lastIndexOf(92));
            if (slash > -1) {
                filename = filename.substring(slash + 1);
            }
            if (filename.equals("")) {
                filename = NO_FILE;
            }
        }
        retval[0] = disposition;
        retval[1] = name;
        retval[2] = filename;
        retval[3] = orgfilename;
        return retval;
    }

    private String c(String line) throws IOException {
        String contentType = null;
        String origline = line;
        if ((line = origline.toLowerCase()).startsWith("content-type")) {
            int start = line.indexOf(" ");
            if (start == -1) {
                throw new IOException("Content type corrupt: " + origline);
            }
            contentType = line.substring(start + 1);
        } else if (line.length() != 0) {
            throw new IOException("Malformed line after disposition: " + origline);
        }
        return contentType;
    }
}

