/*
 * Decompiled with CFR 0.152.
 */
package cn.ajwcc.pduUtils.gsm3040;

import cn.ajwcc.pduUtils.gsm3040.Pdu;
import cn.ajwcc.pduUtils.gsm3040.PduUtils;
import java.util.Calendar;
import java.util.Date;

public class SmsDeliveryPdu
extends Pdu {
    private Calendar a;

    SmsDeliveryPdu() {
    }

    public void setTimestamp(Calendar timestamp) {
        this.a = timestamp;
    }

    public Date getTimestamp() {
        return this.a.getTime();
    }

    public Calendar getTimestampAsCalendar() {
        return this.a;
    }

    public void setTpMms(int value) {
        this.checkTpMti(new int[]{0, 2});
        this.setFirstOctetField(251, value, new int[]{4, 0});
    }

    public boolean hasTpMms() {
        this.checkTpMti(new int[]{0, 2});
        return this.getFirstOctetField(251) == 4;
    }

    public void setTpSri(int value) {
        this.setFirstOctetField(223, value, new int[]{0, 32});
    }

    public boolean hasTpSri() {
        return this.getFirstOctetField(223) == 32;
    }

    @Override
    protected String pduSubclassInfo() {
        StringBuffer sb = new StringBuffer();
        if (this.getAddress() != null) {
            sb.append("Originator Address: [Length: " + this.getAddress().length() + " (" + PduUtils.byteToPdu((byte)this.getAddress().length()) + ")");
            sb.append(", Type: " + PduUtils.byteToPdu(this.getAddressType()) + " (" + PduUtils.byteToBits((byte)this.getAddressType()) + ")");
            sb.append(", Address: " + this.getAddress());
            sb.append("]");
        } else {
            sb.append("Originator Address: [Length: 0");
            sb.append(", Type: " + PduUtils.byteToPdu(this.getAddressType()) + " (" + PduUtils.byteToBits((byte)this.getAddressType()) + ")");
            sb.append("]");
        }
        sb.append("\n");
        sb.append("TP-PID: " + PduUtils.byteToPdu(this.getProtocolIdentifier()) + " (" + PduUtils.byteToBits((byte)this.getProtocolIdentifier()) + ")");
        sb.append("\n");
        sb.append("TP-DCS: " + PduUtils.byteToPdu(this.getDataCodingScheme()) + " (" + PduUtils.decodeDataCodingScheme(this) + ") (" + PduUtils.byteToBits((byte)this.getDataCodingScheme()) + ")");
        sb.append("\n");
        sb.append("TP-SCTS: " + this.formatTimestamp(this.getTimestampAsCalendar()));
        sb.append("\n");
        return sb.toString();
    }
}

