/*
 * Decompiled with CFR 0.152.
 */
package cn.ajwcc.pduUtils.gsm3040.ie;

import cn.ajwcc.pduUtils.gsm3040.ie.ConcatInformationElement;
import cn.ajwcc.pduUtils.gsm3040.ie.InformationElement;
import cn.ajwcc.pduUtils.gsm3040.ie.PortInformationElement;

public class InformationElementFactory {
    public static InformationElement createInformationElement(int id, byte[] data) {
        byte iei = (byte)(id & 0xFF);
        switch (iei) {
            case 0: 
            case 8: {
                return new ConcatInformationElement(iei, data);
            }
            case 5: {
                return new PortInformationElement(iei, data);
            }
        }
        return new InformationElement(iei, data);
    }

    public static ConcatInformationElement generateConcatInfo(int mpRefNo, int partNo) {
        ConcatInformationElement concatInfo = new ConcatInformationElement(ConcatInformationElement.getDefaultConcatType(), mpRefNo, 1, partNo);
        return concatInfo;
    }

    public static ConcatInformationElement generateConcatInfo(int identifier, int mpRefNo, int partNo) {
        ConcatInformationElement concatInfo = new ConcatInformationElement(identifier, mpRefNo, 1, partNo);
        return concatInfo;
    }

    public static PortInformationElement generatePortInfo(int destPort, int srcPort) {
        PortInformationElement portInfo = new PortInformationElement(5, destPort, srcPort);
        return portInfo;
    }
}

