/*
 * Decompiled with CFR 0.152.
 */
package cn.sendsms.jdsmsserver.web;

import java.io.UnsupportedEncodingException;

public class CharacterSetToolkit {
    private static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private static char toHex(int nibble) {
        return hexDigit[nibble & 0xF];
    }

    public static String ascii2Unicode(String theString, boolean escapeSpace) {
        int len = theString.length();
        int buflen = len * 2;
        if (buflen < 0) {
            buflen = Integer.MAX_VALUE;
        }
        StringBuffer outBuffer = new StringBuffer(buflen);
        block8: for (int i2 = 0; i2 < len; ++i2) {
            char aChar = theString.charAt(i2);
            if (aChar > '=' && aChar < '\u007f') {
                if (aChar == '\\') {
                    outBuffer.append('\\').append('\\');
                    continue;
                }
                outBuffer.append(aChar);
                continue;
            }
            switch (aChar) {
                case ' ': {
                    if (i2 == 0 || escapeSpace) {
                        outBuffer.append('\\');
                    }
                    outBuffer.append(' ');
                    continue block8;
                }
                case '\t': {
                    outBuffer.append('\\').append('t');
                    continue block8;
                }
                case '\n': {
                    outBuffer.append('\\').append('n');
                    continue block8;
                }
                case '\r': {
                    outBuffer.append('\\').append('r');
                    continue block8;
                }
                case '\f': {
                    outBuffer.append('\\').append('f');
                    continue block8;
                }
                case '!': 
                case '#': 
                case ':': 
                case '=': {
                    outBuffer.append('\\').append(aChar);
                    continue block8;
                }
                default: {
                    if (aChar < ' ' || aChar > '~') {
                        outBuffer.append(CharacterSetToolkit.toHex(aChar >> 12 & 0xF));
                        outBuffer.append(CharacterSetToolkit.toHex(aChar >> 8 & 0xF));
                        outBuffer.append(CharacterSetToolkit.toHex(aChar >> 4 & 0xF));
                        outBuffer.append(CharacterSetToolkit.toHex(aChar & 0xF));
                        continue block8;
                    }
                    outBuffer.append(aChar);
                }
            }
        }
        return outBuffer.toString();
    }

    public static byte[] ascii2UnicodeBytes(String theString, boolean escapeSpace) {
        int len = theString.length();
        int buflen = len * 2;
        if (buflen < 0) {
            buflen = Integer.MAX_VALUE;
        }
        byte[] outBuffer = new byte[buflen];
        for (int i2 = 0; i2 < len; ++i2) {
            char aChar = theString.charAt(i2);
            outBuffer[2 * i2] = (byte)(aChar >> 8);
            outBuffer[2 * i2 + 1] = (byte)(aChar << 8 >> 8);
        }
        return outBuffer;
    }

    public static String unicode2Ascii(char[] in, int off, int len, char[] convtBuf) {
        if (convtBuf.length < len) {
            int newLen = len;
            if (newLen < 0) {
                newLen = Integer.MAX_VALUE;
            }
            convtBuf = new char[newLen];
        }
        char[] out = convtBuf;
        int outLen = 0;
        int end = off + len;
        block8: while (off < end) {
            char aChar;
            if ((aChar = in[off++]) == '\\') {
                if ((aChar = in[off++]) == 'u') {
                    int value = 0;
                    block9: for (int i2 = 0; i2 < 4; ++i2) {
                        aChar = in[off++];
                        switch (aChar) {
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': {
                                value = (value << 4) + aChar - 48;
                                continue block9;
                            }
                            case 'a': 
                            case 'b': 
                            case 'c': 
                            case 'd': 
                            case 'e': 
                            case 'f': {
                                value = (value << 4) + 10 + aChar - 97;
                                continue block9;
                            }
                            case 'A': 
                            case 'B': 
                            case 'C': 
                            case 'D': 
                            case 'E': 
                            case 'F': {
                                value = (value << 4) + 10 + aChar - 65;
                                continue block9;
                            }
                            default: {
                                System.out.println(off);
                                throw new IllegalArgumentException("Malformed   \\uxxxx   encoding.");
                            }
                        }
                    }
                    out[outLen++] = (char)value;
                    continue;
                }
                switch (aChar) {
                    case 'f': 
                    case 'n': 
                    case 'r': 
                    case 't': {
                        out[outLen++] = 92;
                        out[outLen++] = aChar;
                        continue block8;
                    }
                }
                out[outLen++] = aChar;
                continue;
            }
            out[outLen++] = aChar;
        }
        return new String(out, 0, outLen);
    }

    public static String unicode2Ascii(byte[] in) {
        char[] out = new char[in.length / 2];
        for (int i2 = 0; i2 < out.length; ++i2) {
            out[i2] = (char)(in[2 * i2] << 8 | in[2 * i2 + 1] & 0xFF);
        }
        return new String(out);
    }

    public static String unicode2Ascii(char[] in) {
        char[] out = new char[in.length / 2];
        for (int i2 = 0; i2 < out.length; ++i2) {
            out[i2] = (char)(in[2 * i2] << 8 | in[2 * i2 + 1] & 0xFF);
        }
        return new String(out);
    }

    public static void main(String[] args) throws UnsupportedEncodingException {
        byte[] a2 = CharacterSetToolkit.ascii2UnicodeBytes("<\u91d1\u7b1b\u77ed\u4fe1\u670d\u52a1\u5668V3.4\u6b22\u8fce\u60a8\u4f7f\u7528 www.sendsms.cn>\u5272\u308a\u5f53\u3066\u3089\u308c\u306a\u3044\u3068\u3044\u3046\u306e\u304c\u554f\u984c\u3067\u3059\u3002\u3053\u308c\u3092\u89e3\u6c7a\u3057\u305f\u3044\u3067\u3059\u3002\u307e\u305f\u3001\u5171\u901a", false);
        System.out.println("\u957f\u5ea61\uff1a" + "003C91D17B1B77ED4FE1670D52A1566800560033002E00346B228FCE60A84F7F75280020007700770077002E00730065006E00640073006D0073002E0063006E003E5272308A5F5330663089308C306A3044306830443046306E304C554F984C3067305930023053308C309289E36C7A3057305F3044306730593002307E305F30015171901A".length());
        System.out.println("\u957f\u5ea6\uff1a" + a2.length);
        for (byte b2 : a2) {
            System.out.println(b2);
        }
    }
}

