/*
 * Decompiled with CFR 0.152.
 */
package cn.sendsms.jdsmsserver.web;

import cn.sendsms.jdsmsserver.interfaces.ConnectionPool;
import cn.sendsms.jdsmsserver.web.Condition;
import cn.sendsms.jdsmsserver.web.DbHelper;
import cn.sendsms.jdsmsserver.web.InMessage;
import cn.sendsms.jdsmsserver.web.OutMessage;
import cn.sendsms.jdsmsserver.web.Page;
import cn.sendsms.jdsmsserver.web.Record;
import cn.sendsms.jdsmsserver.web.User;
import cn.sendsms.util.UserAddrBook;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.dbutils.DbUtils;

public class DbHelperForMYSQL8
extends DbHelper {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean modifySendTable(String defaultValue) {
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = ConnectionPool.getInstance().getConnection();
            conn.setAutoCommit(false);
            String sql = "alter table %s alter gateway_id set default '" + defaultValue + "'";
            sql = String.format(sql, this.getProperty("tables.sms_out"));
            pstmt = conn.prepareStatement(sql);
            pstmt.executeUpdate();
            DbUtils.close((Statement)pstmt);
        }
        catch (Exception e2) {
            boolean bl = false;
            return bl;
        }
        finally {
            DbUtils.closeQuietly((Connection)conn);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Page getUserList(int pageIndex) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException, IOException {
        Page page = new Page();
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            conn = ConnectionPool.getInstance().getConnection();
            stmt = conn.createStatement();
            String sql = "select * from " + this.getProperty("tables.sms_user") + " where user_id <> 'admin' order by user_id limit %begin% , %size%";
            page.setPageIndex(pageIndex);
            sql = sql.replaceAll("%begin%", "" + (page.getPageIndex() - 1) * page.getPageSize4User());
            sql = sql.replaceAll("%size%", "" + page.getPageSize4User());
            rs = stmt.executeQuery(sql);
            ArrayList list = page.getData();
            while (rs.next()) {
                User user = new User();
                user.setUserId(rs.getString("user_id"));
                user.setPassword(rs.getString("password"));
                user.setUserDesc(rs.getString("user_desc"));
                user.setSurplusNumber(rs.getInt("surplus_number"));
                user.setFlag(rs.getInt("flag"));
                list.add(user);
            }
            String sql1 = "select count(1) as toatlnum from " + this.getProperty("tables.sms_user") + " where user_id <> 'admin'";
            rs = stmt.executeQuery(sql1);
            if (rs.next()) {
                page.setTotalNum(rs.getLong(1));
                if (page.getTotalNum() % (long)page.getPageSize4User() == 0L) {
                    page.setPageNum((int)(page.getTotalNum() / (long)page.getPageSize4User()));
                } else {
                    page.setPageNum((int)(page.getTotalNum() / (long)page.getPageSize4User() + 1L));
                }
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
        return page;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Page getAddRecordList(String userId, int pageIndex) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException, IOException {
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        Page page = new Page();
        try {
            conn = ConnectionPool.getInstance().getConnection();
            stmt = conn.createStatement();
            String sql = "";
            sql = userId == null ? "select * from " + this.getProperty("tables.sms_record") + "  order by add_time desc limit %begin% , %size%" : "select * from " + this.getProperty("tables.sms_record") + " where user_id ='" + userId + "' order by add_time desc limit %begin% , %size%";
            page.setPageIndex(pageIndex);
            sql = sql.replaceAll("%begin%", "" + (page.getPageIndex() - 1) * page.getPageSize4User());
            sql = sql.replaceAll("%size%", "" + page.getPageSize4User());
            rs = stmt.executeQuery(sql);
            ArrayList list = page.getData();
            while (rs.next()) {
                Record record = new Record();
                record.setRecordId(rs.getString("record_id"));
                record.setAddTime(this.DateFormat(rs.getTimestamp("add_time")));
                record.setUserId(rs.getString("user_id"));
                record.setAddNumber(rs.getInt("add_number"));
                list.add(record);
            }
            String sql1 = "";
            sql1 = userId == null ? "select count(1) as toatlnum from " + this.getProperty("tables.sms_record") : "select count(1) as toatlnum from " + this.getProperty("tables.sms_record") + " where user_id='" + userId + "'";
            rs = stmt.executeQuery(sql1);
            if (rs.next()) {
                page.setTotalNum(rs.getLong(1));
                if (page.getTotalNum() % (long)page.getPageSize4User() == 0L) {
                    page.setPageNum((int)(page.getTotalNum() / (long)page.getPageSize4User()));
                } else {
                    page.setPageNum((int)(page.getTotalNum() / (long)page.getPageSize4User() + 1L));
                }
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
        return page;
    }

    public DbHelperForMYSQL8(PropertiesConfiguration props, String dbid) {
        this.props = props;
        this.dbid = dbid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Page waitForSendMsgList(int pageIndex, User user) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException, IOException {
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        Page page = new Page();
        try {
            conn = ConnectionPool.getInstance().getConnection();
            stmt = conn.createStatement();
            String sql = "select * from " + this.getProperty("tables.sms_out") + " where status in ('U','Q','Z') order by create_date,priority desc limit %begin% , %size%";
            if (!"admin".equals(user.getUserId())) {
                sql = "select * from " + this.getProperty("tables.sms_out") + " where status in ('U','Q','Z') and user_id='" + user.getUserId() + "' order by create_date,priority desc limit %begin% , %size%";
            }
            page.setPageIndex(pageIndex);
            sql = sql.replaceAll("%begin%", "" + (page.getPageIndex() - 1) * page.getPageSize());
            sql = sql.replaceAll("%size%", "" + page.getPageSize());
            rs = stmt.executeQuery(sql);
            ArrayList list = page.getData();
            UserAddrBook uab = user.getAddrBook();
            while (rs.next()) {
                OutMessage msg = new OutMessage();
                msg.setId(rs.getLong("id"));
                msg.setContent(rs.getString("text"));
                msg.setCreateTime(this.DateFormat(rs.getTimestamp("create_date")));
                msg.setGateway_id(rs.getString("gateway_id"));
                String name = rs.getString("recipient");
                name = uab.findAddrName(name, uab);
                msg.setName(name);
                msg.setRecipient(rs.getString("recipient"));
                msg.setStatus((char)rs.getCharacterStream("status").read());
                msg.setType((char)rs.getCharacterStream("type").read());
                msg.setWap_url(rs.getString("wap_url"));
                list.add(msg);
            }
            String sql1 = "select count(1) as toatlnum from " + this.getProperty("tables.sms_out") + " where status in ('U','Q','Z')";
            if (!"admin".equals(user.getUserId())) {
                sql1 = "select count(1) as toatlnum from " + this.getProperty("tables.sms_out") + " where status in ('U','Q','Z') and user_id='" + user.getUserId() + "'";
            }
            if ((rs = stmt.executeQuery(sql1)).next()) {
                page.setTotalNum(rs.getLong(1));
                if (page.getTotalNum() % (long)page.getPageSize() == 0L) {
                    page.setPageNum((int)(page.getTotalNum() / (long)page.getPageSize()));
                } else {
                    page.setPageNum((int)(page.getTotalNum() / (long)page.getPageSize() + 1L));
                }
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
        return page;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelWaitMsg(User user) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException {
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = ConnectionPool.getInstance().getConnection();
            stmt = conn.createStatement();
            String sql = "update " + this.getProperty("tables.sms_out") + " set status = 'Z' where status in ('U','Q')";
            if (!"admin".equals(user.getUserId())) {
                sql = "update " + this.getProperty("tables.sms_out") + " set status = 'Z' where status in ('U','Q') and user_id='" + user.getUserId() + "'";
            }
            stmt.executeUpdate(sql);
        }
        catch (Exception exception) {
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteCanceledMsg(User user) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException {
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = ConnectionPool.getInstance().getConnection();
            stmt = conn.createStatement();
            String sql = "delete from " + this.getProperty("tables.sms_out") + " where status in ('Z')";
            if (!"admin".equals(user.getUserId())) {
                sql = "delete from " + this.getProperty("tables.sms_out") + " where status in ('Z') and user_id='" + user.getUserId() + "'";
            }
            stmt.executeUpdate(sql);
        }
        catch (Exception exception) {
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Page findMsgByCondition(Condition condition, User user) throws SQLException, InstantiationException, IllegalAccessException, ClassNotFoundException, IOException {
        String tels;
        String strKeyWord;
        UserAddrBook uab = user.getAddrBook();
        String sendDate = condition.getSendDate() == null ? "" : condition.getSendDate();
        String endDate = condition.getEndDate() == null ? "" : condition.getEndDate();
        Timestamp startTime = null;
        Timestamp endTime = null;
        String telephone = condition.getTelephone() == null ? "" : condition.getTelephone();
        String sendContent = condition.getSendContent() == null ? "" : condition.getSendContent().trim();
        String string = strKeyWord = condition.getKeyWord() == null ? "" : condition.getKeyWord().trim();
        if (sendDate.matches("\\d{4}-\\d{2}-\\d{2}") || sendDate.matches("\\d{8}")) {
            sendDate = sendDate.replaceAll("-", "");
            sendDate = sendDate + "000000";
            try {
                startTime = this.DateFromString(sendDate);
            }
            catch (Exception e2) {
                sendDate = "";
            }
        } else {
            sendDate = "";
        }
        if (endDate.matches("\\d{4}-\\d{2}-\\d{2}") || endDate.matches("\\d{8}")) {
            endDate = endDate.replaceAll("-", "");
            endDate = endDate + "235959";
            try {
                endTime = this.DateFromString(endDate);
            }
            catch (Exception e3) {
                sendDate = "";
            }
        } else {
            sendDate = "";
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select * from ");
        if (condition.getType() == 3) {
            sql.append(this.getProperty("tables.sms_in"));
        } else {
            sql.append(this.getProperty("tables.sms_out"));
        }
        if (condition.getType() != 3) {
            sql.append(" where status = ");
            if (condition.getType() == 1) {
                sql.append("'S'");
            } else {
                sql.append("'F'");
            }
            if (!"admin".equals(user.getUserId())) {
                sql.append(" and user_id='" + user.getUserId() + "'");
            }
            if (!"".equals(sendDate)) {
                sql.append(" and sent_date between '" + startTime + "' and '" + endTime + "'");
            }
            if (!"".equals(telephone)) {
                tels = uab.findAddrTel(telephone, uab);
                if (tels.indexOf("'@'") != -1) {
                    sql.append(" and recipient in(" + tels + ")");
                } else {
                    sql.append(" and recipient like '%" + tels + "%'");
                }
            }
            if (!"".equals(sendContent)) {
                sql.append(" and user_id='" + sendContent + "'");
            }
        } else {
            if (!"admin".equals(user.getUserId())) {
                sql.append(" where type = 'I'");
            } else {
                sql.append(" where type = 'I'");
            }
            if (!"".equals(sendDate)) {
                sql.append(" and receive_date between '" + startTime + "' and '" + endTime + "'");
            }
            if (!"".equals(telephone)) {
                tels = uab.findAddrTel(telephone, uab);
                if (tels.indexOf("'@'") != -1) {
                    sql.append(" and originator in(" + tels + ")");
                } else {
                    sql.append(" and originator like '%" + tels + "%'");
                }
            }
        }
        if (!"".equals(strKeyWord)) {
            sql.append(" and text like '%" + strKeyWord + "%'");
        }
        StringBuffer countSql = new StringBuffer(sql.toString());
        int index = countSql.indexOf("*");
        countSql.replace(index, index + 1, "count(1) as totalnum");
        sql.append(" order by ");
        if (condition.getType() != 3) {
            sql.append("sent_date ");
        } else {
            sql.append("receive_date ");
        }
        if (condition.getOrder() == 0) {
            sql.append("desc, id desc");
        } else {
            sql.append("asc, id asc");
        }
        if (condition.getType() != 3) {
            sql.append(",user_id desc ");
        }
        Page page = new Page();
        page.setPageIndex(condition.getPageIndex());
        sql.append(" limit " + (condition.getPageIndex() - 1) * page.getPageSize() + "," + page.getPageSize());
        ArrayList list = page.getData();
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            conn = ConnectionPool.getInstance().getConnection();
            stmt = conn.createStatement();
            rs = stmt.executeQuery(sql.toString());
            while (rs.next()) {
                String name;
                Object msg;
                if (condition.getType() != 3) {
                    msg = new OutMessage();
                    ((OutMessage)msg).setId(rs.getLong("id"));
                    ((OutMessage)msg).setContent(rs.getString("text"));
                    ((OutMessage)msg).setCreateTime(this.DateFormat(rs.getTimestamp("sent_date")));
                    ((OutMessage)msg).setGateway_id(rs.getString("gateway_id"));
                    name = rs.getString("recipient");
                    name = uab.findAddrName(name, uab);
                    ((OutMessage)msg).setName(name);
                    ((OutMessage)msg).setRecipient(rs.getString("recipient"));
                    ((OutMessage)msg).setStatus((char)rs.getCharacterStream("status").read());
                    ((OutMessage)msg).setType((char)rs.getCharacterStream("type").read());
                    ((OutMessage)msg).setWap_url(rs.getString("wap_url"));
                    ((OutMessage)msg).setUserId(rs.getString("user_id"));
                    list.add(msg);
                    continue;
                }
                msg = new InMessage();
                ((InMessage)msg).setId(rs.getLong("id"));
                ((InMessage)msg).setContent(rs.getString("text"));
                ((InMessage)msg).setGateway_id(rs.getString("gateway_id"));
                ((InMessage)msg).setType((char)rs.getCharacterStream("type").read());
                ((InMessage)msg).setMsgDate(this.DateFormat(rs.getTimestamp("message_date")));
                ((InMessage)msg).setRecvDate(this.DateFormat(rs.getTimestamp("receive_date")));
                name = rs.getString("originator");
                name = uab.findAddrName(name, uab);
                ((InMessage)msg).setName(name);
                ((InMessage)msg).setOriginator(rs.getString("originator"));
                list.add(msg);
            }
            rs.close();
            rs = stmt.executeQuery(countSql.toString());
            if (rs.next()) {
                page.setTotalNum(rs.getLong(1));
                if (page.getTotalNum() % (long)page.getPageSize() == 0L) {
                    page.setPageNum((int)(page.getTotalNum() / (long)page.getPageSize()));
                } else {
                    page.setPageNum((int)(page.getTotalNum() / (long)page.getPageSize() + 1L));
                }
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
        return page;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List findAllMsgByCondition(Condition condition, User user) throws SQLException, InstantiationException, IllegalAccessException, ClassNotFoundException, IOException {
        String tels;
        String strKeyWord;
        UserAddrBook uab = user.getAddrBook();
        String sendDate = condition.getSendDate() == null ? "" : condition.getSendDate();
        String endDate = condition.getEndDate() == null ? "" : condition.getEndDate();
        Timestamp startTime = null;
        Timestamp endTime = null;
        String telephone = condition.getTelephone() == null ? "" : condition.getTelephone();
        String sendContent = condition.getSendContent() == null ? "" : condition.getSendContent().trim();
        String string = strKeyWord = condition.getKeyWord() == null ? "" : condition.getKeyWord().trim();
        if (sendDate.matches("\\d{4}-\\d{2}-\\d{2}") || sendDate.matches("\\d{8}")) {
            sendDate = sendDate.replaceAll("-", "");
            sendDate = sendDate + "000000";
            try {
                startTime = this.DateFromString(sendDate);
            }
            catch (Exception e2) {
                sendDate = "";
            }
        } else {
            sendDate = "";
        }
        if (endDate.matches("\\d{4}-\\d{2}-\\d{2}") || endDate.matches("\\d{8}")) {
            endDate = endDate.replaceAll("-", "");
            endDate = endDate + "235959";
            try {
                endTime = this.DateFromString(endDate);
            }
            catch (Exception e3) {
                sendDate = "";
            }
        } else {
            sendDate = "";
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select * from ");
        if (condition.getType() == 3) {
            sql.append(this.getProperty("tables.sms_in"));
        } else {
            sql.append(this.getProperty("tables.sms_out"));
        }
        if (condition.getType() != 3) {
            sql.append(" where status = ");
            if (condition.getType() == 1) {
                sql.append("'S'");
            } else {
                sql.append("'F'");
            }
            if (!"admin".equals(user.getUserId())) {
                sql.append(" and user_id='" + user.getUserId() + "'");
            }
            if (!"".equals(sendDate)) {
                sql.append(" and sent_date between '" + startTime + "' and '" + endTime + "'");
            }
            if (!"".equals(telephone)) {
                tels = uab.findAddrTel(telephone, uab);
                if (tels.indexOf("'@'") != -1) {
                    sql.append(" and recipient in(" + tels + ")");
                } else {
                    sql.append(" and recipient like '%" + tels + "%'");
                }
            }
            if (!"".equals(sendContent)) {
                sql.append(" and user_id='" + sendContent + "'");
            }
        } else {
            if (!"admin".equals(user.getUserId())) {
                sql.append(" where type = 'I'");
            } else {
                sql.append(" where type = 'I'");
            }
            if (!"".equals(sendDate)) {
                sql.append(" and receive_date between '" + startTime + "' and '" + endTime + "'");
            }
            if (!"".equals(telephone)) {
                tels = uab.findAddrTel(telephone, uab);
                if (tels.indexOf("'@'") != -1) {
                    sql.append(" and originator in(" + tels + ")");
                } else {
                    sql.append(" and originator like '%" + tels + "%'");
                }
            }
        }
        if (!"".equals(strKeyWord)) {
            sql.append(" and text like '%" + strKeyWord + "%'");
        }
        sql.append(" order by ");
        if (condition.getType() != 3) {
            sql.append("sent_date ");
        } else {
            sql.append("receive_date ");
        }
        if (condition.getOrder() == 0) {
            sql.append("desc");
        } else {
            sql.append("asc");
        }
        if (condition.getType() != 3) {
            sql.append(",user_id desc ");
        }
        ArrayList<Object> list = new ArrayList<Object>();
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            conn = ConnectionPool.getInstance().getConnection();
            stmt = conn.createStatement();
            rs = stmt.executeQuery(sql.toString());
            while (rs.next()) {
                String name;
                Object msg;
                if (condition.getType() != 3) {
                    msg = new OutMessage();
                    ((OutMessage)msg).setId(rs.getLong("id"));
                    ((OutMessage)msg).setContent(rs.getString("text"));
                    ((OutMessage)msg).setCreateTime(this.DateFormat(rs.getTimestamp("sent_date")));
                    ((OutMessage)msg).setGateway_id(rs.getString("gateway_id"));
                    name = rs.getString("recipient");
                    name = uab.findAddrName(name, uab);
                    ((OutMessage)msg).setName(name);
                    ((OutMessage)msg).setRecipient(rs.getString("recipient"));
                    ((OutMessage)msg).setStatus((char)rs.getCharacterStream("status").read());
                    ((OutMessage)msg).setType((char)rs.getCharacterStream("type").read());
                    ((OutMessage)msg).setWap_url(rs.getString("wap_url"));
                    ((OutMessage)msg).setUserId(rs.getString("user_id"));
                    list.add(msg);
                    continue;
                }
                msg = new InMessage();
                ((InMessage)msg).setId(rs.getLong("id"));
                ((InMessage)msg).setContent(rs.getString("text"));
                ((InMessage)msg).setGateway_id(rs.getString("gateway_id"));
                ((InMessage)msg).setType((char)rs.getCharacterStream("type").read());
                ((InMessage)msg).setMsgDate(this.DateFormat(rs.getTimestamp("message_date")));
                ((InMessage)msg).setRecvDate(this.DateFormat(rs.getTimestamp("receive_date")));
                name = rs.getString("originator");
                name = uab.findAddrName(name, uab);
                ((InMessage)msg).setName(name);
                ((InMessage)msg).setOriginator(rs.getString("originator"));
                list.add(msg);
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
        return list;
    }

    @Override
    public String getHttpReceiveApiSQL(String gateway, int count) {
        String sql = "select id,originator,message_date,text,encoding,gateway_id,type,receive_date  from " + this.getProperty("tables.sms_in");
        sql = sql + this.GenerateRecvSQL(gateway);
        sql = sql + " order by id desc limit 0," + count;
        return sql;
    }

    @Override
    public String getHttpReceiveApiSQL(String gateway, int count, int minId) {
        String sql = "select id,originator,message_date,text,encoding,gateway_id,type,receive_date  from " + this.getProperty("tables.sms_in");
        sql = sql + this.GenerateRecvSQL(gateway, minId);
        sql = sql + " order by id asc limit 0," + count;
        return sql;
    }

    public static void main(String[] args) {
        System.out.println("select id,originator,message_date,text,encoding,gateway_id,type,receive_date  from smsserver_in order by id desc limit 0,5000");
    }
}

