/*
 * Decompiled with CFR 0.152.
 */
package cn.sendsms.jdsmsserver.web;

import cn.sendsms.GatewayClient;
import cn.sendsms.GatewayClientSms;
import cn.sendsms.jdsmsserver.JDSMSServer;
import cn.sendsms.jdsmsserver.ResourceManager;
import cn.sendsms.jdsmsserver.web.Charge;
import cn.sendsms.jdsmsserver.web.JDWebAction;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.configuration.ConfigurationException;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class GatewayAction
extends JDWebAction {
    private String serialnum;
    private String pwd;
    private String cardNum;
    private String cardPassword;
    private String telephone;
    private String companyname;
    private String userDesc;

    public void Init(HttpServletRequest req, HttpServletResponse resp) {
        Charge charge = new Charge();
        charge.setSn(GatewayClientSms.getInstance().getUserName());
        charge.setPwd(GatewayClientSms.getInstance().getPwd());
        req.setAttribute("surplusNumber", (Object)(GatewayClientSms.getSurplusNumber() == -1 ? 0 : GatewayClientSms.getSurplusNumber()));
        req.setAttribute("charge", (Object)charge);
        this.findForward("/chargeUp.jsp", true, req, resp);
    }

    public void balance(HttpServletRequest request, HttpServletResponse response) {
        response.setContentType("text/xml;charset=UTF-8");
        String errorcode = "0";
        String errorDesc = "";
        String surplusNumber = "";
        if (!GatewayClientSms.getInstance().isRegister()) {
            errorcode = "-1";
            errorDesc = ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.other_not_registered");
        } else {
            surplusNumber = GatewayClientSms.getInstance().getBalance();
        }
        if (surplusNumber.startsWith("-")) {
            errorcode = "-1";
            errorDesc = GatewayClientSms.getErrorCodeDesc(surplusNumber);
        } else {
            int avilableNumber = GatewayClientSms.getSurplusNumber();
            try {
                GatewayClientSms.setSurplusNumber(Integer.parseInt(surplusNumber));
            }
            catch (Exception e2) {
                GatewayClientSms.setSurplusNumber(avilableNumber);
            }
        }
        Document doc = DocumentHelper.createDocument();
        Element rootElt = doc.addElement("result");
        rootElt.addElement("error").addText(errorcode);
        rootElt.addElement("errorDesc").addText(errorDesc);
        rootElt.addElement("surplusNumber").addText(surplusNumber);
        String xmlString = doc.asXML();
        try {
            response.getWriter().print(xmlString);
        }
        catch (IOException e3) {
            e3.printStackTrace();
        }
    }

    public void apply(HttpServletRequest request, HttpServletResponse response) {
        response.setContentType("text/xml;charset=UTF-8");
        String errorcode = "0";
        String errorDesc = ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.gateway_successful");
        String surplusNumber = "";
        String beifenUserName = GatewayClientSms.getInstance().getUserName();
        if (GatewayClientSms.getInstance().isRegister() && beifenUserName.equals(this.serialnum)) {
            errorcode = "-1";
            errorDesc = ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.gateway_registered_please_do_not_repeat_the_operation");
        } else {
            String result = GatewayClientSms.getInstance().gatewayApply(this.serialnum, this.pwd, this.telephone, this.companyname, this.userDesc);
            if (result.startsWith("-")) {
                errorcode = "-1";
                errorDesc = GatewayClientSms.getErrorCodeDesc(result);
            }
        }
        Document doc = DocumentHelper.createDocument();
        Element rootElt = doc.addElement("result");
        rootElt.addElement("error").addText(errorcode);
        rootElt.addElement("errorDesc").addText(errorDesc);
        String xmlString = doc.asXML();
        try {
            response.getWriter().print(xmlString);
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    public void register(HttpServletRequest request, HttpServletResponse response) {
        response.setContentType("text/xml;charset=UTF-8");
        String errorcode = "0";
        String errorDesc = ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.gateway_successful");
        String surplusNumber = "";
        String beifenUserName = GatewayClientSms.getInstance().getUserName();
        String beifenPassword = GatewayClientSms.getInstance().getPwd();
        if (GatewayClientSms.getInstance().isRegister() && beifenUserName.equals(this.serialnum)) {
            errorcode = "-1";
            errorDesc = "\u5df2\u6ce8\u518c,\u8bf7\u4e0d\u8981\u91cd\u590d\u6ce8\u518c";
        } else {
            GatewayClientSms.getInstance().setUserName(this.serialnum);
            String password = "";
            try {
                password = GatewayClient.getMD5(this.serialnum + this.pwd);
                GatewayClientSms.getInstance().setPwd(password);
            }
            catch (UnsupportedEncodingException e1) {
                errorcode = "-1";
                errorDesc = ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.gateway_abnormal_code_please_check_your_registration");
                password = "";
            }
            String result = GatewayClientSms.getInstance().register();
            if (result.startsWith("-")) {
                errorcode = "-1";
                errorDesc = GatewayClientSms.getErrorCodeDesc(result);
                GatewayClientSms.getInstance().setUserName(beifenUserName);
                GatewayClientSms.getInstance().setPwd(beifenPassword);
            } else {
                JDSMSServer.getInstance().getProperties().setProperty("md.userName", (Object)this.serialnum);
                JDSMSServer.getInstance().getProperties().setProperty("md.pwd", (Object)password);
                JDSMSServer.getInstance().getProperties().setProperty("md.register", (Object)"true");
                try {
                    JDSMSServer.getInstance().getProperties().save();
                }
                catch (ConfigurationException e2) {
                    errorcode = "-1";
                    errorDesc = ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.gateway_failed_registration_failed_to_save_the_configurations");
                    e2.printStackTrace();
                }
            }
        }
        Document doc = DocumentHelper.createDocument();
        Element rootElt = doc.addElement("result");
        rootElt.addElement("error").addText(errorcode);
        rootElt.addElement("errorDesc").addText(errorDesc);
        String xmlString = doc.asXML();
        try {
            response.getWriter().print(xmlString);
        }
        catch (IOException e3) {
            e3.printStackTrace();
        }
    }

    public void chargefee(HttpServletRequest request, HttpServletResponse response) {
        response.setContentType("text/xml;charset=UTF-8");
        String errorcode = "0";
        String errorDesc = "";
        String surplusNumber = "-1";
        String chargeResult = "";
        if (!GatewayClientSms.getInstance().isRegister()) {
            errorcode = "-1";
            errorDesc = ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.gateway_no_registration_please_register_first");
        } else {
            chargeResult = GatewayClientSms.getInstance().chargeFee(this.cardNum, this.cardPassword);
        }
        if (chargeResult.startsWith("-")) {
            errorcode = "-1";
            errorDesc = GatewayClientSms.getErrorCodeDesc(chargeResult);
        } else {
            surplusNumber = GatewayClientSms.getInstance().getBalance();
            if (!surplusNumber.startsWith("-")) {
                int avilableNumber = GatewayClientSms.getSurplusNumber();
                try {
                    GatewayClientSms.setSurplusNumber(Integer.parseInt(surplusNumber));
                }
                catch (Exception e2) {
                    GatewayClientSms.setSurplusNumber(avilableNumber);
                }
            }
        }
        Document doc = DocumentHelper.createDocument();
        Element rootElt = doc.addElement("result");
        rootElt.addElement("error").addText(errorcode);
        rootElt.addElement("errorDesc").addText(errorDesc);
        rootElt.addElement("surplusNumber").addText(surplusNumber);
        String xmlString = doc.asXML();
        try {
            response.getWriter().print(xmlString);
        }
        catch (IOException e3) {
            e3.printStackTrace();
        }
    }

    public static void main(String[] args) {
    }
}

