/*
 * Decompiled with CFR 0.152.
 */
package cn.sendsms.modem;

import cn.sendsms.GatewayException;
import cn.sendsms.TimeoutException;
import cn.sendsms.helper.AGatewayHelper;
import cn.sendsms.jdsmsserver.web.DeviceInfoCache;
import cn.sendsms.jdsmsserver.web.SerialModemBean;
import cn.sendsms.modem.ModemGateway;
import java.io.IOException;

public class IPModemGateway
extends ModemGateway {
    public IPModemGateway(String id, String ipName, int ipPort, String manufacturer, String model) {
        super(ModemGateway.ModemTypes.IP, id, ipName, ipPort, manufacturer, model);
    }

    @Override
    public void setStatus(AGatewayHelper.GatewayStatuses myStatus) {
        super.setStatus(myStatus);
        SerialModemBean bean = DeviceInfoCache.getInstance().get(this.getModemDevice() + ":" + this.getModemParms());
        if (bean != null) {
            bean.setStatus(this.getStatus());
        }
    }

    public IPModemGateway(SerialModemBean bean) {
        super(ModemGateway.ModemTypes.IP, bean.getGatewayID(), bean.getIpAddress(), bean.getIpPort(), bean.getManufacturer(), bean.getModel());
        this.setProtocol(bean.getProtocol());
        if (bean.getInbound().equalsIgnoreCase("yes")) {
            this.setInbound(true);
        } else {
            this.setInbound(false);
        }
        if (bean.getOutbound().equalsIgnoreCase("yes")) {
            this.setOutbound(true);
        } else {
            this.setOutbound(false);
        }
        this.setSimPin(bean.getPin());
        this.setCustomInitString(bean.getInit_string());
        this.setSmscNumber(bean.getSmsc_number());
    }

    @Override
    public void startGateway() throws TimeoutException, GatewayException, IOException, InterruptedException {
        SerialModemBean bean = DeviceInfoCache.getInstance().get(this.getGatewayId());
        this.setStatus(AGatewayHelper.GatewayStatuses.STARTING);
        try {
            super.startGateway();
        }
        catch (GatewayException e2) {
            e2.printStackTrace();
            if (e2 instanceof GatewayException) {
                if (e2.getMessage().indexOf("NoSuchPort") != -1) {
                    this.setStatus(AGatewayHelper.GatewayStatuses.NOPORT);
                } else if (e2.getMessage().indexOf("PortInUse") != -1) {
                    this.setStatus(AGatewayHelper.GatewayStatuses.OCCUPY);
                } else {
                    this.setStatus(AGatewayHelper.GatewayStatuses.STOPPED);
                }
                return;
            }
            throw e2;
        }
        this.judgeAuthorize();
    }

    @Override
    public void stopGateway() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.setStatus(AGatewayHelper.GatewayStatuses.STOPPING);
        super.stopGateway();
    }
}

