/*
 * Decompiled with CFR 0.152.
 */
package cn.sendsms.modem;

import cn.ajwcc.pduUtils.gsm3040.Pdu;
import cn.ajwcc.pduUtils.gsm3040.PduParser;
import cn.ajwcc.pduUtils.gsm3040.PduUtils;
import cn.ajwcc.pduUtils.gsm3040.SmsDeliveryPdu;
import cn.ajwcc.pduUtils.gsm3040.SmsStatusReportPdu;
import cn.sendsms.AGateway;
import cn.sendsms.Contact;
import cn.sendsms.GatewayException;
import cn.sendsms.InboundBinaryMessage;
import cn.sendsms.InboundEncryptedMessage;
import cn.sendsms.InboundMessage;
import cn.sendsms.Message;
import cn.sendsms.OutboundBinaryMessage;
import cn.sendsms.OutboundMessage;
import cn.sendsms.Phonebook;
import cn.sendsms.Service;
import cn.sendsms.StatusReportMessage;
import cn.sendsms.TimeoutException;
import cn.sendsms.TmpMsg;
import cn.sendsms.USSDRequest;
import cn.sendsms.UnknownMessage;
import cn.sendsms.helper.AGatewayHelper;
import cn.sendsms.helper.Logger;
import cn.sendsms.jdsmsserver.JDSMSServer;
import cn.sendsms.jdsmsserver.web.AlertInfo;
import cn.sendsms.jdsmsserver.web.DbHelper;
import cn.sendsms.jdsmsserver.web.DeviceInfoCache;
import cn.sendsms.jdsmsserver.web.NewAuth;
import cn.sendsms.jdsmsserver.web.SerialModemBean;
import cn.sendsms.modem.AModemDriver;
import cn.sendsms.modem.SerialModemDriver;
import cn.sendsms.modem.a;
import cn.sendsms.modem.athandler.AATHandler;
import cn.sendsms.modem.athandler.ATHandler_Huawei_ME909;
import cn.sendsms.modem.athandler.ATHandler_INCORPORATED_7600CE_JT1S;
import cn.sendsms.modem.athandler.ATHandler_INCORPORATED_7600CE_L;
import cn.sendsms.modem.athandler.ATHandler_INCORPORATED_7600CE_T;
import cn.sendsms.modem.athandler.ATHandler_INCORPORATED_A7600C1_SE;
import cn.sendsms.modem.athandler.ATHandler_TDTech_ME901;
import cn.sendsms.modem.athandler.ATHandler_TDTech_ME909;
import cn.sendsms.modem.athandler.ATHandler_TDTech_MH5000;
import cn.sendsms.modem.athandler.ATHandler_Yuga;
import cn.sendsms.modem.athandler.ATHandler_Yuga_CLM920_NC5;
import cn.sendsms.modem.athandler.ATHandler_Yuga_CLM920_RC3;
import cn.sendsms.modem.athandler.ATHandler_Yuga_CLM920_RV3;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.time.StopWatch;

public class ModemGateway
extends AGateway {
    private static boolean lastCountTip = false;
    private AModemDriver a;
    private AATHandler b;
    private String c;
    private int d;
    private IPProtocols e;
    private boolean f;
    private long g;
    private String h;
    private String i;
    private String j;
    private String k;
    private String l;
    private String m;
    private int n;
    private List<List<InboundMessage>> o;
    private Object p = new Object();
    private boolean q;

    public ModemGateway(ModemTypes myType, String id, String myModemDevice, int myModemParms, String myManufacturer, String myModel) {
        super(id);
        this.a(myType, myModemDevice, myModemParms, myManufacturer, myModel, null);
    }

    public ModemGateway(String id, String myModemDevice, int myModemParms, String myManufacturer, String myModel, AModemDriver myDriver) {
        super(id);
        this.a(null, myModemDevice, myModemParms, myManufacturer, myModel, myDriver);
    }

    private void a(ModemTypes myType, String myModemDevice, int myModemParms, String myManufacturer, String myModel, AModemDriver myDriver) {
        if ("MH5000-31".equals(myModel)) {
            myModel = "MH5000_31";
        } else if ("MH5000-82M".equals(myModel)) {
            myModel = "MH5000";
        }
        this.setModemDevice(myModemDevice);
        this.setModemParms(myModemParms);
        this.setIpProtocol(IPProtocols.BINARY);
        this.setIpEncryption(false);
        this.a(-1L);
        this.h = myManufacturer;
        this.i = myModel;
        this.setAttributes(251);
        if (myDriver != null) {
            this.setDriver(myDriver);
        } else if (myType == ModemTypes.SERIAL) {
            this.setDriver(new SerialModemDriver(this, this.getModemDevice() + ":" + this.getModemParms()));
        } else {
            this.setDriver(new a(this, this.getModemDevice() + ":" + this.getModemParms()));
        }
        this.setAtHandler(AATHandler.load(this, this.h, this.i));
        this.setSimPin("");
        this.setSimPin2("");
        this.setSmscNumber("");
        this.setCustomInitString("");
        this.n = new Random().nextInt();
        if (this.n < 0) {
            this.n *= -1;
        }
        this.n %= 65536;
        this.o = new ArrayList<List<InboundMessage>>();
    }

    private boolean b() {
        return this.getAtHandler() instanceof ATHandler_Huawei_ME909 || this.getAtHandler() instanceof ATHandler_Yuga || this.getAtHandler() instanceof ATHandler_Yuga_CLM920_RC3 || this.getAtHandler() instanceof ATHandler_Yuga_CLM920_RV3 || this.getAtHandler() instanceof ATHandler_Yuga_CLM920_NC5 || this.getAtHandler() instanceof ATHandler_TDTech_ME909 || this.getAtHandler() instanceof ATHandler_TDTech_MH5000 || this.getAtHandler() instanceof ATHandler_TDTech_ME901 || this.getAtHandler() instanceof ATHandler_INCORPORATED_A7600C1_SE || this.getAtHandler() instanceof ATHandler_INCORPORATED_7600CE_L || this.getAtHandler() instanceof ATHandler_INCORPORATED_7600CE_JT1S || this.getAtHandler() instanceof ATHandler_INCORPORATED_7600CE_T;
    }

    public void setIpProtocol(IPProtocols myIpProtocol) {
        this.e = myIpProtocol;
    }

    public IPProtocols getIpProtocol() {
        return this.e;
    }

    public void setIpEncryption(boolean ipEncryption) {
        this.f = ipEncryption;
    }

    public boolean getIpEncryption() {
        return this.f;
    }

    @Override
    public void startGateway() throws TimeoutException, GatewayException, IOException, InterruptedException {
        Logger.getInstance().logInfo("Starting gateway, using " + this.getATHandler().getDescription() + " AT Handler.", null, this.getGatewayId());
        this.getDriver().connect();
        super.startGateway();
        Logger.getInstance().logInfo("Gateway started.", null, this.getGatewayId());
    }

    protected void judgeAuthorize() {
        String serialnum = null;
        boolean flag = false;
        String port = null;
        try {
            SerialModemBean modem = DeviceInfoCache.getInstance().get(this.getGatewayId());
            if (modem.getManufacturer().equalsIgnoreCase("Wavecom") && !modem.getModel().equalsIgnoreCase("WISMOQCDMA")) {
                String deviceType = this.sendCustomATCommand("ATI3\r");
                serialnum = deviceType.indexOf("Q2406B") != -1 ? this.getSerialNo() : this.getSerialNumber();
                if (serialnum == null || serialnum.indexOf("ERROR") >= 0 || serialnum.indexOf("N/A") >= 0) {
                    serialnum = this.getSerialNo();
                }
            } else {
                serialnum = this.getSerialNo();
            }
            Logger.getInstance().logInfo("\u8bbe\u5907\u5e8f\u5217\u53f7\uff1a" + serialnum, null, this.getGatewayId());
            if (serialnum.equalsIgnoreCase("N/A")) {
                return;
            }
            port = modem.getPort();
            modem.setSerialnum(serialnum);
            flag = NewAuth.checkDeviceAuth(serialnum);
            DeviceInfoCache.getInstance().get(this.getGatewayId()).setValidate(flag);
            if (flag) {
                NewAuth.updateAuthorizeTemp(port, serialnum);
                Logger.getInstance().logInfo("\u8bbe\u5907\u6388\u6743\u6709\u6548", null, this.getGatewayId());
            } else {
                NewAuth.updateAuthorizeTemp(port, serialnum);
                Logger.getInstance().logInfo("\u8bbe\u5907\u672a\u6388\u6743", null, this.getGatewayId());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testGateway() throws TimeoutException, GatewayException, IOException, InterruptedException {
        Logger.getInstance().logInfo("Starting gateway ", null, this.getGatewayId());
        this.getDriver().testconnect();
        Logger.getInstance().logInfo("Gateway started.", null, this.getGatewayId());
    }

    @Override
    public void stopGateway() throws TimeoutException, GatewayException, IOException, InterruptedException {
        Logger.getInstance().logInfo("Stopping gateway...", null, this.getGatewayId());
        try {
            super.stopGateway();
        }
        catch (Exception e2) {
            Logger.getInstance().logError("Gateway stopping occur error.", null, this.getGatewayId());
        }
        this.getDriver().disconnect();
        Logger.getInstance().logInfo("Gateway stopped.", null, this.getGatewayId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readMessages(Collection<InboundMessage> msgList, InboundMessage.MessageClasses msgClass) throws TimeoutException, GatewayException, IOException, InterruptedException {
        if (this.getStatus() != AGatewayHelper.GatewayStatuses.STARTED) {
            return;
        }
        SerialModemBean modem = DeviceInfoCache.getInstance().get(this.getGatewayId());
        String serialnum = modem.getSerialnum();
        if (serialnum.trim().length() <= 0) {
            serialnum = modem.getManufacturer().equalsIgnoreCase("Wavecom") && !modem.getModel().equalsIgnoreCase("WISMOQCDMA") ? this.getSerialNumber() : this.getSerialNo();
        }
        if (serialnum.indexOf("N/A") >= 0) {
            throw new GatewayException("\u83b7\u53d6\u8bbe\u5907\u5e8f\u5217\u53f7\u5931\u8d25");
        }
        try {
            boolean flag = NewAuth.checkDeviceAuth(serialnum);
            if (!flag) {
                int num = NewAuth.getAvaliableNum(serialnum);
                JDSMSServer.getInstance().userConsolePrint("x", "\u8bbe\u5907\u672a\u6388\u6743\uff0c\u8fd8\u53ef\u6536\u53d1" + num + "\u6761\u77ed\u4fe1");
                if (num < 1 && !lastCountTip) {
                    lastCountTip = true;
                    Logger.getInstance().logWarn("\u8bbe\u5907\u672a\u6388\u6743\uff0c\u6536\u53d1\u77ed\u4fe1\u6761\u6570\u5df2\u8fbe\u5230\u6700\u5927\u9650\u5236\u657088\u6761,\u5df2\u505c\u6b62\u6536\u53d1\u77ed\u4fe1", null, this.getGatewayId());
                    return;
                }
            }
        }
        catch (Exception e2) {
            return;
        }
        Object e2 = this.getDriver().getSYNCCommander();
        synchronized (e2) {
            if (this.getModemDriver().isOccurTimeoutError()) {
                return;
            }
            if (this.getProtocol() == AGatewayHelper.Protocols.PDU) {
                try {
                    this.b(msgList, msgClass, 0);
                }
                catch (Exception e3) {
                    Logger.getInstance().logError("\u8bfb\u53d6pdu\u77ed\u4fe1\u65f6\u51fa\u73b0\u5f02\u5e38", e3, this.getGatewayId());
                }
            } else if (this.getProtocol() == AGatewayHelper.Protocols.TEXT) {
                this.a(msgList, msgClass, 0);
            }
        }
        Iterator<InboundMessage> it = msgList.iterator();
        while (it.hasNext()) {
            InboundMessage msg = it.next();
            if (!msg.getGatewayId().equals(this.getGatewayId())) continue;
            if (!this.a(msg, serialnum)) {
                it.remove();
                continue;
            }
            SerialModemBean bean = DeviceInfoCache.getInstance().get(this.getGatewayId());
            serialnum = bean.getSerialnum();
            if (serialnum.trim().length() <= 0) {
                serialnum = bean.getManufacturer().equalsIgnoreCase("Wavecom") && !bean.getModel().equalsIgnoreCase("WISMOQCDMA") ? this.getSerialNumber() : this.getSerialNo();
            }
            if (serialnum.indexOf("N/A") >= 0) {
                throw new GatewayException("\u83b7\u53d6\u8bbe\u5907\u5e8f\u5217\u53f7\u5931\u8d25");
            }
            int num = NewAuth.getAvaliableNum(serialnum);
            --num;
            try {
                NewAuth.updateAvaliableNum(serialnum, num);
            }
            catch (SQLException e4) {
                return;
            }
        }
    }

    private boolean a(Message msg, String serialnum) {
        String guanggao = "<\u8bf7\u586b\u5199\u8bbe\u5907\u6ce8\u518c\u7801>";
        try {
            if (serialnum == null) {
                SerialModemBean bean = DeviceInfoCache.getInstance().get(this.getGatewayId());
                serialnum = bean.getSerialnum();
                if (serialnum.trim().length() <= 0) {
                    serialnum = bean.getManufacturer().equalsIgnoreCase("Wavecom") && !bean.getModel().equalsIgnoreCase("WISMOQCDMA") ? this.getSerialNumber() : this.getSerialNo();
                }
                if (serialnum.indexOf("N/A") >= 0) {
                    throw new GatewayException("\u83b7\u53d6\u8bbe\u5907\u5e8f\u5217\u53f7\u5931\u8d25");
                }
            }
            if (!NewAuth.checkDeviceAuth(serialnum)) {
                int num = NewAuth.getAvaliableNum(serialnum);
                if (num > 0) {
                    Logger.getInstance().logWarn("\u8bbe\u5907\u672a\u6388\u6743\uff0c\u5f53\u524d\u8fd8\u53ef\u6536\u53d1\u77ed\u4fe1" + num + "\u6761", null, this.getGatewayId());
                }
                if (num < 1) {
                    Logger.getInstance().logWarn("\u8bbe\u5907\u672a\u6388\u6743\uff0c\u6536\u53d1\u77ed\u4fe1\u6761\u6570\u5df2\u8fbe\u5230\u6700\u5927\u9650\u5236\u657088\u6761,\u5df2\u505c\u6b62\u6536\u53d1\u77ed\u4fe1", null, this.getGatewayId());
                    return false;
                }
                if (!(msg instanceof InboundBinaryMessage)) {
                    if (msg instanceof InboundMessage) {
                        if (msg.getText().indexOf(guanggao) == -1) {
                            msg.setText(guanggao + msg.getText());
                        }
                    } else {
                        if (msg instanceof OutboundBinaryMessage) {
                            Logger.getInstance().logWarn("\u4e0d\u652f\u6301\u53d1\u9001\u5f69\u4fe1", null, this.getGatewayId());
                            return false;
                        }
                        if (msg instanceof OutboundMessage && msg.getText().indexOf(guanggao) == -1) {
                            msg.setText(guanggao + msg.getText());
                        }
                    }
                }
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InboundMessage readMessage(String memLoc, int memIndex) throws TimeoutException, GatewayException, IOException, InterruptedException {
        if (this.getStatus() != AGatewayHelper.GatewayStatuses.STARTED) {
            return null;
        }
        Object object = this.getDriver().getSYNCCommander();
        synchronized (object) {
            ArrayList<InboundMessage> msgList = new ArrayList<InboundMessage>();
            this.readMessages(msgList, InboundMessage.MessageClasses.ALL);
            Iterator iter = msgList.iterator();
            if (iter.hasNext()) {
                InboundMessage msg = (InboundMessage)iter.next();
                if (msg.getMemIndex() == memIndex && msg.getMemLocation().equals(memLoc)) {
                    iter = null;
                }
                return msg;
            }
            iter = null;
            return null;
        }
    }

    @Override
    public boolean sendMessage(OutboundMessage msg) throws TimeoutException, GatewayException, IOException, InterruptedException, ClassNotFoundException, NoSuchMethodException, SecurityException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, SQLException {
        AlertInfo demo;
        SerialModemBean bean;
        DbHelper helper;
        if (this.sendMessageA(msg)) {
            helper = DbHelper.getDbHelper(JDSMSServer.getInstance().getProperties(), "db1");
            bean = DeviceInfoCache.getInstance().get(this.getGatewayId());
            demo = bean.getAlert();
            if (demo == null) {
                return true;
            }
            int nSentNumber = demo.getSentNumber();
            int nAlertNumber = demo.getAlertNumber();
            String strCallNumber = demo.getCallNumber();
            String strAlertMsg = demo.getAlertMsg();
            int nMaxLimitNumber = demo.getMaxLimitNumber();
            for (int nNumber = msg.getSplitNum(); nNumber > 0; --nNumber) {
                String strTemp;
                demo.setSentNumber(++nSentNumber);
                if (nSentNumber != nMaxLimitNumber || nMaxLimitNumber <= 0 || nMaxLimitNumber > nAlertNumber) continue;
                OutboundMessage AlertMsg = msg;
                if (strAlertMsg.indexOf("#K#") != -1) {
                    strAlertMsg = strTemp = strAlertMsg.substring(0, strAlertMsg.indexOf("#K#")) + String.valueOf(demo.getAlertNumber()) + strAlertMsg.substring(strAlertMsg.indexOf("#K#") + 3);
                }
                if (strAlertMsg.indexOf("#Y#") != -1) {
                    strAlertMsg = strTemp = strAlertMsg.substring(0, strAlertMsg.indexOf("#Y#")) + String.valueOf(demo.getSentNumber()) + strAlertMsg.substring(strAlertMsg.indexOf("#Y#") + 3);
                }
                if (strAlertMsg.indexOf("#S#") != -1) {
                    strAlertMsg = strTemp = strAlertMsg.substring(0, strAlertMsg.indexOf("#S#")) + String.valueOf(demo.getAlertNumber() - demo.getSentNumber()) + strAlertMsg.substring(strAlertMsg.indexOf("#S#") + 3);
                }
                AlertMsg.setText(strAlertMsg);
                AlertMsg.setRecipient(strCallNumber);
                try {
                    helper.insertMessage(false, strCallNumber, strAlertMsg, bean.getGatewayID(), null, null);
                    continue;
                }
                catch (Exception e2) {
                    Logger.getInstance().logError("\u63d2\u5165\u544a\u8b66\u51fa\u9519", e2, this.getGatewayId());
                    e2.printStackTrace();
                }
            }
        } else {
            return false;
        }
        bean.setAlert(demo);
        helper.AddAlertInfoToDB(demo);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendMessageA(OutboundMessage msg) throws TimeoutException, GatewayException, IOException, InterruptedException {
        Object object;
        Logger.getInstance().logDebug("in sendMessageA", null, this.getGatewayId());
        boolean sendKeepLinkOpen = false;
        boolean flag = false;
        if (this.getStatus() != AGatewayHelper.GatewayStatuses.STARTED) {
            return false;
        }
        long interval = 3600 / Integer.parseInt(JDSMSServer.getInstance().getProperties().getString("settings.send_speed", "600")) * 1000;
        Object object2 = this.p;
        synchronized (object2) {
            StopWatch watch = new StopWatch();
            watch.start();
            if (this.c() == -1L) {
                sendKeepLinkOpen = true;
            }
            if (!sendKeepLinkOpen && System.currentTimeMillis() - this.c() > 4000L) {
                sendKeepLinkOpen = true;
            }
            Logger.getInstance().logDebug("in sendMessageA--before processMsg", null, this.getGatewayId());
            if (!this.a(msg, null)) {
                return false;
            }
            if (this.getModemDriver().isOccurFull()) {
                Logger.getInstance().logInfo("\u77ed\u4fe1\u6c60\u5df2\u6ee1,\u7b49\u5f85\u5904\u7406,\u53d1\u9001\u88ab\u6682\u505c", null, this.getGatewayId());
                if (!this.threadWait(6000L)) {
                    // empty if block
                }
                return false;
            }
            Logger.getInstance().logDebug("in sendMessageA--after processMsg", null, this.getGatewayId());
            object = this.getDriver().getSYNCCommander();
            synchronized (object) {
                Logger.getInstance().logInfo("send command lock", null, this.getGatewayId());
                if (this.getModemDriver().isOccurTimeoutError()) {
                    return false;
                }
                int nums = this.getAtHandler().getSimNums();
                if (this.threadWait(Integer.valueOf(JDSMSServer.getInstance().getProperties().getString("settings.seek_time", "1000")).intValue()) && (nums = this.getAtHandler().getSimNums()) > 0) {
                    Logger.getInstance().logInfo("\u83b7\u53d6\u5230\u7684\u77ed\u4fe1\u6570\u91cf\u4e3a" + nums, null, this.getGatewayId());
                    return false;
                }
                if (sendKeepLinkOpen) {
                    this.getAtHandler().keepLinkOpen();
                }
                this.a(System.currentTimeMillis());
                flag = this.getProtocol() == AGatewayHelper.Protocols.PDU ? this.b(msg) : (this.getProtocol() == AGatewayHelper.Protocols.TEXT ? this.a(msg) : false);
                Logger.getInstance().logInfo("send command unlock", null, this.getGatewayId());
            }
            if (flag) {
                SerialModemBean bean = DeviceInfoCache.getInstance().get(this.getGatewayId());
                String serialnum = "";
                serialnum = bean.getSerialnum();
                if (serialnum.trim().length() <= 0) {
                    serialnum = bean.getManufacturer().equalsIgnoreCase("Wavecom") && !bean.getModel().equalsIgnoreCase("WISMOQCDMA") ? this.getSerialNumber() : this.getSerialNo();
                }
                if (serialnum.indexOf("N/A") >= 0) {
                    throw new GatewayException("\u83b7\u53d6\u8bbe\u5907\u5e8f\u5217\u53f7\u5931\u8d25");
                }
                int num = NewAuth.getAvaliableNum(serialnum);
                --num;
                try {
                    NewAuth.updateAvaliableNum(serialnum, num);
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            watch.stop();
            if (interval - watch.getTime() <= 0L || !this.threadWait(interval - watch.getTime())) {
                // empty if block
            }
        }
        if (flag) {
            int nExMode = Integer.valueOf(JDSMSServer.getInstance().getProperties().getString("settings.exnotify_mode", "0"));
            int nRingLen = Integer.valueOf(JDSMSServer.getInstance().getProperties().getString("settings.ring_length", "10"));
            if (1 == nExMode) {
                object = this.getDriver().getSYNCCommander();
                synchronized (object) {
                    this.getAtHandler().doExRing(msg.getRecipient(), nRingLen);
                }
            }
            if (2 == nExMode) {
                object = this.getDriver().getSYNCCommander();
                synchronized (object) {
                    this.getAtHandler().doExVoice(msg.getRecipient(), msg.getText(), nRingLen);
                }
            }
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteMessage(InboundMessage msg) throws TimeoutException, GatewayException, IOException, InterruptedException {
        if (this.getStatus() != AGatewayHelper.GatewayStatuses.STARTED) {
            return false;
        }
        Object object = this.getDriver().getSYNCCommander();
        synchronized (object) {
            if (msg.getMemIndex() >= 0) {
                return this.a(msg.getMemIndex(), msg.getMemLocation());
            }
            if (msg.getMemIndex() == -1 && msg.getMpMemIndex().length() != 0) {
                StringTokenizer tokens = new StringTokenizer(msg.getMpMemIndex(), ",");
                while (tokens.hasMoreTokens()) {
                    this.a(Integer.parseInt(tokens.nextToken()), msg.getMemLocation());
                }
            }
            return true;
        }
    }

    @Override
    public int readPhonebook(Phonebook phonebook) throws TimeoutException, GatewayException, IOException, InterruptedException {
        int count = 0;
        String locations = this.getATHandler().readPhonebookLocations();
        if (locations.length() > 0) {
            StringTokenizer tokens = new StringTokenizer(locations, ",");
            while (tokens.hasMoreTokens()) {
                String location = tokens.nextToken().replaceAll("\"", "");
                String entries = this.getATHandler().readPhonebook(location);
                if (entries == null || entries.trim().length() == 0) continue;
                BufferedReader reader = new BufferedReader(new StringReader(entries));
                String entry = reader.readLine().trim();
                while (!entry.equalsIgnoreCase("OK")) {
                    entry = entry.replaceAll("\\s*\\+CPBR:\\s*", "");
                    entry = entry.replaceAll("\"\"", "\" \"");
                    StringTokenizer tokens4 = new StringTokenizer(entry = entry.replaceAll("\"", ""), ",");
                    String index = tokens4.nextToken();
                    index = index == null ? "" : index.trim();
                    String phone = tokens4.nextToken();
                    phone = phone == null ? "" : phone.trim();
                    String type = tokens4.nextToken();
                    type = type == null ? "" : type.trim();
                    String name = tokens4.nextToken();
                    name = name == null ? "" : name.trim();
                    phonebook.getContacts().add(new Contact(name, phone, location, Integer.parseInt(index)));
                    ++count;
                    entry = reader.readLine().trim();
                }
                reader.close();
            }
        }
        return count;
    }

    private boolean a(int memIndex, String memLocation) throws TimeoutException, GatewayException, IOException, InterruptedException {
        return this.getATHandler().deleteMessage(memIndex, memLocation);
    }

    private boolean a(OutboundMessage msg) throws TimeoutException, GatewayException, IOException, InterruptedException {
        Logger.getInstance().logDebug("in sendMessageTEXT", null, this.getGatewayId());
        boolean ok = false;
        int refNo = this.getATHandler().sendMessage(0, "", msg.getRecipient(), msg.getText());
        int nSplitNum = this.getATHandler().getTextSplitNum(msg.getText());
        msg.setSplitNum(nSplitNum);
        if (refNo >= 0) {
            msg.setGatewayId(this.getGatewayId());
            msg.setRefNo("" + refNo);
            msg.setDispatchDate(new Date());
            msg.setMessageStatus(OutboundMessage.MessageStatuses.SENT);
            this.incOutboundMessageCount();
            ok = true;
        } else {
            msg.setRefNo(null);
            msg.setDispatchDate(null);
            msg.setMessageStatus(OutboundMessage.MessageStatuses.FAILED);
            msg.setErrorMessage(this.a.getLastErrorText());
        }
        return ok;
    }

    private void a(Collection<InboundMessage> msgList, InboundMessage.MessageClasses msgClass, int myLimit) throws TimeoutException, GatewayException, IOException, InterruptedException {
        int limit = myLimit < 0 ? 0 : myLimit;
        Calendar cal1 = Calendar.getInstance();
        Calendar cal2 = Calendar.getInstance();
        for (int ml = 0; ml < this.getATHandler().getStorageLocations().length() / 2; ++ml) {
            InboundMessage msg;
            String msgText;
            String originator;
            StringTokenizer tokens;
            String tmpLine;
            int memIndex;
            int j2;
            int i2;
            String line;
            if (!this.getATHandler().switchStorageLocation(this.getATHandler().getStorageLocations().substring(ml * 2, ml * 2 + 2))) continue;
            String response = this.getATHandler().listMessages(msgClass);
            if (response.startsWith("OK") && response.length() < 10) {
                return;
            }
            BufferedReader reader = new BufferedReader(new StringReader(response));
            if (response.startsWith("^HCMGR")) {
                while ((line = reader.readLine()) != null && (line = line.trim()).length() <= 0) {
                }
                while (line != null && line.length() > 0 && !line.equalsIgnoreCase("OK")) {
                    i2 = line.indexOf(58);
                    j2 = line.indexOf(44);
                    memIndex = 0;
                    if (line.indexOf("#") + 1 >= line.lastIndexOf("#")) break;
                    try {
                        memIndex = Integer.parseInt(line.substring(line.indexOf("#") + 1, line.lastIndexOf("#")).trim());
                    }
                    catch (NumberFormatException e2) {
                        Logger.getInstance().logWarn("Incorrect Memory Index number parsed!", e2, this.getGatewayId());
                    }
                    tmpLine = "";
                    tokens = new StringTokenizer(line, ",");
                    tokens.nextToken();
                    originator = line.substring(line.indexOf(":") + 1, line.indexOf(",")).trim();
                    cal1.set(1, Integer.parseInt(tokens.nextToken().trim()));
                    cal1.set(2, Integer.parseInt(tokens.nextToken().trim()) - 1);
                    cal1.set(5, Integer.parseInt(tokens.nextToken().trim()));
                    cal1.set(11, Integer.parseInt(tokens.nextToken().trim()));
                    cal1.set(12, Integer.parseInt(tokens.nextToken().trim()));
                    cal1.set(13, Integer.parseInt(tokens.nextToken().trim()));
                    msgText = "";
                    while ((tmpLine = reader.readLine()) != null && !tmpLine.startsWith("^HCMGR") && !tmpLine.startsWith("^HCMGL")) {
                        msgText = msgText + (msgText.length() == 0 ? "" : "\n") + tmpLine;
                    }
                    line = tmpLine;
                    msgText = msgText.trim();
                    msgText = msgText.replaceAll(String.valueOf('\u001a'), "");
                    msgText = msgText.replaceAll("\nOK", "");
                    msg = new InboundMessage(cal1.getTime(), originator, msgText, memIndex, this.getATHandler().getStorageLocations().substring(ml * 2, ml * 2 + 2));
                    msg.setGatewayId(this.getGatewayId());
                    Logger.getInstance().logDebug("IN-DTLS: MI:" + msg.getMemIndex(), null, this.getGatewayId());
                    msg.setCdmaFlag(true);
                    msgList.add(msg);
                    this.incInboundMessageCount();
                    do {
                        String string = line = tmpLine == null || tmpLine.length() == 0 ? reader.readLine() : tmpLine;
                    } while (line != null && (line = line.trim()).length() <= 0);
                    if (limit <= 0 || msgList.size() != limit) continue;
                }
                reader.close();
                continue;
            }
            while ((line = reader.readLine()) != null && (line = line.trim()).length() <= 0) {
            }
            while (line != null && line.length() > 0) {
                String dateStr;
                i2 = line.indexOf(58);
                j2 = line.indexOf(44);
                memIndex = 0;
                try {
                    memIndex = Integer.parseInt(line.substring(i2 + 1, j2).trim());
                }
                catch (NumberFormatException e3) {
                    Logger.getInstance().logWarn("Incorrect Memory Index number parsed!", e3, this.getGatewayId());
                }
                tokens = new StringTokenizer(line, ",");
                tokens.nextToken();
                tokens.nextToken();
                tmpLine = "";
                if (Character.isDigit(tokens.nextToken().trim().charAt(0))) {
                    line = line.replaceAll(",,", ", ,");
                    tokens = new StringTokenizer(line, ",");
                    tokens.nextToken();
                    tokens.nextToken();
                    tokens.nextToken();
                    String refNo = tokens.nextToken();
                    tokens.nextToken();
                    dateStr = tokens.nextToken().replaceAll("\"", "");
                    cal1.set(1, 2000 + Integer.parseInt(dateStr.substring(0, 2)));
                    cal1.set(2, Integer.parseInt(dateStr.substring(3, 5)) - 1);
                    cal1.set(5, Integer.parseInt(dateStr.substring(6, 8)));
                    dateStr = tokens.nextToken().replaceAll("\"", "");
                    cal1.set(11, Integer.parseInt(dateStr.substring(0, 2)));
                    cal1.set(12, Integer.parseInt(dateStr.substring(3, 5)));
                    cal1.set(13, Integer.parseInt(dateStr.substring(6, 8)));
                    dateStr = tokens.nextToken().replaceAll("\"", "");
                    cal2.set(1, 2000 + Integer.parseInt(dateStr.substring(0, 2)));
                    cal2.set(2, Integer.parseInt(dateStr.substring(3, 5)) - 1);
                    cal2.set(5, Integer.parseInt(dateStr.substring(6, 8)));
                    dateStr = tokens.nextToken().replaceAll("\"", "");
                    cal2.set(11, Integer.parseInt(dateStr.substring(0, 2)));
                    cal2.set(12, Integer.parseInt(dateStr.substring(3, 5)));
                    cal2.set(13, Integer.parseInt(dateStr.substring(6, 8)));
                    msg = new StatusReportMessage(refNo, memIndex, this.getATHandler().getStorageLocations().substring(ml * 2, ml * 2 + 2), cal1.getTime(), cal2.getTime());
                    msg.setGatewayId(this.getGatewayId());
                    Logger.getInstance().logDebug("IN-DTLS: MI:" + msg.getMemIndex(), null, this.getGatewayId());
                    msgList.add(msg);
                    this.incInboundMessageCount();
                } else {
                    line = line.replaceAll(",,", ", ,");
                    tokens = new StringTokenizer(line, ",");
                    tokens.nextToken();
                    tokens.nextToken();
                    originator = tokens.nextToken().replaceAll("\"", "");
                    tokens.nextToken();
                    dateStr = tokens.nextToken().replaceAll("\"", "");
                    cal1.set(1, 2000 + Integer.parseInt(dateStr.substring(0, 2)));
                    cal1.set(2, Integer.parseInt(dateStr.substring(3, 5)) - 1);
                    cal1.set(5, Integer.parseInt(dateStr.substring(6, 8)));
                    dateStr = tokens.nextToken().replaceAll("\"", "");
                    cal1.set(11, Integer.parseInt(dateStr.substring(0, 2)));
                    cal1.set(12, Integer.parseInt(dateStr.substring(3, 5)));
                    cal1.set(13, Integer.parseInt(dateStr.substring(6, 8)));
                    msgText = "";
                    while ((tmpLine = reader.readLine()) != null && !tmpLine.startsWith("+CMGL") && !tmpLine.startsWith("+CMGR")) {
                        msgText = msgText + (msgText.length() == 0 ? "" : "\n") + tmpLine;
                    }
                    line = tmpLine;
                    msgText = msgText.trim();
                    msgText = msgText.replaceAll("(\n)+OK", "");
                    msg = new InboundMessage(cal1.getTime(), originator, msgText, memIndex, this.getATHandler().getStorageLocations().substring(ml * 2, ml * 2 + 2));
                    msg.setGatewayId(this.getGatewayId());
                    Logger.getInstance().logDebug("IN-DTLS: MI:" + msg.getMemIndex(), null, this.getGatewayId());
                    msgList.add(msg);
                    this.incInboundMessageCount();
                }
                do {
                    String string = line = tmpLine == null || tmpLine.length() == 0 ? reader.readLine() : tmpLine;
                } while (line != null && (line = line.trim()).length() <= 0);
                if (limit <= 0 || msgList.size() != limit) continue;
            }
            reader.close();
        }
    }

    private boolean b(OutboundMessage msg) throws TimeoutException, GatewayException, IOException, InterruptedException {
        Logger.getInstance().logDebug("in sendMessagePDU", null, this.getGatewayId());
        boolean ok = false;
        List<String> pdus = msg.getPdus(this.getSmscNumber(), this.n);
        long interval = 3600 / Integer.parseInt(JDSMSServer.getInstance().getProperties().getString("settings.send_speed", "600")) * 1000;
        msg.setSplitNum(pdus.size());
        Logger.getInstance().logInfo("\u53d1\u9001\u77ed\u4fe1\u6761\u6570" + pdus.size(), null, this.getGatewayId());
        for (int i2 = 0; i2 < pdus.size(); ++i2) {
            StopWatch watch = new StopWatch();
            watch.start();
            String pdu = pdus.get(i2);
            Pdu newPdu = new PduParser().parsePdu(pdu);
            Logger.getInstance().logDebug(newPdu.toString(), null, this.getGatewayId());
            int j2 = pdu.length() / 2;
            if (this.getSmscNumber() != null) {
                if (this.getSmscNumber().length() == 0) {
                    --j2;
                } else {
                    int smscNumberLen = this.getSmscNumber().length();
                    if (this.getSmscNumber().charAt(0) == '+') {
                        --smscNumberLen;
                    }
                    if (smscNumberLen % 2 != 0) {
                        ++smscNumberLen;
                    }
                    int smscLen = (2 + smscNumberLen) / 2;
                    j2 = j2 - smscLen - 1;
                }
            }
            Logger.getInstance().logDebug("Sending Pdu: " + pdu, null, this.getGatewayId());
            Logger.getInstance().logInfo("\u53d1\u9001\u7b2c" + i2 + "\u6761\u77ed\u4fe1", null, this.getGatewayId());
            int refNo = this.getATHandler().sendMessage(j2, pdu, null, null);
            if (refNo >= 0) {
                msg.setGatewayId(this.getGatewayId());
                msg.setRefNo(String.valueOf(refNo));
                msg.setDispatchDate(new Date());
                msg.setMessageStatus(OutboundMessage.MessageStatuses.SENT);
                msg.setFailureCause(OutboundMessage.FailureCauses.NO_ERROR);
                this.incOutboundMessageCount();
                ok = true;
            } else {
                Logger.getInstance().logInfo("\u53d1\u9001\u77ed\u4fe1\u5931\u8d25,\u8fd4\u56de" + refNo, null, this.getGatewayId());
                msg.setRefNo(null);
                msg.setDispatchDate(null);
                msg.setMessageStatus(OutboundMessage.MessageStatuses.FAILED);
                msg.setFailureCause(OutboundMessage.FailureCauses.UNKNOWN);
                ok = false;
                msg.setErrorMessage(this.a.getLastErrorText());
            }
            watch.stop();
            if (interval - watch.getTime() > 0L && this.threadWait(interval - watch.getTime())) continue;
        }
        if (pdus.size() > 1) {
            this.n = (this.n + 1) % 65536;
        }
        return ok;
    }

    private void b(Collection<InboundMessage> msgList, InboundMessage.MessageClasses messageClass, int myLimit) throws Exception {
        SerialModemBean modem = DeviceInfoCache.getInstance().get(this.getGatewayId());
        String ccid = modem.getCcid();
        ArrayList<TmpMsg> TmpMsgList = new ArrayList<TmpMsg>();
        DbHelper helper = DbHelper.getDbHelper(JDSMSServer.getInstance().getProperties(), "db1");
        PduParser parser = new PduParser();
        int limit = myLimit < 0 ? 0 : myLimit;
        for (int ml = 0; ml < this.getATHandler().getStorageLocations().length() / 2; ++ml) {
            String line;
            if (!this.getATHandler().switchStorageLocation(this.getATHandler().getStorageLocations().substring(ml * 2, ml * 2 + 2))) continue;
            String response = this.getATHandler().listMessages(messageClass);
            response = response.replaceAll("\\s+OK\\s+", "\nOK");
            BufferedReader reader = new BufferedReader(new StringReader(response));
            while ((line = reader.readLine()) != null && (line = line.trim()).length() <= 0) {
            }
            while (this.threadWait(1L) && line != null && (line = line.trim()).length() > 0 && !line.equalsIgnoreCase("OK") && line.length() > 0 && !line.equalsIgnoreCase("ERROR")) {
                int breakFlag;
                if (line.indexOf("+CMTI") != -1) {
                    line = reader.readLine();
                    continue;
                }
                if (line.indexOf("^RRCSTAT") != -1) {
                    line = reader.readLine();
                    continue;
                }
                if (line.indexOf("^SMMEMFULL:") != -1) {
                    line = reader.readLine();
                    continue;
                }
                if (line.indexOf("^LENDC:") != -1) {
                    line = reader.readLine();
                    continue;
                }
                if (line.indexOf("+CGREG:") != -1) {
                    line = reader.readLine();
                    continue;
                }
                if (line.indexOf("+C5GREG:") != -1) {
                    line = reader.readLine();
                    continue;
                }
                if (line.indexOf("^LWURC:") != -1) {
                    line = reader.readLine();
                    continue;
                }
                if (line.matches("\\s*OK\\s*")) {
                    line = reader.readLine();
                    continue;
                }
                if (line.indexOf("+CPMS") != -1) {
                    line = reader.readLine();
                    continue;
                }
                int i2 = line.indexOf(58);
                int j2 = line.indexOf(44);
                if (i2 == -1 || j2 == -1) break;
                int memIndex = 0;
                try {
                    memIndex = Integer.parseInt(line.substring(i2 + 1, j2).trim());
                }
                catch (NumberFormatException e2) {
                    Logger.getInstance().logWarn("Incorrect Memory Index number parsed!", e2, this.getGatewayId());
                }
                String pduString = reader.readLine().trim();
                for (breakFlag = 0; pduString.indexOf("+CMTI") != -1 && breakFlag < 3 && this.threadWait(1L); ++breakFlag) {
                    pduString = reader.readLine().trim();
                }
                if (breakFlag >= 3) break;
                try {
                    String memLocation = this.getATHandler().getStorageLocations().substring(ml * 2, ml * 2 + 2);
                    helper.addTmpMsg(pduString, memIndex, memLocation, ml, ccid);
                    TmpMsg tmpMsg = new TmpMsg();
                    tmpMsg.setPdustring(pduString);
                    tmpMsg.setMemindex(memIndex);
                    tmpMsg.setMemlocation(memLocation);
                    tmpMsg.setMl(ml);
                    tmpMsg.setCCID(ccid);
                    TmpMsgList.add(tmpMsg);
                    Logger.getInstance().logDebug("READ PDU: " + pduString, null, this.getGatewayId());
                }
                catch (Exception e3) {
                    e3.printStackTrace();
                }
                while (this.threadWait(1L) && (line = reader.readLine()) != null && (line = line.trim()).length() <= 0) {
                }
                if (limit <= 0 || msgList.size() != limit) continue;
                break;
            }
            reader.close();
        }
        ArrayList<InboundMessage> msgDeleteList = new ArrayList<InboundMessage>();
        for (int index = 0; index < TmpMsgList.size(); ++index) {
            InboundMessage msg;
            TmpMsg tmpMsg = (TmpMsg)TmpMsgList.get(index);
            try {
                Pdu pdu = parser.parsePdu(tmpMsg.getPdustring());
                Logger.getInstance().logDebug("raw pdu:" + tmpMsg.getPdustring(), null, this.getGatewayId());
                Logger.getInstance().logDebug("pdu decode text:" + pdu.getDecodedText(), null, this.getGatewayId());
                if (pdu instanceof SmsDeliveryPdu) {
                    if (pdu.isBinary()) {
                        msg = new InboundBinaryMessage((SmsDeliveryPdu)pdu, tmpMsg.getMemindex(), tmpMsg.getMemlocation(), tmpMsg.getCCID());
                        if (Service.getInstance().getKeyManager().getKey(msg.getOriginator()) != null) {
                            msg = new InboundEncryptedMessage((SmsDeliveryPdu)pdu, tmpMsg.getMemindex(), tmpMsg.getMemlocation(), tmpMsg.getCCID());
                        }
                    } else {
                        msg = new InboundMessage((SmsDeliveryPdu)pdu, tmpMsg.getMemindex(), tmpMsg.getMemlocation(), tmpMsg.getCCID());
                    }
                    msg.setGatewayId(this.getGatewayId());
                    msg.setTmpDeleteFlag(true);
                    if (this.b()) {
                        msg.setFlag4G(true);
                    }
                    msgDeleteList.add(msg);
                    continue;
                }
                if (!(pdu instanceof SmsStatusReportPdu)) continue;
                msg = new StatusReportMessage((SmsStatusReportPdu)pdu, tmpMsg.getMemindex(), this.getATHandler().getStorageLocations().substring(tmpMsg.getMl() * 2, tmpMsg.getMl() * 2 + 2));
                msg.setTmpDeleteFlag(true);
                if (this.b()) {
                    msg.setFlag4G(true);
                }
                msgDeleteList.add(msg);
                continue;
            }
            catch (Exception e4) {
                msg = new UnknownMessage(tmpMsg.getPdustring(), tmpMsg.getMemindex(), this.getATHandler().getStorageLocations().substring(tmpMsg.getMl() * 2, tmpMsg.getMl() * 2 + 2));
                msg.setGatewayId(this.getGatewayId());
                msg.setTmpDeleteFlag(true);
                if (this.b()) {
                    msg.setFlag4G(true);
                }
                msgDeleteList.add(msg);
            }
        }
        List<TmpMsg> tmpMsgList = helper.getTmpMsg(true, ccid);
        this.o = new ArrayList<List<InboundMessage>>();
        int index = 1;
        for (int i1 = 0; i1 < tmpMsgList.size(); ++i1) {
            UnknownMessage msg;
            TmpMsg tmpMsg = tmpMsgList.get(i1);
            Pdu pdu = null;
            try {
                InboundMessage msg2;
                try {
                    pdu = parser.parsePdu(tmpMsg.getPdustring());
                }
                catch (Exception e5) {
                    msg = new UnknownMessage(tmpMsg.getPdustring(), tmpMsg.getMemindex(), this.getATHandler().getStorageLocations().substring(tmpMsg.getMl() * 2, tmpMsg.getMl() * 2 + 2));
                    msg.setGatewayId(this.getGatewayId());
                    msg.setTmpFlag(false);
                    msg.setTmpMsgId(tmpMsg.getId());
                    msg.setTmpDeleteFlag(false);
                    msgList.add(msg);
                    helper.deleteTmpMsg(msg.getTmpMsgId());
                    this.incInboundMessageCount();
                    Logger.getInstance().logError("Unhandled SMS in inbox, skipping...", e5, this.getGatewayId());
                    Logger.getInstance().logError("ERROR PDU: " + tmpMsg.getPdustring(), null, this.getGatewayId());
                    continue;
                }
                if (pdu instanceof SmsDeliveryPdu) {
                    if (pdu.isBinary()) {
                        msg2 = new InboundBinaryMessage((SmsDeliveryPdu)pdu, tmpMsg.getMemindex(), tmpMsg.getMemlocation(), tmpMsg.getCCID());
                        if (Service.getInstance().getKeyManager().getKey(msg2.getOriginator()) != null) {
                            msg2 = new InboundEncryptedMessage((SmsDeliveryPdu)pdu, tmpMsg.getMemindex(), tmpMsg.getMemlocation(), tmpMsg.getCCID());
                        }
                    } else {
                        msg2 = new InboundMessage((SmsDeliveryPdu)pdu, tmpMsg.getMemindex(), tmpMsg.getMemlocation(), tmpMsg.getCCID());
                    }
                    if (!(msg2 instanceof InboundBinaryMessage)) {
                        Logger.getInstance().logDebug("index:" + index, null, this.getGatewayId());
                        Logger.getInstance().logDebug("PDU:" + tmpMsg.getPdustring(), null, this.getGatewayId());
                        Logger.getInstance().logDebug("\u6765\u6e90\u53f7\u7801:" + msg2.getOriginator(), null, this.getGatewayId());
                        Logger.getInstance().logDebug("\u5185\u5bb9:" + msg2.getText(), null, this.getGatewayId());
                        Logger.getInstance().logDebug("refno:" + msg2.getMpRefNo(), null, this.getGatewayId());
                        Logger.getInstance().logDebug("MaxMp:" + msg2.getMpMaxNo(), null, this.getGatewayId());
                        Logger.getInstance().logDebug("seqno:" + msg2.getMpSeqNo(), null, this.getGatewayId());
                    }
                    ++index;
                    msg2.setGatewayId(this.getGatewayId());
                    msg2.setTmpFlag(true);
                    msg2.setTmpMsgId(tmpMsg.getId());
                    msg2.setTmpDeleteFlag(false);
                    if (msg2.getMpRefNo() == 0 && msg2.getMpMaxNo() <= 1) {
                        msg2.setTmpFlag(false);
                        msgList.add(msg2);
                        helper.deleteTmpMsg(msg2.getTmpMsgId());
                        this.incInboundMessageCount();
                        continue;
                    }
                    List<InboundMessage> tmpList = null;
                    boolean found = false;
                    for (int k2 = 0; k2 < this.o.size(); ++k2) {
                        tmpList = this.o.get(k2);
                        InboundMessage listMsg = tmpList.get(0);
                        int diffhours = Integer.parseInt(JDSMSServer.getInstance().getProperties().getString("settings.recvdiff", "5"));
                        boolean flag = false;
                        if ((long)(diffhours * 3600) * 1000L > Math.abs(listMsg.getDate().getTime() - msg2.getDate().getTime())) {
                            flag = true;
                        }
                        if (!flag || listMsg.getMpRefNo() != msg2.getMpRefNo() || listMsg.getMpMaxNo() != msg2.getMpMaxNo() || !msg2.getOriginator().equals(listMsg.getOriginator()) || !msg2.getCCID().equals(listMsg.getCCID())) continue;
                        boolean duplicate = false;
                        for (int l2 = 0; l2 < tmpList.size(); ++l2) {
                            listMsg = tmpList.get(l2);
                            if (listMsg.getMpSeqNo() != msg2.getMpSeqNo()) continue;
                            duplicate = true;
                            break;
                        }
                        if (!duplicate) {
                            tmpList.add(msg2);
                        }
                        found = true;
                        break;
                    }
                    if (found) continue;
                    tmpList = new ArrayList<InboundMessage>();
                    tmpList.add(msg2);
                    this.o.add(tmpList);
                    continue;
                }
                if (pdu instanceof SmsStatusReportPdu) {
                    msg2 = new StatusReportMessage((SmsStatusReportPdu)pdu, tmpMsg.getMemindex(), this.getATHandler().getStorageLocations().substring(tmpMsg.getMl() * 2, tmpMsg.getMl() * 2 + 2));
                    msg2.setGatewayId(this.getGatewayId());
                    msg2.setTmpFlag(false);
                    msg2.setTmpMsgId(tmpMsg.getId());
                    msg2.setTmpDeleteFlag(false);
                    msgList.add(msg2);
                    helper.deleteTmpMsg(msg2.getTmpMsgId());
                    this.incInboundMessageCount();
                    continue;
                }
                if (!this.q) continue;
                Logger.getInstance().logError("Wrong type of PDU detected: " + pdu.getClass().getName(), null, this.getGatewayId());
                Logger.getInstance().logError("ERROR PDU: " + tmpMsg.getPdustring(), null, this.getGatewayId());
                continue;
            }
            catch (Exception e6) {
                msg = new UnknownMessage(tmpMsg.getPdustring(), tmpMsg.getMemindex(), this.getATHandler().getStorageLocations().substring(tmpMsg.getMl() * 2, tmpMsg.getMl() * 2 + 2));
                msg.setGatewayId(this.getGatewayId());
                msg.setTmpFlag(false);
                msg.setTmpMsgId(tmpMsg.getId());
                msg.setTmpDeleteFlag(false);
                msgList.add(msg);
                helper.deleteTmpMsg(msg.getTmpMsgId());
                this.incInboundMessageCount();
                Logger.getInstance().logError("Unhandled SMS in inbox, skipping...", e6, this.getGatewayId());
                Logger.getInstance().logError("ERROR PDU: " + tmpMsg.getPdustring(), null, this.getGatewayId());
            }
        }
        this.a(msgList);
        msgList.addAll(msgDeleteList);
    }

    public void setDisplayIllegalReceivedMessages(boolean b2) {
        this.q = b2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMessageByIndex(int msgIndex) throws TimeoutException, GatewayException, IOException, InterruptedException {
        Object object = this.getDriver().getSYNCCommander();
        synchronized (object) {
            return this.getATHandler().getMessageByIndex(msgIndex);
        }
    }

    private void a(Collection<InboundMessage> msgList) throws TimeoutException, GatewayException, IOException, InterruptedException {
        DbHelper helper = null;
        try {
            helper = DbHelper.getDbHelper(JDSMSServer.getInstance().getProperties(), "db1");
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        InboundMessage mpMsg = null;
        Logger.getInstance().logDebug("CheckMpMsgList(): MAINLIST: " + this.o.size(), null, this.getGatewayId());
        for (int k2 = 0; k2 < this.o.size(); ++k2) {
            List<InboundMessage> tmpList = this.o.get(k2);
            Logger.getInstance().logDebug("CheckMpMsgList(): SUBLIST[" + k2 + "]: " + tmpList.size(), null, this.getGatewayId());
            InboundMessage listMsg = tmpList.get(0);
            boolean found = false;
            if (listMsg.getMpMaxNo() == tmpList.size()) {
                found = true;
                block9: for (int l2 = 0; l2 < tmpList.size(); ++l2) {
                    for (int m2 = 0; m2 < tmpList.size(); ++m2) {
                        listMsg = tmpList.get(m2);
                        if (listMsg.getMpSeqNo() != l2 + 1) continue;
                        if (listMsg.getMpSeqNo() == 1) {
                            mpMsg = listMsg;
                            mpMsg.setMpMemIndex(mpMsg.getMemIndex());
                            if (listMsg.getMpMaxNo() != 1) continue block9;
                            msgList.add(mpMsg);
                            try {
                                for (int i2 = 0; i2 < tmpList.size(); ++i2) {
                                    helper.deleteTmpMsg(tmpList.get(i2).getTmpMsgId());
                                }
                            }
                            catch (Exception e2) {
                                e2.printStackTrace();
                            }
                            this.incInboundMessageCount();
                            continue block9;
                        }
                        if (mpMsg == null) continue block9;
                        if (mpMsg instanceof InboundBinaryMessage) {
                            InboundBinaryMessage mpMsgBinary = (InboundBinaryMessage)mpMsg;
                            InboundBinaryMessage listMsgBinary = (InboundBinaryMessage)listMsg;
                            mpMsgBinary.addDataBytes(listMsgBinary.getDataBytes());
                        } else {
                            String textToAdd = listMsg.getText();
                            if (mpMsg.getEndsWithMultiChar()) {
                                Logger.getInstance().logDebug("Adjusting dangling multi-char: " + textToAdd.charAt(0) + " --> " + PduUtils.getMultiCharFor(textToAdd.charAt(0)), null, this.getGatewayId());
                                textToAdd = PduUtils.getMultiCharFor(textToAdd.charAt(0)) + textToAdd.substring(1);
                            }
                            mpMsg.setEndsWithMultiChar(listMsg.getEndsWithMultiChar());
                            try {
                                mpMsg.addText(textToAdd);
                            }
                            catch (UnsupportedEncodingException unsupportedEncodingException) {
                                // empty catch block
                            }
                        }
                        mpMsg.setMpSeqNo(listMsg.getMpSeqNo());
                        mpMsg.setMpMemIndex(listMsg.getMemIndex());
                        if (listMsg.getMpSeqNo() != listMsg.getMpMaxNo()) continue block9;
                        mpMsg.setMemIndex(-1);
                        msgList.add(mpMsg);
                        try {
                            for (int i3 = 0; i3 < tmpList.size(); ++i3) {
                                helper.deleteTmpMsg(tmpList.get(i3).getTmpMsgId());
                            }
                        }
                        catch (Exception e3) {
                            e3.printStackTrace();
                        }
                        this.incInboundMessageCount();
                        mpMsg = null;
                        continue block9;
                    }
                }
                tmpList.clear();
                tmpList = null;
            }
            if (!found) continue;
            this.o.remove(k2);
            --k2;
        }
    }

    private long c() {
        return this.g;
    }

    private void a(long lastKeepLinkOpen) {
        this.g = lastKeepLinkOpen;
    }

    public void setSimPin(String mySimPin) {
        this.j = mySimPin;
    }

    public void setSimPin2(String mySimPin2) {
        this.k = mySimPin2;
    }

    public String getSimPin() {
        return this.j;
    }

    public String getSimPin2() {
        return this.k;
    }

    public AModemDriver getModemDriver() {
        return this.a;
    }

    public AATHandler getATHandler() {
        return this.b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getManufacturer() throws TimeoutException, GatewayException, IOException, InterruptedException {
        Object object = this.getDriver().getSYNCCommander();
        synchronized (object) {
            String response = this.getATHandler().getManufacturer();
            if (response.indexOf("ERROR") >= 0) {
                return "N/A";
            }
            response = response.replaceAll("\\s+OK\\s+", "");
            return response;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getModel() throws TimeoutException, GatewayException, IOException, InterruptedException {
        Object object = this.getDriver().getSYNCCommander();
        synchronized (object) {
            String response = this.getATHandler().getModel();
            if (response.indexOf("ERROR") >= 0) {
                return "N/A";
            }
            response = response.replaceAll("\\s+OK\\s+", "");
            return response;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSerialNo() throws TimeoutException, GatewayException, IOException, InterruptedException {
        Object object = this.getDriver().getSYNCCommander();
        synchronized (object) {
            String response = this.getATHandler().getSerialNo();
            if (response.indexOf("ERROR") >= 0) {
                return "N/A";
            }
            response = response.replaceAll("\\s+OK\\s+", "");
            response = response.replaceAll("\\+CGSN:", "");
            return response.trim();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getImsi() throws TimeoutException, GatewayException, IOException, InterruptedException {
        if (Service.getInstance().getSettings().MASK_IMSI) {
            return "** MASKED **";
        }
        Object object = this.getDriver().getSYNCCommander();
        synchronized (object) {
            String response = this.getATHandler().getImsi();
            if (response.indexOf("ERROR") >= 0) {
                return "N/A";
            }
            response = response.replaceAll("\\s+OK\\s+", "");
            return response;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSwVersion() throws TimeoutException, GatewayException, IOException, InterruptedException {
        Object object = this.getDriver().getSYNCCommander();
        synchronized (object) {
            String response = this.getATHandler().getSwVersion();
            if (response.indexOf("ERROR") >= 0) {
                return "N/A";
            }
            response = response.replaceAll("\\s+OK\\s+", "");
            return response;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean a() throws TimeoutException, GatewayException, IOException, InterruptedException {
        Object object = this.getDriver().getSYNCCommander();
        synchronized (object) {
            return this.getATHandler().getGprsStatus().matches("\\+CGATT[\\p{ASCII}]*1\\sOK\\s");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getBatteryLevel() throws TimeoutException, GatewayException, IOException, InterruptedException {
        Object object = this.getDriver().getSYNCCommander();
        synchronized (object) {
            String response = this.getATHandler().getBatteryLevel();
            if (response.indexOf("ERROR") >= 0) {
                return 0;
            }
            Matcher m2 = Pattern.compile("\\+CBC: (\\d+),\\s*(\\d+)").matcher(response);
            if (m2.find()) {
                return Integer.parseInt(m2.group(2));
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSignalLevel() throws TimeoutException, GatewayException, IOException, InterruptedException {
        Object object = this.getDriver().getSYNCCommander();
        synchronized (object) {
            String response = this.getATHandler().getSignalLevel();
            if (response.indexOf("ERROR") >= 0) {
                return 0;
            }
            response = response.replaceAll("\\s+OK\\s+", "");
            StringTokenizer tokens = new StringTokenizer(response, ":,");
            tokens.nextToken();
            Integer rssi_code = Integer.parseInt(tokens.nextToken().trim());
            if (rssi_code == 99) {
                return 99;
            }
            return -113 + 2 * rssi_code;
        }
    }

    public String getSmscNumber() {
        return this.m;
    }

    public void setSmscNumber(String mySmscNumber) {
        this.m = mySmscNumber;
    }

    public String getCustomInitString() {
        return this.l;
    }

    public void setCustomInitString(String myCustomInitString) {
        this.l = myCustomInitString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String sendCustomATCommand(String atCommand) throws GatewayException, TimeoutException, IOException, InterruptedException {
        Object object = this.getDriver().getSYNCCommander();
        synchronized (object) {
            return this.getATHandler().sendCustomATCommand(atCommand);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String sendUSSDCommand(String ussdCommand) throws GatewayException, TimeoutException, IOException, InterruptedException {
        Object object = this.getDriver().getSYNCCommander();
        synchronized (object) {
            return this.getATHandler().sendUSSDCommand(ussdCommand);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String sendUSSDCommand(String ussdCommand, boolean interactive) throws GatewayException, TimeoutException, IOException, InterruptedException {
        Object object = this.getDriver().getSYNCCommander();
        synchronized (object) {
            return this.getATHandler().sendUSSDCommand(ussdCommand, interactive);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean sendUSSDRequest(USSDRequest request) throws GatewayException, TimeoutException, IOException, InterruptedException {
        Object object = this.getDriver().getSYNCCommander();
        synchronized (object) {
            return this.getATHandler().sendUSSDRequest(Integer.toString(request.getResultPresentation().getNumeric()), request.getContent(), Integer.toString(request.getDcs().getNumeric()));
        }
    }

    public AModemDriver getDriver() {
        return this.a;
    }

    protected void setDriver(AModemDriver myDriver) {
        this.a = myDriver;
    }

    public AATHandler getAtHandler() {
        return this.b;
    }

    protected void setAtHandler(AATHandler myAtHandler) {
        this.b = myAtHandler;
    }

    protected String getModemDevice() {
        return this.c;
    }

    protected void setModemDevice(String myModemDevice) {
        this.c = myModemDevice;
    }

    protected int getModemParms() {
        return this.d;
    }

    protected void setModemParms(int myModemParms) {
        this.d = myModemParms;
    }

    protected int getAgeInHours(Date messageDate) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        long now = cal.getTimeInMillis();
        cal.setTime(messageDate);
        long past = cal.getTimeInMillis();
        return (int)((now - past) / 3600000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSerialNumber() throws TimeoutException, GatewayException, IOException, InterruptedException {
        Object object = this.getDriver().getSYNCCommander();
        synchronized (object) {
            String response = this.getATHandler().getSerialNumber();
            if (response.indexOf("ERROR") >= 0) {
                return "N/A";
            }
            response = response.replaceAll("\\s+OK\\s+", "");
            String[] tmp = response.split(" ");
            return tmp[tmp.length - 1];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSerialNumber1() throws TimeoutException, GatewayException, IOException, InterruptedException {
        Object object = this.getDriver().getSYNCCommander();
        synchronized (object) {
            String response = this.getATHandler().getSerialNo();
            if (response.indexOf("ERROR") >= 0) {
                return null;
            }
            response = response.replaceAll("\\s+OK\\s+", "");
            String[] tmp = response.split(" ");
            return tmp[tmp.length - 1];
        }
    }

    @Override
    public int getQueueSchedulingInterval() {
        return 5000;
    }

    public static enum IPProtocols {
        TEXT,
        BINARY;

    }

    public static enum ModemTypes {
        SERIAL,
        IP;

    }
}

