/*
 * Decompiled with CFR 0.152.
 */
package cn.sendsms.modem.athandler;

import cn.sendsms.GatewayException;
import cn.sendsms.InboundMessage;
import cn.sendsms.Service;
import cn.sendsms.TimeoutException;
import cn.sendsms.helper.AGatewayHelper;
import cn.sendsms.modem.ModemGateway;
import cn.sendsms.modem.athandler.ATHandler;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ATHandler_Huawei_MH5000_31
extends ATHandler {
    public ATHandler_Huawei_MH5000_31(ModemGateway myGateway) {
        super(myGateway);
    }

    @Override
    public String getCCID() throws TimeoutException, GatewayException, IOException, InterruptedException {
        String response = "";
        this.getModemDriver().write("AT^ICCID?\r");
        this.threadWait(Service.getInstance().getSettings().AT_WAIT);
        int reReadTimes = 0;
        response = this.getModemDriver().getResponse();
        while (!response.contains("^ICCID") || this.b(response)) {
            response = response + this.getModemDriver().getResponse();
            if (++reReadTimes > 15) break;
            this.threadWait(Service.getInstance().getSettings().AT_WAIT);
        }
        if (!response.contains("^ICCID")) {
            response = "";
        }
        return response;
    }

    @Override
    public String getCSQ() throws TimeoutException, GatewayException, IOException, InterruptedException {
        String matchStr;
        Pattern signalPattern;
        Matcher signalMatcher;
        String response = "";
        this.getModemDriver().write("AT+CSQ\r");
        this.threadWait(Service.getInstance().getSettings().AT_WAIT);
        int reReadTimes = 0;
        response = this.getModemDriver().getResponse();
        while (!response.contains("+CSQ") || this.b(response)) {
            response = response + this.getModemDriver().getResponse();
            if (++reReadTimes > 15) break;
            this.threadWait(Service.getInstance().getSettings().AT_WAIT);
        }
        if ((signalMatcher = (signalPattern = Pattern.compile(matchStr = "\\+CSQ:\\s*\\d{1,2},\\d{1,2}")).matcher(response)).find()) {
            response = signalMatcher.group(0);
            return response + "\r";
        }
        return "";
    }

    @Override
    public void keepLinkOpen() throws TimeoutException, GatewayException, IOException, InterruptedException {
    }

    @Override
    public String listMessages(InboundMessage.MessageClasses messageClass) throws TimeoutException, GatewayException, IOException, InterruptedException {
        if (this.getGateway().getProtocol() == AGatewayHelper.Protocols.PDU) {
            if (messageClass == InboundMessage.MessageClasses.ALL) {
                this.getModemDriver().write("AT+CMGL=4\r");
            } else if (messageClass == InboundMessage.MessageClasses.UNREAD) {
                this.getModemDriver().write("AT+CMGL=0\r");
            } else if (messageClass == InboundMessage.MessageClasses.READ) {
                this.getModemDriver().write("AT+CMGL=1\r");
            }
        } else if (this.getGateway().getProtocol() == AGatewayHelper.Protocols.TEXT) {
            if (messageClass == InboundMessage.MessageClasses.ALL) {
                this.getModemDriver().write("AT+CMGL=\"ALL\"\r");
            } else if (messageClass == InboundMessage.MessageClasses.UNREAD) {
                this.getModemDriver().write("AT+CMGL=\"REC UNREAD\"\r");
            } else if (messageClass == InboundMessage.MessageClasses.READ) {
                this.getModemDriver().write("AT+CMGL=\"REC READ\"\r");
            }
        }
        int reReadTimes = 0;
        String response = this.getModemDriver().getResponse();
        while (this.a(response)) {
            response = response + this.getModemDriver().getResponse();
            if (++reReadTimes > 15) {
                return response;
            }
            this.threadWait(Service.getInstance().getSettings().AT_WAIT);
        }
        return response;
    }

    private boolean a(String response) {
        String needfilteredInfoRegex1 = "\\^LENDC: ([0-9]+,){4}([0-9]+)\\s*OK";
        String needfilteredInfoRegex2 = "\\^HFREQINFO: ([0-9]+,){8}([0-9]+)\\s*OK";
        String needfilteredInfoRegex3 = "\\+CMGS: [0-9]+\\s*OK";
        String needfilteredInfoRegex4 = "\\+CPMS: (\"[SME]{2}\",[0-9]{1,2},[0-9]{1,2},){2}(\"[SME]{2}\",[0-9]{1,2},[0-9]{1,2})\\s*OK";
        if (response == null || response.equals("")) {
            return true;
        }
        if (response.contains("OK")) {
            return !response.replaceAll(needfilteredInfoRegex1, "").replaceAll(needfilteredInfoRegex2, "").replaceAll(needfilteredInfoRegex3, "").replaceAll(needfilteredInfoRegex4, "").contains("OK");
        }
        return true;
    }

    private boolean b(String response) {
        String needfilteredInfoRegex1 = "\\^LENDC: ([0-9]+,){4}([0-9]+)\\s*OK";
        String needfilteredInfoRegex2 = "\\^HFREQINFO: ([0-9]+,){8}([0-9]+)\\s*OK";
        String needfilteredInfoRegex3 = "\\+CMGS: [0-9]+\\s*OK";
        if (response == null || response.equals("")) {
            return true;
        }
        if (response.contains("OK")) {
            return !response.replaceAll(needfilteredInfoRegex1, "").replaceAll(needfilteredInfoRegex2, "").replaceAll(needfilteredInfoRegex3, "").contains("OK");
        }
        return true;
    }

    @Override
    public boolean switchStorageLocation(String mem) throws TimeoutException, GatewayException, IOException, InterruptedException {
        if (mem.equalsIgnoreCase("--")) {
            return true;
        }
        this.getModemDriver().write("ATE0\r");
        this.threadWait(Service.getInstance().getSettings().AT_WAIT);
        this.getModemDriver().getResponse();
        this.getModemDriver().write("AT+CPMS=\"" + mem + "\"\r");
        this.threadWait(Service.getInstance().getSettings().AT_WAIT);
        int reReadTimes = 0;
        String response = this.getModemDriver().getResponse();
        while (!response.contains("+CPMS:") || this.b(response)) {
            response = response + this.getModemDriver().getResponse();
            if (++reReadTimes > 15) break;
            this.threadWait(Service.getInstance().getSettings().AT_WAIT);
        }
        if (reReadTimes > 15 && !response.contains("+CPMS:")) {
            this.getModemDriver().write("AT\r");
            reReadTimes = 0;
            response = this.getModemDriver().getResponse();
            while (response.contains("+CPMS:")) {
                response = response + this.getModemDriver().getResponse();
                if (++reReadTimes > 15) break;
                this.threadWait(Service.getInstance().getSettings().AT_WAIT);
            }
            return this.getModemDriver().isOk();
        }
        return this.getModemDriver().isOk();
    }

    @Override
    public boolean deleteMessage(int memIndex, String memLocation) throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getModemDriver().write("AT+CMGD=_1_\r".replaceAll("_1_", "" + memIndex));
        this.threadWait(Service.getInstance().getSettings().AT_WAIT);
        return true;
    }

    @Override
    public void init() throws TimeoutException, GatewayException, IOException, InterruptedException {
        super.init();
        this.getModemDriver().write("ATE0\r");
        this.threadWait(Service.getInstance().getSettings().AT_WAIT);
        String response = this.getModemDriver().getResponse();
        this.getModemDriver().write("AT^CURC=0\r");
        this.threadWait(Service.getInstance().getSettings().AT_WAIT);
        response = this.getModemDriver().getResponse();
        this.getModemDriver().write("AT+CNMI=1,1,0,1,0\r");
        this.threadWait(Service.getInstance().getSettings().AT_WAIT);
        response = this.getModemDriver().getResponse();
        this.getModemDriver().write("AT^LENDC=0\r");
        this.threadWait(Service.getInstance().getSettings().AT_WAIT);
        response = this.getModemDriver().getResponse();
        this.getModemDriver().write("AT^HFREQINFO=0\r");
        this.threadWait(Service.getInstance().getSettings().AT_WAIT);
        response = this.getModemDriver().getResponse();
        this.getModemDriver().write("AT+CGREG=0\r");
        this.threadWait(Service.getInstance().getSettings().AT_WAIT);
        response = this.getModemDriver().getResponse();
        this.getModemDriver().write("AT+C5GREG=0\r");
        this.threadWait(Service.getInstance().getSettings().AT_WAIT);
        response = this.getModemDriver().getResponse();
        this.getModemDriver().write("AT+CREG=0\r");
        this.threadWait(Service.getInstance().getSettings().AT_WAIT);
        response = this.getModemDriver().getResponse();
        this.getModemDriver().write("AT+CPMS=\"SM\",\"SM\",\"SM\"\r");
        this.threadWait(Service.getInstance().getSettings().AT_WAIT);
        response = this.getModemDriver().getResponse();
    }
}

