/*
 * Decompiled with CFR 0.152.
 */
package cn.sendsms.otherModem.bigdipper;

import cn.sendsms.OutboundMessage;
import cn.sendsms.jdsmsserver.JDSMSServer;
import cn.sendsms.jdsmsserver.web.NewAuth;
import cn.sendsms.otherModem.bean.BigDipperBean;
import cn.sendsms.otherModem.common.Const;
import cn.sendsms.otherModem.common.Utils;
import cn.sendsms.otherModem.driver.bigdipperDriver.BDDriver;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.servlet.ServletException;
import jssc.SerialPort;
import jssc.SerialPortException;
import jssc.SerialPortList;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.log4j.Logger;

public class BDDeviceInfoGetter {
    private static int loop = -1;
    public static final Logger log = Logger.getRootLogger();
    private ArrayList<SerialPort> a = new ArrayList();
    private Vector<BigDipperBean> b = new Vector();

    private BDDeviceInfoGetter() {
    }

    public static BDDeviceInfoGetter getInstance() {
        return cn.sendsms.otherModem.bigdipper.BDDeviceInfoGetter$a.a;
    }

    public synchronized void deleteAll() {
        this.b.removeAllElements();
        this.a = new ArrayList();
    }

    public void addBD(BigDipperBean obj) {
        this.b.add(obj);
    }

    public List<BigDipperBean> getAll() {
        ArrayList<BigDipperBean> list = new ArrayList<BigDipperBean>();
        for (int i2 = 0; i2 < this.b.size(); ++i2) {
            list.add(this.b.get(i2));
        }
        return list;
    }

    public synchronized void getBDDeviceInfo() throws Exception {
        int i2;
        long startTime = System.currentTimeMillis();
        this.a = new ArrayList();
        this.deleteAll();
        String[] portList = SerialPortList.getPortNames();
        int deviceID = 1;
        block14: for (i2 = 0; i2 < portList.length; ++i2) {
            for (int j2 = 0; j2 < Const.BAUDRATES.length; ++j2) {
                SerialPort serialPort = new SerialPort(portList[i2]);
                log.info((Object)("\u6b63\u5728\u5c1d\u8bd5\u6253\u5f00\u7aef\u53e3:" + portList[i2]));
                try {
                    if (!serialPort.isOpened()) {
                        serialPort.openPort();
                    }
                    serialPort.setFlowControlMode(0);
                    serialPort.setParams(Const.BAUDRATES[j2], 8, 1, 0);
                }
                catch (SerialPortException e2) {
                    if (serialPort.isOpened()) {
                        log.info((Object)("\u7aef\u53e3" + portList[i2] + "\u6253\u5f00\u6210\u529f"));
                    }
                    log.info((Object)("\u7aef\u53e3" + portList[i2] + "\u6253\u5f00\u5931\u8d25"));
                }
                String cardNumber = BDDriver.getInstance().getCardNumber(serialPort);
                if (Utils.isEmptyStr(cardNumber) || "0000000".equals(cardNumber)) {
                    try {
                        serialPort.closePort();
                    }
                    catch (SerialPortException e3) {
                        if (!serialPort.isOpened()) {
                            log.info((Object)("\u7aef\u53e3" + serialPort + "\u5173\u95ed\u6210\u529f\uff01"));
                            continue;
                        }
                        log.info((Object)("\u7aef\u53e3" + serialPort + "\u5173\u95ed\u5931\u8d25"));
                    }
                    continue;
                }
                BigDipperBean BDInfo = new BigDipperBean();
                BDInfo.setGatewayID("BD" + deviceID);
                ++deviceID;
                BDInfo.setPortID(serialPort.getPortName());
                BDInfo.setBaudrate(Const.BAUDRATES[j2]);
                BDInfo.setCardNumber(cardNumber);
                String serialNumber = cardNumber;
                BDInfo.setSerialNumber(serialNumber);
                boolean flag = NewAuth.checkDeviceAuth(serialNumber);
                BDInfo.setValidate(flag);
                if (flag) {
                    try {
                        NewAuth.updateAuthorizeTemp(portList[i2], serialNumber);
                    }
                    catch (Exception e4) {
                        log.error((Object)"", (Throwable)e4);
                    }
                    cn.sendsms.helper.Logger.getInstance().logInfo("\u8bbe\u5907\u6388\u6743\u6709\u6548", null, BDInfo.getGatewayID());
                } else {
                    try {
                        NewAuth.updateAuthorizeTemp(portList[i2], serialNumber);
                    }
                    catch (Exception e5) {
                        log.error((Object)"", (Throwable)e5);
                    }
                    cn.sendsms.helper.Logger.getInstance().logInfo("\u8bbe\u5907\u672a\u6388\u6743", null, BDInfo.getGatewayID());
                }
                String signal = BDDriver.getInstance().getSignal(serialPort);
                BDInfo.setSignal(signal);
                BDInfo.setUsingStatus("0");
                this.addBD(BDInfo);
                this.a.add(serialPort);
                try {
                    serialPort.closePort();
                }
                catch (SerialPortException e6) {
                    if (!serialPort.isOpened()) {
                        log.info((Object)("\u7aef\u53e3" + serialPort + "\u5173\u95ed\u6210\u529f\uff01"));
                        continue block14;
                    }
                    log.info((Object)("\u7aef\u53e3" + serialPort + "\u5173\u95ed\u5931\u8d25"));
                }
                continue block14;
            }
        }
        for (i2 = 0; i2 < this.b.size(); ++i2) {
            BigDipperBean BDInfo = this.b.get(i2);
            String seiralNumber = this.getSerialNumber(BDInfo.getPortID());
            boolean flag = NewAuth.checkDeviceAuth(seiralNumber);
            BDInfo.setValidate(flag);
            if (flag) {
                try {
                    NewAuth.updateAuthorizeTemp(BDInfo.getPortID(), seiralNumber);
                }
                catch (Exception e7) {
                    log.error((Object)"", (Throwable)e7);
                }
                cn.sendsms.helper.Logger.getInstance().logInfo("\u8bbe\u5907\u6388\u6743\u6709\u6548", null, BDInfo.getGatewayID());
            } else {
                try {
                    NewAuth.updateAuthorizeTemp(BDInfo.getPortID(), seiralNumber);
                }
                catch (Exception e8) {
                    log.error((Object)"", (Throwable)e8);
                }
                cn.sendsms.helper.Logger.getInstance().logInfo("\u8bbe\u5907\u672a\u6388\u6743", null, BDInfo.getGatewayID());
            }
            BDInfo.setSerialNumber(seiralNumber);
        }
        long endTime = System.currentTimeMillis();
        log.info((Object)("\u68c0\u6d4b\u8bbe\u5907\u82b1\u8d39\uff1a" + (endTime - startTime) + "ms"));
    }

    public List<String> getUsingBDList() {
        ArrayList<String> list = new ArrayList<String>();
        for (int i2 = 0; i2 < this.b.size(); ++i2) {
            BigDipperBean device = this.b.get(i2);
            if (!device.getUsingStatus().equals("1")) continue;
            list.add(device.getGatewayID());
        }
        return list;
    }

    public String getSerialNumber(String portID) {
        String serialNumber = "";
        for (int i2 = 0; i2 < this.b.size(); ++i2) {
            BigDipperBean device = this.b.get(i2);
            if (!portID.equals(device.getPortID())) continue;
            serialNumber = device.getSerialNumber();
        }
        return serialNumber;
    }

    public List<BigDipperBean> getUsingBDs() {
        ArrayList<BigDipperBean> list = new ArrayList<BigDipperBean>();
        for (int i2 = 0; i2 < this.b.size(); ++i2) {
            BigDipperBean device = this.b.get(i2);
            if (!device.getUsingStatus().equals("1")) continue;
            list.add(device);
        }
        return list;
    }

    public boolean isBDUsing(String portID) {
        for (int i2 = 0; i2 < this.b.size(); ++i2) {
            BigDipperBean device = this.b.get(i2);
            if (!portID.equals(device.getPortID()) || !device.getUsingStatus().equals("1")) continue;
            return true;
        }
        return false;
    }

    public void deleteBD(String portID) throws ServletException, Exception {
        for (int i2 = 0; i2 < this.b.size(); ++i2) {
            BigDipperBean device = this.b.get(i2);
            if (!device.getPortID().equals(portID)) continue;
            this.deleteConfiguration(device);
            this.b.removeElementAt(i2);
            return;
        }
    }

    public void deleteConfiguration(BigDipperBean bean) throws ConfigurationException {
        PropertiesConfiguration props = JDSMSServer.getInstance().getProperties();
        boolean flag = false;
        int i2 = 0;
        for (i2 = 0; i2 < 64; ++i2) {
            if (props.getString("BDDevice." + i2, "").trim().length() == 0 || props.getString("BDDevice." + i2, "").indexOf(bean.getGatewayID()) == -1) continue;
            flag = true;
            props.clearProperty("BDDevice." + i2);
            break;
        }
        if (flag) {
            props.clearProperty(bean.getGatewayID() + ".port");
            props.clearProperty(bean.getGatewayID() + ".baudrate");
            props.clearProperty(bean.getGatewayID() + ".using_status");
            props.clearProperty(bean.getGatewayID() + ".serial_number");
            props.clearProperty(bean.getGatewayID() + ".card_number");
        }
        props.save();
    }

    public void saveConfigInfo(BigDipperBean bean) throws ConfigurationException {
        PropertiesConfiguration props = JDSMSServer.getInstance().getProperties();
        Configuration config = JDSMSServer.getInstance().getProperties().subset("BDDevice");
        int count = 0;
        boolean flag = false;
        Iterator it = config.getKeys();
        while (it.hasNext()) {
            String v = config.getString((String)it.next());
            if (!v.startsWith(bean.getGatewayID())) continue;
            flag = true;
            break;
        }
        if (!flag) {
            while (count < 64) {
                if (JDSMSServer.getInstance().getProperties().getString("BDDevice." + count, "").length() == 0) {
                    props.setProperty("BDDevice." + count, (Object)(bean.getGatewayID() + ",BD"));
                    break;
                }
                ++count;
            }
        }
        props.setProperty(bean.getGatewayID() + ".port", (Object)bean.getPortID());
        props.setProperty(bean.getGatewayID() + ".baudrate", (Object)bean.getBaudrate());
        props.setProperty(bean.getGatewayID() + ".using_status", (Object)bean.getUsingStatus());
        props.setProperty(bean.getGatewayID() + ".serial_number", (Object)bean.getSerialNumber());
        props.setProperty(bean.getGatewayID() + ".card_number", (Object)bean.getSerialNumber());
        props.save();
    }

    public boolean checkStartBD(String portID) {
        for (int i2 = 0; i2 < this.b.size(); ++i2) {
            BigDipperBean device = this.b.get(i2);
            if (!device.getPortID().equals(portID) || !device.getUsingStatus().equals("1")) continue;
            return true;
        }
        return false;
    }

    public boolean checkStopBD(String portID) {
        for (int i2 = 0; i2 < this.b.size(); ++i2) {
            BigDipperBean device = this.b.get(i2);
            if (!device.getPortID().equals(portID) || !device.getUsingStatus().equals("0")) continue;
            return true;
        }
        return false;
    }

    public int getbaudrate(String portID) {
        BigDipperBean serialBigDipperInfo = this.findDeviceByPortID(portID);
        if (serialBigDipperInfo != null) {
            return serialBigDipperInfo.getBaudrate();
        }
        log.error((Object)"\u83b7\u53d6\u6ce2\u7279\u7387\u5931\u8d25\uff0c\u91c7\u7528\u9ed8\u8ba4\u6ce2\u7279\u73879600");
        return 9600;
    }

    public BigDipperBean findDeviceByPortID(String portID) {
        List<BigDipperBean> list = this.getAll();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            if (!list.get(i2).getPortID().equals(portID)) continue;
            return list.get(i2);
        }
        return null;
    }

    public BigDipperBean findDeviceByGatewayID(String gatewayID) {
        List<BigDipperBean> list = this.getAll();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            if (!list.get(i2).getGatewayID().equals(gatewayID)) continue;
            return list.get(i2);
        }
        return null;
    }

    public String getPortIDByLoop(OutboundMessage msg) {
        if (this.getUsingBDList().isEmpty()) {
            return "";
        }
        String gatewayID = msg.getGatewayId();
        String recipient = msg.getRecipient();
        if (gatewayID == null || gatewayID.equals("")) {
            return "";
        }
        if (recipient == null || recipient.equals("")) {
            return "";
        }
        int loopTimes = 0;
        if ("-".equals(gatewayID)) {
            do {
                ++loop;
                if (++loopTimes <= this.b.size()) continue;
                log.error((Object)"\u6ca1\u6709\u627e\u5230\u53ef\u7528\u7684\u7aef\u53e3");
                return "";
            } while (!(loop < this.b.size() ? this.b.get(loop).getUsingStatus().equals("1") : this.b.get(loop = 0).getUsingStatus().equals("1")));
            return this.b.get(loop).getPortID();
        }
        BigDipperBean device = this.findDeviceByGatewayID(gatewayID);
        if (device == null) {
            log.error((Object)("\u8bbe\u5907" + msg.getGatewayId() + "\u672a\u542f\u7528\u6216\u8005\u4e0d\u5b58\u5728\u3002\u3002\u3002"));
            return "";
        }
        return device.getPortID();
    }

    public void updateAvaliableNum(String portID) {
        String serialnum = this.findDeviceByPortID(portID).getSerialNumber();
        int num = NewAuth.getAvaliableNum(serialnum);
        --num;
        try {
            NewAuth.updateAvaliableNum(serialnum, num);
        }
        catch (SQLException e2) {
            return;
        }
    }

    public boolean hasIdleDevice(OutboundMessage msg) {
        String gatewayID = msg.getGatewayId();
        if ("-".equals(gatewayID)) {
            for (int i2 = 0; i2 < this.b.size(); ++i2) {
                if (!this.b.get(i2).isSendIdle()) continue;
                msg.setUsingPortID(this.b.get(i2).getPortID());
                this.b.get(i2).setSendIdle(false);
                return true;
            }
        } else {
            BigDipperBean device = this.findDeviceByGatewayID(gatewayID);
            if (device == null) {
                return false;
            }
            if (device.isSendIdle()) {
                msg.setUsingPortID(device.getPortID());
                device.setSendIdle(false);
                return true;
            }
        }
        return false;
    }

    public synchronized SerialPort getSerialPort(String portID) {
        for (int i2 = 0; i2 < this.a.size(); ++i2) {
            if (!this.a.get(i2).getPortName().equals(portID)) continue;
            return this.a.get(i2);
        }
        SerialPort serialPort = new SerialPort(portID);
        try {
            if (!serialPort.isOpened()) {
                serialPort.openPort();
            }
            serialPort.setFlowControlMode(0);
            serialPort.setParams(this.getbaudrate(portID), 8, 1, 0);
            this.a.add(serialPort);
            serialPort.closePort();
            return serialPort;
        }
        catch (SerialPortException e2) {
            log.error((Object)"\u4ece\u914d\u7f6e\u6587\u4ef6\u4e2d\u8bfb\u53d6\u7684\u8bbe\u5907\u521d\u59cb\u5316\u5931\u8d25\u3002\u3002\u3002", null);
            return null;
        }
    }

    public boolean isBDRegistered(String serialnum) throws Exception {
        String regcode = NewAuth.getAuthorizeInfo(serialnum, "regcode");
        if (regcode == null || regcode.indexOf("null") != -1) {
            regcode = "";
        }
        if (regcode.equals("")) {
            return false;
        }
        return NewAuth.checkDeviceAuth(serialnum);
    }

    public boolean checkAuthorizeInfo(String usingPort, OutboundMessage msg) {
        String gatewayID = this.findDeviceByPortID(usingPort).getGatewayID();
        String serialNum = this.findDeviceByPortID(usingPort).getSerialNumber();
        try {
            boolean flag = this.findDeviceByPortID(usingPort).isValidate();
            if (!flag) {
                if (msg != null) {
                    msg.setText("<\u8bf7\u586b\u5199\u8bbe\u5907\u6ce8\u518c\u7801>" + msg.getText());
                }
                int num = NewAuth.getAvaliableNum(serialNum);
                log.info((Object)("\u8bbe\u5907\u672a\u6388\u6743\uff0c\u8fd8\u53ef\u6536\u53d1" + num + "\u6761\u77ed\u4fe1" + gatewayID));
                if (num < 1) {
                    log.warn((Object)("\u8bbe\u5907\u672a\u6388\u6743\uff0c\u6536\u53d1\u4fe1\u606f\u6761\u6570\u5df2\u8fbe\u5230\u6700\u5927\u9650\u5236\u657088\u6761,\u5df2\u505c\u6b62\u6536\u53d1\u4fe1\u606f" + gatewayID));
                    return false;
                }
            }
        }
        catch (Exception e2) {
            log.info((Object)("\u83b7\u53d6\u8bbe\u5907\u6388\u6743\u4fe1\u606f\u5931\u8d25\uff1a" + gatewayID), (Throwable)e2);
            return false;
        }
        return true;
    }

    public void initForBD() {
        PropertiesConfiguration props = JDSMSServer.getInstance().getProperties();
        this.a = new ArrayList();
        Configuration config = props.subset("BDDevice");
        Iterator it = config.getKeys();
        while (it.hasNext()) {
            String deviceIDKey = (String)it.next();
            String deviceID = config.getString(deviceIDKey);
            String port = props.getString(deviceID + ".port", "");
            int baudrate = props.getInt(deviceID + ".baudrate", 9600);
            String serial_number = props.getString(deviceID + ".serial_number", "");
            String using_status = props.getString(deviceID + ".using_status", "0");
            String card_number = props.getString(deviceID + ".card_number", "");
            BigDipperBean BDInfo = new BigDipperBean();
            BDInfo.setGatewayID(deviceID);
            BDInfo.setPortID(port);
            BDInfo.setBaudrate(baudrate);
            BDInfo.setSerialNumber(serial_number);
            BDInfo.setCardNumber(card_number);
            BDInfo.setUsingStatus(using_status);
            this.addBD(BDInfo);
        }
        List<BigDipperBean> BDInfoList = this.getAll();
        for (BigDipperBean BDInfo : BDInfoList) {
            String serial_number = BDInfo.getSerialNumber();
            String port = BDInfo.getPortID();
            boolean flag = NewAuth.checkDeviceAuth(serial_number);
            BDInfo.setValidate(flag);
            if (flag) {
                try {
                    NewAuth.updateAuthorizeTemp(port, serial_number);
                }
                catch (Exception e2) {
                    log.error((Object)"\u66f4\u65b0\u6388\u6743\u4fe1\u606f\u5f02\u5e38\u3002", (Throwable)e2);
                }
                cn.sendsms.helper.Logger.getInstance().logInfo("\u8bbe\u5907\u6388\u6743\u6709\u6548", null, BDInfo.getGatewayID());
            } else {
                try {
                    NewAuth.updateAuthorizeTemp(port, serial_number);
                }
                catch (Exception e3) {
                    log.error((Object)"\u66f4\u65b0\u6388\u6743\u4fe1\u606f\u5f02\u5e38\u3002", (Throwable)e3);
                }
                cn.sendsms.helper.Logger.getInstance().logInfo("\u8bbe\u5907\u672a\u6388\u6743", null, BDInfo.getGatewayID());
            }
            SerialPort serialPort = new SerialPort(BDInfo.getPortID());
            try {
                if (!serialPort.isOpened()) {
                    serialPort.openPort();
                }
                serialPort.setFlowControlMode(0);
                serialPort.setParams(BDInfo.getBaudrate(), 8, 1, 0);
                BDInfo.setSignal(BDDriver.getInstance().getSignal(serialPort));
                this.a.add(serialPort);
                if (BDInfo.getUsingStatus().equals("0")) {
                    serialPort.closePort();
                    continue;
                }
                BDDriver.getInstance().startDevice(BDInfo.getPortID());
            }
            catch (SerialPortException e4) {
                log.error((Object)"\u4ece\u914d\u7f6e\u6587\u4ef6\u4e2d\u8bfb\u53d6\u7684\u8bbe\u5907\u521d\u59cb\u5316\u5931\u8d25\u3002\u3002\u3002", null);
            }
        }
    }

    private static class a {
        private static BDDeviceInfoGetter a = new BDDeviceInfoGetter();

        private a() {
        }
    }
}

