/*
 * Decompiled with CFR 0.152.
 */
package cn.sendsms.otherModem.driver;

import cn.sendsms.otherModem.bean.ModemBean;
import cn.sendsms.otherModem.common.Utils;
import cn.sendsms.otherModem.thread.WatchDog;
import jssc.SerialPort;
import jssc.SerialPortException;
import org.apache.log4j.Logger;

public abstract class ModemDriver {
    private static Logger log = Logger.getRootLogger();

    public abstract boolean startDevice(String var1);

    public abstract boolean stopDevice(String var1);

    public abstract boolean restartDevice(String var1);

    public abstract String getSignal(SerialPort var1);

    public abstract String getSerialNumber(SerialPort var1);

    public abstract boolean connectionOK(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final byte[] getBytesResponse(SerialPort serialPort, String decodingType) {
        SerialPort serialPort2 = serialPort;
        synchronized (serialPort2) {
            byte[] response = null;
            if (!ModemDriver.serialportConnected(serialPort)) {
                return response;
            }
            try {
                if (serialPort.isOpened()) {
                    response = serialPort.readBytes();
                }
            }
            catch (SerialPortException e2) {
                log.error((Object)("\u8bfb\u4e32\u53e3" + serialPort.getPortName() + "\u5931\u8d25\u3002\u3002\u3002"), (Throwable)e2);
            }
            if (response != null && response.length != 0) {
                log.info((Object)("\u4ece\u7aef\u53e3" + serialPort.getPortName() + "\u8bfb\u5230\u6d88\u606f(\u5b57\u8282)\uff1a\u3010" + Utils.getString(response, decodingType) + "\u3011"));
            }
            return response;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String getStrResponse(SerialPort serialPort, boolean isRawResponse, String expectResponse, String decodingType) {
        SerialPort serialPort2 = serialPort;
        synchronized (serialPort2) {
            String response = "";
            if (!ModemDriver.serialportConnected(serialPort)) {
                log.error((Object)("\u7aef\u53e3" + serialPort.getPortName() + "\u672a\u6253\u5f00\u3002\u3002"));
                return response;
            }
            try {
                response = Utils.getString(serialPort.readBytes(), decodingType);
            }
            catch (SerialPortException e2) {
                log.error((Object)("\u8bfb\u4e32\u53e3" + serialPort.getPortName() + "\u5931\u8d25\u3002\u3002\u3002"), (Throwable)e2);
            }
            if (response == null) {
                response = "";
            }
            if (!isRawResponse) {
                response = response.replace("\r", "");
                response = response.replace("\n", "");
            }
            if (expectResponse == null || expectResponse.equals("")) {
                return response;
            }
            if ("ERROR".equals(response.toUpperCase())) {
                return response;
            }
            int waitTimes = 0;
            while (ModemDriver.serialportConnected(serialPort) && !response.endsWith(expectResponse)) {
                try {
                    if (response.matches(expectResponse)) {
                        break;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (waitTimes >= 40) break;
                try {
                    Thread.sleep(300L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                String moreResponse = "";
                try {
                    moreResponse = Utils.getString(serialPort.readBytes(), decodingType);
                }
                catch (SerialPortException e3) {
                    log.error((Object)("\u8bfb\u4e32\u53e3" + serialPort.getPortName() + "\u5931\u8d25\u3002\u3002\u3002"), (Throwable)e3);
                }
                if (moreResponse == null || moreResponse.equals("")) {
                    ++waitTimes;
                    continue;
                }
                response = response + moreResponse;
                if (isRawResponse) continue;
                response = response.replace("\r", "");
                response = response.replace("\n", "");
            }
            log.info((Object)("\u4ece\u7aef\u53e3" + serialPort.getPortName() + "\u8bfb\u5230\u6d88\u606f(\u5b57\u7b26)\uff1a\u3010" + response + "\u3011"));
            return response;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int readPortInputBufferUsedSize(SerialPort serialport) {
        SerialPort serialPort = serialport;
        synchronized (serialPort) {
            if (serialport.isOpened()) {
                try {
                    return serialport.getInputBufferBytesCount();
                }
                catch (SerialPortException e2) {
                    return -1;
                }
            }
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean execAtCommand(ModemBean device, SerialPort serialPort, String cmd, String encodingType) {
        SerialPort serialPort2 = serialPort;
        synchronized (serialPort2) {
            try {
                if (!serialPort.isOpened()) {
                    return false;
                }
                if (!ModemDriver.serialportConnected(serialPort)) {
                    log.error((Object)("\u5199\u4e32\u53e3" + serialPort.getPortName() + "\u5931\u8d25\u3002\u3002\u3002" + cmd));
                    if (device != null) {
                        if ("0".equals(device.getUsingStatus()) && !serialPort.isOpened()) {
                            return false;
                        }
                        device.setUsingStatus("2");
                        log.info((Object)(device.getGatewayID() + "\u5373\u5c06\u91cd\u542f\u3002\u3002\u3002"));
                        WatchDog.getInstance().interrupt();
                    }
                    return false;
                }
                log.info((Object)(serialPort.getPortName() + "\u5373\u5c06\u6267\u884c\u7684\u6307\u4ee4\uff1a" + cmd));
                serialPort.writeBytes(cmd.getBytes(encodingType));
                return true;
            }
            catch (Exception e2) {
                log.error((Object)("\u5199\u4e32\u53e3" + serialPort.getPortName() + "\u5931\u8d25\u3002\u3002\u3002" + cmd), (Throwable)e2);
                if (device != null) {
                    if ("0".equals(device.getUsingStatus()) && !serialPort.isOpened()) {
                        return false;
                    }
                    device.setUsingStatus("2");
                    log.info((Object)(device.getGatewayID() + "\u5373\u5c06\u91cd\u542f\u3002\u3002\u3002"));
                    WatchDog.getInstance().interrupt();
                }
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean serialportConnected(SerialPort serialport) {
        if (serialport.getPortName().matches("Vitual-[0-9]+-COM")) {
            return true;
        }
        SerialPort serialPort = serialport;
        synchronized (serialPort) {
            if (serialport.isOpened()) {
                try {
                    return serialport.getInputBufferBytesCount() >= 0;
                }
                catch (SerialPortException e2) {
                    log.error((Object)("\u7aef\u53e3" + serialport.getPortName() + "\u5f02\u5e38\u3002\u3002"));
                    return false;
                }
            }
            log.error((Object)("\u7aef\u53e3" + serialport.getPortName() + "\u5df2\u5173\u95ed\u3002\u3002"));
            return false;
        }
    }
}

