/*
 * Decompiled with CFR 0.152.
 */
package cn.sendsms.otherModem.driver.bigdipperDriver;

import cn.sendsms.InboundMessage;
import cn.sendsms.Message;
import cn.sendsms.TmpMsg;
import cn.sendsms.jdsmsserver.JDSMSServer;
import cn.sendsms.otherModem.bean.BigDipperBean;
import cn.sendsms.otherModem.bigdipper.BDDeviceInfoGetter;
import cn.sendsms.otherModem.bigdipper.BDMessageHolder;
import cn.sendsms.otherModem.common.Utils;
import cn.sendsms.otherModem.driver.ModemDriver;
import cn.sendsms.otherModem.thread.WatchDog;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jssc.SerialPort;
import jssc.SerialPortException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.log4j.Logger;

public class BDDriver
extends ModemDriver {
    public static BDDeviceInfoGetter bdDeviceInfoGetter = BDDeviceInfoGetter.getInstance();
    public static final Logger log = Logger.getRootLogger();
    public static final String ENCODING_IN_8BIT = "1";
    public static final String ENCODING_IN_UFT8 = "2";
    public static final String ENCODING_SIMPLE_CHINESE = "0";
    public static final int BD_MESSAGE_PREFIX_LENGTH = 2;
    public static final String BD_MESSAGE_PREFIX = "A4";
    public static final int BD_MESSAGE_SUFFIX_LENGTH = 3;
    public static final String DEFAULT_CARD_NUMBER = "0000000";
    public static final String SC_MESSAGE_ID_PREFIX = "X";
    public static BDMessageHolder bdMessageHolder = BDMessageHolder.getInstance();
    public static HashMap<String, String> messageIDReceiveDeviceIDMap = new HashMap();
    public static HashMap<String, String> messageIDCodingTypeMap = new HashMap();
    public static HashMap<String, Date> messageIDOReceiveDateMap = new HashMap();
    public static HashMap<String, Integer> messageIDExpectMessageNumMap = new HashMap();
    public static HashMap<String, HashSet<String>> messageIDSplitedMessagesMap = new HashMap();

    private BDDriver() {
    }

    public static BDDriver getInstance() {
        return a.a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSignal(SerialPort serialport) {
        String signal = "";
        boolean needToClose = false;
        String getSigalCmd = "$CCRMO,BSI,2,0*" + Utils.getXORCheckStr("CCRMO,BSI,2,0".getBytes()) + "\r\n";
        String signalRegex = "\\$BDBSI(,[0-9]{2}){2}(,[0-4]{1}){10}\\*[0-9A-F]{2}";
        Pattern signalPattern = Pattern.compile(signalRegex);
        BigDipperBean device = bdDeviceInfoGetter.findDeviceByPortID(serialport.getPortName());
        SerialPort serialPort = serialport;
        synchronized (serialPort) {
            if (!serialport.isOpened()) {
                log.info((Object)("\u6b63\u5728\u5c1d\u8bd5\u6253\u5f00\u7aef\u53e3:" + serialport.getPortName()));
                if (Utils.openPort(device.getBaudrate(), serialport)) {
                    needToClose = true;
                } else {
                    return signal;
                }
            }
            BDDriver.execAtCommand(device, serialport, getSigalCmd, "GBK");
            byte[] responseByteArray = BDDriver.getBytesResponse(serialport, "GBK");
            int loop = 0;
            do {
                String response;
                if ((response = Utils.getString(responseByteArray, "GBK")).replace("\r", "").replace("\n", "").equals("ERROR")) {
                    log.error((Object)("\u8bfb\u4fe1\u53f7\u5f02\u5e38\uff01\u8fd4\u56de\u503c\uff1a" + response));
                    return "";
                }
                Matcher signalMatcher = signalPattern.matcher(response.replace("\r", "").replace("\n", ""));
                if (signalMatcher.find()) {
                    signal = signalMatcher.group(0);
                    signal = signal.replaceFirst("\\$BDBSI(,[0-9]{2}){2},", "");
                    signal = signal.replaceFirst("\\*[0-9A-F]{2}", "");
                    break;
                }
                try {
                    Thread.sleep(300L);
                }
                catch (InterruptedException e2) {
                    log.error((Object)"\u7b49\u5f85\u53d1\u9001\u4fe1\u606f\u547d\u4ee4\u7684\u8fd4\u56de\u7ed3\u679c\u65f6\u88ab\u6253\u65ad\u3002\u3002\u3002");
                }
                byte[] tmpResponseByteArray = BDDriver.getBytesResponse(serialport, "GBK");
                responseByteArray = Utils.mergeByteArray(tmpResponseByteArray, responseByteArray);
            } while (++loop < 15);
            this.getCompleteMessages(responseByteArray, serialport, "\u8bfb\u53d6\u8bbe\u5907\u4fe1\u53f7\u5f3a\u5ea6");
            if (device != null) {
                device.setSignal(signal);
            }
            if (needToClose) {
                Utils.closePort(serialport);
            }
            return signal;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCardNumber(SerialPort serialport) {
        String cardNumber = DEFAULT_CARD_NUMBER;
        String getSigalCmd = "$CCICA,0,0*" + Utils.getXORCheckStr("CCICA,0,0".getBytes()) + "\r\n";
        String expectResponse = "\\$BDICI(,[0-9]+){6},[EN]+{1},[0-9A-F\\*]+[\\s]*";
        Pattern expectResponsePattern = Pattern.compile(expectResponse);
        BigDipperBean device = bdDeviceInfoGetter.findDeviceByPortID(serialport.getPortName());
        SerialPort serialPort = serialport;
        synchronized (serialPort) {
            BDDriver.execAtCommand(device, serialport, getSigalCmd, "GBK");
            byte[] responseByteArray = BDDriver.getBytesResponse(serialport, "GBK");
            int loop = 0;
            block5: do {
                String response;
                if ((response = Utils.getString(responseByteArray, "GBK")).replace("\r", "").replace("\n", "").equals("ERROR")) {
                    log.error((Object)("\u8bfb\u5361\u53f7\u5f02\u5e38\uff01\u8fd4\u56de\u503c\uff1a" + response));
                    return "";
                }
                Matcher expectResponseMatcher = expectResponsePattern.matcher(response.replace("\r", "").replace("\n", ""));
                if (expectResponseMatcher.find()) {
                    cardNumber = expectResponseMatcher.group(0);
                    String[] responsePieces = cardNumber.split(",");
                    for (int i2 = 0; i2 < responsePieces.length; ++i2) {
                        if (Utils.isEmptyStr(responsePieces[i2]) || !"$BDICI".equals(responsePieces[i2]) || i2 + 1 >= responsePieces.length) continue;
                        cardNumber = responsePieces[i2 + 1];
                        break block5;
                    }
                    break;
                }
                try {
                    Thread.sleep(300L);
                }
                catch (InterruptedException e2) {
                    log.error((Object)"\u7b49\u5f85\u53d1\u9001\u4fe1\u606f\u547d\u4ee4\u7684\u8fd4\u56de\u7ed3\u679c\u65f6\u88ab\u6253\u65ad\u3002\u3002\u3002");
                }
                byte[] tmpResponseByteArray = BDDriver.getBytesResponse(serialport, "GBK");
                responseByteArray = Utils.mergeByteArray(tmpResponseByteArray, responseByteArray);
            } while (++loop < 15);
            this.getCompleteMessages(responseByteArray, serialport, "\u8bfb\u53d6\u5361\u53f7");
        }
        return cardNumber;
    }

    public void getCompleteMessages(byte[] responseByteArray, SerialPort serialport, String markForLog) {
        BigDipperBean device = bdDeviceInfoGetter.findDeviceByPortID(serialport.getPortName());
        int readTimes = 0;
        ArrayList<String> messageList = new ArrayList<String>();
        while (!this.a(responseByteArray, device, messageList)) {
            log.info((Object)("\u6536\u5230\u4e0d\u5b8c\u6574\u4fe1\u606f\uff1a\u3010" + markForLog + "\u3011" + Utils.getString(responseByteArray, "GBK")));
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            byte[] tmpResponseByteArray = BDDriver.getBytesResponse(serialport, "GBK");
            responseByteArray = Utils.mergeByteArray(tmpResponseByteArray, responseByteArray);
            if (++readTimes >= 150) break;
            messageList = new ArrayList();
        }
        for (int i2 = 0; i2 < messageList.size(); ++i2) {
            bdMessageHolder.updateMessageList(device, (String)messageList.get(i2));
        }
    }

    private boolean a(byte[] messageByteArray, BigDipperBean device, List<String> messageList) {
        boolean checkResult = true;
        String messages = Utils.getString(messageByteArray, "GBK");
        List<String> formattedMessageList = this.a(messages, device);
        if (formattedMessageList == null || formattedMessageList.size() == 0) {
            return checkResult;
        }
        String messageRegex = "[\\s]*\\$BDTXR(,[0-9]+){3},,[\\S]+(\\*[0-9A-F]{2}[\\s]*)$";
        for (int i2 = 0; i2 < formattedMessageList.size(); ++i2) {
            String message = formattedMessageList.get(i2);
            if (message.matches(messageRegex)) {
                String encodingType = "";
                try {
                    encodingType = message.split(",")[3];
                }
                catch (Exception e2) {
                    log.info((Object)("\u4fe1\u606f\u683c\u5f0f\u4e0d\u6b63\u786e\u3002" + message));
                }
                if (bdMessageHolder.getCodingType(encodingType) == Message.MessageEncodings.SC) {
                    StringBuffer buffer = new StringBuffer(message);
                    String messageID = SC_MESSAGE_ID_PREFIX + Utils.complementStrWithZero(message.split(",")[2], 7);
                    int lastIndex = message.lastIndexOf(",") + 1;
                    buffer.insert(lastIndex, messageID + "0101000");
                    messageList.add(buffer.toString());
                    continue;
                }
                String context = message.replaceFirst("[\\s]*\\$BDTXR(,[0-9]+){3},,", "");
                int sendContextLength = 0;
                if (Utils.isEmptyStr(context)) {
                    log.info((Object)(message + "\u672a\u63a5\u6536\u5b8c(0)"));
                    checkResult = false;
                    continue;
                }
                context = context.substring(0, context.length() - 3);
                if (bdMessageHolder.getCodingType(encodingType) == Message.MessageEncodings.ENCUCS2) {
                    context = context.substring(2);
                }
                if (bdMessageHolder.getCodingType(encodingType) != Message.MessageEncodings.ENC7BIT && bdMessageHolder.getCodingType(encodingType) != Message.MessageEncodings.ENC8BIT) {
                    try {
                        context = Utils.getString(Utils.hexStr2ByteArr(context), "GBK");
                    }
                    catch (Exception e3) {
                        log.info((Object)(message + "\u672a\u63a5\u6536\u5b8c(1)"));
                        checkResult = false;
                        continue;
                    }
                }
                if (context.length() <= 15) {
                    log.info((Object)(message + "\u672a\u63a5\u6536\u5b8c(2)"));
                    checkResult = false;
                    continue;
                }
                String sentContextLengthStr = context.substring(12, 15);
                try {
                    sendContextLength = Integer.valueOf(sentContextLengthStr, 16);
                }
                catch (NumberFormatException e4) {
                    log.info((Object)(message + "\u672a\u63a5\u6536\u5b8c(4)"));
                    checkResult = false;
                    continue;
                }
                context = context.substring(15);
                int receivedContextLength = Utils.getByteArray(context, "GBK").length;
                if (sendContextLength != receivedContextLength) {
                    log.info((Object)(message + "\u672a\u63a5\u6536\u5b8c(5)"));
                    checkResult = false;
                    continue;
                }
                messageList.add(message);
                continue;
            }
            log.info((Object)(message + "\u672a\u63a5\u6536\u5b8c(6)"));
            checkResult = false;
        }
        return checkResult;
    }

    private List<String> a(String messages, BigDipperBean device) {
        String formatedMessage = "";
        StringReader stringReader = new StringReader(messages);
        BufferedReader reader = new BufferedReader(stringReader);
        String sendMessageResponseRegex = "\\$BDFKI,TXA,[NY]{1},[NY]{1},[0-9]{1},[0-9]{4}\\*[0-9A-F]{2}";
        String getSignalResponseRegex = "\\$BDBSI(,[0-9]{2}){2}(,[0-4]{1}){10}\\*[0-9A-F]{2}";
        String getCardNumberRegex = "\\$BDICI(,[0-9]+){6},[EN]+{1},[0-9A-F\\*]+[\\s]*";
        String getCardNumberCmdRegex = "\\$CCICA,[0-9A-F]+,[0-9A-F\\*]+[\\s]*";
        while (true) {
            String line = null;
            try {
                line = reader.readLine();
            }
            catch (IOException e2) {
                log.error((Object)"\u4fe1\u606f\u89e3\u6790\u5931\u8d25\u3002\u3002\u3002", (Throwable)e2);
            }
            if (line == null) break;
            if (line.trim().equals("") || line.replace("\r", "").replace("\n", "").equals("ERROR") || line.replace("\r", "").replace("\n", "").matches(sendMessageResponseRegex) || line.replace("\r", "").replace("\n", "").matches(getSignalResponseRegex) || line.replace("\r", "").replace("\n", "").matches(getCardNumberRegex) || line.replace("\r", "").replace("\n", "").matches(getCardNumberCmdRegex)) continue;
            formatedMessage = formatedMessage + line;
        }
        try {
            reader.close();
            stringReader.close();
        }
        catch (IOException e3) {
            log.error((Object)"\u6570\u636e\u6d41\u5173\u95ed\u5f02\u5e38", (Throwable)e3);
        }
        String[] messageArray = formatedMessage.split("\\$BDTXR");
        ArrayList<String> messageList = new ArrayList<String>();
        for (int i2 = 0; i2 < messageArray.length; ++i2) {
            if (messageArray[i2] == null || messageArray[i2].length() == 0) continue;
            messageList.add("$BDTXR" + messageArray[i2]);
        }
        if (formatedMessage.endsWith("$BDTXR")) {
            messageList.add("$BDTXR");
        }
        return messageList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendMessage(String usingPort, String recipient, String text, Message.MessageEncodings encoding) {
        PropertiesConfiguration props = JDSMSServer.getInstance().getProperties();
        BigDipperBean bigDipperDevice = bdDeviceInfoGetter.findDeviceByPortID(usingPort);
        SerialPort serialport = bdDeviceInfoGetter.getSerialPort(usingPort);
        if (serialport == null || !serialport.isOpened()) {
            log.error((Object)("\u7aef\u53e3" + usingPort + "\u672a\u6253\u5f00\uff0c\u8bf7\u786e\u8ba4\u8bbe\u5907" + bigDipperDevice.getGatewayID() + "\u662f\u5426\u6b63\u5e38\u8fde\u63a5\u3002\u3002\u3002"));
            return false;
        }
        if (bdDeviceInfoGetter.checkStopBD(usingPort)) {
            return false;
        }
        if (ENCODING_IN_UFT8.equals(bigDipperDevice.getUsingStatus())) {
            return false;
        }
        long timeToWait = bigDipperDevice.getDiffTime();
        log.info((Object)("\u8bbe\u5907\u3010" + bigDipperDevice.getGatewayID() + "\u3011\u9700\u8981\u7b49\u5f85" + timeToWait + "\u79d2\u540e\u624d\u80fd\u53d1\u9001..."));
        try {
            Thread.sleep(timeToWait * 1000L);
        }
        catch (InterruptedException e1) {
            log.error((Object)"\u53d1\u9001\u524d\u7684\u7b49\u5f85\u88ab\u6253\u65ad\u3002\u3002");
        }
        int waitTimes = 0;
        while (true) {
            if (waitTimes > 60) {
                log.error((Object)("\u8bbe\u5907" + bigDipperDevice.getGatewayID() + "\u4fe1\u53f7\u5f02\u5e38\uff0c\u53d1\u9001\u5931\u8d25\u3002\u3002\u3002"));
                return false;
            }
            String signal = this.getSignal(serialport);
            if (this.a(signal)) break;
            try {
                Thread.sleep(props.getInt("settings.bd_wait_for_normal_signal_interval", 3) * 1000);
            }
            catch (InterruptedException e2) {
                log.error((Object)"\u7b49\u5f85\u68c0\u6d4b\u8bbe\u5907\u4fe1\u53f7\u88ab\u6253\u65ad\u3002\u3002\u3002");
            }
            ++waitTimes;
        }
        String encodingType = bdMessageHolder.getCodingType(encoding);
        if (ENCODING_IN_UFT8.equals(encodingType)) {
            text = Utils.byteArr2HexStr(Utils.getByteArray(text, "GBK")).toUpperCase();
            text = BD_MESSAGE_PREFIX + text;
        }
        if (ENCODING_SIMPLE_CHINESE.equals(encodingType)) {
            text = text.substring(15, text.length());
        }
        String strToCheck = "CCTXA," + recipient + ",1," + encodingType + "," + text;
        String checkCode = Utils.getXORCheckStr(Utils.getByteArray(strToCheck, "GBK"));
        String sendMessageCmd = "$" + strToCheck + "*" + checkCode + "\r\n";
        boolean sendSucess = false;
        SerialPort serialPort = serialport;
        synchronized (serialPort) {
            boolean execAtCommandSucess = BDDriver.execAtCommand(bigDipperDevice, serialport, sendMessageCmd, "GBK");
            bigDipperDevice.setLastSendTiming(new Date());
            if (!execAtCommandSucess) {
                log.error((Object)("\u8bbe\u5907" + bigDipperDevice.getGatewayID() + "\u53d1\u9001\u4fe1\u606f\u3010" + text + "\u3011\u5931\u8d25\uff01"));
                return false;
            }
            String sendSucessResultRegex = "\\$BDFKI,TXA,Y,[NY]{1},[0-1]{1},[0-9]{4}\\*[0-9A-F]{2}";
            Pattern sendSucessPattern = Pattern.compile(sendSucessResultRegex);
            String sendFailedResultRegex = "\\$BDFKI,TXA,N,[NY]{1},[0-1]{1},[0-9]{4}\\*[0-9A-F]{2}";
            Pattern sendFailedPattern = Pattern.compile(sendFailedResultRegex);
            byte[] responseByteArray = BDDriver.getBytesResponse(serialport, "GBK");
            int loop = 0;
            do {
                String response;
                if ((response = Utils.getString(responseByteArray, "GBK")).replace("\r", "").replace("\n", "").equals("ERROR")) {
                    log.error((Object)("\u8bbe\u5907" + bigDipperDevice.getGatewayID() + "\u53d1\u9001\u4fe1\u606f\u3010" + text + "\u3011\u5931\u8d25\uff01\u8fd4\u56de\u503c\uff1a" + response));
                    return false;
                }
                Matcher sendSucessMatcher = sendSucessPattern.matcher(response.replace("\r", "").replace("\n", ""));
                Matcher sendFailedMatcher = sendFailedPattern.matcher(response.replace("\r", "").replace("\n", ""));
                if (sendSucessMatcher.find()) {
                    log.info((Object)("\u8bbe\u5907" + bigDipperDevice.getGatewayID() + "\u53d1\u9001\u4fe1\u606f\u3010" + text + "\u3011\u6210\u529f\uff01"));
                    sendSucess = true;
                    break;
                }
                if (sendFailedMatcher.find()) {
                    sendSucess = false;
                    break;
                }
                try {
                    Thread.sleep(300L);
                }
                catch (InterruptedException e3) {
                    log.error((Object)"\u7b49\u5f85\u53d1\u9001\u4fe1\u606f\u547d\u4ee4\u7684\u8fd4\u56de\u7ed3\u679c\u65f6\u88ab\u6253\u65ad\u3002\u3002\u3002");
                }
                byte[] tmpResponseByteArray = BDDriver.getBytesResponse(serialport, "GBK");
                responseByteArray = Utils.mergeByteArray(tmpResponseByteArray, responseByteArray);
            } while (++loop < 15);
            this.getCompleteMessages(responseByteArray, serialport, "\u53d1\u4fe1\u7ebf\u7a0b");
        }
        return sendSucess;
    }

    private boolean a(String signal) {
        return signal.contains(ENCODING_IN_UFT8) || signal.contains("3") || signal.contains("4");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean restartDevice(String portID) {
        BigDipperBean device = bdDeviceInfoGetter.findDeviceByPortID(portID);
        if (device == null) {
            log.error((Object)("\u7aef\u53e3" + portID + "\u4e0d\u5b58\u5728\uff01"));
            return false;
        }
        SerialPort serialport = bdDeviceInfoGetter.getSerialPort(portID);
        if (serialport == null) {
            log.error((Object)("\u7aef\u53e3" + portID + "\u4e0d\u5b58\u5728\uff01"));
            return false;
        }
        SerialPort serialPort = serialport;
        synchronized (serialPort) {
            try {
                serialport.closePort();
            }
            catch (SerialPortException e2) {
                if (!serialport.isOpened()) {
                    log.info((Object)("\u7aef\u53e3" + portID + "\u5173\u95ed\u6210\u529f"));
                }
                log.error((Object)("\u7aef\u53e3" + portID + "\u5173\u95ed\u5931\u8d25"));
                return false;
            }
            try {
                serialport.openPort();
                serialport.setFlowControlMode(0);
                serialport.setParams(device.getBaudrate(), 8, 1, 0);
                device.setUsingStatus(ENCODING_IN_8BIT);
                return true;
            }
            catch (SerialPortException e3) {
                if (serialport.isOpened()) {
                    log.info((Object)("\u7aef\u53e3" + portID + "\u6253\u5f00\u6210\u529f"));
                    device.setUsingStatus(ENCODING_IN_8BIT);
                    return true;
                }
                log.error((Object)("\u7aef\u53e3" + portID + "\u6253\u5f00\u5931\u8d25\uff0c\u8bf7\u786e\u8ba4\u8bbe\u5907\u662f\u5426\u6b63\u5e38\u8fde\u63a5:" + portID));
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean startDevice(String portID) {
        BigDipperBean device = bdDeviceInfoGetter.findDeviceByPortID(portID);
        if (device == null) {
            log.error((Object)("\u7aef\u53e3" + portID + "\u4e0d\u5b58\u5728\uff01"));
            return false;
        }
        SerialPort serialport = bdDeviceInfoGetter.getSerialPort(portID);
        if (serialport == null) {
            log.error((Object)("\u7aef\u53e3" + portID + "\u4e0d\u5b58\u5728\uff01"));
            return false;
        }
        SerialPort serialPort = serialport;
        synchronized (serialPort) {
            try {
                serialport.openPort();
                serialport.setFlowControlMode(0);
                serialport.setParams(device.getBaudrate(), 8, 1, 0);
                device.setUsingStatus(ENCODING_IN_8BIT);
                return true;
            }
            catch (SerialPortException e2) {
                if (serialport.isOpened()) {
                    log.info((Object)("\u7aef\u53e3" + portID + "\u6253\u5f00\u6210\u529f"));
                    device.setUsingStatus(ENCODING_IN_8BIT);
                    return true;
                }
                log.error((Object)("\u7aef\u53e3" + portID + "\u6253\u5f00\u5931\u8d25\uff0c\u8bf7\u786e\u8ba4\u8bbe\u5907\u662f\u5426\u6b63\u5e38\u8fde\u63a5:" + portID));
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean stopDevice(String portID) {
        SerialPort serialport;
        BigDipperBean device = bdDeviceInfoGetter.findDeviceByPortID(portID);
        if (device == null) {
            log.error((Object)("\u7aef\u53e3" + portID + "\u4e0d\u5b58\u5728\uff01"));
        }
        if ((serialport = bdDeviceInfoGetter.getSerialPort(portID)) == null) {
            log.error((Object)("\u7aef\u53e3" + portID + "\u4e0d\u5b58\u5728\uff01"));
        }
        SerialPort serialPort = serialport;
        synchronized (serialPort) {
            try {
                serialport.closePort();
                device.setUsingStatus(ENCODING_SIMPLE_CHINESE);
            }
            catch (SerialPortException e2) {
                if (!serialport.isOpened()) {
                    log.info((Object)("\u7aef\u53e3" + portID + "\u5173\u95ed\u6210\u529f"));
                    device.setUsingStatus(ENCODING_SIMPLE_CHINESE);
                }
                log.error((Object)("\u7aef\u53e3" + portID + "\u5173\u95ed\u5931\u8d25"));
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readBigDipperMessages() {
        List<BigDipperBean> BDDeviceList = bdDeviceInfoGetter.getUsingBDs();
        for (int i2 = 0; i2 < BDDeviceList.size(); ++i2) {
            boolean checkResult;
            BigDipperBean device = BDDeviceList.get(i2);
            if (ENCODING_SIMPLE_CHINESE.equals(device.getUsingStatus()) || !(checkResult = bdDeviceInfoGetter.checkAuthorizeInfo(device.getPortID(), null)) || ENCODING_IN_UFT8.equals(device.getUsingStatus())) continue;
            ArrayList<String> messageList = new ArrayList<String>();
            SerialPort serialPort = bdDeviceInfoGetter.getSerialPort(device.getPortID());
            if (!BDDriver.serialportConnected(serialPort)) {
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException e2) {
                    log.info((Object)"\u7b49\u5f85\u7aef\u53e3\u72b6\u6001\u548c\u8bbe\u5907\u72b6\u6001\u540c\u6b65\u65f6\u88ab\u6253\u65ad...");
                }
                if (ENCODING_IN_8BIT.equals(device.getUsingStatus())) {
                    log.error((Object)"\u8bbe\u5907\u8fde\u63a5\u5f02\u5e38\uff0c\u5373\u5c06\u91cd\u542f\uff01\u3010readBigDipperMessages\u3011");
                    device.setUsingStatus(ENCODING_IN_UFT8);
                    WatchDog.getInstance().interrupt();
                }
            }
            SerialPort e2 = serialPort;
            synchronized (e2) {
                byte[] messageByteArray = null;
                messageByteArray = BDDriver.getBytesResponse(serialPort, "GBK");
                if (!(messageByteArray != null && messageByteArray.length != 0 || bdMessageHolder.getMessageList(device) != null && !bdMessageHolder.getMessageList(device).isEmpty())) {
                    log.info((Object)("\u8bbe\u5907" + device.getGatewayID() + "\u6ca1\u6709\u6536\u5230\u4fe1\u606f\u3002\u3002\u3002"));
                    continue;
                }
                this.getCompleteMessages(messageByteArray, serialPort, "\u6536\u4fe1\u7ebf\u7a0b");
                if (bdMessageHolder.getMessageList(device) != null && !bdMessageHolder.getMessageList(device).isEmpty()) {
                    messageList.addAll(bdMessageHolder.getMessageList(device));
                    bdMessageHolder.clearMessageList(device);
                }
            }
            for (int j2 = 0; j2 < messageList.size(); ++j2) {
                String message;
                String encodingType;
                String originator;
                InboundMessage msg;
                block16: {
                    String text = (String)messageList.get(j2);
                    if (text == null || text.equals("")) continue;
                    msg = null;
                    String messageID = "";
                    String numberOfSlicesInHexStr = "";
                    String currentNumberOfSlicesInHexStr = "";
                    originator = "";
                    encodingType = "";
                    message = "";
                    log.info((Object)("\u8bbe\u5907" + device.getGatewayID() + "\u6536\u5230\u4fe1\u606f:" + text));
                    String[] splitMessages = text.split(",");
                    try {
                        originator = Utils.complementStrWithZero(splitMessages[2], 7);
                        encodingType = Utils.complementStrWithZero(splitMessages[3], 1);
                        message = splitMessages[5];
                        if (bdMessageHolder.getCodingType(encodingType) == Message.MessageEncodings.ENCUCS2) {
                            message = message.substring(2);
                        }
                        message = message.substring(0, message.length() - 3);
                        if (bdMessageHolder.getCodingType(encodingType) == Message.MessageEncodings.ENCUCS2) {
                            message = Utils.getString(Utils.hexStr2ByteArr(message), "GBK");
                            String attachInfo = message.substring(0, 15);
                            message = message.substring(15);
                            message = attachInfo + message;
                        }
                        messageID = message.substring(0, 8);
                        message = message.substring(8);
                        numberOfSlicesInHexStr = message.substring(0, 2);
                        message = message.substring(2);
                        currentNumberOfSlicesInHexStr = message.substring(0, 2);
                        Integer.valueOf(currentNumberOfSlicesInHexStr, 16);
                        message = message.substring(2);
                        message = message.substring(3);
                        String receiveDevice = device.getGatewayID();
                        String formattedReceiveDevice = Utils.complementStrWithSpace(receiveDevice, 15);
                        if (bdMessageHolder.getCodingType(encodingType) == Message.MessageEncodings.SC) break block16;
                        message = messageID + numberOfSlicesInHexStr + currentNumberOfSlicesInHexStr + originator + encodingType + message + formattedReceiveDevice;
                    }
                    catch (Exception e3) {
                        log.info((Object)("\u4fe1\u606f\u3010" + text + "\u3011\u683c\u5f0f\u5f02\u5e38\uff0c\u4e22\u5f03..."), (Throwable)e3);
                        continue;
                    }
                }
                msg = new InboundMessage(new Date(), originator, message, device.getGatewayID());
                if (bdMessageHolder.getCodingType(encodingType) == Message.MessageEncodings.SC) {
                    msg.setMessageID("00000063");
                }
                msg.setEncoding(bdMessageHolder.getCodingType(encodingType));
                msg.setText(message);
                msg.setOriginator(originator);
                msg.setGatewayId(device.getGatewayID());
                bdMessageHolder.addMessage(msg);
            }
        }
    }

    public List<InboundMessage> getMessages(List<TmpMsg> tmpMsgList) {
        ArrayList<InboundMessage> msgList = new ArrayList<InboundMessage>();
        if (tmpMsgList == null || tmpMsgList.isEmpty()) {
            return msgList;
        }
        for (int i2 = 0; i2 < tmpMsgList.size(); ++i2) {
            TmpMsg tmpMsg = tmpMsgList.get(i2);
            if (tmpMsg.getMemindex() != 0 || Utils.isEmptyStr(tmpMsg.getMemlocation()) || !"BD".equals(tmpMsg.getMemlocation()) || tmpMsg.getMl() != 0) continue;
            try {
                String tmpText = tmpMsg.getPdustring();
                String receiveDevice = tmpText.substring(tmpText.length() - 15).trim();
                tmpText = tmpText.substring(0, tmpText.length() - 15);
                String messageID = tmpText.substring(0, 8);
                tmpText = tmpText.substring(8);
                String numberOfSlicesStr = tmpText.substring(0, 2);
                int numberOfSlices = Integer.valueOf(numberOfSlicesStr, 16);
                tmpText = tmpText.substring(2);
                String currentNumberOfSlicesInHexStr = tmpText.substring(0, 2);
                tmpText = tmpText.substring(2);
                String originator = tmpText.substring(0, 7);
                tmpText = tmpText.substring(7);
                String encodingType = tmpText.substring(0, 1);
                tmpText = tmpText.substring(1);
                String messageKey = messageID + originator;
                tmpText = currentNumberOfSlicesInHexStr + tmpText;
                if (!messageIDReceiveDeviceIDMap.containsKey(messageKey)) {
                    messageIDReceiveDeviceIDMap.put(messageKey, receiveDevice);
                }
                if (!messageIDCodingTypeMap.containsKey(messageKey)) {
                    messageIDCodingTypeMap.put(messageKey, encodingType);
                }
                if (!messageIDOReceiveDateMap.containsKey(messageKey)) {
                    messageIDOReceiveDateMap.put(messageKey, new Date());
                }
                if (!messageIDExpectMessageNumMap.containsKey(messageKey)) {
                    messageIDExpectMessageNumMap.put(messageKey, numberOfSlices);
                }
                if (messageIDSplitedMessagesMap.containsKey(messageKey)) {
                    messageIDSplitedMessagesMap.get(messageKey).add(tmpText);
                    continue;
                }
                HashSet<String> messageSet = new HashSet<String>();
                messageSet.add(tmpText);
                messageIDSplitedMessagesMap.put(messageKey, messageSet);
                continue;
            }
            catch (Exception e2) {
                log.info((Object)("\u4e34\u65f6\u8868\u4fe1\u606f\u683c\u5f0f\u5f02\u5e38\uff1a" + tmpMsg.getPdustring()), (Throwable)e2);
                Utils.deleteTmpmsg(tmpMsg.getPdustring(), "BD");
            }
        }
        if (messageIDSplitedMessagesMap.isEmpty()) {
            return msgList;
        }
        Iterator<Map.Entry<String, HashSet<String>>> iter = messageIDSplitedMessagesMap.entrySet().iterator();
        while (iter.hasNext() && !messageIDExpectMessageNumMap.isEmpty()) {
            try {
                Map.Entry<String, HashSet<String>> entry = iter.next();
                String messageKey = entry.getKey();
                HashSet<String> messageSet = entry.getValue();
                int splitNumber = messageIDExpectMessageNumMap.get(messageKey);
                InboundMessage msg = new InboundMessage(messageKey);
                msg.setError(false);
                if (messageSet.size() != splitNumber) {
                    long hours;
                    if (!messageIDOReceiveDateMap.containsKey(messageKey)) continue;
                    Date startReceiveDate = messageIDOReceiveDateMap.get(messageKey);
                    Date now = new Date();
                    int diffhours = 5;
                    try {
                        diffhours = Integer.parseInt(JDSMSServer.getInstance().getProperties().getString("settings.recvdiff", "5"));
                    }
                    catch (Exception e3) {
                        log.error((Object)"\u3010settings.recvdiff\u3011\u8bbe\u5b9a\u5f02\u5e38\uff0c\u4f7f\u7528\u9ed8\u8ba4\u503c\uff1a5\uff08\u5c0f\u65f6\uff09\u3002");
                    }
                    if ((hours = (now.getTime() - startReceiveDate.getTime()) / 3600000L) <= (long)diffhours) continue;
                    msg.setError(true);
                    msgList.add(msg);
                    continue;
                }
                msgList.add(msg);
            }
            catch (Exception e4) {
                log.info((Object)"\u4e34\u65f6\u8868\u4fe1\u606f\u5206\u6790\u5f02\u5e38\uff01", (Throwable)e4);
            }
        }
        Iterator<InboundMessage> iters = msgList.iterator();
        while (iters.hasNext()) {
            try {
                InboundMessage msg = iters.next();
                String messageKey = msg.getMessageID();
                String messageID = messageKey.substring(0, 8);
                String originator = messageKey.substring(8);
                this.a(messageIDSplitedMessagesMap.get(messageKey), msg, messageIDExpectMessageNumMap.get(messageKey));
                msg.setGatewayId(messageIDReceiveDeviceIDMap.get(messageKey));
                msg.setEncoding(bdMessageHolder.getCodingType(messageIDCodingTypeMap.get(messageKey)));
                msg.setOriginator(originator);
                msg.setDate(messageIDOReceiveDateMap.get(messageKey));
                msg.setMessageID(messageID);
            }
            catch (Exception e5) {
                log.info((Object)"\u4e34\u65f6\u8868\u4fe1\u606f\u6574\u5408\u5f02\u5e38\uff01", (Throwable)e5);
            }
        }
        this.a();
        return msgList;
    }

    private void a(HashSet<String> hashSet, InboundMessage msg, int numberOfSlices) {
        ArrayList<String> messageList = Utils.getEmptyList(numberOfSlices);
        for (String message : hashSet) {
            String currentNumberOfSlicesInHexStr = message.substring(0, 2);
            int currentNumberOfSlices = Integer.valueOf(currentNumberOfSlicesInHexStr, 16);
            message = message.substring(2);
            messageList.set(currentNumberOfSlices - 1, message);
        }
        StringBuffer buffer = new StringBuffer();
        for (int i2 = 0; i2 < messageList.size(); ++i2) {
            if (Utils.isEmptyStr(messageList.get(i2))) {
                buffer.append("*****");
                continue;
            }
            buffer.append(messageList.get(i2));
        }
        msg.setText(buffer.toString());
    }

    private void a() {
        messageIDReceiveDeviceIDMap.clear();
        messageIDCodingTypeMap.clear();
        messageIDOReceiveDateMap.clear();
        messageIDExpectMessageNumMap.clear();
        messageIDSplitedMessagesMap.clear();
    }

    @Override
    public String getSerialNumber(SerialPort serialPort) {
        return "";
    }

    @Override
    public boolean connectionOK(String portID) {
        SerialPort serialPort = bdDeviceInfoGetter.getSerialPort(portID);
        return ModemDriver.readPortInputBufferUsedSize(serialPort) >= 0;
    }

    private static class a {
        private static BDDriver a = new BDDriver();

        private a() {
        }
    }
}

