/*
 * Decompiled with CFR 0.152.
 */
package cn.sendsms.otherModem.nbiot;

import cn.sendsms.otherModem.bean.NbIoTBean;
import cn.sendsms.otherModem.common.Utils;
import cn.sendsms.otherModem.driver.nbiotDriver.VirtualNbIoTDriver;
import cn.sendsms.otherModem.nbiot.NbIoTDeviceInfoGetter;
import cn.sendsms.otherModem.nbiot.NbIoTMessageHolder;
import cn.sendsms.otherModem.thread.WatchDog;
import org.apache.log4j.Logger;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttMessage;

public class DeviceMqttCallback
implements MqttCallback {
    private String a;
    public static final Logger log = Logger.getRootLogger();

    public DeviceMqttCallback(String communicationID) {
        this.a = communicationID;
    }

    public void connectionLost(Throwable cause) {
        log.error((Object)("connectionLost:" + cause.getMessage()));
        NbIoTBean device = NbIoTDeviceInfoGetter.getInstance().findVitualNbIoTBeanByCommunicationID(this.a);
        if (device != null) {
            log.info((Object)("\u8bbe\u5907" + device.getGatewayID() + "\u5373\u5c06\u91cd\u542f"));
            device.setUsingStatus("2");
            WatchDog.getInstance().interrupt();
        }
    }

    public void messageArrived(String topic, MqttMessage message) throws Exception {
        NbIoTBean device = NbIoTDeviceInfoGetter.getInstance().findVitualNbIoTBeanByCommunicationID(topic);
        String context = "";
        boolean bDecodeOk = false;
        try {
            context = VirtualNbIoTDriver.getInstance().decodeMessage(message.toString());
            bDecodeOk = true;
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            // empty catch block
        }
        if (!bDecodeOk) {
            log.info((Object)("receive: [topic]:" + topic + "  [msg] \u89e3\u7801\u9519\u8bef"));
            return;
        }
        if (Utils.isEmptyStr(context)) {
            log.info((Object)("receive: [topic]:" + topic + "  [msg]:" + message.toString() + "\u4e22\u5931\uff01"));
        } else {
            NbIoTMessageHolder.getInstance().updateMessageList(device, context);
            log.info((Object)("receive: [topic]:" + topic + "  [msg]:" + message.toString()));
        }
    }

    public void deliveryComplete(IMqttDeliveryToken token) {
        log.info((Object)("[isComplete]:" + token.isComplete() + "       " + token.getTopics()));
    }

    public String getCommunicationID() {
        return this.a;
    }

    public void setCommunicationID(String communicationID) {
        this.a = communicationID;
    }
}

