/*
 * Decompiled with CFR 0.152.
 */
package cn.sendsms.otherModem.nbiot.authorize;

import cn.sendsms.jdsmsserver.JDSMSServer;
import cn.sendsms.otherModem.common.DesUtils;
import cn.sendsms.otherModem.common.Utils;
import cn.sendsms.otherModem.nbiot.authorize.AuthorizeInfo;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.log4j.Logger;

public class NbIoTAuthorize {
    private static final String HTTP_TRANSFER_SECRET_KEY = "l1gEgX#jnMau@Csi";
    private static final String HTTP_PASSWORD = "jd.110110";
    private static final String ACTION_IS_AUTHORIZED = "isAuthorized";
    private static final String ACTION_AUTHORIZE_SUCESS = "authorizeSucess";
    private static final String ACTION_CANCELL_SUCESS = "cancellSucess";
    private static final Set<String> LEGAL_ACTIONS = new HashSet<String>(){
        {
            this.add(NbIoTAuthorize.ACTION_IS_AUTHORIZED);
            this.add(NbIoTAuthorize.ACTION_AUTHORIZE_SUCESS);
            this.add(NbIoTAuthorize.ACTION_CANCELL_SUCESS);
        }
    };
    private static DesUtils HTTPDesUtils;
    private static PropertiesConfiguration props;
    private static Logger log;

    private static void initHttPDesUtils() {
        try {
            if (HTTPDesUtils == null) {
                HTTPDesUtils = new DesUtils(HTTP_TRANSFER_SECRET_KEY);
            }
        }
        catch (Exception e2) {
            log.error((Object)"\u6388\u6743\u5f02\u5e38\uff01");
        }
    }

    public static String getAuthorizeInfoFromServer(String token, String action, String para) {
        try {
            String urlStr = "";
            String authorizeServer = props.getString("settings.mqtt_authorize_server", "192.168.0.80");
            String authorizePort = props.getString("settings.mqtt_authorize_port", "8060");
            if (Utils.isEmptyStr(authorizeServer) || Utils.isEmptyStr(authorizePort) || Utils.isEmptyStr(token) || Utils.isEmptyStr(action) || Utils.isEmptyStr(para)) {
                log.error((Object)"\u8bbe\u5907\u6388\u6743\u670d\u52a1\u5668\u8fde\u63a5\u53c2\u6570\u5f02\u5e38\uff01");
                return "";
            }
            if (!Utils.isConnectionOK(authorizeServer, Integer.valueOf(authorizePort))) {
                log.error((Object)"\u6388\u6743\u670d\u52a1\u5668\u8fde\u63a5\u5f02\u5e38\uff01");
                return "";
            }
            if (!NbIoTAuthorize.isActionAndParaLegal(action, para)) {
                log.error((Object)("\u8bf7\u6c42" + action + "\u6216\u8005\u53c2\u6570" + para + "\u4e0d\u5408\u6cd5\uff01"));
                return "";
            }
            NbIoTAuthorize.initHttPDesUtils();
            urlStr = "http://" + authorizeServer + ":" + authorizePort + "/authorize?token=" + HTTPDesUtils.encrypt(token) + "&action=" + HTTPDesUtils.encrypt(action) + "&para=" + HTTPDesUtils.encrypt(para) + "&password=" + HTTPDesUtils.encrypt(HTTP_PASSWORD);
            URL url = new URL(urlStr);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setRequestProperty("content-type", "text/html");
            conn.setDoOutput(true);
            if (conn.getResponseCode() != 200) {
                return "";
            }
            BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream(), "utf-8"));
            StringBuffer sb = new StringBuffer();
            String s = "";
            while ((s = rd.readLine()) != null) {
                sb.append(s);
            }
            if (sb.length() == 0) {
                sb.append("[]");
            }
            String result = sb.toString();
            rd.close();
            conn.disconnect();
            return NbIoTAuthorize.getDecodedResult(result);
        }
        catch (Exception e2) {
            log.error((Object)"\u8bf7\u6c42\u5f02\u5e38\uff01", (Throwable)e2);
            return "";
        }
    }

    public static boolean isActionAndParaLegal(String action, String para) {
        if (LEGAL_ACTIONS.contains(action)) {
            if (action.equals(ACTION_IS_AUTHORIZED) || action.equals(ACTION_CANCELL_SUCESS)) {
                String[] paraArray = para.split(",");
                if (paraArray.length >= 1) {
                    return !Utils.isEmptyStr(paraArray[0]);
                }
                return false;
            }
            if (action.equals(ACTION_AUTHORIZE_SUCESS)) {
                if (para.startsWith("[") && para.endsWith("]")) {
                    String[] paraArray = para.split(",");
                    if (paraArray.length >= 3) {
                        return !Utils.isEmptyStr(paraArray[0]) && !Utils.isEmptyStr(paraArray[1]) && !Utils.isEmptyStr(paraArray[2]);
                    }
                    return false;
                }
                return false;
            }
            return false;
        }
        return false;
    }

    private static String getDecodedResult(String encodedResult) {
        String decodeResult = "";
        try {
            int startIndex = encodedResult.indexOf("<result>");
            int lastIndex = encodedResult.indexOf("</result>");
            decodeResult = HTTPDesUtils.decrypt(encodedResult.substring(startIndex + 8, lastIndex));
        }
        catch (Exception e2) {
            log.error((Object)("\u6388\u6743\u670d\u52a1\u5668\u8fd4\u56de\u7ed3\u679c\u89e3\u5bc6\u5931\u8d25\uff1a" + encodedResult));
        }
        return decodeResult;
    }

    public static String HttpDecodeDes(String encodeStr) {
        NbIoTAuthorize.initHttPDesUtils();
        String decodeStr = "";
        try {
            decodeStr = HTTPDesUtils.decrypt(encodeStr);
        }
        catch (Exception e2) {
            log.error((Object)("\u6388\u6743\u670d\u52a1\u5668\u8fd4\u56de\u7ed3\u679c\u89e3\u5bc6\u5931\u8d25\uff1a" + encodeStr));
        }
        return decodeStr;
    }

    public static String generatePara(AuthorizeInfo authorizeInfo) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[");
        buffer.append(authorizeInfo.getSerialNum());
        buffer.append(",");
        buffer.append(authorizeInfo.getRegCode());
        buffer.append(",");
        buffer.append(authorizeInfo.getCompany());
        buffer.append(",");
        buffer.append(authorizeInfo.getUseId());
        buffer.append(",");
        buffer.append(authorizeInfo.getTelephone());
        buffer.append("]");
        return buffer.toString();
    }

    public static String generateToken() {
        return "AAAAAA";
    }

    static {
        props = JDSMSServer.getInstance().getProperties();
        log = Logger.getRootLogger();
    }
}

