/*
 * Decompiled with CFR 0.152.
 */
package cn.ajwcc.pduUtils.gsm3040;

import cn.ajwcc.pduUtils.gsm3040.Pdu;
import cn.ajwcc.pduUtils.gsm3040.PduUtils;
import cn.ajwcc.pduUtils.gsm3040.SmsDeliveryPdu;
import cn.ajwcc.pduUtils.gsm3040.SmsStatusReportPdu;
import cn.ajwcc.pduUtils.gsm3040.SmsSubmitPdu;
import cn.ajwcc.pduUtils.gsm3040.ie.ConcatInformationElement;
import cn.ajwcc.pduUtils.gsm3040.ie.InformationElement;
import cn.ajwcc.pduUtils.gsm3040.ie.InformationElementFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PduGenerator {
    private ByteArrayOutputStream _$3;
    private int _$2 = -1;
    private boolean _$1 = false;

    protected void writeSmscInfo(Pdu pdu) throws Exception {
        if (pdu.getSmscAddress() != null) {
            this.writeBCDAddress(pdu.getSmscAddress(), pdu.getSmscAddressType(), pdu.getSmscInfoLength());
        } else {
            this.writeByte(0);
        }
    }

    protected void writeFirstOctet(Pdu pdu) {
        this._$2 = pdu.getSmscInfoLength() + 1;
        this.writeByte(pdu.getFirstOctet());
    }

    protected void writeValidityPeriodInteger(int n) {
        if (n == -1) {
            this._$3.write(255);
        } else {
            int n2 = n <= 12 ? n * 12 - 1 : (n <= 24 ? (n - 12) * 2 + 143 : (n <= 720 ? n / 24 + 166 : n / 168 + 192));
            this._$3.write(n2);
        }
    }

    protected void writeTimeStampStringForDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int n = calendar.get(1) - 2000;
        int n2 = calendar.get(2) + 1;
        int n3 = calendar.get(5);
        int n4 = calendar.get(11);
        int n5 = calendar.get(12);
        int n6 = calendar.get(13);
        TimeZone timeZone = calendar.getTimeZone();
        int n7 = timeZone.getOffset(date.getTime());
        int n8 = n7 / 60000;
        int n9 = n8 / 15;
        if (n9 < 0) {
            n9 = 128 - n9;
        }
        this._$3.write(PduUtils.createSwappedBCD(n));
        this._$3.write(PduUtils.createSwappedBCD(n2));
        this._$3.write(PduUtils.createSwappedBCD(n3));
        this._$3.write(PduUtils.createSwappedBCD(n4));
        this._$3.write(PduUtils.createSwappedBCD(n5));
        this._$3.write(PduUtils.createSwappedBCD(n6));
        this._$3.write(PduUtils.createSwappedBCD(n9));
    }

    protected void writeAddress(String string, int n, int n2) throws Exception {
        switch (PduUtils.extractAddressType(n)) {
            case 80: {
                byte[] byArray = PduUtils.stringToUnencodedSeptets(string);
                byte[] byArray2 = PduUtils.encode7bitUserData(null, byArray);
                this._$3.write(byArray2.length * 2);
                this._$3.write(n);
                this._$3.write(byArray2);
                break;
            }
            default: {
                this.writeBCDAddress(string, n, n2);
            }
        }
    }

    protected void writeBCDAddress(String string, int n, int n2) throws Exception {
        this._$3.write(n2);
        this._$3.write(n);
        if (string.length() % 2 == 1) {
            string = string + "F";
        }
        int n3 = 0;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (i % 2 == 1) {
                this._$3.write(n3 |= Integer.parseInt(Character.toString(c), 16) << 4);
                n3 = 0;
                continue;
            }
            n3 |= Integer.parseInt(Character.toString(c), 16) & 0xF;
        }
    }

    protected void writeUDData(Pdu pdu, int n, int n2) {
        int n3 = pdu.getDataCodingScheme();
        try {
            switch (PduUtils.extractDcsEncoding(n3)) {
                case 0: {
                    this.writeUDData7bit(pdu, n, n2);
                    break;
                }
                case 4: {
                    this._$2(pdu, n, n2);
                    break;
                }
                case 8: {
                    this.writeUDDataUCS2(pdu, n, n2);
                    break;
                }
                default: {
                    throw new RuntimeException("Invalid DCS encoding: " + PduUtils.extractDcsEncoding(n3));
                }
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private void _$2(Pdu pdu, int n, int n2) throws Exception {
        byte[] byArray = pdu.isBinary() ? PduUtils.convertByteArr(pdu.getDataBytes()) : PduUtils.hexStr2ByteArr(pdu.getDecodedText());
        int n3 = this.computePotentialUdhLength(pdu);
        this.checkForConcat(pdu, byArray.length, 140 - pdu.getTotalUDHLength(), 140 - n3, n, n2);
        int n4 = pdu.getTotalUDHLength();
        int n5 = 140 - n4;
        int n6 = this.computeOffset(pdu, n5, n2);
        byte[] byArray2 = new byte[Math.min(n5, byArray.length - n6)];
        System.arraycopy(byArray, n6, byArray2, 0, byArray2.length);
        int n7 = n4 + byArray2.length;
        this._$3.write(n7);
        if (pdu.hasTpUdhi()) {
            this.writeUDH(pdu, this._$3);
        }
        this._$3.write(byArray2);
    }

    protected void writeUDH(Pdu pdu) throws IOException {
        this.writeUDH(pdu, this._$3);
    }

    protected void writeUDH(Pdu pdu, ByteArrayOutputStream byteArrayOutputStream) throws IOException {
        byteArrayOutputStream.write(pdu.getUDHLength());
        Iterator<InformationElement> iterator = pdu.getInformationElements();
        while (iterator.hasNext()) {
            InformationElement informationElement = iterator.next();
            byteArrayOutputStream.write(informationElement.getIdentifier());
            byteArrayOutputStream.write(informationElement.getLength());
            byteArrayOutputStream.write(informationElement.getData());
        }
    }

    protected int computeOffset(Pdu pdu, int n, int n2) {
        int n3;
        int n4 = 1;
        n4 = !pdu.isBinary() ? pdu.getDecodedText().length() / n + 1 : pdu.getDataBytes().length / n + 1;
        if (pdu.hasTpUdhi() && pdu.getConcatInfo() != null && n2 > 0) {
            pdu.getConcatInfo().setMpMaxNo(n4);
        }
        if (n4 > 1 && n2 > 0) {
            if (n2 > n4) {
                throw new RuntimeException("Invalid partNo: " + n2 + ", maxParts=" + n4);
            }
            n3 = (n2 - 1) * n;
        } else {
            n3 = 0;
        }
        return n3;
    }

    protected void checkForConcat(Pdu pdu, int n, int n2, int n3, int n4, int n5) {
        if (n > n3 && (n <= n3 || n > n2)) {
            if (pdu.getConcatInfo() != null) {
                pdu.getConcatInfo().setMpRefNo(n4);
                pdu.getConcatInfo().setMpSeqNo(n5);
            } else {
                ConcatInformationElement concatInformationElement = InformationElementFactory.generateConcatInfo(n4, n5);
                pdu.addInformationElement(concatInformationElement);
                this._$1 = true;
            }
        }
    }

    protected int computePotentialUdhLength(Pdu pdu) {
        int n = pdu.getTotalUDHLength();
        if (n == 0) {
            return ConcatInformationElement.getDefaultConcatLength() + 1;
        }
        return n + ConcatInformationElement.getDefaultConcatLength();
    }

    protected void writeUDData7bit(Pdu pdu, int n, int n2) throws Exception {
        Object object;
        String string = pdu.getDecodedText();
        byte[] byArray = PduUtils.stringToUnencodedSeptets(string);
        int n3 = PduUtils.getNumSeptetsForOctets(this.computePotentialUdhLength(pdu));
        this.checkForConcat(pdu, byArray.length, 160 - PduUtils.getNumSeptetsForOctets(pdu.getTotalUDHLength()), 160 - n3, n, n2);
        int n4 = pdu.getTotalUDHLength();
        int n5 = 160 - PduUtils.getNumSeptetsForOctets(n4);
        byte[] byArray2 = this._$1(pdu, n5, n2);
        int n6 = PduUtils.getNumSeptetsForOctets(n4) + byArray2.length;
        this._$3.write(n6);
        byte[] byArray3 = null;
        if (pdu.hasTpUdhi()) {
            object = new ByteArrayOutputStream();
            this.writeUDH(pdu, (ByteArrayOutputStream)object);
            byArray3 = ((ByteArrayOutputStream)object).toByteArray();
        }
        object = PduUtils.encode7bitUserData(byArray3, byArray2);
        this._$3.write((byte[])object);
    }

    private byte[] _$1(Pdu pdu, int n, int n2) {
        int n3;
        int n4 = 1;
        byte[] byArray = PduUtils.stringToUnencodedSeptets(pdu.getDecodedText());
        n4 = byArray.length / n + 1;
        if (pdu.hasTpUdhi() && pdu.getConcatInfo() != null && n2 > 0) {
            pdu.getConcatInfo().setMpMaxNo(n4);
        }
        if (n4 > 1 && n2 > 0) {
            if (n2 > n4) {
                throw new RuntimeException("Invalid partNo: " + n2 + ", maxParts=" + n4);
            }
            n3 = (n2 - 1) * n;
        } else {
            n3 = 0;
        }
        byte[] byArray2 = new byte[Math.min(n, byArray.length - n3)];
        System.arraycopy(byArray, n3, byArray2, 0, byArray2.length);
        return byArray2;
    }

    protected void writeUDData8bit(Pdu pdu, int n, int n2) throws Exception {
        byte[] byArray = pdu.isBinary() ? pdu.getDataBytes() : PduUtils.encode8bitUserData(pdu.getDecodedText());
        int n3 = this.computePotentialUdhLength(pdu);
        this.checkForConcat(pdu, byArray.length, 140 - pdu.getTotalUDHLength(), 140 - n3, n, n2);
        int n4 = pdu.getTotalUDHLength();
        int n5 = 140 - n4;
        int n6 = this.computeOffset(pdu, n5, n2);
        byte[] byArray2 = new byte[Math.min(n5, byArray.length - n6)];
        System.arraycopy(byArray, n6, byArray2, 0, byArray2.length);
        int n7 = n4 + byArray2.length;
        this._$3.write(n7);
        if (pdu.hasTpUdhi()) {
            this.writeUDH(pdu, this._$3);
        }
        this._$3.write(byArray2);
    }

    protected void writeUDDataUCS2(Pdu pdu, int n, int n2) throws Exception {
        String string = pdu.getDecodedText();
        int n3 = this.computePotentialUdhLength(pdu);
        this.checkForConcat(pdu, string.length(), (140 - pdu.getTotalUDHLength()) / 2, (140 - n3) / 2, n, n2);
        int n4 = pdu.getTotalUDHLength();
        int n5 = (140 - n4) / 2;
        int n6 = this.computeOffset(pdu, n5, n2);
        String string2 = string.substring(n6, Math.min(n6 + n5, string.length()));
        int n7 = n4 + string2.length() * 2;
        this._$3.write(n7);
        if (pdu.hasTpUdhi()) {
            this.writeUDH(pdu, this._$3);
        }
        this._$3.write(PduUtils.encodeUcs2UserData(string2));
    }

    protected void writeByte(int n) {
        this._$3.write(n);
    }

    protected void writeBytes(byte[] byArray) throws Exception {
        this._$3.write(byArray);
    }

    public List<String> generatePduList(Pdu pdu, int n) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 1; i <= pdu.getMpMaxNo(); ++i) {
            String string = this.generatePduString(pdu, n, i);
            arrayList.add(string);
        }
        return arrayList;
    }

    public String generatePduString(Pdu pdu) {
        return this.generatePduString(pdu, -1, -1);
    }

    public String generatePduString(Pdu pdu, int n, int n2) {
        try {
            this._$3 = new ByteArrayOutputStream();
            this._$2 = -1;
            this._$1 = false;
            if (!pdu.isBinary() && pdu.getDecodedText().compareToIgnoreCase("!$!$") == 0) {
                this.generateSmsNoShowString((SmsSubmitPdu)pdu);
                byte[] byArray = this._$3.toByteArray();
                return PduUtils.bytesToPdu(byArray);
            }
            switch (pdu.getTpMti()) {
                case 0: {
                    this.generateSmsDeliverPduString((SmsDeliveryPdu)pdu, n, n2);
                    break;
                }
                case 1: {
                    this.generateSmsSubmitPduString((SmsSubmitPdu)pdu, n, n2);
                    break;
                }
                case 2: {
                    this.generateSmsStatusReportPduString((SmsStatusReportPdu)pdu);
                }
            }
            byte[] byArray = this._$3.toByteArray();
            if (this._$1) {
                byArray[this._$2] = (byte)(pdu.getFirstOctet() & 0xFF);
            }
            return PduUtils.bytesToPdu(byArray);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    protected void generateSmsNoShowString(SmsSubmitPdu smsSubmitPdu) throws Exception {
        this.writeSmscInfo(smsSubmitPdu);
        this.writeFirstOctet(smsSubmitPdu);
        this.writeByte(smsSubmitPdu.getMessageReference());
        this.writeAddress(smsSubmitPdu.getAddress(), smsSubmitPdu.getAddressType(), smsSubmitPdu.getAddress().length());
        this.writeByte(64);
        this.writeByte(192);
        switch (smsSubmitPdu.getTpVpf()) {
            case 16: {
                this.writeValidityPeriodInteger(smsSubmitPdu.getValidityPeriod());
                break;
            }
            case 24: {
                this.writeTimeStampStringForDate(smsSubmitPdu.getValidityDate());
            }
        }
        this.writeByte(0);
    }

    protected void generateSmsSubmitPduString(SmsSubmitPdu smsSubmitPdu, int n, int n2) throws Exception {
        this.writeSmscInfo(smsSubmitPdu);
        this.writeFirstOctet(smsSubmitPdu);
        this.writeByte(smsSubmitPdu.getMessageReference());
        this.writeAddress(smsSubmitPdu.getAddress(), smsSubmitPdu.getAddressType(), smsSubmitPdu.getAddress().length());
        this.writeByte(smsSubmitPdu.getProtocolIdentifier());
        this.writeByte(smsSubmitPdu.getDataCodingScheme());
        switch (smsSubmitPdu.getTpVpf()) {
            case 16: {
                this.writeValidityPeriodInteger(smsSubmitPdu.getValidityPeriod());
                break;
            }
            case 24: {
                this.writeTimeStampStringForDate(smsSubmitPdu.getValidityDate());
            }
        }
        this.writeUDData(smsSubmitPdu, n, n2);
    }

    protected void generateSmsDeliverPduString(SmsDeliveryPdu smsDeliveryPdu, int n, int n2) throws Exception {
        this.writeSmscInfo(smsDeliveryPdu);
        this.writeFirstOctet(smsDeliveryPdu);
        this.writeAddress(smsDeliveryPdu.getAddress(), smsDeliveryPdu.getAddressType(), smsDeliveryPdu.getAddress().length());
        this.writeByte(smsDeliveryPdu.getProtocolIdentifier());
        this.writeByte(smsDeliveryPdu.getDataCodingScheme());
        this.writeTimeStampStringForDate(smsDeliveryPdu.getTimestamp());
        this.writeUDData(smsDeliveryPdu, n, n2);
    }

    protected void generateSmsStatusReportPduString(SmsStatusReportPdu smsStatusReportPdu) throws Exception {
        this.writeSmscInfo(smsStatusReportPdu);
        this.writeFirstOctet(smsStatusReportPdu);
        this.writeByte(smsStatusReportPdu.getMessageReference());
        this.writeAddress(smsStatusReportPdu.getAddress(), smsStatusReportPdu.getAddressType(), smsStatusReportPdu.getAddress().length());
        this.writeTimeStampStringForDate(smsStatusReportPdu.getTimestamp());
        this.writeTimeStampStringForDate(smsStatusReportPdu.getDischargeTime());
        this.writeByte(smsStatusReportPdu.getStatus());
    }
}

