/*
 * Decompiled with CFR 0.152.
 */
package cn.ajwcc.pduUtils.gsm3040;

import cn.ajwcc.pduUtils.gsm3040.Pdu;
import java.io.ByteArrayOutputStream;
import java.lang.reflect.Method;
import java.util.BitSet;

public class PduUtils {
    private static final char[][] _$4 = new char[][]{{'\u0386', 'A'}, {'\u0388', 'E'}, {'\u0389', 'H'}, {'\u038a', 'I'}, {'\u038c', 'O'}, {'\u038e', 'Y'}, {'\u038f', '\u03a9'}, {'\u0390', 'I'}, {'\u0391', 'A'}, {'\u0392', 'B'}, {'\u0393', '\u0393'}, {'\u0394', '\u0394'}, {'\u0395', 'E'}, {'\u0396', 'Z'}, {'\u0397', 'H'}, {'\u0398', '\u0398'}, {'\u0399', 'I'}, {'\u039a', 'K'}, {'\u039b', '\u039b'}, {'\u039c', 'M'}, {'\u039d', 'N'}, {'\u039e', '\u039e'}, {'\u039f', 'O'}, {'\u03a0', '\u03a0'}, {'\u03a1', 'P'}, {'\u03a3', '\u03a3'}, {'\u03a4', 'T'}, {'\u03a5', 'Y'}, {'\u03a6', '\u03a6'}, {'\u03a7', 'X'}, {'\u03a8', '\u03a8'}, {'\u03a9', '\u03a9'}, {'\u03aa', 'I'}, {'\u03ab', 'Y'}, {'\u03ac', 'A'}, {'\u03ad', 'E'}, {'\u03ae', 'H'}, {'\u03af', 'I'}, {'\u03b0', 'Y'}, {'\u03b1', 'A'}, {'\u03b2', 'B'}, {'\u03b3', '\u0393'}, {'\u03b4', '\u0394'}, {'\u03b5', 'E'}, {'\u03b6', 'Z'}, {'\u03b7', 'H'}, {'\u03b8', '\u0398'}, {'\u03b9', 'I'}, {'\u03ba', 'K'}, {'\u03bb', '\u039b'}, {'\u03bc', 'M'}, {'\u03bd', 'N'}, {'\u03be', '\u039e'}, {'\u03bf', 'O'}, {'\u03c0', '\u03a0'}, {'\u03c1', 'P'}, {'\u03c2', '\u03a3'}, {'\u03c3', '\u03a3'}, {'\u03c4', 'T'}, {'\u03c5', 'Y'}, {'\u03c6', '\u03a6'}, {'\u03c7', 'X'}, {'\u03c8', '\u03a8'}, {'\u03c9', '\u03a9'}, {'\u03ca', 'I'}, {'\u03cb', 'Y'}, {'\u03cc', 'O'}, {'\u03cd', 'Y'}, {'\u03ce', '\u03a9'}};
    private static final char[] _$3 = new char[]{'\f', '^', '{', '}', '\\', '[', '~', ']', '|', '\u20ac'};
    private static final String[] _$2 = new String[]{"1b0a", "1b14", "1b28", "1b29", "1b2f", "1b3c", "1b3d", "1b3e", "1b40", "1b65"};
    private static final char[] _$1 = new char[]{'@', '\u00a3', '$', '\u00a5', '\u00e8', '\u00e9', '\u00f9', '\u00ec', '\u00f2', '\u00c7', '\n', '\u00d8', '\u00f8', '\r', '\u00c5', '\u00e5', '\u0394', '_', '\u03a6', '\u0393', '\u039b', '\u03a9', '\u03a0', '\u03a8', '\u03a3', '\u0398', '\u039e', '\u00a0', '\u00c6', '\u00e6', '\u00df', '\u00c9', ' ', '!', '\"', '#', '\u00a4', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '\u00a1', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '\u00c4', '\u00d6', '\u00d1', '\u00dc', '\u00a7', '\u00bf', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '\u00e4', '\u00f6', '\u00f1', '\u00fc', '\u00e0'};
    public static final int TP_MTI_MASK = 252;
    public static final int TP_MTI_SMS_DELIVER = 0;
    public static final int TP_MTI_SMS_SUBMIT = 1;
    public static final int TP_MTI_SMS_STATUS_REPORT = 2;
    public static final int TP_RD_MASK = 251;
    public static final int TP_RD_ACCEPT_DUPLICATES = 0;
    public static final int TP_RD_REJECT_DUPLICATES = 4;
    public static final int TP_MMS_MASK = 251;
    public static final int TP_MMS_NO_MESSAGES = 0;
    public static final int TP_MMS_MORE_MESSAGES = 4;
    public static final int TP_VPF_MASK = 231;
    public static final int TP_VPF_NONE = 0;
    public static final int TP_VPF_INTEGER = 16;
    public static final int TP_VPF_TIMESTAMP = 24;
    public static final int TP_SRI_MASK = 223;
    public static final int TP_SRI_NO_REPORT = 0;
    public static final int TP_SRI_REPORT = 32;
    public static final int TP_SRR_MASK = 223;
    public static final int TP_SRR_NO_REPORT = 0;
    public static final int TP_SRR_REPORT = 32;
    public static final int TP_UDHI_MASK = 191;
    public static final int TP_UDHI_NO_UDH = 0;
    public static final int TP_UDHI_WITH_UDH = 64;
    public static final int ADDRESS_NUMBER_PLAN_ID_MASK = 15;
    public static final int ADDRESS_NUMBER_PLAN_ID_UNKNOWN = 0;
    public static final int ADDRESS_NUMBER_PLAN_ID_TELEPHONE = 1;
    public static final int ADDRESS_TYPE_MASK = 112;
    public static final int ADDRESS_TYPE_UNKNOWN = 0;
    public static final int ADDRESS_TYPE_INTERNATIONAL = 16;
    public static final int ADDRESS_TYPE_ALPHANUMERIC = 80;
    public static final int DCS_CODING_GROUP_MASK = 15;
    public static final int DCS_CODING_GROUP_DATA = 240;
    public static final int DCS_CODING_GROUP_GENERAL = 192;
    public static final int DCS_ENCODING_MASK = 243;
    public static final int DCS_ENCODING_7BIT = 0;
    public static final int DCS_ENCODING_8BIT = 4;
    public static final int DCS_ENCODING_UCS2 = 8;
    public static final int DCS_MESSAGE_CLASS_MASK = 236;
    public static final int DCS_MESSAGE_CLASS_NONE = 0;
    public static final int DCS_MESSAGE_CLASS_FLASH = 16;
    public static final int DCS_MESSAGE_CLASS_ME = 17;
    public static final int DCS_MESSAGE_CLASS_SIM = 18;
    public static final int DCS_MESSAGE_CLASS_TE = 19;

    public static String getMultiCharFor(char c) {
        switch (c) {
            case '\n': {
                return "'\f'";
            }
            case '\u039b': {
                return "^";
            }
            case '(': {
                return "{";
            }
            case ')': {
                return "}";
            }
            case '/': {
                return "\\";
            }
            case '<': {
                return "[";
            }
            case '=': {
                return "~";
            }
            case '>': {
                return "]";
            }
            case '\u00a1': {
                return "|";
            }
            case 'e': {
                return "\u20ac";
            }
        }
        return "";
    }

    public static int getAddressTypeFor(String string) {
        boolean bl = false;
        if (string.startsWith("+")) {
            bl = true;
            string = string.substring(1);
        }
        for (int i = 0; i < string.length(); ++i) {
            if (Character.isDigit(string.charAt(i))) continue;
            return PduUtils.createAddressType(80);
        }
        if (bl) {
            return PduUtils.createAddressType(17);
        }
        return PduUtils.createAddressType(1);
    }

    public static int extractAddressType(int n) {
        return n & 0x70;
    }

    public static int extractNumberPlan(int n) {
        return n & 0xF;
    }

    public static int createAddressType(int n) {
        return 0x80 | n;
    }

    public static int extractDcsEncoding(int n) {
        return n & 0xFFFFFF0C;
    }

    public static int extractDcsClass(int n) {
        return n & 0xFFFFFF13;
    }

    public static int extractDcsFlash(int n) {
        return n & 0xFFFFFF13;
    }

    public static int extractDcsCodingGroup(int n) {
        return n & 0xFFFFFFF0;
    }

    private static Integer _$2(Pdu pdu, String string) {
        try {
            Method method = pdu.getClass().getMethod("get" + string, new Class[0]);
            return (Integer)method.invoke((Object)pdu, new Object[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static Boolean _$1(Pdu pdu, String string) {
        try {
            Method method = pdu.getClass().getMethod("has" + string, new Class[0]);
            return (Boolean)method.invoke((Object)pdu, new Object[0]);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static String decodeFirstOctet(Pdu pdu) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("First Octet: " + PduUtils.byteToPdu(pdu.getFirstOctet()));
        stringBuffer.append(" [");
        switch (pdu.getTpMti()) {
            case 0: {
                stringBuffer.append("TP-MTI: (SMS-DELIVER)");
                break;
            }
            case 2: {
                stringBuffer.append("TP-MTI: (SMS-STATUS REPORT)");
                break;
            }
            case 1: {
                stringBuffer.append("TP-MTI: (SMS-SUBMIT)");
                break;
            }
            default: {
                throw new RuntimeException("Invalid message type");
            }
        }
        if (PduUtils._$1(pdu, "TpMms") != null) {
            if (PduUtils._$1(pdu, "TpMms").booleanValue()) {
                stringBuffer.append(", TP-MMS: (Has more messages)");
            } else {
                stringBuffer.append(", TP-MMS: (has no messages)");
            }
        }
        if (PduUtils._$1(pdu, "TpRd") != null) {
            if (PduUtils._$1(pdu, "TpRd").booleanValue()) {
                stringBuffer.append(", TP-RD: (Reject duplicates)");
            } else {
                stringBuffer.append(", TP-RD: (allow duplicates)");
            }
        }
        if (PduUtils._$1(pdu, "TpVpf") != null && PduUtils._$1(pdu, "TpVpf").booleanValue()) {
            switch (PduUtils._$2(pdu, "TpVpf")) {
                case 16: {
                    stringBuffer.append(", TP-VPF: (validity format, integer");
                    break;
                }
                case 24: {
                    stringBuffer.append(", TP-VPF: (validity format, timestamp");
                    break;
                }
                case 0: {
                    stringBuffer.append(", TP-VPF: (validity format, none)");
                }
            }
        }
        if (PduUtils._$1(pdu, "TpSri") != null) {
            if (PduUtils._$1(pdu, "TpSri").booleanValue()) {
                stringBuffer.append(", TP-SRI: (Requests Status Report)");
            } else {
                stringBuffer.append(", TP-SRI: (No Status Report)");
            }
        }
        if (PduUtils._$1(pdu, "TpSrr") != null) {
            if (PduUtils._$1(pdu, "TpSrr").booleanValue()) {
                stringBuffer.append(", TP-SRR: (Requests Status Report)");
            } else {
                stringBuffer.append(", TP-SRR: (No Status Report)");
            }
        }
        if (pdu.hasTpUdhi()) {
            stringBuffer.append(", TP-UDHI: (has UDH)");
        } else {
            stringBuffer.append(", TP-UDHI: (no UDH)");
        }
        stringBuffer.append("]");
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    public static String decodeDataCodingScheme(Pdu pdu) {
        StringBuffer stringBuffer = new StringBuffer();
        switch (PduUtils.extractDcsEncoding(pdu.getDataCodingScheme())) {
            case 0: {
                stringBuffer.append("7-bit GSM Alphabet");
                break;
            }
            case 4: {
                stringBuffer.append("8-bit encoding");
                break;
            }
            case 8: {
                stringBuffer.append("UCS2 encoding");
            }
        }
        if ((pdu.getDataCodingScheme() & 0xFFFFFF3F) == 0) {
            switch (PduUtils.extractDcsClass(pdu.getDataCodingScheme())) {
                case 16: {
                    stringBuffer.append(", (Flash Message)");
                    break;
                }
                case 17: {
                    stringBuffer.append(", (Class1 ME Message)");
                    break;
                }
                case 18: {
                    stringBuffer.append(", (Class2 SIM Message)");
                    break;
                }
                case 19: {
                    stringBuffer.append(", (Class3 TE Message)");
                }
            }
        }
        return stringBuffer.toString();
    }

    public static byte[] encode8bitUserData(String string) {
        try {
            return string.getBytes("ISO8859_1");
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static byte[] hexStr2ByteArr(String string) {
        try {
            byte[] byArray = string.getBytes();
            int n = byArray.length;
            byte[] byArray2 = new byte[n / 2];
            for (int i = 0; i < n; i += 2) {
                String string2 = new String(byArray, i, 2);
                byArray2[i / 2] = (byte)Integer.parseInt(string2, 16);
            }
            return byArray2;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static byte[] convertByteArr(byte[] byArray) {
        try {
            boolean bl = false;
            int n = byArray.length;
            if (n % 2 != 0) {
                ++n;
                bl = true;
            }
            byte[] byArray2 = new byte[n / 2];
            for (int i = 0; i < n; i += 2) {
                String string = null;
                string = bl && i == n - 2 ? new String(byArray, i, 1) : new String(byArray, i, 2);
                byArray2[i / 2] = (byte)Integer.parseInt(string, 16);
            }
            return byArray2;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static String byteArr2HexStr(byte[] byArray, byte[] byArray2) {
        try {
            int n = byArray == null ? 0 : byArray.length;
            byte[] byArray3 = null;
            if (n != 0) {
                byArray3 = new byte[byArray2.length - n];
                System.arraycopy(byArray2, n, byArray3, 0, byArray3.length);
                byArray2 = byArray3;
            }
            int n2 = byArray2.length;
            StringBuffer stringBuffer = new StringBuffer(n2 * 2);
            for (int i = 0; i < n2; ++i) {
                int n3;
                for (n3 = byArray2[i]; n3 < 0; n3 += 256) {
                }
                if (n3 < 16) {
                    stringBuffer.append("0");
                }
                stringBuffer.append(Integer.toString(n3, 16));
            }
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static byte[] encodeUcs2UserData(String string) {
        try {
            return string.getBytes("UTF-16BE");
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static byte[] encode7bitUserData(byte[] byArray, byte[] byArray2) {
        if (byArray == null) {
            return PduUtils.unencodedSeptetsToEncodedSeptets(byArray2);
        }
        byte[] byArray3 = PduUtils.encodedSeptetsToUnencodedSeptets(byArray, false);
        byte[] byArray4 = new byte[byArray3.length + byArray2.length];
        System.arraycopy(byArray3, 0, byArray4, 0, byArray3.length);
        System.arraycopy(byArray2, 0, byArray4, byArray3.length, byArray2.length);
        return PduUtils.unencodedSeptetsToEncodedSeptets(byArray4);
    }

    public static String decode7bitEncoding(byte[] byArray) {
        return PduUtils.decode7bitEncoding(null, byArray);
    }

    public static String decode7bitEncoding(byte[] byArray, byte[] byArray2) {
        int n;
        int n2 = n = byArray == null ? 0 : byArray.length;
        if (n == 0) {
            return PduUtils.unencodedSeptetsToString(PduUtils.encodedSeptetsToUnencodedSeptets(byArray2));
        }
        String string = PduUtils.unencodedSeptetsToString(PduUtils.encodedSeptetsToUnencodedSeptets(byArray, false));
        String string2 = PduUtils.unencodedSeptetsToString(PduUtils.encodedSeptetsToUnencodedSeptets(byArray2));
        return string2.substring(string.length());
    }

    public static String decode8bitEncoding(byte[] byArray, byte[] byArray2) {
        try {
            int n = byArray == null ? 0 : byArray.length;
            return new String(byArray2, n, byArray2.length - n, "ISO8859_1");
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static String decodeUcs2Encoding(byte[] byArray, byte[] byArray2) {
        try {
            int n = byArray == null ? 0 : byArray.length;
            return new String(byArray2, n, byArray2.length - n, "UTF-16");
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static byte swapNibbles(int n) {
        return (byte)(n << 4 & 0xF0 | n >>> 4 & 0xF);
    }

    public static String readBCDNumbers(int n, byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < byArray.length; ++i) {
            byte by = byArray[i];
            int n2 = by & 0xF;
            stringBuffer.append(n2);
            int n3 = by >>> 4 & 0xF;
            if (n3 == 15) continue;
            stringBuffer.append(n3);
        }
        return stringBuffer.toString();
    }

    public static int createSwappedBCD(int n) {
        int n2 = (n & 0xFF) / 10;
        int n3 = (n & 0xFF) - n2 * 10;
        return n3 << 4 | n2;
    }

    public static String stringToPdu(String string) {
        byte[] byArray = PduUtils.stringToUnencodedSeptets(string);
        return PduUtils.bytesToPdu(PduUtils.unencodedSeptetsToEncodedSeptets(byArray));
    }

    public static byte[] stringToUnencodedSeptets(String string) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n = 0;
        block0: for (int i = 0; i < string.length(); ++i) {
            int n2;
            char c = string.charAt(i);
            int n3 = -1;
            for (n2 = 0; n2 < _$3.length; ++n2) {
                if (_$3[n2] != c) continue;
                n3 = n2;
                break;
            }
            if (n3 != -1) {
                byteArrayOutputStream.write((byte)Integer.parseInt(_$2[n3].substring(0, 2), 16));
                ++n;
                byteArrayOutputStream.write((byte)Integer.parseInt(_$2[n3].substring(2, 4), 16));
                ++n;
                continue;
            }
            n3 = -1;
            for (n2 = 0; n2 < _$1.length; ++n2) {
                if (_$1[n2] != c) continue;
                n3 = n2;
                byteArrayOutputStream.write((byte)n2);
                ++n;
                break;
            }
            if (n3 != -1) continue;
            for (n2 = 0; n2 < _$4.length; ++n2) {
                if (_$4[n2][0] != c) continue;
                n3 = n2;
                c = _$4[n2][1];
                break;
            }
            if (n3 != -1) {
                for (n2 = 0; n2 < _$1.length; ++n2) {
                    if (_$1[n2] != c) continue;
                    n3 = n2;
                    byteArrayOutputStream.write((byte)n2);
                    ++n;
                    continue block0;
                }
                continue;
            }
            byteArrayOutputStream.write(32);
            ++n;
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] unencodedSeptetsToEncodedSeptets(byte[] byArray) {
        int n;
        int n2;
        byte[] byArray2 = byArray;
        int n3 = byArray2.length;
        BitSet bitSet = new BitSet();
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = 0; n < 7; ++n) {
                if ((byArray2[n2] & 1 << n) == 0) continue;
                bitSet.set(n2 * 7 + n);
            }
        }
        int n4 = n3 * 7 / 8 + (n3 * 7 % 8 != 0 ? 1 : 0);
        byte[] byArray3 = new byte[n4];
        for (n2 = 0; n2 < n4; ++n2) {
            for (n = 0; n < 8; ++n) {
                int n5 = n2;
                byArray3[n5] = (byte)(byArray3[n5] | (byte)((bitSet.get(n2 * 8 + n) ? 1 : 0) << n));
            }
        }
        return byArray3;
    }

    public static int getNumMultiCharsInSeptets(byte[] byArray) {
        int n = 0;
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] != 27) continue;
            ++n;
        }
        return n;
    }

    public static String unencodedSeptetsToString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == 27) {
                if (i >= byArray.length - 1) continue;
                String string = "1b" + Integer.toHexString(byArray[++i]);
                for (int j = 0; j < _$2.length; ++j) {
                    if (!_$2[j].equalsIgnoreCase(string)) continue;
                    stringBuffer.append(_$3[j]);
                }
                continue;
            }
            stringBuffer.append(_$1[byArray[i]]);
        }
        return stringBuffer.toString();
    }

    public static String encodedSeptetsToString(byte[] byArray) {
        return PduUtils.unencodedSeptetsToString(PduUtils.encodedSeptetsToUnencodedSeptets(byArray));
    }

    public static int getNumSeptetsForOctets(int n) {
        return n * 8 / 7 + (n * 8 % 7 != 0 ? 1 : 0);
    }

    public static byte[] encodedSeptetsToUnencodedSeptets(byte[] byArray) {
        return PduUtils.encodedSeptetsToUnencodedSeptets(byArray, true);
    }

    public static byte[] encodedSeptetsToUnencodedSeptets(byte[] byArray, boolean bl) {
        int n;
        int n2;
        int n3;
        BitSet bitSet = new BitSet(byArray.length * 8);
        int n4 = 0;
        for (n3 = 0; n3 < byArray.length; ++n3) {
            for (n2 = 0; n2 < 8; ++n2) {
                n4 = n3 * 8 + n2;
                if ((byArray[n3] & 1 << n2) == 0) continue;
                bitSet.set(n4);
            }
        }
        if ((n = ++n4 / 7 + (n4 % 7 != 0 ? 1 : 0)) == 0) {
            ++n;
        }
        byte[] byArray2 = new byte[n];
        for (n3 = 0; n3 < n; ++n3) {
            for (n2 = 0; n2 < 7; ++n2) {
                if (n4 + 1 <= n3 * 7 + n2 || !bitSet.get(n3 * 7 + n2)) continue;
                int n5 = n3;
                byArray2[n5] = (byte)(byArray2[n5] | (byte)(1 << n2));
            }
        }
        if (bl && byArray2[byArray2.length - 1] == 0) {
            byte[] byArray3 = new byte[byArray2.length - 1];
            System.arraycopy(byArray2, 0, byArray3, 0, byArray3.length);
            return byArray3;
        }
        return byArray2;
    }

    public static byte[] pduToBytes(String string) {
        byte[] byArray = new byte[string.length() / 2];
        for (int i = 0; i < string.length(); i += 2) {
            byArray[i / 2] = (byte)Integer.parseInt(string.substring(i, i + 2), 16);
        }
        return byArray;
    }

    public static String pduToBits(String string) {
        return PduUtils.bytesToBits(PduUtils.pduToBytes(string));
    }

    public static String bytesToPdu(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < byArray.length; ++i) {
            stringBuffer.append(PduUtils.byteToPdu(byArray[i] & 0xFF));
        }
        return stringBuffer.toString();
    }

    public static String bytesToBits(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < byArray.length; ++i) {
            String string = Integer.toBinaryString(byArray[i] & 0xFF);
            while (string.length() < 8) {
                string = "0" + string;
            }
            if (i > 0) {
                stringBuffer.append(" ");
            }
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public static String byteToBits(byte by) {
        String string = Integer.toBinaryString(by & 0xFF);
        while (string.length() < 8) {
            string = "0" + string;
        }
        return string;
    }

    public static String byteToPdu(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = Integer.toHexString(n & 0xFF);
        if (string.length() == 1) {
            stringBuffer.append("0");
        }
        stringBuffer.append(string);
        return stringBuffer.toString().toUpperCase();
    }
}

