/*
 * Decompiled with CFR 0.152.
 */
package cn.sendsms.modem;

import cn.sendsms.GatewayException;
import cn.sendsms.TimeoutException;
import cn.sendsms.helper.AGatewayHelper;
import cn.sendsms.helper.Logger;
import cn.sendsms.jdsmsserver.web.DeviceInfoCache;
import cn.sendsms.jdsmsserver.web.SerialModemBean;
import cn.sendsms.modem.ModemGateway;
import java.io.IOException;

public class SerialModemGateway
extends ModemGateway {
    public SerialModemGateway(String string, String string2, int n, String string3, String string4) {
        super(ModemGateway.ModemTypes.SERIAL, string, string2, n, string3, string4);
    }

    public void setStatus(AGatewayHelper.GatewayStatuses gatewayStatuses) {
        super.setStatus(gatewayStatuses);
        SerialModemBean serialModemBean = DeviceInfoCache.getInstance().get(this.getModemDevice());
        if (serialModemBean != null) {
            serialModemBean.setStatus(this.getStatus());
        } else {
            Logger.getInstance().logError("\u8bbe\u5907\u72b6\u6001\u66f4\u65b0\u5931\u8d25\u3002 ", null, null);
        }
    }

    public SerialModemGateway(SerialModemBean serialModemBean) {
        super(ModemGateway.ModemTypes.SERIAL, serialModemBean.getGatewayID(), serialModemBean.getPort(), serialModemBean.getBaudrate(), serialModemBean.getManufacturer(), serialModemBean.getModel());
        this.setProtocol(serialModemBean.getProtocol());
        if (serialModemBean.getInbound().equalsIgnoreCase("yes")) {
            this.setInbound(true);
        } else {
            this.setInbound(false);
        }
        if (serialModemBean.getOutbound().equalsIgnoreCase("yes")) {
            this.setOutbound(true);
        } else {
            this.setOutbound(false);
        }
        this.setSimPin(serialModemBean.getPin());
        this.setCustomInitString(serialModemBean.getInit_string());
        this.setSmscNumber(serialModemBean.getSmsc_number());
    }

    public void startGateway() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.setStatus(AGatewayHelper.GatewayStatuses.STARTING);
        try {
            super.startGateway();
        }
        catch (GatewayException gatewayException) {
            gatewayException.printStackTrace();
            if (gatewayException instanceof GatewayException) {
                if (gatewayException.getMessage().indexOf("NoSuchPort") != -1) {
                    this.setStatus(AGatewayHelper.GatewayStatuses.NOPORT);
                } else if (gatewayException.getMessage().indexOf("PortInUse") != -1) {
                    this.setStatus(AGatewayHelper.GatewayStatuses.OCCUPY);
                } else {
                    this.setStatus(AGatewayHelper.GatewayStatuses.STOPPED);
                }
                return;
            }
            throw gatewayException;
        }
        this.judgeAuthorize();
    }

    public void stopGateway() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.setStatus(AGatewayHelper.GatewayStatuses.STOPPING);
        super.stopGateway();
    }
}

