/*
 * Decompiled with CFR 0.152.
 */
package cn.sendsms.modem.athandler;

import cn.sendsms.GatewayException;
import cn.sendsms.InboundMessage;
import cn.sendsms.Service;
import cn.sendsms.TimeoutException;
import cn.sendsms.helper.Logger;
import cn.sendsms.jdsmsserver.JDSMSServer;
import cn.sendsms.jdsmsserver.web.CharacterSetToolkit;
import cn.sendsms.modem.ModemGateway;
import cn.sendsms.modem.athandler.ATHandler_Wavecom;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ATHandler_Wavecom_WISMOQCDMA
extends ATHandler_Wavecom {
    private Object _$4 = new Object();

    @Override
    public void reset() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.threadWait(Service.getInstance().getSettings().AT_WAIT_AFTER_RESET);
        this.getModemDriver().clearBuffer();
    }

    @Override
    public String getSerialNo() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getModemDriver().write("ATI3\r");
        String string = this.getModemDriver().getResponse();
        if (string != null && string.indexOf("WQ2") != -1) {
            this.getModemDriver().write("AT+WAIP=0\r");
            this.getModemDriver().getResponse();
            this.getModemDriver().write("AT+CPBS=\"ME\"\r");
            this.getModemDriver().getResponse();
            this.getModemDriver().write("AT+CPBR=1\r");
            String string2 = this.getModemDriver().getResponse();
            string2 = string2.replaceAll("AT+CPBR=1\r", "").replaceAll("\\s+OK\\s+", "").replaceAll("\\s+", "");
            string2 = string2.substring(string2.indexOf(58) + 1);
            String string3 = string2.substring(string2.lastIndexOf(44) + 1);
            if (string2.indexOf("ERROR") != -1) {
                return "N/A";
            }
            if (string2.trim().equals("")) {
                return "N/A";
            }
            if (!string3.equals("\"WMSN\"")) {
                return "N/A";
            }
            String string4 = string2.split(",")[1];
            return string4.substring(1, string4.length() - 1);
        }
        this.getModemDriver().write("AT+WMSN\r");
        String string5 = this.getModemDriver().getResponse();
        string5 = string5.replaceAll("\\s+OK\\s+", "");
        String[] stringArray = string5.split(":");
        return stringArray[stringArray.length - 1];
    }

    @Override
    public String getSerialNumber() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getModemDriver().write("ATI3\r");
        String string = this.getModemDriver().getResponse();
        if (string != null && string.indexOf("WQ2") != -1) {
            this.getModemDriver().write("AT+WAIP=0\r");
            this.getModemDriver().getResponse();
            this.getModemDriver().write("AT+CPBS=\"ME\"\r");
            this.getModemDriver().getResponse();
            this.getModemDriver().write("AT+CPBR=1\r");
            String string2 = this.getModemDriver().getResponse();
            string2 = string2.replaceAll("AT+CPBR=1\r", "").replaceAll("\\s+OK\\s+", "").replaceAll("\\s+", "");
            string2 = string2.substring(string2.indexOf(58) + 1);
            String string3 = string2.substring(string2.lastIndexOf(44) + 1);
            if (string2.indexOf("ERROR") != -1) {
                return "N/A";
            }
            if (string2.trim().equals("")) {
                return "N/A";
            }
            if (!string3.equals("\"WMSN\"")) {
                return "N/A";
            }
            String string4 = string2.split(",")[1];
            return string4.substring(1, string4.length() - 1);
        }
        this.getModemDriver().write("AT+WMSN\r");
        String string5 = this.getModemDriver().getResponse();
        string5 = string5.replaceAll("\\s+OK\\s+", "");
        String[] stringArray = string5.split(":");
        return stringArray[stringArray.length - 1];
    }

    @Override
    public void done() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.threadWait(Service.getInstance().getSettings().AT_WAIT);
    }

    public ATHandler_Wavecom_WISMOQCDMA(ModemGateway modemGateway) {
        super(modemGateway);
        this.terminators[1] = "\\s*([\\p{ASCII}]|[^\\x00-\\xff])*\\s+OK\\s";
        this.terminators[9] = "\\+CCID:\\s*[\\p{ASCII}]*\\s*";
        this.setStorageLocations("MT");
    }

    @Override
    public String listMessages(InboundMessage.MessageClasses messageClasses) throws TimeoutException, GatewayException, IOException, InterruptedException {
        StringBuffer stringBuffer = new StringBuffer();
        String string = "";
        try {
            if (messageClasses == InboundMessage.MessageClasses.ALL) {
                this.getModemDriver().write("AT+CMGL=\"ALL\"\r");
            } else if (messageClasses == InboundMessage.MessageClasses.UNREAD) {
                this.getModemDriver().write("AT+CMGL=\"REC UNREAD\"\r");
            } else if (messageClasses == InboundMessage.MessageClasses.READ) {
                this.getModemDriver().write("AT+CMGL=\"REC READ\"\r");
            }
            string = this.getModemDriver().getResponse4CDMA();
        }
        catch (TimeoutException timeoutException) {
            Logger.getInstance().logError("\u63a5\u6536\u77ed\u4fe1\u53d1\u9001at+cmgl=all\u6307\u4ee4\u51fa\u73b0\u8d85\u65f6", timeoutException, this.getGateway().getGatewayId());
            this.threadWait(60000L);
        }
        ArrayList<Integer> arrayList = this._$1(string);
        for (int i = 0; i < arrayList.size(); ++i) {
            int n = arrayList.get(i);
            String string2 = "";
            String string3 = "";
            this.getModemDriver().write("AT+CMGR=" + n + "\r");
            byte[] byArray = new byte[]{};
            try {
                byArray = this.getModemDriver().getResponseByteArray4CDMA();
            }
            catch (TimeoutException timeoutException) {
                Logger.getInstance().logError("\u63a5\u6536\u77ed\u4fe1\u53d1\u9001at+cmgr\u6307\u4ee4\u65f6\u51fa\u73b0\u8d85\u65f6", timeoutException, this.getGateway().getGatewayId());
                continue;
            }
            int n2 = 0;
            for (n2 = 0; n2 < byArray.length && byArray[n2] != 13; ++n2) {
                string2 = string2 + (char)byArray[n2];
            }
            ++n2;
            String string4 = "(^\\+CMGR:)(\\\"[^\\\"]+\\\",)(\\\"[^\\\"]+\\\",)(\\\"[^,]+,)(\\d+)\\s+(:\\d+)\\s+(:\\d+\\\")(,\\d,)(\\d)";
            Pattern pattern = Pattern.compile(string4);
            Matcher matcher = pattern.matcher(string2);
            string2 = matcher.replaceAll("$1 " + n + ",$2$3,$4$5$6$7$8$9");
            char c = matcher.replaceAll("$9").charAt(0);
            String string5 = "";
            if (c == '4') {
                byte[] byArray2;
                try {
                    byArray2 = new byte[byArray.length - n2 - 4];
                }
                catch (NegativeArraySizeException negativeArraySizeException) {
                    continue;
                }
                for (int j = 0; j < byArray2.length; ++j) {
                    byArray2[j] = byArray[n2 + j];
                }
                string5 = CharacterSetToolkit.unicode2Ascii(byArray2);
            } else {
                while (n2 < byArray.length) {
                    string5 = string5 + (char)byArray[n2++];
                }
            }
            string3 = string2 + "\r" + string5 + "\r";
            stringBuffer.append(string3);
        }
        return stringBuffer.toString();
    }

    private ArrayList<Integer> _$1(String string) throws IOException {
        String string2;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        String string3 = string;
        BufferedReader bufferedReader = new BufferedReader(new StringReader(string3));
        while ((string2 = bufferedReader.readLine().trim()) != null && (string2 = string2.trim()).length() <= 0) {
        }
        while (string2 != null && (string2 = string2.trim()).length() > 0 && !string2.equalsIgnoreCase("OK")) {
            if (string2.matches("^\\+CMGL:\\s*\\d+,.*")) {
                int n = string2.indexOf(58);
                int n2 = string2.indexOf(44);
                int n3 = Integer.parseInt(string2.substring(n + 1, n2).trim());
                arrayList.add(n3);
            }
            if ((string2 = bufferedReader.readLine()) == null) break;
            string2 = string2.trim();
            while (string2.length() == 0 && (string2 = bufferedReader.readLine()) != null) {
                string2 = string2.trim();
            }
        }
        bufferedReader.close();
        return arrayList;
    }

    @Override
    public boolean setTextProtocol() throws TimeoutException, GatewayException, IOException, InterruptedException {
        this.getModemDriver().write("ATI3\r");
        String string = this.getModemDriver().getResponse();
        if (string != null && string.indexOf("WQ2") != -1) {
            this.getModemDriver().write("AT+CMGF=1\r");
            this.getModemDriver().getResponse();
            if (this.getModemDriver().isOk()) {
                this.getModemDriver().write("AT+CSCS=\"CDMA\"\r");
                this.getModemDriver().getResponse();
                if (this.getModemDriver().isOk()) {
                    this.getModemDriver().write("AT+WSCL=6,4\r");
                    this.echoOff();
                    return true;
                }
                return false;
            }
        }
        this.getModemDriver().write("AT+CSCS=\"CDMA\"\r");
        this.getModemDriver().getResponse();
        if (this.getModemDriver().isOk()) {
            this.getModemDriver().write("AT+WSCL=6,4\r");
            this.echoOff();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int sendMessage(int n, String string, String string2, String string3) throws GatewayException, IOException, InterruptedException {
        String string4 = "";
        int n2 = -1;
        boolean bl = true;
        if (JDSMSServer.getInstance().getProperties().getString("settings.delete_after_processing", "no").equalsIgnoreCase("no")) {
            this.getModemDriver().write("AT+CMGD=1,4\r");
            try {
                this.getModemDriver().getResponse();
            }
            catch (Exception exception) {
                Logger.getInstance().logError("\u5220\u9664\u77ed\u4fe1\u51fa\u73b0\u5f02\u5e38", null, this.getGateway().getGatewayId());
            }
        }
        Logger.getInstance().logDebug("wait...", null, this.getGateway().getGatewayId());
        byte[] byArray = ATHandler_Wavecom_WISMOQCDMA.ascii2UnicodeBytes(string3, false);
        for (int i = 0; i <= (byArray.length - 1) / 130; ++i) {
            int n3 = byArray.length < 130 * (i + 1) ? byArray.length - 130 * i : 130;
            byte[] byArray2 = new byte[n3];
            try {
                System.arraycopy(byArray, i * 130, byArray2, 0, n3);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            Logger.getInstance().logInfo(string3 + " : \u7684unicode bytes are: " + new String(byArray), null, this.getGateway().getGatewayId());
            Object object = this._$4;
            synchronized (object) {
                int n4;
                this.getModemDriver().clearBuffer();
                if (byArray.length <= 140) {
                    this.getModemDriver().write("AT+CMGS=\"_1_\",_2_\r".replaceAll("_1_", string2).replaceAll("_2_", byArray.length + ""));
                    Logger.getInstance().logInfo("\u5f00\u59cb\u53d1\u77ed\u4fe1:" + "AT+CMGS=\"_1_\",_2_\r".replaceAll("_1_", string2).replaceAll("_2_", byArray.length + ""), null, this.getGateway().getGatewayId());
                    this.getModemDriver().write(byArray);
                    bl = false;
                } else {
                    n4 = (byArray.length - 1) / 130 + 1;
                    String string5 = "(" + (i + 1) + "/" + n4 + ")";
                    byte[] byArray3 = ATHandler_Wavecom_WISMOQCDMA.ascii2UnicodeBytes(string5, false);
                    byte[] byArray4 = new byte[byArray3.length + byArray2.length];
                    System.arraycopy(byArray3, 0, byArray4, 0, byArray3.length);
                    System.arraycopy(byArray2, 0, byArray4, byArray3.length, byArray2.length);
                    this.getModemDriver().write("AT+CMGS=\"_1_\",_2_\r".replaceAll("_1_", string2).replaceAll("_2_", byArray4.length + ""));
                    Logger.getInstance().logInfo("\u5f00\u59cb\u53d1\u77ed\u4fe1:" + "AT+CMGS=\"_1_\",_2_\r".replaceAll("_1_", string2).replaceAll("_2_", byArray4.length + ""), null, this.getGateway().getGatewayId());
                    this.getModemDriver().write(byArray4);
                }
                Logger.getInstance().logInfo("\u77ed\u4fe1\u5185\u5bb9: " + string3, null, this.getGateway().getGatewayId());
                this.getModemDriver().write('\u0000');
                this.getModemDriver().write('\u001a');
                this.getModemDriver().write('\r');
                n4 = 1;
                boolean bl2 = false;
                long l = System.currentTimeMillis();
                boolean bl3 = false;
                while (n4 != 0) {
                    if ((System.currentTimeMillis() - l) / 1000L >= 120L) {
                        n2 = -1;
                        break;
                    }
                    Logger.getInstance().logInfo("response \u5f00\u59cb\u54cd\u5e94...", null, this.getGateway().getGatewayId());
                    try {
                        string4 = bl2 ? this.getModemDriver().getResponseString() : this.getModemDriver().getResponse();
                    }
                    catch (TimeoutException timeoutException) {
                        timeoutException.printStackTrace();
                        Logger.getInstance().logInfo("\u63a5\u6536\u77ed\u4fe1\u54cd\u5e94\u65f6\u51fa\u73b0\u8d85\u65f6\u5f02\u5e38", timeoutException, this.getGateway().getGatewayId());
                    }
                    if (string4.indexOf("CMGR:") == -1 && string4.indexOf("CMGL:") == -1 && string4.indexOf("CDS:") == -1) {
                        bl2 = true;
                        continue;
                    }
                    String string6 = string4.substring(string4.lastIndexOf(","), string4.length());
                    if (string6.indexOf("32768") != -1 || string6.indexOf("8") != -1) {
                        StringBuilder stringBuilder = new StringBuilder();
                        int n5 = string4.indexOf(",");
                        while (!Character.isDigit(string4.charAt(n5))) {
                            ++n5;
                        }
                        while (Character.isDigit(string4.charAt(n5))) {
                            stringBuilder.append(string4.charAt(n5));
                            ++n5;
                        }
                        n2 = Integer.parseInt(stringBuilder.toString());
                    } else {
                        n2 = -1;
                    }
                    Logger.getInstance().logInfo("\u8fd4\u56de\u54cd\u5e94: " + string4, null, this.getGateway().getGatewayId());
                    break;
                }
            }
            if (!bl) break;
        }
        return n2;
    }

    public static byte[] ascii2UnicodeBytes(String string, boolean bl) {
        int n = string.length();
        int n2 = n * 2;
        if (n2 < 0) {
            n2 = Integer.MAX_VALUE;
        }
        byte[] byArray = new byte[n2];
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            byArray[2 * i] = (byte)(c >> 8);
            byArray[2 * i + 1] = (byte)(c << 8 >> 8);
        }
        return byArray;
    }
}

