/*
 * Decompiled with CFR 0.152.
 */
package cn.sendsms;

import cn.sendsms.AGateway;
import cn.sendsms.GatewayException;
import cn.sendsms.Group;
import cn.sendsms.ICallNotification;
import cn.sendsms.IGatewayStatusNotification;
import cn.sendsms.IInboundMessageNotification;
import cn.sendsms.IOrphanedMessageNotification;
import cn.sendsms.IOutboundMessageNotification;
import cn.sendsms.IQueueSendingNotification;
import cn.sendsms.IUSSDNotification;
import cn.sendsms.IlIlIlIllIlllIIl;
import cn.sendsms.InboundMessage;
import cn.sendsms.Library;
import cn.sendsms.OutboundMessage;
import cn.sendsms.Phonebook;
import cn.sendsms.SendSMSException;
import cn.sendsms.Settings;
import cn.sendsms.TimeoutException;
import cn.sendsms.USSDRequest;
import cn.sendsms.balancing.LoadBalancer;
import cn.sendsms.balancing.RoundRobinLoadBalancer;
import cn.sendsms.crypto.KeyManager;
import cn.sendsms.helper.AGatewayHelper;
import cn.sendsms.helper.Logger;
import cn.sendsms.llIIllIllIlIlIll;
import cn.sendsms.notify.NotifyQueueManager;
import cn.sendsms.queues.AbstractQueueManager;
import cn.sendsms.queues.DefaultQueueManager;
import cn.sendsms.routing.Router;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Service {
    private List<AGateway> gatewayList;
    private Router router;
    private LoadBalancer loadBalancer;
    private IlIlIlIllIlllIIl watchDog;
    private IInboundMessageNotification inboundMessageNotification;
    private IOutboundMessageNotification outboundMessageNotification;
    private ICallNotification callNotification;
    private IGatewayStatusNotification gatewayStatusNotification;
    private IQueueSendingNotification queueSendingNotification;
    private IOrphanedMessageNotification orphanedMessageNotification;
    protected AbstractQueueManager queueManager;
    protected NotifyQueueManager notifyQueueManager;
    private long startMillis;
    private Collection<Group> groups;
    private volatile ServiceStatus serviceStatus;
    private KeyManager keyManager;
    public Settings S;
    private IUSSDNotification ussdNotification;
    private static final Service service = new Service();
    public static final int maxnumofgateway = 64;

    private Service() {
        this.setSettings(new Settings());
        this.initializeService();
    }

    protected void initializeService() {
        this.startMillis = System.currentTimeMillis();
        this.setServiceStatus(ServiceStatus.STOPPED);
        this.groups = new ArrayList<Group>();
        this.listSystemInformation();
        this.gatewayList = new ArrayList<AGateway>();
        this.keyManager = KeyManager.getInstance();
        this.setRouter(new Router());
        this.setLoadBalancer(new RoundRobinLoadBalancer());
        this.setNotifyQueueManager(new NotifyQueueManager());
    }

    private void listSystemInformation() {
        Logger.getInstance().logInfo(Library.getLibraryDescription(), null, null);
        Logger.getInstance().logInfo("Version: " + Library.getLibraryVersion(), null, null);
        Logger.getInstance().logInfo("JRE Version: " + System.getProperty("java.version"), null, null);
        Logger.getInstance().logInfo("JRE Impl Version: " + System.getProperty("java.vm.version"), null, null);
        Logger.getInstance().logInfo("O/S: " + System.getProperty("os.name") + " / " + System.getProperty("os.arch") + " / " + System.getProperty("os.version"), null, null);
    }

    public Logger getLogger() {
        return Logger.getInstance();
    }

    public static Service getInstance() {
        return service;
    }

    public void addGateway(AGateway aGateway) throws GatewayException {
        if (this.getServiceStatus() != ServiceStatus.STOPPED) {
            throw new GatewayException("Cannot add gateways while Service is running!");
        }
        this.getGateways().add(aGateway);
    }

    public boolean removeGateway(AGateway aGateway) throws GatewayException {
        if (this.getServiceStatus() != ServiceStatus.STOPPED) {
            throw new GatewayException("Cannot remove gateways while Service is running!");
        }
        return this.getGateways().remove(aGateway);
    }

    public AGateway getGateway(String string) {
        Iterator<AGateway> iterator = this.getGateways().iterator();
        while (iterator.hasNext()) {
            AGateway aGateway = iterator.next();
            if (!aGateway.getGatewayId().equalsIgnoreCase(string)) continue;
            iterator = null;
            return aGateway;
        }
        iterator = null;
        return null;
    }

    public synchronized void startService() throws SendSMSException, TimeoutException, GatewayException, IOException, InterruptedException {
        this.startService(true);
    }

    public synchronized void startService(boolean bl) throws SendSMSException, TimeoutException, GatewayException, IOException, InterruptedException {
        this.queueManager = new DefaultQueueManager();
        try {
            this.getQueueManager().start();
            this.setServiceStatus(ServiceStatus.STARTING);
            this.setWatchDog(new IlIlIlIllIlllIIl(this, "WatchDog", this.getSettings().WATCHDOG_INTERVAL * 1000));
            this.startService_Internal(bl);
            this.setServiceStatus(ServiceStatus.STARTED);
        }
        catch (SendSMSException sendSMSException) {
            this.stopService();
            throw sendSMSException;
        }
        catch (IOException iOException) {
            this.stopService();
            throw iOException;
        }
        catch (InterruptedException interruptedException) {
            this.stopService();
            throw interruptedException;
        }
    }

    private void startService_Internal(boolean bl) throws SendSMSException, TimeoutException, GatewayException, IOException, InterruptedException {
        if (this.getSettings().CONCURRENT_GATEWAY_START) {
            LinkedList linkedList = new LinkedList();
            LinkedList linkedList2 = new LinkedList();
            for (AGateway aGateway : this.getGateways()) {
                new llIIllIllIlIlIll(this, aGateway, linkedList, linkedList2).start();
            }
            Iterator<AGateway> iterator = null;
        } else {
            for (AGateway aGateway : this.getGateways()) {
                try {
                    aGateway.startGateway();
                }
                catch (Exception exception) {
                    if (exception instanceof GatewayException) {
                        aGateway.setStatus(AGatewayHelper.GatewayStatuses.FAILURE);
                    } else {
                        aGateway.setStatus(AGatewayHelper.GatewayStatuses.STOPPED);
                    }
                    Logger.getInstance().logInfo(" start device failed", exception, aGateway.getGatewayId());
                }
            }
            Iterator<AGateway> iterator = null;
        }
    }

    public synchronized void stopService() throws SendSMSException, TimeoutException, GatewayException, IOException, InterruptedException {
        this.setServiceStatus(ServiceStatus.STOPPING);
        if (this.getQueueManager() != null) {
            this.getQueueManager().stop();
        }
        if (this.getWatchDog() != null) {
            this.getWatchDog().cancel();
            this.setWatchDog(null);
        }
        for (AGateway aGateway : this.getGateways()) {
            aGateway.stopGateway();
        }
        Iterator<AGateway> iterator = null;
        this.getNotifyQueueManager().cancel();
        this.setServiceStatus(ServiceStatus.STOPPED);
    }

    public int readMessages(Collection<InboundMessage> collection, InboundMessage.MessageClasses messageClasses) throws TimeoutException, GatewayException, IOException, InterruptedException {
        if (this.getServiceStatus() != ServiceStatus.STARTED) {
            return 0;
        }
        for (AGateway aGateway : this.getGateways()) {
            if (!aGateway.isInbound()) continue;
            try {
                this.readMessages(collection, messageClasses, aGateway);
            }
            catch (TimeoutException timeoutException) {
                Logger.getInstance().logWarn("readMessages(): Gateway " + aGateway.getGatewayId() + " does not respond, marking for restart.", null, null);
                aGateway.setStatus(AGatewayHelper.GatewayStatuses.RESTART);
            }
            catch (IOException iOException) {
                Logger.getInstance().logWarn("readMessages(): Gateway " + aGateway.getGatewayId() + " throws IO errors, marking for restart.", null, null);
                aGateway.setStatus(AGatewayHelper.GatewayStatuses.RESTART);
            }
        }
        Iterator<AGateway> iterator = null;
        return collection.size();
    }

    public InboundMessage[] readMessages(InboundMessage.MessageClasses messageClasses) throws TimeoutException, GatewayException, IOException, InterruptedException {
        ArrayList<InboundMessage> arrayList = new ArrayList<InboundMessage>();
        this.readMessages(arrayList, messageClasses);
        return arrayList.toArray(new InboundMessage[0]);
    }

    public int readMessages(Collection<InboundMessage> collection, InboundMessage.MessageClasses messageClasses, String string) throws TimeoutException, GatewayException, IOException, InterruptedException {
        if (this.getServiceStatus() != ServiceStatus.STARTED) {
            return 0;
        }
        AGateway aGateway = this.findGateway(string);
        if (aGateway != null && aGateway.isInbound()) {
            try {
                this.readMessages(collection, messageClasses, aGateway);
            }
            catch (TimeoutException timeoutException) {
                Logger.getInstance().logWarn("readMessages(): Gateway " + aGateway.getGatewayId() + " does not respond, marking for restart.", null, null);
                aGateway.setStatus(AGatewayHelper.GatewayStatuses.RESTART);
            }
            catch (IOException iOException) {
                Logger.getInstance().logWarn("readMessages(): Gateway " + aGateway.getGatewayId() + " throws IO errors, marking for restart.", null, null);
                aGateway.setStatus(AGatewayHelper.GatewayStatuses.RESTART);
            }
        }
        return collection.size();
    }

    public InboundMessage[] readMessages(InboundMessage.MessageClasses messageClasses, String string) throws TimeoutException, GatewayException, IOException, InterruptedException {
        ArrayList<InboundMessage> arrayList = new ArrayList<InboundMessage>();
        this.readMessages(arrayList, messageClasses, string);
        return arrayList.toArray(new InboundMessage[0]);
    }

    public int readMessages(Collection<InboundMessage> collection, InboundMessage.MessageClasses messageClasses, AGateway aGateway) throws TimeoutException, GatewayException, IOException, InterruptedException {
        if (this.getServiceStatus() != ServiceStatus.STARTED) {
            return 0;
        }
        try {
            aGateway.readMessages(collection, messageClasses);
        }
        catch (TimeoutException timeoutException) {
            Logger.getInstance().logWarn("readMessages(): Gateway " + aGateway.getGatewayId() + " does not respond, marking for restart.", null, null);
            aGateway.setStatus(AGatewayHelper.GatewayStatuses.RESTART);
        }
        catch (IOException iOException) {
            Logger.getInstance().logWarn("readMessages(): Gateway " + aGateway.getGatewayId() + " throws IO errors, marking for restart.", null, null);
            aGateway.setStatus(AGatewayHelper.GatewayStatuses.RESTART);
        }
        return collection.size();
    }

    public InboundMessage[] readMessages(InboundMessage.MessageClasses messageClasses, AGateway aGateway) throws TimeoutException, GatewayException, IOException, InterruptedException {
        ArrayList<InboundMessage> arrayList = new ArrayList<InboundMessage>();
        this.readMessages(arrayList, messageClasses, aGateway);
        return arrayList.toArray(new InboundMessage[0]);
    }

    public InboundMessage readMessage(String string, String string2, int n) throws TimeoutException, GatewayException, IOException, InterruptedException {
        if (this.getServiceStatus() != ServiceStatus.STARTED) {
            return null;
        }
        InboundMessage inboundMessage = null;
        AGateway aGateway = this.findGateway(string);
        if (aGateway != null && aGateway.isInbound()) {
            try {
                inboundMessage = aGateway.readMessage(string2, n);
            }
            catch (TimeoutException timeoutException) {
                Logger.getInstance().logWarn("readMessages(): Gateway " + aGateway.getGatewayId() + " does not respond, marking for restart.", null, null);
                aGateway.setStatus(AGatewayHelper.GatewayStatuses.RESTART);
            }
            catch (IOException iOException) {
                Logger.getInstance().logWarn("readMessages(): Gateway " + aGateway.getGatewayId() + " throws IO errors, marking for restart.", null, null);
                aGateway.setStatus(AGatewayHelper.GatewayStatuses.RESTART);
            }
        }
        return inboundMessage;
    }

    public boolean sendMessage(OutboundMessage outboundMessage) throws TimeoutException, GatewayException, IOException, InterruptedException {
        if (this.getServiceStatus() != ServiceStatus.STARTED) {
            return false;
        }
        AGateway aGateway = this.routeMessage(outboundMessage);
        if (aGateway != null) {
            Logger.getInstance().logInfo("sending message by - " + aGateway.getGatewayId(), null, null);
            try {
                ArrayList<String> arrayList = this.expandGroup(outboundMessage.getRecipient());
                if (arrayList.size() == 0) {
                    try {
                        return aGateway.sendMessage(outboundMessage);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                ArrayList<OutboundMessage> arrayList2 = new ArrayList<OutboundMessage>();
                for (int i = 0; i < arrayList.size(); ++i) {
                    String string = (String)arrayList.get(i);
                    OutboundMessage outboundMessage2 = new OutboundMessage();
                    outboundMessage.copyTo(outboundMessage2);
                    outboundMessage2.setRecipient(string);
                    arrayList2.add(outboundMessage2);
                }
                this.sendMessages(arrayList2);
                return true;
            }
            catch (TimeoutException timeoutException) {
                Logger.getInstance().logWarn("sendMessage(): " + aGateway.getGatewayId() + " does not respond, marking for restart.", null, null);
                aGateway.setStatus(AGatewayHelper.GatewayStatuses.RESTART);
                outboundMessage.setMessageStatus(OutboundMessage.MessageStatuses.FAILED);
                outboundMessage.setFailureCause(OutboundMessage.FailureCauses.GATEWAY_FAILURE);
                return false;
            }
            catch (IOException iOException) {
                Logger.getInstance().logWarn("sendMessage(): " + aGateway.getGatewayId() + " throws IO errors, marking for restart.", null, null);
                aGateway.setStatus(AGatewayHelper.GatewayStatuses.RESTART);
                outboundMessage.setMessageStatus(OutboundMessage.MessageStatuses.FAILED);
                outboundMessage.setFailureCause(OutboundMessage.FailureCauses.GATEWAY_FAILURE);
                return false;
            }
        }
        outboundMessage.setMessageStatus(OutboundMessage.MessageStatuses.FAILED);
        outboundMessage.setFailureCause(OutboundMessage.FailureCauses.NO_ROUTE);
        return false;
    }

    public boolean sendMessage(OutboundMessage outboundMessage, String string) throws TimeoutException, GatewayException, IOException, InterruptedException {
        if (this.getServiceStatus() != ServiceStatus.STARTED) {
            return false;
        }
        outboundMessage.setGatewayId(string);
        return this.sendMessage(outboundMessage);
    }

    public int sendMessages(Collection<OutboundMessage> collection) throws TimeoutException, GatewayException, IOException, InterruptedException {
        if (this.getServiceStatus() != ServiceStatus.STARTED) {
            return 0;
        }
        int n = 0;
        Iterator<OutboundMessage> iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (!this.sendMessage(iterator.next())) continue;
            ++n;
        }
        iterator = null;
        return n;
    }

    public int sendMessages(OutboundMessage[] outboundMessageArray) throws TimeoutException, GatewayException, IOException, InterruptedException {
        int n = 0;
        for (int i = 0; i < outboundMessageArray.length; ++i) {
            if (!this.sendMessage(outboundMessageArray[i])) continue;
            ++n;
        }
        return n;
    }

    public int sendMessages(Collection<OutboundMessage> collection, String string) throws TimeoutException, GatewayException, IOException, InterruptedException {
        if (this.getServiceStatus() != ServiceStatus.STARTED) {
            return 0;
        }
        int n = 0;
        for (OutboundMessage outboundMessage : collection) {
            outboundMessage.setGatewayId(string);
            if (!this.sendMessage(outboundMessage)) continue;
            ++n;
        }
        Iterator<OutboundMessage> iterator = null;
        return n;
    }

    public int sendMessages(OutboundMessage[] outboundMessageArray, String string) throws TimeoutException, GatewayException, IOException, InterruptedException {
        int n = 0;
        for (int i = 0; i < outboundMessageArray.length; ++i) {
            outboundMessageArray[i].setGatewayId(string);
            if (!this.sendMessage(outboundMessageArray[i])) continue;
            ++n;
        }
        return n;
    }

    public boolean queueMessage(OutboundMessage outboundMessage) {
        if (this.getServiceStatus() != ServiceStatus.STARTED) {
            return false;
        }
        ArrayList<String> arrayList = this.expandGroup(outboundMessage.getRecipient());
        if (arrayList.size() == 0) {
            if ("*".equals(outboundMessage.getGatewayId())) {
                AGateway aGateway = this.routeMessage(outboundMessage);
                if (aGateway == null) {
                    return false;
                }
                Logger.getInstance().logWarn("queuing message to " + aGateway.getGatewayId(), null, null);
                outboundMessage.setGatewayId(aGateway.getGatewayId());
            }
            return this.getQueueManager().queueMessage(outboundMessage);
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            String string = (String)arrayList.get(i);
            OutboundMessage outboundMessage2 = new OutboundMessage();
            outboundMessage.copyTo(outboundMessage2);
            outboundMessage2.setRecipient(string);
            if ("*".equals(outboundMessage.getGatewayId())) {
                AGateway aGateway = this.routeMessage(outboundMessage);
                if (aGateway == null) {
                    return false;
                }
                Logger.getInstance().logWarn("queuing message to Gateway " + aGateway.getGatewayId(), null, null);
                outboundMessage.setGatewayId(aGateway.getGatewayId());
            }
            this.getQueueManager().queueMessage(outboundMessage2);
        }
        return true;
    }

    public boolean queueMessage(OutboundMessage outboundMessage, String string) {
        if (this.getServiceStatus() != ServiceStatus.STARTED) {
            return false;
        }
        outboundMessage.setGatewayId(string);
        return this.queueMessage(outboundMessage);
    }

    public int queueMessages(Collection<OutboundMessage> collection) {
        int n = 0;
        if (this.getServiceStatus() != ServiceStatus.STARTED) {
            return 0;
        }
        Iterator<OutboundMessage> iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (!this.queueMessage(iterator.next())) continue;
            ++n;
        }
        iterator = null;
        return n;
    }

    public int queueMessages(OutboundMessage[] outboundMessageArray) {
        int n = 0;
        if (this.getServiceStatus() != ServiceStatus.STARTED) {
            return 0;
        }
        for (int i = 0; i < outboundMessageArray.length; ++i) {
            if (!this.queueMessage(outboundMessageArray[i])) continue;
            ++n;
        }
        return n;
    }

    public int queueMessages(Collection<OutboundMessage> collection, String string) {
        if (this.getServiceStatus() != ServiceStatus.STARTED) {
            return 0;
        }
        int n = 0;
        for (OutboundMessage outboundMessage : collection) {
            outboundMessage.setGatewayId(string);
            if (!this.queueMessage(outboundMessage)) continue;
            ++n;
        }
        Iterator<OutboundMessage> iterator = null;
        return n;
    }

    public int queueMessages(OutboundMessage[] outboundMessageArray, String string) {
        int n = 0;
        if (this.getServiceStatus() != ServiceStatus.STARTED) {
            return 0;
        }
        for (int i = 0; i < outboundMessageArray.length; ++i) {
            outboundMessageArray[i].setGatewayId(string);
            if (!this.queueMessage(outboundMessageArray[i])) continue;
            ++n;
        }
        return n;
    }

    public boolean queueMessageAt(OutboundMessage outboundMessage, Date date) {
        outboundMessage.setScheduledDeliveryDate(date);
        return this.queueMessage(outboundMessage);
    }

    public boolean queueMessageAt(OutboundMessage outboundMessage, long l) {
        outboundMessage.setDeliveryDelay(l);
        return this.queueMessage(outboundMessage);
    }

    public boolean removeMessage(OutboundMessage outboundMessage) {
        if (this.getServiceStatus() != ServiceStatus.STARTED) {
            return false;
        }
        return this.getQueueManager().removePendingMessage(outboundMessage);
    }

    public boolean removeMessage(String string) {
        if (this.getServiceStatus() != ServiceStatus.STARTED) {
            return false;
        }
        return this.getQueueManager().removePendingMessage(string);
    }

    public boolean deleteMessage(InboundMessage inboundMessage) throws TimeoutException, GatewayException, IOException, InterruptedException {
        if (this.getServiceStatus() != ServiceStatus.STARTED) {
            return false;
        }
        AGateway aGateway = this.findGateway(inboundMessage.getGatewayId());
        if (aGateway != null) {
            try {
                return aGateway.deleteMessage(inboundMessage);
            }
            catch (TimeoutException timeoutException) {
                Logger.getInstance().logWarn("deleteMessage(): Gateway " + aGateway.getGatewayId() + " does not respond, marking for restart.", null, null);
                aGateway.setStatus(AGatewayHelper.GatewayStatuses.RESTART);
                return false;
            }
            catch (IOException iOException) {
                Logger.getInstance().logWarn("deleteMessage(): Gateway " + aGateway.getGatewayId() + " throws IO errors, marking for restart.", null, null);
                aGateway.setStatus(AGatewayHelper.GatewayStatuses.RESTART);
                return false;
            }
        }
        return false;
    }

    public boolean sendUSSDRequest(USSDRequest uSSDRequest, String string) throws GatewayException, TimeoutException, IOException, InterruptedException {
        if (this.getServiceStatus() != ServiceStatus.STARTED) {
            throw new GatewayException("Service is not started");
        }
        AGateway aGateway = this.findGateway(string);
        if (uSSDRequest == null) {
            throw new IllegalArgumentException("Cannot use a null request object");
        }
        if (aGateway == null) {
            throw new GatewayException("Cannot use a null gateway");
        }
        return aGateway.sendUSSDRequest(uSSDRequest);
    }

    public int readPhonebook(Phonebook phonebook, String string) throws TimeoutException, GatewayException, IOException, InterruptedException {
        if (this.getServiceStatus() != ServiceStatus.STARTED) {
            return 0;
        }
        AGateway aGateway = this.findGateway(string);
        if (aGateway != null) {
            return aGateway.readPhonebook(phonebook);
        }
        return 0;
    }

    public int getInboundMessageCount(String string) {
        return this.getInboundMessageCount(this.findGateway(string));
    }

    public int getInboundMessageCount(AGateway aGateway) {
        return aGateway != null ? aGateway.getInboundMessageCount() : -1;
    }

    public int getOutboundMessageCount(String string) {
        return this.getOutboundMessageCount(this.findGateway(string));
    }

    public int getOutboundMessageCount(AGateway aGateway) {
        return aGateway != null ? aGateway.getOutboundMessageCount() : -1;
    }

    public int getInboundMessageCount() {
        int n = 0;
        for (AGateway aGateway : this.getGateways()) {
            n += aGateway.getInboundMessageCount();
        }
        Iterator<AGateway> iterator = null;
        return n;
    }

    public int getOutboundMessageCount() {
        int n = 0;
        for (AGateway aGateway : this.getGateways()) {
            n += aGateway.getOutboundMessageCount();
        }
        Iterator<AGateway> iterator = null;
        return n;
    }

    public AGateway findGateway(String string) {
        Iterator<AGateway> iterator = this.getGateways().iterator();
        while (iterator.hasNext()) {
            AGateway aGateway = iterator.next();
            if (!aGateway.getGatewayId().equals(string)) continue;
            iterator = null;
            return aGateway;
        }
        iterator = null;
        return null;
    }

    public Collection<AGateway> getGateways() {
        return this.gatewayList;
    }

    public AGateway[] getGatewaysNET() {
        return this.getGateways().toArray(new AGateway[0]);
    }

    public LoadBalancer getLoadBalancer() {
        return this.loadBalancer;
    }

    public void setLoadBalancer(LoadBalancer loadBalancer) {
        this.loadBalancer = loadBalancer;
    }

    public Router getRouter() {
        return this.router;
    }

    public void setRouter(Router router) {
        this.router = router;
    }

    public synchronized AGateway routeMessage(OutboundMessage outboundMessage) {
        Collection<AGateway> collection = this.getRouter().route(outboundMessage, this.getGateways());
        if (collection.size() > 0) {
            return this.getLoadBalancer().balance(outboundMessage, collection);
        }
        outboundMessage.setMessageStatus(OutboundMessage.MessageStatuses.FAILED);
        outboundMessage.setFailureCause(OutboundMessage.FailureCauses.NO_ROUTE);
        return null;
    }

    public IInboundMessageNotification getInboundMessageNotification() {
        return this.inboundMessageNotification;
    }

    public void setInboundMessageNotification(IInboundMessageNotification iInboundMessageNotification) {
        this.inboundMessageNotification = iInboundMessageNotification;
    }

    public IOutboundMessageNotification getOutboundMessageNotification() {
        return this.outboundMessageNotification;
    }

    public void setOutboundMessageNotification(IOutboundMessageNotification iOutboundMessageNotification) {
        this.outboundMessageNotification = iOutboundMessageNotification;
    }

    public ICallNotification getCallNotification() {
        return this.callNotification;
    }

    public void setCallNotification(ICallNotification iCallNotification) {
        this.callNotification = iCallNotification;
    }

    public IUSSDNotification getUSSDNotification() {
        return this.ussdNotification;
    }

    public void setUSSDNotification(IUSSDNotification iUSSDNotification) {
        this.ussdNotification = iUSSDNotification;
    }

    public IGatewayStatusNotification getGatewayStatusNotification() {
        return this.gatewayStatusNotification;
    }

    public void setGatewayStatusNotification(IGatewayStatusNotification iGatewayStatusNotification) {
        this.gatewayStatusNotification = iGatewayStatusNotification;
    }

    public IQueueSendingNotification getQueueSendingNotification() {
        return this.queueSendingNotification;
    }

    public void setQueueSendingNotification(IQueueSendingNotification iQueueSendingNotification) {
        this.queueSendingNotification = iQueueSendingNotification;
    }

    public IOrphanedMessageNotification getOrphanedMessageNotification() {
        return this.orphanedMessageNotification;
    }

    public void setOrphanedMessageNotification(IOrphanedMessageNotification iOrphanedMessageNotification) {
        this.orphanedMessageNotification = iOrphanedMessageNotification;
    }

    public long getStartMillis() {
        return this.startMillis;
    }

    void setSettings(Settings settings) {
        this.S = settings;
    }

    public ServiceStatus getServiceStatus() {
        return this.serviceStatus;
    }

    void setServiceStatus(ServiceStatus serviceStatus) {
        this.serviceStatus = serviceStatus;
    }

    public Settings getSettings() {
        return this.S;
    }

    public boolean createGroup(String string) {
        this.groups.add(new Group(string));
        return true;
    }

    public boolean removeGroup(String string) {
        Iterator<Group> iterator = this.groups.iterator();
        while (iterator.hasNext()) {
            Group group = iterator.next();
            if (!group.getName().equalsIgnoreCase(string)) continue;
            group.clear();
            this.groups.remove(group);
            iterator = null;
            return true;
        }
        iterator = null;
        return false;
    }

    public ArrayList<String> expandGroup(String string) {
        Iterator<Group> iterator = this.groups.iterator();
        while (iterator.hasNext()) {
            Group group = iterator.next();
            if (!group.getName().equalsIgnoreCase(string)) continue;
            iterator = null;
            return new ArrayList<String>(group.getNumbers());
        }
        iterator = null;
        return new ArrayList<String>();
    }

    public boolean addToGroup(String string, String string2) {
        Iterator<Group> iterator = this.groups.iterator();
        while (iterator.hasNext()) {
            Group group = iterator.next();
            if (!group.getName().equalsIgnoreCase(string)) continue;
            group.addNumber(string2);
            iterator = null;
            return true;
        }
        iterator = null;
        return false;
    }

    public boolean removeFromGroup(String string, String string2) {
        Iterator<Group> iterator = this.groups.iterator();
        while (iterator.hasNext()) {
            Group group = iterator.next();
            if (!group.getName().equalsIgnoreCase(string)) continue;
            iterator = null;
            return group.removeNumber(string2);
        }
        iterator = null;
        return false;
    }

    public boolean checkInGroup(String string, String string2) {
        Iterator<Group> iterator = this.groups.iterator();
        while (iterator.hasNext()) {
            Group group = iterator.next();
            if (!group.getName().equalsIgnoreCase(string)) continue;
            Collection<String> collection = group.getNumbers();
            iterator = null;
            return collection.contains(string2);
        }
        iterator = null;
        return false;
    }

    public boolean setQueueManager(AbstractQueueManager abstractQueueManager) {
        if (this.getServiceStatus() != ServiceStatus.STOPPED) {
            return false;
        }
        this.queueManager = abstractQueueManager;
        return true;
    }

    public AbstractQueueManager getQueueManager() {
        return this.queueManager;
    }

    void setNotifyQueueManager(NotifyQueueManager notifyQueueManager) {
        this.notifyQueueManager = notifyQueueManager;
    }

    public NotifyQueueManager getNotifyQueueManager() {
        return this.notifyQueueManager;
    }

    public KeyManager getKeyManager() {
        return this.keyManager;
    }

    IlIlIlIllIlllIIl getWatchDog() {
        return this.watchDog;
    }

    void setWatchDog(IlIlIlIllIlllIIl ilIlIlIllIlllIIl) {
        this.watchDog = ilIlIlIllIlllIIl;
    }

    public static void main(String[] stringArray) {
        System.out.println(Library.getLibraryDescription());
        System.out.println("\nSendSMS API Version: " + Library.getLibraryVersion());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ServiceStatus {
        STARTING,
        STARTED,
        STOPPING,
        STOPPED;

    }
}

