/*
 * Decompiled with CFR 0.152.
 */
package cn.ajwcc.pduUtils.gsm3040;

import cn.ajwcc.pduUtils.gsm3040.Pdu;
import cn.ajwcc.pduUtils.gsm3040.PduUtils;
import cn.ajwcc.pduUtils.gsm3040.SmsDeliveryPdu;
import cn.ajwcc.pduUtils.gsm3040.SmsStatusReportPdu;
import cn.ajwcc.pduUtils.gsm3040.SmsSubmitPdu;
import cn.ajwcc.pduUtils.gsm3040.ie.ConcatInformationElement;
import cn.ajwcc.pduUtils.gsm3040.ie.InformationElement;
import cn.ajwcc.pduUtils.gsm3040.ie.InformationElementFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;

public class PduGenerator {
    private ByteArrayOutputStream a;
    private int b = -1;
    private boolean c = false;

    protected void writeSmscInfo(Pdu pdu) throws Exception {
        if (pdu.getSmscAddress() != null) {
            this.writeBCDAddress(pdu.getSmscAddress(), pdu.getSmscAddressType(), pdu.getSmscInfoLength());
        } else {
            this.writeByte(0);
        }
    }

    protected void writeFirstOctet(Pdu pdu) {
        this.b = pdu.getSmscInfoLength() + 1;
        this.writeByte(pdu.getFirstOctet());
    }

    protected void writeValidityPeriodInteger(int validityPeriod) {
        if (validityPeriod == -1) {
            this.a.write(255);
        } else {
            int validityInt = validityPeriod <= 12 ? validityPeriod * 12 - 1 : (validityPeriod <= 24 ? (validityPeriod - 12) * 2 + 143 : (validityPeriod <= 720 ? validityPeriod / 24 + 166 : validityPeriod / 168 + 192));
            this.a.write(validityInt);
        }
    }

    protected void writeTimeStampStringForDate(Date timestamp) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(timestamp);
        int year = cal.get(1) - 2000;
        int month = cal.get(2) + 1;
        int dayOfMonth = cal.get(5);
        int hourOfDay = cal.get(11);
        int minute = cal.get(12);
        int sec = cal.get(13);
        TimeZone tz = cal.getTimeZone();
        int offset = tz.getOffset(timestamp.getTime());
        int minOffset = offset / 60000;
        int tzValue = minOffset / 15;
        if (tzValue < 0) {
            tzValue = 128 - tzValue;
        }
        this.a.write(PduUtils.createSwappedBCD(year));
        this.a.write(PduUtils.createSwappedBCD(month));
        this.a.write(PduUtils.createSwappedBCD(dayOfMonth));
        this.a.write(PduUtils.createSwappedBCD(hourOfDay));
        this.a.write(PduUtils.createSwappedBCD(minute));
        this.a.write(PduUtils.createSwappedBCD(sec));
        this.a.write(PduUtils.createSwappedBCD(tzValue));
    }

    protected void writeAddress(String address, int addressType, int addressLength) throws Exception {
        switch (PduUtils.extractAddressType(addressType)) {
            case 80: {
                byte[] textSeptets = PduUtils.stringToUnencodedSeptets(address);
                byte[] alphaNumBytes = PduUtils.encode7bitUserData(null, textSeptets);
                this.a.write(alphaNumBytes.length * 2);
                this.a.write(addressType);
                this.a.write(alphaNumBytes);
                break;
            }
            default: {
                this.writeBCDAddress(address, addressType, addressLength);
            }
        }
    }

    protected void writeBCDAddress(String address, int addressType, int addressLength) throws Exception {
        this.a.write(addressLength);
        this.a.write(addressType);
        if (address.length() % 2 == 1) {
            address = address + "F";
        }
        int digit = 0;
        for (int i2 = 0; i2 < address.length(); ++i2) {
            char c2 = address.charAt(i2);
            if (i2 % 2 == 1) {
                this.a.write(digit |= Integer.parseInt(Character.toString(c2), 16) << 4);
                digit = 0;
                continue;
            }
            digit |= Integer.parseInt(Character.toString(c2), 16) & 0xF;
        }
    }

    protected void writeUDData(Pdu pdu, int mpRefNo, int partNo) {
        int dcs = pdu.getDataCodingScheme();
        try {
            switch (PduUtils.extractDcsEncoding(dcs)) {
                case 0: {
                    this.writeUDData7bit(pdu, mpRefNo, partNo);
                    break;
                }
                case 4: {
                    this.a(pdu, mpRefNo, partNo);
                    break;
                }
                case 8: {
                    this.writeUDDataUCS2(pdu, mpRefNo, partNo);
                    break;
                }
                default: {
                    throw new RuntimeException("Invalid DCS encoding: " + PduUtils.extractDcsEncoding(dcs));
                }
            }
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }

    private void a(Pdu pdu, int mpRefNo, int partNo) throws Exception {
        byte[] data = pdu.isBinary() ? PduUtils.convertByteArr(pdu.getDataBytes()) : PduUtils.hexStr2ByteArr(pdu.getDecodedText());
        int potentialUdhLength = this.computePotentialUdhLength(pdu);
        this.checkForConcat(pdu, data.length, 140 - pdu.getTotalUDHLength(), 140 - potentialUdhLength, mpRefNo, partNo);
        int totalUDHLength = pdu.getTotalUDHLength();
        int maxMessageLength = 140 - totalUDHLength;
        int offset = this.computeOffset(pdu, maxMessageLength, partNo);
        byte[] dataToWrite = new byte[Math.min(maxMessageLength, data.length - offset)];
        System.arraycopy(data, offset, dataToWrite, 0, dataToWrite.length);
        int udLength = totalUDHLength + dataToWrite.length;
        this.a.write(udLength);
        if (pdu.hasTpUdhi()) {
            this.writeUDH(pdu, this.a);
        }
        this.a.write(dataToWrite);
    }

    protected void writeUDH(Pdu pdu) throws IOException {
        this.writeUDH(pdu, this.a);
    }

    protected void writeUDH(Pdu pdu, ByteArrayOutputStream udhBaos) throws IOException {
        udhBaos.write(pdu.getUDHLength());
        Iterator<InformationElement> ieIterator = pdu.getInformationElements();
        while (ieIterator.hasNext()) {
            InformationElement ie = ieIterator.next();
            udhBaos.write(ie.getIdentifier());
            udhBaos.write(ie.getLength());
            udhBaos.write(ie.getData());
        }
    }

    protected int computeOffset(Pdu pdu, int maxMessageLength, int partNo) {
        int offset;
        int maxParts = 1;
        maxParts = !pdu.isBinary() ? pdu.getDecodedText().length() / maxMessageLength + 1 : pdu.getDataBytes().length / maxMessageLength + 1;
        if (pdu.hasTpUdhi() && pdu.getConcatInfo() != null && partNo > 0) {
            pdu.getConcatInfo().setMpMaxNo(maxParts);
        }
        if (maxParts > 1 && partNo > 0) {
            if (partNo > maxParts) {
                throw new RuntimeException("Invalid partNo: " + partNo + ", maxParts=" + maxParts);
            }
            offset = (partNo - 1) * maxMessageLength;
        } else {
            offset = 0;
        }
        return offset;
    }

    protected void checkForConcat(Pdu pdu, int lengthOfText, int maxLength, int maxLengthWithUdh, int mpRefNo, int partNo) {
        if (lengthOfText > maxLengthWithUdh && (lengthOfText <= maxLengthWithUdh || lengthOfText > maxLength)) {
            if (pdu.getConcatInfo() != null) {
                pdu.getConcatInfo().setMpRefNo(mpRefNo);
                pdu.getConcatInfo().setMpSeqNo(partNo);
            } else {
                ConcatInformationElement concatInfo = InformationElementFactory.generateConcatInfo(mpRefNo, partNo);
                pdu.addInformationElement(concatInfo);
                this.c = true;
            }
        }
    }

    protected int computePotentialUdhLength(Pdu pdu) {
        int currentUdhLength = pdu.getTotalUDHLength();
        if (currentUdhLength == 0) {
            return ConcatInformationElement.getDefaultConcatLength() + 1;
        }
        return currentUdhLength + ConcatInformationElement.getDefaultConcatLength();
    }

    protected void writeUDData7bit(Pdu pdu, int mpRefNo, int partNo) throws Exception {
        String decodedText = pdu.getDecodedText();
        byte[] textSeptetsForDecodedText = PduUtils.stringToUnencodedSeptets(decodedText);
        int potentialUdhLength = PduUtils.getNumSeptetsForOctets(this.computePotentialUdhLength(pdu));
        this.checkForConcat(pdu, textSeptetsForDecodedText.length, 160 - PduUtils.getNumSeptetsForOctets(pdu.getTotalUDHLength()), 160 - potentialUdhLength, mpRefNo, partNo);
        int totalUDHLength = pdu.getTotalUDHLength();
        int maxMessageLength = 160 - PduUtils.getNumSeptetsForOctets(totalUDHLength);
        byte[] textSeptets = this.b(pdu, maxMessageLength, partNo);
        int udLength = PduUtils.getNumSeptetsForOctets(totalUDHLength) + textSeptets.length;
        this.a.write(udLength);
        byte[] udhBytes = null;
        if (pdu.hasTpUdhi()) {
            ByteArrayOutputStream udhBaos = new ByteArrayOutputStream();
            this.writeUDH(pdu, udhBaos);
            udhBytes = udhBaos.toByteArray();
        }
        byte[] udBytes = PduUtils.encode7bitUserData(udhBytes, textSeptets);
        this.a.write(udBytes);
    }

    private byte[] b(Pdu pdu, int maxMessageLength, int partNo) {
        int offset;
        int maxParts = 1;
        byte[] unencodedSeptets = PduUtils.stringToUnencodedSeptets(pdu.getDecodedText());
        maxParts = unencodedSeptets.length / maxMessageLength + 1;
        if (pdu.hasTpUdhi() && pdu.getConcatInfo() != null && partNo > 0) {
            pdu.getConcatInfo().setMpMaxNo(maxParts);
        }
        if (maxParts > 1 && partNo > 0) {
            if (partNo > maxParts) {
                throw new RuntimeException("Invalid partNo: " + partNo + ", maxParts=" + maxParts);
            }
            offset = (partNo - 1) * maxMessageLength;
        } else {
            offset = 0;
        }
        byte[] septetsForPart = new byte[Math.min(maxMessageLength, unencodedSeptets.length - offset)];
        System.arraycopy(unencodedSeptets, offset, septetsForPart, 0, septetsForPart.length);
        return septetsForPart;
    }

    protected void writeUDData8bit(Pdu pdu, int mpRefNo, int partNo) throws Exception {
        byte[] data = pdu.isBinary() ? pdu.getDataBytes() : PduUtils.encode8bitUserData(pdu.getDecodedText());
        int potentialUdhLength = this.computePotentialUdhLength(pdu);
        this.checkForConcat(pdu, data.length, 140 - pdu.getTotalUDHLength(), 140 - potentialUdhLength, mpRefNo, partNo);
        int totalUDHLength = pdu.getTotalUDHLength();
        int maxMessageLength = 140 - totalUDHLength;
        int offset = this.computeOffset(pdu, maxMessageLength, partNo);
        byte[] dataToWrite = new byte[Math.min(maxMessageLength, data.length - offset)];
        System.arraycopy(data, offset, dataToWrite, 0, dataToWrite.length);
        int udLength = totalUDHLength + dataToWrite.length;
        this.a.write(udLength);
        if (pdu.hasTpUdhi()) {
            this.writeUDH(pdu, this.a);
        }
        this.a.write(dataToWrite);
    }

    protected void writeUDDataUCS2(Pdu pdu, int mpRefNo, int partNo) throws Exception {
        String decodedText = pdu.getDecodedText();
        int potentialUdhLength = this.computePotentialUdhLength(pdu);
        this.checkForConcat(pdu, decodedText.length(), (140 - pdu.getTotalUDHLength()) / 2, (140 - potentialUdhLength) / 2, mpRefNo, partNo);
        int totalUDHLength = pdu.getTotalUDHLength();
        int maxMessageLength = (140 - totalUDHLength) / 2;
        int offset = this.computeOffset(pdu, maxMessageLength, partNo);
        String textToEncode = decodedText.substring(offset, Math.min(offset + maxMessageLength, decodedText.length()));
        int udLength = totalUDHLength + textToEncode.length() * 2;
        this.a.write(udLength);
        if (pdu.hasTpUdhi()) {
            this.writeUDH(pdu, this.a);
        }
        this.a.write(PduUtils.encodeUcs2UserData(textToEncode));
    }

    protected void writeByte(int i2) {
        this.a.write(i2);
    }

    protected void writeBytes(byte[] b2) throws Exception {
        this.a.write(b2);
    }

    public List<String> generatePduList(Pdu pdu, int mpRefNo) {
        ArrayList<String> pduList = new ArrayList<String>();
        for (int i2 = 1; i2 <= pdu.getMpMaxNo(); ++i2) {
            String pduString = this.generatePduString(pdu, mpRefNo, i2);
            pduList.add(pduString);
        }
        return pduList;
    }

    public String generatePduString(Pdu pdu) {
        return this.generatePduString(pdu, -1, -1);
    }

    public String generatePduString(Pdu pdu, int mpRefNo, int partNo) {
        try {
            this.a = new ByteArrayOutputStream();
            this.b = -1;
            this.c = false;
            if (!pdu.isBinary() && pdu.getDecodedText().compareToIgnoreCase("!$!$") == 0) {
                this.generateSmsNoShowString((SmsSubmitPdu)pdu);
                byte[] silentPduBytes = this.a.toByteArray();
                return PduUtils.bytesToPdu(silentPduBytes);
            }
            switch (pdu.getTpMti()) {
                case 0: {
                    this.generateSmsDeliverPduString((SmsDeliveryPdu)pdu, mpRefNo, partNo);
                    break;
                }
                case 1: {
                    this.generateSmsSubmitPduString((SmsSubmitPdu)pdu, mpRefNo, partNo);
                    break;
                }
                case 2: {
                    this.generateSmsStatusReportPduString((SmsStatusReportPdu)pdu);
                }
            }
            byte[] pduBytes = this.a.toByteArray();
            if (this.c) {
                pduBytes[this.b] = (byte)(pdu.getFirstOctet() & 0xFF);
            }
            return PduUtils.bytesToPdu(pduBytes);
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }

    protected void generateSmsNoShowString(SmsSubmitPdu pdu) throws Exception {
        this.writeSmscInfo(pdu);
        this.writeFirstOctet(pdu);
        this.writeByte(pdu.getMessageReference());
        this.writeAddress(pdu.getAddress(), pdu.getAddressType(), pdu.getAddress().length());
        this.writeByte(64);
        this.writeByte(192);
        switch (pdu.getTpVpf()) {
            case 16: {
                this.writeValidityPeriodInteger(pdu.getValidityPeriod());
                break;
            }
            case 24: {
                this.writeTimeStampStringForDate(pdu.getValidityDate());
            }
        }
        this.writeByte(0);
    }

    protected void generateSmsSubmitPduString(SmsSubmitPdu pdu, int mpRefNo, int partNo) throws Exception {
        this.writeSmscInfo(pdu);
        this.writeFirstOctet(pdu);
        this.writeByte(pdu.getMessageReference());
        this.writeAddress(pdu.getAddress(), pdu.getAddressType(), pdu.getAddress().length());
        this.writeByte(pdu.getProtocolIdentifier());
        this.writeByte(pdu.getDataCodingScheme());
        switch (pdu.getTpVpf()) {
            case 16: {
                this.writeValidityPeriodInteger(pdu.getValidityPeriod());
                break;
            }
            case 24: {
                this.writeTimeStampStringForDate(pdu.getValidityDate());
            }
        }
        this.writeUDData(pdu, mpRefNo, partNo);
    }

    protected void generateSmsDeliverPduString(SmsDeliveryPdu pdu, int mpRefNo, int partNo) throws Exception {
        this.writeSmscInfo(pdu);
        this.writeFirstOctet(pdu);
        this.writeAddress(pdu.getAddress(), pdu.getAddressType(), pdu.getAddress().length());
        this.writeByte(pdu.getProtocolIdentifier());
        this.writeByte(pdu.getDataCodingScheme());
        this.writeTimeStampStringForDate(pdu.getTimestamp());
        this.writeUDData(pdu, mpRefNo, partNo);
    }

    protected void generateSmsStatusReportPduString(SmsStatusReportPdu pdu) throws Exception {
        this.writeSmscInfo(pdu);
        this.writeFirstOctet(pdu);
        this.writeByte(pdu.getMessageReference());
        this.writeAddress(pdu.getAddress(), pdu.getAddressType(), pdu.getAddress().length());
        this.writeTimeStampStringForDate(pdu.getTimestamp());
        this.writeTimeStampStringForDate(pdu.getDischargeTime());
        this.writeByte(pdu.getStatus());
    }
}

