/*
 * Decompiled with CFR 0.152.
 */
package cn.ajwcc.pduUtils.gsm3040;

import cn.ajwcc.pduUtils.gsm3040.Pdu;
import cn.ajwcc.pduUtils.gsm3040.PduUtils;
import java.util.Calendar;
import java.util.Date;

public class SmsSubmitPdu
extends Pdu {
    private int a = 0;
    private int b = -1;
    private Calendar c;

    public void setTpRd(int value) {
        this.setFirstOctetField(251, value, new int[]{0, 4});
    }

    public boolean hasTpRd() {
        return this.getFirstOctetField(251) == 4;
    }

    public void setTpVpf(int value) {
        this.setFirstOctetField(231, value, new int[]{16, 0, 24});
    }

    public int getTpVpf() {
        return this.getFirstOctetField(231);
    }

    public boolean hasTpVpf() {
        return this.getFirstOctetField(231) != 0;
    }

    public void setTpSrr(int value) {
        this.setFirstOctetField(223, value, new int[]{0, 32});
    }

    public boolean hasTpSrr() {
        return this.getFirstOctetField(223) == 32;
    }

    public void setMessageReference(int reference) {
        this.a = reference;
    }

    public int getMessageReference() {
        return this.a;
    }

    public int getValidityPeriod() {
        return this.b;
    }

    public void setValidityPeriod(int validityPeriod) {
        this.b = validityPeriod;
    }

    public void setValidityTimestamp(Calendar date) {
        this.c = date;
    }

    public Date getValidityDate() {
        return this.c.getTime();
    }

    public Calendar getValidityDateAsCalendar() {
        return this.c;
    }

    @Override
    protected String pduSubclassInfo() {
        StringBuffer sb = new StringBuffer();
        sb.append("Message Reference: " + PduUtils.byteToPdu(this.getMessageReference()));
        sb.append("\n");
        if (this.getAddress() != null) {
            sb.append("Destination Address: [Length: " + this.getAddress().length() + " (" + PduUtils.byteToPdu((byte)this.getAddress().length()) + ")");
            sb.append(", Type: " + PduUtils.byteToPdu(this.getAddressType()) + " (" + PduUtils.byteToBits((byte)this.getAddressType()) + ")");
            sb.append(", Address: " + this.getAddress());
            sb.append("]");
        } else {
            sb.append("Destination Address: [Length: 0");
            sb.append(", Type: " + PduUtils.byteToPdu(this.getAddressType()) + " (" + PduUtils.byteToBits((byte)this.getAddressType()) + ")");
            sb.append("]");
        }
        sb.append("\n");
        sb.append("TP-PID: " + PduUtils.byteToPdu(this.getProtocolIdentifier()) + " (" + PduUtils.byteToBits((byte)this.getProtocolIdentifier()) + ")");
        sb.append("\n");
        sb.append("TP-DCS: " + PduUtils.byteToPdu(this.getDataCodingScheme()) + " (" + PduUtils.decodeDataCodingScheme(this) + ") (" + PduUtils.byteToBits((byte)this.getDataCodingScheme()) + ")");
        sb.append("\n");
        switch (this.getTpVpf()) {
            case 16: {
                sb.append("TP-VPF: " + this.getValidityPeriod() + " hours");
                break;
            }
            case 24: {
                sb.append("TP-VPF: " + this.formatTimestamp(this.getValidityDateAsCalendar()));
            }
        }
        sb.append("\n");
        return sb.toString();
    }
}

