/*
 * Decompiled with CFR 0.152.
 */
package cn.sendsms;

import cn.sendsms.AGateway;
import cn.sendsms.GatewayException;
import cn.sendsms.Group;
import cn.sendsms.ICallNotification;
import cn.sendsms.IGatewayStatusNotification;
import cn.sendsms.IInboundMessageNotification;
import cn.sendsms.IOrphanedMessageNotification;
import cn.sendsms.IOutboundMessageNotification;
import cn.sendsms.IQueueSendingNotification;
import cn.sendsms.IUSSDNotification;
import cn.sendsms.InboundMessage;
import cn.sendsms.Library;
import cn.sendsms.OutboundMessage;
import cn.sendsms.Phonebook;
import cn.sendsms.SendSMSException;
import cn.sendsms.Settings;
import cn.sendsms.TimeoutException;
import cn.sendsms.USSDRequest;
import cn.sendsms.balancing.LoadBalancer;
import cn.sendsms.balancing.RoundRobinLoadBalancer;
import cn.sendsms.crypto.KeyManager;
import cn.sendsms.helper.AGatewayHelper;
import cn.sendsms.helper.Logger;
import cn.sendsms.jdsmsserver.web.DeviceInfoCache;
import cn.sendsms.notify.NotifyQueueManager;
import cn.sendsms.queues.AbstractQueueManager;
import cn.sendsms.queues.DefaultQueueManager;
import cn.sendsms.routing.Router;
import cn.sendsms.threading.AServiceThread;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class Service {
    private List<AGateway> a;
    private Router b;
    private LoadBalancer c;
    private c d;
    private IInboundMessageNotification e;
    private IOutboundMessageNotification f;
    private ICallNotification g;
    private IGatewayStatusNotification h;
    private IQueueSendingNotification i;
    private IOrphanedMessageNotification j;
    protected AbstractQueueManager queueManager;
    protected NotifyQueueManager notifyQueueManager;
    private long k;
    private Collection<Group> l;
    private volatile ServiceStatus serviceStatus;
    private KeyManager m;
    public Settings S;
    private IUSSDNotification n;
    private static final Service service = new Service();
    public static final int maxnumofgateway = 64;

    private Service() {
        this.a(new Settings());
        this.initializeService();
    }

    protected void initializeService() {
        this.k = System.currentTimeMillis();
        this.a(ServiceStatus.STOPPED);
        this.l = new ArrayList<Group>();
        this.b();
        this.a = new ArrayList<AGateway>();
        this.m = KeyManager.getInstance();
        this.setRouter(new Router());
        this.setLoadBalancer(new RoundRobinLoadBalancer());
        this.a(new NotifyQueueManager());
    }

    private void b() {
        Logger.getInstance().logInfo(Library.getLibraryDescription(), null, null);
        Logger.getInstance().logInfo("Version: " + Library.getLibraryVersion(), null, null);
        Logger.getInstance().logInfo("JRE Version: " + System.getProperty("java.version"), null, null);
        Logger.getInstance().logInfo("JRE Impl Version: " + System.getProperty("java.vm.version"), null, null);
        Logger.getInstance().logInfo("O/S: " + System.getProperty("os.name") + " / " + System.getProperty("os.arch") + " / " + System.getProperty("os.version"), null, null);
    }

    public Logger getLogger() {
        return Logger.getInstance();
    }

    public static Service getInstance() {
        return service;
    }

    public void addGateway(AGateway gateway) throws GatewayException {
        if (this.getServiceStatus() != ServiceStatus.STOPPED) {
            throw new GatewayException("Cannot add gateways while Service is running!");
        }
        this.getGateways().add(gateway);
    }

    public boolean removeGateway(AGateway gateway) throws GatewayException {
        if (this.getServiceStatus() != ServiceStatus.STOPPED) {
            throw new GatewayException("Cannot remove gateways while Service is running!");
        }
        return this.getGateways().remove(gateway);
    }

    public AGateway getGateway(String gatewayId) {
        Iterator<AGateway> iter = this.getGateways().iterator();
        while (iter.hasNext()) {
            AGateway gateway = iter.next();
            if (!gateway.getGatewayId().equalsIgnoreCase(gatewayId)) continue;
            iter = null;
            return gateway;
        }
        iter = null;
        return null;
    }

    public synchronized void startService() throws SendSMSException, TimeoutException, GatewayException, IOException, InterruptedException {
        this.startService(true);
    }

    public synchronized void startService(boolean startAllGateways) throws SendSMSException, TimeoutException, GatewayException, IOException, InterruptedException {
        this.queueManager = new DefaultQueueManager();
        try {
            this.getQueueManager().start();
            this.a(ServiceStatus.STARTING);
            this.a(new c("WatchDog", this.getSettings().WATCHDOG_INTERVAL * 1000));
            this.a(startAllGateways);
            this.a(ServiceStatus.STARTED);
        }
        catch (SendSMSException e2) {
            this.stopService();
            throw e2;
        }
        catch (IOException e3) {
            this.stopService();
            throw e3;
        }
        catch (InterruptedException e4) {
            this.stopService();
            throw e4;
        }
    }

    private void a(boolean startAll) throws SendSMSException, TimeoutException, GatewayException, IOException, InterruptedException {
        if (this.getSettings().CONCURRENT_GATEWAY_START) {
            class A {
                public Throwable a;
                public AGateway b;

                A() {
                }
            }
            LinkedList<A> eList = new LinkedList<A>();
            LinkedList<AGateway> gList = new LinkedList<AGateway>();
            for (AGateway gateway : this.getGateways()) {
                class B
                extends Thread {
                    AGateway a;
                    List<A> b;
                    List<AGateway> c;

                    public B(AGateway gateway, List<A> eList, List<AGateway> gList) {
                        this.a = gateway;
                        this.b = eList;
                        this.c = gList;
                    }

                    @Override
                    public void run() {
                        try {
                            this.a.startGateway();
                            this.c.add(this.a);
                            DeviceInfoCache.getInstance().findDevice(this.a.getGatewayId());
                        }
                        catch (Exception e2) {
                            A exc = new A();
                            exc.a = e2;
                            exc.b = this.a;
                            this.b.add(exc);
                            if (exc.a instanceof GatewayException) {
                                exc.b.setStatus(AGatewayHelper.GatewayStatuses.FAILURE);
                            }
                            exc.b.setStatus(AGatewayHelper.GatewayStatuses.STOPPED);
                        }
                    }
                }
                new B(gateway, eList, gList).start();
            }
            Iterator<AGateway> iter = null;
        } else {
            for (AGateway gateway : this.getGateways()) {
                try {
                    gateway.startGateway();
                }
                catch (Exception e2) {
                    if (e2 instanceof GatewayException) {
                        gateway.setStatus(AGatewayHelper.GatewayStatuses.FAILURE);
                    } else {
                        gateway.setStatus(AGatewayHelper.GatewayStatuses.STOPPED);
                    }
                    Logger.getInstance().logInfo(" start device failed", e2, gateway.getGatewayId());
                }
            }
            Object var2_3 = null;
        }
    }

    public synchronized void stopService() throws SendSMSException, TimeoutException, GatewayException, IOException, InterruptedException {
        this.a(ServiceStatus.STOPPING);
        if (this.getQueueManager() != null) {
            this.getQueueManager().stop();
        }
        if (this.a() != null) {
            this.a().cancel();
            this.a((c)null);
        }
        for (AGateway gateway : this.getGateways()) {
            gateway.stopGateway();
        }
        Iterator<AGateway> iter = null;
        this.getNotifyQueueManager().cancel();
        this.a(ServiceStatus.STOPPED);
    }

    public int readMessages(Collection<InboundMessage> msgList, InboundMessage.MessageClasses msgClass) throws TimeoutException, GatewayException, IOException, InterruptedException {
        if (this.getServiceStatus() != ServiceStatus.STARTED) {
            return 0;
        }
        for (AGateway gateway : this.getGateways()) {
            if (!gateway.isInbound()) continue;
            try {
                this.readMessages(msgList, msgClass, gateway);
            }
            catch (TimeoutException e2) {
                Logger.getInstance().logWarn("readMessages(): Gateway " + gateway.getGatewayId() + " does not respond, marking for restart.", null, null);
                gateway.setStatus(AGatewayHelper.GatewayStatuses.RESTART);
            }
            catch (IOException e3) {
                Logger.getInstance().logWarn("readMessages(): Gateway " + gateway.getGatewayId() + " throws IO errors, marking for restart.", null, null);
                gateway.setStatus(AGatewayHelper.GatewayStatuses.RESTART);
            }
        }
        Iterator<AGateway> iter = null;
        return msgList.size();
    }

    public InboundMessage[] readMessages(InboundMessage.MessageClasses msgClass) throws TimeoutException, GatewayException, IOException, InterruptedException {
        ArrayList<InboundMessage> messageList = new ArrayList<InboundMessage>();
        this.readMessages(messageList, msgClass);
        return messageList.toArray(new InboundMessage[0]);
    }

    public int readMessages(Collection<InboundMessage> msgList, InboundMessage.MessageClasses msgClass, String gatewayId) throws TimeoutException, GatewayException, IOException, InterruptedException {
        if (this.getServiceStatus() != ServiceStatus.STARTED) {
            return 0;
        }
        AGateway gateway = this.findGateway(gatewayId);
        if (gateway != null && gateway.isInbound()) {
            try {
                this.readMessages(msgList, msgClass, gateway);
            }
            catch (TimeoutException e2) {
                Logger.getInstance().logWarn("readMessages(): Gateway " + gateway.getGatewayId() + " does not respond, marking for restart.", null, null);
                gateway.setStatus(AGatewayHelper.GatewayStatuses.RESTART);
            }
            catch (IOException e3) {
                Logger.getInstance().logWarn("readMessages(): Gateway " + gateway.getGatewayId() + " throws IO errors, marking for restart.", null, null);
                gateway.setStatus(AGatewayHelper.GatewayStatuses.RESTART);
            }
        }
        return msgList.size();
    }

    public InboundMessage[] readMessages(InboundMessage.MessageClasses msgClass, String gatewayId) throws TimeoutException, GatewayException, IOException, InterruptedException {
        ArrayList<InboundMessage> messageList = new ArrayList<InboundMessage>();
        this.readMessages(messageList, msgClass, gatewayId);
        return messageList.toArray(new InboundMessage[0]);
    }

    public int readMessages(Collection<InboundMessage> msgList, InboundMessage.MessageClasses msgClass, AGateway gateway) throws TimeoutException, GatewayException, IOException, InterruptedException {
        if (this.getServiceStatus() != ServiceStatus.STARTED) {
            return 0;
        }
        try {
            gateway.readMessages(msgList, msgClass);
        }
        catch (TimeoutException e2) {
            Logger.getInstance().logWarn("readMessages(): Gateway " + gateway.getGatewayId() + " does not respond, marking for restart.", null, null);
            gateway.setStatus(AGatewayHelper.GatewayStatuses.RESTART);
        }
        catch (IOException e3) {
            Logger.getInstance().logWarn("readMessages(): Gateway " + gateway.getGatewayId() + " throws IO errors, marking for restart.", null, null);
            gateway.setStatus(AGatewayHelper.GatewayStatuses.RESTART);
        }
        return msgList.size();
    }

    public InboundMessage[] readMessages(InboundMessage.MessageClasses msgClass, AGateway gateway) throws TimeoutException, GatewayException, IOException, InterruptedException {
        ArrayList<InboundMessage> messageList = new ArrayList<InboundMessage>();
        this.readMessages(messageList, msgClass, gateway);
        return messageList.toArray(new InboundMessage[0]);
    }

    public InboundMessage readMessage(String gatewayId, String memLoc, int memIndex) throws TimeoutException, GatewayException, IOException, InterruptedException {
        if (this.getServiceStatus() != ServiceStatus.STARTED) {
            return null;
        }
        InboundMessage msg = null;
        AGateway gateway = this.findGateway(gatewayId);
        if (gateway != null && gateway.isInbound()) {
            try {
                msg = gateway.readMessage(memLoc, memIndex);
            }
            catch (TimeoutException e2) {
                Logger.getInstance().logWarn("readMessages(): Gateway " + gateway.getGatewayId() + " does not respond, marking for restart.", null, null);
                gateway.setStatus(AGatewayHelper.GatewayStatuses.RESTART);
            }
            catch (IOException e3) {
                Logger.getInstance().logWarn("readMessages(): Gateway " + gateway.getGatewayId() + " throws IO errors, marking for restart.", null, null);
                gateway.setStatus(AGatewayHelper.GatewayStatuses.RESTART);
            }
        }
        return msg;
    }

    public boolean sendMessage(OutboundMessage msg) throws TimeoutException, GatewayException, IOException, InterruptedException {
        if (this.getServiceStatus() != ServiceStatus.STARTED) {
            return false;
        }
        AGateway gateway = this.routeMessage(msg);
        if (gateway != null) {
            Logger.getInstance().logInfo("sending message by - " + gateway.getGatewayId(), null, null);
            try {
                ArrayList<String> recipients = this.expandGroup(msg.getRecipient());
                if (recipients.size() == 0) {
                    try {
                        return gateway.sendMessage(msg);
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                }
                ArrayList<OutboundMessage> groupMessages = new ArrayList<OutboundMessage>();
                for (int i2 = 0; i2 < recipients.size(); ++i2) {
                    String to = (String)recipients.get(i2);
                    OutboundMessage newMessage = new OutboundMessage();
                    msg.copyTo(newMessage);
                    newMessage.setRecipient(to);
                    groupMessages.add(newMessage);
                }
                this.sendMessages(groupMessages);
                return true;
            }
            catch (TimeoutException e3) {
                Logger.getInstance().logWarn("sendMessage(): " + gateway.getGatewayId() + " does not respond, marking for restart.", null, null);
                gateway.setStatus(AGatewayHelper.GatewayStatuses.RESTART);
                msg.setMessageStatus(OutboundMessage.MessageStatuses.FAILED);
                msg.setFailureCause(OutboundMessage.FailureCauses.GATEWAY_FAILURE);
                return false;
            }
            catch (IOException e4) {
                Logger.getInstance().logWarn("sendMessage(): " + gateway.getGatewayId() + " throws IO errors, marking for restart.", null, null);
                gateway.setStatus(AGatewayHelper.GatewayStatuses.RESTART);
                msg.setMessageStatus(OutboundMessage.MessageStatuses.FAILED);
                msg.setFailureCause(OutboundMessage.FailureCauses.GATEWAY_FAILURE);
                return false;
            }
        }
        msg.setMessageStatus(OutboundMessage.MessageStatuses.FAILED);
        msg.setFailureCause(OutboundMessage.FailureCauses.NO_ROUTE);
        return false;
    }

    public boolean sendMessage(OutboundMessage msg, String gatewayId) throws TimeoutException, GatewayException, IOException, InterruptedException {
        if (this.getServiceStatus() != ServiceStatus.STARTED) {
            return false;
        }
        msg.setGatewayId(gatewayId);
        return this.sendMessage(msg);
    }

    public int sendMessages(Collection<OutboundMessage> msgList) throws TimeoutException, GatewayException, IOException, InterruptedException {
        if (this.getServiceStatus() != ServiceStatus.STARTED) {
            return 0;
        }
        int counter = 0;
        Iterator<OutboundMessage> iter = msgList.iterator();
        while (iter.hasNext()) {
            if (!this.sendMessage(iter.next())) continue;
            ++counter;
        }
        iter = null;
        return counter;
    }

    public int sendMessages(OutboundMessage[] msgArray) throws TimeoutException, GatewayException, IOException, InterruptedException {
        int counter = 0;
        for (int i2 = 0; i2 < msgArray.length; ++i2) {
            if (!this.sendMessage(msgArray[i2])) continue;
            ++counter;
        }
        return counter;
    }

    public int sendMessages(Collection<OutboundMessage> msgList, String gatewayId) throws TimeoutException, GatewayException, IOException, InterruptedException {
        if (this.getServiceStatus() != ServiceStatus.STARTED) {
            return 0;
        }
        int counter = 0;
        for (OutboundMessage msg : msgList) {
            msg.setGatewayId(gatewayId);
            if (!this.sendMessage(msg)) continue;
            ++counter;
        }
        Iterator<OutboundMessage> iter = null;
        return counter;
    }

    public int sendMessages(OutboundMessage[] msgArray, String gatewayId) throws TimeoutException, GatewayException, IOException, InterruptedException {
        int counter = 0;
        for (int i2 = 0; i2 < msgArray.length; ++i2) {
            msgArray[i2].setGatewayId(gatewayId);
            if (!this.sendMessage(msgArray[i2])) continue;
            ++counter;
        }
        return counter;
    }

    public boolean queueMessage(OutboundMessage msg) {
        if (this.getServiceStatus() != ServiceStatus.STARTED) {
            return false;
        }
        ArrayList<String> recipients = this.expandGroup(msg.getRecipient());
        if (recipients.size() == 0) {
            if ("*".equals(msg.getGatewayId())) {
                AGateway gateway = this.routeMessage(msg);
                if (gateway == null) {
                    return false;
                }
                Logger.getInstance().logWarn("queuing message to " + gateway.getGatewayId(), null, null);
                msg.setGatewayId(gateway.getGatewayId());
            }
            return this.getQueueManager().queueMessage(msg);
        }
        for (int i2 = 0; i2 < recipients.size(); ++i2) {
            String to = (String)recipients.get(i2);
            OutboundMessage newMessage = new OutboundMessage();
            msg.copyTo(newMessage);
            newMessage.setRecipient(to);
            if ("*".equals(msg.getGatewayId())) {
                AGateway gateway = this.routeMessage(msg);
                if (gateway == null) {
                    return false;
                }
                Logger.getInstance().logWarn("queuing message to Gateway " + gateway.getGatewayId(), null, null);
                msg.setGatewayId(gateway.getGatewayId());
            }
            this.getQueueManager().queueMessage(newMessage);
        }
        return true;
    }

    public boolean queueMessage(OutboundMessage msg, String gatewayId) {
        if (this.getServiceStatus() != ServiceStatus.STARTED) {
            return false;
        }
        msg.setGatewayId(gatewayId);
        return this.queueMessage(msg);
    }

    public int queueMessages(Collection<OutboundMessage> msgList) {
        int counter = 0;
        if (this.getServiceStatus() != ServiceStatus.STARTED) {
            return 0;
        }
        Iterator<OutboundMessage> iterMessage = msgList.iterator();
        while (iterMessage.hasNext()) {
            if (!this.queueMessage(iterMessage.next())) continue;
            ++counter;
        }
        iterMessage = null;
        return counter;
    }

    public int queueMessages(OutboundMessage[] msgArray) {
        int counter = 0;
        if (this.getServiceStatus() != ServiceStatus.STARTED) {
            return 0;
        }
        for (int i2 = 0; i2 < msgArray.length; ++i2) {
            if (!this.queueMessage(msgArray[i2])) continue;
            ++counter;
        }
        return counter;
    }

    public int queueMessages(Collection<OutboundMessage> msgList, String gatewayId) {
        if (this.getServiceStatus() != ServiceStatus.STARTED) {
            return 0;
        }
        int counter = 0;
        for (OutboundMessage msg : msgList) {
            msg.setGatewayId(gatewayId);
            if (!this.queueMessage(msg)) continue;
            ++counter;
        }
        Iterator<OutboundMessage> iter = null;
        return counter;
    }

    public int queueMessages(OutboundMessage[] msgArray, String gatewayId) {
        int counter = 0;
        if (this.getServiceStatus() != ServiceStatus.STARTED) {
            return 0;
        }
        for (int i2 = 0; i2 < msgArray.length; ++i2) {
            msgArray[i2].setGatewayId(gatewayId);
            if (!this.queueMessage(msgArray[i2])) continue;
            ++counter;
        }
        return counter;
    }

    public boolean queueMessageAt(OutboundMessage msg, Date at) {
        msg.setScheduledDeliveryDate(at);
        return this.queueMessage(msg);
    }

    public boolean queueMessageAt(OutboundMessage msg, long delayMillis) {
        msg.setDeliveryDelay(delayMillis);
        return this.queueMessage(msg);
    }

    public boolean removeMessage(OutboundMessage msg) {
        if (this.getServiceStatus() != ServiceStatus.STARTED) {
            return false;
        }
        return this.getQueueManager().removePendingMessage(msg);
    }

    public boolean removeMessage(String messageId) {
        if (this.getServiceStatus() != ServiceStatus.STARTED) {
            return false;
        }
        return this.getQueueManager().removePendingMessage(messageId);
    }

    public boolean deleteMessage(InboundMessage msg) throws TimeoutException, GatewayException, IOException, InterruptedException {
        if (this.getServiceStatus() != ServiceStatus.STARTED) {
            return false;
        }
        AGateway gateway = this.findGateway(msg.getGatewayId());
        if (gateway != null) {
            try {
                return gateway.deleteMessage(msg);
            }
            catch (TimeoutException e2) {
                Logger.getInstance().logWarn("deleteMessage(): Gateway " + gateway.getGatewayId() + " does not respond, marking for restart.", null, null);
                gateway.setStatus(AGatewayHelper.GatewayStatuses.RESTART);
                return false;
            }
            catch (IOException e3) {
                Logger.getInstance().logWarn("deleteMessage(): Gateway " + gateway.getGatewayId() + " throws IO errors, marking for restart.", null, null);
                gateway.setStatus(AGatewayHelper.GatewayStatuses.RESTART);
                return false;
            }
        }
        return false;
    }

    public boolean sendUSSDRequest(USSDRequest request, String gatewayId) throws GatewayException, TimeoutException, IOException, InterruptedException {
        if (this.getServiceStatus() != ServiceStatus.STARTED) {
            throw new GatewayException("Service is not started");
        }
        AGateway gateway = this.findGateway(gatewayId);
        if (request == null) {
            throw new IllegalArgumentException("Cannot use a null request object");
        }
        if (gateway == null) {
            throw new GatewayException("Cannot use a null gateway");
        }
        return gateway.sendUSSDRequest(request);
    }

    public int readPhonebook(Phonebook phonebook, String gatewayId) throws TimeoutException, GatewayException, IOException, InterruptedException {
        if (this.getServiceStatus() != ServiceStatus.STARTED) {
            return 0;
        }
        AGateway gateway = this.findGateway(gatewayId);
        if (gateway != null) {
            return gateway.readPhonebook(phonebook);
        }
        return 0;
    }

    public int getInboundMessageCount(String gatewayId) {
        return this.getInboundMessageCount(this.findGateway(gatewayId));
    }

    public int getInboundMessageCount(AGateway gateway) {
        return gateway != null ? gateway.getInboundMessageCount() : -1;
    }

    public int getOutboundMessageCount(String gatewayId) {
        return this.getOutboundMessageCount(this.findGateway(gatewayId));
    }

    public int getOutboundMessageCount(AGateway gateway) {
        return gateway != null ? gateway.getOutboundMessageCount() : -1;
    }

    public int getInboundMessageCount() {
        int total = 0;
        for (AGateway gateway : this.getGateways()) {
            total += gateway.getInboundMessageCount();
        }
        Iterator<AGateway> iter = null;
        return total;
    }

    public int getOutboundMessageCount() {
        int total = 0;
        for (AGateway gateway : this.getGateways()) {
            total += gateway.getOutboundMessageCount();
        }
        Iterator<AGateway> iter = null;
        return total;
    }

    public AGateway findGateway(String gatewayId) {
        Iterator<AGateway> iter = this.getGateways().iterator();
        while (iter.hasNext()) {
            AGateway gateway = iter.next();
            if (!gateway.getGatewayId().equals(gatewayId)) continue;
            iter = null;
            return gateway;
        }
        iter = null;
        return null;
    }

    public Collection<AGateway> getGateways() {
        return this.a;
    }

    public AGateway[] getGatewaysNET() {
        return this.getGateways().toArray(new AGateway[0]);
    }

    public LoadBalancer getLoadBalancer() {
        return this.c;
    }

    public void setLoadBalancer(LoadBalancer loadBalancer) {
        this.c = loadBalancer;
    }

    public Router getRouter() {
        return this.b;
    }

    public void setRouter(Router router) {
        this.b = router;
    }

    public synchronized AGateway routeMessage(OutboundMessage msg) {
        Collection<AGateway> gateways = this.getRouter().route(msg, this.getGateways());
        if (gateways.size() > 0) {
            return this.getLoadBalancer().balance(msg, gateways);
        }
        msg.setMessageStatus(OutboundMessage.MessageStatuses.FAILED);
        msg.setFailureCause(OutboundMessage.FailureCauses.NO_ROUTE);
        return null;
    }

    public IInboundMessageNotification getInboundMessageNotification() {
        return this.e;
    }

    public void setInboundMessageNotification(IInboundMessageNotification inboundNotification) {
        this.e = inboundNotification;
    }

    public IOutboundMessageNotification getOutboundMessageNotification() {
        return this.f;
    }

    public void setOutboundMessageNotification(IOutboundMessageNotification outboundNotification) {
        this.f = outboundNotification;
    }

    public ICallNotification getCallNotification() {
        return this.g;
    }

    public void setCallNotification(ICallNotification callNotification) {
        this.g = callNotification;
    }

    public IUSSDNotification getUSSDNotification() {
        return this.n;
    }

    public void setUSSDNotification(IUSSDNotification ussdNotification) {
        this.n = ussdNotification;
    }

    public IGatewayStatusNotification getGatewayStatusNotification() {
        return this.h;
    }

    public void setGatewayStatusNotification(IGatewayStatusNotification gatewayStatusNotification) {
        this.h = gatewayStatusNotification;
    }

    public IQueueSendingNotification getQueueSendingNotification() {
        return this.i;
    }

    public void setQueueSendingNotification(IQueueSendingNotification queueSendingNotification) {
        this.i = queueSendingNotification;
    }

    public IOrphanedMessageNotification getOrphanedMessageNotification() {
        return this.j;
    }

    public void setOrphanedMessageNotification(IOrphanedMessageNotification orphanedMessageNotification) {
        this.j = orphanedMessageNotification;
    }

    public long getStartMillis() {
        return this.k;
    }

    void a(Settings settings) {
        this.S = settings;
    }

    public ServiceStatus getServiceStatus() {
        return this.serviceStatus;
    }

    void a(ServiceStatus myServiceStatus) {
        this.serviceStatus = myServiceStatus;
    }

    public Settings getSettings() {
        return this.S;
    }

    public boolean createGroup(String groupName) {
        this.l.add(new Group(groupName));
        return true;
    }

    public boolean removeGroup(String groupName) {
        Iterator<Group> iter = this.l.iterator();
        while (iter.hasNext()) {
            Group a2 = iter.next();
            if (!a2.getName().equalsIgnoreCase(groupName)) continue;
            a2.clear();
            this.l.remove(a2);
            iter = null;
            return true;
        }
        iter = null;
        return false;
    }

    public ArrayList<String> expandGroup(String groupName) {
        Iterator<Group> iter = this.l.iterator();
        while (iter.hasNext()) {
            Group a2 = iter.next();
            if (!a2.getName().equalsIgnoreCase(groupName)) continue;
            iter = null;
            return new ArrayList<String>(a2.getNumbers());
        }
        iter = null;
        return new ArrayList<String>();
    }

    public boolean addToGroup(String groupName, String number) {
        Iterator<Group> iter = this.l.iterator();
        while (iter.hasNext()) {
            Group a2 = iter.next();
            if (!a2.getName().equalsIgnoreCase(groupName)) continue;
            a2.addNumber(number);
            iter = null;
            return true;
        }
        iter = null;
        return false;
    }

    public boolean removeFromGroup(String groupName, String number) {
        Iterator<Group> iter = this.l.iterator();
        while (iter.hasNext()) {
            Group a2 = iter.next();
            if (!a2.getName().equalsIgnoreCase(groupName)) continue;
            iter = null;
            return a2.removeNumber(number);
        }
        iter = null;
        return false;
    }

    public boolean checkInGroup(String groupName, String number) {
        Iterator<Group> iter = this.l.iterator();
        while (iter.hasNext()) {
            Group a2 = iter.next();
            if (!a2.getName().equalsIgnoreCase(groupName)) continue;
            Collection<String> numbers = a2.getNumbers();
            iter = null;
            return numbers.contains(number);
        }
        iter = null;
        return false;
    }

    public boolean setQueueManager(AbstractQueueManager myQueueManager) {
        if (this.getServiceStatus() != ServiceStatus.STOPPED) {
            return false;
        }
        this.queueManager = myQueueManager;
        return true;
    }

    public AbstractQueueManager getQueueManager() {
        return this.queueManager;
    }

    void a(NotifyQueueManager myNotifyQueueManager) {
        this.notifyQueueManager = myNotifyQueueManager;
    }

    public NotifyQueueManager getNotifyQueueManager() {
        return this.notifyQueueManager;
    }

    public KeyManager getKeyManager() {
        return this.m;
    }

    c a() {
        return this.d;
    }

    void a(c myWatchDog) {
        this.d = myWatchDog;
    }

    public static void main(String[] args) {
        System.out.println(Library.getLibraryDescription());
        System.out.println("\nSendSMS API Version: " + Library.getLibraryVersion());
    }

    private class c
    extends AServiceThread {
        public c(String name, int delay) {
            super(name, delay, 0, true);
        }

        @Override
        public void process() throws Exception {
            if (Service.this.getServiceStatus() != ServiceStatus.STARTED) {
                return;
            }
            for (AGateway gateway : Service.this.getGateways()) {
                if (gateway.getStatus() != AGatewayHelper.GatewayStatuses.RESTART) continue;
                Logger.getInstance().logWarn("Gateway: " + gateway.getGatewayId() + " restarting.", null, null);
                try {
                    gateway.stopGateway();
                    gateway.setStatus(AGatewayHelper.GatewayStatuses.RESTART);
                }
                catch (Exception e2) {
                    gateway.setStatus(AGatewayHelper.GatewayStatuses.RESTART);
                    Logger.getInstance().logWarn("Error while shutting down Gateway: " + gateway.getGatewayId(), e2, null);
                }
                try {
                    gateway.startGateway();
                }
                catch (Exception e3) {
                    if (e3 instanceof GatewayException) {
                        gateway.setStatus(AGatewayHelper.GatewayStatuses.FAILURE);
                    } else {
                        gateway.setStatus(AGatewayHelper.GatewayStatuses.STOPPED);
                    }
                    Logger.getInstance().logError("Error while starting Gateway: " + gateway.getGatewayId(), e3, null);
                }
            }
            Iterator<AGateway> iter = null;
        }
    }

    public static enum ServiceStatus {
        STARTING,
        STARTED,
        STOPPING,
        STOPPED;

    }
}

