/*
 * Decompiled with CFR 0.152.
 */
package cn.sendsms.crypto;

import cn.sendsms.SendSMSException;
import cn.sendsms.crypto.AKey;
import cn.sendsms.crypto.ASymmetricKey;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

public class KeyManager {
    private static KeyManager _instance = null;
    HashMap<String, AKey> a = new HashMap();

    private KeyManager() {
    }

    public static KeyManager getInstance() {
        if (_instance == null) {
            _instance = new KeyManager();
        }
        return _instance;
    }

    public void registerKey(String mobileNumber, AKey key) {
        this.a.put(mobileNumber.charAt(0) == '+' ? mobileNumber.substring(1) : mobileNumber, key);
    }

    public AKey unregisterKey(String mobileNumber) {
        return this.a.remove(mobileNumber.charAt(0) == '+' ? mobileNumber.substring(1) : mobileNumber);
    }

    public void unregisterAllKeys() {
        this.a.clear();
    }

    public AKey getKey(String mobileNumber) {
        if (mobileNumber == null) {
            return null;
        }
        return this.a.get(mobileNumber.charAt(0) == '+' ? mobileNumber.substring(1) : mobileNumber);
    }

    public byte[] encrypt(String mobileNumber, byte[] message) throws SendSMSException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException, NoSuchPaddingException, NoSuchAlgorithmException {
        AKey k2 = this.getKey(mobileNumber);
        if (k2 == null) {
            throw new SendSMSException("Could not find Encryption Key for the specific number.");
        }
        if (k2 instanceof ASymmetricKey) {
            return ((ASymmetricKey)k2).encrypt(message);
        }
        return new byte[0];
    }

    public byte[] decrypt(String mobileNumber, byte[] message) throws SendSMSException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException, NoSuchPaddingException, NoSuchAlgorithmException {
        AKey k2 = this.getKey(mobileNumber);
        if (k2 == null) {
            throw new SendSMSException("Could not find Encryption Key for the specific number.");
        }
        if (k2 instanceof ASymmetricKey) {
            return ((ASymmetricKey)k2).decrypt(message);
        }
        return new byte[0];
    }
}

