/*
 * Decompiled with CFR 0.152.
 */
package cn.sendsms.jdsmsserver.web;

import cn.sendsms.helper.AGatewayHelper;
import cn.sendsms.helper.Logger;
import cn.sendsms.jdsmsserver.web.GetSerialPortInfo;
import cn.sendsms.modem.SerialModemDriver;
import cn.sendsms.modem.SerialModemGateway;
import cn.sendsms.modem.athandler.ATHandler_Test;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Properties;
import java.util.Random;
import jssc.SerialPortException;

public class GetSerialPortInfoByGateway
extends GetSerialPortInfo {
    private SerialModemGateway gateway;

    public GetSerialPortInfoByGateway(Properties options) {
        super(options);
    }

    @Override
    protected void open() throws Exception {
        super.open();
    }

    @Override
    protected void init(int botelv) throws Exception {
        super.init(botelv);
        super.testOK();
        this.gateway = new SerialModemGateway("jdsms", this.options.getProperty("portname"), botelv, "Test", null);
    }

    @Override
    protected void testOK() throws Exception {
    }

    @Override
    protected String athandle(String cmd) throws Exception {
        int retryCount;
        String response = null;
        this.serialPort.writeBytes(cmd.getBytes());
        if (cmd.indexOf("AT^CPBR") != -1) {
            Thread.sleep(1000L);
        }
        Thread.sleep(200L);
        response = "";
        for (retryCount = 0; this.serialPort.getInputBufferBytesCount() <= 0 && retryCount < 3; ++retryCount) {
            Thread.sleep(2000L);
        }
        if (retryCount >= 3) {
            Logger.getInstance().logError("\u8d85\u8fc76s\u53d1\u9001" + cmd + "\u6307\u4ee4\u6ca1\u6709\u5f97\u5230\u8fd4\u56de\u6570\u636e", null, null);
            return "";
        }
        response = this.serialPort.readString();
        Logger.getInstance().logDebug("at\u6307\u4ee4" + cmd + "\u8fd4\u56de" + response, null, null);
        response = response.replace(cmd, "").replaceAll("\\s+OK\\s+", "").replaceAll("\\s+", "");
        return response;
    }

    @Override
    protected void close() {
        if (this.gateway != null) {
            try {
                this.gateway.stopGateway();
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
            finally {
                SerialModemDriver driver = (SerialModemDriver)this.gateway.getDriver();
                if (driver.getSerialPort() != null && driver.getSerialPort().isOpened()) {
                    try {
                        driver.getSerialPort().closePort();
                    }
                    catch (SerialPortException e3) {
                        e3.printStackTrace();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handler() {
        try {
            long begin = System.currentTimeMillis();
            this.open();
            Logger.getInstance().logInfo("\u6253\u5f00\u7aef\u53e3\u8017\u65f6" + (System.currentTimeMillis() - begin) + "\u6beb\u79d2", null, null);
        }
        catch (Exception e1) {
            if (e1.getMessage().indexOf("Port busy.") != -1) {
                this.serialmodem.setStatus(AGatewayHelper.GatewayStatuses.OCCUPY);
            } else if (e1.getMessage().indexOf("Port not found.") != -1) {
                this.serialmodem.setStatus(AGatewayHelper.GatewayStatuses.NOPORT);
            }
            this.serialmodem.setBaudrate(botelvs[botelvs.length - 1]);
            return;
        }
        try {
            for (int i2 = 0; i2 < botelvs.length; ++i2) {
                int botelv;
                block66: {
                    botelv = Integer.parseInt(this.options.getProperty("baudrate", "0"));
                    try {
                        String result;
                        if (botelv == 0) {
                            this.init(botelvs[i2]);
                        } else {
                            this.init(botelv);
                        }
                        this.serialmodem.setStatus(AGatewayHelper.GatewayStatuses.STOPPED);
                        this.testOK();
                        this.getSignal();
                        this.getManufacturer();
                        if (this.serialmodem.getManufacturer().equalsIgnoreCase("Siemens")) {
                            this.getModel2();
                            this.getCardNumber1();
                            this.getSerialNumber1();
                        } else if (this.serialmodem.getManufacturer().equalsIgnoreCase("huawei")) {
                            this.getModel2();
                            if (this.serialmodem.getModel().equalsIgnoreCase("MC323")) {
                                this.serialmodem.setProtocol(AGatewayHelper.Protocols.TEXT);
                                ((ATHandler_Test)this.gateway.getATHandler()).settest(true);
                                this.b();
                            }
                            if (this.serialmodem.getModel().equalsIgnoreCase("MG301")) {
                                result = null;
                                result = this.athandle("AT+CGSN\r");
                                this.serialmodem.setSerialnum(result);
                            }
                            if (this.serialmodem.getModel().equalsIgnoreCase("ME909") || this.serialmodem.getModel().equalsIgnoreCase("MH5000-31") || this.serialmodem.getModel().equalsIgnoreCase("MH5000-82M")) {
                                result = null;
                                result = this.athandle("AT+CGSN\r");
                                if (this.serialmodem.getModel().equalsIgnoreCase("MH5000-31")) {
                                    result = this.a(result);
                                }
                                this.serialmodem.setSerialnum(result);
                                if (this.serialmodem.getModel().equalsIgnoreCase("MH5000-31")) {
                                    this.getCardNumber3();
                                } else {
                                    this.getCardNumber2();
                                }
                            } else {
                                this.getCardNumber();
                            }
                        } else if (this.serialmodem.getManufacturer().equalsIgnoreCase("WAVECOM")) {
                            this.getModel1();
                            if (this.serialmodem.getModel().equalsIgnoreCase("WISMOQCDMA")) {
                                if (this.getVersion().indexOf("WQ2") != -1) {
                                    this.a();
                                } else {
                                    this.getSerialNumber();
                                }
                                this.serialmodem.setProtocol(AGatewayHelper.Protocols.TEXT);
                                ((ATHandler_Test)this.gateway.getATHandler()).settest(true);
                            } else if (this.getVersion().indexOf("Q2406B") != -1) {
                                this.getSerialNumber1();
                            } else {
                                this.getSerialNumber();
                            }
                            this.getCardNumber();
                        } else if (this.serialmodem.getManufacturer().equalsIgnoreCase("Quectel_Ltd")) {
                            this.getModel();
                            if (this.serialmodem.getModel().equalsIgnoreCase("Quectel_M35") || this.serialmodem.getModel().equalsIgnoreCase("Quectel_M26")) {
                                result = null;
                                result = this.athandle("AT+CGSN\r");
                                this.serialmodem.setSerialnum(result);
                            }
                            this.getCardNumber();
                        } else if (this.serialmodem.getManufacturer().equalsIgnoreCase("Quectel")) {
                            this.getModel();
                            if (this.serialmodem.getModel().equalsIgnoreCase("EC20F")) {
                                result = null;
                                result = this.athandle("AT+CGSN\r");
                                this.serialmodem.setSerialnum(result);
                            }
                            this.getCardNumber();
                        } else if (this.serialmodem.getManufacturer().equalsIgnoreCase("Yuga")) {
                            this.getModel();
                            result = this.athandle("AT+CGSN\r");
                            this.serialmodem.setSerialnum(result);
                            if (this.serialmodem.getModel().equalsIgnoreCase("CLM920_RC3")) {
                                this.getCardNumber4();
                            } else if (this.serialmodem.getModel().equalsIgnoreCase("CLM920_RV3")) {
                                this.getCardNumber4();
                            } else if (this.serialmodem.getModel().equalsIgnoreCase("CLM920_NC5")) {
                                this.getCardNumber();
                            } else {
                                this.getModel();
                                this.getCardNumber();
                            }
                        } else if (this.serialmodem.getManufacturer().equalsIgnoreCase("INCORPORATED")) {
                            this.getModel();
                            if (this.serialmodem.getModel().equalsIgnoreCase("A7600C1_SE")) {
                                result = null;
                                result = this.athandle("AT+CGSN\r");
                                this.serialmodem.setSerialnum(result);
                                this.getCardNumberForINCORPORATED();
                            } else if (this.serialmodem.getModel().equalsIgnoreCase("7600CE_L") || this.serialmodem.getModel().equalsIgnoreCase("7600CE_JT1S") || this.serialmodem.getModel().equalsIgnoreCase("7600CE_T")) {
                                result = null;
                                result = this.athandle("AT+CGSN\r");
                                this.serialmodem.setSerialnum(result);
                                this.getCardNumberForINCORPORATED();
                            }
                        } else if (this.serialmodem.getManufacturer().equalsIgnoreCase("TDTech")) {
                            this.getModel();
                            if (this.serialmodem.getModel().equalsIgnoreCase("ME909")) {
                                result = null;
                                result = this.athandle("AT+CGSN\r");
                                this.serialmodem.setSerialnum(result);
                                this.getCardNumber2();
                            } else if (this.serialmodem.getModel().equalsIgnoreCase("MH5000-82M")) {
                                result = null;
                                result = this.athandle("AT+CGSN\r");
                                this.serialmodem.setSerialnum(result);
                                this.getCardNumber2();
                            } else if (this.serialmodem.getModel().equalsIgnoreCase("ME901")) {
                                result = null;
                                result = this.athandle("AT+CGSN\r");
                                this.serialmodem.setSerialnum(result);
                                this.getCardNumber();
                            }
                        } else if (this.serialmodem.getManufacturer().equalsIgnoreCase("MEIG")) {
                            this.getModel();
                            result = this.athandle("AT+CGSN\r");
                            this.serialmodem.setSerialnum(result);
                            if (this.serialmodem.getModel().equalsIgnoreCase("SLM750_V")) {
                                this.getCardNumber4();
                            }
                        }
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                        if (this.serialmodem.getAtFlag().equals("OK")) break block66;
                        this.serialmodem.setStatus(AGatewayHelper.GatewayStatuses.FAILURE);
                    }
                }
                if (this.serialmodem.getStatus() == AGatewayHelper.GatewayStatuses.FAILURE) {
                    if (botelv == 0) continue;
                }
                break;
            }
        }
        finally {
            if (this.serialPort != null && this.serialPort.isOpened()) {
                try {
                    this.serialPort.closePort();
                }
                catch (SerialPortException e3) {
                    Logger.getInstance().logError("\u68c0\u6d4b\u7aef\u53e3" + this.serialmodem.getPort() + "\u65f6\u5173\u95ed\u7aef\u53e3\u51fa\u73b0\u9519\u8bef", (Exception)((Object)e3), this.serialmodem.getGatewayID());
                }
            }
        }
    }

    private String a(String result) {
        BufferedReader reader;
        StringReader stringReader;
        block5: {
            String line;
            stringReader = new StringReader(result);
            reader = new BufferedReader(stringReader);
            do {
                line = null;
                try {
                    line = reader.readLine();
                }
                catch (IOException e2) {
                    Logger.getInstance().logError(result + "\u89e3\u6790\u5f02\u5e38!", null, null);
                }
                if (line == null) break block5;
            } while (!line.matches("[0-9]{15}"));
            return line;
        }
        try {
            reader.close();
            stringReader.close();
        }
        catch (IOException e3) {
            Logger.getInstance().logError("\u6570\u636e\u6d41\u5173\u95ed\u5f02\u5e38!", null, null);
        }
        return "";
    }

    private void a() throws Exception {
        if (this.options.getProperty("serialnumber") != null) {
            return;
        }
        String result = null;
        result = this.athandle("AT+WAIP=0\r");
        result = this.athandle("AT+CPBS=\"ME\"\r");
        result = this.athandle("AT+CPBR=1\r");
        String key = result.substring(result.lastIndexOf(44) + 1);
        System.out.println("key:" + key);
        if ((result.equals("") || !key.equals("\"WMSN\"")) && result.indexOf("ERROR") == -1) {
            String wmsn = GetSerialPortInfoByGateway.getWMSN();
            this.athandle("AT+CPBW=1,\"" + wmsn + "\",129,\"WMSN\"\r");
            result = this.athandle("AT+CPBR=1\r");
        }
        result = result.substring(result.indexOf(58) + 1);
        key = result.substring(result.lastIndexOf(44) + 1);
        if (result.indexOf("ERROR") != -1) {
            return;
        }
        if (result.trim().equals("")) {
            return;
        }
        if (!key.equals("\"WMSN\"")) {
            return;
        }
        String str = result.split(",")[1];
        this.serialmodem.setSerialnum(str.substring(1, str.length() - 1));
    }

    private void b() throws Exception {
        String wmsn;
        if (this.options.getProperty("serialnumber") != null) {
            return;
        }
        String result = null;
        result = this.athandle("AT+CPBS=\"ME\"\r");
        result = this.athandle("AT^CPBR=1\r");
        String key = "";
        if (result.indexOf("ERROR") != -1) {
            wmsn = GetSerialPortInfoByGateway.getWMSN();
            this.athandle("AT^CPBW=1,\"" + wmsn + "\",129,\"WMSN\"\r");
            result = this.athandle("AT^CPBR=1\r");
        } else {
            key = result.substring(result.lastIndexOf(44, result.length() - 3) + 1, result.lastIndexOf(","));
            if ((result.equals("") || !key.equals("\"WMSN\"")) && result.indexOf("ERROR") == -1) {
                wmsn = GetSerialPortInfoByGateway.getWMSN();
                this.athandle("AT^CPBW=1,\"" + wmsn + "\",129,\"WMSN\"\r");
                result = this.athandle("AT^CPBR=1\r");
            }
        }
        result = result.substring(result.indexOf(58) + 1);
        key = result.substring(result.lastIndexOf(44, result.length() - 3) + 1, result.lastIndexOf(","));
        if (result.indexOf("ERROR") != -1) {
            return;
        }
        if (result.trim().equals("")) {
            return;
        }
        if (!key.equals("\"WMSN\"")) {
            return;
        }
        String str = result.split(",")[1];
        this.serialmodem.setSerialnum(str.substring(1, str.length() - 1));
    }

    private static String getWMSN() {
        char[] nums = new char[]{'1', '2', '3', '4', '5', '6', '7', '8', '9', '0'};
        Random rand = new Random();
        String wmsn = "";
        for (int i2 = 0; i2 < 17; ++i2) {
            wmsn = wmsn + nums[rand.nextInt(10)];
        }
        return wmsn;
    }

    public static void main(String[] args) {
    }
}

