/*
 * Decompiled with CFR 0.152.
 */
package cn.sendsms.modem;

import cn.sendsms.AGateway;
import cn.sendsms.AtTimeoutException;
import cn.sendsms.GatewayException;
import cn.sendsms.InboundMessage;
import cn.sendsms.InvalidMessageException;
import cn.sendsms.Service;
import cn.sendsms.TimeoutException;
import cn.sendsms.USSDResponse;
import cn.sendsms.helper.AGatewayHelper;
import cn.sendsms.helper.Logger;
import cn.sendsms.jdsmsserver.JDSMSServer;
import cn.sendsms.jdsmsserver.web.DeviceInfoCache;
import cn.sendsms.jdsmsserver.web.SerialModemBean;
import cn.sendsms.modem.ModemGateway;
import cn.sendsms.notify.CallNotification;
import cn.sendsms.notify.InboundMessageNotification;
import cn.sendsms.threading.AServiceThread;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public abstract class AModemDriver {
    private static final String rxErrorWithCode = "[>]*\\s*[\\p{ASCII}]*\\s*[\\r]*\\+(CM[ES])\\s+ERROR: (\\d+)\\s";
    private static final String rxPlainError = "\\s*[\\p{ASCII}]*\\s*(ERROR|NO CARRIER|NO DIALTONE)\\s";
    private Object a;
    private Object b;
    private Object c;
    private ModemGateway d;
    private boolean e;
    private volatile boolean occurTimeoutError = false;
    private volatile boolean isOccurFull = false;
    private volatile boolean connected;
    private d f;
    private f g;
    private e h;
    private b i;
    private a j;
    private int k;
    static int OK = 0;

    public boolean isOccurFull() {
        return this.isOccurFull;
    }

    public void setOccurFull(boolean isOccurFull) {
        this.isOccurFull = isOccurFull;
    }

    public boolean isOccurTimeoutError() {
        return this.occurTimeoutError;
    }

    public void setOccurTimeoutError(boolean occurTimeoutError) {
        this.occurTimeoutError = occurTimeoutError;
    }

    protected AModemDriver(ModemGateway myGateway, String deviceParms) {
        this.setSYNCReader(new Object());
        this.setSYNCCommander(new Object());
        this.setSYNCInboundReader(new Object());
        this.setGateway(myGateway);
        this.setConnected(false);
        this.setDataReceived(false);
        this.setCharQueue(new d());
    }

    protected abstract void connectPort() throws GatewayException, IOException, InterruptedException;

    protected abstract void disconnectPort() throws IOException, InterruptedException;

    protected abstract void clear() throws IOException;

    private void a(SerialModemBean serialModemBean, String response) {
        String[] result = null;
        result = response.replaceAll("\\s+\\s+", " ").replaceAll("\n", " ").replaceAll("\r", " ").split(" ");
        if (result[result.length - 1].indexOf("OK") == -1 && result[result.length - 1].indexOf("ERROR") == -1) {
            serialModemBean.setAtFlag("\u4e0dAT");
        } else {
            serialModemBean.setAtFlag(result[result.length - 1]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected void connect() throws TimeoutException, GatewayException, IOException, InterruptedException {
        response = "";
        var2_2 = this.getSYNCCommander();
        synchronized (var2_2) {
            try {
                if (!this.isConnected()) {
                    this.connectPort();
                }
                this.setKeepAlive(new e("KeepAlive [" + this.getGateway().getGatewayId() + "]", Service.getInstance().getSettings().SERIAL_KEEPALIVE_INTERVAL * 1000));
                this.setModemReader(new f());
                this.setAsyncNotifier(new b());
                for (i = 0; i < 3; ++i) {
                    try {
                        this.getGateway().getATHandler().reset();
                        response = this.getGateway().sendCustomATCommand("AT\r");
                        break;
                    }
                    catch (TimeoutException e) {
                        Logger.getInstance().logDebug("\u7b2c" + (i + 1) + "\u6b21AT\u65e0\u54cd\u5e94", null, this.getGateway().getGatewayId());
                        if (i != 2) continue;
                        throw e;
                    }
                }
                if (response.indexOf("ERROR") != -1) {
                    this.getGateway().getATHandler().reset();
                }
                this.getGateway().getATHandler().sync();
                this.getGateway().getATHandler().echoOff();
                this.getGateway().getATHandler().modifyMMSRemindWay();
                if (this.getGateway().getCustomInitString() != null && this.getGateway().getCustomInitString().length() > 0) {
                    this.write(this.getGateway().getCustomInitString() + "\r");
                    this.getGateway().getATHandler().echoOff();
                }
                bean = DeviceInfoCache.getInstance().get(this.getGateway().getGatewayId());
                response = this.getGateway().sendCustomATCommand("AT\r");
                if (response.indexOf("ERROR") != -1) {
                    this.getGateway().getATHandler().reset();
                    response = this.getGateway().sendCustomATCommand("AT\r");
                }
                this.a(bean, response);
                response = this.getGateway().getAtHandler().getCSQ();
                response = StringUtils.remove((String)response, (char)' ');
                bean.setCsq(StringUtils.substringBetween((String)response, (String)":", (String)"\r"));
                if (bean.getCsq() == null) {
                    bean.setCsq("-------");
                }
                this.getGateway().judgeAuthorize();
                if (this.getGateway().getATHandler().getCCID().indexOf("CCID") == -1) {
                    this.threadWait(10000L);
                    if (this.getGateway().getATHandler().getCCID().indexOf("CCID") == -1) {
                        Logger.getInstance().logError("ccid\u8fd4\u56de" + this.getGateway().getATHandler().getCCID(), null, null);
                        throw new GatewayException("\u8bbe\u5907\u672a\u63d2\u5361");
                    }
                }
                response = bean.getManufacturer().equals("Siemens") != false ? this.getGateway().getATHandler().getCXXCID() : this.getGateway().getAtHandler().getCCID();
                Logger.getInstance().logInfo("SendCCid..." + response, null, this.getGateway().getGatewayId());
                response = StringUtils.remove((String)response, (char)' ');
                bean.setCcid(StringUtils.substringBetween((String)response, (String)":", (String)"\r"));
                if (bean.getCcid() == null) {
                    bean.setCcid("-------");
                }
                do lbl-1000:
                // 4 sources

                {
                    block47: {
                        block46: {
                            response = this.getGateway().getATHandler().getSimStatus();
                            while (response.indexOf("BUSY") >= 0) {
                                Logger.getInstance().logDebug("SIM found busy, waiting...", null, this.getGateway().getGatewayId());
                                if (!this.threadWait(Service.getInstance().getSettings().AT_WAIT_SIMPIN)) break;
                                response = this.getGateway().getATHandler().getSimStatus();
                            }
                            if (response.indexOf("SIM PIN2") < 0) break block46;
                            Logger.getInstance().logDebug("SIM requesting PIN2.", null, this.getGateway().getGatewayId());
                            if (this.getGateway().getSimPin2() == null || this.getGateway().getSimPin2().length() == 0) {
                                throw new GatewayException("The GSM modem requires SIM PIN2 to operate.");
                            }
                            if (!this.getGateway().getATHandler().enterPin(this.getGateway().getSimPin2())) {
                                throw new GatewayException("SIM PIN2 provided is not accepted by the GSM modem.");
                            }
                            if (this.threadWait(Service.getInstance().getSettings().AT_WAIT_SIMPIN)) ** GOTO lbl-1000
                            break;
                        }
                        if (response.indexOf("SIM PIN") < 0) break block47;
                        Logger.getInstance().logDebug("SIM requesting PIN.", null, this.getGateway().getGatewayId());
                        if (this.getGateway().getSimPin() == null || this.getGateway().getSimPin().length() == 0) {
                            throw new GatewayException("The GSM modem requires SIM PIN to operate.");
                        }
                        if (!this.getGateway().getATHandler().enterPin(this.getGateway().getSimPin())) {
                            throw new GatewayException("SIM PIN provided is not accepted by the GSM modem.");
                        }
                        if (this.threadWait(Service.getInstance().getSettings().AT_WAIT_SIMPIN)) ** GOTO lbl-1000
                        break;
                    }
                    if (response.indexOf("READY") >= 0 || response.indexOf("OK") >= 0) break;
                    if (response.indexOf("ERROR") >= 0) {
                        Logger.getInstance().logWarn("Erroneous CPIN response, proceeding with defaults.", null, this.getGateway().getGatewayId());
                        break;
                    }
                    Logger.getInstance().logWarn("Cannot understand SIMPIN response: " + response + ", will wait for a while...", null, this.getGateway().getGatewayId());
                } while (this.threadWait(Service.getInstance().getSettings().AT_WAIT_SIMPIN));
                this.getGateway().getATHandler().echoOff();
                this.getGateway().getATHandler().setVerboseErrors();
                this.getGateway().getATHandler().init();
                this.getGateway().getATHandler().checkMode();
                if (!this.waitForNetworkRegistration()) {
                    Logger.getInstance().logWarn("Network Registration failed, proceeding with defaults.", null, this.getGateway().getGatewayId());
                }
                if (this.getGateway().getATHandler().getStorageLocations().length() == 0) {
                    try {
                        this.getGateway().getATHandler().readStorageLocations();
                        Logger.getInstance().logInfo("MEM: Storage Locations Found: " + this.getGateway().getATHandler().getStorageLocations(), null, this.getGateway().getGatewayId());
                    }
                    catch (Exception e) {
                        this.getGateway().getATHandler().setStorageLocations("--");
                        Logger.getInstance().logWarn("Storage locations could *not* be retrieved, will proceed with defaults.", e, this.getGateway().getGatewayId());
                    }
                }
                if (this.getGateway().getProtocol() == AGatewayHelper.Protocols.PDU) {
                    if (!this.getGateway().getATHandler().setPduProtocol()) {
                        throw new GatewayException("The GSM modem does not support the PDU protocol.");
                    }
                } else if (this.getGateway().getProtocol() == AGatewayHelper.Protocols.TEXT && !this.getGateway().getATHandler().setTextProtocol()) {
                    throw new GatewayException("The GSM modem does not support the TEXT protocol.");
                }
            }
            catch (AtTimeoutException t) {
                try {
                    Logger.getInstance().logError("\u7aef\u53e3\u542f\u52a8\u65f6\u51fa\u73b0\u8d85\u65f6\u5f02\u5e38", t, this.getGateway().getGatewayId());
                    this.disconnect();
                }
                catch (Exception var4_11) {
                    // empty catch block
                }
                throw t;
            }
            catch (TimeoutException t) {
                try {
                    Logger.getInstance().logError("\u7aef\u53e3\u542f\u52a8\u65f6\u51fa\u73b0\u8d85\u65f6\u5f02\u5e38", t, this.getGateway().getGatewayId());
                    this.disconnect();
                }
                catch (Exception var4_12) {
                    // empty catch block
                }
                throw t;
            }
            catch (GatewayException t) {
                try {
                    Logger.getInstance().logError("\u7aef\u53e3\u542f\u52a8\u65f6\u51fa\u73b0\u5f02\u5e38", t, this.getGateway().getGatewayId());
                    this.disconnect();
                    if (t.getMessage().indexOf("\u8bbe\u5907\u672a\u63d2\u5361") != -1) {
                        this.getGateway().setStatus(AGatewayHelper.GatewayStatuses.RESTART);
                    }
                }
                catch (Exception var4_13) {
                    // empty catch block
                }
                throw t;
            }
            catch (IOException t) {
                try {
                    Logger.getInstance().logError("\u7aef\u53e3\u542f\u52a8\u65f6\u51fa\u73b0IO\u5f02\u5e38", t, this.getGateway().getGatewayId());
                    this.disconnect();
                }
                catch (Exception var4_14) {
                    // empty catch block
                }
                throw t;
            }
            catch (InterruptedException t) {
                try {
                    Logger.getInstance().logError("\u7aef\u53e3\u542f\u52a8\u65f6\u51fa\u73b0\u4e2d\u65ad", t, this.getGateway().getGatewayId());
                    this.disconnect();
                }
                catch (Exception var4_15) {
                    // empty catch block
                }
                throw t;
            }
        }
    }

    public void testconnect() throws GatewayException, IOException, InterruptedException, TimeoutException {
        this.connectPort();
        this.write("ATE0\r".getBytes());
        if (!this.threadWait(120L)) {
            // empty if block
        }
        this.clear();
        this.getCharQueue().c();
        this.setModemReader(new f());
    }

    protected void disconnect() throws IOException, InterruptedException {
        Logger.getInstance().logInfo("thread work disconnect()", null, this.getGateway().getGatewayId());
        this.setConnected(false);
        if (this.getKeepAlive() != null) {
            this.getKeepAlive().cancel();
            this.setKeepAlive(null);
        }
        if (this.getAsyncNotifier() != null) {
            this.getAsyncNotifier().interrupt();
            this.getAsyncNotifier().join();
            this.setAsyncNotifier(null);
        }
        if (this.getAsyncMessageProcessor() != null) {
            this.getAsyncMessageProcessor().interrupt();
            this.getAsyncMessageProcessor().join();
            this.setAsyncMessageProcessor(null);
        }
        if (this.getModemReader() != null) {
            this.getModemReader().interrupt();
            this.getModemReader().join();
            this.setModemReader(null);
        }
        this.disconnectPort();
    }

    public abstract void write(char var1) throws IOException;

    public abstract void write(byte[] var1) throws IOException;

    public abstract void writeSring(String var1) throws IOException;

    protected abstract byte[] read() throws IOException;

    protected abstract boolean portHasData() throws IOException;

    public boolean dataAvailable() throws InterruptedException {
        return this.getCharQueue().b() != -1;
    }

    public void write(String s) throws IOException, InterruptedException {
        this.noLockClearBufferNew();
        try {
            Logger.getInstance().logDebug("SEND :" + this.formatLog(s), null, this.getGateway().getGatewayId());
            this.writeSring(s);
        }
        catch (IOException e2) {
            Logger.getInstance().logWarn("thread work write error", e2, this.getGateway().getGatewayId());
            this.d.setStatus(AGatewayHelper.GatewayStatuses.RESTART);
            throw e2;
        }
    }

    public void writeNoClear(String s) throws IOException, InterruptedException {
        try {
            Logger.getInstance().logDebug("SEND :" + this.formatLog(s), null, this.getGateway().getGatewayId());
            this.writeSring(s);
        }
        catch (IOException e2) {
            Logger.getInstance().logWarn("thread work write error", e2, this.getGateway().getGatewayId());
            this.d.setStatus(AGatewayHelper.GatewayStatuses.RESTART);
            throw e2;
        }
    }

    public void addToQueue(String s) {
        for (int i2 = 0; i2 < s.length(); ++i2) {
            this.getCharQueue().a((byte)s.charAt(i2));
        }
    }

    public String getResponse() throws GatewayException, TimeoutException, IOException, InterruptedException {
        byte[] ret = this.getResponse(AGateway.AsyncEvents.NOTHING);
        if (ret == null) {
            return "";
        }
        return new String(ret);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte[] getResponseByteArray() throws GatewayException, TimeoutException, IOException, InterruptedException {
        String response = "";
        AGateway.AsyncEvents eventResponse = AGateway.AsyncEvents.NOTHING;
        this.a(-1);
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(Service.getInstance().getSettings().SERIAL_BUFFER_SIZE);
        try {
            byte[] tmp;
            while (true) {
                if (this.getCharQueue().b() == 10 || this.getCharQueue().b() == 13) {
                    this.getCharQueue().a();
                    continue;
                }
                while (true) {
                    byte c2 = this.getCharQueue().a();
                    if (System.getProperty("sendsms.dumpqueues") != null) {
                        Logger.getInstance().logDebug("OUT READER QUEUE : " + c2 + " / " + (char)c2, null, this.getGateway().getGatewayId());
                    }
                    if (c2 == 10) break;
                    buffer.write(c2);
                }
                tmp = buffer.toByteArray();
                if (tmp.length <= 0) continue;
                if (tmp[tmp.length - 1] != 13) {
                    buffer.write(13);
                    tmp = buffer.toByteArray();
                }
                response = buffer.toString();
                if (this.getGateway().getATHandler().matchesTerminator(response) || this.a(response)) break;
            }
            buffer.close();
            Logger.getInstance().logDebug("BUFFER: " + response, null, this.getGateway().getGatewayId());
            if (this.getGateway().getATHandler().isUnsolicitedResponse(response)) {
                AGateway.AsyncEvents event = this.getGateway().getATHandler().processUnsolicitedEvents(response);
                if (event == eventResponse && eventResponse != AGateway.AsyncEvents.NOTHING) {
                    return tmp;
                }
                if (event != AGateway.AsyncEvents.INBOUNDMESSAGE && event != AGateway.AsyncEvents.INBOUNDSTATUSREPORTMESSAGE && event != AGateway.AsyncEvents.INBOUNDCALL && event != AGateway.AsyncEvents.USSDRESPONSE) return this.getResponseByteArray();
                this.getAsyncNotifier().a(event, response);
                return this.getResponseByteArray();
            }
            if (response.matches(rxErrorWithCode)) {
                Pattern p2 = Pattern.compile(rxErrorWithCode);
                Matcher m2 = p2.matcher(response);
                if (!m2.find()) throw new GatewayException("Cannot match error code. Should never happen!");
                try {
                    if (m2.group(1).equals("CME")) {
                        int code = Integer.parseInt(m2.group(2));
                        this.a(5000 + code);
                    }
                    if (!m2.group(1).equals("CMS")) throw new GatewayException("Invalid error response: " + m2.group(1));
                    int code = Integer.parseInt(m2.group(2));
                    this.a(6000 + code);
                }
                catch (NumberFormatException e2) {
                    Logger.getInstance().logDebug("Error on number conversion while interpreting response: ", null, this.getGateway().getGatewayId());
                    throw new GatewayException("Cannot convert error code number.");
                }
            } else if (response.matches(rxPlainError)) {
                this.a(9000);
            } else if (response.indexOf("OK") >= 0) {
                this.a(0);
            } else {
                this.a(10000);
            }
            Logger.getInstance().logDebug("RECV :" + this.formatLog(response), null, this.getGateway().getGatewayId());
            return tmp;
        }
        catch (InterruptedException e3) {
            Logger.getInstance().logWarn("GetResponse() Interrupted.", e3, this.getGateway().getGatewayId());
            throw e3;
        }
        catch (TimeoutException e4) {
            this.getGateway().getModemDriver().write('\u001b');
            Logger.getInstance().logDebug("Buffer contents on timeout 1: " + response, null, this.getGateway().getGatewayId());
            throw e4;
        }
    }

    public String getResponse4CDMA() throws GatewayException, TimeoutException, IOException, InterruptedException {
        return new String(this.getResponse4CDMA(AGateway.AsyncEvents.NOTHING));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte[] getResponse4CDMA(AGateway.AsyncEvents eventResponse) throws GatewayException, TimeoutException, IOException, InterruptedException {
        String response = "";
        this.a(-1);
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(Service.getInstance().getSettings().SERIAL_BUFFER_SIZE);
        try {
            byte[] tmp;
            while (true) {
                if (this.getCharQueue().b() == 10 || this.getCharQueue().b() == 13) {
                    this.getCharQueue().a();
                    continue;
                }
                while (true) {
                    byte c2 = this.getCharQueue().a();
                    if (System.getProperty("sendsms.dumpqueues") != null) {
                        Logger.getInstance().logDebug("OUT READER QUEUE : " + c2 + " / " + (char)c2, null, this.getGateway().getGatewayId());
                    }
                    if (c2 == 10) break;
                    buffer.write(c2);
                }
                tmp = buffer.toByteArray();
                if (tmp[tmp.length - 1] != 13) {
                    buffer.write(13);
                    tmp = buffer.toByteArray();
                }
                response = buffer.toString();
                if (this.getGateway().getATHandler().matchesTerminator(response) || this.a(response)) break;
            }
            buffer.close();
            Logger.getInstance().logDebug("BUFFER: " + response, null, this.getGateway().getGatewayId());
            if (this.getGateway().getATHandler().isUnsolicitedResponse(response)) {
                AGateway.AsyncEvents event = this.getGateway().getATHandler().processUnsolicitedEvents(response);
                if (event == eventResponse && eventResponse != AGateway.AsyncEvents.NOTHING) {
                    return tmp;
                }
                if (event != AGateway.AsyncEvents.INBOUNDMESSAGE && event != AGateway.AsyncEvents.INBOUNDSTATUSREPORTMESSAGE && event != AGateway.AsyncEvents.INBOUNDCALL && event != AGateway.AsyncEvents.USSDRESPONSE) return this.getResponseByteArray();
                this.getAsyncNotifier().a(event, response);
                return this.getResponseByteArray();
            }
            if (response.matches(rxErrorWithCode)) {
                Pattern p2 = Pattern.compile(rxErrorWithCode);
                Matcher m2 = p2.matcher(response);
                if (!m2.find()) throw new GatewayException("Cannot match error code. Should never happen!");
                try {
                    if (m2.group(1).equals("CME")) {
                        int code = Integer.parseInt(m2.group(2));
                        this.a(5000 + code);
                    }
                    if (!m2.group(1).equals("CMS")) throw new GatewayException("Invalid error response: " + m2.group(1));
                    int code = Integer.parseInt(m2.group(2));
                    this.a(6000 + code);
                }
                catch (NumberFormatException e2) {
                    Logger.getInstance().logDebug("Error on number conversion while interpreting response: ", null, this.getGateway().getGatewayId());
                    throw new GatewayException("Cannot convert error code number.");
                }
            } else if (response.matches(rxPlainError)) {
                this.a(9000);
            } else if (response.indexOf("OK") >= 0) {
                this.a(0);
            } else {
                this.a(10000);
            }
            Logger.getInstance().logDebug("RECV :" + this.formatLog(response), null, this.getGateway().getGatewayId());
            return tmp;
        }
        catch (InterruptedException e3) {
            Logger.getInstance().logWarn("GetResponse() Interrupted.", e3, this.getGateway().getGatewayId());
            throw e3;
        }
        catch (TimeoutException e4) {
            this.getGateway().getModemDriver().write('\u001b');
            Logger.getInstance().logDebug("Buffer contents on timeout 2: " + response, null, this.getGateway().getGatewayId());
            throw e4;
        }
    }

    public byte[] getResponseByteArray4CDMA() throws GatewayException, TimeoutException, IOException, InterruptedException {
        return this.getResponse4CDMA(AGateway.AsyncEvents.NOTHING);
    }

    public String getResponseString() throws GatewayException, TimeoutException, IOException, InterruptedException {
        String strRes = new String(this.getResponseArray());
        return strRes;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte[] getResponseArray() throws GatewayException, TimeoutException, IOException, InterruptedException {
        String response = "";
        AGateway.AsyncEvents eventResponse = AGateway.AsyncEvents.NOTHING;
        this.a(-1);
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(Service.getInstance().getSettings().SERIAL_BUFFER_SIZE);
        try {
            byte[] tmp;
            boolean isHWMC323 = true;
            SerialModemBean bean = DeviceInfoCache.getInstance().get(this.getGateway().getGatewayId());
            if (!(bean == null || bean.getManufacturer().equalsIgnoreCase("Huawei") && bean.getModel().equalsIgnoreCase("MC323"))) {
                isHWMC323 = false;
            }
            while (true) {
                if (!isHWMC323) {
                    while (this.getCharQueue().b() == 10 || this.getCharQueue().b() == 13) {
                        this.getCharQueue().a();
                    }
                }
                while (true) {
                    byte c2 = this.getCharQueue().a();
                    if (System.getProperty("sendsms.dumpqueues") != null) {
                        Logger.getInstance().logDebug("OUT READER QUEUE : " + c2 + " / " + (char)c2, null, this.getGateway().getGatewayId());
                    }
                    if (c2 == 10) break;
                    buffer.write(c2);
                }
                tmp = buffer.toByteArray();
                if (tmp.length <= 0) continue;
                if (tmp[tmp.length - 1] != 13) {
                    buffer.write(13);
                    tmp = buffer.toByteArray();
                }
                response = buffer.toString();
                if (this.getGateway().getATHandler().matchesTerminator(response) || response.indexOf("CMGR:") != -1 || response.indexOf("CMGL:") != -1 || response.indexOf("CDS:") != -1 || response.indexOf("^HCMGSS:") != -1 || response.indexOf("^HCMGSF:") != -1) break;
            }
            buffer.close();
            Logger.getInstance().logDebug("BUFFER: " + response, null, this.getGateway().getGatewayId());
            if (this.getGateway().getATHandler().isUnsolicitedResponse(response)) {
                AGateway.AsyncEvents event = this.getGateway().getATHandler().processUnsolicitedEvents(response);
                if (event != eventResponse || eventResponse == AGateway.AsyncEvents.NOTHING) return this.getResponseByteArray();
                return tmp;
            }
            if (response.matches(rxErrorWithCode)) {
                Pattern p2 = Pattern.compile(rxErrorWithCode);
                Matcher m2 = p2.matcher(response);
                if (!m2.find()) throw new GatewayException("Cannot match error code. Should never happen!");
                try {
                    if (m2.group(1).equals("CME")) {
                        int code = Integer.parseInt(m2.group(2));
                        this.a(5000 + code);
                    }
                    if (!m2.group(1).equals("CMS")) throw new GatewayException("Invalid error response: " + m2.group(1));
                    int code = Integer.parseInt(m2.group(2));
                    this.a(6000 + code);
                }
                catch (NumberFormatException e2) {
                    Logger.getInstance().logDebug("Error on number conversion while interpreting response: ", null, this.getGateway().getGatewayId());
                    throw new GatewayException("Cannot convert error code number.");
                }
            } else if (response.matches(rxPlainError)) {
                this.a(9000);
            } else if (response.indexOf("OK") >= 0) {
                this.a(0);
            } else {
                this.a(10000);
            }
            Logger.getInstance().logDebug("RECV :" + this.formatLog(response), null, this.getGateway().getGatewayId());
            return tmp;
        }
        catch (InterruptedException e3) {
            Logger.getInstance().logWarn("GetResponse() Interrupted.", e3, this.getGateway().getGatewayId());
            throw e3;
        }
        catch (TimeoutException e4) {
            this.getGateway().getModemDriver().write('\u001b');
            Logger.getInstance().logDebug("Buffer contents on timeout 3: " + response, null, this.getGateway().getGatewayId());
            throw e4;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte[] getResponse(AGateway.AsyncEvents eventResponse) throws GatewayException, TimeoutException, IOException, InterruptedException {
        String response = "";
        this.a(-1);
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(Service.getInstance().getSettings().SERIAL_BUFFER_SIZE);
        byte[] tmp = null;
        try {
            boolean isHWMC323 = false;
            while (this.threadWait(1L)) {
                if (!isHWMC323) {
                    while ((this.getCharQueue().b() == 10 || this.getCharQueue().b() == 13) && this.threadWait(1L)) {
                        this.getCharQueue().a();
                    }
                }
                while (this.threadWait(1L)) {
                    byte c2 = this.getCharQueue().a();
                    if (System.getProperty("sendsms.dumpqueues") != null) {
                        Logger.getInstance().logDebug("OUT READER QUEUE : " + c2 + " / " + (char)c2, null, this.getGateway().getGatewayId());
                    }
                    if (c2 == 10) break;
                    buffer.write(c2);
                }
                if ((tmp = buffer.toByteArray()).length <= 0) continue;
                if (tmp[tmp.length - 1] != 13) {
                    buffer.write(13);
                    tmp = buffer.toByteArray();
                }
                if ((response = buffer.toString()).indexOf("ERROR") != -1) {
                    Logger.getInstance().logError("\u83b7\u53d6\u54cd\u5e94\u51fa\u73b0\u9519\u8bef:" + response, null, this.getGateway().getGatewayId());
                    break;
                }
                if (!this.getGateway().getATHandler().matchesTerminator(response) && response.indexOf("+CME ERROR:R-UIM not inserted") == -1 && response.indexOf("+CME ERROR:not found") == -1) continue;
            }
            buffer.close();
            Logger.getInstance().logDebug("BUFFER: " + response, null, this.getGateway().getGatewayId());
            if (this.getGateway().getATHandler().isUnsolicitedResponse(response)) {
                AGateway.AsyncEvents event = this.getGateway().getATHandler().processUnsolicitedEvents(response);
                if (event == eventResponse && eventResponse != AGateway.AsyncEvents.NOTHING) {
                    return tmp;
                }
                if (event == AGateway.AsyncEvents.INBOUNDSTATUSREPORTMESSAGE || event == AGateway.AsyncEvents.INBOUNDCALL || event == AGateway.AsyncEvents.USSDRESPONSE) {
                    this.getAsyncNotifier().a(event, response);
                }
                int trycount = 0;
                while (this.getCharQueue().b == this.getCharQueue().c && this.threadWait(200L)) {
                    if (trycount++ <= 600) continue;
                    Logger.getInstance().logError("\u8d85\u8fc72\u5206\u949f\u4e32\u53e3\u4f9d\u7136\u6ca1\u6709\u8fd4\u56de\u6570\u636e", null, this.getGateway().getGatewayId());
                    return tmp;
                }
                return this.getResponseByteArray();
            }
            if (response.matches(rxErrorWithCode)) {
                int k2 = response.indexOf("+CMS");
                if (k2 != -1) {
                    response = response.substring(k2);
                } else {
                    int p2 = response.indexOf("+CME");
                    if (p2 != -1) {
                        response = response.substring(p2);
                    }
                }
                Pattern p3 = Pattern.compile(rxErrorWithCode);
                Matcher m2 = p3.matcher(response);
                if (!m2.find()) throw new GatewayException("Cannot match error code. Should never happen!");
                try {
                    if (m2.group(1).equals("CME")) {
                        int code = Integer.parseInt(m2.group(2));
                        this.a(5000 + code);
                    }
                    if (!m2.group(1).equals("CMS")) throw new GatewayException("Invalid error response: " + m2.group(1));
                    int code = Integer.parseInt(m2.group(2));
                    this.a(6000 + code);
                }
                catch (NumberFormatException e2) {
                    Logger.getInstance().logDebug("Error on number conversion while interpreting response: ", null, this.getGateway().getGatewayId());
                    throw new GatewayException("Cannot convert error code number.");
                }
            } else if (response.matches(rxPlainError)) {
                this.a(9000);
            } else if (response.indexOf("OK") >= 0) {
                this.a(0);
            } else {
                this.a(10000);
            }
            Logger.getInstance().logDebug("RECV :" + this.formatLog(response), null, this.getGateway().getGatewayId());
            return tmp;
        }
        catch (InterruptedException e3) {
            Logger.getInstance().logWarn("GetResponse() Interrupted.", e3, this.getGateway().getGatewayId());
            throw e3;
        }
        catch (TimeoutException e4) {
            this.getGateway().getModemDriver().write('\u001b');
            this.d.setStatus(AGatewayHelper.GatewayStatuses.RESTART);
            Logger.getInstance().logError("Buffer contents on timeout 4: " + response, null, this.getGateway().getGatewayId());
            Logger.getInstance().logError("TimeoutException: " + e4.getMessage(), null, this.getGateway().getGatewayId());
            throw e4;
        }
        catch (IOException e5) {
            Logger.getInstance().logError("Buffer IO error: " + response, null, this.getGateway().getGatewayId());
            this.getGateway().setStatus(AGatewayHelper.GatewayStatuses.RESTART);
            throw e5;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearBuffer() throws IOException, InterruptedException {
        Object object = this.getSYNCCommander();
        synchronized (object) {
            Logger.getInstance().logDebug("clearBuffer() called.", null, this.getGateway().getGatewayId());
            if (!this.threadWait(Service.getInstance().getSettings().SERIAL_CLEAR_WAIT)) {
                // empty if block
            }
            this.clear();
            this.getCharQueue().c();
        }
    }

    public void noLockClearBufferOld() throws IOException, InterruptedException {
        if (!this.threadWait(300L)) {
            // empty if block
        }
        this.getCharQueue().c();
    }

    public void noLockClearBufferNew() throws IOException, InterruptedException {
        this.getCharQueue().c();
    }

    protected boolean waitForNetworkRegistration() throws GatewayException, TimeoutException, IOException, InterruptedException {
        if ("no".equalsIgnoreCase(JDSMSServer.getInstance().getProperties().getString("settings.register_GSM"))) {
            return true;
        }
        int retries = 0;
        String response;
        while ((response = this.getGateway().getATHandler().getNetworkRegistration()).indexOf("ERROR") < 0) {
            int answer;
            response = response.replaceAll("\\s+OK\\s+", "");
            response = response.replaceAll("\\s+", "");
            response = response.replaceAll("\\+CREG:", "");
            StringTokenizer tokens = new StringTokenizer(response, ",");
            tokens.nextToken();
            try {
                String a2 = tokens.nextToken();
                answer = Integer.parseInt(a2);
            }
            catch (Exception e2) {
                answer = -1;
            }
            switch (answer) {
                case 0: {
                    Logger.getInstance().logError("GSM: Auto-registration disabled!", null, this.getGateway().getGatewayId());
                    throw new GatewayException("GSM Network Auto-Registration disabled!");
                }
                case 1: {
                    Logger.getInstance().logInfo("GSM: Registered to home network.", null, this.getGateway().getGatewayId());
                    return true;
                }
                case 2: {
                    Logger.getInstance().logWarn("GSM: Not registered, searching for network...", null, this.getGateway().getGatewayId());
                    if (++retries != 6) break;
                    throw new GatewayException("GSM Network Registration failed, give up trying!");
                }
                case 3: {
                    Logger.getInstance().logError("GSM: Network registration denied!", null, this.getGateway().getGatewayId());
                    throw new GatewayException("GSM Network Registration denied!");
                }
                case 4: {
                    Logger.getInstance().logError("GSM: Unknown registration error!", null, this.getGateway().getGatewayId());
                    throw new GatewayException("GSM Network Registration error!");
                }
                case 5: {
                    Logger.getInstance().logInfo("GSM: Registered to foreign network (roaming).", null, this.getGateway().getGatewayId());
                    return true;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    Logger.getInstance().logInfo("GSM: CREG status=" + answer, null, this.getGateway().getGatewayId());
                    return true;
                }
                case -1: {
                    Logger.getInstance().logInfo("GSM: Invalid CREG response.", null, this.getGateway().getGatewayId());
                    throw new GatewayException("GSM: Invalid CREG response.");
                }
            }
            if (this.threadWait(Service.getInstance().getSettings().AT_WAIT_NETWORK)) continue;
        }
        return false;
    }

    protected String formatLog(String s) {
        StringBuffer response = new StringBuffer();
        block5: for (int i2 = 0; i2 < s.length(); ++i2) {
            char c2 = s.charAt(i2);
            switch (c2) {
                case '\r': {
                    response.append("(cr)");
                    continue block5;
                }
                case '\n': {
                    response.append("(lf)");
                    continue block5;
                }
                case '\t': {
                    response.append("(tab)");
                    continue block5;
                }
                default: {
                    if (c2 >= ' ' && c2 < '\u0080') {
                        response.append(c2);
                        continue block5;
                    }
                    response.append("(" + c2 + ")");
                }
            }
        }
        return response.toString();
    }

    void a(int myLastError) {
        this.k = myLastError;
    }

    public int getLastError() {
        return this.k;
    }

    public String getLastErrorText() {
        if (this.getLastError() == 0) {
            return "OK";
        }
        if (this.getLastError() == -1) {
            return "Invalid or empty response";
        }
        if (this.getLastError() / 1000 == 5) {
            return "CME Error " + this.getLastError() % 1000;
        }
        if (this.getLastError() / 1000 == 6) {
            return "CMS Error " + this.getLastError() % 1000;
        }
        return "Error: unknown " + this.getLastError();
    }

    public boolean isOk() {
        Logger.getInstance().logDebug("getLastError\u8fd4\u56de" + this.getLastError(), null, this.getGateway().getGatewayId());
        return this.getLastError() == OK;
    }

    protected ModemGateway getGateway() {
        return this.d;
    }

    protected void setGateway(ModemGateway myGateway) {
        this.d = myGateway;
    }

    protected boolean isConnected() {
        return this.connected;
    }

    protected void setConnected(boolean myConnected) {
        this.connected = myConnected;
    }

    protected boolean isDataReceived() {
        return this.e;
    }

    protected void setDataReceived(boolean myDataReceived) {
        this.e = myDataReceived;
    }

    protected d getCharQueue() {
        return this.f;
    }

    protected void setCharQueue(d myCharQueue) {
        this.f = myCharQueue;
    }

    protected Object getSYNCReader() {
        return this.a;
    }

    protected void setSYNCReader(Object reader) {
        this.a = reader;
    }

    public Object getSYNCCommander() {
        return this.b;
    }

    protected void setSYNCCommander(Object commander) {
        this.b = commander;
    }

    protected Object getSYNCInboundReader() {
        return this.c;
    }

    protected void setSYNCInboundReader(Object inbMessage) {
        this.c = inbMessage;
    }

    protected e getKeepAlive() {
        return this.h;
    }

    protected void setKeepAlive(e myKeepAlive) {
        this.h = myKeepAlive;
    }

    protected b getAsyncNotifier() {
        return this.i;
    }

    protected void setAsyncNotifier(b myAsyncNotifier) {
        this.i = myAsyncNotifier;
    }

    protected a getAsyncMessageProcessor() {
        return this.j;
    }

    protected void setAsyncMessageProcessor(a myAsyncMessageProcessor) {
        this.j = myAsyncMessageProcessor;
    }

    protected f getModemReader() {
        return this.g;
    }

    protected void setModemReader(f myModemReader) {
        this.g = myModemReader;
    }

    private boolean a(String response) {
        return response.length() - 3 == response.lastIndexOf("OK");
    }

    public boolean threadWait(long nTimeOut) {
        if (this.getGateway() == null) {
            return false;
        }
        return this.getGateway().threadWait(nTimeOut);
    }

    private class c
    extends AServiceThread {
        private List<InboundMessage> b;

        public c(String name, int delay) {
            super(name, delay, 0, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void process() throws Exception {
            if (AModemDriver.this.isConnected() && AModemDriver.this.getGateway().getStatus() == AGatewayHelper.GatewayStatuses.STARTED) {
                Object object = AModemDriver.this.getSYNCInboundReader();
                synchronized (object) {
                    this.b = new ArrayList<InboundMessage>();
                    AModemDriver.this.getGateway().readMessages(this.b, InboundMessage.MessageClasses.ALL);
                    for (int i2 = 0; i2 < this.b.size(); ++i2) {
                        InboundMessage msg = this.b.get(i2);
                        switch (msg.getType()) {
                            case INBOUND: 
                            case STATUSREPORT: {
                                Service.getInstance().getNotifyQueueManager().getNotifyQueue().add(new InboundMessageNotification(AModemDriver.this.getGateway(), msg.getType(), msg));
                            }
                        }
                    }
                    this.b.clear();
                }
            }
        }
    }

    private class a
    extends Thread {
        private List<InboundMessage> b = new ArrayList<InboundMessage>();
        private Object c = new Object();
        private boolean d = false;

        public a() {
            this.setPriority(10);
            this.setName("SendSMS-AsyncMessageProcessor : " + AModemDriver.this.getGateway().getGatewayId());
            this.setDaemon(true);
            this.start();
            Logger.getInstance().logDebug("AsyncMessageProcessor thread started.", null, AModemDriver.this.getGateway().getGatewayId());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void a() {
            Object object = this.c;
            synchronized (object) {
                if (this.d) {
                    return;
                }
                this.d = true;
                this.c.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (AModemDriver.this.isConnected()) {
                try {
                    Object object = this.c;
                    synchronized (object) {
                        if (!this.d) {
                            this.c.wait();
                            if (!AModemDriver.this.isConnected()) {
                                break;
                            }
                        }
                    }
                    object = AModemDriver.this.getSYNCInboundReader();
                    synchronized (object) {
                        AModemDriver.this.getGateway().readMessages(this.b, InboundMessage.MessageClasses.ALL);
                        block15: for (int i2 = 0; i2 < this.b.size(); ++i2) {
                            InboundMessage msg = this.b.get(i2);
                            switch (msg.getType()) {
                                case INBOUND: 
                                case STATUSREPORT: {
                                    Service.getInstance().getNotifyQueueManager().getNotifyQueue().add(new InboundMessageNotification(AModemDriver.this.getGateway(), msg.getType(), msg));
                                    continue block15;
                                }
                            }
                        }
                    }
                    this.b.clear();
                    this.d = false;
                }
                catch (InterruptedException e2) {
                    if (AModemDriver.this.isConnected()) continue;
                    break;
                }
                catch (GatewayException e3) {
                    Logger.getInstance().logError("ModemDriver: AsyncMessageProcessor GatewayException Error.", e3, AModemDriver.this.getGateway().getGatewayId());
                    AModemDriver.this.getGateway().setStatus(AGatewayHelper.GatewayStatuses.RESTART);
                }
                catch (IOException e4) {
                    Logger.getInstance().logError("ModemDriver: AsyncMessageProcessor IOException Error.", e4, AModemDriver.this.getGateway().getGatewayId());
                    AModemDriver.this.getGateway().setStatus(AGatewayHelper.GatewayStatuses.RESTART);
                }
                catch (TimeoutException e5) {
                    Logger.getInstance().logError("ModemDriver: AsyncMessageProcessor TimeoutException Error.", e5, AModemDriver.this.getGateway().getGatewayId());
                    AModemDriver.this.getGateway().setStatus(AGatewayHelper.GatewayStatuses.RESTART);
                }
            }
            Logger.getInstance().logDebug("AsyncMessageProcessor thread ended.", null, AModemDriver.this.getGateway().getGatewayId());
        }
    }

    private class b
    extends Thread {
        private BlockingQueue<a> b;
        private Object c = new Object();

        public b() {
            this.b = new LinkedBlockingQueue<a>();
            this.setPriority(1);
            this.setName("SendSMS-AsyncNotifier : " + AModemDriver.this.getGateway().getGatewayId());
            this.setDaemon(true);
            this.start();
            Logger.getInstance().logInfo("AsyncNotifier thread started.", null, AModemDriver.this.getGateway().getGatewayId());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void a(AGateway.AsyncEvents event, String response) {
            Object object = this.c;
            synchronized (object) {
                a ev = new a(event, response);
                Logger.getInstance().logInfo("Storing AsyncEvent: " + ev, null, AModemDriver.this.getGateway().getGatewayId());
                this.b.add(ev);
                this.c.notify();
            }
        }

        protected String a(String indication) {
            Pattern p2 = Pattern.compile("\\+?\"\\S+\"");
            Matcher m2 = p2.matcher(indication);
            if (m2.find()) {
                return indication.substring(m2.start(), m2.end()).replaceAll("\"", "");
            }
            return "";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (AModemDriver.this.isConnected()) {
                try {
                    String response;
                    a event = this.b.take();
                    Logger.getInstance().logInfo("Processing AsyncEvent: " + event, null, AModemDriver.this.getGateway().getGatewayId());
                    if (event.a == AGateway.AsyncEvents.INBOUNDMESSAGE) {
                        Logger.getInstance().logDebug("Inbound message detected!", null, AModemDriver.this.getGateway().getGatewayId());
                        event.a = AGateway.AsyncEvents.NOTHING;
                        response = event.b;
                        if (AModemDriver.this.getAsyncMessageProcessor() == null) continue;
                        AModemDriver.this.getAsyncMessageProcessor().a();
                        continue;
                    }
                    if (event.a == AGateway.AsyncEvents.INBOUNDSTATUSREPORTMESSAGE) {
                        Logger.getInstance().logDebug("Inbound status report message detected!", null, AModemDriver.this.getGateway().getGatewayId());
                        event.a = AGateway.AsyncEvents.NOTHING;
                        response = event.b;
                        if (AModemDriver.this.getAsyncMessageProcessor() == null) continue;
                        AModemDriver.this.getAsyncMessageProcessor().a();
                        continue;
                    }
                    if (event.a == AGateway.AsyncEvents.INBOUNDCALL) {
                        Logger.getInstance().logInfo("Inbound call detected!", null, AModemDriver.this.getGateway().getGatewayId());
                        event.a = AGateway.AsyncEvents.NOTHING;
                        Object object = AModemDriver.this.getSYNCCommander();
                        synchronized (object) {
                            AModemDriver.this.getGateway().getATHandler().switchToCmdMode();
                            AModemDriver.this.getGateway().getModemDriver().write("ATH\r");
                            AModemDriver.this.getGateway().getModemDriver().getResponse();
                            response = event.b;
                            Logger.getInstance().logInfo("Processing AsyncEvent: response=" + response, null, AModemDriver.this.getGateway().getGatewayId());
                        }
                        Service.getInstance().getNotifyQueueManager().getNotifyQueue().add(new CallNotification(AModemDriver.this.getGateway(), this.a(response)));
                        continue;
                    }
                    if (event.a != AGateway.AsyncEvents.USSDRESPONSE) continue;
                    Logger.getInstance().logDebug("Inbound USSD response detected!", null, AModemDriver.this.getGateway().getGatewayId());
                    event.a = AGateway.AsyncEvents.NOTHING;
                    response = event.b;
                    Logger.getInstance().logDebug("USSD response : " + AModemDriver.this.formatLog(response), null, AModemDriver.this.getGateway().getGatewayId());
                    if (Service.getInstance().getUSSDNotification() == null) continue;
                    USSDResponse ussdResponse = new USSDResponse(response, AModemDriver.this.getGateway().getGatewayId());
                    ussdResponse.setContent(AModemDriver.this.getGateway().getATHandler().formatUSSDResponse(ussdResponse.getContent()));
                    Service.getInstance().getUSSDNotification().process(AModemDriver.this.getGateway(), ussdResponse);
                }
                catch (InterruptedException e2) {
                    if (AModemDriver.this.isConnected()) continue;
                    break;
                }
                catch (InvalidMessageException e3) {
                    Logger.getInstance().logInfo("Invalid Message received! Ignoring. ", e3, AModemDriver.this.getGateway().getGatewayId());
                }
                catch (GatewayException e4) {
                    Logger.getInstance().logError("ModemDriver: AsyncNotifier GatewayException Error.", e4, AModemDriver.this.getGateway().getGatewayId());
                    AModemDriver.this.getGateway().setStatus(AGatewayHelper.GatewayStatuses.RESTART);
                }
                catch (IOException e5) {
                    Logger.getInstance().logError("ModemDriver: AsyncNotifier IOException Error.", e5, AModemDriver.this.getGateway().getGatewayId());
                    AModemDriver.this.getGateway().setStatus(AGatewayHelper.GatewayStatuses.RESTART);
                }
                catch (TimeoutException e6) {
                    Logger.getInstance().logError("ModemDriver: AsyncNotifier TimeoutException Error.", e6, AModemDriver.this.getGateway().getGatewayId());
                    AModemDriver.this.getGateway().setStatus(AGatewayHelper.GatewayStatuses.RESTART);
                }
            }
            Logger.getInstance().logInfo("AsyncNotifier thread ended.", null, AModemDriver.this.getGateway().getGatewayId());
        }

        class a {
            AGateway.AsyncEvents a;
            String b;

            public a(AGateway.AsyncEvents myEvent, String myResponse) {
                this.a = myEvent;
                this.b = myResponse;
            }

            public String toString() {
                return "Event: " + (Object)((Object)this.a) + " / Response: " + this.b;
            }
        }
    }

    private class e
    extends AServiceThread {
        private volatile int b;

        public e(String name, int delay) {
            super(name, delay, 0, true);
            this.b = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void process() throws Exception {
            block13: {
                try {
                    if (!AModemDriver.this.isConnected()) {
                        return;
                    }
                    if (AModemDriver.this.getGateway().getStatus() != AGatewayHelper.GatewayStatuses.STARTED) break block13;
                    Object object = AModemDriver.this.getSYNCCommander();
                    synchronized (object) {
                        block14: {
                            if (!AModemDriver.this.isConnected()) {
                                return;
                            }
                            try {
                                if (!AModemDriver.this.getGateway().getATHandler().isAlive()) {
                                    Logger.getInstance().logError("thread work KeepAlive\u8fd4\u56de\u54cd\u5e94\u5931\u8d25\u72b6\u6001\u88ab\u6807\u8bb0\u4e3a\u91cd\u542f", null, AModemDriver.this.getGateway().getGatewayId());
                                    AModemDriver.this.getGateway().setStatus(AGatewayHelper.GatewayStatuses.RESTART);
                                } else {
                                    this.b = 0;
                                }
                            }
                            catch (InterruptedException e2) {
                                Logger.getInstance().logDebug("thread work keep alive interrupted", e2, AModemDriver.this.getGateway().getGatewayId());
                            }
                            catch (Exception e3) {
                                Logger.getInstance().logError("thread work KeepAlive\u8fd4\u56de\u54cd\u5e94\u5f02\u5e38 " + this.b, e3, AModemDriver.this.getGateway().getGatewayId());
                                if (++this.b < 5) break block14;
                                AModemDriver.this.getGateway().setStatus(AGatewayHelper.GatewayStatuses.RESTART);
                                this.b = 0;
                            }
                        }
                    }
                }
                catch (Exception e4) {
                    Logger.getInstance().logError("thread work KeepAlive Error.", e4, AModemDriver.this.getGateway().getGatewayId());
                    AModemDriver.this.getGateway().setStatus(AGatewayHelper.GatewayStatuses.RESTART);
                }
            }
            if (!AModemDriver.this.threadWait(1000L)) {
                // empty if block
            }
        }
    }

    private class f
    extends Thread {
        public f() {
            this.setName("SMSlib-ModemReader-" + AModemDriver.this.getGateway().getGatewayId());
            this.setDaemon(true);
            this.start();
            Logger.getInstance().logDebug("ModemReader thread started.", null, AModemDriver.this.getGateway().getGatewayId());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block6: while (AModemDriver.this.isConnected()) {
                try {
                    String result = "";
                    Object object = AModemDriver.this.getSYNCReader();
                    synchronized (object) {
                        if (!AModemDriver.this.isDataReceived()) {
                            AModemDriver.this.getSYNCReader().wait();
                        }
                        if (!AModemDriver.this.isConnected()) {
                            break;
                        }
                        byte[] c2 = AModemDriver.this.read();
                        int len = c2.length;
                        if (len >= 100) {
                            len = 100;
                        }
                        result = new String(c2, 0, len);
                        for (int i2 = 0; c2 != null && i2 < c2.length; ++i2) {
                            AModemDriver.this.getCharQueue().a(c2[i2]);
                        }
                        AModemDriver.this.setDataReceived(false);
                    }
                    if (result.indexOf("CMS ERROR: 305") != -1 || result.indexOf("CMS ERROR: 304") != -1 || result.indexOf("CMS ERROR: 302") != -1) {
                        AModemDriver.this.getGateway().getAtHandler().readTextMode();
                    }
                    int len = result.length() > 20 ? 20 : result.length();
                    String data = result.substring(0, len);
                    Logger.getInstance().logInfo("data\u6570\u636e\u662f=" + data, null, AModemDriver.this.getGateway().getGatewayId());
                    data = AModemDriver.this.getCharQueue().a(6);
                    for (int i3 = 0; i3 < AModemDriver.this.getGateway().getATHandler().getUnsolicitedResponses().length; ++i3) {
                        if (data.indexOf(AModemDriver.this.getGateway().getATHandler().getUnsolicitedResponse(i3)) < 0) continue;
                        Logger.getInstance().logDebug("thread work - interrupt()", null, AModemDriver.this.getGateway().getGatewayId());
                        AModemDriver.this.getKeepAlive().interrupt();
                        continue block6;
                    }
                }
                catch (InterruptedException e2) {
                    if (AModemDriver.this.isConnected()) continue;
                    break;
                }
                catch (Exception e3) {
                    e3.printStackTrace();
                }
            }
            Logger.getInstance().logDebug("ModemReader thread ended.", null, AModemDriver.this.getGateway().getGatewayId());
        }
    }

    private class d {
        byte[] a = null;
        int b = 0;
        int c = 0;

        public synchronized void a(byte c2) {
            if (this.a == null) {
                this.a = new byte[Service.getInstance().getSettings().SERIAL_BUFFER_SIZE];
            }
            this.a[this.c] = c2;
            ++this.c;
            if (this.c == Service.getInstance().getSettings().SERIAL_BUFFER_SIZE) {
                this.c = 0;
            }
            if (System.getProperty("sendsms.dumpqueues") != null) {
                Logger.getInstance().logDebug("IN READER QUEUE : " + c2 + " / " + (char)c2, null, AModemDriver.this.getGateway().getGatewayId());
            }
            this.notifyAll();
        }

        public synchronized byte a() throws TimeoutException, InterruptedException {
            if (this.a == null) {
                this.a = new byte[Service.getInstance().getSettings().SERIAL_BUFFER_SIZE];
            }
            while (true) {
                try {
                    if (this.b == this.c) {
                        this.wait(Service.getInstance().getSettings().SERIAL_TIMEOUT_RECV);
                    }
                    if (this.b == this.c) {
                        throw new TimeoutException("No response from device.");
                    }
                    byte c2 = this.a[this.b];
                    ++this.b;
                    if (this.b == Service.getInstance().getSettings().SERIAL_BUFFER_SIZE) {
                        this.b = 0;
                    }
                    return c2;
                }
                catch (InterruptedException e2) {
                    if (AModemDriver.this.getGateway().getStatus() == AGatewayHelper.GatewayStatuses.STARTED) {
                        Logger.getInstance().logWarn("Ignoring InterruptedException in Queue.get().", null, AModemDriver.this.getGateway().getGatewayId());
                        continue;
                    }
                    Logger.getInstance().logWarn("Re-throwing InterruptedException in Queue.get() - should be during shutdown...", null, AModemDriver.this.getGateway().getGatewayId());
                    throw new InterruptedException();
                }
                break;
            }
        }

        public synchronized byte b() throws InterruptedException {
            if (this.a == null) {
                this.a = new byte[Service.getInstance().getSettings().SERIAL_BUFFER_SIZE];
            }
            while (true) {
                try {
                    if (this.b == this.c) {
                        this.wait(Service.getInstance().getSettings().SERIAL_TIMEOUT);
                    }
                    if (this.b == this.c) {
                        return -1;
                    }
                    return this.a[this.b];
                }
                catch (InterruptedException e2) {
                    if (AModemDriver.this.getGateway().getStatus() == AGatewayHelper.GatewayStatuses.STARTED) {
                        Logger.getInstance().logWarn("Ignoring InterruptedException in Queue.peek().", e2, AModemDriver.this.getGateway().getGatewayId());
                        continue;
                    }
                    Logger.getInstance().logWarn("Re-throwing InterruptedException in Queue.peek() - should be during shutdown...", e2, AModemDriver.this.getGateway().getGatewayId());
                    throw new InterruptedException();
                }
                break;
            }
        }

        public synchronized String a(int sizeToRead) {
            if (this.a == null) {
                this.a = new byte[Service.getInstance().getSettings().SERIAL_BUFFER_SIZE];
            }
            int size = sizeToRead;
            if (this.b == this.c) {
                return "";
            }
            StringBuffer result = new StringBuffer(size);
            int i2 = this.b;
            while (size > 0) {
                if (this.a[i2] != 10 && this.a[i2] != 13) {
                    result.append((char)this.a[i2]);
                    --size;
                }
                if (++i2 == Service.getInstance().getSettings().SERIAL_BUFFER_SIZE) {
                    i2 = 0;
                }
                if (i2 != this.c) continue;
                break;
            }
            return result.toString();
        }

        public synchronized void c() {
            this.b = 0;
            this.c = 0;
        }
    }
}

