/*
 * Decompiled with CFR 0.152.
 */
package cn.sendsms.otherModem.driver.loraDriver;

import cn.ajwcc.pduUtils.gsm3040.PduUtils;
import cn.sendsms.InboundMessage;
import cn.sendsms.Message;
import cn.sendsms.OutboundMessage;
import cn.sendsms.TmpMsg;
import cn.sendsms.jdsmsserver.JDSMSServer;
import cn.sendsms.jdsmsserver.web.NewAuth;
import cn.sendsms.otherModem.bean.LoraBean;
import cn.sendsms.otherModem.common.DesUtils;
import cn.sendsms.otherModem.common.Utils;
import cn.sendsms.otherModem.driver.ModemDriver;
import cn.sendsms.otherModem.thread.WatchDog;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.servlet.ServletException;
import jssc.SerialPort;
import jssc.SerialPortException;
import jssc.SerialPortList;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoRaDriver
extends ModemDriver {
    private static int loop = -1;
    private static ArrayList<SerialPort> serialPortList = new ArrayList();
    private static final LoRaDriver cache = new LoRaDriver();
    private static Logger log = Logger.getRootLogger();
    private Vector<LoraBean> devices = new Vector();
    private Vector<OutboundMessage> messages = new Vector();
    private Vector<InboundMessage> inMessages = new Vector();
    private static DesUtils des = null;
    public static final int[] BAUDRATES = new int[]{9600, 115200};
    public static final int MESSAGE_lENGTH = 2;
    public static final String MESSAGE_HEADER_HEX_STR = "FFFF";
    public static final int MESSAGE_HEADER_HEX_STR_LENGTH = 4;
    public static final int DISPATCH_DATE_LENGTH = 14;
    public static final int MESSAGE_SERIAL_LENGTH = 2;
    public static final int ENCODING_TYPE_LENGTH = 2;
    private static HashMap<String, String> messageIDWaitTimesMap = new HashMap();
    public static HashMap<String, String> messageIDReceiveDeviceIDMap = new HashMap();
    public static HashMap<String, ArrayList<String>> messageIDMessageInfoMap = new HashMap();
    public static HashMap<String, String> messageIDExpectMessageNumMap = new HashMap();
    public static HashMap<String, HashSet<String>> messageIDRealMessageNumMap = new HashMap();
    public static final String LOST_MESSAGE_FRAGMENT = "*****";
    public static SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
    private static int MESSAGE_TEXT_LENGTH = 10;
    public static final String LORA_DEVICE_SERIAL_NUMBER = "LORA";
    public static final int SPILITER = -1;
    public static final String ENCODING_IN_7BIT = "AA";
    public static final String ENCODING_IN_8BIT = "BB";
    public static final String ENCODING_IN_UFT8 = "CC";

    private LoRaDriver() {
    }

    public static final LoRaDriver getInstance() {
        return cache;
    }

    public void deleteConfiguration(LoraBean loraBean) throws ConfigurationException {
        PropertiesConfiguration propertiesConfiguration = JDSMSServer.getInstance().getProperties();
        boolean bl = false;
        int n = 0;
        for (n = 0; n < 64; ++n) {
            if (propertiesConfiguration.getString("loraDevice." + n, "").trim().length() == 0 || propertiesConfiguration.getString("loraDevice." + n, "").indexOf(loraBean.getGatewayID()) == -1) continue;
            bl = true;
            propertiesConfiguration.clearProperty("loraDevice." + n);
            break;
        }
        if (bl) {
            propertiesConfiguration.clearProperty(loraBean.getGatewayID() + ".port");
            propertiesConfiguration.clearProperty(loraBean.getGatewayID() + ".baudrate");
            propertiesConfiguration.clearProperty(loraBean.getGatewayID() + ".address");
            propertiesConfiguration.clearProperty(loraBean.getGatewayID() + ".channel");
            propertiesConfiguration.clearProperty(loraBean.getGatewayID() + ".type");
            propertiesConfiguration.clearProperty(loraBean.getGatewayID() + ".using_status");
            propertiesConfiguration.clearProperty(loraBean.getGatewayID() + ".serial_number");
        }
        propertiesConfiguration.save();
    }

    public void getLoRaDeviceInfo() throws Exception {
        Object object;
        int n;
        long l = System.currentTimeMillis();
        ArrayList<String> arrayList = new ArrayList();
        serialPortList = new ArrayList();
        String[] stringArray = SerialPortList.getPortNames();
        if (stringArray.length > 0) {
            arrayList = this.getSerialNumberList();
        }
        int n2 = 1;
        block14: for (n = 0; n < stringArray.length; ++n) {
            for (int i = 0; i < BAUDRATES.length; ++i) {
                object = new SerialPort(stringArray[n]);
                LoraBean loraBean = new LoraBean();
                log.error((Object)("\u7aef\u53e3" + object + "\u672a\u6253\u5f00"), null);
                log.info((Object)("\u6b63\u5728\u5c1d\u8bd5\u6253\u5f00\u7aef\u53e3:" + object));
                try {
                    if (!object.isOpened()) {
                        object.openPort();
                    }
                    object.setFlowControlMode(0);
                    object.setParams(BAUDRATES[i], 8, 1, 0);
                }
                catch (SerialPortException serialPortException) {
                    if (object.isOpened()) {
                        log.info((Object)("\u7aef\u53e3" + object + "\u6253\u5f00\u6210\u529f"));
                    }
                    log.info((Object)("\u7aef\u53e3" + object + "\u6253\u5f00\u5931\u8d25"));
                }
                String string = this.getDeviceInfo((SerialPort)object);
                string = string.replace(" ", "");
                if (string.startsWith("C0") && string.length() == 12) {
                    loraBean.setGatewayID("lora" + n2);
                    ++n2;
                    loraBean.setPortID(stringArray[n]);
                    loraBean.setAddress(string.substring(2, 6));
                    loraBean.setChannel(string.substring(8, 10));
                    String string2 = this.getSerialNumber(stringArray[n], arrayList);
                    boolean bl = NewAuth.checkDeviceAuth(string2);
                    loraBean.setValidate(bl);
                    if (bl) {
                        try {
                            NewAuth.updateAuthorizeTemp();
                        }
                        catch (Exception exception) {
                            log.error((Object)"", (Throwable)exception);
                        }
                        cn.sendsms.helper.Logger.getInstance().logInfo("\u8bbe\u5907\u6388\u6743\u6709\u6548", null, loraBean.getGatewayID());
                    } else {
                        try {
                            NewAuth.updateAuthorizeTemp();
                        }
                        catch (Exception exception) {
                            log.error((Object)"", (Throwable)exception);
                        }
                        cn.sendsms.helper.Logger.getInstance().logInfo("\u8bbe\u5907\u672a\u6388\u6743", null, loraBean.getGatewayID());
                    }
                    loraBean.setSerialNumber(string2);
                    this.addLora(loraBean);
                    serialPortList.add((SerialPort)object);
                    try {
                        object.closePort();
                    }
                    catch (SerialPortException serialPortException) {
                        if (!object.isOpened()) {
                            log.info((Object)("\u7aef\u53e3" + object + "\u5173\u95ed\u6210\u529f\uff01"));
                            continue block14;
                        }
                        log.info((Object)("\u7aef\u53e3" + object + "\u5173\u95ed\u5931\u8d25"));
                    }
                    continue block14;
                }
                try {
                    object.closePort();
                    continue;
                }
                catch (SerialPortException serialPortException) {
                    if (!object.isOpened()) {
                        log.info((Object)("\u7aef\u53e3" + object + "\u5173\u95ed\u6210\u529f\uff01"));
                        continue;
                    }
                    log.info((Object)("\u7aef\u53e3" + object + "\u5173\u95ed\u5931\u8d25"));
                }
            }
        }
        for (n = 0; n < this.devices.size(); ++n) {
            LoraBean loraBean = this.devices.get(n);
            object = this.getSerialNumber(loraBean.getPortID(), arrayList);
            boolean bl = NewAuth.checkDeviceAuth((String)object);
            loraBean.setValidate(bl);
            if (bl) {
                try {
                    NewAuth.updateAuthorizeTemp();
                }
                catch (Exception exception) {
                    log.error((Object)"", (Throwable)exception);
                }
                cn.sendsms.helper.Logger.getInstance().logInfo("\u8bbe\u5907\u6388\u6743\u6709\u6548", null, loraBean.getGatewayID());
            } else {
                try {
                    NewAuth.updateAuthorizeTemp();
                }
                catch (Exception exception) {
                    log.error((Object)"", (Throwable)exception);
                }
                cn.sendsms.helper.Logger.getInstance().logInfo("\u8bbe\u5907\u672a\u6388\u6743", null, loraBean.getGatewayID());
            }
            loraBean.setSerialNumber((String)object);
        }
        long l2 = System.currentTimeMillis();
        log.info((Object)("\u68c0\u6d4b\u8bbe\u5907\u82b1\u8d39\uff1a" + (l2 - l) + "ms"));
    }

    public String getSerialNumber(String string, List<String> list) {
        if (list == null) {
            return "";
        }
        for (int i = 0; i < this.devices.size(); ++i) {
            if (!this.devices.get(i).getPortID().equals(string)) continue;
            if (list.size() > i) {
                return list.get(i);
            }
            return "";
        }
        return "";
    }

    public void addLora(LoraBean loraBean) {
        this.devices.add(loraBean);
    }

    public void addMessage(OutboundMessage outboundMessage) {
        this.messages.add(outboundMessage);
    }

    public void addMessages(List<OutboundMessage> list) {
        this.messages.addAll(list);
    }

    public synchronized void addInMessage(Date date, String string, String string2, String string3, String string4) throws Exception {
        String string5 = JDSMSServer.getInstance().getProperties().getString("settings.lora_using", "yes");
        if (!string5.equals("yes")) {
            return;
        }
        InboundMessage inboundMessage = new InboundMessage(date, string, string2, string3);
        this.inMessages.add(inboundMessage);
    }

    public List<LoraBean> getAll() {
        ArrayList<LoraBean> arrayList = new ArrayList<LoraBean>();
        for (int i = 0; i < this.devices.size(); ++i) {
            arrayList.add(this.devices.get(i));
        }
        return arrayList;
    }

    public void deleteAll() {
        this.devices.removeAllElements();
        serialPortList = new ArrayList();
    }

    public boolean isLoraRegistered(String string) throws Exception {
        String string2 = NewAuth.getAuthorizeInfo(string, "regcode");
        if (string2 == null || string2.indexOf("null") != -1) {
            string2 = "";
        }
        if (string2.equals("")) {
            return false;
        }
        return NewAuth.checkDeviceAuth(string);
    }

    public List<InboundMessage> getInMessages() {
        ArrayList<InboundMessage> arrayList = new ArrayList<InboundMessage>();
        for (int i = 0; i < this.inMessages.size(); ++i) {
            InboundMessage inboundMessage = this.inMessages.get(i);
            arrayList.add(inboundMessage);
        }
        this.inMessages = new Vector();
        return arrayList;
    }

    public List<String> getUsingLoraList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.devices.size(); ++i) {
            LoraBean loraBean = this.devices.get(i);
            if (!loraBean.getUsingStatus().equals("1")) continue;
            arrayList.add(loraBean.getGatewayID());
        }
        return arrayList;
    }

    public String getSerialNumber(String string) {
        String string2 = "";
        for (int i = 0; i < this.devices.size(); ++i) {
            LoraBean loraBean = this.devices.get(i);
            if (!string.equals(loraBean.getPortID())) continue;
            string2 = loraBean.getSerialNumber();
        }
        return string2;
    }

    public List<LoraBean> getUsingLoras() {
        ArrayList<LoraBean> arrayList = new ArrayList<LoraBean>();
        for (int i = 0; i < this.devices.size(); ++i) {
            LoraBean loraBean = this.devices.get(i);
            if (!loraBean.getUsingStatus().equals("1")) continue;
            arrayList.add(loraBean);
        }
        return arrayList;
    }

    public void deleteLora(String string) throws ServletException, IOException, Exception {
        int n = 0;
        for (int i = 0; i < this.devices.size(); ++i) {
            LoraBean loraBean = this.devices.get(i);
            if (!loraBean.getPortID().equals(string)) continue;
            n = i;
            break;
        }
        LoRaDriver.getInstance().deleteLoraDevice(string);
        this.devices.removeElementAt(n);
    }

    public boolean checkStartLoras(String string) {
        if (string == null || string.equals("")) {
            return false;
        }
        for (int i = 0; i < this.devices.size(); ++i) {
            SerialPort serialPort;
            LoraBean loraBean = this.devices.get(i);
            if (!string.equals(loraBean.getPortID()) || !loraBean.getUsingStatus().equals("1") || (serialPort = this.getSerialPort(string)) == null || !serialPort.isOpened()) continue;
            return true;
        }
        return false;
    }

    public boolean checkStopLoras(String string) {
        if (string == null || string.equals("")) {
            return false;
        }
        for (int i = 0; i < this.devices.size(); ++i) {
            SerialPort serialPort;
            LoraBean loraBean = this.devices.get(i);
            if (!string.equals(loraBean.getPortID()) || !loraBean.getUsingStatus().equals("0") || (serialPort = this.getSerialPort(string)) == null || serialPort.isOpened()) continue;
            return true;
        }
        return false;
    }

    public boolean startDevice(String string, List<String> list) {
        for (int i = 0; i < this.devices.size(); ++i) {
            String string2;
            LoraBean loraBean = this.devices.get(i);
            if (!loraBean.getPortID().equals(string)) continue;
            if (!loraBean.isValidate()) {
                string2 = loraBean.getSerialNumber();
                String string3 = loraBean.getPortID();
                if (string2 == null || string2.equals("")) {
                    string2 = this.getSerialNumber(string3, list);
                }
                boolean bl = NewAuth.checkDeviceAuth(string2);
                loraBean.setValidate(bl);
                if (bl) {
                    try {
                        NewAuth.updateAuthorizeTemp();
                    }
                    catch (Exception exception) {
                        log.error((Object)"\u66f4\u65b0\u6388\u6743\u4fe1\u606f\u5f02\u5e38\u3002", (Throwable)exception);
                    }
                    cn.sendsms.helper.Logger.getInstance().logInfo("\u8bbe\u5907\u6388\u6743\u6709\u6548", null, loraBean.getGatewayID());
                } else {
                    try {
                        NewAuth.updateAuthorizeTemp();
                    }
                    catch (Exception exception) {
                        log.error((Object)"\u66f4\u65b0\u6388\u6743\u4fe1\u606f\u5f02\u5e38\u3002", (Throwable)exception);
                    }
                    cn.sendsms.helper.Logger.getInstance().logInfo("\u8bbe\u5907\u672a\u6388\u6743", null, loraBean.getGatewayID());
                }
            }
            if (!loraBean.getUsingStatus().equals("0")) continue;
            string2 = this.getSerialPort(string);
            try {
                string2.openPort();
                string2.setFlowControlMode(0);
                string2.setParams(this.getbaudrate(string), 8, 1, 0);
                loraBean.setUsingStatus("1");
                return true;
            }
            catch (SerialPortException serialPortException) {
                if (string2.isOpened()) {
                    log.info((Object)("\u7aef\u53e3" + string + "\u6253\u5f00\u6210\u529f"));
                    loraBean.setUsingStatus("1");
                    return true;
                }
                log.error((Object)("\u7aef\u53e3" + string + "\u6253\u5f00\u5931\u8d25\uff0c\u8bf7\u786e\u8ba4\u8bbe\u5907\u662f\u5426\u6b63\u5e38\u8fde\u63a5:" + string));
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean restartDevice(String string) {
        for (int i = 0; i < this.devices.size(); ++i) {
            LoraBean loraBean = this.devices.get(i);
            if (!loraBean.getPortID().equals(string)) continue;
            SerialPort serialPort = this.getSerialPort(string);
            if (serialPort == null) {
                return false;
            }
            try {
                serialPort.closePort();
            }
            catch (SerialPortException serialPortException) {
                if (!serialPort.isOpened()) {
                    log.info((Object)("\u7aef\u53e3" + string + "\u5173\u95ed\u6210\u529f"));
                }
                log.error((Object)("\u7aef\u53e3" + string + "\u5173\u95ed\u5931\u8d25"));
                return false;
            }
            try {
                serialPort.openPort();
                serialPort.setFlowControlMode(0);
                serialPort.setParams(this.getbaudrate(string), 8, 1, 0);
                loraBean.setUsingStatus("1");
                return true;
            }
            catch (SerialPortException serialPortException) {
                if (serialPort.isOpened()) {
                    log.info((Object)("\u7aef\u53e3" + string + "\u6253\u5f00\u6210\u529f"));
                    loraBean.setUsingStatus("1");
                    return true;
                }
                log.error((Object)("\u7aef\u53e3" + string + "\u6253\u5f00\u5931\u8d25\uff0c\u8bf7\u786e\u8ba4\u8bbe\u5907\u662f\u5426\u6b63\u5e38\u8fde\u63a5:" + string));
                return false;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean stopDevice(String string) {
        int n = 0;
        while (n < this.devices.size()) {
            LoraBean loraBean;
            LoraBean loraBean2 = loraBean = this.devices.get(n);
            synchronized (loraBean2) {
                if (loraBean.getPortID().equals(string)) {
                    SerialPort serialPort;
                    loraBean.setUsingStatus("0");
                    SerialPort serialPort2 = serialPort = this.getSerialPort(string);
                    synchronized (serialPort2) {
                        if (serialPort == null) {
                            return false;
                        }
                        try {
                            serialPort.closePort();
                        }
                        catch (SerialPortException serialPortException) {
                            if (serialPort.isOpened()) {
                                log.error((Object)("\u7aef\u53e3" + string + "\u5173\u95ed\u5931\u8d25"));
                                return false;
                            }
                            log.info((Object)("\u7aef\u53e3" + string + "\u5173\u95ed\u6210\u529f"));
                        }
                        return true;
                    }
                }
            }
            ++n;
        }
        return false;
    }

    public SerialPort getSerialPort(String string) {
        for (int i = 0; i < serialPortList.size(); ++i) {
            if (!serialPortList.get(i).getPortName().equals(string)) continue;
            return serialPortList.get(i);
        }
        SerialPort serialPort = new SerialPort(string);
        try {
            if (!serialPort.isOpened()) {
                serialPort.openPort();
            }
            serialPort.setFlowControlMode(0);
            serialPort.setParams(this.getbaudrate(string), 8, 1, 0);
            serialPortList.add(serialPort);
            serialPort.closePort();
            return serialPort;
        }
        catch (SerialPortException serialPortException) {
            log.error((Object)"\u4ece\u914d\u7f6e\u6587\u4ef6\u4e2d\u8bfb\u53d6\u7684\u8bbe\u5907\u521d\u59cb\u5316\u5931\u8d25\u3002\u3002\u3002", null);
            return null;
        }
    }

    public void deleteLoraDevice(String string) throws ServletException, IOException, Exception {
        try {
            List<LoraBean> list = LoRaDriver.getInstance().getAll();
            int n = list.size();
            int n2 = 0;
            for (n2 = 0; n2 < n && !list.get(n2).getPortID().equals(string); ++n2) {
            }
            PropertiesConfiguration propertiesConfiguration = JDSMSServer.getInstance().getProperties();
            int n3 = 0;
            for (n3 = 0; n3 < 64; ++n3) {
                Object[] objectArray = propertiesConfiguration.getStringArray("loraDevice." + n3);
                if (ArrayUtils.isEmpty((Object[])objectArray) || !((String)objectArray[0]).equals(list.get(n2).getGatewayID())) continue;
                propertiesConfiguration.clearProperty("loraDevice." + n3);
                propertiesConfiguration.clearProperty((String)objectArray[0] + ".port");
                propertiesConfiguration.clearProperty((String)objectArray[0] + ".baudrate");
                propertiesConfiguration.clearProperty((String)objectArray[0] + ".address");
                propertiesConfiguration.clearProperty((String)objectArray[0] + ".channel");
                propertiesConfiguration.clearProperty((String)objectArray[0] + ".type");
                propertiesConfiguration.clearProperty((String)objectArray[0] + ".serial_number");
                propertiesConfiguration.clearProperty((String)objectArray[0] + ".using_status");
                propertiesConfiguration.save();
                break;
            }
        }
        catch (Exception exception) {
            log.error((Object)"\u5220\u9664LoRa\u8bbe\u5907\u65f6\u53d1\u751f\u5f02\u5e38", (Throwable)exception);
            throw exception;
        }
    }

    public boolean sendMessage(OutboundMessage outboundMessage) {
        String string = outboundMessage.getUsingPortID();
        SerialPort serialPort = this.getSerialPort(string);
        LoraBean loraBean = this.findDeviceByPortID(string);
        try {
            if (LoRaDriver.readPortInputBufferUsedSize(serialPort) == -1) {
                log.error((Object)("\u8bbe\u5907" + loraBean.getGatewayID() + "\u6389\u7ebf\u4e86\uff01"));
                loraBean.setUsingStatus("2");
                WatchDog.getInstance().interrupt();
                return false;
            }
        }
        catch (Exception exception) {
            log.error((Object)("\u8bbe\u5907" + loraBean.getGatewayID() + "\u6389\u7ebf\u4e86\uff01"));
            log.error((Object)"\u8bbe\u5907\u8fde\u63a5\u5f02\u5e38\uff0c\u5373\u5c06\u91cd\u542f\uff01\u3010sendMessage\u3011");
            loraBean.setUsingStatus("2");
            WatchDog.getInstance().interrupt();
            return false;
        }
        outboundMessage.setGatewayId(loraBean.getGatewayID());
        String string2 = outboundMessage.getText();
        Date date = outboundMessage.getDispatchDate();
        if (date == null) {
            date = new Date();
        }
        String string3 = outboundMessage.getRecipient().toUpperCase();
        String string4 = this.findDeviceByPortID(string).getChannel();
        int n = string2.length();
        this.updateFragmentationLengthByEncodingType(outboundMessage.getEncoding());
        int n2 = n / MESSAGE_TEXT_LENGTH;
        if (n % MESSAGE_TEXT_LENGTH != 0) {
            ++n2;
        }
        int n3 = outboundMessage.getMessageID();
        if (n <= MESSAGE_TEXT_LENGTH) {
            String string5 = this.getMessageIdentificationStr(n3, 1, 1);
            boolean bl = this.sendMessage(string, string3, string4, string2, outboundMessage.getEncoding(), string5, date);
            if (!bl) {
                log.error((Object)(string2 + "\u53d1\u9001\u5931\u8d25.."));
                return false;
            }
        } else {
            int n4 = 0;
            for (int i = 0; i < string2.length(); i += MESSAGE_TEXT_LENGTH) {
                boolean bl;
                String string6 = "";
                String string7 = this.getMessageIdentificationStr(n3, n2, ++n4);
                if (i + MESSAGE_TEXT_LENGTH < n) {
                    string6 = string2.substring(i, i + MESSAGE_TEXT_LENGTH);
                    bl = this.sendMessage(string, string3, string4, string6, outboundMessage.getEncoding(), string7, date);
                    if (bl) continue;
                    log.error((Object)(string2 + "\u53d1\u9001\u5931\u8d25.."));
                    return false;
                }
                string6 = string2.substring(i, string2.length());
                bl = this.sendMessage(string, string3, string4, string6, outboundMessage.getEncoding(), string7, date);
                if (bl) continue;
                log.error((Object)(string2 + "\u53d1\u9001\u5931\u8d25.."));
                return false;
            }
        }
        return true;
    }

    private void updateFragmentationLengthByEncodingType(Message.MessageEncodings messageEncodings) {
        switch (messageEncodings) {
            case ENC7BIT: {
                MESSAGE_TEXT_LENGTH = 32;
                break;
            }
            case ENC8BIT: {
                MESSAGE_TEXT_LENGTH = 32;
                break;
            }
            case ENCUCS2: {
                MESSAGE_TEXT_LENGTH = 10;
                break;
            }
        }
    }

    private String getOriginator(String string) {
        if (string == null) {
            return "0000";
        }
        for (int i = 0; i < this.devices.size(); ++i) {
            if (!this.devices.get(i).getPortID().equals(string)) continue;
            return this.complementStr(this.devices.get(i).getAddress(), 4);
        }
        return null;
    }

    private boolean sendMessage(String string, String string2, String string3, String string4, Message.MessageEncodings messageEncodings, String string5, Date date) {
        byte[] byArray;
        SerialPort serialPort;
        PropertiesConfiguration propertiesConfiguration = JDSMSServer.getInstance().getProperties();
        String string6 = this.findDeviceByPortID(string).getGatewayID();
        if (des == null) {
            try {
                des = new DesUtils(propertiesConfiguration.getString("settings.secretkey", "B123KLF3AB12"));
            }
            catch (Exception exception) {
                log.error((Object)"\u52a0\u5bc6\u89e3\u5bc6\u5de5\u5177\u5b9e\u4f53\u5316\u5931\u8d25", (Throwable)exception);
            }
        }
        if ((serialPort = this.getSerialPort(string)) == null || !serialPort.isOpened()) {
            log.error((Object)("\u7aef\u53e3" + string + "\u672a\u6253\u5f00\uff0c\u8bf7\u786e\u8ba4\u8bbe\u5907\u662f\u5426\u6b63\u5e38\u8fde\u63a5\u3002\u3002\u3002"));
            return false;
        }
        string5 = string5.toUpperCase();
        String string7 = this.complementStr(dateFormat.format(date).trim(), 14);
        String string8 = this.getOriginator(string);
        try {
            byArray = des.encrypt(this.getByteByEncodingType(string4, messageEncodings));
        }
        catch (Exception exception) {
            log.error((Object)("\u4fe1\u606f\u52a0\u5bc6\u5931\u8d25:" + string4), (Throwable)exception);
            return false;
        }
        String string9 = this.complementStr(Integer.toHexString(16 + byArray.length), 2).toUpperCase();
        String string10 = this.getCodingType(messageEncodings);
        byte[] byArray2 = LoRaDriver.compressHexStr(MESSAGE_HEADER_HEX_STR + string9 + string5 + string8 + string7 + string10);
        byte[] byArray3 = new byte[byArray2.length + byArray.length];
        System.arraycopy(byArray2, 0, byArray3, 0, byArray2.length);
        System.arraycopy(byArray, 0, byArray3, byArray2.length, byArray.length);
        byte[] byArray4 = this.hexStringToByte(string2 + string3);
        byte[] byArray5 = new byte[byArray3.length + byArray4.length];
        System.arraycopy(byArray4, 0, byArray5, 0, byArray4.length);
        System.arraycopy(byArray3, 0, byArray5, byArray4.length, byArray3.length);
        try {
            if (!this.portOutputBufferIsEmpty(serialPort)) {
                return false;
            }
            boolean bl = this.writePort(serialPort, byArray5);
            if (!bl) {
                return false;
            }
            if (!this.portOutputBufferIsEmpty(serialPort)) {
                return false;
            }
            try {
                Thread.sleep(propertiesConfiguration.getInt("settings.lora_outbound_slip_interval", 3) * 1000);
            }
            catch (InterruptedException interruptedException) {}
        }
        catch (SerialPortException serialPortException) {
            log.error((Object)("\u8bbe\u5907" + string6 + "\u53d1\u9001\u4fe1\u606f" + byArray3 + "\u5931\u8d25:" + string4), (Throwable)serialPortException);
            return false;
        }
        log.info((Object)("\u8bbe\u5907" + string6 + "\u53d1\u9001\u4fe1\u606f\u6210\u529f\u3002\u5185\u5bb9 \uff1a" + string4));
        log.info((Object)("\u4fe1\u606f\u7f16\u7801\uff1a " + this.byteArrayToHexStr(byArray3)));
        return true;
    }

    private boolean portOutputBufferIsEmpty(SerialPort serialPort) throws SerialPortException {
        int n = this.readPortOutputBufferUsedSize(serialPort);
        int n2 = 0;
        while (n != 0 && n != -1) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (++n2 > 50) {
                log.error((Object)"\u53d1\u9001\u7f13\u51b2\u533a\u6e05\u7a7a\u5931\u8d25\uff01");
                return false;
            }
            log.info((Object)("\u53d1\u9001\u7f13\u51b2\u533a\u88ab\u5360\u7528\uff1a" + n));
            n = this.readPortOutputBufferUsedSize(serialPort);
        }
        if (n == -1) {
            log.error((Object)("\u7aef\u53e3" + serialPort.getPortName() + "\u672a\u6253\u5f00\uff0c\u8bf7\u786e\u8ba4\u8bbe\u5907\u662f\u5426\u6b63\u5e38\u8fde\u63a5\u3002\u3002\u3002."));
            return false;
        }
        return true;
    }

    private String getCodingType(Message.MessageEncodings messageEncodings) {
        switch (messageEncodings) {
            case ENC7BIT: {
                return ENCODING_IN_7BIT;
            }
            case ENC8BIT: {
                return ENCODING_IN_8BIT;
            }
            case ENCUCS2: {
                return ENCODING_IN_UFT8;
            }
        }
        return ENCODING_IN_UFT8;
    }

    private Message.MessageEncodings getCodingType(String string) {
        if (ENCODING_IN_7BIT.equals(string)) {
            return Message.MessageEncodings.ENC7BIT;
        }
        if (ENCODING_IN_8BIT.equals(string)) {
            return Message.MessageEncodings.ENC8BIT;
        }
        if (ENCODING_IN_UFT8.equals(string)) {
            return Message.MessageEncodings.ENCUCS2;
        }
        return Message.MessageEncodings.ENCUCS2;
    }

    private byte[] getByteByEncodingType(String string, Message.MessageEncodings messageEncodings) throws UnsupportedEncodingException {
        switch (messageEncodings) {
            case ENC7BIT: {
                return PduUtils.encode7bitUserData(null, string.getBytes("US-ASCII"));
            }
            case ENC8BIT: {
                return PduUtils.encode8bitUserData(string);
            }
            case ENCUCS2: {
                return string.getBytes("UTF-8");
            }
        }
        return string.getBytes("UTF-8");
    }

    public void sendMessages(List<OutboundMessage> list) {
        for (int i = 0; i < list.size(); ++i) {
            boolean bl = this.sendMessage(list.get(i));
            if (!bl) continue;
            list.get(i).setMessageStatus(OutboundMessage.MessageStatuses.SENT);
        }
    }

    public LoraBean getPointedSerialLoraBean(String string) {
        for (int i = 0; i < this.devices.size(); ++i) {
            if (!this.devices.get(i).getPortID().equals(string)) continue;
            return this.devices.get(i);
        }
        return null;
    }

    private byte[] hexStringToByte(String string) {
        int n = string.length() / 2;
        byte[] byArray = new byte[n];
        char[] cArray = string.toCharArray();
        for (int i = 0; i < n; ++i) {
            int n2 = i * 2;
            byArray[i] = (byte)(this.toByte(cArray[n2]) << 4 | this.toByte(cArray[n2 + 1]));
        }
        return byArray;
    }

    private int toByte(char c) {
        byte by = (byte)"0123456789ABCDEF".indexOf(c);
        return by;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getDeviceInfo(SerialPort serialPort) {
        SerialPort serialPort2 = serialPort;
        synchronized (serialPort2) {
            try {
                this.writePort(serialPort, this.hexStringToByte("C1C1C1"));
            }
            catch (SerialPortException serialPortException) {
                log.error((Object)"\u4e32\u53e3\u901a\u4fe1(\u5199)\u5f02\u5e38\u3002\u8bf7\u786e\u8ba4\u8bbe\u5907\u662f\u5426\u6b63\u5e38\u8fde\u63a5\u3002\u3002\u3002", (Throwable)serialPortException);
                return "";
            }
            PropertiesConfiguration propertiesConfiguration = JDSMSServer.getInstance().getProperties();
            try {
                Thread.sleep(propertiesConfiguration.getInt("settings.lora_wait_response", 1000));
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            String string = "";
            try {
                string = this.readPortInHexStr(serialPort);
            }
            catch (SerialPortException serialPortException) {
                log.error((Object)"\u4e32\u53e3\u901a\u4fe1(\u8bfb)\u5f02\u5e38\u3002\u8bf7\u786e\u8ba4\u8bbe\u5907\u662f\u5426\u6b63\u5e38\u8fde\u63a5\u3002\u3002\u3002", (Throwable)serialPortException);
            }
            if (null == string || "".equals(string)) {
                log.info((Object)("\u7aef\u53e3" + serialPort.getPortName() + "\u672a\u5904\u4e8e\u4f11\u7720\u72b6\u6001"));
                return "";
            }
            log.info((Object)("\u7aef\u53e3" + serialPort.getPortName() + "\u53ef\u80fd\u5904\u4e8e\u4f11\u7720\u72b6\u6001\u6216\u8005\u8be5\u7aef\u53e3\u6b63\u5728\u63a5\u6536\u4fe1\u606f\u3002"));
            log.info((Object)("\u7aef\u53e3" + serialPort.getPortName() + "\u8fd4\u56de\u7684\u4fe1\u606f:" + string));
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String checkDeviceMode(SerialPort serialPort) {
        if (serialPort == null) {
            return "ERROR2";
        }
        SerialPort serialPort2 = serialPort;
        synchronized (serialPort2) {
            PropertiesConfiguration propertiesConfiguration = JDSMSServer.getInstance().getProperties();
            try {
                if (!serialPort.isOpened()) {
                    serialPort.openPort();
                    serialPort.setFlowControlMode(0);
                    serialPort.setParams(this.getbaudrate(serialPort.getPortName()), 8, 1, 0);
                }
                this.writePort(serialPort, this.hexStringToByte("C1C1C1"));
                try {
                    Thread.sleep(propertiesConfiguration.getInt("settings.lora_wait_response", 1000));
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                String string = this.readPortInHexStr(serialPort);
                serialPort.closePort();
                if (string != null && !string.trim().equals("")) {
                    return "ERROR1";
                }
            }
            catch (SerialPortException serialPortException) {
                log.error((Object)"\u4e32\u53e3\u901a\u4fe1(\u5199)\u5f02\u5e38\u3002\u8bf7\u786e\u8ba4\u8bbe\u5907\u662f\u5426\u6b63\u5e38\u8fde\u63a5\u3002\u3002\u3002", (Throwable)serialPortException);
                try {
                    serialPort.closePort();
                }
                catch (SerialPortException serialPortException2) {
                    log.error((Object)"\u68c0\u6d4b\u8bbe\u5907\u65f6\uff0c\u7aef\u53e3\u5173\u95ed\u5f02\u5e38\u3002\u3002\u3002", (Throwable)serialPortException);
                    return "ERROR2";
                }
                return "ERROR2";
            }
            return "OK";
        }
    }

    public void readLoraMessages() {
        PropertiesConfiguration propertiesConfiguration = JDSMSServer.getInstance().getProperties();
        if (des == null) {
            try {
                des = new DesUtils(propertiesConfiguration.getString("settings.secretkey", "B123KLF3AB12"));
            }
            catch (Exception exception) {
                log.error((Object)"\u83b7\u53d6\u5bc6\u94a5\u5931\u8d25..", (Throwable)exception);
            }
        }
        List<LoraBean> list = this.getUsingLoras();
        for (int i = 0; i < list.size(); ++i) {
            if (this.checkStopLoras(list.get(i).getPortID())) {
                log.error((Object)("\u8bbe\u5907" + list.get(i).getGatewayID() + "\u672a\u542f\u7528\u3002"));
                continue;
            }
            byte[] byArray = null;
            try {
                boolean bl = this.checkAuthorizeInfo(list.get(i).getPortID(), null);
                if (!bl) continue;
                log.debug((Object)(list.get(i).getGatewayID() + "\u6b63\u5728\u63a5\u6536\u77ed\u4fe1..."));
                SerialPort serialPort = this.getSerialPort(list.get(i).getPortID());
                if (LoRaDriver.readPortInputBufferUsedSize(serialPort) == -1) {
                    log.error((Object)("\u8bbe\u5907" + list.get(i).getGatewayID() + "\u6389\u7ebf\u4e86\uff01"));
                    list.get(i).setUsingStatus("2");
                    WatchDog.getInstance().interrupt();
                    continue;
                }
                byArray = this.readPortInByteArray(serialPort);
                if (byArray == null || byArray.length == 0) {
                    log.debug((Object)("\u8bbe\u5907" + list.get(i).getGatewayID() + "\u6ca1\u6709\u6536\u5230\u4fe1\u606f"));
                    continue;
                }
                if (!this.isReceivedMessageCompleted(byArray)) {
                    log.info((Object)"\u5c1d\u8bd5\u8bfb\u53d6\u672a\u63a5\u6536\u5b8c\u7684\u4fe1\u606f...");
                    byArray = this.getCompleteMessage(byArray, this.getSerialPort(list.get(i).getPortID()));
                }
            }
            catch (SerialPortException serialPortException) {
                log.error((Object)("\u8bfb\u4e32\u53e3" + list.get(i).getPortID() + "\u5931\u8d25.."), (Throwable)serialPortException);
            }
            log.info((Object)("\u8bbe\u5907" + list.get(i).getGatewayID() + "\u6536\u5230\u7f16\u7801\u4fe1\u606f\uff1a" + this.byteArrayToHexStr(byArray)));
            List<String> list2 = this.getReceiveBytesInStr(byArray);
            if (list2.isEmpty()) {
                log.info((Object)"\u4fe1\u606f\u89e3\u7801\u540e\u4e3a\u7a7a");
            }
            for (int j = 0; j < list2.size(); ++j) {
                String string = list2.get(j);
                log.info((Object)("\u8bbe\u5907" + list.get(i).getGatewayID() + "\u6536\u5230\u4fe1\u606f\uff1a" + list2.get(j)));
                if (string == null || string.equals("")) continue;
                try {
                    this.addInMessage(new Date(), "", string, list.get(i).getGatewayID(), list.get(i).getSerialNumber());
                    continue;
                }
                catch (Exception exception) {
                    log.error((Object)"\u6dfb\u52a0\u4fe1\u606f\u5931\u8d25\u3002\u3002\u3002");
                }
            }
        }
    }

    private boolean isReceivedMessageCompleted(byte[] byArray) {
        int n;
        int n2 = 19;
        if (byArray.length <= n2) {
            log.error((Object)("\u4fe1\u606f\u3010" + this.byteArrayToHexStr(byArray) + "\u3011\u672a\u63a5\u6536\u5b8c(\u4fe1\u606f\u957f\u5ea6\u5c0f\u4e8e17\u4e2a\u5b57\u8282)\u3002\u3002\u3002"));
            return false;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (n = 0; n < byArray.length; ++n) {
            if (byArray[n] != -1 || n + 1 >= byArray.length || byArray[n + 1] != -1 || n + 2 >= byArray.length || byArray[n + 2] == -1) continue;
            arrayList.add(n);
        }
        n = byArray.length;
        for (int i = 0; i < arrayList.size(); ++i) {
            String string = "";
            int n3 = (Integer)arrayList.get(i);
            n = i + 1 < arrayList.size() ? (Integer)arrayList.get(i + 1) : byArray.length;
            byte[] byArray2 = new byte[n - n3];
            byte[] byArray3 = new byte[n2];
            try {
                System.arraycopy(byArray, n3, byArray2, 0, byArray2.length);
                if (n - n3 <= n2) {
                    log.error((Object)("\u4fe1\u606f\u3010" + this.byteArrayToHexStr(byArray2) + "\u3011\u672a\u63a5\u6536\u5b8c(\u4fe1\u606f\u957f\u5ea6\u5c0f\u4e8e17\u4e2a\u5b57\u8282)\u3002\u3002\u3002"));
                    return false;
                }
                System.arraycopy(byArray2, 0, byArray3, 0, byArray3.length);
                string = LoRaDriver.decompressByteArray(byArray3, 0, byArray3.length).substring(4);
                int n4 = Integer.valueOf(string.substring(0, 2), 16);
                if (byArray2.length - 3 == n4) continue;
                log.error((Object)("\u4fe1\u606f\u3010" + this.byteArrayToHexStr(byArray2) + "\u3011\u672a\u63a5\u6536\u5b8c(\u63a5\u6536\u5230\u4fe1\u606f\u7684\u957f\u5ea6\u548c\u671f\u5f85\u957f\u5ea6\u4e0d\u4e00\u81f4)\u3002\u3002\u3002" + "\u5b9e\u9645\u957f\u5ea6\uff1a" + (byArray2.length - 3) + "\u671f\u5f85\u957f\u5ea6\uff1a" + n4));
                return false;
            }
            catch (Exception exception) {
                log.error((Object)("\u4fe1\u606f\u3010" + this.byteArrayToHexStr(byArray2) + "\u3011\u672a\u63a5\u6536\u5b8c(\u51fa\u73b0\u5f02\u5e38\u3002\u3002\u3002)"), (Throwable)exception);
                return false;
            }
        }
        return true;
    }

    private byte[] getCompleteMessage(byte[] byArray, SerialPort serialPort) {
        byte[] byArray2 = new byte[1024];
        byte[] byArray3 = null;
        int n = 0;
        int n2 = byArray.length;
        System.arraycopy(byArray, 0, byArray2, n, byArray.length);
        n += byArray.length;
        int n3 = 1;
        do {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            log.info((Object)("\u7b2c" + n3 + "\u6b21\u7b49\u5f85.."));
            try {
                if (LoRaDriver.readPortInputBufferUsedSize(serialPort) == -1) {
                    log.error((Object)("\u8bbe\u5907" + serialPort.getPortName() + "\u6389\u7ebf\uff0c" + this.byteArrayToHexStr(byArray3) + "\u4e22\u5931\u4e86\uff01"));
                    return byArray3;
                }
                byte[] byArray4 = this.readPortInByteArray(serialPort);
                if (byArray4 != null && byArray4.length != 0) {
                    System.arraycopy(byArray4, 0, byArray2, n, byArray4.length);
                    n += byArray4.length;
                    n2 += byArray4.length;
                }
            }
            catch (Exception exception) {
                log.error((Object)("\u8bfb\u7aef\u53e3" + serialPort.getPortName() + "\u5f02\u5e38\u3002\u3002\u3002"), (Throwable)exception);
            }
            byArray3 = new byte[n2];
            System.arraycopy(byArray2, 0, byArray3, 0, n2);
            if (!this.isReceivedMessageCompleted(byArray3)) continue;
            log.info((Object)("\u6536\u5230\u5b8c\u6574\u7684\u7f16\u7801\u4fe1\u606f\uff1a" + this.byteArrayToHexStr(byArray3)));
            return byArray3;
        } while (++n3 < 10);
        log.error((Object)(this.byteArrayToHexStr(byArray3) + "\u4e22\u5931\u4e86\uff01"));
        byArray3 = null;
        return byArray3;
    }

    private List<String> getReceiveBytesInStr(byte[] byArray) {
        int n;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (byArray == null) {
            return arrayList;
        }
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        for (n = 0; n < byArray.length; ++n) {
            if (byArray[n] != -1 || n + 1 >= byArray.length || byArray[n + 1] != -1 || n + 2 >= byArray.length || byArray[n + 2] == -1) continue;
            arrayList2.add(n);
        }
        n = byArray.length;
        int n2 = 19;
        for (int i = 0; i < arrayList2.size(); ++i) {
            byte[] byArray2;
            StringBuffer stringBuffer;
            String string;
            String string2;
            block10: {
                string2 = "";
                string = "";
                stringBuffer = new StringBuffer();
                int n3 = (Integer)arrayList2.get(i);
                n = i + 1 < arrayList2.size() ? (Integer)arrayList2.get(i + 1) : byArray.length;
                byArray2 = new byte[n - n3];
                byte[] byArray3 = new byte[n2];
                try {
                    System.arraycopy(byArray, n3, byArray2, 0, byArray2.length);
                    if (n - n3 <= n2) {
                        log.error((Object)("\u4fe1\u606f\u3010" + this.byteArrayToHexStr(byArray2) + "\u3011\u6709\u4e22\u5931(1)"));
                        continue;
                    }
                    System.arraycopy(byArray2, 0, byArray3, 0, byArray3.length);
                    string2 = LoRaDriver.decompressByteArray(byArray3, 0, byArray3.length).substring(4);
                    int n4 = Integer.valueOf(string2.substring(0, 2), 16);
                    string2 = string2.substring(2);
                    if (byArray2.length - 3 != n4) {
                        log.error((Object)("\u4fe1\u606f\u3010" + this.byteArrayToHexStr(byArray2) + "\u3011\u6709\u4e22\u5931(2)"));
                        continue;
                    }
                    string = string2.substring(string2.length() - 2);
                    if (!(string.equals(ENCODING_IN_7BIT) || string.equals(ENCODING_IN_8BIT) || string.equals(ENCODING_IN_UFT8))) {
                        log.error((Object)("\u4fe1\u606f\u3010" + this.byteArrayToHexStr(byArray2) + "\u7684\u7f16\u7801\u683c\u5f0f\u4e0d\u660e\u3002\u3002\u3002"));
                    }
                    break block10;
                }
                catch (Exception exception) {
                    log.error((Object)("\u4fe1\u606f\u3010" + this.byteArrayToHexStr(byArray2) + "\u3011\u6709\u4e22\u5931(4)"), (Throwable)exception);
                }
                continue;
            }
            try {
                byte[] byArray4 = new byte[byArray2.length - n2];
                System.arraycopy(byArray2, n2, byArray4, 0, byArray4.length);
                byte[] byArray5 = des.decrypt(byArray4);
                String string3 = "";
                string3 = string.equals(ENCODING_IN_7BIT) ? PduUtils.decode7bitEncoding(byArray5) : (string.equals(ENCODING_IN_8BIT) ? PduUtils.decode8bitEncoding(null, byArray5) : new String(byArray5, "UTF-8"));
                stringBuffer.append(string2);
                stringBuffer.append(string3);
            }
            catch (Exception exception) {
                log.error((Object)("\u4fe1\u606f\u3010" + this.byteArrayToHexStr(byArray2) + "\u3011" + "\u89e3\u5bc6\u5931\u8d25"), (Throwable)exception);
                continue;
            }
            arrayList.add(stringBuffer.toString());
        }
        return arrayList;
    }

    public boolean checkAuthorizeInfo(String string, OutboundMessage outboundMessage) {
        String string2 = this.findDeviceByPortID(string).getGatewayID();
        String string3 = this.findDeviceByPortID(string).getSerialNumber();
        try {
            boolean bl = this.findDeviceByPortID(string).isValidate();
            if (!bl) {
                if (outboundMessage != null) {
                    outboundMessage.setText("<\u8bf7\u586b\u5199\u8bbe\u5907\u6ce8\u518c\u7801>" + outboundMessage.getText());
                }
                int n = NewAuth.getAvaliableNum(string3);
                log.info((Object)("\u8bbe\u5907\u672a\u6388\u6743\uff0c\u8fd8\u53ef\u6536\u53d1" + n + "\u6761\u77ed\u4fe1" + string2));
                if (n < 1) {
                    log.warn((Object)("\u8bbe\u5907\u672a\u6388\u6743\uff0c\u6536\u53d1\u4fe1\u606f\u6761\u6570\u5df2\u8fbe\u5230\u6700\u5927\u9650\u5236\u657088\u6761,\u5df2\u505c\u6b62\u6536\u53d1\u4fe1\u606f" + string2));
                    return false;
                }
            }
        }
        catch (Exception exception) {
            log.info((Object)("\u83b7\u53d6\u8bbe\u5907\u6388\u6743\u4fe1\u606f\u5931\u8d25\uff1a" + string2), (Throwable)exception);
            return false;
        }
        return true;
    }

    public void saveConfigInfo(LoraBean loraBean) throws ConfigurationException {
        PropertiesConfiguration propertiesConfiguration = JDSMSServer.getInstance().getProperties();
        Configuration configuration = JDSMSServer.getInstance().getProperties().subset("loraDevice");
        int n = 0;
        boolean bl = false;
        Iterator iterator = configuration.getKeys();
        while (iterator.hasNext()) {
            String string = configuration.getString((String)iterator.next());
            if (!string.startsWith(loraBean.getGatewayID())) continue;
            bl = true;
            break;
        }
        if (!bl) {
            while (n < 64) {
                if (JDSMSServer.getInstance().getProperties().getString("loraDevice." + n, "").length() == 0) {
                    propertiesConfiguration.setProperty("loraDevice." + n, (Object)(loraBean.getGatewayID() + ",LoRa"));
                    break;
                }
                ++n;
            }
        }
        propertiesConfiguration.setProperty(loraBean.getGatewayID() + ".port", (Object)loraBean.getPortID());
        propertiesConfiguration.setProperty(loraBean.getGatewayID() + ".baudrate", (Object)loraBean.getBaudrate());
        propertiesConfiguration.setProperty(loraBean.getGatewayID() + ".address", (Object)loraBean.getAddress());
        propertiesConfiguration.setProperty(loraBean.getGatewayID() + ".channel", (Object)loraBean.getChannel());
        propertiesConfiguration.setProperty(loraBean.getGatewayID() + ".type", (Object)loraBean.getDeviceType());
        propertiesConfiguration.setProperty(loraBean.getGatewayID() + ".serial_number", (Object)loraBean.getSerialNumber());
        propertiesConfiguration.setProperty(loraBean.getGatewayID() + ".using_status", (Object)loraBean.getUsingStatus());
        propertiesConfiguration.save();
    }

    public LoraBean findDeviceByPortID(String string) {
        List<LoraBean> list = this.getAll();
        for (int i = 0; i < list.size(); ++i) {
            if (!list.get(i).getPortID().equals(string)) continue;
            return list.get(i);
        }
        return null;
    }

    public LoraBean findDeviceByGatewayID(String string) {
        List<LoraBean> list = this.getAll();
        for (int i = 0; i < list.size(); ++i) {
            if (!list.get(i).getGatewayID().equals(string)) continue;
            return list.get(i);
        }
        return null;
    }

    public String getPortIDByLoop(OutboundMessage outboundMessage) {
        if (this.getUsingLoraList().isEmpty()) {
            return "";
        }
        String string = outboundMessage.getGatewayId();
        String string2 = outboundMessage.getRecipient();
        if (string == null || string.equals("")) {
            return "";
        }
        if (string2 == null || string2.equals("")) {
            return "";
        }
        int n = 0;
        if ("@".equals(string)) {
            while (true) {
                ++loop;
                if (++n > this.devices.size()) {
                    log.error((Object)"\u6ca1\u6709\u627e\u5230\u53ef\u7528\u7684\u7aef\u53e3");
                    return "";
                }
                if (loop < this.devices.size()) {
                    if (!this.devices.get(loop).getUsingStatus().equals("1") || this.devices.get(loop).getAddress().equals(string2)) continue;
                    return this.devices.get(loop).getPortID();
                }
                loop = 0;
                if (this.devices.get(loop).getUsingStatus().equals("1") && !this.devices.get(loop).getAddress().equals(string2)) break;
            }
            return this.devices.get(loop).getPortID();
        }
        for (int i = 0; i < this.devices.size(); ++i) {
            LoraBean loraBean = this.devices.get(i);
            if (loraBean.getGatewayID().equals(string) && !loraBean.getAddress().equals(string2)) {
                return loraBean.getPortID();
            }
            if (loraBean.getAddress().equals(string2)) {
                log.error((Object)("LoRa\u4e0d\u652f\u6301\u7ed9\u81ea\u8eab\u53d1\u9001\u4fe1\u606f\u3002\u3002\u3002" + outboundMessage.getGatewayId()));
                continue;
            }
            log.error((Object)("\u8bbe\u5907" + outboundMessage.getGatewayId() + "\u672a\u542f\u7528\u6216\u8005\u4e0d\u5b58\u5728\u3002\u3002\u3002"));
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readPortInHexStr(SerialPort serialPort) throws SerialPortException {
        SerialPort serialPort2 = serialPort;
        synchronized (serialPort2) {
            if (serialPort.isOpened()) {
                return serialPort.readHexString();
            }
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readPortInByteArray(SerialPort serialPort) throws SerialPortException {
        SerialPort serialPort2 = serialPort;
        synchronized (serialPort2) {
            if (serialPort.isOpened()) {
                return serialPort.readBytes();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writePort(SerialPort serialPort, byte[] byArray) throws SerialPortException {
        SerialPort serialPort2 = serialPort;
        synchronized (serialPort2) {
            if (serialPort.isOpened()) {
                return serialPort.writeBytes(byArray);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readPortOutputBufferUsedSize(SerialPort serialPort) throws SerialPortException {
        LoraBean loraBean = this.findDeviceByPortID(serialPort.getPortName());
        SerialPort serialPort2 = serialPort;
        synchronized (serialPort2) {
            if ("0".equals(loraBean.getUsingStatus())) {
                return 0;
            }
            if (serialPort.isOpened()) {
                return serialPort.getOutputBufferBytesCount();
            }
            return -1;
        }
    }

    private String getMessageIdentificationStr(int n, int n2, int n3) {
        String string = Integer.toHexString(n);
        string = this.complementStr(string, 8);
        String string2 = Integer.toHexString(n2);
        string2 = this.complementStr(string2, 2);
        String string3 = Integer.toHexString(n3);
        string3 = this.complementStr(string3, 2);
        return string + string2 + string3;
    }

    private String complementStr(String string, int n) {
        int n2 = string.length();
        if (n2 > n) {
            return string.substring(n2 - n);
        }
        if (n2 == n) {
            return string;
        }
        for (int i = 0; i < n - n2; ++i) {
            string = "0" + string;
        }
        return string;
    }

    public ArrayList<InboundMessage> getMessages(List<TmpMsg> list) {
        Object object;
        Object object2;
        String string;
        int n = 32;
        ArrayList<InboundMessage> arrayList = new ArrayList<InboundMessage>();
        for (int i = 0; i < list.size(); ++i) {
            AbstractCollection abstractCollection;
            Map.Entry<String, String> entry = list.get(i);
            String object32 = ((TmpMsg)((Object)entry)).getPdustring();
            if (((TmpMsg)((Object)entry)).getMemindex() != 0 || Utils.isEmptyStr(((TmpMsg)((Object)entry)).getMemlocation()) || !"LR".equals(((TmpMsg)((Object)entry)).getMemlocation()) || ((TmpMsg)((Object)entry)).getMl() != 0) continue;
            if (object32.length() <= n) {
                Utils.deleteTmpmsg(((TmpMsg)((Object)entry)).getPdustring(), "LR");
                continue;
            }
            string = list.get(i).getPdustring().substring(0, n);
            if (!string.matches("[A-F,0-9]+")) {
                Utils.deleteTmpmsg(((TmpMsg)((Object)entry)).getPdustring(), "LR");
                continue;
            }
            int n2 = 0;
            int n3 = n2 + 8 + 4;
            object2 = object32.substring(n2, n3);
            object = ((String)object2).substring(0, 8);
            String string2 = object32.substring(12, 16);
            String string3 = (String)object + string2;
            String string4 = ((String)object2).substring(8, 10);
            String string5 = ((String)object2).substring(10);
            String string6 = object32.substring(16, 30);
            if (!messageIDWaitTimesMap.containsKey(string3)) {
                messageIDWaitTimesMap.put(string3, string6);
            }
            int n4 = -1;
            try {
                n4 = Integer.valueOf(string5, 16);
            }
            catch (NumberFormatException numberFormatException) {
                log.error((Object)("\u6536\u5230\u7684\u4fe1\u606f\uff1a" + object32), null);
                Utils.deleteTmpmsg(((TmpMsg)((Object)entry)).getPdustring(), "LR");
                continue;
            }
            String string7 = object32.substring(n);
            String string8 = object32.substring(12, 30);
            String string9 = object32.substring(30, 32);
            string7 = string8 + string9 + string7;
            if (!messageIDMessageInfoMap.containsKey(string3)) {
                abstractCollection = this.getEmptyList(Integer.valueOf(string4, 16));
                try {
                    ((ArrayList)abstractCollection).set(n4, (String)string7);
                }
                catch (Exception exception) {
                    log.error((Object)("\u4fe1\u606f\u7247\u6bb5\u4fdd\u5b58\u5931\u8d25\uff1a" + string7));
                    log.error((Object)("\u4fe1\u5fc3\u7f16\u53f7\uff1a" + string3 + ": " + n4));
                }
                messageIDMessageInfoMap.put(string3, (ArrayList<String>)abstractCollection);
            } else {
                try {
                    messageIDMessageInfoMap.get(string3).set(n4, string7);
                }
                catch (Exception exception) {
                    log.error((Object)("\u4fe1\u606f\u7247\u6bb5\u4fdd\u5b58\u5931\u8d25\uff1a" + string7));
                    log.error((Object)("\u4fe1\u606f\u7f16\u53f7\uff1a" + string3 + ": " + n4));
                }
            }
            if (!messageIDExpectMessageNumMap.containsKey(string3)) {
                messageIDExpectMessageNumMap.put(string3, string4);
            }
            if (!messageIDRealMessageNumMap.containsKey(string3)) {
                abstractCollection = new HashSet();
                ((HashSet)abstractCollection).add((String)string5);
                messageIDRealMessageNumMap.put(string3, (HashSet<String>)abstractCollection);
                continue;
            }
            messageIDRealMessageNumMap.get(string3).add(string5);
        }
        for (Map.Entry<String, String> entry : messageIDExpectMessageNumMap.entrySet()) {
            String string10 = entry.getKey();
            string = entry.getValue();
            InboundMessage inboundMessage = new InboundMessage(string10);
            inboundMessage.setError(false);
            if (messageIDRealMessageNumMap.get(string10).size() != Integer.valueOf(string, 16).intValue()) {
                long l;
                if (!messageIDWaitTimesMap.containsKey(string10)) continue;
                String string11 = messageIDWaitTimesMap.get(string10);
                object2 = new Date();
                try {
                    object2 = dateFormat.parse(string11);
                }
                catch (ParseException parseException) {
                    log.error((Object)"\u65e5\u671f\u4fe1\u606f\u683c\u5f0f\u5f02\u5e38..\u3002", (Throwable)parseException);
                }
                object = new Date();
                int n5 = 5;
                try {
                    n5 = Integer.parseInt(JDSMSServer.getInstance().getProperties().getString("settings.recvdiff", "5"));
                }
                catch (Exception exception) {
                    log.error((Object)"\u3010settings.recvdiff\u3011\u8bbe\u5b9a\u5f02\u5e38\uff0c\u4f7f\u7528\u9ed8\u8ba4\u503c\uff1a5\uff08\u5c0f\u65f6\uff09\u3002");
                }
                if ((l = (((Date)object).getTime() - ((Date)object2).getTime()) / 3600000L) <= (long)n5) continue;
                inboundMessage.setError(true);
                arrayList.add(inboundMessage);
                continue;
            }
            arrayList.add(inboundMessage);
        }
        for (InboundMessage inboundMessage : arrayList) {
            string = inboundMessage.getMessageID();
            this.getMessage(messageIDMessageInfoMap.get(string), inboundMessage);
        }
        this.clearMap();
        return arrayList;
    }

    private ArrayList<String> getEmptyList(int n) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < n + 1; ++i) {
            arrayList.add("");
        }
        return arrayList;
    }

    private void getMessage(ArrayList<String> arrayList, InboundMessage inboundMessage) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = "00000000000000";
        String string2 = "";
        String string3 = "";
        for (int i = 0; i < arrayList.size(); ++i) {
            if ("".equals(arrayList.get(i)) && i != 0) {
                stringBuffer.append(LOST_MESSAGE_FRAGMENT);
                continue;
            }
            if (("".equals(arrayList.get(i)) || null == arrayList.get(i)) && i == 0) continue;
            stringBuffer.append(arrayList.get(i).substring(20));
            String string4 = arrayList.get(i).substring(4, 18);
            if (string.compareTo(string4) < 0) {
                try {
                    dateFormat.parse(string4);
                    string = string4;
                }
                catch (ParseException parseException) {
                    log.error((Object)"\u65e5\u671f\u4fe1\u606f\u683c\u5f0f\u5f02\u5e381\u3002", (Throwable)parseException);
                }
            }
            if (string2.equals("")) {
                string2 = arrayList.get(i).substring(0, 4);
            }
            if (!string3.equals("")) continue;
            int n = 18;
            string3 = arrayList.get(i).substring(n, n + 2);
        }
        inboundMessage.setOriginator(string2);
        Date date = new Date();
        try {
            date = dateFormat.parse(string);
        }
        catch (ParseException parseException) {
            log.error((Object)"\u65e5\u671f\u4fe1\u606f\u683c\u5f0f\u5f02\u5e382\u3002", (Throwable)parseException);
        }
        inboundMessage.setEncoding(this.getCodingType(string3));
        inboundMessage.setDate(date);
        inboundMessage.setText(stringBuffer.toString());
        inboundMessage.setMessageID(inboundMessage.getMessageID().substring(0, 8));
        inboundMessage.setGatewayId(messageIDReceiveDeviceIDMap.get(inboundMessage.getMessageID()));
    }

    public HashMap<String, String> updateReceiveDeviceID(List<InboundMessage> list) {
        Iterator<InboundMessage> iterator = list.iterator();
        int n = 32;
        while (iterator.hasNext()) {
            InboundMessage inboundMessage = iterator.next();
            if (inboundMessage.getText().length() <= n) {
                iterator.remove();
                continue;
            }
            int n2 = 0;
            int n3 = n2 + 8;
            String string = inboundMessage.getText().substring(n2, n3);
            if (!string.matches("[A-F,0-9]+")) {
                iterator.remove();
                continue;
            }
            if (!messageIDReceiveDeviceIDMap.containsKey(string)) {
                messageIDReceiveDeviceIDMap.put(string, inboundMessage.getGatewayId());
                continue;
            }
            String string2 = messageIDReceiveDeviceIDMap.get(string);
            if (string2 != null && !string2.equals("")) continue;
            messageIDReceiveDeviceIDMap.put(string, inboundMessage.getGatewayId());
        }
        return messageIDReceiveDeviceIDMap;
    }

    public void initForLoRa() {
        Object object;
        String string;
        String string2;
        Object object2;
        List<String> list;
        Object object3;
        PropertiesConfiguration propertiesConfiguration = JDSMSServer.getInstance().getProperties();
        String string3 = propertiesConfiguration.getString("settings.secretkey", "");
        if (null == string3 || "".equals(string3)) {
            string3 = RandomStringUtils.randomAlphanumeric((int)12);
            propertiesConfiguration.setProperty("settings.secretkey", (Object)string3);
            try {
                propertiesConfiguration.save();
            }
            catch (ConfigurationException configurationException) {
                log.error((Object)"\u83b7\u53d6\u5bc6\u94a5\u5931\u8d25", (Throwable)configurationException);
            }
        }
        serialPortList = new ArrayList();
        Configuration configuration = propertiesConfiguration.subset("loraDevice");
        Iterator iterator = configuration.getKeys();
        boolean bl = false;
        while (iterator.hasNext()) {
            object3 = (String)iterator.next();
            list = configuration.getString((String)object3);
            object2 = propertiesConfiguration.getString(list + ".port");
            int n = propertiesConfiguration.getInt(list + ".baudrate");
            string2 = propertiesConfiguration.getString(list + ".address");
            string = propertiesConfiguration.getString(list + ".channel");
            String string4 = propertiesConfiguration.getString(list + ".type");
            object = propertiesConfiguration.getString(list + ".serial_number");
            if (object == null || ((String)object).trim().equals("")) {
                bl = true;
            }
            String string5 = propertiesConfiguration.getString(list + ".using_status");
            LoraBean loraBean = new LoraBean();
            loraBean.setGatewayID((String)((Object)list));
            loraBean.setPortID((String)object2);
            loraBean.setBaudrate(n);
            loraBean.setAddress(string2);
            loraBean.setChannel(string);
            loraBean.setDeviceType(string4);
            loraBean.setSerialNumber((String)object);
            loraBean.setUsingStatus(string5);
            LoRaDriver.getInstance().addLora(loraBean);
        }
        object3 = this.getAll();
        list = new ArrayList();
        if (bl) {
            list = this.getSerialNumberList();
        }
        object2 = object3.iterator();
        while (object2.hasNext()) {
            LoraBean loraBean = (LoraBean)object2.next();
            string2 = loraBean.getSerialNumber();
            string = loraBean.getPortID();
            if (string2 == null || string2.equals("")) {
                string2 = this.getSerialNumber(string, list);
                loraBean.setSerialNumber(string2);
            }
            boolean bl2 = NewAuth.checkDeviceAuth(string2);
            loraBean.setValidate(bl2);
            if (bl2) {
                try {
                    NewAuth.updateAuthorizeTemp();
                }
                catch (Exception exception) {
                    log.error((Object)"\u66f4\u65b0\u6388\u6743\u4fe1\u606f\u5f02\u5e38\u3002", (Throwable)exception);
                }
                cn.sendsms.helper.Logger.getInstance().logInfo("\u8bbe\u5907\u6388\u6743\u6709\u6548", null, loraBean.getGatewayID());
            } else {
                try {
                    NewAuth.updateAuthorizeTemp();
                }
                catch (Exception exception) {
                    log.error((Object)"\u66f4\u65b0\u6388\u6743\u4fe1\u606f\u5f02\u5e38\u3002", (Throwable)exception);
                }
                cn.sendsms.helper.Logger.getInstance().logInfo("\u8bbe\u5907\u672a\u6388\u6743", null, loraBean.getGatewayID());
            }
            object = new SerialPort(loraBean.getPortID());
            try {
                if (!object.isOpened()) {
                    object.openPort();
                }
                object.setFlowControlMode(0);
                object.setParams(loraBean.getBaudrate(), 8, 1, 0);
                serialPortList.add((SerialPort)object);
                if (!loraBean.getUsingStatus().equals("0")) continue;
                object.closePort();
            }
            catch (SerialPortException serialPortException) {
                log.error((Object)"\u4ece\u914d\u7f6e\u6587\u4ef6\u4e2d\u8bfb\u53d6\u7684\u8bbe\u5907\u521d\u59cb\u5316\u5931\u8d25\u3002\u3002\u3002", null);
                loraBean.setUsingStatus("0");
            }
        }
    }

    private void clearMap() {
        messageIDWaitTimesMap.clear();
        messageIDReceiveDeviceIDMap.clear();
        messageIDMessageInfoMap.clear();
        messageIDMessageInfoMap.clear();
        messageIDExpectMessageNumMap.clear();
        messageIDRealMessageNumMap.clear();
    }

    public boolean isWindowsOS() {
        PropertiesConfiguration propertiesConfiguration = JDSMSServer.getInstance().getProperties();
        String string = propertiesConfiguration.getString("settings.os_type", "");
        boolean bl = false;
        if (string == null || string.equals("")) {
            String string2 = System.getProperty("os.name");
            if (string2.toLowerCase().indexOf("windows") > -1) {
                bl = true;
            }
        } else if (string.equals("WIN")) {
            bl = true;
        }
        return bl;
    }

    public String getAddressByPortID(String string) {
        LoraBean loraBean = this.findDeviceByPortID(string);
        if (loraBean != null) {
            return loraBean.getAddress();
        }
        return "";
    }

    public int getbaudrate(String string) {
        LoraBean loraBean = this.findDeviceByPortID(string);
        if (loraBean != null) {
            return loraBean.getBaudrate();
        }
        return 9600;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getSerialNumberList() {
        Object object;
        ArrayList<String> arrayList = new ArrayList<String>();
        long l = System.currentTimeMillis();
        if (this.isWindowsOS()) {
            object = FileUtils.getFile((String[])new String[]{System.getProperty("user.dir"), "bin", "FT_Prog-CmdLine.exe"});
            if (!((File)object).exists()) {
                log.error((Object)(((File)object).getAbsolutePath() + "\u4e0d\u5b58\u5728\uff01"));
                return arrayList;
            }
            Process process = null;
            try {
                process = Runtime.getRuntime().exec(((File)object).getAbsolutePath() + " scan");
                process.waitFor();
                InputStream inputStream = process.getInputStream();
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                String string = null;
                while ((string = bufferedReader.readLine()) != null) {
                    if (!(string = string.replaceAll("\\s", "")).startsWith("Device") || !(string = string.substring(string.lastIndexOf(",") + 1)).startsWith(LORA_DEVICE_SERIAL_NUMBER)) continue;
                    arrayList.add(string.substring(string.lastIndexOf(",") + 1));
                }
            }
            catch (InterruptedException interruptedException) {
                log.error((Object)"\u7b49\u5f85\u8fd4\u56de\u7ed3\u679c\u65f6\u88ab\u6253\u65ad\u3002");
                ArrayList<String> arrayList2 = arrayList;
                return arrayList2;
            }
            catch (IOException iOException) {
                log.error((Object)"\u53d6\u5f97\u8bbe\u5907\u5e8f\u5217\u53f7\u65f6\u51fa\u9519");
                ArrayList<String> arrayList3 = arrayList;
                return arrayList3;
            }
            finally {
                if (process != null) {
                    process.destroy();
                }
            }
        }
        object = null;
        String[] stringArray = new String[]{"/bin/sh", "-c", "lsusb -v|grep iSerial"};
        try {
            object = Runtime.getRuntime().exec(stringArray);
            ((Process)object).waitFor();
            InputStream inputStream = ((Process)object).getInputStream();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            String string = null;
            while ((string = bufferedReader.readLine()) != null) {
                string = string.replace("iSerial", "");
                if ((string = string.replaceAll("\\s", "")).length() == 1 || !string.matches("[A-Z,0-9]+") || !(string = string.substring(1)).startsWith(LORA_DEVICE_SERIAL_NUMBER)) continue;
                arrayList.add(string);
            }
        }
        catch (InterruptedException interruptedException) {
            log.error((Object)"\u7b49\u5f85\u8fd4\u56de\u7ed3\u679c\u65f6\u88ab\u6253\u65ad\u3002");
            ArrayList<String> arrayList4 = arrayList;
            return arrayList4;
        }
        catch (IOException iOException) {
            log.error((Object)"\u53d6\u5f97\u8bbe\u5907\u5e8f\u5217\u53f7\u65f6\u51fa\u9519");
            ArrayList<String> arrayList5 = arrayList;
            return arrayList5;
        }
        finally {
            if (object != null) {
                ((Process)object).destroy();
            }
        }
        long l2 = System.currentTimeMillis();
        log.info((Object)("\u83b7\u53d6\u8bbe\u5907\u5e8f\u5217\u53f7\u82b1\u8d39\u65f6\u95f4\uff1a" + (l2 - l) + "ms"));
        return arrayList;
    }

    private static byte[] compressHexStr(String string) {
        if (!string.matches("[A-F,a-f,0-9]+")) {
            return null;
        }
        if (string.length() % 2 != 0) {
            return null;
        }
        byte[] byArray = new byte[string.length() / 2];
        int n = 0;
        for (int i = 0; i < string.length(); i += 2) {
            byArray[n] = Integer.valueOf(string.substring(i, i + 2), 16).byteValue();
            ++n;
        }
        return byArray;
    }

    private static String decompressByteArray(byte[] byArray, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = n; i < n2; ++i) {
            int n3;
            int n4;
            if (byArray[i] >= 0) {
                n4 = (byArray[i] & 0xF0) >> 4;
                stringBuffer.append(Integer.toHexString(n4));
                n3 = byArray[i] & 0xF;
                stringBuffer.append(Integer.toHexString(n3));
                continue;
            }
            n4 = byArray[i] + 128;
            n3 = ((n4 & 0xF0) >> 4) + 8;
            stringBuffer.append(Integer.toHexString(n3));
            int n5 = n4 & 0xF;
            stringBuffer.append(Integer.toHexString(n5));
        }
        return stringBuffer.toString().toUpperCase();
    }

    private String byteArrayToHexStr(byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            return "";
        }
        int n = byArray.length;
        StringBuffer stringBuffer = new StringBuffer(n * 2);
        for (int i = 0; i < n; ++i) {
            int n2;
            for (n2 = byArray[i]; n2 < 0; n2 += 256) {
            }
            if (n2 < 16) {
                stringBuffer.append("0");
            }
            try {
                stringBuffer.append(Integer.toString(n2, 16));
                continue;
            }
            catch (Exception exception) {
                log.error((Object)"\u8f6c\u6362\u5931\u8d25\u3002\u3002", (Throwable)exception);
                stringBuffer.append("**");
            }
        }
        return stringBuffer.toString().toUpperCase();
    }

    @Override
    public boolean startDevice(String string) {
        return false;
    }

    @Override
    public String getSignal(SerialPort serialPort) {
        return "";
    }

    @Override
    public String getSerialNumber(SerialPort serialPort) {
        return "";
    }

    @Override
    public boolean connectionOK(String string) {
        SerialPort serialPort = this.getSerialPort(string);
        return ModemDriver.readPortInputBufferUsedSize(serialPort) != -1;
    }
}

