/*
 * Decompiled with CFR 0.152.
 */
package cn.sendsms.otherModem.driver.nbiotDriver;

import cn.sendsms.jdsmsserver.JDSMSServer;
import cn.sendsms.otherModem.bean.ModemBean;
import cn.sendsms.otherModem.bean.NbIoTBean;
import cn.sendsms.otherModem.common.ComReadWriter;
import cn.sendsms.otherModem.common.ComReadWriterManager;
import cn.sendsms.otherModem.common.Utils;
import cn.sendsms.otherModem.driver.nbiotDriver.NbIoTDriver;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jssc.SerialPort;
import org.apache.commons.configuration.PropertiesConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XYM110NBIoTDriver
extends NbIoTDriver {
    private static final XYM110NBIoTDriver _$4 = new XYM110NBIoTDriver();
    private ComReadWriterManager _$3 = new ComReadWriterManager();
    private boolean _$2;

    public static final XYM110NBIoTDriver getInstance() {
        return _$4;
    }

    private static void _$1(int n) {
        try {
            Thread.sleep(n * 300);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    @Override
    public boolean connectSucessed(String string) {
        ComReadWriter comReadWriter = this._$3.getReadWriter(string);
        PropertiesConfiguration propertiesConfiguration = JDSMSServer.getInstance().getProperties();
        SerialPort serialPort = nbiotDeviceInfoGetter.getSerialPort(string);
        NbIoTBean nbIoTBean = nbiotDeviceInfoGetter.findDeviceByPortID(string);
        String string2 = propertiesConfiguration.getString("settings.mqtt_server", "119.90.56.92");
        String string3 = propertiesConfiguration.getString("settings.mqtt_port", "1883");
        String string4 = propertiesConfiguration.getString("settings.mqtt_user", "0000");
        String string5 = propertiesConfiguration.getString("settings.mqtt_password", "0000");
        int n = propertiesConfiguration.getInt("settings.mqtt_keepalive", 10);
        int n2 = propertiesConfiguration.getInt("settings.mqtt_ack", 8);
        String string6 = "AT+MQNEW=\"" + string2 + "\",\"" + string3 + "\"," + n * 1000 + ",990\r";
        if (!comReadWriter.send(serialPort, string6)) {
            log.error((Object)("\u7aef\u53e3" + serialPort.getPortName() + "\u672a\u6253\u5f00\u3002\u3002"));
            ComReadWriter.xClosePort(serialPort);
            return false;
        }
        XYM110NBIoTDriver._$1(15);
        Object object = comReadWriter.recv(serialPort, 10000L);
        if (((ComReadWriter.ComReadResult)object).code != 1) {
            log.error((Object)(serialPort.getPortName() + "\u914d\u7f6eMQTT\u670d\u52a1\u5668\u8fde\u63a5\u53c2\u6570\u5f02\u5e38:" + ((ComReadWriter.ComReadResult)object).szValue));
            return false;
        }
        string6 = nbIoTBean.getCommunicationID();
        object = "AT+MQCON=0,4,\"" + string6 + "\",120,0,0\r";
        if (!comReadWriter.send(serialPort, (String)object)) {
            log.error((Object)("\u7aef\u53e3" + serialPort.getPortName() + "\u672a\u6253\u5f00\u3002\u3002"));
            return false;
        }
        XYM110NBIoTDriver._$1(15);
        ComReadWriter.ComReadResult comReadResult = comReadWriter.recv(serialPort, 10000L);
        if (comReadResult.code != 1) {
            log.error((Object)(serialPort.getPortName() + "MQTT\u670d\u52a1\u5668\u8fde\u63a5\u5f02\u5e38:" + comReadResult.szValue));
            return false;
        }
        this._$2 = true;
        this.getCompleteMessages(null, serialPort, nbIoTBean, "\u8fde\u63a5MQTT\u670d\u52a1\u5668");
        return true;
    }

    @Override
    public boolean isCompleteMessages(byte[] byArray, NbIoTBean nbIoTBean, List<String> list, List<String> list2) {
        String string = Utils.getString(byArray);
        return this._$1(string, nbIoTBean, list);
    }

    @Override
    public String getCommunicationID(String string) {
        String string2 = "";
        if (string == null || string.equals("")) {
            return string2;
        }
        PropertiesConfiguration propertiesConfiguration = JDSMSServer.getInstance().getProperties();
        String string3 = propertiesConfiguration.getString("random_number_seed", "");
        if (string3 != null && !"".equals(string3) && string3.length() >= 10 && string3.matches("[0-9a-zA-Z]+")) {
            string = string3;
        }
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.update(string.getBytes("UTF-8"));
            byte[] byArray = messageDigest.digest();
            string2 = new BigInteger(1, byArray).toString(16).substring(8, 16).toUpperCase();
        }
        catch (Exception exception) {
            log.error((Object)"\u83b7\u53d6\u901a\u4fe1ID\u5931\u8d25\u3002\u3002\u3002", (Throwable)exception);
            string2 = "";
        }
        return string2;
    }

    public static String bytes2HexString(byte[] byArray) {
        if (byArray == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (byte by : byArray) {
            String string = Integer.toHexString(by & 0xFF);
            if (string.length() == 1) {
                string = '0' + string;
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString().toUpperCase();
    }

    public static String createMessageBody(String string) {
        if (string == null) {
            return "";
        }
        byte[] byArray = null;
        try {
            byArray = string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            System.out.println("ERROR:" + unsupportedEncodingException);
        }
        return XYM110NBIoTDriver.bytes2HexString(byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean sendMessage(String string, String string2, NbIoTBean nbIoTBean) {
        String string3 = XYM110NBIoTDriver.createMessageBody(string2);
        PropertiesConfiguration propertiesConfiguration = JDSMSServer.getInstance().getProperties();
        String string4 = nbIoTBean.getPortID();
        ComReadWriter comReadWriter = this._$3.getReadWriter(string4);
        SerialPort serialPort = nbiotDeviceInfoGetter.getSerialPort(string4);
        int n = propertiesConfiguration.getInt("settings.mqtt_qos", 1);
        String string5 = "AT+MQPUB=0,\"" + string + "\"," + n + ",0,0," + string3.length() / 2 + ",\"" + string3 + "\"\r";
        SerialPort serialPort2 = serialPort;
        synchronized (serialPort2) {
            if (!comReadWriter.send(serialPort, string5)) {
                log.error((Object)("\u7aef\u53e3" + serialPort.getPortName() + "\u672a\u6253\u5f00\u3002\u3002"));
                ComReadWriter.xClosePort(serialPort);
                return false;
            }
            XYM110NBIoTDriver._$1(10);
            ComReadWriter.ComReadResult comReadResult = comReadWriter.recv(serialPort, 5000L);
            if (comReadResult.code != 1) {
                log.error((Object)(serialPort.getPortName() + "\u6d88\u606f\u53d1\u9001\u5931\u8d25:" + comReadResult.szValue));
                return false;
            }
        }
        this.getCompleteMessages(null, serialPort, nbIoTBean, "\u53d1\u9001\u7ebf\u7a0b");
        return true;
    }

    @Override
    public void commandNotEcho(SerialPort serialPort) {
        if (!ComReadWriter.xSend(serialPort, "ATE0\r")) {
            log.error((Object)("\u7aef\u53e3" + serialPort.getPortName() + "\u672a\u6253\u5f00\u3002\u3002"));
            return;
        }
        ComReadWriter.ComReadResult comReadResult = ComReadWriter.xRecv(serialPort, 5000L);
        if (comReadResult.code != 1) {
            log.error((Object)"\u5173\u95ed\u547d\u4ee4\u56de\u663e\u5931\u8d25");
        } else {
            log.info((Object)"\u5173\u95ed\u547d\u4ee4\u56de\u663e\u6210\u529f");
        }
    }

    @Override
    public boolean subSucessed(String string) {
        ComReadWriter comReadWriter = this._$3.getReadWriter(string);
        SerialPort serialPort = nbiotDeviceInfoGetter.getSerialPort(string);
        NbIoTBean nbIoTBean = nbiotDeviceInfoGetter.findDeviceByPortID(string);
        PropertiesConfiguration propertiesConfiguration = JDSMSServer.getInstance().getProperties();
        int n = propertiesConfiguration.getInt("settings.mqtt_qos", 1);
        String string2 = "AT+MQSUB=0,\"" + nbIoTBean.getCommunicationID() + "\"," + n + "\r";
        if (!comReadWriter.send(serialPort, string2)) {
            log.error((Object)("\u7aef\u53e3" + serialPort.getPortName() + "\u672a\u6253\u5f00\u3002\u3002"));
            return false;
        }
        ComReadWriter.ComReadResult comReadResult = comReadWriter.recv(serialPort, 5000L);
        if (comReadResult.code != 1) {
            log.error((Object)(serialPort.getPortName() + "\u6d88\u606f\u8ba2\u9605\u5931\u8d25: " + comReadResult.szValue));
            return false;
        }
        this.getCompleteMessages(null, serialPort, nbIoTBean, "\u8ba2\u9605\u4e3b\u9898");
        return true;
    }

    @Override
    public void disconnectMQTTServer(SerialPort serialPort) {
        ComReadWriter comReadWriter = this._$3.getReadWriter(serialPort.getPortName());
        if (!comReadWriter.send(serialPort, "AT+MQDISCON=0\r")) {
            return;
        }
        XYM110NBIoTDriver._$1(10);
        ComReadWriter.ComReadResult comReadResult = comReadWriter.recv(serialPort, 5000L);
        if (!comReadWriter.send(serialPort, "AT+MQDISCON=1\r")) {
            return;
        }
        XYM110NBIoTDriver._$1(10);
        comReadResult = comReadWriter.recv(serialPort, 5000L);
    }

    @Override
    public boolean networkNormal(SerialPort serialPort) {
        ComReadWriter comReadWriter = this._$3.getReadWriter(serialPort.getPortName());
        if (!comReadWriter.send(serialPort, "AT+CEREG?\r")) {
            log.error((Object)("\u7aef\u53e3" + serialPort.getPortName() + "\u672a\u6253\u5f00\u3002\u3002"));
            return false;
        }
        ComReadWriter.ComReadResult comReadResult = comReadWriter.recv(serialPort, 5000L);
        if (comReadResult.code != 1) {
            log.info((Object)("\u7f51\u7edc\u72b6\u6001\u83b7\u53d6\u9519\u8bef\uff1a" + comReadResult.szValue));
            return false;
        }
        Pattern pattern = Pattern.compile("CEREG:[\\s]*0,1");
        Matcher matcher = pattern.matcher(comReadResult.szValue);
        if (matcher.find()) {
            log.info((Object)(serialPort.getPortName() + "\u7f51\u7edc\u6b63\u5e38\u3002\u3002\u3002"));
            return true;
        }
        log.info((Object)("\u5f53\u524d\u7f51\u7edc\u72b6\u6001\uff1a" + comReadResult.szValue));
        return false;
    }

    @Override
    public boolean initDevice(SerialPort serialPort) {
        if (!ComReadWriter.xSend(serialPort, "AT+RB\r")) {
            log.error((Object)("\u7aef\u53e3" + serialPort.getPortName() + "\u672a\u6253\u5f00\u3002\u3002"));
            return false;
        }
        ComReadWriter.ComReadResult comReadResult = ComReadWriter.xRecv(serialPort, "ACT", "ERROR", 10000L);
        if (comReadResult.code != 1) {
            log.info((Object)("\u8bbe\u5907\u91cd\u542f\u5931\u8d25\uff1a" + comReadResult.szValue));
            return false;
        }
        log.info((Object)("\u8bbe\u5907\u91cd\u542f\u5b8c\u6210\uff1a" + comReadResult.szValue));
        return true;
    }

    public static byte[] hexString2Bytes(String string) {
        if (string == null) {
            return null;
        }
        int n = 0;
        int n2 = 0;
        int n3 = string.length() / 2;
        byte[] byArray = new byte[n3];
        for (int i = 0; i < n3; ++i) {
            n = i * 2 + 1;
            n2 = n + 1;
            int n4 = Integer.decode("0x" + string.substring(i * 2, n) + string.substring(n, n2));
            byArray[i] = (byte)n4;
        }
        return byArray;
    }

    private String _$1(String string) {
        String string2 = ",[0-9a-zA-Z]*$";
        Pattern pattern = Pattern.compile(string2);
        Matcher matcher = pattern.matcher(string);
        if (!matcher.find()) {
            return "";
        }
        String string3 = matcher.group(0).replaceAll(",", "");
        String string4 = "";
        try {
            string4 = new String(XYM110NBIoTDriver.hexString2Bytes(string3), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            log.info((Object)("\u6d88\u606f\u5185\u5bb9\u89e3\u6790\u9519\u8bef:" + unsupportedEncodingException));
        }
        return string4;
    }

    private boolean _$1(String string, NbIoTBean nbIoTBean, List<String> list) {
        String string2 = nbIoTBean.getCommunicationID();
        String string3 = "\\+JINDIPUB2:\\s*[0-9]," + string2 + ",[0-9]{1,2},[0-9]{1,2},[0-9]{1,2},[0-9]{1,4},[0-9a-zA-Z]*";
        Pattern pattern = Pattern.compile(string3);
        String string4 = string.replaceAll("\\+MQPUB:", "\\+JINDIPUB1:\\+JINDIPUB2:");
        String[] stringArray = string4.split("\\+JINDIPUB1:");
        boolean bl = true;
        for (String string5 : stringArray) {
            if (string5.indexOf("+JINDIPUB2:") != 0) continue;
            Matcher matcher = pattern.matcher(string5);
            if (matcher.find()) {
                list.add(this._$1(matcher.group(0)));
                continue;
            }
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getCompleteMessages(byte[] byArray, SerialPort serialPort, NbIoTBean nbIoTBean, String string) {
        ComReadWriter comReadWriter = this._$3.getReadWriter(serialPort.getPortName());
        comReadWriter.recvNoWait(serialPort);
        ArrayList<String> arrayList = new ArrayList<String>();
        SerialPort serialPort2 = serialPort;
        synchronized (serialPort2) {
            String string2;
            while ((string2 = comReadWriter.getRecvLine()) != null) {
                if (string2.indexOf("MQDISON:") > 0 || string2.indexOf("MQDISCON:") > 0 || string2.indexOf("disconnect") > 0 || string2.indexOf("timeout") > 0) {
                    log.info((Object)("RECV: " + string2));
                    this._$2 = false;
                } else if (string2.indexOf("MQPUB:") > 0) {
                    log.info((Object)("RECV: " + string2));
                }
                this._$1(string2, nbIoTBean, arrayList);
            }
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            nbiotMessageHolder.updateMessageList(nbIoTBean, (String)arrayList.get(i));
        }
    }

    @Override
    public String getSignal(SerialPort serialPort) {
        String string = "99,99";
        boolean bl = false;
        Object object = nbiotDeviceInfoGetter.findDeviceByPortID(serialPort.getPortName());
        if (object != null && !XYM110NBIoTDriver.serialportConnected(serialPort)) {
            Utils.closePort(serialPort);
            if (Utils.openPort(((ModemBean)object).getBaudrate(), serialPort)) {
                bl = true;
            } else {
                return string;
            }
        }
        if (!ComReadWriter.xSend(serialPort, "AT+CSQ\r")) {
            log.error((Object)("\u7aef\u53e3" + serialPort.getPortName() + "\u672a\u6253\u5f00\u3002\u3002"));
            return string;
        }
        object = ComReadWriter.xRecv(serialPort, 5000L);
        if (((ComReadWriter.ComReadResult)object).code != 1) {
            return string;
        }
        String string2 = "\\+CSQ:[\\s\\S]+[0-9]+,[0-9]+";
        Pattern pattern = Pattern.compile(string2);
        Matcher matcher = pattern.matcher(((ComReadWriter.ComReadResult)object).szValue);
        if (matcher.find()) {
            string = matcher.group(0);
        }
        string = Utils.deletePrefix(string, "+CSQ:");
        string = string.trim();
        if (bl) {
            Utils.closePort(serialPort);
        }
        return string;
    }

    @Override
    public String getSerialNumber(SerialPort serialPort) {
        boolean bl = false;
        Object object = nbiotDeviceInfoGetter.findDeviceByPortID(serialPort.getPortName());
        if (object != null && !XYM110NBIoTDriver.serialportConnected(serialPort)) {
            Utils.closePort(serialPort);
            log.info((Object)("\u6b63\u5728\u5c1d\u8bd5\u6253\u5f00\u7aef\u53e3:" + serialPort.getPortName()));
            if (Utils.openPort(((ModemBean)object).getBaudrate(), serialPort)) {
                bl = true;
            } else {
                return "";
            }
        }
        if (!ComReadWriter.xSend(serialPort, "AT+CGSN=1\r")) {
            log.error((Object)("\u7aef\u53e3" + serialPort.getPortName() + "\u672a\u6253\u5f00\u3002\u3002"));
            return "";
        }
        object = ComReadWriter.xRecv(serialPort, 5000L);
        if (((ComReadWriter.ComReadResult)object).code != 1) {
            return "";
        }
        String string = "";
        String string2 = "[A-Z,0-9]{10,}";
        Pattern pattern = Pattern.compile(string2);
        Matcher matcher = pattern.matcher(((ComReadWriter.ComReadResult)object).szValue);
        if (matcher.find()) {
            string = matcher.group(0);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean connectionOK(String string) {
        ComReadWriter comReadWriter = this._$3.getReadWriter(string);
        SerialPort serialPort = nbiotDeviceInfoGetter.getSerialPort(string);
        NbIoTBean nbIoTBean = nbiotDeviceInfoGetter.findDeviceByPortID(string);
        XYM110NBIoTDriver._$1(1);
        SerialPort serialPort2 = serialPort;
        synchronized (serialPort2) {
            if ("0".equals(nbIoTBean.getUsingStatus())) {
                log.info((Object)("\u8bbe\u5907" + nbIoTBean.getGatewayID() + "\u5df2\u7ecf\u5173\u95ed\u3002\u3002\u3002"));
                return true;
            }
            if (!this._$2) {
                this.disconnectMQTTServer(serialPort);
                return false;
            }
        }
        this.getCompleteMessages(null, serialPort, nbIoTBean, "\u68c0\u6d4b...");
        return this._$2;
    }

    @Override
    public boolean isDeviceAT(SerialPort serialPort) {
        ComReadWriter comReadWriter = this._$3.getReadWriter(serialPort.getPortName());
        if (!comReadWriter.send(serialPort, "AT\r")) {
            log.error((Object)("\u7aef\u53e3" + serialPort.getPortName() + "\u672a\u6253\u5f00\u3002\u3002"));
            return false;
        }
        ComReadWriter.ComReadResult comReadResult = comReadWriter.recv(serialPort, 5000L);
        return comReadResult.code == 1;
    }
}

