/*
 * Decompiled with CFR 0.152.
 */
package cn.sendsms;

import cn.ajwcc.pduUtils.gsm3040.PduFactory;
import cn.ajwcc.pduUtils.gsm3040.SmsSubmitPdu;
import cn.ajwcc.pduUtils.wappush.WapSiPdu;
import cn.sendsms.Message;
import cn.sendsms.OutboundBinaryMessage;
import cn.sendsms.jdsmsserver.JDSMSServer;
import java.net.URL;
import java.util.Date;

public class OutboundWapSIMessage
extends OutboundBinaryMessage {
    private static final long serialVersionUID = 2L;
    protected URL url;
    protected Date createDate;
    protected Date expireDate;
    protected WapSISignals signal;
    protected String siId;
    protected String indicationText;

    public OutboundWapSIMessage(String string, URL uRL, Date date, Date date2, WapSISignals wapSISignals, String string2) {
        this.url = uRL;
        this.createDate = new Date(date.getTime());
        this.expireDate = new Date(date2.getTime());
        this.signal = wapSISignals;
        if (string2 != null) {
            String string3 = JDSMSServer.getInstance().getProperties().getString("settings.signature", "");
            String string4 = JDSMSServer.getInstance().getProperties().getString("settings.device_mode", "0");
            if ("0".equals(string4) && !string3.trim().isEmpty() && !string2.endsWith(string3)) {
                string2 = string2 + string3;
            }
            this.setIndicationText(string2);
        }
        this.setSrcPort(9200);
        this.setDstPort(2948);
        this._$1(Message.MessageTypes.WAPSI);
        this.setEncoding(Message.MessageEncodings.ENC8BIT);
        this.setRecipient(string);
    }

    public OutboundWapSIMessage(String string, URL uRL, String string2) {
        this(string, uRL, new Date(), new Date(), WapSISignals.MEDIUM, string2);
    }

    public OutboundWapSIMessage(String string, URL uRL, String string2, Date date, WapSISignals wapSISignals) {
        this(string, uRL, new Date(), date, wapSISignals, string2);
    }

    public void setIndicationText(String string) {
        this.indicationText = string;
    }

    public String getIndicationText() {
        return this.indicationText;
    }

    public Date getCreateDate() {
        return new Date(this.createDate.getTime());
    }

    public void setCreateDate(Date date) {
        this.createDate = new Date(date.getTime());
    }

    public Date getExpireDate() {
        return new Date(this.expireDate.getTime());
    }

    public void setExpireDate(Date date) {
        this.expireDate = new Date(date.getTime());
    }

    public WapSISignals getSignal() {
        return this.signal;
    }

    public void setSignal(WapSISignals wapSISignals) {
        this.signal = wapSISignals;
    }

    public URL getUrl() {
        return this.url;
    }

    public void setUrl(URL uRL) {
        this.url = uRL;
    }

    public String getSiId() {
        return this.siId;
    }

    public void setSiId(String string) {
        this.siId = string;
    }

    protected WapSiPdu createPduObject() {
        WapSiPdu wapSiPdu = this.getStatusReport() ? PduFactory.newWapSiPdu(48) : PduFactory.newWapSiPdu();
        return wapSiPdu;
    }

    protected void initPduObject(SmsSubmitPdu smsSubmitPdu, String string) {
        super.initPduObject(smsSubmitPdu, string);
        WapSiPdu wapSiPdu = (WapSiPdu)smsSubmitPdu;
        wapSiPdu.setIndicationText(this.indicationText);
        wapSiPdu.setUrl(this.url.toString());
        wapSiPdu.setCreateDate(this.createDate);
        wapSiPdu.setExpireDate(this.expireDate);
        wapSiPdu.setWapSignalFromString(this.signal.toString());
        wapSiPdu.setSiId(this.siId);
        super.setDataBytes(wapSiPdu.getDataBytes());
    }

    public byte[] getDataBytes() {
        WapSiPdu wapSiPdu = this.createPduObject();
        this.initPduObject(wapSiPdu, "");
        return super.getDataBytes();
    }

    public void setDataBytes(byte[] byArray) {
        throw new RuntimeException("setDataBytes() not supported for WapSi Message");
    }

    public void addDataBytes(byte[] byArray) {
        throw new RuntimeException("addDataBytes() not supported for WapSi Message");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum WapSISignals {
        NONE,
        LOW,
        MEDIUM,
        HIGH,
        DELETE;

    }
}

