/*
 * Decompiled with CFR 0.152.
 */
package cn.sendsms.jdsmsserver.interfaces;

import cn.sendsms.AGateway;
import cn.sendsms.InboundBinaryMessage;
import cn.sendsms.InboundMessage;
import cn.sendsms.Message;
import cn.sendsms.OutboundBinaryMessage;
import cn.sendsms.OutboundMessage;
import cn.sendsms.OutboundWapSIMessage;
import cn.sendsms.Service;
import cn.sendsms.StatusReportMessage;
import cn.sendsms.helper.AGatewayHelper;
import cn.sendsms.helper.Logger;
import cn.sendsms.jdsmsserver.JDSMSServer;
import cn.sendsms.jdsmsserver.SysLock;
import cn.sendsms.jdsmsserver.interfaces.ConnectionPool;
import cn.sendsms.jdsmsserver.interfaces.Interface;
import cn.sendsms.jdsmsserver.web.Authorize1;
import cn.sendsms.jdsmsserver.web.PhoneInfoCache;
import cn.sendsms.otherModem.common.Utils;
import java.net.URL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang3.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Database
extends Interface<Integer> {
    static final int _$9 = 1000;
    int _$8 = 1;
    private Connection _$7 = null;

    public Database(String string, PropertiesConfiguration propertiesConfiguration, JDSMSServer jDSMSServer, Interface.InterfaceTypes interfaceTypes) {
        super(string, propertiesConfiguration, jDSMSServer, interfaceTypes);
        this.setDescription("Default database interface.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws Exception {
        Connection connection = null;
        try {
            connection = this._$3();
            Statement statement = connection.createStatement(1003, 1007);
            statement.executeUpdate("update " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " set status = 'U' where status = 'Q'");
            statement.close();
        }
        catch (SQLException sQLException) {
            Throwable throwable = sQLException.getCause();
            String string = throwable == null ? "" : throwable.toString();
            try {
                if (connection != null) {
                    connection.close();
                }
                this._$1(connection);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!this.getServer().getShutdown()) {
                Logger.getInstance().logError(String.format("SQL failure " + string + " , will retry in %d seconds...", this._$8 * 1), sQLException, null);
                Thread.sleep(this._$8 * 1000);
                this._$8 *= 2;
                if (this._$8 == 64) {
                    this._$8 = 1;
                }
            }
        }
        finally {
            this._$1(connection);
        }
        super.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() throws Exception {
        Connection connection = null;
        try {
            connection = this._$3();
            Statement statement = connection.createStatement(1003, 1007);
            statement.executeUpdate("update " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " set status = 'U' where status = 'Q'");
            statement.close();
        }
        catch (SQLException sQLException) {
            try {
                if (connection != null) {
                    connection.close();
                }
                this._$1(connection);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!this.getServer().getShutdown()) {
                Logger.getInstance().logError(String.format("SQL failure, will retry in %d seconds...", this._$8 * 1), sQLException, null);
                Thread.sleep(this._$8 * 1000);
                this._$8 *= 2;
                if (this._$8 == 64) {
                    this._$8 = 1;
                }
            }
        }
        finally {
            this._$1(connection);
            this._$2();
        }
        super.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void callReceived(String string, String string2) throws Exception {
        Connection connection = null;
        try {
            connection = this._$3();
            PreparedStatement preparedStatement = connection.prepareStatement("insert into " + this.getProperty("tables.calls", "jdsmsserver_calls") + " (call_date, gateway_id, caller_id) values (?,?,?) ");
            preparedStatement.setTimestamp(1, new Timestamp(new Date().getTime()));
            preparedStatement.setString(2, string);
            preparedStatement.setString(3, string2);
            preparedStatement.executeUpdate();
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            try {
                if (connection != null) {
                    connection.close();
                }
                this._$1(connection);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Logger.getInstance().logError(String.format("SQL failure, will retry in %d seconds...", this._$8 * 1), sQLException, null);
            Thread.sleep(this._$8 * 1000);
            this._$8 *= 2;
            if (this._$8 == 64) {
                this._$8 = 1;
            }
        }
        finally {
            this._$1(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void messagesReceived(Collection<InboundMessage> collection) throws Exception {
        int n = 0;
        while (!SysLock.getInstance().canUse()) {
            try {
                Thread.sleep(50L);
                if (n++ <= 50) continue;
                Logger.getInstance().logError("\u81ea\u65cb\u7b49\u5f85\u8d85\u8fc72\u79d2", null, null);
            }
            catch (InterruptedException interruptedException) {
                Logger.getInstance().logError("\u53d6\u5f85\u53d1\u77ed\u4fe1\u65f6\u4ea7\u751f\u4e2d\u65ad\u5f02\u5e38", interruptedException, null);
            }
        }
        System.out.println("Database messagesReceived...");
        Connection connection = null;
        try {
            connection = this._$3();
            PreparedStatement preparedStatement = connection.prepareStatement(" insert into " + this.getProperty("tables.sms_in", "jdsmsserver_in") + " (process, originator, type, encoding, message_date, receive_date, text," + " original_ref_no, original_receive_date, gateway_id) " + " values(?,?,?,?,?,?,?,?,?,?)");
            block26: for (InboundMessage inboundMessage : collection) {
                if (inboundMessage.isError()) {
                    Logger.getInstance().logInfo("\u4fe1\u606f\u3010" + inboundMessage.getText() + "\u3011\u4e0d\u5b8c\u6574\uff0c\u4e0d\u5165\u5e93\u3002", null, null);
                    continue;
                }
                if (this._$1(connection, inboundMessage)) {
                    Logger.getInstance().logInfo("\u4fe1\u606f\u3010" + inboundMessage.getText() + "\u3011\u91cd\u590d\u4e86\uff01key: " + inboundMessage.getMessageID() + "-" + inboundMessage.getOriginator(), null, null);
                    continue;
                }
                if (inboundMessage.getType() != Message.MessageTypes.INBOUND && inboundMessage.getType() != Message.MessageTypes.STATUSREPORT) continue;
                if (Utils.isEmptyStr(inboundMessage.getMessageID())) {
                    preparedStatement.setInt(1, 0);
                } else {
                    preparedStatement.setInt(1, Integer.valueOf(inboundMessage.getMessageID(), 16));
                }
                switch (inboundMessage.getEncoding()) {
                    case ENC7BIT: {
                        preparedStatement.setString(4, "7");
                        break;
                    }
                    case ENC8BIT: {
                        preparedStatement.setString(4, "8");
                        break;
                    }
                    case ENCUCS2: {
                        preparedStatement.setString(4, "U");
                        break;
                    }
                    case SC: {
                        preparedStatement.setString(4, "S");
                        break;
                    }
                    case ENCCUSTOM: {
                        preparedStatement.setString(4, "C");
                    }
                }
                switch (inboundMessage.getType()) {
                    case INBOUND: {
                        preparedStatement.setString(3, "I");
                        String string = inboundMessage.getOriginator();
                        if (null == string) continue block26;
                        if (string.startsWith("86")) {
                            string = string.substring(2, string.length());
                        }
                        preparedStatement.setString(2, string);
                        if (inboundMessage.getDate() != null) {
                            preparedStatement.setTimestamp(5, new Timestamp(inboundMessage.getDate().getTime()));
                        }
                        preparedStatement.setString(8, null);
                        preparedStatement.setTimestamp(9, null);
                        break;
                    }
                    case STATUSREPORT: {
                        preparedStatement.setString(3, "S");
                        preparedStatement.setString(2, ((StatusReportMessage)inboundMessage).getRecipient());
                        if (((StatusReportMessage)inboundMessage).getSent() != null) {
                            preparedStatement.setTimestamp(5, new Timestamp(((StatusReportMessage)inboundMessage).getSent().getTime()));
                        }
                        preparedStatement.setString(8, ((StatusReportMessage)inboundMessage).getRefNo());
                        if (((StatusReportMessage)inboundMessage).getReceived() != null) {
                            preparedStatement.setTimestamp(9, new Timestamp(((StatusReportMessage)inboundMessage).getReceived().getTime()));
                        }
                        if (!this.getProperty("update_outbound_on_statusreport", "no").equalsIgnoreCase("yes")) break;
                        PreparedStatement preparedStatement2 = connection.prepareStatement(" update " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " set status = ? " + " where (recipient = ? or recipient = ?) and ref_no = ? and gateway_id = ?");
                        switch (((StatusReportMessage)inboundMessage).getStatus()) {
                            case DELIVERED: {
                                preparedStatement2.setString(1, "D");
                                break;
                            }
                            case KEEPTRYING: {
                                preparedStatement2.setString(1, "P");
                                break;
                            }
                            case ABORTED: {
                                preparedStatement2.setString(1, "A");
                                break;
                            }
                        }
                        preparedStatement2.setString(2, ((StatusReportMessage)inboundMessage).getRecipient());
                        if (((StatusReportMessage)inboundMessage).getRecipient().startsWith("+")) {
                            preparedStatement2.setString(3, ((StatusReportMessage)inboundMessage).getRecipient().substring(1));
                        } else {
                            preparedStatement2.setString(3, "+" + ((StatusReportMessage)inboundMessage).getRecipient());
                        }
                        preparedStatement2.setString(4, ((StatusReportMessage)inboundMessage).getRefNo());
                        preparedStatement2.setString(5, ((StatusReportMessage)inboundMessage).getGatewayId());
                        preparedStatement2.executeUpdate();
                        preparedStatement2.close();
                        break;
                    }
                }
                preparedStatement.setTimestamp(6, new Timestamp(new Date().getTime()));
                if (inboundMessage instanceof InboundBinaryMessage) {
                    preparedStatement.setString(7, inboundMessage.getPduUserData().length() == 0 ? "" : inboundMessage.getPduUserData());
                } else {
                    preparedStatement.setString(7, inboundMessage.getText().length() == 0 ? "" : inboundMessage.getText());
                }
                preparedStatement.setString(10, inboundMessage.getGatewayId());
                preparedStatement.addBatch();
            }
            Iterator<InboundMessage> iterator = null;
            preparedStatement.executeBatch();
            preparedStatement.close();
        }
        catch (Exception exception) {
            try {
                if (connection != null) {
                    connection.close();
                }
                this._$1(connection);
            }
            catch (Exception exception2) {
                // empty catch block
            }
            Logger.getInstance().logError(String.format("SQL failure, will retry in %d seconds...", this._$8 * 1), exception, null);
            Thread.sleep(this._$8 * 1000);
            this._$8 *= 2;
            if (this._$8 == 64) {
                this._$8 = 1;
            }
        }
        finally {
            SysLock.getInstance().setbusy(false);
            this._$1(connection);
        }
        SysLock.getInstance().setbusy(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<OutboundMessage> getMessagesToSend() throws Exception {
        int n = 0;
        while (!SysLock.getInstance().canUse()) {
            try {
                Thread.sleep(50L);
                if (n++ <= 50) continue;
                Logger.getInstance().logError("\u81ea\u65cb\u7b49\u5f85\u8d85\u8fc72\u79d2", null, null);
            }
            catch (InterruptedException interruptedException) {
                Logger.getInstance().logError("\u53d6\u5f85\u53d1\u77ed\u4fe1\u65f6\u4ea7\u751f\u4e2d\u65ad\u5f02\u5e38", interruptedException, null);
            }
        }
        Connection connection = null;
        ArrayList<OutboundMessage> arrayList = new ArrayList<OutboundMessage>();
        boolean bl = false;
        if (JDSMSServer.getInstance().getProperties().getString("db1.type", "mysql").equals("oracle") || JDSMSServer.getInstance().getProperties().getString("db1.type", "mysql").equals("oracle-rac")) {
            bl = true;
        }
        boolean bl2 = false;
        if (JDSMSServer.getInstance().getProperties().getString("db1.type", "mysql").equals("mssql")) {
            bl2 = true;
        }
        boolean bl3 = false;
        if (JDSMSServer.getInstance().getProperties().getString("db1.type", "mysql").equals("postgresql")) {
            bl3 = true;
        }
        String string = JDSMSServer.getInstance().getProperties().getString("settings.device_using", "yes");
        String string2 = JDSMSServer.getInstance().getProperties().getString("settings.phone_using", "yes");
        String string3 = JDSMSServer.getInstance().getProperties().getString("settings.gateway_using", "yes");
        String string4 = this._$1();
        int n2 = 0;
        if (string2.equals("yes")) {
            ++n2;
        }
        if (string.equals("yes")) {
            ++n2;
        }
        if (string3.equals("yes")) {
            ++n2;
        }
        n2 *= 3;
        try {
            PreparedStatement preparedStatement;
            ResultSet resultSet = null;
            int n3 = 1;
            connection = this._$3();
            Statement statement = connection.createStatement(1005, 1008);
            if ("no".equals(string)) {
                ArrayList<OutboundMessage> arrayList2 = arrayList;
                return arrayList2;
            }
            if (!"*".equals(string4)) {
                preparedStatement = connection.prepareStatement("update " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " set status = 'Q',gateway_id=? where id = ? ");
                JDSMSServer.getInstance().userConsolePrint("x", "send update1: update " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " set status = 'Q',gateway_id=? where id = ? ");
            } else {
                preparedStatement = connection.prepareStatement("update " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " set status = 'Q' where id = ? ");
                JDSMSServer.getInstance().userConsolePrint("x", "send update2: update " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " set status = 'Q' where id = ? ");
            }
            String string5 = "";
            if ("*".equals(string4)) {
                if (bl) {
                    string5 = "select * from " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " where status = 'U' and (gateway_id = '*' or gateway_id like 'modem%') and rownum <= %size% order by priority desc, id";
                    string5 = string5.replaceAll("%size%", "" + Integer.parseInt(this.getProperty("batch_size", "50")));
                } else if (bl2) {
                    string5 = "select top %size% * from " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " where status = 'U' and (gateway_id = '*' or gateway_id like 'modem%') order by priority desc, id";
                    string5 = string5.replaceAll("%size%", "" + Integer.parseInt(this.getProperty("batch_size", "50")));
                } else if (bl3) {
                    string5 = "select * from " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " where status = 'U' and (gateway_id = '*' or gateway_id like 'modem%') order by priority desc, id limit %size% offset %begin%";
                    string5 = string5.replaceAll("%begin%", "0");
                    string5 = string5.replaceAll("%size%", "" + Integer.parseInt(this.getProperty("batch_size", "50")));
                } else {
                    string5 = "select * from " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " where status = 'U' and (gateway_id = '*' or gateway_id like 'modem%') order by priority desc, id limit %begin% , %size%";
                    string5 = string5.replaceAll("%begin%", "0");
                    string5 = string5.replaceAll("%size%", "" + Integer.parseInt(this.getProperty("batch_size", "50")));
                }
                JDSMSServer.getInstance().userConsolePrint("x", "get send1:" + string5);
                resultSet = statement.executeQuery(string5);
            }
            int n4 = Integer.parseInt(this.getProperty("retries", "2"));
            if (!"*".equals(string4)) {
                if (bl) {
                    string5 = "select * from " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " where (status = 'F' and (gateway_id='#' or gateway_id = '$') and errors>'" + n4 + "' and errors<'" + n2 + "') or (status = 'U' and (gateway_id = '*' or gateway_id like 'modem%')) and rownum <= %size% order by priority desc, id";
                    string5 = string5.replaceAll("%size%", "" + Integer.parseInt(this.getProperty("batch_size", "50")));
                } else if (bl2) {
                    string5 = "select top %size% * from " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " where (status = 'F' and (gateway_id='#' or gateway_id = '$') and errors>'" + n4 + "' and errors<'" + n2 + "') or (status = 'U' and (gateway_id = '*' or gateway_id like 'modem%')) order by priority desc, id";
                    string5 = string5.replaceAll("%size%", "" + Integer.parseInt(this.getProperty("batch_size", "50")));
                } else if (bl3) {
                    string5 = "select * from " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " where (status = 'F' and (gateway_id='#' or gateway_id = '$') and errors>'" + n4 + "' and errors<'" + n2 + "') or (status = 'U' and (gateway_id = '*' or gateway_id like 'modem%')) order by priority desc, id limit %size% offset %begin%";
                    string5 = string5.replaceAll("%begin%", "0");
                    string5 = string5.replaceAll("%size%", "" + Integer.parseInt(this.getProperty("batch_size", "50")));
                } else {
                    string5 = "select * from " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " where (status = 'F' and (gateway_id='#' or gateway_id = '$') and errors>'" + n4 + "' and errors<'" + n2 + "') or (status = 'U' and (gateway_id = '*' or gateway_id like 'modem%')) order by priority desc, id limit %begin% , %size%";
                    string5 = string5.replaceAll("%begin%", "0");
                    string5 = string5.replaceAll("%size%", "" + Integer.parseInt(this.getProperty("batch_size", "50")));
                }
                JDSMSServer.getInstance().userConsolePrint("x", "get send2:" + string5);
                resultSet = statement.executeQuery(string5);
            }
            if (resultSet == null) {
                Logger.getInstance().logError("\u914d\u7f6e\u6587\u4ef6\u8bbe\u5907\u6a21\u5f0f\u4e22\u5931,\u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6", null, null);
                ArrayList<OutboundMessage> arrayList3 = arrayList;
                return arrayList3;
            }
            Logger.getInstance().logDebug("sql\u67e5\u8be2=" + string5, null, null);
            PreparedStatement preparedStatement2 = connection.prepareStatement("update " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " set status = 'F',sent_date=? where id = ? ");
            block28: while (resultSet.next() && n3 <= Integer.parseInt(this.getProperty("batch_size", "50"))) {
                Object object;
                OutboundMessage outboundMessage;
                if (!this.getServer().checkPriorityTimeFrame(resultSet.getInt("priority"))) continue;
                String string6 = resultSet.getString("recipient");
                if (StringUtils.isEmpty((CharSequence)string6) || !string6.matches("\\+?\\d{1,25}")) {
                    preparedStatement2.setTimestamp(1, new Timestamp(System.currentTimeMillis()));
                    preparedStatement2.setLong(2, resultSet.getLong("id"));
                    preparedStatement2.addBatch();
                    continue;
                }
                if (resultSet.getTimestamp("sent_date") != null && System.currentTimeMillis() < resultSet.getTimestamp("sent_date").getTime()) continue;
                switch (resultSet.getString("type").charAt(0)) {
                    case 'O': {
                        switch (resultSet.getString("encoding").charAt(0)) {
                            case '7': {
                                outboundMessage = new OutboundMessage(resultSet.getString("recipient").trim(), resultSet.getString("text").trim());
                                outboundMessage.setEncoding(Message.MessageEncodings.ENC7BIT);
                                break;
                            }
                            case '8': {
                                object = resultSet.getString("text").trim();
                                if (((String)object).matches("[0-9A-F]+")) {
                                    outboundMessage = new OutboundBinaryMessage(resultSet.getString("recipient").trim(), ((String)object).getBytes());
                                    break;
                                }
                                Logger.getInstance().logError("8bit\u7f16\u7801\u4e0d\u80fd\u5305\u542b[A-F0-9]\u4ee5\u5916\u7684\u5b57\u7b26\u3002", null, null);
                                continue block28;
                            }
                            case 'U': {
                                outboundMessage = new OutboundMessage(resultSet.getString("recipient").trim(), resultSet.getString("text").trim());
                                outboundMessage.setEncoding(Message.MessageEncodings.ENCUCS2);
                                break;
                            }
                            default: {
                                outboundMessage = new OutboundMessage(resultSet.getString("recipient").trim(), resultSet.getString("text").trim());
                                outboundMessage.setEncoding(Message.MessageEncodings.ENC7BIT);
                            }
                        }
                        if (resultSet.getInt("flash_sms") == 1) {
                            outboundMessage.setFlashSms(true);
                        }
                        if (resultSet.getInt("src_port") == -1) break;
                        outboundMessage.setSrcPort(resultSet.getInt("src_port"));
                        outboundMessage.setDstPort(resultSet.getInt("dst_port"));
                        break;
                    }
                    case 'W': {
                        OutboundWapSIMessage.WapSISignals wapSISignals;
                        if (resultSet.getTime("wap_expiry_date") == null) {
                            Calendar calendar = Calendar.getInstance();
                            calendar.setTime(new Date());
                            calendar.add(6, 7);
                            object = calendar.getTime();
                        } else {
                            object = resultSet.getTimestamp("wap_expiry_date");
                        }
                        if (resultSet.getString("wap_signal") == null) {
                            wapSISignals = OutboundWapSIMessage.WapSISignals.NONE;
                        } else {
                            switch (resultSet.getString("wap_signal").charAt(0)) {
                                case 'N': {
                                    wapSISignals = OutboundWapSIMessage.WapSISignals.NONE;
                                    break;
                                }
                                case 'L': {
                                    wapSISignals = OutboundWapSIMessage.WapSISignals.LOW;
                                    break;
                                }
                                case 'M': {
                                    wapSISignals = OutboundWapSIMessage.WapSISignals.MEDIUM;
                                    break;
                                }
                                case 'H': {
                                    wapSISignals = OutboundWapSIMessage.WapSISignals.HIGH;
                                    break;
                                }
                                case 'D': {
                                    wapSISignals = OutboundWapSIMessage.WapSISignals.DELETE;
                                    break;
                                }
                                default: {
                                    wapSISignals = OutboundWapSIMessage.WapSISignals.NONE;
                                }
                            }
                        }
                        outboundMessage = new OutboundWapSIMessage(resultSet.getString("recipient").trim(), new URL(resultSet.getString("wap_url").trim()), resultSet.getString("text").trim(), (Date)object, wapSISignals);
                        break;
                    }
                    default: {
                        throw new Exception("Message type '" + resultSet.getString("type") + "' is unknown!");
                    }
                }
                outboundMessage.setPriority(resultSet.getInt("priority"));
                if (resultSet.getInt("status_report") == 1) {
                    outboundMessage.setStatusReport(true);
                }
                if (resultSet.getString("originator") != null && resultSet.getString("originator").length() > 0) {
                    outboundMessage.setFrom(resultSet.getString("originator").trim());
                }
                object = resultSet.getString("gateway_id").trim();
                if (!"*".equals(string4)) {
                    if ("#".equals(object) || "$".equals(object)) {
                        outboundMessage.setGatewayId("*");
                        preparedStatement.setString(1, "*");
                        JDSMSServer.getInstance().userConsolePrint("x", "update gateway from " + (String)object + " to *");
                    } else {
                        outboundMessage.setGatewayId((String)object);
                        preparedStatement.setString(1, (String)object);
                    }
                } else {
                    outboundMessage.setGatewayId((String)object);
                }
                JDSMSServer.getInstance().userConsolePrint("m", "*check message: gateid=" + outboundMessage.getGatewayId() + " msgid=" + resultSet.getInt("id"));
                arrayList.add(outboundMessage);
                this.getMessageCache().put(outboundMessage.getMessageId(), resultSet.getInt("id"));
                if (!"*".equals(string4)) {
                    preparedStatement.setInt(2, resultSet.getInt("id"));
                } else {
                    preparedStatement.setInt(1, resultSet.getInt("id"));
                }
                preparedStatement.addBatch();
                ++n3;
            }
            preparedStatement2.executeBatch();
            preparedStatement.executeBatch();
            resultSet.close();
            statement.close();
            preparedStatement.close();
            preparedStatement2.close();
        }
        catch (Exception exception) {
            try {
                if (connection != null) {
                    connection.close();
                }
                this._$1(connection);
            }
            catch (Exception exception2) {
                // empty catch block
            }
            Logger.getInstance().logError(String.format("SQL failure, will retry in %d seconds...", this._$8 * 1), exception, null);
            Thread.sleep(this._$8 * 1000);
            this._$8 *= 2;
            if (this._$8 == 64) {
                this._$8 = 1;
            }
        }
        finally {
            SysLock.getInstance().setbusy(false);
            this._$1(connection);
        }
        SysLock.getInstance().setbusy(false);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<OutboundMessage> getMessagesToSend4Gateway() throws Exception {
        while (!SysLock.getInstance().canUse()) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        Connection connection = null;
        ArrayList<OutboundMessage> arrayList = new ArrayList<OutboundMessage>();
        boolean bl = false;
        if (JDSMSServer.getInstance().getProperties().getString("db1.type", "mysql").equals("oracle")) {
            bl = true;
        }
        boolean bl2 = false;
        if (JDSMSServer.getInstance().getProperties().getString("db1.type", "mysql").equals("mssql")) {
            bl2 = true;
        }
        boolean bl3 = false;
        if (JDSMSServer.getInstance().getProperties().getString("db1.type", "mysql").equals("postgresql")) {
            bl3 = true;
        }
        String string = JDSMSServer.getInstance().getProperties().getString("settings.device_using", "yes");
        String string2 = JDSMSServer.getInstance().getProperties().getString("settings.phone_using", "yes");
        String string3 = JDSMSServer.getInstance().getProperties().getString("settings.gateway_using", "yes");
        String string4 = this._$1();
        int n = 0;
        if (string2.equals("yes")) {
            ++n;
        }
        if (string.equals("yes")) {
            ++n;
        }
        if (string3.equals("yes")) {
            ++n;
        }
        n *= 3;
        try {
            PreparedStatement preparedStatement;
            ResultSet resultSet = null;
            int n2 = 1;
            connection = this._$3();
            Statement statement = connection.createStatement(1005, 1008);
            if (!"#".equals(string4)) {
                preparedStatement = connection.prepareStatement("update " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " set status = 'Q',errors=?,gateway_id=? where id = ? ");
                JDSMSServer.getInstance().userConsolePrint("x", "send4gate update1: update " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " set status = 'Q',errors=?,gateway_id=? where id = ? ");
            } else {
                preparedStatement = connection.prepareStatement("update " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " set status = 'Q' where id = ? ");
                JDSMSServer.getInstance().userConsolePrint("x", "send4gate update2: update " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " set status = 'Q' where id = ? ");
            }
            int n3 = Integer.parseInt(this.getProperty("retries", "2"));
            String string5 = "";
            if ("#".equals(string4)) {
                if (bl) {
                    string5 = "select * from " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " where status = 'U' and (gateway_id='md' or gateway_id='#') and rownum <= %size% order by priority desc, id";
                    string5 = string5.replaceAll("%size%", "" + Integer.parseInt(this.getProperty("batch_size", "50")));
                } else if (bl2) {
                    string5 = "select top %size% * from " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " where status = 'U' and (gateway_id='md' or gateway_id='#') order by priority desc, id";
                    string5 = string5.replaceAll("%size%", "" + Integer.parseInt(this.getProperty("batch_size", "50")));
                } else if (bl3) {
                    string5 = "select * from " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " where status = 'U' and (gateway_id='md' or gateway_id='#') order by priority desc, id limit %size% offset %begin%";
                    string5 = string5.replaceAll("%begin%", "0");
                    string5 = string5.replaceAll("%size%", "" + Integer.parseInt(this.getProperty("batch_size", "50")));
                } else {
                    string5 = "select * from " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " where status = 'U' and (gateway_id='md' or gateway_id='#') order by priority desc, id limit %begin% , %size%";
                    string5 = string5.replaceAll("%begin%", "0");
                    string5 = string5.replaceAll("%size%", "" + Integer.parseInt(this.getProperty("batch_size", "50")));
                }
                JDSMSServer.getInstance().userConsolePrint("x", "get send4gate1:" + string5);
                resultSet = statement.executeQuery(string5);
            }
            if (!"#".equals(string4)) {
                if (bl) {
                    string5 = "select * from " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " where (status = 'F' and (gateway_id='*' or gateway_id = '$') and errors>'" + n3 + "' and errors<'" + n + "') or (status = 'U' and (gateway_id='md' or gateway_id='#')) and rownum <= %size% order by priority desc, id";
                    string5 = string5.replaceAll("%size%", "" + Integer.parseInt(this.getProperty("batch_size", "50")));
                } else if (bl2) {
                    string5 = "select top %size% * from " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " where (status = 'F' and (gateway_id='*' or gateway_id = '$') and errors>'" + n3 + "' and errors<'" + n + "') or (status = 'U' and (gateway_id='md' or gateway_id='#')) order by priority desc, id";
                    string5 = string5.replaceAll("%size%", "" + Integer.parseInt(this.getProperty("batch_size", "50")));
                } else if (bl3) {
                    string5 = "select * from " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " where (status = 'F' and (gateway_id='*' or gateway_id = '$') and errors>'" + n3 + "' and errors<'" + n + "') or (status = 'U' and (gateway_id='md' or gateway_id='#')) order by priority desc, id limit %size% offset %begin%";
                    string5 = string5.replaceAll("%begin%", "0");
                    string5 = string5.replaceAll("%size%", "" + Integer.parseInt(this.getProperty("batch_size", "50")));
                } else {
                    string5 = "select * from " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " where (status = 'F' and (gateway_id='*' or gateway_id = '$') and errors>'" + n3 + "' and errors<'" + n + "') or (status = 'U' and (gateway_id='md' or gateway_id='#')) order by priority desc, id limit %begin% , %size%";
                    string5 = string5.replaceAll("%begin%", "0");
                    string5 = string5.replaceAll("%size%", "" + Integer.parseInt(this.getProperty("batch_size", "50")));
                }
                JDSMSServer.getInstance().userConsolePrint("x", "get send4gate2:" + string5);
                resultSet = statement.executeQuery(string5);
            }
            PreparedStatement preparedStatement2 = connection.prepareStatement("update " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " set status = 'F',sent_date=? where id = ? ");
            while (resultSet.next() && n2 <= Integer.parseInt(this.getProperty("batch_size", "50"))) {
                Object object;
                OutboundMessage outboundMessage;
                if (!this.getServer().checkPriorityTimeFrame(resultSet.getInt("priority"))) continue;
                String string6 = resultSet.getString("recipient");
                if (StringUtils.isEmpty((CharSequence)string6) || !string6.matches("\\+?\\d{1,25}")) {
                    preparedStatement2.setTimestamp(1, new Timestamp(System.currentTimeMillis()));
                    preparedStatement2.setLong(2, resultSet.getLong("id"));
                    preparedStatement2.addBatch();
                    continue;
                }
                if (resultSet.getTimestamp("sent_date") != null && System.currentTimeMillis() < resultSet.getTimestamp("sent_date").getTime()) continue;
                switch (resultSet.getString("type").charAt(0)) {
                    case 'O': {
                        Object object2;
                        switch (resultSet.getString("encoding").charAt(0)) {
                            case '7': {
                                outboundMessage = new OutboundMessage(resultSet.getString("recipient").trim(), resultSet.getString("text").trim());
                                outboundMessage.setEncoding(Message.MessageEncodings.ENC7BIT);
                                break;
                            }
                            case '8': {
                                object = resultSet.getString("text").trim();
                                object2 = new byte[((String)object).length() / 2];
                                for (int i = 0; i < ((String)object).length(); i += 2) {
                                    int n4 = Integer.parseInt("" + ((String)object).charAt(i), 16) * 16 + Integer.parseInt("" + ((String)object).charAt(i + 1), 16);
                                    object2[i / 2] = (OutboundWapSIMessage.WapSISignals)((byte)n4);
                                }
                                outboundMessage = new OutboundBinaryMessage(resultSet.getString("recipient").trim(), (byte[])object2);
                                break;
                            }
                            case 'U': {
                                outboundMessage = new OutboundMessage(resultSet.getString("recipient").trim(), resultSet.getString("text").trim());
                                outboundMessage.setEncoding(Message.MessageEncodings.ENCUCS2);
                                break;
                            }
                            default: {
                                outboundMessage = new OutboundMessage(resultSet.getString("recipient").trim(), resultSet.getString("text").trim());
                                outboundMessage.setEncoding(Message.MessageEncodings.ENC7BIT);
                            }
                        }
                        if (resultSet.getInt("flash_sms") == 1) {
                            outboundMessage.setFlashSms(true);
                        }
                        if (resultSet.getInt("src_port") == -1) break;
                        outboundMessage.setSrcPort(resultSet.getInt("src_port"));
                        outboundMessage.setDstPort(resultSet.getInt("dst_port"));
                        break;
                    }
                    case 'W': {
                        Object object2;
                        if (resultSet.getTime("wap_expiry_date") == null) {
                            Calendar calendar = Calendar.getInstance();
                            calendar.setTime(new Date());
                            calendar.add(6, 7);
                            object = calendar.getTime();
                        } else {
                            object = resultSet.getTimestamp("wap_expiry_date");
                        }
                        if (resultSet.getString("wap_signal") == null) {
                            object2 = OutboundWapSIMessage.WapSISignals.NONE;
                        } else {
                            switch (resultSet.getString("wap_signal").charAt(0)) {
                                case 'N': {
                                    object2 = OutboundWapSIMessage.WapSISignals.NONE;
                                    break;
                                }
                                case 'L': {
                                    object2 = OutboundWapSIMessage.WapSISignals.LOW;
                                    break;
                                }
                                case 'M': {
                                    object2 = OutboundWapSIMessage.WapSISignals.MEDIUM;
                                    break;
                                }
                                case 'H': {
                                    object2 = OutboundWapSIMessage.WapSISignals.HIGH;
                                    break;
                                }
                                case 'D': {
                                    object2 = OutboundWapSIMessage.WapSISignals.DELETE;
                                    break;
                                }
                                default: {
                                    object2 = OutboundWapSIMessage.WapSISignals.NONE;
                                }
                            }
                        }
                        outboundMessage = new OutboundWapSIMessage(resultSet.getString("recipient").trim(), new URL(resultSet.getString("wap_url").trim()), resultSet.getString("text").trim(), (Date)object, (OutboundWapSIMessage.WapSISignals)((Object)object2));
                        break;
                    }
                    default: {
                        throw new Exception("Message type '" + resultSet.getString("type") + "' is unknown!");
                    }
                }
                outboundMessage.setPriority(resultSet.getInt("priority"));
                if (resultSet.getInt("status_report") == 1) {
                    outboundMessage.setStatusReport(true);
                }
                if (resultSet.getString("originator") != null && resultSet.getString("originator").length() > 0) {
                    outboundMessage.setFrom(resultSet.getString("originator").trim());
                }
                object = resultSet.getString("gateway_id").trim();
                if (!"#".equals(string4)) {
                    if ("*".equals(object) || "$".equals(object)) {
                        preparedStatement.setInt(1, resultSet.getInt("errors"));
                        preparedStatement.setString(2, "#");
                        outboundMessage.setGatewayId("#");
                        JDSMSServer.getInstance().userConsolePrint("x", "update gateway from " + (String)object + " to #");
                    } else {
                        preparedStatement.setInt(1, resultSet.getInt("errors"));
                        preparedStatement.setString(2, (String)object);
                        outboundMessage.setGatewayId((String)object);
                    }
                    preparedStatement.setInt(3, resultSet.getInt("id"));
                } else {
                    outboundMessage.setGatewayId((String)object);
                    preparedStatement.setInt(1, resultSet.getInt("id"));
                }
                JDSMSServer.getInstance().userConsolePrint("m", "#check message: gateid=" + outboundMessage.getGatewayId() + " msgid=" + resultSet.getInt("id"));
                arrayList.add(outboundMessage);
                this.getMessageCache().put(outboundMessage.getMessageId(), resultSet.getInt("id"));
                preparedStatement.addBatch();
                ++n2;
            }
            preparedStatement2.executeBatch();
            preparedStatement.executeBatch();
            resultSet.close();
            statement.close();
            preparedStatement.close();
            preparedStatement2.close();
        }
        catch (Exception exception) {
            try {
                if (connection != null) {
                    connection.close();
                }
                this._$1(connection);
            }
            catch (Exception exception2) {
                // empty catch block
            }
            Logger.getInstance().logError(String.format("SQL failure, will retry in %d seconds...", this._$8 * 1), exception, null);
            Thread.sleep(this._$8 * 1000);
            this._$8 *= 2;
            if (this._$8 == 64) {
                this._$8 = 1;
            }
        }
        finally {
            SysLock.getInstance().setbusy(false);
            this._$1(connection);
        }
        SysLock.getInstance().setbusy(false);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<OutboundMessage> getMessagesToSend4Phone() throws Exception {
        int n;
        while (!SysLock.getInstance().canUse()) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        Connection connection = null;
        ArrayList<OutboundMessage> arrayList = new ArrayList<OutboundMessage>();
        boolean bl = false;
        if (JDSMSServer.getInstance().getProperties().getString("db1.type", "mysql").equals("oracle")) {
            bl = true;
        }
        boolean bl2 = false;
        if (JDSMSServer.getInstance().getProperties().getString("db1.type", "mysql").equals("mssql")) {
            bl2 = true;
        }
        boolean bl3 = false;
        if (JDSMSServer.getInstance().getProperties().getString("db1.type", "mysql").equals("postgresql")) {
            bl3 = true;
        }
        List<String> list = PhoneInfoCache.getInstance().getUsingPhoneNos();
        int n2 = n = list.size();
        if (0 == n) {
            n2 = 1;
        }
        if (PhoneInfoCache.getInstance().getMessagesCounts() >= n2 * Integer.parseInt(this.getProperty("phone_message_size", "50"))) {
            list.clear();
            SysLock.getInstance().setbusy(false);
            return arrayList;
        }
        boolean bl4 = false;
        if (0 == PhoneInfoCache.getInstance().getRealUsingPhones().size()) {
            bl4 = true;
        }
        String string = JDSMSServer.getInstance().getProperties().getString("settings.device_using", "yes");
        String string2 = JDSMSServer.getInstance().getProperties().getString("settings.phone_using", "yes");
        String string3 = JDSMSServer.getInstance().getProperties().getString("settings.gateway_using", "yes");
        String string4 = this._$1();
        int n3 = 0;
        if (string.equals("yes")) {
            ++n3;
        }
        if (string3.equals("yes")) {
            ++n3;
        }
        if (string2.equals("yes")) {
            ++n3;
        }
        n3 *= 3;
        try {
            PreparedStatement preparedStatement;
            ResultSet resultSet = null;
            int n4 = 1;
            connection = this._$3();
            Statement statement = connection.createStatement(1005, 1008);
            if (!"$".equals(string4)) {
                preparedStatement = connection.prepareStatement("update " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " set status = 'Q',errors=?,gateway_id=? where id = ? ");
                JDSMSServer.getInstance().userConsolePrint("x", "send4phone update1: update " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " set status = 'Q',errors=?,gateway_id=? where id = ? ");
            } else {
                preparedStatement = connection.prepareStatement("update " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " set status = 'Q' where id = ? ");
                JDSMSServer.getInstance().userConsolePrint("x", "send4phone update2: update " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " set status = 'Q' where id = ? ");
            }
            String string5 = "";
            int n5 = Integer.parseInt(this.getProperty("retries", "2"));
            if ("$".equals(string4)) {
                if (bl) {
                    string5 = "select * from " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " where status = 'U' and (gateway_id= '$' or (gateway_id <> '*' and gateway_id <> '#' and gateway_id <> 'md' and gateway_id not like 'modem%' and gateway_id <> '@' and gateway_id not like 'lora%' and gateway_id <> '~' and gateway_id not like 'nbiot%' and gateway_id <> '-' and gateway_id not like 'BD%')) and rownum <= %size% order by priority desc, id";
                    string5 = string5.replaceAll("%size%", "" + n * Integer.parseInt(this.getProperty("phone_message_size", "50")));
                } else if (bl2) {
                    string5 = "select top %size% * from " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " where status = 'U' and (gateway_id= '$' or (gateway_id <> '*' and gateway_id <> '#' and gateway_id <> 'md' and gateway_id not like 'modem%' and gateway_id <> '@' and gateway_id not like 'lora%' and gateway_id <> '~' and gateway_id not like 'nbiot%' and gateway_id <> '-' and gateway_id not like 'BD%')) order by priority desc, id";
                    string5 = string5.replaceAll("%size%", "" + n * Integer.parseInt(this.getProperty("phone_message_size", "50")));
                } else if (bl3) {
                    string5 = "select * from " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " where status = 'U' and (gateway_id= '$' or (gateway_id <> '*' and gateway_id <> '#' and gateway_id <> 'md' and gateway_id not like 'modem%' and gateway_id <> '@' and gateway_id not like 'lora%' and gateway_id <> '~' and gateway_id not like 'nbiot%' and gateway_id <> '-' and gateway_id not like 'BD%')) order by priority desc, id limit %size% offset %begin%";
                    string5 = string5.replaceAll("%begin%", "0");
                    string5 = string5.replaceAll("%size%", "" + Integer.parseInt(this.getProperty("batch_size", "50")));
                } else {
                    string5 = "select * from " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " where status = 'U' and (gateway_id= '$' or (gateway_id <> '*' and gateway_id <> '#' and gateway_id <> 'md' and gateway_id not like 'modem%' and gateway_id <> '@' and gateway_id not like 'lora%' and gateway_id <> '~' and gateway_id not like 'nbiot%' and gateway_id <> '-' and gateway_id not like 'BD%')) order by priority desc, id limit %begin% , %size%";
                    string5 = string5.replaceAll("%begin%", "0");
                    string5 = string5.replaceAll("%size%", "" + n * Integer.parseInt(this.getProperty("phone_message_size", "50")));
                }
                JDSMSServer.getInstance().userConsolePrint("x", "get send4phone1:" + string5);
                resultSet = statement.executeQuery(string5);
            }
            if (!"$".equals(string4)) {
                if (bl) {
                    string5 = "select * from " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " where (status = 'F' and (gateway_id = '*' or gateway_id = '#') and errors>'" + n5 + "'and errors<'" + n3 + "') or (status = 'U' and (gateway_id= '$' or (gateway_id <> '*' and gateway_id <> '#' and gateway_id <> 'md' and gateway_id not like 'modem%' and gateway_id <> '@' and gateway_id not like 'lora%' and gateway_id <> '~' and gateway_id not like 'nbiot%' and gateway_id <> '-' and gateway_id not like 'BD%'))) and rownum <= %size% order by priority desc, id";
                    string5 = string5.replaceAll("%size%", "" + n * Integer.parseInt(this.getProperty("phone_message_size", "50")));
                } else if (bl2) {
                    string5 = "select top %size% * from " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " where (status = 'F' and (gateway_id = '*' or gateway_id = '#') and errors>'" + n5 + "'and errors<'" + n3 + "') or (status = 'U' and (gateway_id= '$' or (gateway_id <> '*' and gateway_id <> '#' and gateway_id <> 'md' and gateway_id not like 'modem%' and gateway_id <> '@' and gateway_id not like 'lora%' and gateway_id <> '~' and gateway_id not like 'nbiot%' and gateway_id <> '-' and gateway_id not like 'BD%'))) order by priority desc, id";
                    string5 = string5.replaceAll("%size%", "" + n * Integer.parseInt(this.getProperty("phone_message_size", "50")));
                } else if (bl3) {
                    string5 = "select * from " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " where (status = 'F' and (gateway_id = '*' or gateway_id = '#') and errors>'" + n5 + "'and errors<'" + n3 + "') or (status = 'U' and (gateway_id= '$' or (gateway_id <> '*' and gateway_id <> '#' and gateway_id <> 'md' and gateway_id not like 'modem%' and gateway_id <> '@' and gateway_id not like 'lora%' and gateway_id <> '~' and gateway_id not like 'nbiot%' and gateway_id <> '-' and gateway_id not like 'BD%'))) order by priority desc, id limit %size% offset %begin%";
                    string5 = string5.replaceAll("%begin%", "0");
                    string5 = string5.replaceAll("%size%", "" + Integer.parseInt(this.getProperty("batch_size", "50")));
                } else {
                    string5 = "select * from " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " where (status = 'F' and (gateway_id = '*' or gateway_id = '#') and errors>'" + n5 + "'and errors<'" + n3 + "') or (status = 'U' and (gateway_id= '$' or (gateway_id <> '*' and gateway_id <> '#' and gateway_id <> 'md' and gateway_id not like 'modem%' and gateway_id <> '@' and gateway_id not like 'lora%' and gateway_id <> '~' and gateway_id not like 'nbiot%' and gateway_id <> '-' and gateway_id not like 'BD%'))) order by priority desc, id limit %begin% , %size%";
                    string5 = string5.replaceAll("%begin%", "0");
                    string5 = string5.replaceAll("%size%", "" + n * Integer.parseInt(this.getProperty("phone_message_size", "50")));
                }
                JDSMSServer.getInstance().userConsolePrint("x", "get send4phone2:" + string5);
                resultSet = statement.executeQuery(string5);
            }
            PreparedStatement preparedStatement2 = connection.prepareStatement("update " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " set status = 'F',sent_date=? where id = ? ");
            while (resultSet.next() && n4 <= n2 * Integer.parseInt(this.getProperty("phone_message_size"))) {
                int n6;
                Object object;
                Object object2;
                OutboundMessage outboundMessage;
                if (!this.getServer().checkPriorityTimeFrame(resultSet.getInt("priority"))) continue;
                String string6 = resultSet.getString("recipient");
                if (StringUtils.isEmpty((CharSequence)string6) || !string6.matches("\\+?\\d{1,25}")) {
                    preparedStatement2.setTimestamp(1, new Timestamp(System.currentTimeMillis()));
                    preparedStatement2.setLong(2, resultSet.getLong("id"));
                    preparedStatement2.addBatch();
                    continue;
                }
                if (resultSet.getTimestamp("sent_date") != null && System.currentTimeMillis() < resultSet.getTimestamp("sent_date").getTime()) continue;
                switch (resultSet.getString("type").charAt(0)) {
                    case 'O': {
                        switch (resultSet.getString("encoding").charAt(0)) {
                            case '7': {
                                outboundMessage = new OutboundMessage(resultSet.getString("recipient").trim(), resultSet.getString("text").trim());
                                outboundMessage.setEncoding(Message.MessageEncodings.ENC7BIT);
                                break;
                            }
                            case '8': {
                                object2 = resultSet.getString("text").trim();
                                object = new byte[((String)object2).length() / 2];
                                for (int i = 0; i < ((String)object2).length(); i += 2) {
                                    n6 = Integer.parseInt("" + ((String)object2).charAt(i), 16) * 16 + Integer.parseInt("" + ((String)object2).charAt(i + 1), 16);
                                    object[i / 2] = (OutboundWapSIMessage.WapSISignals)((byte)n6);
                                }
                                outboundMessage = new OutboundBinaryMessage(resultSet.getString("recipient").trim(), (byte[])object);
                                break;
                            }
                            case 'U': {
                                outboundMessage = new OutboundMessage(resultSet.getString("recipient").trim(), resultSet.getString("text").trim());
                                outboundMessage.setEncoding(Message.MessageEncodings.ENCUCS2);
                                break;
                            }
                            default: {
                                outboundMessage = new OutboundMessage(resultSet.getString("recipient").trim(), resultSet.getString("text").trim());
                                outboundMessage.setEncoding(Message.MessageEncodings.ENC7BIT);
                            }
                        }
                        if (resultSet.getInt("flash_sms") == 1) {
                            outboundMessage.setFlashSms(true);
                        }
                        if (resultSet.getInt("src_port") == -1) break;
                        outboundMessage.setSrcPort(resultSet.getInt("src_port"));
                        outboundMessage.setDstPort(resultSet.getInt("dst_port"));
                        break;
                    }
                    case 'W': {
                        if (resultSet.getTime("wap_expiry_date") == null) {
                            Calendar calendar = Calendar.getInstance();
                            calendar.setTime(new Date());
                            calendar.add(6, 7);
                            object2 = calendar.getTime();
                        } else {
                            object2 = resultSet.getTimestamp("wap_expiry_date");
                        }
                        if (resultSet.getString("wap_signal") == null) {
                            object = OutboundWapSIMessage.WapSISignals.NONE;
                        } else {
                            switch (resultSet.getString("wap_signal").charAt(0)) {
                                case 'N': {
                                    object = OutboundWapSIMessage.WapSISignals.NONE;
                                    break;
                                }
                                case 'L': {
                                    object = OutboundWapSIMessage.WapSISignals.LOW;
                                    break;
                                }
                                case 'M': {
                                    object = OutboundWapSIMessage.WapSISignals.MEDIUM;
                                    break;
                                }
                                case 'H': {
                                    object = OutboundWapSIMessage.WapSISignals.HIGH;
                                    break;
                                }
                                case 'D': {
                                    object = OutboundWapSIMessage.WapSISignals.DELETE;
                                    break;
                                }
                                default: {
                                    object = OutboundWapSIMessage.WapSISignals.NONE;
                                }
                            }
                        }
                        outboundMessage = new OutboundWapSIMessage(resultSet.getString("recipient").trim(), new URL(resultSet.getString("wap_url").trim()), resultSet.getString("text").trim(), (Date)object2, (OutboundWapSIMessage.WapSISignals)((Object)object));
                        break;
                    }
                    default: {
                        throw new Exception("Message type '" + resultSet.getString("type") + "' is unknown!");
                    }
                }
                outboundMessage.setPriority(resultSet.getInt("priority"));
                if (resultSet.getInt("status_report") == 1) {
                    outboundMessage.setStatusReport(true);
                }
                if (resultSet.getString("originator") != null && resultSet.getString("originator").length() > 0) {
                    outboundMessage.setFrom(resultSet.getString("originator").trim());
                }
                object2 = resultSet.getString("gateway_id").trim();
                if (!"$".equals(string4)) {
                    if ("*".equals(object2) || "#".equals(object2)) {
                        preparedStatement.setInt(1, resultSet.getInt("errors"));
                        preparedStatement.setString(2, "$");
                        outboundMessage.setGatewayId("$");
                        JDSMSServer.getInstance().userConsolePrint("x", "update gateway from " + (String)object2 + " to $");
                    } else {
                        preparedStatement.setInt(1, resultSet.getInt("errors"));
                        preparedStatement.setString(2, (String)object2);
                        outboundMessage.setGatewayId((String)object2);
                    }
                    preparedStatement.setInt(3, resultSet.getInt("id"));
                } else {
                    outboundMessage.setGatewayId((String)object2);
                    preparedStatement.setInt(1, resultSet.getInt("id"));
                }
                if (!bl4) {
                    object = list.get((n4 - 1) % n);
                    String string7 = PhoneInfoCache.getInstance().getUsingPhoneIMEI((String)object);
                    n6 = Authorize1.isAuthorized2(string7) ? 1 : 0;
                    if (n6 == 0) {
                        outboundMessage.setText("<\u8bf7\u586b\u5199\u8bbe\u5907\u6ce8\u518c\u7801>" + outboundMessage.getText());
                        int n7 = Authorize1.getAvaliableNum(string7);
                        if (n7 < 0) {
                            Logger.getInstance().logWarn("\u624b\u673a\u672a\u6388\u6743\uff0c\u6536\u53d1\u77ed\u4fe1\u6761\u6570\u5df2\u8fbe\u5230\u6700\u5927\u9650\u5236\u657088\u6761,\u5df2\u505c\u6b62\u6536\u53d1\u77ed\u4fe1", null, (String)object);
                            PhoneInfoCache.getInstance().setRealUsingPhoneFlag((String)object, "0");
                            resultSet.close();
                            statement.close();
                            preparedStatement.close();
                            break;
                        }
                    }
                }
                if (bl4) {
                    object = arrayList;
                    return object;
                }
                JDSMSServer.getInstance().userConsolePrint("m", "$check message: gateid=" + outboundMessage.getGatewayId() + " msgid=" + resultSet.getInt("id"));
                arrayList.add(outboundMessage);
                this.getMessageCache().put(outboundMessage.getMessageId(), resultSet.getInt("id"));
                preparedStatement.addBatch();
                ++n4;
            }
            preparedStatement2.executeBatch();
            preparedStatement.executeBatch();
            resultSet.close();
            statement.close();
            preparedStatement.close();
            preparedStatement2.close();
        }
        catch (Exception exception) {
            Logger.getInstance().logError(String.format("SQL failure, will retry in %d seconds...", this._$8 * 1), exception, null);
            Thread.sleep(this._$8 * 1000);
            this._$8 *= 2;
            if (this._$8 == 64) {
                this._$8 = 1;
            }
        }
        finally {
            SysLock.getInstance().setbusy(false);
            this._$1(connection);
        }
        list.clear();
        SysLock.getInstance().setbusy(false);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getPendingMessagesToSend() throws Exception {
        int n = -1;
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = this._$3();
            statement = connection.createStatement(1005, 1007);
            resultSet = statement.executeQuery("select count(*) as cnt from " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " where status in ('U', 'Q')");
            if (resultSet.next()) {
                n = resultSet.getInt("cnt");
            }
        }
        catch (Exception exception) {
            Logger.getInstance().logError(String.format("SQL failure, will retry in %d seconds...", this._$8 * 1), exception, null);
            Thread.sleep(this._$8 * 1000);
            this._$8 *= 2;
            if (this._$8 == 64) {
                this._$8 = 1;
            }
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (statement != null) {
                statement.close();
            }
            this._$1(connection);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void markMessage(OutboundMessage outboundMessage) throws Exception {
        Connection connection = null;
        if (this.getMessageCache().get(outboundMessage.getMessageId()) == null) {
            return;
        }
        try {
            int n = 0;
            connection = this._$3();
            PreparedStatement preparedStatement = connection.prepareStatement("select errors,sent_date from " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " where id = ?");
            preparedStatement.setInt(1, (Integer)this.getMessageCache().get(outboundMessage.getMessageId()));
            ResultSet resultSet = preparedStatement.executeQuery();
            Timestamp timestamp = null;
            while (resultSet.next()) {
                n = resultSet.getInt("errors");
                timestamp = resultSet.getTimestamp("sent_date");
            }
            resultSet.close();
            preparedStatement.close();
            if (outboundMessage.getMessageStatus() == OutboundMessage.MessageStatuses.SENT) {
                PreparedStatement preparedStatement2 = connection.prepareStatement("update " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " set status = ?, sent_date = ?, gateway_id = ?, ref_no = ? where id = ?");
                preparedStatement2.setString(1, "S");
                preparedStatement2.setTimestamp(2, new Timestamp(outboundMessage.getDispatchDate().getTime()));
                preparedStatement2.setString(3, outboundMessage.getGatewayId());
                preparedStatement2.setString(4, outboundMessage.getRefNo());
                preparedStatement2.setInt(5, (Integer)this.getMessageCache().get(outboundMessage.getMessageId()));
                preparedStatement2.executeUpdate();
                preparedStatement2.close();
            } else if (outboundMessage.getMessageStatus() == OutboundMessage.MessageStatuses.UNSENT || outboundMessage.getMessageStatus() == OutboundMessage.MessageStatuses.FAILED && outboundMessage.getFailureCause() == OutboundMessage.FailureCauses.NO_ROUTE) {
                PreparedStatement preparedStatement3 = connection.prepareStatement("update " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " set status = ? where id = ?");
                preparedStatement3.setString(1, "U");
                preparedStatement3.setInt(2, (Integer)this.getMessageCache().get(outboundMessage.getMessageId()));
                preparedStatement3.executeUpdate();
                preparedStatement3.close();
            } else if (outboundMessage.getMessageStatus() == OutboundMessage.MessageStatuses.FAILED && outboundMessage.getSendFlag()) {
                PreparedStatement preparedStatement4 = connection.prepareStatement("update " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " set status = ?, errors = ?,sent_date=? where id = ?");
                ++n;
                int n2 = Integer.parseInt(this.getProperty("retries", "2"));
                while (0 != n % (n2 + 1)) {
                    ++n;
                }
                if (n % (n2 + 1) == 0) {
                    preparedStatement4.setString(1, "F");
                    preparedStatement4.setTimestamp(3, new Timestamp(System.currentTimeMillis()));
                } else {
                    preparedStatement4.setString(1, "U");
                    preparedStatement4.setTimestamp(3, timestamp);
                }
                preparedStatement4.setInt(2, n);
                preparedStatement4.setInt(4, (Integer)this.getMessageCache().get(outboundMessage.getMessageId()));
                preparedStatement4.executeUpdate();
                preparedStatement4.close();
            } else {
                PreparedStatement preparedStatement5 = connection.prepareStatement("update " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " set status = ?, errors = ?,sent_date=? where id = ?");
                if (++n % (Integer.parseInt(this.getProperty("retries", "2")) + 1) == 0) {
                    preparedStatement5.setString(1, "F");
                    preparedStatement5.setTimestamp(3, new Timestamp(System.currentTimeMillis()));
                } else {
                    preparedStatement5.setString(1, "U");
                    preparedStatement5.setTimestamp(3, timestamp);
                }
                preparedStatement5.setInt(2, n);
                preparedStatement5.setInt(4, (Integer)this.getMessageCache().get(outboundMessage.getMessageId()));
                preparedStatement5.executeUpdate();
                preparedStatement5.close();
            }
        }
        catch (Exception exception) {
            try {
                if (connection != null) {
                    connection.close();
                }
                this._$1(connection);
            }
            catch (Exception exception2) {
                // empty catch block
            }
            Logger.getInstance().logError(String.format("SQL failure, will retry in %d seconds...", this._$8 * 1), exception, null);
            Thread.sleep(this._$8 * 1000);
            this._$8 *= 2;
            if (this._$8 == 64) {
                this._$8 = 1;
            }
        }
        finally {
            this._$1(connection);
        }
        this.getMessageCache().remove(outboundMessage.getMessageId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markMessages4GatewayFail(List<OutboundMessage> list) throws Exception {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        try {
            connection = this._$3();
            connection.setAutoCommit(false);
            preparedStatement = connection.prepareStatement("update " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " set status = ?,gateway_id = ? where id = ?");
            for (int i = 0; i < list.size(); ++i) {
                OutboundMessage outboundMessage = list.get(i);
                if (this.getMessageCache().get(outboundMessage.getMessageId()) == null) continue;
                String string = JDSMSServer.getInstance().getProperties().getString("settings.device_using", "yes");
                String string2 = JDSMSServer.getInstance().getProperties().getString("settings.phone_using", "yes");
                int n = Integer.parseInt(JDSMSServer.getInstance().getProperties().getString("settings.using_sorted", "0"));
                boolean bl = false;
                for (AGateway aGateway : Service.getInstance().getGateways()) {
                    if (!aGateway.isOutbound() || aGateway.getStatus() != AGatewayHelper.GatewayStatuses.STARTED) continue;
                    bl = true;
                    break;
                }
                Iterator<AGateway> iterator = null;
                switch (n) {
                    case 0: 
                    case 3: 
                    case 4: {
                        if (string2.equals("yes") && PhoneInfoCache.getInstance().getUsingPhones().size() > 0) {
                            preparedStatement.setString(1, "U");
                            preparedStatement.setString(2, "$");
                            break;
                        }
                        if (string.equals("yes") && bl) {
                            preparedStatement.setString(1, "U");
                            preparedStatement.setString(2, "*");
                            break;
                        }
                        preparedStatement.setString(1, "U");
                        preparedStatement.setString(2, "#");
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 5: {
                        if (string.equals("yes") && bl) {
                            preparedStatement.setString(1, "U");
                            preparedStatement.setString(2, "*");
                            break;
                        }
                        if (string2.equals("yes") && PhoneInfoCache.getInstance().getUsingPhones().size() > 0) {
                            preparedStatement.setString(1, "U");
                            preparedStatement.setString(2, "$");
                            break;
                        }
                        preparedStatement.setString(1, "U");
                        preparedStatement.setString(2, "#");
                        break;
                    }
                }
                preparedStatement.setInt(3, (Integer)this.getMessageCache().get(outboundMessage.getMessageId()));
                preparedStatement.addBatch();
                this.getMessageCache().remove(outboundMessage.getMessageId());
            }
            preparedStatement.executeBatch();
            preparedStatement.close();
        }
        catch (Exception exception) {
            try {
                connection.rollback();
                if (connection != null) {
                    connection.close();
                }
                this._$1(connection);
            }
            catch (Exception exception2) {
                // empty catch block
            }
            Logger.getInstance().logError(String.format("SQL failure, will retry in %d seconds...", this._$8 * 1), exception, null);
            Thread.sleep(this._$8 * 1000);
            this._$8 *= 2;
            if (this._$8 == 64) {
                this._$8 = 1;
            }
        }
        finally {
            this._$1(connection);
        }
    }

    private Connection _$3() throws Exception {
        Connection connection = null;
        ConnectionPool connectionPool = ConnectionPool.getInstance();
        if (!connectionPool.isPoolCreate()) {
            connectionPool.createPool();
        }
        connection = connectionPool.getConnection();
        return connection;
    }

    private void _$1(Connection connection) {
        ConnectionPool connectionPool = ConnectionPool.getInstance();
        try {
            connectionPool.returnConnection(connection);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void _$2() {
        ConnectionPool connectionPool = ConnectionPool.getInstance();
        try {
            connectionPool.closeConnectionPool();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<OutboundMessage> getMessagesToSendLora() throws Exception {
        int n = 0;
        while (!SysLock.getInstance().canUse()) {
            try {
                Thread.sleep(50L);
                if (n++ <= 50) continue;
                Logger.getInstance().logError("\u81ea\u65cb\u7b49\u5f85\u8d85\u8fc72\u79d2", null, null);
            }
            catch (InterruptedException interruptedException) {
                Logger.getInstance().logError("\u53d6\u5f85\u53d1\u77ed\u4fe1\u65f6\u4ea7\u751f\u4e2d\u65ad\u5f02\u5e38", interruptedException, null);
            }
        }
        Connection connection = null;
        ArrayList<OutboundMessage> arrayList = new ArrayList<OutboundMessage>();
        boolean bl = false;
        if (JDSMSServer.getInstance().getProperties().getString("db1.type", "mysql").equals("oracle") || JDSMSServer.getInstance().getProperties().getString("db1.type", "mysql").equals("oracle-rac")) {
            bl = true;
        }
        boolean bl2 = false;
        if (JDSMSServer.getInstance().getProperties().getString("db1.type", "mysql").equals("mssql")) {
            bl2 = true;
        }
        boolean bl3 = false;
        if (JDSMSServer.getInstance().getProperties().getString("db1.type", "mysql").equals("postgresql")) {
            bl3 = true;
        }
        String string = JDSMSServer.getInstance().getProperties().getString("settings.lora_using", "no");
        int n2 = Integer.parseInt(this.getProperty("retries", "2"));
        try {
            ResultSet resultSet = null;
            int n3 = 1;
            connection = this._$3();
            Statement statement = connection.createStatement(1005, 1008);
            if ("no".equals(string)) {
                ArrayList<OutboundMessage> arrayList2 = arrayList;
                return arrayList2;
            }
            PreparedStatement preparedStatement = connection.prepareStatement("update " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " set status = 'Q' where id = ? ");
            String string2 = "";
            if (bl) {
                string2 = "select * from " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " where (status = 'U' or (status = 'F' and errors < " + n2 + ")) and (gateway_id = '@' or gateway_id like 'lora%') and rownum <= %size% order by priority desc, id";
                string2 = string2.replaceAll("%size%", "" + Integer.parseInt(this.getProperty("batch_size", "50")));
            } else if (bl2) {
                string2 = "select top %size% * from " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " where (status = 'U' or (status = 'F' and errors < " + n2 + ")) and (gateway_id = '@' or gateway_id like 'lora%') order by priority desc, id";
                string2 = string2.replaceAll("%size%", "" + Integer.parseInt(this.getProperty("batch_size", "50")));
            } else if (bl3) {
                string2 = "select * from " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " where (status = 'U' or (status = 'F' and errors < " + n2 + ")) and (gateway_id = '@' or gateway_id like 'lora%') order by priority desc, id limit %size% offset %begin%";
                string2 = string2.replaceAll("%begin%", "0");
                string2 = string2.replaceAll("%size%", "" + Integer.parseInt(this.getProperty("batch_size", "50")));
            } else {
                string2 = "select * from " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " where (status = 'U' or (status = 'F' and errors < " + n2 + ")) and (gateway_id = '@' or gateway_id like 'lora%') order by priority desc, id limit %begin% , %size%";
                string2 = string2.replaceAll("%begin%", "0");
                string2 = string2.replaceAll("%size%", "" + Integer.parseInt(this.getProperty("batch_size", "50")));
            }
            JDSMSServer.getInstance().userConsolePrint("x", "get send lora:" + string2);
            resultSet = statement.executeQuery(string2);
            if (resultSet == null) {
                Logger.getInstance().logError("\u914d\u7f6e\u6587\u4ef6\u8bbe\u5907\u6a21\u5f0f\u4e22\u5931,\u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6", null, null);
                ArrayList<OutboundMessage> arrayList3 = arrayList;
                return arrayList3;
            }
            Logger.getInstance().logDebug("sql\u67e5\u8be2=" + string2, null, null);
            PreparedStatement preparedStatement2 = connection.prepareStatement("update " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " set status = 'F',sent_date=? where id = ? ");
            while (resultSet.next() && n3 <= Integer.parseInt(this.getProperty("batch_size", "50"))) {
                Object object;
                OutboundMessage outboundMessage;
                if (!this.getServer().checkPriorityTimeFrame(resultSet.getInt("priority"))) continue;
                String string3 = resultSet.getString("recipient");
                if (StringUtils.isEmpty((CharSequence)string3) || string3.length() != 4 || !string3.matches("[A-F,a-f,0-9]+")) {
                    Logger.getInstance().logDebug("\u6536\u4fe1\u5730\u5740" + string3 + "\u4e0d\u5408\u6cd5!", null, null);
                    preparedStatement2.setTimestamp(1, new Timestamp(System.currentTimeMillis()));
                    preparedStatement2.setLong(2, resultSet.getLong("id"));
                    preparedStatement2.addBatch();
                    continue;
                }
                if (resultSet.getTimestamp("sent_date") != null && System.currentTimeMillis() < resultSet.getTimestamp("sent_date").getTime()) continue;
                switch (resultSet.getString("type").charAt(0)) {
                    case 'O': {
                        switch (resultSet.getString("encoding").charAt(0)) {
                            case '7': {
                                outboundMessage = new OutboundMessage(resultSet.getString("recipient").trim(), resultSet.getString("text").trim());
                                outboundMessage.setEncoding(Message.MessageEncodings.ENC7BIT);
                                break;
                            }
                            case '8': {
                                outboundMessage = new OutboundMessage(resultSet.getString("recipient").trim(), resultSet.getString("text").trim());
                                outboundMessage.setEncodingForOthers(Message.MessageEncodings.ENC8BIT);
                                break;
                            }
                            case 'U': {
                                outboundMessage = new OutboundMessage(resultSet.getString("recipient").trim(), resultSet.getString("text").trim());
                                outboundMessage.setEncoding(Message.MessageEncodings.ENCUCS2);
                                break;
                            }
                            default: {
                                outboundMessage = new OutboundMessage(resultSet.getString("recipient").trim(), resultSet.getString("text").trim());
                                outboundMessage.setEncoding(Message.MessageEncodings.ENCUCS2);
                            }
                        }
                        if (resultSet.getInt("flash_sms") == 1) {
                            outboundMessage.setFlashSms(true);
                        }
                        if (resultSet.getInt("src_port") == -1) break;
                        outboundMessage.setSrcPort(resultSet.getInt("src_port"));
                        outboundMessage.setDstPort(resultSet.getInt("dst_port"));
                        break;
                    }
                    case 'W': {
                        OutboundWapSIMessage.WapSISignals wapSISignals;
                        if (resultSet.getTime("wap_expiry_date") == null) {
                            Calendar calendar = Calendar.getInstance();
                            calendar.setTime(new Date());
                            calendar.add(6, 7);
                            object = calendar.getTime();
                        } else {
                            object = resultSet.getTimestamp("wap_expiry_date");
                        }
                        if (resultSet.getString("wap_signal") == null) {
                            wapSISignals = OutboundWapSIMessage.WapSISignals.NONE;
                        } else {
                            switch (resultSet.getString("wap_signal").charAt(0)) {
                                case 'N': {
                                    wapSISignals = OutboundWapSIMessage.WapSISignals.NONE;
                                    break;
                                }
                                case 'L': {
                                    wapSISignals = OutboundWapSIMessage.WapSISignals.LOW;
                                    break;
                                }
                                case 'M': {
                                    wapSISignals = OutboundWapSIMessage.WapSISignals.MEDIUM;
                                    break;
                                }
                                case 'H': {
                                    wapSISignals = OutboundWapSIMessage.WapSISignals.HIGH;
                                    break;
                                }
                                case 'D': {
                                    wapSISignals = OutboundWapSIMessage.WapSISignals.DELETE;
                                    break;
                                }
                                default: {
                                    wapSISignals = OutboundWapSIMessage.WapSISignals.NONE;
                                }
                            }
                        }
                        outboundMessage = new OutboundWapSIMessage(resultSet.getString("recipient").trim(), new URL(resultSet.getString("wap_url").trim()), resultSet.getString("text").trim(), (Date)object, wapSISignals);
                        break;
                    }
                    default: {
                        throw new Exception("Message type '" + resultSet.getString("type") + "' is unknown!");
                    }
                }
                outboundMessage.setPriority(resultSet.getInt("priority"));
                if (resultSet.getInt("status_report") == 1) {
                    outboundMessage.setStatusReport(true);
                }
                if (resultSet.getString("originator") != null && resultSet.getString("originator").length() > 0) {
                    outboundMessage.setFrom(resultSet.getString("originator").trim());
                }
                object = resultSet.getString("gateway_id").trim();
                int n4 = resultSet.getInt("id");
                preparedStatement.setInt(1, n4);
                outboundMessage.setGatewayId((String)object);
                int n5 = resultSet.getInt("id") + 100;
                if (n5 > Integer.MAX_VALUE) {
                    Logger.getInstance().logError("\u5df2\u7ecf\u5230\u8fc7\u6570\u636e\u5e93\u6700\u5927\u5bb9\u91cf\uff0c\u8bf7\u66f4\u6362\u6570\u636e\u5e93\uff01", null, null);
                    continue;
                }
                outboundMessage.setMessageID(n5);
                JDSMSServer.getInstance().userConsolePrint("x", "@check message: gateid=" + outboundMessage.getGatewayId() + " msgid=" + resultSet.getInt("id"));
                arrayList.add(outboundMessage);
                this.getMessageCache().put(outboundMessage.getMessageId(), resultSet.getInt("id"));
                preparedStatement.addBatch();
                ++n3;
            }
            preparedStatement2.executeBatch();
            preparedStatement.executeBatch();
            resultSet.close();
            statement.close();
            preparedStatement.close();
            preparedStatement2.close();
        }
        catch (Exception exception) {
            try {
                if (connection != null) {
                    connection.close();
                }
                this._$1(connection);
            }
            catch (Exception exception2) {
                // empty catch block
            }
            Logger.getInstance().logError(String.format("SQL failure, will retry in %d seconds...", this._$8 * 1), exception, null);
            Thread.sleep(this._$8 * 1000);
            this._$8 *= 2;
            if (this._$8 == 64) {
                this._$8 = 1;
            }
        }
        finally {
            SysLock.getInstance().setbusy(false);
            this._$1(connection);
        }
        SysLock.getInstance().setbusy(false);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void LoRaMessagesReceived(Collection<InboundMessage> collection) throws Exception {
        int n = 0;
        while (!SysLock.getInstance().canUse()) {
            try {
                Thread.sleep(50L);
                if (n++ <= 50) continue;
                Logger.getInstance().logError("\u81ea\u65cb\u7b49\u5f85\u8d85\u8fc72\u79d2", null, null);
            }
            catch (InterruptedException interruptedException) {
                Logger.getInstance().logError("\u53d6\u5f85\u53d1\u77ed\u4fe1\u65f6\u4ea7\u751f\u4e2d\u65ad\u5f02\u5e38", interruptedException, null);
            }
        }
        JDSMSServer.getInstance().userConsolePrint("x", "Database LoraMessagesReceiving...");
        Connection connection = null;
        try {
            connection = this._$3();
            PreparedStatement preparedStatement = connection.prepareStatement(" insert into " + this.getProperty("tables.sms_in", "jdsmsserver_in") + " (process, originator, type, encoding, message_date, receive_date, text," + " original_ref_no, original_receive_date, gateway_id) " + " values(?,?,?,?,?,?,?,?,?,?)");
            for (InboundMessage inboundMessage : collection) {
                if (inboundMessage.isError()) {
                    Logger.getInstance().logInfo("\u4fe1\u606f\u3010" + inboundMessage.getText() + "\u3011\u4e0d\u5b8c\u6574\uff0c\u4e0d\u5165\u5e93\u3002", null, null);
                    continue;
                }
                if (inboundMessage.getType() != Message.MessageTypes.INBOUND) continue;
                preparedStatement.setInt(1, 0);
                switch (inboundMessage.getEncoding()) {
                    case ENC7BIT: {
                        preparedStatement.setString(4, "7");
                        break;
                    }
                    case ENC8BIT: {
                        preparedStatement.setString(4, "8");
                        break;
                    }
                    case ENCUCS2: {
                        preparedStatement.setString(4, "U");
                        break;
                    }
                    case ENCCUSTOM: {
                        preparedStatement.setString(4, "C");
                        break;
                    }
                    default: {
                        preparedStatement.setString(4, "U");
                    }
                }
                switch (inboundMessage.getType()) {
                    case INBOUND: {
                        preparedStatement.setString(3, "I");
                        preparedStatement.setString(2, inboundMessage.getOriginator());
                        preparedStatement.setTimestamp(5, new Timestamp(inboundMessage.getDate().getTime()));
                        preparedStatement.setString(8, null);
                        preparedStatement.setTimestamp(9, null);
                        break;
                    }
                }
                preparedStatement.setTimestamp(6, new Timestamp(new Date().getTime()));
                preparedStatement.setString(7, inboundMessage.getText().length() == 0 ? "" : inboundMessage.getText());
                String string = inboundMessage.getGatewayId();
                if (string == null || string.equals("")) {
                    string = "@";
                }
                preparedStatement.setString(10, string);
                preparedStatement.addBatch();
            }
            Iterator<InboundMessage> iterator = null;
            preparedStatement.executeBatch();
            preparedStatement.close();
        }
        catch (Exception exception) {
            try {
                if (connection != null) {
                    connection.close();
                }
                this._$1(connection);
            }
            catch (Exception exception2) {
                // empty catch block
            }
            Logger.getInstance().logError(String.format("SQL failure, will retry in %d seconds...", this._$8 * 1), exception, null);
            Thread.sleep(this._$8 * 1000);
            this._$8 *= 2;
            if (this._$8 == 64) {
                this._$8 = 1;
            }
        }
        finally {
            SysLock.getInstance().setbusy(false);
            this._$1(connection);
        }
        SysLock.getInstance().setbusy(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _$1(Connection connection, InboundMessage inboundMessage) {
        ResultSet resultSet = null;
        Statement statement = null;
        int n = 0;
        try {
            if (inboundMessage.getMessageID() == null || "".equals(inboundMessage.getMessageID())) {
                boolean bl = false;
                return bl;
            }
            statement = connection.prepareStatement("select count(*) from " + this.getProperty("tables.sms_in", "jdsmsserver_in") + " where process = ?  and originator = ?");
            statement.setInt(1, Integer.valueOf(inboundMessage.getMessageID(), 16));
            statement.setString(2, inboundMessage.getOriginator());
            resultSet = statement.executeQuery();
            if (resultSet.next()) {
                n = resultSet.getInt(1);
            }
            resultSet.close();
            statement.close();
        }
        catch (Exception exception) {
            Logger.getInstance().logError("\u6570\u636e\u5e93\u8bbf\u95ee\u5f02\u5e38\uff01", exception, null);
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException sQLException) {
                Logger.getInstance().logError("\u8d44\u6e90\u91ca\u653e\u5931\u8d25(1)\uff01", sQLException, null);
                resultSet = null;
            }
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {
                Logger.getInstance().logError("\u8d44\u6e90\u91ca\u653e\u5931\u8d25\uff01(2)", sQLException, null);
                statement = null;
            }
        }
        return n > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<? extends OutboundMessage> getMessagesToSendNbIoT() throws Exception {
        int n = 0;
        while (!SysLock.getInstance().canUse()) {
            try {
                Thread.sleep(50L);
                if (n++ <= 50) continue;
                Logger.getInstance().logError("\u81ea\u65cb\u7b49\u5f85\u8d85\u8fc72\u79d2", null, null);
            }
            catch (InterruptedException interruptedException) {
                Logger.getInstance().logError("\u53d6\u5f85\u53d1\u77ed\u4fe1\u65f6\u4ea7\u751f\u4e2d\u65ad\u5f02\u5e38", interruptedException, null);
            }
        }
        Connection connection = null;
        ArrayList<OutboundMessage> arrayList = new ArrayList<OutboundMessage>();
        boolean bl = false;
        if (JDSMSServer.getInstance().getProperties().getString("db1.type", "mysql").equals("oracle") || JDSMSServer.getInstance().getProperties().getString("db1.type", "mysql").equals("oracle-rac")) {
            bl = true;
        }
        boolean bl2 = false;
        if (JDSMSServer.getInstance().getProperties().getString("db1.type", "mysql").equals("mssql")) {
            bl2 = true;
        }
        boolean bl3 = false;
        if (JDSMSServer.getInstance().getProperties().getString("db1.type", "mysql").equals("postgresql")) {
            bl3 = true;
        }
        String string = JDSMSServer.getInstance().getProperties().getString("settings.nbiot_using", "no");
        int n2 = Integer.parseInt(this.getProperty("retries", "2"));
        try {
            ResultSet resultSet = null;
            int n3 = 1;
            connection = this._$3();
            Statement statement = connection.createStatement(1005, 1008);
            if ("no".equals(string)) {
                ArrayList<OutboundMessage> arrayList2 = arrayList;
                return arrayList2;
            }
            PreparedStatement preparedStatement = connection.prepareStatement("update " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " set status = 'Q' where id = ? ");
            String string2 = "";
            if (bl) {
                string2 = "select * from " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " where (status = 'U' or (status = 'F' and errors < " + n2 + ")) and (gateway_id = '~' or gateway_id like 'nbiot%') and rownum <= %size% order by priority desc, id";
                string2 = string2.replaceAll("%size%", "" + Integer.parseInt(this.getProperty("batch_size", "50")));
            } else if (bl2) {
                string2 = "select top %size% * from " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " where (status = 'U' or (status = 'F' and errors < " + n2 + ")) and (gateway_id = '~' or gateway_id like 'nbiot%') order by priority desc, id";
                string2 = string2.replaceAll("%size%", "" + Integer.parseInt(this.getProperty("batch_size", "50")));
            } else if (bl3) {
                string2 = "select * from " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " where (status = 'U' or (status = 'F' and errors < " + n2 + ")) and (gateway_id = '~' or gateway_id like 'nbiot%') order by priority desc, id limit %size% offset %begin%";
                string2 = string2.replaceAll("%begin%", "0");
                string2 = string2.replaceAll("%size%", "" + Integer.parseInt(this.getProperty("batch_size", "50")));
            } else {
                string2 = "select * from " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " where (status = 'U' or (status = 'F' and errors < " + n2 + ")) and (gateway_id = '~' or gateway_id like 'nbiot%') order by priority desc, id limit %begin% , %size%";
                string2 = string2.replaceAll("%begin%", "0");
                string2 = string2.replaceAll("%size%", "" + Integer.parseInt(this.getProperty("batch_size", "50")));
            }
            JDSMSServer.getInstance().userConsolePrint("x", "get send nbiot:" + string2);
            resultSet = statement.executeQuery(string2);
            if (resultSet == null) {
                Logger.getInstance().logError("\u914d\u7f6e\u6587\u4ef6\u8bbe\u5907\u6a21\u5f0f\u4e22\u5931,\u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6", null, null);
                ArrayList<OutboundMessage> arrayList3 = arrayList;
                return arrayList3;
            }
            Logger.getInstance().logDebug("sql\u67e5\u8be2=" + string2, null, null);
            PreparedStatement preparedStatement2 = connection.prepareStatement("update " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " set status = 'F',sent_date=? where id = ? ");
            while (resultSet.next() && n3 <= Integer.parseInt(this.getProperty("batch_size", "50"))) {
                Object object;
                OutboundMessage outboundMessage;
                if (!this.getServer().checkPriorityTimeFrame(resultSet.getInt("priority"))) continue;
                String string3 = resultSet.getString("recipient");
                if (StringUtils.isEmpty((CharSequence)string3) || !string3.matches("\\+?[a-zA-Z0-9]+")) {
                    Logger.getInstance().logDebug("\u6536\u4fe1\u5730\u5740" + string3 + "\u4e0d\u5408\u6cd5!", null, null);
                    preparedStatement2.setTimestamp(1, new Timestamp(System.currentTimeMillis()));
                    preparedStatement2.setLong(2, resultSet.getLong("id"));
                    preparedStatement2.addBatch();
                    continue;
                }
                if (resultSet.getTimestamp("sent_date") != null && System.currentTimeMillis() < resultSet.getTimestamp("sent_date").getTime()) continue;
                switch (resultSet.getString("type").charAt(0)) {
                    case 'O': {
                        switch (resultSet.getString("encoding").charAt(0)) {
                            case '8': {
                                outboundMessage = new OutboundMessage(resultSet.getString("recipient").trim(), resultSet.getString("text").trim());
                                outboundMessage.setEncodingForOthers(Message.MessageEncodings.ENC8BIT);
                                break;
                            }
                            case 'U': {
                                outboundMessage = new OutboundMessage(resultSet.getString("recipient").trim(), resultSet.getString("text").trim());
                                outboundMessage.setEncoding(Message.MessageEncodings.ENCUCS2);
                                break;
                            }
                            case 'S': {
                                outboundMessage = new OutboundMessage(resultSet.getString("recipient").trim(), resultSet.getString("text").trim());
                                outboundMessage.setEncoding(Message.MessageEncodings.SC);
                                break;
                            }
                            default: {
                                outboundMessage = new OutboundMessage(resultSet.getString("recipient").trim(), resultSet.getString("text").trim());
                                outboundMessage.setEncoding(Message.MessageEncodings.ENCUCS2);
                            }
                        }
                        if (resultSet.getInt("flash_sms") == 1) {
                            outboundMessage.setFlashSms(true);
                        }
                        if (resultSet.getInt("src_port") == -1) break;
                        outboundMessage.setSrcPort(resultSet.getInt("src_port"));
                        outboundMessage.setDstPort(resultSet.getInt("dst_port"));
                        break;
                    }
                    case 'W': {
                        OutboundWapSIMessage.WapSISignals wapSISignals;
                        if (resultSet.getTime("wap_expiry_date") == null) {
                            Calendar calendar = Calendar.getInstance();
                            calendar.setTime(new Date());
                            calendar.add(6, 7);
                            object = calendar.getTime();
                        } else {
                            object = resultSet.getTimestamp("wap_expiry_date");
                        }
                        if (resultSet.getString("wap_signal") == null) {
                            wapSISignals = OutboundWapSIMessage.WapSISignals.NONE;
                        } else {
                            switch (resultSet.getString("wap_signal").charAt(0)) {
                                case 'N': {
                                    wapSISignals = OutboundWapSIMessage.WapSISignals.NONE;
                                    break;
                                }
                                case 'L': {
                                    wapSISignals = OutboundWapSIMessage.WapSISignals.LOW;
                                    break;
                                }
                                case 'M': {
                                    wapSISignals = OutboundWapSIMessage.WapSISignals.MEDIUM;
                                    break;
                                }
                                case 'H': {
                                    wapSISignals = OutboundWapSIMessage.WapSISignals.HIGH;
                                    break;
                                }
                                case 'D': {
                                    wapSISignals = OutboundWapSIMessage.WapSISignals.DELETE;
                                    break;
                                }
                                default: {
                                    wapSISignals = OutboundWapSIMessage.WapSISignals.NONE;
                                }
                            }
                        }
                        outboundMessage = new OutboundWapSIMessage(resultSet.getString("recipient").trim(), new URL(resultSet.getString("wap_url").trim()), resultSet.getString("text").trim(), (Date)object, wapSISignals);
                        break;
                    }
                    default: {
                        throw new Exception("Message type '" + resultSet.getString("type") + "' is unknown!");
                    }
                }
                outboundMessage.setPriority(resultSet.getInt("priority"));
                if (resultSet.getInt("status_report") == 1) {
                    outboundMessage.setStatusReport(true);
                }
                if (resultSet.getString("originator") != null && resultSet.getString("originator").length() > 0) {
                    outboundMessage.setFrom(resultSet.getString("originator").trim());
                }
                object = resultSet.getString("gateway_id").trim();
                int n4 = resultSet.getInt("id");
                preparedStatement.setInt(1, n4);
                outboundMessage.setGatewayId((String)object);
                int n5 = resultSet.getInt("id") + 100;
                if (n5 > Integer.MAX_VALUE) {
                    Logger.getInstance().logError("\u5df2\u7ecf\u5230\u8fc7\u6570\u636e\u5e93\u6700\u5927\u5bb9\u91cf\uff0c\u8bf7\u66f4\u6362\u6570\u636e\u5e93\uff01", null, null);
                    continue;
                }
                outboundMessage.setMessageID(n5);
                JDSMSServer.getInstance().userConsolePrint("x", "~check message: gateid=" + outboundMessage.getGatewayId() + " msgid=" + resultSet.getInt("id"));
                arrayList.add(outboundMessage);
                this.getMessageCache().put(outboundMessage.getMessageId(), resultSet.getInt("id"));
                preparedStatement.addBatch();
                ++n3;
            }
            preparedStatement2.executeBatch();
            preparedStatement.executeBatch();
            resultSet.close();
            statement.close();
            preparedStatement.close();
            preparedStatement2.close();
        }
        catch (Exception exception) {
            try {
                if (connection != null) {
                    connection.close();
                }
                this._$1(connection);
            }
            catch (Exception exception2) {
                // empty catch block
            }
            Logger.getInstance().logError(String.format("SQL failure, will retry in %d seconds...", this._$8 * 1), exception, null);
            Thread.sleep(this._$8 * 1000);
            this._$8 *= 2;
            if (this._$8 == 64) {
                this._$8 = 1;
            }
        }
        finally {
            SysLock.getInstance().setbusy(false);
            this._$1(connection);
        }
        SysLock.getInstance().setbusy(false);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<? extends OutboundMessage> getMessagesToSendBigDipper() throws Exception {
        int n = 0;
        while (!SysLock.getInstance().canUse()) {
            try {
                Thread.sleep(50L);
                if (n++ <= 50) continue;
                Logger.getInstance().logError("\u81ea\u65cb\u7b49\u5f85\u8d85\u8fc72\u79d2", null, null);
            }
            catch (InterruptedException interruptedException) {
                Logger.getInstance().logError("\u53d6\u5f85\u53d1\u77ed\u4fe1\u65f6\u4ea7\u751f\u4e2d\u65ad\u5f02\u5e38", interruptedException, null);
            }
        }
        Connection connection = null;
        ArrayList<OutboundMessage> arrayList = new ArrayList<OutboundMessage>();
        boolean bl = false;
        if (JDSMSServer.getInstance().getProperties().getString("db1.type", "mysql").equals("oracle") || JDSMSServer.getInstance().getProperties().getString("db1.type", "mysql").equals("oracle-rac")) {
            bl = true;
        }
        boolean bl2 = false;
        if (JDSMSServer.getInstance().getProperties().getString("db1.type", "mysql").equals("mssql")) {
            bl2 = true;
        }
        boolean bl3 = false;
        if (JDSMSServer.getInstance().getProperties().getString("db1.type", "mysql").equals("postgresql")) {
            bl3 = true;
        }
        String string = JDSMSServer.getInstance().getProperties().getString("settings.bd_using", "no");
        int n2 = Integer.parseInt(this.getProperty("retries", "2"));
        try {
            ResultSet resultSet = null;
            int n3 = 1;
            connection = this._$3();
            Statement statement = connection.createStatement(1005, 1008);
            if ("no".equals(string)) {
                ArrayList<OutboundMessage> arrayList2 = arrayList;
                return arrayList2;
            }
            PreparedStatement preparedStatement = connection.prepareStatement("update " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " set status = 'Q' where id = ? ");
            String string2 = "";
            if (bl) {
                string2 = "select * from " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " where (status = 'U' or (status = 'F' and errors < " + n2 + ")) and (gateway_id = '-' or gateway_id like 'BD%') and rownum <= %size% order by priority desc, id";
                string2 = string2.replaceAll("%size%", "" + Integer.parseInt(this.getProperty("batch_size", "50")));
            } else if (bl2) {
                string2 = "select top %size% * from " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " where (status = 'U' or (status = 'F' and errors < " + n2 + ")) and (gateway_id = '-' or gateway_id like 'BD%') order by priority desc, id";
                string2 = string2.replaceAll("%size%", "" + Integer.parseInt(this.getProperty("batch_size", "50")));
            } else if (bl3) {
                string2 = "select * from " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " where (status = 'U' or (status = 'F' and errors < " + n2 + ")) and (gateway_id = '-' or gateway_id like 'BD%') order by priority desc, id limit %size% offset %begin%";
                string2 = string2.replaceAll("%begin%", "0");
                string2 = string2.replaceAll("%size%", "" + Integer.parseInt(this.getProperty("batch_size", "50")));
            } else {
                string2 = "select * from " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " where (status = 'U' or (status = 'F' and errors < " + n2 + ")) and (gateway_id = '-' or gateway_id like 'BD%') order by priority desc, id limit %begin% , %size%";
                string2 = string2.replaceAll("%begin%", "0");
                string2 = string2.replaceAll("%size%", "" + Integer.parseInt(this.getProperty("batch_size", "50")));
            }
            JDSMSServer.getInstance().userConsolePrint("x", "get send BD:" + string2);
            resultSet = statement.executeQuery(string2);
            if (resultSet == null) {
                Logger.getInstance().logError("\u914d\u7f6e\u6587\u4ef6\u8bbe\u5907\u6a21\u5f0f\u4e22\u5931,\u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6", null, null);
                ArrayList<OutboundMessage> arrayList3 = arrayList;
                return arrayList3;
            }
            Logger.getInstance().logDebug("sql\u67e5\u8be2=" + string2, null, null);
            PreparedStatement preparedStatement2 = connection.prepareStatement("update " + this.getProperty("tables.sms_out", "jdsmsserver_out") + " set status = 'F',sent_date=? where id = ? ");
            while (resultSet.next() && n3 <= Integer.parseInt(this.getProperty("batch_size", "50"))) {
                Object object;
                OutboundMessage outboundMessage;
                if (!this.getServer().checkPriorityTimeFrame(resultSet.getInt("priority"))) continue;
                String string3 = resultSet.getString("recipient");
                if (StringUtils.isEmpty((CharSequence)string3) || !string3.matches("[A-F,a-f,0-9]+")) {
                    Logger.getInstance().logDebug("\u6536\u4fe1\u5730\u5740" + string3 + "\u4e0d\u5408\u6cd5!", null, null);
                    preparedStatement2.setTimestamp(1, new Timestamp(System.currentTimeMillis()));
                    preparedStatement2.setLong(2, resultSet.getLong("id"));
                    preparedStatement2.addBatch();
                    continue;
                }
                if (resultSet.getTimestamp("sent_date") != null && System.currentTimeMillis() < resultSet.getTimestamp("sent_date").getTime()) continue;
                switch (resultSet.getString("type").charAt(0)) {
                    case 'O': {
                        switch (resultSet.getString("encoding").charAt(0)) {
                            case '7': {
                                outboundMessage = new OutboundMessage(resultSet.getString("recipient").trim(), resultSet.getString("text").trim());
                                outboundMessage.setEncoding(Message.MessageEncodings.ENC7BIT);
                                break;
                            }
                            case '8': {
                                outboundMessage = new OutboundMessage(resultSet.getString("recipient").trim(), resultSet.getString("text").trim());
                                outboundMessage.setEncodingForOthers(Message.MessageEncodings.ENC8BIT);
                                break;
                            }
                            case 'U': {
                                outboundMessage = new OutboundMessage(resultSet.getString("recipient").trim(), resultSet.getString("text").trim());
                                outboundMessage.setEncoding(Message.MessageEncodings.ENCUCS2);
                                break;
                            }
                            case 'S': {
                                outboundMessage = new OutboundMessage(resultSet.getString("recipient").trim(), resultSet.getString("text").trim());
                                outboundMessage.setEncoding(Message.MessageEncodings.SC);
                                break;
                            }
                            default: {
                                outboundMessage = new OutboundMessage(resultSet.getString("recipient").trim(), resultSet.getString("text").trim());
                                outboundMessage.setEncoding(Message.MessageEncodings.ENCUCS2);
                            }
                        }
                        if (resultSet.getInt("flash_sms") == 1) {
                            outboundMessage.setFlashSms(true);
                        }
                        if (resultSet.getInt("src_port") == -1) break;
                        outboundMessage.setSrcPort(resultSet.getInt("src_port"));
                        outboundMessage.setDstPort(resultSet.getInt("dst_port"));
                        break;
                    }
                    case 'W': {
                        OutboundWapSIMessage.WapSISignals wapSISignals;
                        if (resultSet.getTime("wap_expiry_date") == null) {
                            Calendar calendar = Calendar.getInstance();
                            calendar.setTime(new Date());
                            calendar.add(6, 7);
                            object = calendar.getTime();
                        } else {
                            object = resultSet.getTimestamp("wap_expiry_date");
                        }
                        if (resultSet.getString("wap_signal") == null) {
                            wapSISignals = OutboundWapSIMessage.WapSISignals.NONE;
                        } else {
                            switch (resultSet.getString("wap_signal").charAt(0)) {
                                case 'N': {
                                    wapSISignals = OutboundWapSIMessage.WapSISignals.NONE;
                                    break;
                                }
                                case 'L': {
                                    wapSISignals = OutboundWapSIMessage.WapSISignals.LOW;
                                    break;
                                }
                                case 'M': {
                                    wapSISignals = OutboundWapSIMessage.WapSISignals.MEDIUM;
                                    break;
                                }
                                case 'H': {
                                    wapSISignals = OutboundWapSIMessage.WapSISignals.HIGH;
                                    break;
                                }
                                case 'D': {
                                    wapSISignals = OutboundWapSIMessage.WapSISignals.DELETE;
                                    break;
                                }
                                default: {
                                    wapSISignals = OutboundWapSIMessage.WapSISignals.NONE;
                                }
                            }
                        }
                        outboundMessage = new OutboundWapSIMessage(resultSet.getString("recipient").trim(), new URL(resultSet.getString("wap_url").trim()), resultSet.getString("text").trim(), (Date)object, wapSISignals);
                        break;
                    }
                    default: {
                        throw new Exception("Message type '" + resultSet.getString("type") + "' is unknown!");
                    }
                }
                outboundMessage.setPriority(resultSet.getInt("priority"));
                if (resultSet.getInt("status_report") == 1) {
                    outboundMessage.setStatusReport(true);
                }
                if (resultSet.getString("originator") != null && resultSet.getString("originator").length() > 0) {
                    outboundMessage.setFrom(resultSet.getString("originator").trim());
                }
                object = resultSet.getString("gateway_id").trim();
                int n4 = resultSet.getInt("id");
                preparedStatement.setInt(1, n4);
                outboundMessage.setGatewayId((String)object);
                int n5 = resultSet.getInt("id") + 100;
                if (n5 > Integer.MAX_VALUE) {
                    Logger.getInstance().logError("\u5df2\u7ecf\u5230\u8fc7\u6570\u636e\u5e93\u6700\u5927\u5bb9\u91cf\uff0c\u8bf7\u66f4\u6362\u6570\u636e\u5e93\uff01", null, null);
                    continue;
                }
                outboundMessage.setMessageID(n5);
                JDSMSServer.getInstance().userConsolePrint("x", "-check message: gateid=" + outboundMessage.getGatewayId() + " msgid=" + resultSet.getInt("id"));
                arrayList.add(outboundMessage);
                this.getMessageCache().put(outboundMessage.getMessageId(), resultSet.getInt("id"));
                preparedStatement.addBatch();
                ++n3;
            }
            preparedStatement2.executeBatch();
            preparedStatement.executeBatch();
            resultSet.close();
            statement.close();
            preparedStatement.close();
            preparedStatement2.close();
        }
        catch (Exception exception) {
            try {
                if (connection != null) {
                    connection.close();
                }
                this._$1(connection);
            }
            catch (Exception exception2) {
                // empty catch block
            }
            Logger.getInstance().logError(String.format("SQL failure, will retry in %d seconds...", this._$8 * 1), exception, null);
            Thread.sleep(this._$8 * 1000);
            this._$8 *= 2;
            if (this._$8 == 64) {
                this._$8 = 1;
            }
        }
        finally {
            SysLock.getInstance().setbusy(false);
            this._$1(connection);
        }
        SysLock.getInstance().setbusy(false);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void BDMessagesReceived(Collection<InboundMessage> collection) throws Exception {
        int n = 0;
        PropertiesConfiguration propertiesConfiguration = JDSMSServer.getInstance().getProperties();
        while (!SysLock.getInstance().canUse()) {
            try {
                Thread.sleep(50L);
                if (n++ <= 50) continue;
                Logger.getInstance().logError("\u81ea\u65cb\u7b49\u5f85\u8d85\u8fc72\u79d2", null, null);
            }
            catch (InterruptedException interruptedException) {
                Logger.getInstance().logError("\u53d6\u5f85\u53d1\u77ed\u4fe1\u65f6\u4ea7\u751f\u4e2d\u65ad\u5f02\u5e38", interruptedException, null);
            }
        }
        System.out.println("Database BigDipperMessagesReceiving...");
        Connection connection = null;
        int n2 = propertiesConfiguration.getInt("settings.resend_times", 0);
        try {
            connection = this._$3();
            PreparedStatement preparedStatement = connection.prepareStatement(" insert into " + this.getProperty("tables.sms_in", "jdsmsserver_in") + " (process, originator, type, encoding, message_date, receive_date, text," + " original_ref_no, original_receive_date, gateway_id) " + " values(?,?,?,?,?,?,?,?,?,?)");
            for (InboundMessage inboundMessage : collection) {
                if (inboundMessage.getEncoding() != Message.MessageEncodings.SC && n2 > 0) {
                    if (inboundMessage.isError()) {
                        Logger.getInstance().logInfo("\u4fe1\u606f\u3010" + inboundMessage.getText() + "\u3011\u4e0d\u5b8c\u6574\uff0c\u4e0d\u5165\u5e93\u3002", null, null);
                        continue;
                    }
                    if (this._$1(connection, inboundMessage)) {
                        Logger.getInstance().logInfo("\u4fe1\u606f\u3010" + inboundMessage.getText() + "\u3011\u91cd\u590d\u4e86\uff01 key: " + inboundMessage.getMessageID() + "-" + inboundMessage.getOriginator(), null, null);
                        continue;
                    }
                }
                if (inboundMessage.getType() != Message.MessageTypes.INBOUND) continue;
                if (Utils.isEmptyStr(inboundMessage.getMessageID())) {
                    preparedStatement.setInt(1, 0);
                } else {
                    preparedStatement.setInt(1, Integer.valueOf(inboundMessage.getMessageID(), 16));
                }
                switch (inboundMessage.getEncoding()) {
                    case ENC7BIT: {
                        preparedStatement.setString(4, "7");
                        break;
                    }
                    case ENC8BIT: {
                        preparedStatement.setString(4, "8");
                        break;
                    }
                    case ENCUCS2: {
                        preparedStatement.setString(4, "U");
                        break;
                    }
                    case SC: {
                        preparedStatement.setString(4, "S");
                        break;
                    }
                    case ENCCUSTOM: {
                        preparedStatement.setString(4, "C");
                    }
                }
                switch (inboundMessage.getType()) {
                    case INBOUND: {
                        preparedStatement.setString(3, "I");
                        preparedStatement.setString(2, inboundMessage.getOriginator());
                        preparedStatement.setTimestamp(5, new Timestamp(inboundMessage.getDate().getTime()));
                        preparedStatement.setString(8, null);
                        preparedStatement.setTimestamp(9, null);
                        break;
                    }
                }
                preparedStatement.setTimestamp(6, new Timestamp(new Date().getTime()));
                preparedStatement.setString(7, inboundMessage.getText().length() == 0 ? "" : inboundMessage.getText());
                String string = inboundMessage.getGatewayId();
                if (string == null || string.equals("")) {
                    string = "-";
                }
                preparedStatement.setString(10, string);
                preparedStatement.addBatch();
            }
            Iterator<InboundMessage> iterator = null;
            preparedStatement.executeBatch();
            preparedStatement.close();
        }
        catch (Exception exception) {
            try {
                if (connection != null) {
                    connection.close();
                }
                this._$1(connection);
            }
            catch (Exception exception2) {
                // empty catch block
            }
            Logger.getInstance().logError(String.format("SQL failure, will retry in %d seconds...", this._$8 * 1), exception, null);
            Thread.sleep(this._$8 * 1000);
            this._$8 *= 2;
            if (this._$8 == 64) {
                this._$8 = 1;
            }
        }
        finally {
            SysLock.getInstance().setbusy(false);
            this._$1(connection);
        }
        SysLock.getInstance().setbusy(false);
    }

    private String _$1() {
        String string = "*";
        int n = Integer.parseInt(JDSMSServer.getInstance().getProperties().getString("settings.using_sorted", "0"));
        String string2 = JDSMSServer.getInstance().getProperties().getString("settings.device_using", "yes");
        String string3 = JDSMSServer.getInstance().getProperties().getString("settings.phone_using", "yes");
        String string4 = JDSMSServer.getInstance().getProperties().getString("settings.gateway_using", "yes");
        switch (n) {
            case 0: {
                if (string2.equals("yes")) {
                    string = "*";
                    break;
                }
                if (string4.equals("yes")) {
                    string = "#";
                    break;
                }
                if (!string3.equals("yes")) break;
                string = "$";
                break;
            }
            case 1: {
                if (string2.equals("yes")) {
                    string = "*";
                    break;
                }
                if (string3.equals("yes")) {
                    string = "$";
                    break;
                }
                if (!string4.equals("yes")) break;
                string = "#";
                break;
            }
            case 2: {
                if (string4.equals("yes")) {
                    string = "#";
                    break;
                }
                if (string2.equals("yes")) {
                    string = "*";
                    break;
                }
                if (!string3.equals("yes")) break;
                string = "$";
                break;
            }
            case 3: {
                if (string4.equals("yes")) {
                    string = "#";
                    break;
                }
                if (string3.equals("yes")) {
                    string = "$";
                    break;
                }
                if (!string2.equals("yes")) break;
                string = "*";
                break;
            }
            case 4: {
                if (string3.equals("yes")) {
                    string = "$";
                    break;
                }
                if (string2.equals("yes")) {
                    string = "*";
                    break;
                }
                if (!string4.equals("yes")) break;
                string = "#";
                break;
            }
            case 5: {
                if (string3.equals("yes")) {
                    string = "$";
                    break;
                }
                if (string4.equals("yes")) {
                    string = "#";
                    break;
                }
                if (!string2.equals("yes")) break;
                string = "*";
                break;
            }
        }
        return string;
    }
}

